/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.variables;

import com.intellij.debugger.engine.DebuggerUtils;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.JdiTypeUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverterKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ\u001a\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0017\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "typeMatches", "", "requestedType", "Lorg/jetbrains/org/objectweb/asm/Type;", "actualTypeObj", "Lcom/sun/jdi/Type;", "coerce", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "value", "Lcom/sun/jdi/Value;", "type", "coerceRef", "coerceBoxing", "box", "unbox", "ref", "Companion", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nEvaluatorValueConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluatorValueConverter.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1#2:271\n626#3,12:272\n*S KotlinDebug\n*F\n+ 1 EvaluatorValueConverter.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter\n*L\n180#1:272,12\n*E\n"})
public final class EvaluatorValueConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private static final Map<String, String> UNBOXING_METHOD_NAMES;

    public EvaluatorValueConverter(@NotNull ExecutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final ExecutionContext getContext() {
        return this.context;
    }

    public final boolean typeMatches(@NotNull Type requestedType, @Nullable com.sun.jdi.Type actualTypeObj) {
        Intrinsics.checkNotNullParameter((Object)requestedType, (String)"requestedType");
        if (actualTypeObj == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)requestedType.getDescriptor(), (Object)"Ljava/lang/Object;") || JdiTypeUtils.isSubtype(actualTypeObj, requestedType)) {
            return true;
        }
        Type actualType = EvaluatorValueConverterKt.access$asmType(actualTypeObj);
        if (EvaluatorValueConverter.typeMatches$isRefWrapper(actualType, requestedType) || EvaluatorValueConverter.typeMatches$isRefWrapper(requestedType, actualType)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)requestedType.getInternalName(), (Object)"kotlin/reflect/KClass") && Intrinsics.areEqual((Object)actualType.getInternalName(), (Object)"java/lang/Class")) {
            return true;
        }
        Type unwrappedActualType = EvaluatorValueConverterKt.access$unwrap(actualType);
        Type unwrappedRequestedType = EvaluatorValueConverterKt.access$unwrap(requestedType);
        return Intrinsics.areEqual((Object)unwrappedActualType, (Object)unwrappedRequestedType);
    }

    @Nullable
    public final VariableFinder.Result coerce(@Nullable Value value, @NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        VariableFinder.Result unrefResult = this.coerceRef(value, type2);
        return this.coerceBoxing(unrefResult.getValue(), type2);
    }

    private final VariableFinder.Result coerceRef(Value value, Type type2) {
        if (EvaluatorValueConverterKt.isRefType(type2)) {
            if (value != null && EvaluatorValueConverterKt.isRefType(EvaluatorValueConverterKt.access$asmType(value))) {
                return new VariableFinder.Result(value);
            }
            return new VariableFinder.Result(this.ref(value));
        }
        if (value != null && EvaluatorValueConverterKt.isRefType(EvaluatorValueConverterKt.access$asmType(value))) {
            if (EvaluatorValueConverterKt.isRefType(type2)) {
                return new VariableFinder.Result(value);
            }
            return new VariableFinder.Result(Companion.unref(value));
        }
        return new VariableFinder.Result(value);
    }

    private final VariableFinder.Result coerceBoxing(Value value, Type type2) {
        if (value == null) {
            return new VariableFinder.Result(null);
        }
        if (Intrinsics.areEqual((Object)type2, (Object)Type.VOID_TYPE)) {
            return new VariableFinder.Result(this.context.getVm().mirrorOfVoid());
        }
        if (EvaluatorValueConverterKt.access$isBoxedType(type2)) {
            if (EvaluatorValueConverterKt.access$isBoxedType(EvaluatorValueConverterKt.access$asmType(value))) {
                return new VariableFinder.Result(value);
            }
            if (!(value instanceof PrimitiveValue)) {
                return null;
            }
            return new VariableFinder.Result(this.box(value));
        }
        if (EvaluatorValueConverterKt.access$isPrimitiveType(type2)) {
            if (value instanceof PrimitiveValue) {
                return new VariableFinder.Result(value);
            }
            if (!(value instanceof ObjectReference) || !EvaluatorValueConverterKt.access$isBoxedType(EvaluatorValueConverterKt.access$asmType(value))) {
                return null;
            }
            return new VariableFinder.Result(this.unbox(value));
        }
        if (value instanceof PrimitiveValue) {
            Value boxedValue;
            if (type2.getSort() != 10) {
                return null;
            }
            Value value2 = boxedValue = this.box(value);
            if (!this.typeMatches(type2, value2 != null ? value2.type() : null)) {
                return null;
            }
            return new VariableFinder.Result(boxedValue);
        }
        return new VariableFinder.Result(value);
    }

    private final Value box(Value value) {
        if (!(value instanceof PrimitiveValue)) {
            return value;
        }
        Type unboxedType = EvaluatorValueConverterKt.access$asmType(value);
        Type boxedType = EvaluatorValueConverterKt.box(unboxedType);
        ClassType classType = (ClassType)BaseExecutionContext.findClass$default((BaseExecutionContext)this.context, boxedType, null, 2, null);
        if (classType == null) {
            throw new IllegalStateException(("Class " + boxedType + " is not loaded").toString());
        }
        ClassType boxedTypeClass = classType;
        Type[] typeArray = new Type[]{unboxedType};
        String methodDesc = Type.getMethodDescriptor((Type)boxedType, (Type[])typeArray);
        Method valueOfMethod = JdiTypeUtils.findMethod(boxedTypeClass, "valueOf", methodDesc);
        return BaseExecutionContext.invokeMethod$default(this.context, boxedTypeClass, valueOfMethod, CollectionsKt.listOf((Object)value), false, 8, null);
    }

    private final Value unbox(Value value) {
        Type type2;
        if (!(value instanceof ObjectReference)) {
            return value;
        }
        ReferenceType referenceType = ((ObjectReference)value).referenceType();
        ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        if (classType == null) {
            return value;
        }
        ClassType boxedTypeClass = classType;
        Type it = type2 = EvaluatorValueConverterKt.access$asmType(boxedTypeClass);
        boolean bl = false;
        Object object = EvaluatorValueConverterKt.access$isBoxedType(it) ? type2 : null;
        if (object == null) {
            return value;
        }
        Type boxedType = object;
        Type unboxedType = EvaluatorValueConverterKt.access$unbox(boxedType);
        String unboxingMethodName = (String)MapsKt.getValue(UNBOXING_METHOD_NAMES, (Object)boxedType.getInternalName());
        String methodDesc = Type.getMethodDescriptor((Type)unboxedType, (Type[])new Type[0]);
        Method valueMethod = JdiTypeUtils.findMethod(boxedTypeClass, unboxingMethodName, methodDesc);
        return BaseExecutionContext.invokeMethod$default(this.context, (ObjectReference)value, valueMethod, CollectionsKt.emptyList(), 0, false, 24, null);
    }

    private final Value ref(Value value) {
        if (value instanceof VoidValue) {
            return value;
        }
        if (value instanceof PrimitiveValue) {
            Type primitiveType = EvaluatorValueConverterKt.access$asmType(value);
            Type refType = (Type)MapsKt.getValue((Map)EvaluatorValueConverterKt.access$getPRIMITIVE_TO_REF$p(), (Object)primitiveType);
            ClassType classType = (ClassType)BaseExecutionContext.findClass$default((BaseExecutionContext)this.context, refType, null, 2, null);
            if (classType == null) {
                throw new IllegalStateException(("Class " + refType + " is not loaded").toString());
            }
            ClassType refTypeClass = classType;
            return EvaluatorValueConverter.ref$wrapRef(this, value, refTypeClass);
        }
        Type refType = Type.getType(Ref.ObjectRef.class);
        BaseExecutionContext baseExecutionContext = this.context;
        Intrinsics.checkNotNull((Object)refType);
        ClassType classType = (ClassType)BaseExecutionContext.findClass$default(baseExecutionContext, refType, null, 2, null);
        if (classType == null) {
            throw new IllegalStateException(("Class " + refType + " is not loaded").toString());
        }
        ClassType refTypeClass = classType;
        return EvaluatorValueConverter.ref$wrapRef(this, value, refTypeClass);
    }

    private static final boolean typeMatches$isRefWrapper(Type wrapperType, Type objType) {
        return !EvaluatorValueConverterKt.access$isPrimitiveType(objType) && Intrinsics.areEqual((Object)wrapperType.getClassName(), (Object)Ref.ObjectRef.class.getName());
    }

    private static final Value ref$wrapRef(EvaluatorValueConverter this$0, Value value, ClassType refTypeClass) {
        List<Method> list2 = refTypeClass.methods();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"methods(...)");
        Iterable $this$single$iv = list2;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            Method it = (Method)element$iv;
            boolean bl = false;
            if (!it.isConstructor()) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Method constructor = single$iv;
        ExecutionContext executionContext = this$0.context;
        Intrinsics.checkNotNull((Object)constructor);
        ObjectReference ref = executionContext.newInstance(refTypeClass, constructor, CollectionsKt.emptyList());
        this$0.context.keepReference(ref);
        Field field2 = DebuggerUtils.findField((ReferenceType)refTypeClass, (String)"element");
        if (field2 == null) {
            throw new IllegalStateException("'element' field not found".toString());
        }
        Field elementField = field2;
        ref.setValue(elementField, value);
        return ref;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"java/lang/Boolean", (Object)"booleanValue"), TuplesKt.to((Object)"java/lang/Character", (Object)"charValue"), TuplesKt.to((Object)"java/lang/Byte", (Object)"byteValue"), TuplesKt.to((Object)"java/lang/Short", (Object)"shortValue"), TuplesKt.to((Object)"java/lang/Integer", (Object)"intValue"), TuplesKt.to((Object)"java/lang/Float", (Object)"floatValue"), TuplesKt.to((Object)"java/lang/Long", (Object)"longValue"), TuplesKt.to((Object)"java/lang/Double", (Object)"doubleValue")};
        UNBOXING_METHOD_NAMES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter$Companion;", "", "<init>", "()V", "UNBOXING_METHOD_NAMES", "", "", "getUNBOXING_METHOD_NAMES", "()Ljava/util/Map;", "unref", "Lcom/sun/jdi/Value;", "value", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getUNBOXING_METHOD_NAMES() {
            return UNBOXING_METHOD_NAMES;
        }

        @Nullable
        public final Value unref(@Nullable Value value) {
            com.sun.jdi.Type type2;
            block6: {
                block5: {
                    if (!(value instanceof ObjectReference) || value instanceof StringReference) {
                        return value;
                    }
                    type2 = ((ObjectReference)value).type();
                    if (!(type2 instanceof ClassType)) break block5;
                    String string = ((ClassType)type2).signature();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"Lkotlin/jvm/internal/Ref$", (boolean)false, (int)2, null)) break block6;
                }
                return value;
            }
            Field field2 = DebuggerUtils.findField((ReferenceType)((ReferenceType)type2), (String)"element");
            if (field2 == null) {
                return value;
            }
            Field field3 = field2;
            return ((ObjectReference)value).getValue(field3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

