/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\bH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6CollectConstructorsWhichNeedBoxParameters;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "containsCapturedValues", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "markAsNeedsBoxParameter", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6ConstructorBoxParameterOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6ConstructorBoxParameterOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6CollectConstructorsWhichNeedBoxParameters\n+ 2 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n32#2,2:231\n9#2,6:233\n1869#3,2:239\n*S KotlinDebug\n*F\n+ 1 ES6ConstructorBoxParameterOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6CollectConstructorsWhichNeedBoxParameters\n*L\n203#1:231,2\n203#1:233,6\n204#1:239,2\n*E\n"})
public final class ES6CollectConstructorsWhichNeedBoxParameters
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public ES6CollectConstructorsWhichNeedBoxParameters(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        boolean hasSuperClass;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!this.context.getEs6mode() || !(declaration instanceof IrClass)) {
            return null;
        }
        boolean bl = hasSuperClass = IrUtilsKt.getSuperClass((IrClass)declaration) != null;
        if (hasSuperClass && ((IrClass)declaration).isInner()) {
            this.markAsNeedsBoxParameter((IrClass)declaration);
        } else if (hasSuperClass && AdditionalIrUtilsKt.isOriginallyLocal(declaration) && this.containsCapturedValues((IrClass)declaration)) {
            this.markAsNeedsBoxParameter((IrClass)declaration);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsCapturedValues(IrClass $this$containsCapturedValues) {
        List list;
        if (IrUtilsKt.getSuperClass($this$containsCapturedValues) == null) {
            return false;
        }
        Collection $this$filterIsInstanceAnd$iv = $this$containsCapturedValues.getDeclarations();
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceAndTo$iv$iv;
            Iterable iterable = $this$filterIsInstanceAnd$iv;
            Collection destination$iv$iv = new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrFunction)) continue;
                IrFunction it = (IrFunction)element$iv$iv;
                boolean bl = false;
                if (!ES6ConstructorLoweringKt.isEs6ConstructorReplacement(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFunction it = (IrFunction)element$iv;
            boolean bl = false;
            Ref.BooleanRef meetCapturing = new Ref.BooleanRef();
            IrValueParameter boxParameter = ES6AddBoxParameterLoweringKt.getBoxParameter(it);
            IrBody irBody = it.getBody();
            if (irBody != null) {
                IrVisitorsKt.acceptChildrenVoid((IrElement)irBody, new IrVisitorVoid(boxParameter, meetCapturing){
                    final /* synthetic */ IrValueParameter $boxParameter;
                    final /* synthetic */ Ref.BooleanRef $meetCapturing;
                    {
                        this.$boxParameter = $boxParameter;
                        this.$meetCapturing = $meetCapturing;
                    }

                    public void visitSetField(IrSetField expression2) {
                        IrGetValue receiver;
                        Intrinsics.checkNotNullParameter(expression2, "expression");
                        IrExpression irExpression = expression2.getReceiver();
                        IrGetValue irGetValue = receiver = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
                        if (receiver != null) {
                            IrValueParameter irValueParameter = this.$boxParameter;
                            if (Intrinsics.areEqual(receiver.getSymbol(), irValueParameter != null ? irValueParameter.getSymbol() : null)) {
                                this.$meetCapturing.element = true;
                            }
                        }
                        super.visitSetField(expression2);
                    }
                });
            }
            if (!meetCapturing.element) continue;
            return true;
        }
        return false;
    }

    private final void markAsNeedsBoxParameter(IrClass $this$markAsNeedsBoxParameter) {
        block1: {
            if ($this$markAsNeedsBoxParameter.isExternal()) {
                return;
            }
            JsIrAttributesKt.setNeedsBoxParameter($this$markAsNeedsBoxParameter, true);
            IrClass irClass = IrUtilsKt.getSuperClass($this$markAsNeedsBoxParameter);
            if (irClass == null) break block1;
            this.markAsNeedsBoxParameter(irClass);
        }
    }
}

