/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.gpath;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyTokenSets;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyMapPutCanBeKeyedAccessInspection
extends BaseInspection {
    private final ReplaceWithPropertyAccessFix fix = new ReplaceWithPropertyAccessFix();

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.call.to.ref.can.be.keyed.access", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    public LocalQuickFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyMapPutCanBeKeyedAccessInspection.$$$reportNull$$$0(0);
        }
        return this.fix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/gpath/GroovyMapPutCanBeKeyedAccessInspection", "buildFix"));
    }

    private static class ReplaceWithPropertyAccessFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithPropertyAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyBundle.message("intention.family.name.replace.with.keyed.access", new Object[0]);
            if (string == null) {
                ReplaceWithPropertyAccessFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement referenceName, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceWithPropertyAccessFix.$$$reportNull$$$0(1);
            }
            if (referenceName == null) {
                ReplaceWithPropertyAccessFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithPropertyAccessFix.$$$reportNull$$$0(3);
            }
            GrReferenceExpression invokedExpression = (GrReferenceExpression)referenceName.getParent();
            GrMethodCallExpression callExpression = (GrMethodCallExpression)invokedExpression.getParent();
            GrArgumentList argumentList = callExpression.getArgumentList();
            GrExpression[] args = argumentList.getExpressionArguments();
            GrInspectionUtil.replaceExpression(callExpression, invokedExpression.getQualifierExpression().getText() + "[" + args[0].getText() + "]=" + args[1].getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/gpath/GroovyMapPutCanBeKeyedAccessInspection$ReplaceWithPropertyAccessFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/gpath/GroovyMapPutCanBeKeyedAccessInspection$ReplaceWithPropertyAccessFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression grMethodCallExpression) {
            if (grMethodCallExpression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(grMethodCallExpression);
            GrArgumentList args = grMethodCallExpression.getArgumentList();
            if (args.getExpressionArguments().length != 2) {
                return;
            }
            if (PsiImplUtil.hasNamedArguments(args)) {
                return;
            }
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression referenceExpression = (GrReferenceExpression)methodExpression;
            String name = referenceExpression.getReferenceName();
            if (!"put".equals(name)) {
                return;
            }
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null || PsiUtil.isThisOrSuperRef(qualifier)) {
                return;
            }
            if (GroovyTokenSets.SAFE_DOTS.contains(referenceExpression.getDotTokenType())) {
                return;
            }
            PsiType type = qualifier.getType();
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethodCallExpression", "org/jetbrains/plugins/groovy/codeInspection/gpath/GroovyMapPutCanBeKeyedAccessInspection$Visitor", "visitMethodCallExpression"));
        }
    }
}

