/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell.utils;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.langs.LanguageWithVariant;
import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.spell.dictionary.rule.ReplacingRuleDictionary;
import ai.grazie.spell.lists.hunspell.HunspellWordList;
import ai.grazie.spell.utils.UtilsKt;
import ai.grazie.utils.mpp.DataLoader;
import ai.grazie.utils.mpp.Resources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\rJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0006\u001a\u00020\u000fJ\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0087@\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\n\u00a8\u0006\u001b"}, d2={"Lai/grazie/spell/utils/DictionaryResources;", "", "<init>", "()V", "getHunspellDict", "Lai/grazie/spell/lists/hunspell/HunspellWordList;", "language", "Lai/grazie/nlp/langs/LanguageWithVariant;", "loadSwissGerman", "transformSwissGermanDic", "", "dicText", "transformSwissGermanTrigrams", "", "trigrams", "Lai/grazie/nlp/langs/Language;", "dict", "getTrigrams", "", "getReplacingRules", "Lai/grazie/spell/dictionary/RuleDictionary;", "name", "loader", "Lai/grazie/utils/mpp/DataLoader;", "(Ljava/lang/String;Lai/grazie/utils/mpp/DataLoader;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseReplacingRules", "datRules", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nDictionaryResources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DictionaryResources.kt\nai/grazie/spell/utils/DictionaryResources\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1368#2:87\n1454#2,2:88\n1557#2:90\n1628#2,3:91\n1456#2,3:94\n774#2:97\n865#2,2:98\n*S KotlinDebug\n*F\n+ 1 DictionaryResources.kt\nai/grazie/spell/utils/DictionaryResources\n*L\n41#1:87\n41#1:88,2\n43#1:90\n43#1:91,3\n41#1:94,3\n78#1:97\n78#1:98,2\n*E\n"})
public final class DictionaryResources {
    @NotNull
    public static final DictionaryResources INSTANCE = new DictionaryResources();

    private DictionaryResources() {
    }

    @JvmStatic
    @NotNull
    public static final HunspellWordList getHunspellDict(@NotNull LanguageWithVariant language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (language.getBase() == Language.GERMAN) {
            String string = language.getVariant();
            if (string == null) {
                string = "";
            }
            if (StringsKt.startsWith$default((String)string, (String)"CH", (boolean)false, (int)2, null)) {
                return INSTANCE.loadSwissGerman();
            }
        }
        return INSTANCE.getHunspellDict(language.getBase());
    }

    private final HunspellWordList loadSwissGerman() {
        String path = "/dictionary/de";
        String aff = Resources.INSTANCE.text(path + ".aff");
        String dicText = this.transformSwissGermanDic(Resources.INSTANCE.text(path + ".dic"));
        List<String> trigrams = this.transformSwissGermanTrigrams(StringsKt.lines((CharSequence)Resources.INSTANCE.text(path + ".trigrams.txt")));
        return HunspellWordList.Companion.create(aff, dicText, trigrams);
    }

    @NotNull
    public final String transformSwissGermanDic(@NotNull String dicText) {
        Intrinsics.checkNotNullParameter((Object)dicText, (String)"dicText");
        List lines = SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.drop((Sequence)StringsKt.lineSequence((CharSequence)dicText), (int)1), DictionaryResources::transformSwissGermanDic$lambda$0)));
        return lines.size() + "\n" + CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> transformSwissGermanTrigrams(@NotNull List<String> trigrams) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(trigrams, (String)"trigrams");
        Iterable $this$flatMap$iv = trigrams;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String s = (String)element$iv$iv;
            boolean bl = false;
            String replaced = StringsKt.replace$default((String)s, (String)"\u00df", (String)"ss", (boolean)false, (int)4, null);
            if (replaced.length() > 3) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)new IntRange(0, replaced.length() - 3);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void start;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    String string = replaced.substring((int)start, (int)(start + 3));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    collection.add(string);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.listOf((Object)replaced);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    @NotNull
    public final HunspellWordList getHunspellDict(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return this.getHunspellDict("/dictionary/" + language.getIso());
    }

    private final HunspellWordList getHunspellDict(String dict) {
        String affDict = Resources.INSTANCE.text(dict + ".aff");
        String dicDict = Resources.INSTANCE.text(dict + ".dic");
        List trigrams = StringsKt.lines((CharSequence)Resources.INSTANCE.text(dict + ".trigrams.txt"));
        return HunspellWordList.Companion.create(affDict, dicDict, trigrams);
    }

    @NotNull
    public final Set<String> getTrigrams(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return CollectionsKt.toHashSet((Iterable)StringsKt.lines((CharSequence)Resources.INSTANCE.text("/dictionary/" + language.getIso() + ".trigrams.txt")));
    }

    @Deprecated(message="Use a non-suspending version")
    @Nullable
    public final Object getReplacingRules(@NotNull String name, @NotNull DataLoader loader, @NotNull Continuation<? super RuleDictionary> $completion) {
        return this.getReplacingRules(name);
    }

    @NotNull
    public final RuleDictionary getReplacingRules(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.parseReplacingRules(Resources.INSTANCE.text(name + ".dat"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RuleDictionary parseReplacingRules(@NotNull String datRules) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)datRules, (String)"datRules");
        HashSet<ReplacingRuleDictionary.Descriptor> rules = new HashSet<ReplacingRuleDictionary.Descriptor>();
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)datRules);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String line : (List)destination$iv$iv) {
            String[] stringArray = UtilsKt.splitByDelimiter(line, "->");
            String incorrect = stringArray[0];
            String correct2 = stringArray[1];
            rules.add(new ReplacingRuleDictionary.Descriptor(UtilsKt.splitByDelimiter$default(incorrect, null, 1, null), UtilsKt.splitByDelimiter$default(correct2, null, 1, null)));
        }
        return new ReplacingRuleDictionary((Collection<ReplacingRuleDictionary.Descriptor>)rules);
    }

    private static final String transformSwissGermanDic$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.replace$default((String)it, (String)"\u00df", (String)"ss", (boolean)false, (int)4, null);
    }
}

