/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.assertj.core.util.Sets;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.util.Maps;

class EventQueueMapping {
    final Map<Component, WeakReference<EventQueue>> queueMap = Maps.newWeakHashMap();

    EventQueueMapping() {
    }

    @RunsInCurrentThread
    void addQueueFor(@Nonnull Component c) {
        EventQueue queue = c.getToolkit().getSystemEventQueue();
        this.queueMap.put(c, new WeakReference<EventQueue>(queue));
    }

    @Nullable
    @RunsInCurrentThread
    EventQueue queueFor(@Nonnull Component c) {
        EventQueue queue = this.storedQueueFor(c);
        if (queue == null) {
            return c.getToolkit().getSystemEventQueue();
        }
        return queue;
    }

    @Nullable
    EventQueue storedQueueFor(@Nonnull Component c) {
        return this.queueFrom(this.queueMap.get(c));
    }

    @Nonnull
    Collection<EventQueue> eventQueues() {
        HashSet eventQueues = Sets.newHashSet();
        for (WeakReference<EventQueue> reference : this.queueMap.values()) {
            EventQueue queue = this.queueFrom(reference);
            if (queue == null) continue;
            eventQueues.add(queue);
        }
        return eventQueues;
    }

    @Nullable
    private EventQueue queueFrom(@Nullable WeakReference<EventQueue> reference) {
        if (reference == null) {
            return null;
        }
        return (EventQueue)reference.get();
    }
}

