import winston, { Logger } from "winston";
import "winston-daily-rotate-file";
export interface LoggerConfig {
    level: "debug" | "info" | "warn" | "error";
    logfile?: string;
    errfile?: string;
    toConsole: boolean;
    maxFiles: number;
    verbose: boolean;
    timestamp: boolean;
}
export interface RequestLogger {
    error: (msg: string, ...meta: any[]) => void;
    warn: (msg: string, ...meta: any[]) => void;
    info: (msg: string, ...meta: any[]) => void;
    debug: (msg: string, ...meta: any[]) => void;
}
export declare function formatterFn(forceTimestamp?: boolean): winston.Logform.Format;
export declare function simpleLogger(level?: string): winston.Logger;
/**
 * Obtain a logger by name, creating one if necessary.
 */
export declare function get(nameOfLogger: string): winston.Logger;
export declare function logErr(logger: Logger, e: Error): void;
export declare const getLogger: typeof get;
export default getLogger;
/**
 * Configure how loggers should be created.
 */
export declare function configure(opts: LoggerConfig): void;
export declare function isVerbose(): boolean;
export declare function newRequestLogger(baseLogger: Logger, requestId: string, isFromIrc: boolean): RequestLogger;
export declare function setUncaughtExceptionLogger(exceptionLogger: Logger): void;
