/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.opensearch.common.Nullable;
import org.opensearch.common.Numbers;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.LongToSortedNumericUnsignedLongValues;
import org.opensearch.index.fielddata.SortedNumericUnsignedLongValues;
import org.opensearch.index.search.comparators.UnsignedLongComparator;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortOrder;

public class UnsignedLongValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public UnsignedLongValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.LONG;
    }

    private SortedNumericUnsignedLongValues loadDocValues(LeafReaderContext context) {
        LeafNumericFieldData data = (LeafNumericFieldData)this.indexFieldData.load(context);
        return new LongToSortedNumericUnsignedLongValues(data.getLongValues());
    }

    private NumericDocValues getNumericDocValues(LeafReaderContext context, BigInteger missingValue) throws IOException {
        SortedNumericUnsignedLongValues values = this.loadDocValues(context);
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue.longValue(), rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }

    @Override
    public Object missingObject(Object missingValue, boolean reversed) {
        if (this.sortMissingFirst(missingValue) || this.sortMissingLast(missingValue)) {
            boolean min = this.sortMissingFirst(missingValue) ^ reversed;
            return min ? Numbers.MIN_UNSIGNED_LONG_VALUE : Numbers.MAX_UNSIGNED_LONG_VALUE;
        }
        if (missingValue instanceof Number) {
            return Numbers.toUnsignedLongExact((Number)((Number)missingValue));
        }
        BigInteger missing = new BigInteger(missingValue.toString());
        if (missing.signum() < 0) {
            throw new IllegalArgumentException("Value [" + String.valueOf(missingValue) + "] is out of range for an unsigned long");
        }
        return missing;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final BigInteger ulMissingValue = (BigInteger)this.missingObject(this.missingValue, reversed);
        return new UnsignedLongComparator(numHits, fieldname, ulMissingValue, reversed, this.filterPruning(pruning)){

            @Override
            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new UnsignedLongComparator.UnsignedLongLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return UnsignedLongValuesComparatorSource.this.getNumericDocValues(context, ulMissingValue);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForUnsignedLongs(bigArrays, sortOrder, format, bucketSize, extra){
            private final BigInteger ulMissingValue;
            {
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.ulMissingValue = (BigInteger)UnsignedLongValuesComparatorSource.this.missingObject(UnsignedLongValuesComparatorSource.this.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForUnsignedLongs.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForUnsignedLongs.Leaf(ctx){
                    private final NumericDocValues docValues;
                    private long docValue;
                    {
                        super(this, ctx2);
                        this.docValues = UnsignedLongValuesComparatorSource.this.getNumericDocValues(ctx, ulMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = this.docValues.longValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected long docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

