/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.util.Objects;

public class CompensatedSum {
    private static final double NO_CORRECTION = 0.0;
    private double value;
    private double delta;

    public CompensatedSum(double value, double delta) {
        this.value = value;
        this.delta = delta;
    }

    public double value() {
        return this.value;
    }

    public double delta() {
        return this.delta;
    }

    public CompensatedSum add(double value) {
        return this.add(value, 0.0);
    }

    public void reset(double value, double delta) {
        this.value = value;
        this.delta = delta;
    }

    public CompensatedSum add(double value, double delta) {
        if (!Double.isFinite(value)) {
            this.value = value + this.value;
        }
        if (Double.isFinite(this.value)) {
            double correctedSum = value + (this.delta + delta);
            double updatedValue = this.value + correctedSum;
            this.delta = correctedSum - (updatedValue - this.value);
            this.value = updatedValue;
        }
        return this;
    }

    public void add(double[] values, int count) {
        double sum = this.value;
        double c = this.delta;
        for (int i = 0; i < count; ++i) {
            double y = values[i] - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        this.value = sum;
        this.delta = c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompensatedSum that = (CompensatedSum)o;
        return Double.compare(that.value, this.value) == 0 && Double.compare(that.delta, this.delta) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.delta);
    }

    public String toString() {
        return this.value + " " + this.delta;
    }
}

