/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.dataprocessor;

import com.google.common.math.DoubleMath;
import java.util.Arrays;
import org.opensearch.timeseries.dataprocessor.Imputer;

public class LinearUniformImputer
extends Imputer {
    private boolean integerSensitive;

    public LinearUniformImputer(boolean integerSensitive) {
        this.integerSensitive = integerSensitive;
    }

    @Override
    public double[] singleFeatureImpute(double[] samples, int numImputed) {
        int numSamples = samples.length;
        double[] imputedValues = new double[numImputed];
        if (numSamples == 0) {
            imputedValues = new double[]{};
        } else if (numSamples == 1) {
            Arrays.fill(imputedValues, samples[0]);
        } else {
            for (int imputedIndex = 0; imputedIndex < numImputed - 1; ++imputedIndex) {
                double imputed;
                double tGlobal = (double)imputedIndex / ((double)numImputed - 1.0);
                double tInterval = tGlobal * ((double)numSamples - 1.0);
                int intervalIndex = (int)Math.floor(tInterval);
                double leftSample = samples[intervalIndex];
                double rightSample = samples[intervalIndex + 1];
                imputedValues[imputedIndex] = imputed = (1.0 - (tInterval -= (double)intervalIndex)) * leftSample + tInterval * rightSample;
            }
            imputedValues[numImputed - 1] = samples[numSamples - 1];
        }
        if (this.integerSensitive && Arrays.stream(samples).allMatch(DoubleMath::isMathematicalInteger)) {
            imputedValues = Arrays.stream(imputedValues).map(Math::rint).toArray();
        }
        return imputedValues;
    }
}

