function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { cloneElement } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiText } from '../../text';
import { OuiFormControlLayout } from './form_control_layout';
export var OuiFormControlLayoutDelimited = function OuiFormControlLayoutDelimited(_ref) {
  var startControl = _ref.startControl,
    endControl = _ref.endControl,
    _ref$delimiter = _ref.delimiter,
    delimiter = _ref$delimiter === void 0 ? '→' : _ref$delimiter,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, ["startControl", "endControl", "delimiter", "className"]);
  var classes = classNames('ouiFormControlLayoutDelimited', className);
  return /*#__PURE__*/React.createElement(OuiFormControlLayout, _extends({
    className: classes
  }, rest), addClassesToControl(startControl), /*#__PURE__*/React.createElement(OuiText, {
    className: "ouiFormControlLayoutDelimited__delimeter",
    size: "s",
    color: "subdued"
  }, delimiter), addClassesToControl(endControl));
};
OuiFormControlLayoutDelimited.propTypes = {
  /**
     * Left side control
     */
  startControl: PropTypes.element.isRequired,
  /**
     * Right side control
     */
  endControl: PropTypes.element.isRequired,
  /**
     * The center content. Accepts a string to be wrapped in a subdued OuiText
     * or a single ReactElement
     */
  delimiter: PropTypes.node,
  className: PropTypes.string
};
function addClassesToControl(control) {
  return /*#__PURE__*/cloneElement(control, {
    className: classNames(control.props.className, 'ouiFormControlLayoutDelimited__input')
  });
}

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */export { EuiFormControlLayoutDelimited } from '../../../eui_components/form/form_control_layout/form_control_layout_delimited';