"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
const worker_store_1 = require("./worker_store");
// @ts-ignore
window.MonacoEnvironment = {
    getWorker: (_, label) => {
        const workerSrc = (0, worker_store_1.getWorker)(label);
        if (workerSrc) {
            const blob = new Blob([workerSrc], { type: 'application/javascript' });
            const worker = new Worker(URL.createObjectURL(blob));
            return worker;
        }
        throw new Error(`No worker available for language: ${label}`);
    },
};
//# sourceMappingURL=monaco_environment.js.map