"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resourceManagerService = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @experimental this class is experimental and might change in future releases.
 */
class ResourceManagerService {
  constructor() {
    _defineProperty(this, "managers", void 0);
    this.managers = new Map();
  }
  register(dataConnectionType, manager) {
    if (this.managers.get(dataConnectionType) !== undefined) {
      throw new Error(`Manager for dataConnectionType ${dataConnectionType} is already registered. Unable to register another manager.`);
    }
    this.managers.set(dataConnectionType, manager);
  }
  getManager(dataConnectionType) {
    return this.managers.get(dataConnectionType);
  }
}

// export as singleton
const resourceManagerService = exports.resourceManagerService = new ResourceManagerService();