(window["visTypeVislib_bundle_jsonpfunction"]=window["visTypeVislib_bundle_jsonpfunction"]||[]).push([[2],{111:function(module,exports,__webpack_require__){var baseSet=__webpack_require__(54);function setWith(object,path,value,customizer){customizer=typeof customizer=="function"?customizer:undefined;return object==null?object:baseSet(object,path,value,customizer)}module.exports=setWith},171:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"Vis",(function(){return vis_Vis}));var external_osdSharedDeps_Lodash_=__webpack_require__(5);var external_osdSharedDeps_Lodash_default=__webpack_require__.n(external_osdSharedDeps_Lodash_);var d3=__webpack_require__(39);var d3_default=__webpack_require__.n(d3);var events_events=__webpack_require__(67);var external_osdSharedDeps_OsdI18n_=__webpack_require__(1);var public_=__webpack_require__(14);class errors_VislibError extends public_["OsdError"]{constructor(message){super(message)}displayToScreen(handler){handler.error(this.message)}}class InvalidLogScaleValues extends errors_VislibError{constructor(){super("Values less than 1 cannot be displayed on a log scale")}}class ContainerTooSmall extends errors_VislibError{constructor(){super("This container is too small to render the visualization")}}class PieContainsAllZeros extends errors_VislibError{constructor(){super("No results displayed because all values equal 0.")}}class errors_NoResults extends errors_VislibError{constructor(){super(external_osdSharedDeps_OsdI18n_["i18n"].translate("visTypeVislib.vislib.errors.noResultsFoundTitle",{defaultMessage:"No results found"}))}}var opensearch_safer_lodash_set=__webpack_require__(44);function getSeriId(seri){if(!seri.id){return}const bracketsMarker=seri.id.indexOf("[");if(bracketsMarker>-1){return seri.id.substring(0,bracketsMarker)}if(seri.id.indexOf(".")>-1){return seri.id.split(".")[0]}return seri.id}const createSeriesFromParams=(cfg,seri)=>{const seriId=getSeriId(seri);const matchingSeriesParams=cfg.seriesParams?cfg.seriesParams.find(seriConfig=>seriId===seriConfig.data.id):null;const interpolate=cfg.smoothLines?"cardinal":cfg.interpolate;if(!matchingSeriesParams){const seriesParams0=Array.isArray(cfg.seriesParams)&&cfg.seriesParams[0]?cfg.seriesParams[0]:cfg;const stacked=["stacked","percentage","wiggle","silhouette"].includes(cfg.mode);return{show:true,type:cfg.type||"line",mode:stacked?"stacked":"normal",interpolate:interpolate,drawLinesBetweenPoints:seriesParams0.drawLinesBetweenPoints,showCircles:seriesParams0.showCircles,radiusRatio:cfg.radiusRatio,data:seri}}return{...matchingSeriesParams,data:seri,radiusRatio:cfg.radiusRatio}};const createSeries=(cfg,series)=>({type:"point_series",addTimeMarker:cfg.addTimeMarker,series:external_osdSharedDeps_Lodash_default.a.map(series,seri=>createSeriesFromParams(cfg,seri))});const createCharts=(cfg,data)=>{if(data.rows||data.columns){const charts=data.rows?data.rows:data.columns;return charts.map(chart=>createSeries(cfg,chart.series))}return[createSeries(cfg,data.series)]};function create(opts){opts=opts||{};return function(cfg,data){const isUserDefinedYAxis=cfg.setYExtents;const defaultYExtents=cfg.defaultYExtents;const config=external_osdSharedDeps_Lodash_default.a.cloneDeep(cfg);external_osdSharedDeps_Lodash_default.a.defaultsDeep(config,{chartTitle:{},mode:"normal"},opts);config.type="point_series";if(!config.tooltip){config.tooltip={show:cfg.addTooltip}}if(!config.valueAxes){let mode=config.mode;if(["stacked","overlap"].includes(mode))mode="normal";config.valueAxes=[{id:"ValueAxis-1",type:"value",scale:{type:config.scale,setYExtents:config.setYExtents,defaultYExtents:config.defaultYExtents,boundsMargin:defaultYExtents?config.boundsMargin:0,min:isUserDefinedYAxis?config.yAxis.min:undefined,max:isUserDefinedYAxis?config.yAxis.max:undefined,mode:mode},labels:{axisFormatter:data.data.yAxisFormatter||data.get("yAxisFormatter")},title:{text:data.get("yAxisLabel")}}]}else{config.valueAxes.forEach(axis=>{if(axis.labels){axis.labels.axisFormatter=data.data.yAxisFormatter||data.get("yAxisFormatter");const seriesParams=config.seriesParams&&config.seriesParams.find(seriesParams=>seriesParams.valueAxis===axis.id);if(seriesParams){const seriesDataId=seriesParams.data.id;const series=(data.data.series||data.get("series")).find(series=>getSeriId(series)===seriesDataId);if(series){axis.labels.axisFormatter=series.yAxisFormatter}}}})}if(!config.categoryAxes){config.categoryAxes=[{id:"CategoryAxis-1",type:"category",labels:{axisFormatter:data.data.xAxisFormatter||data.get("xAxisFormatter")},scale:{expandLastBucket:opts.expandLastBucket},title:{text:data.get("xAxisLabel")}}]}else{const categoryAxis1=config.categoryAxes.find(categoryAxis=>categoryAxis.id==="CategoryAxis-1");if(categoryAxis1){categoryAxis1.title.text=data.get("xAxisLabel")}}if(!config.charts){config.charts=createCharts(cfg,data.data)}if(typeof config.enableHover==="undefined")config.enableHover=true;return config}}const vislibPointSeriesTypes={line:create(),column:create({expandLastBucket:true}),area:create({alerts:[{type:"warning",msg:"Positive and negative values are not accurately represented by stacked "+'area charts. Either changing the chart mode to "overlap" or using a '+"bar chart is recommended.",test:function(_,data){if(!data.shouldBeStacked()||data.maxNumberOfSeries()<2)return;const hasPos=data.getYMax(data._getY)>0;const hasNeg=data.getYMin(data._getY)<0;return hasPos&&hasNeg}},{type:"warning",msg:"Parts of or the entire area chart might not be displayed due to null "+"values in the data. A line chart is recommended when displaying data "+"with null values.",test:function(_,data){return data.hasNullValues()}}]}),heatmap:(cfg,data)=>{const defaults=create()(cfg,data);const hasCharts=defaults.charts.length;const tooManySeries=defaults.charts.length&&defaults.charts[0].series.length>cfg.heatmapMaxBuckets;if(hasCharts&&tooManySeries){defaults.error=external_osdSharedDeps_OsdI18n_["i18n"].translate("visTypeVislib.vislib.heatmap.maxBucketsText",{defaultMessage:"There are too many series defined ({nr}). The configured maximum is {max}.",values:{max:cfg.heatmapMaxBuckets,nr:defaults.charts[0].series.length},description:"This message appears at heatmap visualizations"})}defaults.valueAxes[0].show=false;defaults.categoryAxes[0].style={rangePadding:0,rangeOuterPadding:0};defaults.categoryAxes.push({id:"CategoryAxis-2",type:"category",position:"left",values:data.getLabels(),scale:{inverted:true},labels:{filter:false,axisFormatter:function(val){return val}},style:{rangePadding:0,rangeOuterPadding:0},title:{text:data.get("zAxisLabel")||""}});return defaults}};function vislibPieConfig(config){if(!config.chart){config.chart=external_osdSharedDeps_Lodash_default.a.defaults({},config,{type:"pie",labels:{show:false,truncate:100}})}return config}function vislibGaugeConfig(config){return config}const vislibTypesConfig={histogram:vislibPointSeriesTypes.column,horizontal_bar:vislibPointSeriesTypes.column,line:vislibPointSeriesTypes.line,pie:vislibPieConfig,area:vislibPointSeriesTypes.area,point_series:vislibPointSeriesTypes.line,heatmap:vislibPointSeriesTypes.heatmap,gauge:vislibGaugeConfig,goal:vislibGaugeConfig,metric:vislibGaugeConfig};var external_osdSharedDeps_Moment_=__webpack_require__(17);var external_osdSharedDeps_Moment_default=__webpack_require__.n(external_osdSharedDeps_Moment_);function flattenData(obj){let charts;if(!external_osdSharedDeps_Lodash_default.a.isObject(obj)||!obj.rows&&!obj.columns&&!obj.series){throw new TypeError("flattenData expects an object with a series, rows, or columns key")}if(!obj.series){charts=obj.rows?obj.rows:obj.columns}return external_osdSharedDeps_Lodash_default()(charts?charts:[obj]).map("series").flattenDeep().map("values").flattenDeep().filter(Boolean).value()}function getUniqKeys(obj){if(!Object(external_osdSharedDeps_Lodash_["isObject"])(obj)){throw new TypeError("getUniqKeys expects an object")}const flattenedData=flattenData(obj);const uniqueXValues=new Map;let charts;if(!obj.series){charts=obj.rows?obj.rows:obj.columns}else{charts=[obj]}const isDate=charts.every(chart=>chart.ordered&&chart.ordered.date);const isOrdered=charts.every(chart=>chart.ordered);const initXValue=(key,index)=>{uniqueXValues.set(key,{index:index,isDate:isDate,isOrdered:isOrdered,isNumber:Object(external_osdSharedDeps_Lodash_["isNumber"])(key),sum:0})};if(obj.xAxisOrderedValues){obj.xAxisOrderedValues.forEach(initXValue)}flattenedData.forEach(d=>{const key=d.x;let prev=uniqueXValues.get(key);if(!prev){initXValue(key,uniqueXValues.size);prev=uniqueXValues.get(key)}uniqueXValues.set(key,{...prev,sum:prev.sum+d.y})});return uniqueXValues}function orderXValues(obj){let orderBucketsBySum=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;if(!external_osdSharedDeps_Lodash_default.a.isObject(obj)){throw new Error("orderXValues expects an object")}const uniqKeys=getUniqKeys(obj);const uniqKeysPairs=[...uniqKeys.entries()];const interval=external_osdSharedDeps_Lodash_default.a.get(obj,"ordered.interval");const dateInterval=external_osdSharedDeps_Moment_default.a.isDuration(interval)?interval:false;return external_osdSharedDeps_Lodash_default()(uniqKeysPairs).sortBy((function(d){if(d[1].isDate||d[1].isOrdered){return+d[0]}return orderBucketsBySum?-d[1].sum:d[1].index})).map((function(d,i,list){if(!d[1].isNumber)return d[0];const val=+d[0];if(interval==null)return val;const gapEdge=parseFloat(external_osdSharedDeps_Lodash_default.a.get(list,[i+1,0]));if(isNaN(gapEdge))return val;const vals=[];let next=val;if(dateInterval){next=external_osdSharedDeps_Moment_default()(val);while(next<gapEdge){vals.push(next.valueOf());next.add(dateInterval)}}else{while(next<gapEdge){vals.push(next);next+=interval}}return vals})).flatten().value()}function createZeroFilledArray(arr,label){if(!Array.isArray(arr)){throw new Error("createZeroFilledArray expects an array of strings or numbers")}const zeroFilledArray=[];arr.forEach((function(val){zeroFilledArray.push({x:val,xi:Infinity,y:0,series:label})}));return zeroFilledArray}function zeroFillDataArray(arr1,arr2){if(!Array.isArray(arr1)||!Array.isArray(arr2)){throw new TypeError("zeroFillDataArray expects 2 arrays")}let i;let val;let index;const max=arr2.length;const getX=function(d){return d.x===val.x};for(i=0;i<max;i++){val=arr2[i];index=external_osdSharedDeps_Lodash_default.a.findIndex(arr1,getX);arr1.splice(index,1,val)}return arr1}function injectZeros(obj,data){let orderBucketsBySum=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;const keys=orderXValues(data,orderBucketsBySum);obj.forEach((function(series){const zeroArray=createZeroFilledArray(keys,series.label);series.values=zeroFillDataArray(zeroArray,series.values)}));return obj}function flattenSeries(obj){if(!external_osdSharedDeps_Lodash_default.a.isObject(obj)||!obj.rows&&!obj.columns){throw new TypeError("GetSeriesUtilService expects an object with either a rows or columns key")}obj=obj.rows?obj.rows:obj.columns;return external_osdSharedDeps_Lodash_default.a.chain(obj).map("series").flattenDeep().value()}function dataArray(obj){if(!external_osdSharedDeps_Lodash_default.a.isObject(obj)||!obj.rows&&!obj.columns&&!obj.series){throw new TypeError("GetArrayUtilService expects an object with a series, rows, or columns key")}if(!obj.series)return flattenSeries(obj);return obj.series}function uniqLabels(arr){if(!Array.isArray(arr)){throw new TypeError("UniqLabelUtil expects an array of objects")}return external_osdSharedDeps_Lodash_default()(arr).map("label").uniq().value()}function labels_labels(obj){if(!external_osdSharedDeps_Lodash_default.a.isObject(obj)){throw new TypeError("LabelUtil expects an object")}return uniqLabels(dataArray(obj))}var services=__webpack_require__(9);class D3MappableObject{constructor(data){for(const key in data){if(data.hasOwnProperty(key)){this[key]=data[key]}}}toString(){return JSON.stringify(this)}}class data_Data{constructor(data,uiState,createColorLookupFunction){this.uiState=uiState;this.createColorLookupFunction=createColorLookupFunction;this.data=this.copyDataObj(data);this.type=this.getDataType();this._cleanVisData();this.labels=this._getLabels(this.data);this.color=this.labels?createColorLookupFunction(this.labels,uiState.get("vis.colors")):undefined;this._normalizeOrdered()}copyDataObj(data){const copyChart=data=>{const newData={};Object.keys(data).forEach(key=>{if(key==="xAxisOrderedValues"){newData[key]=data[key].map(val=>{if(typeof val==="object"){return new D3MappableObject(val)}return val})}else if(key==="series"){newData[key]=data[key].map(seri=>{const converter=Object(services["b"])().deserialize(seri.format);const zConverter=Object(services["b"])().deserialize(seri.zFormat);return{id:seri.id,rawId:seri.rawId,label:seri.label,zLabel:seri.zLabel,values:seri.values.map(val=>{const newVal=external_osdSharedDeps_Lodash_default.a.clone(val);newVal.extraMetrics=val.extraMetrics;newVal.series=val.series||seri.label;if(typeof newVal.x==="object"){newVal.x=new D3MappableObject(newVal.x)}return newVal}),yAxisFormatter:val=>converter.convert(val),zAxisFormatter:val=>zConverter.convert(val)}})}else{newData[key]=data[key]}});const xConverter=Object(services["b"])().deserialize(newData.xAxisFormat);const yConverter=Object(services["b"])().deserialize(newData.yAxisFormat);const zConverter=Object(services["b"])().deserialize(newData.zAxisFormat);newData.xAxisFormatter=val=>xConverter.convert(val);newData.yAxisFormatter=val=>yConverter.convert(val);newData.zAxisFormatter=val=>zConverter.convert(val);return newData};if(!data.series){const newData={};Object.keys(data).forEach(key=>{if(!["rows","columns"].includes(key)){newData[key]=data[key]}else{newData[key]=data[key].map(chart=>copyChart(chart))}});return newData}return copyChart(data)}_getLabels(data){if(this.type==="series"){return labels_labels(data)}return[]}getDataType(){const data=this.getVisData();let type;data.forEach((function(obj){if(obj.series){type="series"}else if(obj.slices){type="slices"}else if(obj.geoJson){type="geoJson"}}));return type}chartData(){if(!this.data.series){const arr=this.data.rows?this.data.rows:this.data.columns;return external_osdSharedDeps_Lodash_default.a.toArray(arr)}return[this.data]}shouldBeStacked(seriesConfig){if(!seriesConfig)return false;return seriesConfig.mode==="stacked"}getStackedSeries(chartConfig,axis,series){let first=arguments.length>3&&arguments[3]!==undefined?arguments[3]:false;const matchingSeries=[];chartConfig.series.forEach((seriArgs,i)=>{const matchingAxis=seriArgs.valueAxis===axis.axisConfig.get("id")||!seriArgs.valueAxis&&first;if(matchingAxis&&(this.shouldBeStacked(seriArgs)||axis.axisConfig.get("scale.stacked"))){matchingSeries.push(series[i])}});return matchingSeries}stackChartData(handler,data,chartConfig){const stackedData={};handler.valueAxes.forEach((axis,i)=>{const id=axis.axisConfig.get("id");stackedData[id]=this.getStackedSeries(chartConfig,axis,data,i===0);stackedData[id]=this.injectZeros(stackedData[id],handler.visConfig.get("orderBucketsBySum",false));axis.axisConfig.set("stackedSeries",stackedData[id].length);axis.stack(external_osdSharedDeps_Lodash_default.a.map(stackedData[id],"values"))});return stackedData}stackData(handler){const data=this.data;if(data.rows||data.columns){const charts=data.rows?data.rows:data.columns;charts.forEach((chart,i)=>{this.stackChartData(handler,chart.series,handler.visConfig.get(`charts[${i}]`))})}else{this.stackChartData(handler,data.series,handler.visConfig.get("charts[0]"))}}getVisData(){let visData;if(this.data.rows){visData=this.data.rows}else if(this.data.columns){visData=this.data.columns}else{visData=[this.data]}return visData}getGeoExtents(){const visData=this.getVisData();return external_osdSharedDeps_Lodash_default.a.reduce(external_osdSharedDeps_Lodash_default.a.map(visData,"geoJson.properties"),(function(minMax,props){return{min:Math.min(props.min,minMax.min),max:Math.max(props.max,minMax.max)}}),{min:Infinity,max:-Infinity})}pieData(){if(!this.data.slices){return this.data.rows?this.data.rows:this.data.columns}return[this.data]}get(thing,def){const source=(this.data.rows||this.data.columns||[this.data])[0];return external_osdSharedDeps_Lodash_default.a.get(source,thing,def)}hasNullValues(){const chartData=this.chartData();return chartData.some((function(chart){return chart.series.some((function(obj){return obj.values.some((function(d){return d.y===null}))}))}))}flatten(){return external_osdSharedDeps_Lodash_default()(this.chartData()).map("series").flattenDeep().map("values").flattenDeep().value()}validateUserDefinedYMin(val){if(!external_osdSharedDeps_Lodash_default.a.isNumber(val)){throw new Error("validateUserDefinedYMin expects a number")}return val}returnNames(array,index,columns){const names=[];const self=this;external_osdSharedDeps_Lodash_default.a.forEach(array,(function(obj){names.push({label:obj.name,values:[obj.rawData],index:index});if(obj.children){const plusIndex=index+1;external_osdSharedDeps_Lodash_default.a.forEach(self.returnNames(obj.children,plusIndex,columns),(function(namedObj){names.push(namedObj)}))}}));return names}getNames(data,columns){const slices=data.slices;if(slices.children){const namedObj=this.returnNames(slices.children,0,columns);return external_osdSharedDeps_Lodash_default()(namedObj).sortBy((function(obj){return obj.index})).uniqBy((function(d){return d.label})).value()}}_cleanVisData(){const visData=this.getVisData();if(this.type==="slices"){this._cleanPieChartData(visData)}}_cleanPieChartData(data){external_osdSharedDeps_Lodash_default.a.forEach(data,obj=>{obj.slices=this._removeZeroSlices(obj.slices)})}_removeZeroSlices(slices){if(!slices.children){return slices}slices=external_osdSharedDeps_Lodash_default.a.clone(slices);slices.children=slices.children.reduce((children,child)=>{if(child.size!==0){return[...children,this._removeZeroSlices(child)]}return children},[]);return slices}pieNames(data){const self=this;const names=[];external_osdSharedDeps_Lodash_default.a.forEach(data,(function(obj){const columns=obj.raw?obj.raw.columns:undefined;external_osdSharedDeps_Lodash_default.a.forEach(self.getNames(obj,columns),(function(name){names.push(name)}))}));return external_osdSharedDeps_Lodash_default.a.uniqBy(names,"label")}injectZeros(data){let orderBucketsBySum=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;return injectZeros(data,this.data,orderBucketsBySum)}xValues(){let orderBucketsBySum=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;return orderXValues(this.data,orderBucketsBySum)}getLabels(){return labels_labels(this.data)}getColorFunc(){if(this.type==="slices"){return this.getPieColorFunc()}const defaultColors=this.uiState.get("vis.defaultColors");const overwriteColors=this.uiState.get("vis.colors");const colors=defaultColors?external_osdSharedDeps_Lodash_default.a.defaults({},overwriteColors,defaultColors):overwriteColors;return this.createColorLookupFunction(this.getLabels(),colors)}getPieColorFunc(){return this.createColorLookupFunction(this.pieNames(this.getVisData()).map((function(d){return d.label})),this.uiState.get("vis.colors"))}_normalizeOrdered(){const data=this.getVisData();const self=this;data.forEach((function(d){if(!d.ordered||!d.ordered.date)return;const missingMin=d.ordered.min==null;const missingMax=d.ordered.max==null;if(missingMax||missingMin){const extent=d3_default.a.extent(self.xValues());if(missingMin)d.ordered.min=extent[0];if(missingMax)d.ordered.max=extent[1]}}))}mapDataExtents(series){const values=external_osdSharedDeps_Lodash_default.a.map(series.rows,(function(row){return row[row.length-1]}));return[external_osdSharedDeps_Lodash_default.a.min(values),external_osdSharedDeps_Lodash_default.a.max(values)]}maxNumberOfSeries(){return this.chartData().reduce((function(max,chart){return Math.max(max,chart.series.length)}),0)}}const DEFAULT_VIS_CONFIG={style:{margin:{top:10,right:3,bottom:5,left:3}},alerts:[],categoryAxes:[],valueAxes:[],grid:{}};class vis_config_VisConfig{constructor(visConfigArgs,data,uiState,el,createColorLookupFunction){this.data=new data_Data(data,uiState,createColorLookupFunction);const visType=vislibTypesConfig[visConfigArgs.type];const typeDefaults=visType(visConfigArgs,this.data);this._values=external_osdSharedDeps_Lodash_default.a.defaultsDeep({...typeDefaults},DEFAULT_VIS_CONFIG);this._values.el=el}get(property,defaults){if(external_osdSharedDeps_Lodash_default.a.has(this._values,property)||typeof defaults!=="undefined"){return external_osdSharedDeps_Lodash_default.a.get(this._values,property,defaults)}else{throw new Error(`Accessing invalid config property: ${property}`);return defaults}}set(property,value){return Object(opensearch_safer_lodash_set["set"])(this._values,property,value)}}var markdown_it=__webpack_require__(112);var markdown_it_default=__webpack_require__.n(markdown_it);var external_osdSharedDeps_Jquery_=__webpack_require__(16);var external_osdSharedDeps_Jquery_default=__webpack_require__.n(external_osdSharedDeps_Jquery_);function chartSplit(selection,parent){selection.each((function(data){const div=d3_default.a.select(this).attr("class",(function(){if(data.rows){return"visWrapper__splitCharts--row"}else if(data.columns){return"visWrapper__splitCharts--column"}else{if(parent){return"visWrapper__chart--first visWrapper__chart--last visWrapper__chart"}return this.className+" visWrapper__chart"}}));let divClass="";let chartsNumber;const charts=div.selectAll("charts").append("div").data((function(d){if(d.rows){chartsNumber=d.rows.length;return d.rows}else if(d.columns){chartsNumber=d.columns.length;return d.columns}else{divClass="chart";chartsNumber=1;return[d]}})).enter().append("div").attr("class",(function(d,i){let fullDivClass=divClass;if(fullDivClass!=="chart"){if(chartsNumber>1){if(i===0){fullDivClass+=" visWrapper__chart--first"}else if(i===chartsNumber-1){fullDivClass+=" visWrapper__chart--last"}}else{fullDivClass+=" visWrapper__chart--first visWrapper__chart--last"}}return fullDivClass}));if(!data.series){charts.call(chartSplit)}}))}function yAxisSplit(selection){selection.each((function(){const div=d3_default.a.select(this);let rows;div.selectAll(".y-axis-div").append("div").data((function(d){rows=d.rows?d.rows.length:1;return d.rows?d.rows:[d]})).enter().append("div").attr("class",(d,i)=>{let divClass="";if(i===0){divClass+=" visWrapper__chart--first"}if(i===rows-1){divClass+=" visWrapper__chart--last"}return"y-axis-div axis-div"+divClass})}))}function xAxisSplit(selection){selection.each((function(){const div=d3_default.a.select(this);let columns;div.selectAll(".x-axis-div").append("div").data((function(d){columns=d.columns?d.columns.length:1;return d.columns?d.columns:[d]})).enter().append("div").attr("class",(d,i)=>{let divClass="";if(i===0){divClass+=" visWrapper__chart--first"}if(i===columns-1){divClass+=" visWrapper__chart--last"}return"x-axis-div axis-div"+divClass})}))}function chartTitleSplit(selection){selection.each((function(data){const div=d3_default.a.select(this);const parent=external_osdSharedDeps_Jquery_default()(this).parents(".visWrapper");if(!data.series){div.selectAll(".chart-title").data((function(d){return d.rows?d.rows:d.columns})).enter().append("div").attr("class","chart-title");if(data.rows){parent.find(".visAxis__splitTitles--x").remove()}else{parent.find(".visAxis__splitTitles--y").remove()}return div}return d3_default.a.select(this).remove()}))}function columnLayout(el,data){if(!el||!data){throw new Error("Both an el and data need to be specified")}return[{parent:el,type:"div",class:"visWrapper",datum:data,children:[{type:"div",class:"visAxis--y",children:[{type:"div",class:"visAxis__spacer--y visAxis__spacer--y-top"},{type:"div",class:"visAxis__column--y visAxis__column--left",children:[{type:"div",class:"visAxis__splitTitles--y",splits:chartTitleSplit},{type:"div",class:"visAxis__splitAxes--y",splits:yAxisSplit}]},{type:"div",class:"visAxis__spacer--y visAxis__spacer--y-bottom"}]},{type:"div",class:"visWrapper__column",children:[{type:"div",class:"visAxis--x visAxis__column--top",children:[{type:"div",class:"visAxis__splitAxes--x",splits:xAxisSplit}]},{type:"div",class:"visWrapper__chart",splits:chartSplit},{type:"div",class:"visWrapper__alerts"},{type:"div",class:"visAxis--x visAxis__column--bottom",children:[{type:"div",class:"visAxis__splitAxes--x",splits:xAxisSplit},{type:"div",class:"visAxis__splitTitles--x",splits:chartTitleSplit}]}]},{type:"div",class:"visAxis--y",children:[{type:"div",class:"visAxis__spacer--y visAxis__spacer--y-top"},{type:"div",class:"visAxis__column--y visAxis__column--right",children:[{type:"div",class:"visAxis__splitAxes--y",splits:yAxisSplit}]},{type:"div",class:"visAxis__spacer--y visAxis__spacer--y-bottom"}]}]}]}function chart_split_chartSplit(selection){selection.each((function(data){const div=d3_default.a.select(this).attr("class",(function(){if(data.rows){return"visWrapper__splitCharts--row"}else if(data.columns){return"visWrapper__splitCharts--column"}else{return"visWrapper__chart"}}));let divClass;const charts=div.selectAll("charts").append("div").data((function(d){if(d.rows){divClass="chart-row";return d.rows}else if(d.columns){divClass="chart-column";return d.columns}else{divClass="chart";return[d]}})).enter().append("div").attr("class",(function(){return divClass}));if(!data.slices){charts.call(chart_split_chartSplit)}}))}function chart_title_split_chartTitleSplit(selection,parent){selection.each((function(data){const div=d3_default.a.select(this);if(!data.slices){div.selectAll(".chart-title").append("div").data((function(d){return d.rows?d.rows:d.columns})).enter().append("div").attr("class","chart-title");if(data.rows){d3_default.a.select(parent).select(".visAxis__splitTitles--x").remove()}else{d3_default.a.select(parent).select(".visAxis__splitTitles--y").remove()}return div}return d3_default.a.select(this).remove()}))}function pieLayout(el,data){if(!el||!data){throw new Error("Both an el and data need to be specified")}return[{parent:el,type:"div",class:"visWrapper",datum:data,children:[{type:"div",class:"visAxis__splitTitles--y",splits:chart_title_split_chartTitleSplit},{type:"div",class:"visWrapper__column",children:[{type:"div",class:"visWrapper__chart",splits:chart_split_chartSplit},{type:"div",class:"visAxis__splitTitles--x",splits:chart_title_split_chartTitleSplit}]}]}]}function gauge_chart_chart_split_chartSplit(selection){selection.each((function(data){const div=d3_default.a.select(this).attr("class",(function(){if(data.rows){return"visWrapper__splitCharts--row"}else if(data.columns){return"visWrapper__splitCharts--column"}else{return"visWrapper__chart"}}));let divClass;const charts=div.selectAll("charts").append("div").data((function(d){if(d.rows){divClass="chart-row";return d.rows}else if(d.columns){divClass="chart-column";return d.columns}else{divClass="chart";return[d]}})).enter().append("div").attr("class",(function(){return divClass}));if(!data.series){charts.call(gauge_chart_chart_split_chartSplit)}}))}function gaugeLayout(el,data){if(!el||!data){throw new Error("Both an el and data need to be specified")}return[{parent:el,type:"div",class:"visWrapper",datum:data,children:[{type:"div",class:"visAxis__splitTitles--y"},{type:"div",class:"visWrapper__column",children:[{type:"div",class:"visWrapper__chart",splits:gauge_chart_chart_split_chartSplit},{type:"div",class:"visWrapper__alerts"},{type:"div",class:"visAxis__splitTitles--x"}]}]}]}const layoutTypes={pie:pieLayout,gauge:gaugeLayout,goal:gaugeLayout,metric:gaugeLayout,point_series:columnLayout};class _error_handler_ErrorHandler{constructor(){}validateWidthandHeight(width,height){const badWidth=external_osdSharedDeps_Lodash_default.a.isNaN(width)||width<=0;const badHeight=external_osdSharedDeps_Lodash_default.a.isNaN(height)||height<=0;if(badWidth||badHeight){throw new ContainerTooSmall}}}class axis_title_AxisTitle{constructor(axisConfig){this.axisConfig=axisConfig;this.elSelector=this.axisConfig.get("title.elSelector").replace("{pos}",this.axisConfig.get("position"))}render(){d3_default.a.select(this.axisConfig.get("rootEl")).selectAll(this.elSelector).call(this.draw())}destroy(){external_osdSharedDeps_Jquery_default()(this.axisConfig.get("rootEl")).find(this.elSelector).find("svg").remove()}draw(){const config=this.axisConfig;return function(selection){selection.each((function(){if(!config.get("show")&&!config.get("title.show",false))return;const el=this;const div=d3_default.a.select(el);const width=external_osdSharedDeps_Jquery_default()(el).width();const height=external_osdSharedDeps_Jquery_default()(el).height();const axisPrefix=config.isHorizontal()?"x":"y";const svg=div.append("svg").attr("focusable","false").attr("width",width).attr("height",height).attr("class",`axis-title ${axisPrefix}-axis-title`);const bbox=svg.append("text").attr("transform",(function(){if(config.isHorizontal()){return`translate(${width/2},0)`}return`translate(0,${height/2}) rotate(270)`})).attr("text-anchor","middle").attr("dominant-baseline","hanging").text(config.get("title.text")).node().getBBox();if(config.isHorizontal()){svg.attr("height",Math.ceil(bbox.height))}else{svg.attr("width",Math.ceil(bbox.height))}}))}}}const truncateLabel=function(text,size){const node=d3_default.a.select(text).node();const str=external_osdSharedDeps_Jquery_default()(node).text();if(size===0)return str;if(size>=str.length)return str;return str.substr(0,size)+"…"};class axis_labels_AxisLabels{constructor(axisConfig,scale){this.axisConfig=axisConfig;this.axisScale=scale}render(selection){selection.call(this.draw())}rotateAxisLabels(){const config=this.axisConfig;return function(selection){const text=selection.selectAll(".tick text");if(config.get("labels.rotate")){text.style("text-anchor",(function(){const currentValue=external_osdSharedDeps_Jquery_default()(this).css("text-anchor");const rotateDeg=config.get("labels.rotate");if(!rotateDeg)return currentValue;else{const position=config.get("position");switch(position){case"top":return"end";case"bottom":return"end";default:if(rotateDeg===90||rotateDeg===-90)return"middle";return currentValue}}})).attr("dy",(function(){return config.isHorizontal()?"0.3em":"0"})).attr("transform",(function rotate(d,j){const position=config.get("position");const rotateDeg=position==="top"?config.get("labels.rotate"):-config.get("labels.rotate");if(external_osdSharedDeps_Jquery_default()(this).css("text-anchor")==="middle"){const coord=text[0][j].getBBox();const transX=coord.x+coord.width/2;const transY=coord.y+coord.height/2;return`rotate(${rotateDeg}, ${transX}, ${transY})`}else{const transX=this.attributes.x.nodeValue;const transY=this.attributes.y.nodeValue;return`rotate(${rotateDeg}, ${transX}, ${transY})`}}))}}}truncateLabels(){const config=this.axisConfig;return function(selection){if(!config.get("labels.truncate"))return;selection.selectAll(".tick text").text((function(){return truncateLabel(this,config.get("labels.truncate"))}))}}filterAxisLabels(){const self=this;const config=this.axisConfig;const padding=1.1;let lastTickStartEdge=Number.POSITIVE_INFINITY;let lastTickEndEdge=Number.NEGATIVE_INFINITY;return function(selection){if(!config.get("labels.filter"))return;const el=external_osdSharedDeps_Jquery_default()(config.get("rootEl")).find(config.get("elSelector"));const upperBound=config.isHorizontal()?el.width():el.height();const lowerBound=0;const scaleRange=self.axisScale.scale.range();const scaleWidth=Math.abs(scaleRange[scaleRange.length-1]-scaleRange[0]);const scaleStartPad=.5*(upperBound-scaleWidth);selection.selectAll(".tick text").text((function(d){const parentNode=d3_default.a.select(this.parentNode).node();const currentTickCenter=config.isHorizontal()?scaleStartPad+self.axisScale.scale(d):upperBound-scaleStartPad-self.axisScale.scale(d);const currentTickSize=(config.isHorizontal()?parentNode.getBBox().width:parentNode.getBBox().height)*padding;const currentTickHalfSize=currentTickSize/2;const currentTickStartEdge=currentTickCenter-currentTickHalfSize;const currentTickEndEdge=currentTickCenter+currentTickHalfSize;const outsideUpperBound=currentTickEndEdge>upperBound;const outsideLowerBound=currentTickStartEdge<lowerBound;const overlapsLastTick=currentTickEndEdge>=lastTickStartEdge&&currentTickStartEdge<=lastTickEndEdge;if(outsideUpperBound||outsideLowerBound||overlapsLastTick){d3_default.a.select(this.parentNode).remove()}else{lastTickStartEdge=currentTickCenter-currentTickHalfSize;lastTickEndEdge=currentTickCenter+currentTickHalfSize;return this.textContent}}))}}draw(){const self=this;const config=this.axisConfig;return function(selection){selection.each((function(){selection.selectAll("text").attr("style",(function(){const currentStyle=d3_default.a.select(this).attr("style");return`${currentStyle} font-size: ${config.get("labels.fontSize")};`}));if(!config.get("labels.show"))selection.selectAll("text").attr("style","display: none;");selection.call(self.truncateLabels());selection.call(self.rotateAxisLabels());selection.call(self.filterAxisLabels())}))}}}const timeTicks=scale=>{const domain=scale.domain();const startOffset=external_osdSharedDeps_Moment_default()(domain[0]).utcOffset();const shiftedDomain=domain.map(val=>external_osdSharedDeps_Moment_default()(val).add(startOffset,"minute"));const tickScale=scale.copy().domain(shiftedDomain);return n=>{const ticks=tickScale.ticks(n);const timePerTick=(domain[1]-domain[0])/ticks.length;const hourTicks=timePerTick<1e3*60*60*12;return ticks.map(d=>{const currentOffset=external_osdSharedDeps_Moment_default()(d).utcOffset();return external_osdSharedDeps_Moment_default()(d).subtract(hourTicks?startOffset:currentOffset,"minute").valueOf()})}};class axis_scale_AxisScale{constructor(axisConfig,visConfig){this.axisConfig=axisConfig;this.visConfig=visConfig;if(this.axisConfig.get("type")==="category"){this.values=this.axisConfig.values;this.ordered=this.axisConfig.ordered}}getScaleType(){return this.axisConfig.getScaleType()}validateUserExtents(domain){const config=this.axisConfig;return domain.map(val=>{val=parseFloat(val);if(isNaN(val))throw new Error(val+" is not a valid number");if(config.isPercentage()&&config.isUserDefined())return val/100;return val})}getTimeDomain(data){return[this.minExtent(data),this.maxExtent(data)]}minExtent(data){return this.calculateExtent(data||this.values,"min")}maxExtent(data){return this.calculateExtent(data||this.values,"max")}calculateExtent(data,extent){const ordered=this.ordered;const opts=[ordered[extent]];let point=d3_default.a[extent](data);if(this.axisConfig.get("scale.expandLastBucket")&&extent==="max"){point=this.addInterval(point)}opts.push(point);return d3_default.a[extent](opts.reduce((function(opts,v){if(!external_osdSharedDeps_Lodash_default.a.isNumber(v))v=+v;if(!isNaN(v))opts.push(v);return opts}),[]))}addInterval(x){return this.modByInterval(x,+1)}subtractInterval(x){return this.modByInterval(x,-1)}modByInterval(x,n){const ordered=this.ordered;if(!ordered)return x;const interval=ordered.interval;if(!interval)return x;if(!ordered.date){return x+=ordered.interval*n}const y=external_osdSharedDeps_Moment_default()(x);const method=n>0?"add":"subtract";external_osdSharedDeps_Lodash_default.a.times(Math.abs(n),(function(){y[method](interval)}));return y.valueOf()}getAllPoints(){const config=this.axisConfig;const data=this.visConfig.data.chartData();const chartPoints=external_osdSharedDeps_Lodash_default.a.reduce(data,(chartPoints,chart,chartIndex)=>{const points=chart.series.reduce((points,seri,seriIndex)=>{const seriConfig=this.visConfig.get(`charts[${chartIndex}].series[${seriIndex}]`);const matchingValueAxis=!!seriConfig.valueAxis&&seriConfig.valueAxis===config.get("id");const isFirstAxis=config.get("id")===this.visConfig.get("valueAxes[0].id");if(matchingValueAxis||!seriConfig.valueAxis&&isFirstAxis){const axisPoints=seri.values.map(val=>{if(val.y0){return val.y0+val.y}return val.y});return points.concat(axisPoints)}return points},[]);return chartPoints.concat(points)},[]);return chartPoints}getYMin(){return d3_default.a.min(this.getAllPoints())}getYMax(){return d3_default.a.max(this.getAllPoints())}getExtents(){if(this.axisConfig.get("type")==="category"){if(this.axisConfig.isTimeDomain())return this.getTimeDomain(this.values);if(this.axisConfig.isOrdinal())return this.values}const min=this.axisConfig.get("scale.min",this.getYMin());const max=this.axisConfig.get("scale.max",this.getYMax());const domain=[min,max];if(this.axisConfig.isUserDefined())return this.validateUserExtents(domain);if(this.axisConfig.isLogScale())return this.logDomain(min,max);if(this.axisConfig.isYExtents()){const scaleBoundsMargin=this.axisConfig.get("scale.boundsMargin");if(scaleBoundsMargin===0){return domain}else{if(max<0){domain[1]=domain[1]+scaleBoundsMargin}if(min>0){domain[0]=domain[0]-scaleBoundsMargin}return domain}}return[Math.min(0,min),Math.max(0,max)]}getDomain(length){const domain=this.getExtents();const pad=this.axisConfig.get("padForLabels");if(pad>0&&this.canApplyNice()){const domainLength=domain[1]-domain[0];const valuePerPixel=domainLength/length;const padValue=valuePerPixel*pad;if(domain[0]<0){domain[0]-=padValue}domain[1]+=padValue}return domain}getRange(length){if(this.axisConfig.isHorizontal()){return!this.axisConfig.get("scale.inverted")?[0,length]:[length,0]}else{return this.axisConfig.get("scale.inverted")?[0,length]:[length,0]}}throwCustomError(message){throw new Error(message)}throwLogScaleValuesError(){throw new InvalidLogScaleValues}logDomain(min,max){if(min<0||max<0)return this.throwLogScaleValuesError();return[1,max]}getD3Scale(scaleTypeArg){let scaleType=scaleTypeArg||"linear";if(scaleType==="square root")scaleType="sqrt";if(this.axisConfig.isTimeDomain()){return d3_default.a.time.scale.utc()}if(this.axisConfig.isOrdinal())return d3_default.a.scale.ordinal();if(typeof d3_default.a.scale[scaleType]!=="function"){return this.throwCustomError(`Axis.getScaleType: ${scaleType} is not a function`)}return d3_default.a.scale[scaleType]()}canApplyNice(){const config=this.axisConfig;return!config.isUserDefined()&&!config.isYExtents()&&!config.isOrdinal()&&!config.isTimeDomain()}getScale(length){const config=this.axisConfig;const scale=this.getD3Scale(config.getScaleType());const domain=this.getDomain(length);const range=this.getRange(length);const padding=config.get("style.rangePadding");const outerPadding=config.get("style.rangeOuterPadding");this.scale=scale.domain(domain);if(config.isOrdinal()){this.scale.rangeBands(range,padding,outerPadding)}else{this.scale.range(range)}if(this.canApplyNice())this.scale.nice();if(this.scale.clamp)this.scale.clamp(true);this.validateScale(this.scale);if(this.axisConfig.isTimeDomain()){this.scale.timezoneCorrectedTicks=timeTicks(scale)}return this.scale}validateScale(scale){if(!scale||external_osdSharedDeps_Lodash_default.a.isNaN(scale))throw new Error("scale is "+scale)}}const SCALE_MODES={NORMAL:"normal",PERCENTAGE:"percentage",WIGGLE:"wiggle",SILHOUETTE:"silhouette",GROUPED:"grouped",ALL:["normal","percentage","wiggle","silhouette"]};const axis_config_defaults={show:true,type:"value",elSelector:".visAxis__column--{pos} .axis-div",position:"left",scale:{type:"linear",expandLastBucket:true,inverted:false,defaultYExtents:null,boundsMargin:0,setYExtents:null,min:null,max:null,mode:SCALE_MODES.NORMAL},style:{color:"#ddd",lineWidth:"1px",opacity:1,tickColor:"#ddd",tickWidth:"1px",tickLength:"6px",rangePadding:.1,rangeOuterPadding:0},labels:{axisFormatter:null,show:true,rotate:0,rotateAnchor:"center",filter:false,color:"#ddd",font:'"Open Sans", "Lato", "Helvetica Neue", Helvetica, Arial, sans-serif',fontSize:"8pt",truncate:100},title:{text:"",elSelector:".visAxis__column--{pos} .axis-div"},padForLabels:0};const padForLabelsX=40;const padForLabelsY=15;const categoryDefaults={type:"category",position:"bottom"};const valueDefaults={labels:{axisFormatter:d3_default.a.format("n")}};const horizontalDefaults={labels:{rotate:0,rotateAnchor:"end",filter:true,truncate:0}};const verticalDefaults={labels:{rotateAnchor:"middle"}};class axis_config_AxisConfig{constructor(chartConfig,axisConfigArgs){const isCategoryType=axisConfigArgs.type==="category";const typeDefaults=isCategoryType?external_osdSharedDeps_Lodash_default.a.cloneDeep(categoryDefaults):external_osdSharedDeps_Lodash_default.a.cloneDeep(valueDefaults);const axisConfigArgsClone=external_osdSharedDeps_Lodash_default.a.cloneDeep(axisConfigArgs);const isCategoryAxis=axisConfigArgsClone.type==="category";const isHorizontal=axisConfigArgsClone.position&&["top","bottom"].includes(axisConfigArgsClone.position);external_osdSharedDeps_Lodash_default.a.merge(typeDefaults,isHorizontal||isCategoryAxis?horizontalDefaults:verticalDefaults);this._values=external_osdSharedDeps_Lodash_default.a.defaultsDeep({},axisConfigArgsClone,typeDefaults,axis_config_defaults);this._values.elSelector=this._values.elSelector.replace("{pos}",this._values.position);this._values.rootEl=chartConfig.get("el");this.data=chartConfig.data;if(isCategoryAxis){if(!this._values.values){this.values=this.data.xValues(chartConfig.get("orderBucketsBySum",false));this.ordered=this.data.get("ordered")}else{this.values=this._values.values}if(!this._values.labels.axisFormatter){this._values.labels.axisFormatter=this.data.data.xAxisFormatter||this.data.get("xAxisFormatter")}}if(this.get("type")==="value"){const isWiggleOrSilhouette=this.get("scale.mode")===SCALE_MODES.WIGGLE||this.get("scale.mode")===SCALE_MODES.SILHOUETTE;if(isWiggleOrSilhouette){this._values.scale.defaultYExtents=false;if(!axisConfigArgs.show){this._values.show=false;this._values.title.show=true}}if(this.isLogScale()){this._values.labels.filter=true}}if(axisConfigArgs.title==null||axisConfigArgs.title.text==null){const label=isCategoryAxis?"xAxisLabel":"yAxisLabel";this.set("title.text",this.data.get(label))}if(this.isHorizontal()&&this.isOrdinal()){this._values.labels.filter=external_osdSharedDeps_Lodash_default.a.get(axisConfigArgs,"labels.filter",false);this._values.labels.rotate=external_osdSharedDeps_Lodash_default.a.get(axisConfigArgs,"labels.rotate",90);this._values.labels.truncate=external_osdSharedDeps_Lodash_default.a.get(axisConfigArgs,"labels.truncate",100)}if(this.get("type")==="category"&&!this.isHorizontal()){this._values.scale.inverted=external_osdSharedDeps_Lodash_default.a.get(axisConfigArgs,"scale.inverted",true)}if(chartConfig.get("labels.show",false)&&!isCategoryAxis){this._values.padForLabels=isHorizontal?padForLabelsX:padForLabelsY}let offset;let stacked=true;switch(this.get("scale.mode")){case SCALE_MODES.NORMAL:offset="zero";stacked=false;break;case SCALE_MODES.GROUPED:offset="group";stacked=false;break;case SCALE_MODES.PERCENTAGE:offset=function expand(data){const n=data.length;const m=data[0].length;const y0=[];for(let j=0;j<m;++j){let o=0;for(let i=0;i<n;i++){o+=data[i][j][1]}if(o){for(let i=0;i<n;i++){data[i][j][1]/=o}}}for(let j=0;j<m;++j){y0[j]=0}return y0};break;default:offset=this.get("scale.mode")}this.set("scale.offset",external_osdSharedDeps_Lodash_default.a.get(axisConfigArgs,"scale.offset",offset));this.set("scale.stacked",stacked)}get(property,defaults){if(typeof defaults==="undefined"&&!external_osdSharedDeps_Lodash_default.a.has(this._values,property)){throw new Error(`Accessing invalid config property: ${property}`)}const val=external_osdSharedDeps_Lodash_default.a.get(this._values,property,defaults);if(val==null&&defaults!=null)return defaults;return val}set(property,value){return Object(opensearch_safer_lodash_set["set"])(this._values,property,value)}isHorizontal(){return this._values.position==="top"||this._values.position==="bottom"}isOrdinal(){return!!this.values&&!this.isTimeDomain()}isTimeDomain(){return this.ordered&&this.ordered.date}isPercentage(){return this._values.scale.mode===SCALE_MODES.PERCENTAGE}isUserDefined(){return this._values.scale.setYExtents}isYExtents(){return this._values.scale.defaultYExtents}isLogScale(){return this.getScaleType()==="log"}getScaleType(){return this._values.scale.type}}class axis_Axis extends _error_handler_ErrorHandler{constructor(visConfig,axisConfigArgs){super();this.visConfig=visConfig;this.axisConfig=new axis_config_AxisConfig(this.visConfig,axisConfigArgs);if(this.axisConfig.get("type")==="category"){this.values=this.axisConfig.values;this.ordered=this.axisConfig.ordered}this.axisScale=new axis_scale_AxisScale(this.axisConfig,visConfig);this.axisTitle=new axis_title_AxisTitle(this.axisConfig);this.axisLabels=new axis_labels_AxisLabels(this.axisConfig,this.axisScale);this.stack=d3_default.a.layout.stack().x(d=>d.x).y(d=>{if(typeof this.axisConfig.get("scale.offset")==="function"&&this.axisConfig.get("scale.offset").name==="expand"){return Math.abs(d.y)}return d.y}).offset(this.axisConfig.get("scale.offset","zero"));const stackedMode=["normal","grouped"].includes(this.axisConfig.get("scale.mode"));if(stackedMode){this.stack=this._stackNegAndPosVals}}_stackNegAndPosVals(data){const cache={};data.forEach(series=>{series.forEach(value=>{if(!cache[value.x])cache[value.x]=[0,0];value.y0=cache[value.x][value.y<0?0:1];cache[value.x][value.y<0?0:1]+=value.y})});return data}render(){const elSelector=this.axisConfig.get("elSelector");const rootEl=this.axisConfig.get("rootEl");d3_default.a.select(rootEl).selectAll(elSelector).call(this.draw())}destroy(){const elSelector=this.axisConfig.get("elSelector");const rootEl=this.axisConfig.get("rootEl");external_osdSharedDeps_Jquery_default()(rootEl).find(elSelector).find("svg").remove();this.axisTitle.destroy()}getAxis(length){const scale=this.axisScale.getScale(length);const position=this.axisConfig.get("position");const axisFormatter=this.axisConfig.get("labels.axisFormatter");const d3Axis=d3_default.a.svg.axis().scale(scale).tickFormat(axisFormatter).orient(position);if(this.axisConfig.isTimeDomain()){d3Axis.tickValues(scale.timezoneCorrectedTicks(this.tickScale(length)))}else{d3Axis.ticks(this.tickScale(length))}return d3Axis}getScale(){return this.axisScale.scale}addInterval(interval){return this.axisScale.addInterval(interval)}substractInterval(interval){return this.axisScale.substractInterval(interval)}tickScale(length){const yTickScale=d3_default.a.scale.linear().clamp(true).domain([20,40,1e3]).range([0,3,11]);return Math.ceil(yTickScale(length))}getLength(el){if(this.axisConfig.isHorizontal()){return external_osdSharedDeps_Jquery_default()(el).width()}else{return external_osdSharedDeps_Jquery_default()(el).height()}}adjustSize(){const config=this.axisConfig;const style=config.get("style");const chartEl=this.visConfig.get("el");const position=config.get("position");const axisPadding=5;return function(selection){const text=selection.selectAll(".tick text");const lengths=[];text.each((function textWidths(){lengths.push((()=>{if(config.isHorizontal()){return d3_default.a.select(this.parentNode).node().getBBox().height}else{return d3_default.a.select(this.parentNode).node().getBBox().width}})())}));let length=lengths.length>0?external_osdSharedDeps_Lodash_default.a.max(lengths):0;length+=axisPadding;if(config.isHorizontal()){selection.attr("height",Math.ceil(length));if(position==="top"){selection.select("g").attr("transform",`translate(0, ${length-parseInt(style.lineWidth)})`);selection.select("path").attr("transform","translate(1,0)")}if(config.get("type")==="value"){const spacerNodes=external_osdSharedDeps_Jquery_default()(chartEl).find(`.visAxis__spacer--y-${position}`);const elHeight=external_osdSharedDeps_Jquery_default()(chartEl).find(`.visAxis__column--${position}`).height();spacerNodes.height(elHeight)}}else{const axisWidth=Math.ceil(length);selection.attr("width",axisWidth);if(position==="left"){selection.select("g").attr("transform",`translate(${axisWidth},0)`)}}}}validate(){if(this.axisConfig.isLogScale()&&this.axisConfig.isPercentage()){throw new errors_VislibError(`Can't mix percentage mode with log scale.`)}}draw(){const svgs=[];const self=this;const config=this.axisConfig;const style=config.get("style");return function(selection){const n=selection[0].length;if(config.get("show")&&self.axisTitle&&["left","top"].includes(config.get("position"))){self.axisTitle.render(selection)}selection.each((function(){const el=this;const div=d3_default.a.select(el);const width=external_osdSharedDeps_Jquery_default()(el).width();const height=external_osdSharedDeps_Jquery_default()(el).height();const length=self.getLength(el,n);self.validate();const axis=self.getAxis(length);if(config.get("show")){const svg=div.append("svg").attr("focusable","false").attr("width",width).attr("height",height);svgs.push(svg);const axisClass=self.axisConfig.isHorizontal()?"x":"y";svg.append("g").attr("class",`${axisClass} axis ${config.get("id")}`).call(axis);const container=svg.select("g.axis").node();if(container){svg.select("path").style("stroke",style.color).style("stroke-width",style.lineWidth).style("stroke-opacity",style.opacity);svg.selectAll("line").style("stroke",style.tickColor).style("stroke-width",style.tickWidth).style("stroke-opacity",style.opacity)}if(self.axisLabels)self.axisLabels.render(svg)}}));if(self.axisTitle&&["right","bottom"].includes(config.get("position"))){self.axisTitle.render(selection)}svgs.forEach(svg=>svg.call(self.adjustSize()))}}}function _defineProperty(e,r,t){return(r=_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function _toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class binder_Binder{constructor(){_defineProperty(this,"disposal",[])}on(emitter){for(var _len=arguments.length,args=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key]}const on=emitter.on||emitter.addListener;const off=emitter.off||emitter.removeListener;on.apply(emitter,args);this.disposal.push(()=>off.apply(emitter,args))}destroy(){const destroyers=this.disposal;this.disposal=[];destroyers.forEach(fn=>fn())}jqOn(el){for(var _len2=arguments.length,args=new Array(_len2>1?_len2-1:0),_key2=1;_key2<_len2;_key2++){args[_key2-1]=arguments[_key2]}const $el=external_osdSharedDeps_Jquery_default()(el);$el.on(...args);this.disposal.push(()=>$el.off(...args))}fakeD3Bind(el,event,handler){this.jqOn(el,event,e=>{const o=d3_default.a.event;d3_default.a.event=e;try{handler.apply(this,[this.__data__])}finally{d3_default.a.event=o}})}}const OFFSET=10;let $clone;const propDirs={top:"north",left:"west"};function positionTooltip(opts,html){if(!opts)return;const $chart=external_osdSharedDeps_Jquery_default()(opts.$chart);const $el=external_osdSharedDeps_Jquery_default()(opts.$el);const $window=external_osdSharedDeps_Jquery_default()(opts.$window||window);const $sizer=external_osdSharedDeps_Jquery_default()(opts.$sizer);const prev=$chart.data("previousPlacement")||{};const event=opts.event;if(!$chart.length||!$el.length)return;const size=getTtSize(html||$el.html(),$sizer);const pos=getBasePosition(size,event);const overflow=getOverflow(size,pos,[$chart,$window]);const placement=placeToAvoidOverflow(pos,prev,overflow);$chart.data("previousPlacement",placement);return placement}function getTtSize(ttHtml,$sizer){if($sizer.html()!==ttHtml){$sizer.html(ttHtml)}const size={width:$sizer.outerWidth(),height:$sizer.outerHeight()};return size}function getBasePosition(size,event){return{east:event.clientX+OFFSET,west:event.clientX-size.width-OFFSET,south:event.clientY+OFFSET,north:event.clientY-size.height-OFFSET}}function getBounds($el){const bounds=external_osdSharedDeps_Jquery_default.a.isWindow($el[0])?{top:0,left:0}:$el.offset();bounds.top+=$el.scrollTop();bounds.left+=$el.scrollLeft();bounds.bottom=bounds.top+$el.outerHeight();bounds.right=bounds.left+$el.outerWidth();bounds.area=(bounds.bottom-bounds.top)*(bounds.right-bounds.left);return bounds}function getOverflow(size,pos,containers){const overflow={};containers.map(getBounds).sort((function(a,b){return a.area-b.area})).forEach((function(bounds){mergeOverflows(overflow,{north:bounds.top-pos.north,east:pos.east+size.width-bounds.right,south:pos.south+size.height-bounds.bottom,west:bounds.left-pos.west})}));(window.overflows||(window.overflows=[])).push(overflow);return overflow}function mergeOverflows(dest,src){external_osdSharedDeps_Lodash_default.a.mergeWith(dest,src,(function(a,b){if(a==null||b==null)return a||b;if(a<0&&b<0)return Math.min(a,b);return Math.max(a,b)}));if(dest.east&&dest.west&&dest.east>0&&dest.west>0&&(src.east<0||src.west<0)){if(src.east<src.west){dest.east=src.east}else{dest.west=src.west}}}function pickPlacement(prop,pos,overflow,prev,pref,fallback,placement){const stash="_"+prop;const dirs=external_osdSharedDeps_Lodash_default.a.uniq([prev[stash],pref,fallback].filter(Boolean));let dir;let value;for(let i=0;i<dirs.length;i++){dir=dirs[i];if(overflow[dir]>0)continue;value=pos[dir];break}if(value==null){dir=dirs[0];let offset=overflow[dir];if(propDirs[prop]===dir){offset=offset*-1}value=pos[dir]-offset}placement[prop]=value;placement[stash]=dir}function placeToAvoidOverflow(pos,prev,overflow){const placement={};pickPlacement("top",pos,overflow,prev,"south","north",placement);pickPlacement("left",pos,overflow,prev,"east","west",placement);return placement}positionTooltip.getTtSize=getTtSize;positionTooltip.getBasePosition=getBasePosition;positionTooltip.getOverflow=getOverflow;positionTooltip.getBounds=getBounds;positionTooltip.placeToAvoidOverflow=placeToAvoidOverflow;positionTooltip.removeClone=function(){$clone&&$clone.remove();$clone=null};var external_osdSharedDeps_Theme_=__webpack_require__(38);let allContents=[];const tooltipColumnPadding=parseInt(external_osdSharedDeps_Theme_["euiThemeVars"].euiSizeXS||0,10)*2;const tooltipTableMargin=parseInt(external_osdSharedDeps_Theme_["euiThemeVars"].euiSizeS||0,10)*2;const tooltipMaxWidth=parseInt(external_osdSharedDeps_Theme_["euiThemeVars"].euiSizeXL||0,10)*10;function Tooltip(id,el,formatter,events){if(!(this instanceof Tooltip)){return new Tooltip(id,el,formatter,events)}this.id=id;this.el=el;this.order=100;this.formatter=formatter;this.events=events;this.containerClass="visWrapper";this.tooltipClass="visTooltip";this.tooltipSizerClass="visTooltip__sizingClone";this.showCondition=external_osdSharedDeps_Lodash_default.a.constant(true);this.binder=new binder_Binder}Tooltip.prototype.$get=external_osdSharedDeps_Lodash_default.a.once((function(){return external_osdSharedDeps_Jquery_default()("<div>").addClass(this.tooltipClass).appendTo(document.body)}));Tooltip.prototype.$getSizer=external_osdSharedDeps_Lodash_default.a.once((function(){return this.$get().clone().removeClass(this.tooltipClass).addClass(this.tooltipSizerClass).appendTo(document.body)}));Tooltip.prototype.show=function(){const $tooltip=this.$get();const $chart=this.$getChart();const html=$tooltip.html();if(!$chart)return;const placement=positionTooltip({$window:external_osdSharedDeps_Jquery_default()(window),$chart:$chart,$el:$tooltip,$sizer:this.$getSizer(),event:d3_default.a.event},html);$tooltip.css({visibility:"visible",left:placement.left,top:placement.top});const tooltipColumns=$tooltip.find("tbody > tr:nth-of-type(1) > td").length;if(tooltipColumns===2){const tooltipWidth=$tooltip.outerWidth();const valueColumn=$tooltip.find("tr:nth-of-type(1) > td:nth-child(2)");if(valueColumn.length!==1){return}const valueColumnSize=valueColumn.outerWidth();const isGratherThanHalf=valueColumnSize>tooltipWidth/2;const containerMaxWidth=isGratherThanHalf?tooltipWidth/2-tooltipTableMargin-tooltipColumnPadding*2:tooltipWidth-valueColumnSize-tooltipTableMargin-tooltipColumnPadding;$tooltip.find(".visTooltip__labelContainer").css({"max-width":containerMaxWidth});if(isGratherThanHalf&&tooltipWidth===tooltipMaxWidth){$tooltip.find(".visTooltip__valueContainer").css({"max-width":containerMaxWidth})}}else if(tooltipColumns===3){const tooltipWidth=$tooltip.outerWidth();const valueColumn=$tooltip.find("tr:nth-of-type(1) > td:nth-child(3)");if(valueColumn.length!==1){return}const valueColumnSize=valueColumn.outerWidth();const containerMaxWidth=(tooltipWidth-valueColumnSize-tooltipTableMargin)/2-tooltipColumnPadding;$tooltip.find(".visTooltip__labelContainer").css({"max-width":containerMaxWidth})}};Tooltip.prototype.hide=function(){const $tooltip=this.$get();allContents=[];$tooltip.css({visibility:"hidden",left:"-500px",top:"-500px"})};Tooltip.prototype.$getChart=function(){const chart=external_osdSharedDeps_Jquery_default()(this.container&&this.container.node());return chart.length?chart:false};Tooltip.prototype.render=function(){const self=this;return function(selection){const $tooltip=self.$get();const id=self.id;const order=self.order;if(self.container===undefined||self.container!==d3_default.a.select(self.el).select("."+self.containerClass)){self.container=d3_default.a.select(self.el).select("."+self.containerClass)}const $chart=self.$getChart();if($chart){self.binder.jqOn($chart,"mouseleave",(function(){$chart.removeData("previousPlacement")}))}selection.each((function(d,i){const element=d3_default.a.select(this);function render(html){allContents=external_osdSharedDeps_Lodash_default.a.filter(allContents,(function(content){return content.id!==id}));if(html)allContents.push({id:id,html:html,order:order});const allHtml=external_osdSharedDeps_Lodash_default()(allContents).sortBy("order").map("html").compact().join("\n");if(allHtml){$tooltip.html(allHtml);self.show()}else{self.hide()}}self.binder.fakeD3Bind(this,"mousemove",(function(){if(!self.showCondition.call(element,d,i)){return render()}const events=self.events?self.events.eventResponse(d,i):d;return render(self.formatter(events))}));self.binder.fakeD3Bind(this,"mouseleave",(function(){render()}))}))}};Tooltip.prototype.destroy=function(){this.hide();this.binder.destroy()};var external_osdSharedDeps_React_=__webpack_require__(0);var external_osdSharedDeps_React_default=__webpack_require__.n(external_osdSharedDeps_React_);var external_osdSharedDeps_ElasticNumeral_=__webpack_require__(36);var external_osdSharedDeps_ElasticNumeral_default=__webpack_require__.n(external_osdSharedDeps_ElasticNumeral_);var external_osdSharedDeps_ReactDomServer_=__webpack_require__(37);var external_osdSharedDeps_OsdI18nReact_=__webpack_require__(6);function collectBranch(leaf){function walk(item,memo){const depth=item.depth-1;function getFieldName(i){if(i.rawData&&i.rawData.column>-1){const{column:column,table:table}=i.rawData;return table.columns[column].name}return i.name||`level ${i.depth}`}memo.unshift({depth:depth,field:getFieldName(item),bucket:item.name,metric:item.size,item:item});if(item.parent&&item.parent.parent){return walk(item.parent,memo)}else{return memo}}return walk(leaf,[])}function hierarchicalTooltipFormatter(metricFieldFormatter){return function(_ref){let{datum:datum}=_ref;const rows=collectBranch(datum);external_osdSharedDeps_Lodash_default.a.forEachRight(rows,(function(row){row.spacer=external_osdSharedDeps_Lodash_default.a.escape(external_osdSharedDeps_Lodash_default.a.repeat("&nbsp;",row.depth));let percent;if(row.item.percentOfGroup!==null&&row.item.percentOfGroup!==undefined){percent=row.item.percentOfGroup}row.metric=metricFieldFormatter?metricFieldFormatter.convert(row.metric):row.metric;if(percent!==null&&percent!==undefined){row.metric+=" ("+external_osdSharedDeps_ElasticNumeral_default()(percent).format("0.[00]%")+")"}return row}));return Object(external_osdSharedDeps_ReactDomServer_["renderToStaticMarkup"])(external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_OsdI18nReact_["I18nProvider"],null,external_osdSharedDeps_React_default.a.createElement("table",{className:"visTooltip__table"},external_osdSharedDeps_React_default.a.createElement("thead",null,external_osdSharedDeps_React_default.a.createElement("tr",{className:"eui-textLeft visTooltip__label"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_OsdI18nReact_["FormattedMessage"],{tagName:"th",scope:"col",id:"visTypeVislib.vislib.tooltip.fieldLabel",defaultMessage:"field"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_OsdI18nReact_["FormattedMessage"],{tagName:"th",scope:"col",id:"visTypeVislib.vislib.tooltip.valueLabel",defaultMessage:"value"}),external_osdSharedDeps_React_default.a.createElement("th",{scope:"col"}))),external_osdSharedDeps_React_default.a.createElement("tbody",null,rows.map((row,index)=>external_osdSharedDeps_React_default.a.createElement("tr",{className:"visTooltip__value",key:index},external_osdSharedDeps_React_default.a.createElement("td",null,external_osdSharedDeps_React_default.a.createElement("div",{className:"visTooltip__labelContainer"},row.field)),external_osdSharedDeps_React_default.a.createElement("td",null,external_osdSharedDeps_React_default.a.createElement("div",{className:"visTooltip__labelContainer"},row.bucket)),external_osdSharedDeps_React_default.a.createElement("td",null,row.metric)))))))}}function pointSeriesTooltipFormatter(){return function tooltipFormatter(_ref){let{datum:datum,data:data}=_ref;if(!datum)return"";const details=[];const currentSeries=data.series&&data.series.find(series=>series.rawId===datum.seriesId);const addDetail=(label,value)=>details.push({label:label,value:value});if(datum.extraMetrics){datum.extraMetrics.forEach(metric=>{addDetail(metric.label,metric.value)})}if(datum.x!==null&&datum.x!==undefined){addDetail(data.xAxisLabel,data.xAxisFormatter(datum.x))}if(datum.y!==null&&datum.y!==undefined){var _datum$yRaw;const value=datum.yScale?datum.yScale*datum.y:datum.y;let label=currentSeries.label;const tableColumns=datum===null||datum===void 0||(_datum$yRaw=datum.yRaw)===null||_datum$yRaw===void 0||(_datum$yRaw=_datum$yRaw.table)===null||_datum$yRaw===void 0?void 0:_datum$yRaw.columns;if(tableColumns&&tableColumns.length>2){const yColumn=datum.yRaw.column?tableColumns[datum.yRaw.column]:{};label=yColumn.name||label}addDetail(label,currentSeries.yAxisFormatter(value))}if(datum.z!==null&&datum.z!==undefined){addDetail(currentSeries.zLabel,currentSeries.zAxisFormatter(datum.z))}if(datum.series&&datum.parent){const dimension=datum.parent;addDetail(dimension.title,datum.series)}if(datum.tableRaw){addDetail(datum.tableRaw.title,datum.tableRaw.value)}return Object(external_osdSharedDeps_ReactDomServer_["renderToStaticMarkup"])(external_osdSharedDeps_React_default.a.createElement("table",null,external_osdSharedDeps_React_default.a.createElement("tbody",null,details.map((detail,index)=>external_osdSharedDeps_React_default.a.createElement("tr",{key:index},external_osdSharedDeps_React_default.a.createElement("td",{className:"visTooltip__label"},external_osdSharedDeps_React_default.a.createElement("div",{className:"visTooltip__labelContainer"},detail.label)),external_osdSharedDeps_React_default.a.createElement("td",{className:"visTooltip__value"},external_osdSharedDeps_React_default.a.createElement("div",{className:"visTooltip__valueContainer"},detail.value,detail.percent&&external_osdSharedDeps_React_default.a.createElement("span",null," (",detail.percent,")"))))))))}}class chart_title_ChartTitle extends _error_handler_ErrorHandler{constructor(visConfig){super();this.el=visConfig.get("el");this.tooltip=new Tooltip("chart-title",this.el,(function(d){return"<p>"+external_osdSharedDeps_Lodash_default.a.escape(d.label)+"</p>"}))}render(){const el=d3_default.a.select(this.el).select(".chart-title").node();const width=el?el.clientWidth:0;const height=el?el.clientHeight:0;return d3_default.a.select(this.el).selectAll(".chart-title").call(this.draw(width,height))}truncate(size){const self=this;return function(selection){selection.each((function(){const text=d3_default.a.select(this);const n=text[0].length;const maxWidth=size/n*.9;const length=this.getComputedTextLength();let str;let avg;let end;if(length>maxWidth){str=text.text();avg=length/str.length;end=Math.floor(maxWidth/avg)-5;str=str.substr(0,end)+"...";self.addMouseEvents(text);return text.text(str)}return text.text()}))}}addMouseEvents(target){if(this.tooltip){return target.call(this.tooltip.render())}}draw(width,height){const self=this;return function(selection){selection.each((function(){const div=d3_default.a.select(this);const dataType=this.parentNode.__data__.rows?"rows":"columns";const size=dataType==="rows"?height:width;const txtHtOffset=11;self.validateWidthandHeight(width,height);div.append("svg").attr("focusable","false").attr("width",width).attr("height",height).append("text").attr("transform",(function(){if(dataType==="rows"){return"translate("+txtHtOffset+","+height/2+")rotate(270)"}return"translate("+width/2+","+txtHtOffset+")"})).attr("text-anchor","middle").text((function(d){return d.label}));div.selectAll("text").call(self.truncate(size))}))}}}class layout_Layout{constructor(config){this.el=config.get("el");this.data=config.data.data;this.opts=config;this.layoutType=layoutTypes[config.get("type")](this.el,this.data)}render(){this.removeAll(this.el);this.createLayout(this.layoutType);if(this.opts.get("type")==="point_series"){this.updateCategoryAxisSize()}}createLayout(arr){return external_osdSharedDeps_Lodash_default.a.each(arr,obj=>{this.layout(obj)})}updateCategoryAxisSize(){const visConfig=this.opts;const axisConfig=visConfig.get("categoryAxes[0]");const axis=new axis_Axis(visConfig,axisConfig);const position=axis.axisConfig.get("position");const chartTitle=new chart_title_ChartTitle(visConfig);const axisWrapperElement=external_osdSharedDeps_Jquery_default()(this.el).find(`.visAxis__column--${position}`);axisWrapperElement.css("visibility","hidden");axis.render();chartTitle.render();const width=axisWrapperElement.width();const height=axisWrapperElement.height();axis.destroy();external_osdSharedDeps_Jquery_default()(this.el).find(".chart-title svg").remove();axisWrapperElement.css("visibility","");if(axis.axisConfig.isHorizontal()){const spacerNodes=external_osdSharedDeps_Jquery_default()(this.el).find(`.visAxis__spacer--y-${position}`);spacerNodes.height(`${height}px`)}else{axisWrapperElement.find(".visAxis__splitAxes--y").width(`${width}px`)}}layout(obj){if(!obj.parent){throw new Error("No parent element provided")}if(!obj.type){throw new Error("No element type provided")}if(typeof obj.type!=="string"){throw new Error(obj.type+" must be a string")}if(typeof obj.parent==="string"&&obj.parent.charAt(0)!=="."){obj.parent="."+obj.parent}const childEl=this.appendElem(obj.parent,obj.type,obj.class);if(obj.datum){childEl.datum(obj.datum)}if(obj.splits){childEl.call(obj.splits,obj.parent,this.opts)}if(obj.children){const newParent=childEl[0][0];external_osdSharedDeps_Lodash_default.a.forEach(obj.children,(function(obj){if(!obj.parent){obj.parent=newParent}}));this.createLayout(obj.children)}return childEl}appendElem(el,type,className){if(!el||!type||!className){throw new Error("Function requires that an el, type, and class be provided")}if(typeof el==="string"){el=d3_default.a.select(this.el).select(el)[0][0]}return d3_default.a.select(el).append(type).attr("class",className)}removeAll(el){return d3_default.a.select(el).selectAll("*").remove()}}class alerts_Alerts{constructor(vis,alertDefs){this.vis=vis;this.data=vis.data;this.alertDefs=external_osdSharedDeps_Lodash_default.a.cloneDeep(alertDefs);this.alerts=external_osdSharedDeps_Lodash_default()(alertDefs).map(alertDef=>{if(!alertDef)return;if(alertDef.test&&!alertDef.test(vis,this.data))return;return this._addAlert(alertDef)}).compact()}_addAlert(alertDef){const type=alertDef.type||"info";const icon=alertDef.icon||type;const msg=alertDef.msg;const $icon=external_osdSharedDeps_Jquery_default()("<i>").addClass("visAlerts__icon fa fa-"+icon);const $text=external_osdSharedDeps_Jquery_default()("<p>").addClass("visAlerts__text").text(msg);const $closeIcon=external_osdSharedDeps_Jquery_default()("<i>").addClass("fa fa-close");const $closeDiv=external_osdSharedDeps_Jquery_default()("<div>").addClass("visAlerts__close").append($closeIcon);const $alert=external_osdSharedDeps_Jquery_default()("<div>").addClass("visAlert visAlert--"+type).append([$icon,$text,$closeDiv]);$closeDiv.on("click",()=>{$alert.remove()});return $alert}render(){const alerts=this.alerts;const vis=this.vis;external_osdSharedDeps_Jquery_default()(vis.element).find(".visWrapper__alerts").append(external_osdSharedDeps_Jquery_default()("<div>").addClass("visAlerts__tray"));if(!alerts.size())return;external_osdSharedDeps_Jquery_default()(vis.element).find(".visAlerts__tray").append(alerts.value())}show(msg,type){const vis=this.vis;const alert={msg:msg,type:type};if(this.alertDefs.find(alertDef=>alertDef.msg===alert.msg))return;this.alertDefs.push(alert);external_osdSharedDeps_Jquery_default()(vis.element).find(".visAlerts__tray").append(this._addAlert(alert))}destroy(){external_osdSharedDeps_Jquery_default()(this.vis.element).find(".visWrapper__alerts").remove()}}const chart_grid_defaults={style:{color:"rgba(105,112,125,0.2)"},categoryLines:false,valueAxis:undefined};class chart_grid_ChartGrid{constructor(handler,gridConfig){if(!gridConfig)return;this._handler=handler;this._values=external_osdSharedDeps_Lodash_default.a.defaultsDeep({},gridConfig,chart_grid_defaults)}drawLine(svg,tick,axis,width,height){const isHorizontal=axis.axisConfig.isHorizontal();const scale=axis.getScale();svg.append("path").attr("d",()=>{const x0=isHorizontal?tick:0;const x1=isHorizontal?tick:width;const y0=!isHorizontal?tick:0;const y1=!isHorizontal?tick:height;const d3Line=d3_default.a.svg.line().x(d=>isHorizontal?scale(d[0]):d[0]).y(d=>!isHorizontal?scale(d[1]):d[1]);return d3Line([[x0,y0],[x1,y1]])}).attr("fill","none").attr("stroke",this.get("style.color")).attr("stroke-width",1)}drawCategoryLines(svg,width,height){const axis=this._handler.categoryAxes[0];if(!axis)return;const ticks=axis.getScale().ticks;if(!ticks)return;ticks().forEach(tick=>{this.drawLine(svg,tick,axis,width,height)})}drawValueLines(svg,width,height){const axis=this._handler.valueAxes.find(axis=>axis.axisConfig.get("id")===this.get("valueAxis"));if(!axis)return;const ticks=axis.getScale().ticks;if(!ticks)return;ticks().forEach(tick=>{this.drawLine(svg,tick,axis,width,height)})}draw(width,height){const self=this;return function(selection){if(!self._values)return;selection.each((function(){if(self.get("categoryLines"))self.drawCategoryLines(d3_default.a.select(this),width,height);if(self.get("valueAxis",false))self.drawValueLines(d3_default.a.select(this),width,height)}))}}get(property,defaults){if(external_osdSharedDeps_Lodash_default.a.has(this._values,property)||typeof defaults!=="undefined"){return external_osdSharedDeps_Lodash_default.a.get(this._values,property,defaults)}else{throw new Error(`Accessing invalid config property: ${property}`);return defaults}}set(property,value){return Object(opensearch_safer_lodash_set["set"])(this._values,property,value)}}function dataLabel(selection,label){d3_default.a.select(selection).attr("data-label",label)}const DIMMING_OPACITY_SETTING="visualization:dimmingOpacity";const HEATMAP_MAX_BUCKETS_SETTING="visualization:heatmap:maxBuckets";function dispatch_defineProperty(e,r,t){return(r=dispatch_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function dispatch_toPropertyKey(t){var i=dispatch_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function dispatch_toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class dispatch_Dispatch{constructor(handler,uiSettings){dispatch_defineProperty(this,"emit",Object(external_osdSharedDeps_Lodash_["rest"])((function(name,args){if(!this._listeners[name]){return this}const listeners=this.listeners(name);let i=-1;while(++i<listeners.length){listeners[i].apply(this,args)}return this})));this.handler=handler;this.uiSettings=uiSettings;this._listeners={}}on(name,handler){let handlers=this._listeners[name];if(!handlers){this._listeners[name]=[];handlers=this._listeners[name]}handlers.push(handler);return this}off(name,handler){if(!this._listeners[name]){return this}if(handler){Object(external_osdSharedDeps_Lodash_["pull"])(this._listeners[name],handler)}else{this._listeners[name]=null}return this}removeAllListeners(){this._listeners={};return this}listeners(name){return this._listeners[name]?this._listeners[name].slice(0):[]}listenerCount(name){if(name){return Object(external_osdSharedDeps_Lodash_["size"])(this._listeners[name])}return Object(external_osdSharedDeps_Lodash_["reduce"])(this._listeners,(count,handlers)=>count+Object(external_osdSharedDeps_Lodash_["size"])(handlers),0)}_pieClickResponse(data){const points=[];let dataPointer=data;while(dataPointer&&dataPointer.rawData){points.push(dataPointer.rawData);dataPointer=dataPointer.parent}if(Object(external_osdSharedDeps_Lodash_["get"])(data,"rawData.table.$parent")){const{table:table,column:column,row:row,key:key}=Object(external_osdSharedDeps_Lodash_["get"])(data,"rawData.table.$parent");points.push({table:table,column:column,row:row,value:key})}return points}_seriesClickResponse(data){const points=[];["xRaw","yRaw","zRaw","seriesRaw","rawData","tableRaw"].forEach(val=>{if(data[val]&&data[val].column!==undefined&&data[val].row!==undefined){points.push(data[val])}});return points}clickEventResponse(d){let props=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};let isSlices=props.isSlices;if(isSlices===undefined){const _data=d3_default.a.event.target.nearestViewportElement?d3_default.a.event.target.nearestViewportElement.__data__:d3_default.a.event.target.__data__;isSlices=!!(_data&&_data.slices)}const data=d.input||d;return{e:d3_default.a.event,data:isSlices?this._pieClickResponse(data):this._seriesClickResponse(data)}}_isSeriesInPercentageMode(rawId,series,visConfig){if(!rawId||!Array.isArray(series)||!visConfig){return false}const{id:id}=series.find(series=>series.rawId===rawId);if(!id){return false}const seriesParams=visConfig.get("seriesParams",[]);const{valueAxis:valueAxisId}=seriesParams.find(param=>param.data.id===id)||{};if(!valueAxisId){return false}const usedValueAxis=visConfig.get("valueAxes",[]).find(valueAxis=>valueAxis.id===valueAxisId);return Object(external_osdSharedDeps_Lodash_["get"])(usedValueAxis,"scale.mode")==="percentage"}eventResponse(d,i){const datum=d._input||d;const data=d3_default.a.event.target.nearestViewportElement?d3_default.a.event.target.nearestViewportElement.__data__:d3_default.a.event.target.__data__;const label=d.label?d.label:d.series||"Count";const isSeries=!!(data&&data.series);const isSlices=!!(data&&data.slices);const series=isSeries?data.series:undefined;const slices=isSlices?data.slices:undefined;const handler=this.handler;const color=Object(external_osdSharedDeps_Lodash_["get"])(handler,"data.color");const config=handler&&handler.visConfig;const isPercentageMode=this._isSeriesInPercentageMode(d.seriesId,series,config);const eventData={value:d.y,point:datum,datum:datum,label:label,color:color?color(label):undefined,pointIndex:i,series:series,slices:slices,config:config,data:data,e:d3_default.a.event,handler:handler,isPercentageMode:isPercentageMode};return eventData}addEvent(event,callback){return function(selection){selection.each((function(){const element=d3_default.a.select(this);if(typeof callback==="function"){return element.on(event,callback)}}))}}addHoverEvent(){const self=this;const isClickable=this.listenerCount("click")>0;const addEvent=this.addEvent;const $el=this.handler.el;if(!this.handler.highlight){this.handler.highlight=self.getHighlighter(self.uiSettings)}function hover(d,i){if(isClickable){self.addMousePointer.call(this,arguments)}self.handler.highlight.call(this,$el);self.emit("hover",self.eventResponse(d,i))}return addEvent("mouseover",hover)}addMouseoutEvent(){const self=this;const addEvent=this.addEvent;const $el=this.handler.el;if(!this.handler.unHighlight){this.handler.unHighlight=self.unHighlight}function mouseout(){self.handler.unHighlight.call(this,$el)}return addEvent("mouseout",mouseout)}addClickEvent(){const onClick=d=>this.emit("click",this.clickEventResponse(d));return this.addEvent("click",onClick)}allowBrushing(){const xAxis=this.handler.categoryAxes[0];return Boolean(xAxis.ordered)}isBrushable(){return this.allowBrushing()&&this.listenerCount("brush")>0}addBrushEvent(svg){if(!this.isBrushable())return;const xScale=this.handler.categoryAxes[0].getScale();this.createBrush(xScale,svg)}addMousePointer(){return d3_default.a.select(this).style("cursor","pointer")}getHighlighter(uiSettings){return function highlight(element){const label=this.getAttribute("data-label");if(!label)return;const dimming=uiSettings.get(DIMMING_OPACITY_SETTING);external_osdSharedDeps_Jquery_default()(element).parent().find("[data-label]").css("opacity",1).not((els,el)=>String(external_osdSharedDeps_Jquery_default()(el).data("label"))===label).css("opacity",justifyOpacity(dimming))}}unHighlight(element){external_osdSharedDeps_Jquery_default()("[data-label]",element.parentNode).css("opacity",1)}createBrush(xScale,svg){const self=this;const visConfig=self.handler.visConfig;const{width:width,height:height}=svg.node().getBBox();const isHorizontal=self.handler.categoryAxes[0].axisConfig.isHorizontal();const brush=d3_default.a.svg.brush();if(isHorizontal){brush.x(xScale)}else{brush.y(xScale)}brush.on("brushend",(function brushEnd(){const data=d3_default.a.select(this).data()[0];const isTimeSeries=data.ordered&&data.ordered.date;const selected=xScale.domain().filter(d=>brush.extent()[0]<=xScale(d)&&xScale(d)<=brush.extent()[1]);const range=isTimeSeries?brush.extent():selected;return self.emit("brush",{range:range,config:visConfig,e:d3_default.a.event,data:data})}));if(self.listenerCount("brush")){const rect=svg.insert("g","g").attr("class","brush").call(brush).call(brushG=>{const brushHandler=brushG.on("mousedown.brush");if(!brushHandler)return;brushG.on("mousedown.brush",(function(){if(validBrushClick(d3_default.a.event))brushHandler.apply(this,arguments)}))}).selectAll("rect");if(isHorizontal){rect.attr("height",height)}else{rect.attr("width",width)}return brush}}}function validBrushClick(event){return event.button===0}function justifyOpacity(opacity){const decimalNumber=parseFloat(opacity,10);const fallbackOpacity=.5;return 0<=decimalNumber&&decimalNumber<=1?decimalNumber:fallbackOpacity}class _chart_Chart{constructor(handler,element,chartData,deps){this.handler=handler;this.chartEl=element;this.chartData=chartData;this.tooltips=[];const events=this.events=new dispatch_Dispatch(handler,deps.uiSettings);const fieldFormatter=Object(services["b"])().deserialize(this.handler.data.get("tooltipFormatter"));const tooltipFormatterProvider=this.handler.visConfig.get("type")==="pie"?hierarchicalTooltipFormatter:pointSeriesTooltipFormatter;const tooltipFormatter=tooltipFormatterProvider(fieldFormatter);if(this.handler.visConfig&&this.handler.visConfig.get("addTooltip",false)){const element=this.handler.el;this.tooltip=new Tooltip("chart",element,tooltipFormatter,events);this.tooltips.push(this.tooltip)}this._addIdentifier=external_osdSharedDeps_Lodash_default.a.bind(this._addIdentifier,this)}render(){const selection=d3_default.a.select(this.chartEl);selection.selectAll("*").remove();selection.call(this.draw())}_addIdentifier(selection,labelProp){labelProp=labelProp||"label";const labels=this.handler.data.labels;function resolveLabel(datum){if(labels.length===1)return labels[0];if(datum[0])return datum[0][labelProp];return datum[labelProp]}selection.each((function(datum){const label=resolveLabel(datum);if(label!=null)dataLabel(this,label)}))}destroy(){const selection=d3_default.a.select(this.chartEl);this.events.removeAllListeners();this.tooltips.forEach((function(tooltip){tooltip.destroy()}));selection.remove()}}var target=__webpack_require__(170);var target_default=__webpack_require__.n(target);class time_marker_TimeMarker{constructor(times,xScale,height){const currentTimeArr=[{time:(new Date).getTime(),class:"time-marker",color:"#c80000",opacity:.3,width:2}];this.xScale=xScale;this.height=height;this.times=times.length?times.map((function(d){return{time:target_default.a.parse(d.time),class:d.class||"time-marker",color:d.color||"#c80000",opacity:d.opacity||.3,width:d.width||2}})):currentTimeArr}_isTimeBasedChart(selection){const data=selection.data();return data.every((function(datum){return datum.ordered&&datum.ordered.date}))}render(selection){const self=this;if(!self._isTimeBasedChart(selection))return;selection.each((function(){d3_default.a.select(this).selectAll("time-marker").data(self.times).enter().append("line").attr("class",(function(d){return d.class})).attr("pointer-events","none").attr("stroke",(function(d){return d.color})).attr("stroke-width",(function(d){return d.width})).attr("stroke-opacity",(function(d){return d.opacity})).attr("x1",(function(d){return self.xScale(d.time)})).attr("x2",(function(d){return self.xScale(d.time)})).attr("y1",self.height).attr("y2",self.xScale.range()[0])}))}}var external_osdSharedDeps_ElasticEuiLibServices_=__webpack_require__(11);const thresholdLineDefaults={show:false,value:10,width:1,style:"full",color:Object(external_osdSharedDeps_ElasticEuiLibServices_["euiPaletteColorBlind"])()[9]};class _point_series_PointSeries{constructor(handler,seriesEl,seriesData,seriesConfig){this.handler=handler;this.baseChart=handler.pointSeries;this.chartEl=seriesEl;this.chartData=seriesData;this.seriesConfig=seriesConfig;this.thresholdLineOptions=external_osdSharedDeps_Lodash_default.a.defaults(handler.visConfig.get("thresholdLine",{}),thresholdLineDefaults)}getGroupedCount(){const stacks=[];return this.baseChart.chartConfig.series.reduce((sum,series)=>{const valueAxis=series.valueAxis||this.baseChart.handler.valueAxes[0].id;const isStacked=series.mode==="stacked";const isHistogram=series.type==="histogram";if(!isHistogram)return sum;if(isStacked&&stacks.includes(valueAxis))return sum;if(isStacked)stacks.push(valueAxis);return sum+1},0)}getGroupedNum(seriesId){let i=0;const stacks=[];for(const seri of this.baseChart.chartConfig.series){const valueAxis=seri.valueAxis||this.baseChart.handler.valueAxes[0].id;const isStacked=seri.mode==="stacked";if(!isStacked){if(seri.data.rawId===seriesId)return i;i++}else{if(!(valueAxis in stacks))stacks[valueAxis]=i++;if(seri.data.rawId===seriesId)return stacks[valueAxis]}}return 0}getValueAxis(){return external_osdSharedDeps_Lodash_default.a.find(this.handler.valueAxes,axis=>axis.axisConfig.get("id")===this.seriesConfig.valueAxis)||this.handler.valueAxes[0]}getCategoryAxis(){return external_osdSharedDeps_Lodash_default.a.find(this.handler.categoryAxes,axis=>axis.axisConfig.get("id")===this.seriesConfig.categoryAxis)||this.handler.categoryAxes[0]}addCircleEvents(element){const events=this.events;if(this.handler.visConfig.get("enableHover")){const hover=events.addHoverEvent();const mouseout=events.addMouseoutEvent();element.call(hover).call(mouseout)}const click=events.addClickEvent();return element.call(click)}addThresholdLine(svgElem){const chartData=this.chartData;const isHorizontal=this.getCategoryAxis().axisConfig.isHorizontal();const valueAxisDomain=this.getValueAxis().axisScale.getDomain(chartData.values.length);const yScale=this.getValueAxis().getScale();const svgParentWidth=svgElem[0][0].attributes.width.value;const svgParentHeight=svgElem[0][0].attributes.height.value;const thresholdLineWidth=this.thresholdLineOptions.width;let thresholdLineStyle="0";if(this.thresholdLineOptions.style==="dashed"){thresholdLineStyle="10,5"}else if(this.thresholdLineOptions.style==="dot-dashed"){thresholdLineStyle="20,5,5,5"}const thresholdValue=this.thresholdLineOptions.value;const lineColor=this.thresholdLineOptions.color;function y(y){return yScale(y)}if(valueAxisDomain&&valueAxisDomain[0]<=thresholdValue&&valueAxisDomain[1]>=thresholdValue){svgElem.append("line").attr("x1",isHorizontal?0:y(thresholdValue)).attr("y1",isHorizontal?y(thresholdValue):0).attr("x2",isHorizontal?svgParentWidth:y(thresholdValue)).attr("y2",isHorizontal?y(thresholdValue):svgParentHeight).attr("stroke-width",thresholdLineWidth).attr("stroke-dasharray",thresholdLineStyle).attr("stroke",lineColor)}}}const column_chart_defaults={mode:"normal",showTooltip:true,color:undefined,fillColor:undefined,showLabel:true};function datumWidth(defaultWidth,datum,nextDatum,scale,gutterWidth){let groupCount=arguments.length>5&&arguments[5]!==undefined?arguments[5]:1;let datumWidth=defaultWidth;if(nextDatum){datumWidth=(scale(nextDatum.x)-scale(datum.x)-gutterWidth)/groupCount;if(datumWidth>defaultWidth){datumWidth=defaultWidth}}return datumWidth}class column_chart_ColumnChart extends _point_series_PointSeries{constructor(handler,chartEl,chartData,seriesConfigArgs,deps){super(handler,chartEl,chartData,seriesConfigArgs,deps);this.seriesConfig=external_osdSharedDeps_Lodash_default.a.defaults(seriesConfigArgs||{},column_chart_defaults);this.labelOptions=external_osdSharedDeps_Lodash_default.a.defaults(handler.visConfig.get("labels",{}),column_chart_defaults.showLabel)}addBars(svg,data){const self=this;const color=this.handler.data.getColorFunc();const tooltip=this.baseChart.tooltip;const isTooltip=this.handler.visConfig.get("tooltip.show");const layer=svg.append("g").attr("class","series histogram").attr("clip-path","url(#"+this.baseChart.clipPathId+")");const bars=layer.selectAll("rect").data(data.values.filter((function(d){return!external_osdSharedDeps_Lodash_default.a.isNull(d.y)})));bars.exit().remove();bars.enter().append("rect").attr("data-label",data.label).attr("fill",()=>color(data.label)).attr("stroke",()=>color(data.label));self.updateBars(bars);if(isTooltip){bars.call(tooltip.render())}return bars}updateBars(bars){if(this.seriesConfig.mode==="stacked"){return this.addStackedBars(bars)}return this.addGroupedBars(bars)}addStackedBars(bars){const xScale=this.getCategoryAxis().getScale();const yScale=this.getValueAxis().getScale();const isHorizontal=this.getCategoryAxis().axisConfig.isHorizontal();const isTimeScale=this.getCategoryAxis().axisConfig.isTimeDomain();const isLabels=this.labelOptions.show;const yMin=yScale.domain()[0];const gutterSpacingPercentage=.15;const chartData=this.chartData;const getGroupedNum=this.getGroupedNum.bind(this);const groupCount=this.getGroupedCount();let barWidth;let gutterWidth;if(isTimeScale){const{min:min,interval:interval}=this.handler.data.get("ordered");let intervalWidth=xScale(min+interval)-xScale(min);intervalWidth=Math.abs(intervalWidth);gutterWidth=intervalWidth*gutterSpacingPercentage;barWidth=(intervalWidth-gutterWidth)/groupCount}function x(d,i){const groupNum=getGroupedNum(d.seriesId);if(isTimeScale){return xScale(d.x)+datumWidth(barWidth,d,bars.data()[i+1],xScale,gutterWidth,groupCount)*groupNum}return xScale(d.x)+xScale.rangeBand()/groupCount*groupNum}function y(d){if(isHorizontal&&d.y<0||!isHorizontal&&d.y>0){return yScale(d.y0)}return yScale(d.y0+d.y)}function labelX(d,i){return x(d,i)+widthFunc(d,i)/2}function labelY(d){return y(d)+heightFunc(d)/2}function labelDisplay(d,i){if(isHorizontal&&this.getBBox().width>widthFunc(d,i))return"none";if(!isHorizontal&&this.getBBox().width>heightFunc(d))return"none";if(isHorizontal&&this.getBBox().height>heightFunc(d))return"none";if(!isHorizontal&&this.getBBox().height>widthFunc(d,i))return"none";return"block"}function widthFunc(d,i){if(isTimeScale){return datumWidth(barWidth,d,bars.data()[i+1],xScale,gutterWidth,groupCount)}return xScale.rangeBand()/groupCount}function heightFunc(d){if(d.y0===0&&yMin>0){return yScale(yMin)-yScale(d.y)}return Math.abs(yScale(d.y0)-yScale(d.y0+d.y))}function formatValue(d){return chartData.yAxisFormatter(d.y)}bars.attr("x",isHorizontal?x:y).attr("width",isHorizontal?widthFunc:heightFunc).attr("y",isHorizontal?y:x).attr("height",isHorizontal?heightFunc:widthFunc);const layer=d3_default.a.select(bars[0].parentNode);const barLabels=layer.selectAll("text").data(chartData.values.filter((function(d){return!external_osdSharedDeps_Lodash_default.a.isNull(d.y)})));if(isLabels){const colorFunc=this.handler.data.getColorFunc();const d3Color=d3_default.a.rgb(colorFunc(chartData.label));let labelClass;if(Object(external_osdSharedDeps_ElasticEuiLibServices_["isColorDark"])(d3Color.r,d3Color.g,d3Color.b)){labelClass="visColumnChart__bar-label--light"}else{labelClass="visColumnChart__bar-label--dark"}barLabels.enter().append("text").text(formatValue).attr("class",`visColumnChart__barLabel visColumnChart__barLabel--stack ${labelClass}`).attr("x",isHorizontal?labelX:labelY).attr("y",isHorizontal?labelY:labelX).attr("display",labelDisplay)}return bars}addGroupedBars(bars){const xScale=this.getCategoryAxis().getScale();const yScale=this.getValueAxis().getScale();const chartData=this.chartData;const groupCount=this.getGroupedCount();const gutterSpacingPercentage=.15;const isTimeScale=this.getCategoryAxis().axisConfig.isTimeDomain();const isHorizontal=this.getCategoryAxis().axisConfig.isHorizontal();const isLogScale=this.getValueAxis().axisConfig.isLogScale();const isLabels=this.labelOptions.show;const getGroupedNum=this.getGroupedNum.bind(this);let barWidth;let gutterWidth;if(isTimeScale){const{min:min,interval:interval}=this.handler.data.get("ordered");let intervalWidth=xScale(min+interval)-xScale(min);intervalWidth=Math.abs(intervalWidth);gutterWidth=intervalWidth*gutterSpacingPercentage;barWidth=(intervalWidth-gutterWidth)/groupCount}function x(d,i){const groupNum=getGroupedNum(d.seriesId);if(isTimeScale){return xScale(d.x)+datumWidth(barWidth,d,bars.data()[i+1],xScale,gutterWidth,groupCount)*groupNum}return xScale(d.x)+xScale.rangeBand()/groupCount*groupNum}function y(d){if(isHorizontal&&d.y<0||!isHorizontal&&d.y>0){return yScale(0)}return yScale(d.y)}function labelX(d,i){return x(d,i)+widthFunc(d,i)/2}function labelY(d){if(isHorizontal){return d.y>=0?y(d)-4:y(d)+heightFunc(d)+this.getBBox().height}return d.y>=0?y(d)+heightFunc(d)+4:y(d)-this.getBBox().width-4}function labelDisplay(d,i){if(isHorizontal&&this.getBBox().width>widthFunc(d,i)){return"none"}if(!isHorizontal&&this.getBBox().height>widthFunc(d)){return"none"}return"block"}function widthFunc(d,i){if(isTimeScale){return datumWidth(barWidth,d,bars.data()[i+1],xScale,gutterWidth,groupCount)}return xScale.rangeBand()/groupCount}function heightFunc(d){const baseValue=isLogScale?1:0;return Math.abs(yScale(baseValue)-yScale(d.y))}function formatValue(d){return chartData.yAxisFormatter(d.y)}bars.attr("x",isHorizontal?x:y).attr("width",isHorizontal?widthFunc:heightFunc).attr("y",isHorizontal?y:x).attr("height",isHorizontal?heightFunc:widthFunc);const layer=d3_default.a.select(bars[0].parentNode);const barLabels=layer.selectAll("text").data(chartData.values.filter((function(d){return!external_osdSharedDeps_Lodash_default.a.isNull(d.y)})));barLabels.exit().remove();if(isLabels){const labelColor=this.handler.data.getColorFunc()(chartData.label);barLabels.enter().append("text").text(formatValue).attr("class","visColumnChart__barLabel").attr("x",isHorizontal?labelX:labelY).attr("y",isHorizontal?labelY:labelX).attr("dominant-baseline",isHorizontal?"auto":"central").attr("text-anchor",isHorizontal?"middle":"start").attr("fill",labelColor).attr("display",labelDisplay)}return bars}draw(){const self=this;return function(selection){selection.each((function(){const svg=self.chartEl.append("g");svg.data([self.chartData]);const bars=self.addBars(svg,self.chartData);self.addCircleEvents(bars);if(self.thresholdLineOptions.show){self.addThresholdLine(self.chartEl)}self.events.emit("rendered",{chart:self.chartData});return svg}))}}}const line_chart_defaults={mode:"normal",showCircles:true,radiusRatio:9,showLines:true,interpolate:"linear",lineWidth:2,color:undefined,fillColor:undefined};class line_chart_LineChart extends _point_series_PointSeries{constructor(handler,chartEl,chartData,seriesConfigArgs,deps){super(handler,chartEl,chartData,seriesConfigArgs,deps);this.seriesConfig=external_osdSharedDeps_Lodash_default.a.defaults(seriesConfigArgs||{},line_chart_defaults)}addCircles(svg,data){const self=this;const showCircles=this.seriesConfig.showCircles;const color=this.handler.data.getColorFunc();const xScale=this.getCategoryAxis().getScale();const yScale=this.getValueAxis().getScale();const ordered=this.handler.data.get("ordered");const tooltip=this.baseChart.tooltip;const isTooltip=this.handler.visConfig.get("tooltip.show");const isHorizontal=this.getCategoryAxis().axisConfig.isHorizontal();const lineWidth=this.seriesConfig.lineWidth;const radii=this.baseChart.radii;const radiusStep=(radii.max-radii.min||radii.max*100)/Math.pow(this.seriesConfig.radiusRatio,2);const layer=svg.append("g").attr("class","points line").attr("clip-path","url(#"+this.baseChart.clipPathId+")");const circles=layer.selectAll("circle").data((function appendData(){return data.values.filter((function(d){return!external_osdSharedDeps_Lodash_default.a.isNull(d.y)&&(d.y||!d.y0)}))}));circles.exit().remove();function cx(d){if(ordered&&ordered.date){return xScale(d.x)}return xScale(d.x)+xScale.rangeBand()/2}function cy(d){const y0=d.y0||0;const y=d.y||0;return yScale(y0+y)}function cColor(){return color(data.label)}function colorCircle(){const parent=d3_default.a.select(this).node().parentNode;const lengthOfParent=d3_default.a.select(parent).data()[0].length;const isVisible=lengthOfParent===1;if(!showCircles&&!isVisible)return"none";return cColor()}function getCircleRadiusFn(modifier){return function getCircleRadius(d){const width=self.baseChart.chartConfig.width;const height=self.baseChart.chartConfig.height;const circleRadius=(d.z-radii.min)/radiusStep;const baseMagicNumber=2;const base=circleRadius?Math.sqrt(circleRadius+baseMagicNumber)+lineWidth:lineWidth;return external_osdSharedDeps_Lodash_default.a.min([base,width,height])+(modifier||0)}}circles.enter().append("circle").attr("r",getCircleRadiusFn()).attr("fill-opacity",this.seriesConfig.drawLinesBetweenPoints?1:.7).attr("cx",isHorizontal?cx:cy).attr("cy",isHorizontal?cy:cx).attr("class","circle-decoration").attr("data-label",data.label).attr("fill",colorCircle);circles.enter().append("circle").attr("r",getCircleRadiusFn(10)).attr("cx",isHorizontal?cx:cy).attr("cy",isHorizontal?cy:cx).attr("fill","transparent").attr("class","circle").attr("data-label",data.label).attr("stroke",cColor).attr("stroke-width",0);if(isTooltip){circles.call(tooltip.render())}return circles}addLine(svg,data){const xScale=this.getCategoryAxis().getScale();const yScale=this.getValueAxis().getScale();const color=this.handler.data.getColorFunc();const ordered=this.handler.data.get("ordered");const lineWidth=this.seriesConfig.lineWidth;const interpolate=this.seriesConfig.interpolate;const isHorizontal=this.getCategoryAxis().axisConfig.isHorizontal();const line=svg.append("g").attr("class","pathgroup lines").attr("clip-path","url(#"+this.baseChart.clipPathId+")");function cx(d){if(ordered&&ordered.date){return xScale(d.x)}return xScale(d.x)+xScale.rangeBand()/2}function cy(d){const y=d.y||0;const y0=d.y0||0;return yScale(y0+y)}line.append("path").attr("data-label",data.label).attr("d",()=>{const d3Line=d3_default.a.svg.line().defined((function(d){return!external_osdSharedDeps_Lodash_default.a.isNull(d.y)})).interpolate(interpolate).x(isHorizontal?cx:cy).y(isHorizontal?cy:cx);return d3Line(data.values)}).attr("fill","none").attr("stroke",()=>color(data.label)).attr("stroke-width",lineWidth);return line}draw(){const self=this;return function(selection){selection.each((function(){const svg=self.chartEl.append("g");svg.data([self.chartData]);if(self.seriesConfig.drawLinesBetweenPoints){self.addLine(svg,self.chartData)}const circles=self.addCircles(svg,self.chartData);self.addCircleEvents(circles);if(self.thresholdLineOptions.show){self.addThresholdLine(self.chartEl)}self.events.emit("rendered",{chart:self.chartData});return svg}))}}}const area_chart_defaults={mode:"normal",showCircles:true,radiusRatio:9,showLines:true,interpolate:"linear",color:undefined,fillColor:undefined};class area_chart_AreaChart extends _point_series_PointSeries{constructor(handler,chartEl,chartData,seriesConfigArgs,deps){super(handler,chartEl,chartData,seriesConfigArgs,deps);this.seriesConfig=external_osdSharedDeps_Lodash_default.a.defaults(seriesConfigArgs||{},area_chart_defaults);this.isOverlapping=this.seriesConfig.mode!=="stacked";if(this.isOverlapping){const defaultOpacity=.6;this.seriesConfig.defaultOpacity=defaultOpacity;handler.highlight=function(element){const label=this.getAttribute("data-label");if(!label)return;const highlightOpacity=.8;const highlightElements=external_osdSharedDeps_Jquery_default()("[data-label]",element.parentNode).filter((function(els,el){return`${external_osdSharedDeps_Jquery_default()(el).data("label")}`===label}));external_osdSharedDeps_Jquery_default()("[data-label]",element.parentNode).not(highlightElements).css("opacity",defaultOpacity/2);highlightElements.css("opacity",highlightOpacity)};handler.unHighlight=function(element){external_osdSharedDeps_Jquery_default()("[data-label]",element).css("opacity",defaultOpacity);external_osdSharedDeps_Jquery_default()("[data-label]",external_osdSharedDeps_Jquery_default()(element).siblings()).css("opacity",1)}}}addPath(svg,data){const ordered=this.handler.data.get("ordered");const isTimeSeries=ordered&&ordered.date;const isOverlapping=this.isOverlapping;const color=this.handler.data.getColorFunc();const xScale=this.getCategoryAxis().getScale();const yScale=this.getValueAxis().getScale();const interpolate=this.seriesConfig.interpolate;const isHorizontal=this.getCategoryAxis().axisConfig.isHorizontal();const layer=svg.append("g").attr("class",(function(d,i){return"series series-"+i}));const path=layer.append("path").attr("data-label",data.label).style("fill",()=>color(data.label)).style("stroke",()=>color(data.label)).classed("visAreaChart__overlapArea",(function(){return isOverlapping})).attr("clip-path","url(#"+this.baseChart.clipPathId+")");function x(d){if(isTimeSeries){return xScale(d.x)}return xScale(d.x)+xScale.rangeBand()/2}function y1(d){const y0=d.y0||0;const y=d.y||0;return yScale(y0+y)}function y0(d){const y0=d.y0||0;return yScale(y0)}function getArea(){if(isHorizontal){return d3_default.a.svg.area().x(x).y0(y0).y1(y1)}else{return d3_default.a.svg.area().y(x).x0(y0).x1(y1)}}path.attr("d",(function(){const area=getArea().defined((function(d){return!external_osdSharedDeps_Lodash_default.a.isNull(d.y)})).interpolate(interpolate);return area(data.values)})).style("stroke-width","1px");return path}addCircles(svg,data){const color=this.handler.data.getColorFunc();const xScale=this.getCategoryAxis().getScale();const yScale=this.getValueAxis().getScale();const ordered=this.handler.data.get("ordered");const circleRadius=12;const circleStrokeWidth=0;const tooltip=this.baseChart.tooltip;const isTooltip=this.handler.visConfig.get("tooltip.show");const isOverlapping=this.isOverlapping;const isHorizontal=this.getCategoryAxis().axisConfig.isHorizontal();const layer=svg.append("g").attr("class","points area").attr("clip-path","url(#"+this.baseChart.clipPathId+")");const circles=layer.selectAll("circles").data((function appendData(){return data.values.filter((function isZeroOrNull(d){return d.y!==0&&!external_osdSharedDeps_Lodash_default.a.isNull(d.y)}))}));circles.exit().remove();circles.enter().append("circle").attr("data-label",data.label).attr("stroke",()=>color(data.label)).attr("fill","transparent").attr("stroke-width",circleStrokeWidth);function cx(d){if(ordered&&ordered.date){return xScale(d.x)}return xScale(d.x)+xScale.rangeBand()/2}function cy(d){const y=d.y||0;if(isOverlapping){return yScale(y)}return yScale(d.y0+y)}circles.attr("cx",isHorizontal?cx:cy).attr("cy",isHorizontal?cy:cx).attr("r",circleRadius);if(isTooltip){circles.call(tooltip.render())}return circles}addPathEvents(path){const events=this.events;if(this.handler.visConfig.get("enableHover")){const hover=events.addHoverEvent();const mouseout=events.addMouseoutEvent();path.call(hover).call(mouseout)}}draw(){const self=this;return function(selection){selection.each((function(){const svg=self.chartEl.append("g");svg.data([self.chartData]);const path=self.addPath(svg,self.chartData);self.addPathEvents(path);const circles=self.addCircles(svg,self.chartData);self.addCircleEvents(circles);if(self.thresholdLineOptions.show){self.addThresholdLine(self.chartEl)}self.events.emit("rendered",{chart:self.chartData});return svg}))}}}var external_osdSharedDeps_ElasticEui_=__webpack_require__(2);var charts_public_=__webpack_require__(3);const heatmap_chart_defaults={color:undefined,fillColor:undefined};class heatmap_chart_HeatmapChart extends _point_series_PointSeries{constructor(handler,chartEl,chartData,seriesConfigArgs,deps){super(handler,chartEl,chartData,seriesConfigArgs,deps);this.seriesConfig=external_osdSharedDeps_Lodash_default.a.defaults(seriesConfigArgs||{},heatmap_chart_defaults);this.handler.visConfig.set("legend",{labels:this.getHeatmapLabels(this.handler.visConfig),colors:this.getHeatmapColors(this.handler.visConfig)});const colors=this.handler.visConfig.get("legend.colors",null);if(colors){this.handler.vis.uiState.setSilent("vis.defaultColors",null);this.handler.vis.uiState.setSilent("vis.defaultColors",colors)}}getHeatmapLabels(cfg){const percentageMode=cfg.get("percentageMode");const colorsNumber=cfg.get("colorsNumber");const colorsRange=cfg.get("colorsRange");const zAxisConfig=this.getValueAxis().axisConfig;const zAxisFormatter=zAxisConfig.get("labels.axisFormatter");const zScale=this.getValueAxis().getScale();const[min,max]=zScale.domain();const labels=[];const maxColorCnt=10;if(cfg.get("setColorRange")){colorsRange.forEach(range=>{const from=isFinite(range.from)?zAxisFormatter(range.from):range.from;const to=isFinite(range.to)?zAxisFormatter(range.to):range.to;labels.push(`${from} - ${to}`)})}else{if(max===min){return[min.toString()]}for(let i=0;i<colorsNumber;i++){let label;let val=i/colorsNumber;let nextVal=(i+1)/colorsNumber;if(percentageMode){val=Math.ceil(val*100);nextVal=Math.ceil(nextVal*100);label=`${val}% - ${nextVal}%`}else{val=val*(max-min)+min;nextVal=nextVal*(max-min)+min;if(max-min>maxColorCnt){const valInt=Math.ceil(val);if(i===0){val=valInt===val?val:valInt-1}else{val=valInt}nextVal=Math.ceil(nextVal)}if(isFinite(val))val=zAxisFormatter(val);if(isFinite(nextVal))nextVal=zAxisFormatter(nextVal);label=`${val} - ${nextVal}`}labels.push(label)}}return labels}getHeatmapColors(cfg){const invertColors=cfg.get("invertColors");const colorSchema=cfg.get("colorSchema");const labels=this.getHeatmapLabels(cfg);const colors={};for(const i in labels){if(labels[i]){const val=invertColors?1-i/labels.length:i/labels.length;colors[labels[i]]=Object(charts_public_["getHeatmapColors"])(val,colorSchema)}}return colors}addSquares(svg,data){const xScale=this.getCategoryAxis().getScale();const yScale=this.handler.categoryAxes[1].getScale();const zScale=this.getValueAxis().getScale();const tooltip=this.baseChart.tooltip;const isTooltip=this.handler.visConfig.get("tooltip.show");const isHorizontal=this.getCategoryAxis().axisConfig.isHorizontal();const colorsNumber=this.handler.visConfig.get("colorsNumber");const setColorRange=this.handler.visConfig.get("setColorRange");const colorsRange=this.handler.visConfig.get("colorsRange");const color=this.handler.data.getColorFunc();const labels=this.handler.visConfig.get("legend.labels");const zAxisConfig=this.getValueAxis().axisConfig;const zAxisFormatter=zAxisConfig.get("labels.axisFormatter");const showLabels=zAxisConfig.get("labels.show");const overwriteLabelColor=zAxisConfig.get("labels.overwriteColor",false);const layer=svg.append("g").attr("class","series");const squares=layer.selectAll("g.square").data(data.values);squares.exit().remove();let barWidth;if(this.getCategoryAxis().axisConfig.isTimeDomain()){const{min:min,interval:interval}=this.handler.data.get("ordered");const start=min;const end=external_osdSharedDeps_Moment_default()(min).add(interval).valueOf();barWidth=xScale(end)-xScale(start);if(!isHorizontal)barWidth*=-1}function x(d){return xScale(d.x)}function y(d){return yScale(d.series)}const[min,max]=zScale.domain();function getColorBucket(d){let val=0;if(setColorRange&&colorsRange.length){const bucket=external_osdSharedDeps_Lodash_default.a.find(colorsRange,range=>range.from<=d.y&&range.to>d.y);return bucket?colorsRange.indexOf(bucket):-1}else{if(isNaN(min)||isNaN(max)){val=colorsNumber-1}else if(min===max){val=0}else{val=(d.y-min)/(max-min);val=Math.min(colorsNumber-1,Math.floor(val*colorsNumber))}}if(d.y==null){return-1}return!isNaN(val)?val:-1}function label(d){const colorBucket=getColorBucket(d);if(colorBucket<0)d.hide=true;return labels[colorBucket]}function z(d){if(label(d)==="")return"transparent";return color(label(d))}const squareWidth=barWidth||xScale.rangeBand();const squareHeight=yScale.rangeBand();squares.enter().append("g").attr("class","square");squares.append("rect").attr("x",x).attr("width",squareWidth).attr("y",y).attr("height",squareHeight).attr("data-label",label).attr("fill",z).attr("style","cursor: pointer; stroke: black; stroke-width: 0.1px").style("display",d=>d.hide?"none":"initial");if(showLabels){const rotate=zAxisConfig.get("labels.rotate");const rotateRad=rotate*Math.PI/180;const cellPadding=5;const maxLength=Math.min(Math.abs(squareWidth/Math.cos(rotateRad)),Math.abs(squareHeight/Math.sin(rotateRad)))-cellPadding;const maxHeight=Math.min(Math.abs(squareWidth/Math.sin(rotateRad)),Math.abs(squareHeight/Math.cos(rotateRad)))-cellPadding;let labelColor;if(overwriteLabelColor){labelColor=zAxisConfig.get("labels.color")}else{labelColor=d=>{const bgColor=z(d);const color=/rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/.exec(bgColor);return color&&Object(external_osdSharedDeps_ElasticEui_["isColorDark"])(parseInt(color[1]),parseInt(color[2]),parseInt(color[3]))?"#FFF":"#222"}}let hiddenLabels=false;squares.append("text").text(d=>zAxisFormatter(d.y)).style("display",(function(d){const textLength=this.getBBox().width;const textHeight=this.getBBox().height;const textTooLong=textLength>maxLength;const textTooWide=textHeight>maxHeight;if(!d.hide&&(textTooLong||textTooWide)){hiddenLabels=true}return d.hide||textTooLong||textTooWide?"none":"initial"})).style("dominant-baseline","central").style("text-anchor","middle").style("fill",labelColor).attr("x",(function(d){const center=x(d)+squareWidth/2;return center})).attr("y",(function(d){const center=y(d)+squareHeight/2;return center})).attr("transform",(function(d){const horizontalCenter=x(d)+squareWidth/2;const verticalCenter=y(d)+squareHeight/2;return`rotate(${rotate},${horizontalCenter},${verticalCenter})`}));if(hiddenLabels){this.baseChart.handler.alerts.show("Some labels were hidden due to size constraints")}}if(isTooltip){squares.call(tooltip.render())}return squares.selectAll("rect")}draw(){const self=this;return function(selection){selection.each((function(){const svg=self.chartEl.append("g");svg.data([self.chartData]);const squares=self.addSquares(svg,self.chartData);self.addCircleEvents(squares);self.events.emit("rendered",{chart:self.chartData});return svg}))}}}const seriesTypes={histogram:column_chart_ColumnChart,line:line_chart_LineChart,area:area_chart_AreaChart,heatmap:heatmap_chart_HeatmapChart};var touchdown_tmpl='<p class="visTooltip__header">\n  <i class="fa fa-info-circle visTooltip__headerIcon"></i>\n  <span class="visTooltip__headerText">\n    <%= wholeBucket ? \'Part of this bucket\' : \'This area\' %>\n    may contain partial data. The selected time range does not fully cover it.\n  </span>\n</p>\n';const seriTypes=seriesTypes;const touchdownTmpl=external_osdSharedDeps_Lodash_default.a.template(touchdown_tmpl);class point_series_PointSeries extends _chart_Chart{constructor(handler,chartEl,chartData,deps){super(handler,chartEl,chartData,deps);this.deps=deps;this.handler=handler;this.chartData=chartData;this.chartEl=chartEl;this.chartConfig=this.findChartConfig();this.handler.pointSeries=this}findChartConfig(){const charts=this.handler.visConfig.get("charts");const chartIndex=this.handler.data.chartData().indexOf(this.chartData);return charts[chartIndex]}getSeries(seriesId){return this.series.find(series=>series.chartData.aggId===seriesId)}addBackground(svg,width,height){const startX=0;const startY=0;return svg.append("rect").attr("x",startX).attr("y",startY).attr("width",width).attr("height",height).attr("fill","transparent").attr("class","background")}addGrid(svg){const{width:width,height:height}=svg.node().getBBox();return svg.append("g").attr("class","grid").call(this.handler.grid.draw(width,height))}addClipPath(svg){const{width:width,height:height}=svg.node().getBBox();const startX=0;const startY=0;this.clipPathId="chart-area"+external_osdSharedDeps_Lodash_default.a.uniqueId();return svg.append("clipPath").attr("id",this.clipPathId).append("rect").attr("x",startX).attr("y",startY).attr("width",width).attr("height",height)}addEvents(svg){const isBrushable=this.events.isBrushable();if(isBrushable){this.events.addBrushEvent(svg)}}createEndZones(svg){const self=this;const xAxis=this.handler.categoryAxes[0];const xScale=xAxis.getScale();const ordered=xAxis.ordered;const isHorizontal=xAxis.axisConfig.isHorizontal();const missingMinMax=!ordered||external_osdSharedDeps_Lodash_default.a.isUndefined(ordered.min)||external_osdSharedDeps_Lodash_default.a.isUndefined(ordered.max);if(missingMinMax||ordered.endzones===false)return;const{width:width,height:height}=svg.node().getBBox();const oneUnit=(ordered.units||external_osdSharedDeps_Lodash_default.a.identity)(1);const drawInverted=isHorizontal||xAxis.axisConfig.get("scale.inverted",false);const size=isHorizontal?width:height;const leftEndzone={x:drawInverted?0:Math.max(xScale(ordered.min),0),w:drawInverted?Math.max(xScale(ordered.min),0):height-Math.max(xScale(ordered.min),0)};const expandLastBucket=xAxis.axisConfig.get("scale.expandLastBucket");const rightLastVal=expandLastBucket?ordered.max:Math.min(ordered.max,external_osdSharedDeps_Lodash_default.a.last(xAxis.values));const rightStart=rightLastVal+oneUnit;const rightEndzone={x:drawInverted?xScale(rightStart):0,w:drawInverted?Math.max(size-xScale(rightStart),0):xScale(rightStart)};this.endzones=svg.selectAll(".layer").data([leftEndzone,rightEndzone]).enter().insert("g",".brush").attr("class","endzone").append("rect").attr("class","zone").attr("x",d=>isHorizontal?d.x:0).attr("y",d=>isHorizontal?0:d.x).attr("height",d=>isHorizontal?height:d.w).attr("width",d=>isHorizontal?d.w:width);function callPlay(event){const boundData=event.target.__data__;const mouseChartXCoord=event.clientX-self.chartEl.getBoundingClientRect().left;const mouseChartYCoord=event.clientY-self.chartEl.getBoundingClientRect().top;const wholeBucket=boundData&&boundData.x!=null;const min=drawInverted?leftEndzone.w:rightEndzone.w;const max=drawInverted?rightEndzone.x:leftEndzone.x;let xLeft=isHorizontal?mouseChartXCoord:mouseChartYCoord;let xRight=isHorizontal?mouseChartXCoord:mouseChartYCoord;if(wholeBucket){xLeft=xScale(boundData.x);xRight=xScale(xAxis.addInterval(boundData.x))}return{wholeBucket:wholeBucket,touchdown:min>xLeft||max<xRight}}function textFormatter(){return touchdownTmpl(callPlay(d3_default.a.event))}const endzoneTT=new Tooltip("endzones",this.handler.el,textFormatter,null);this.tooltips.push(endzoneTT);endzoneTT.order=0;endzoneTT.showCondition=function inEndzone(){return callPlay(d3_default.a.event).touchdown};endzoneTT.render()(svg)}calculateRadiusLimits(data){this.radii=external_osdSharedDeps_Lodash_default()(data.series).map((function(series){return external_osdSharedDeps_Lodash_default.a.map(series.values,"z")})).flattenDeep().reduce((function(result,val){if(result.min>val)result.min=val;if(result.max<val)result.max=val;return result}),{min:Infinity,max:-Infinity})}draw(){const self=this;const $elem=external_osdSharedDeps_Jquery_default()(this.chartEl);const width=this.chartConfig.width=$elem.width();const height=this.chartConfig.height=$elem.height();const xScale=this.handler.categoryAxes[0].getScale();const addTimeMarker=this.chartConfig.addTimeMarker;const times=this.chartConfig.times||[];let div;let svg;return function(selection){selection.each((function(data){const el=this;div=d3_default.a.select(el);svg=div.append("svg").attr("focusable","false").attr("width",width).attr("height",height);self.addBackground(svg,width,height);self.addGrid(svg);self.addClipPath(svg);self.addEvents(svg);self.createEndZones(svg);self.calculateRadiusLimits(data);self.series=[];external_osdSharedDeps_Lodash_default.a.each(self.chartConfig.series,(seriArgs,i)=>{if(!seriArgs.show)return;const SeriClass=seriTypes[seriArgs.type||self.handler.visConfig.get("chart.type")]||seriTypes.line;const series=new SeriClass(self.handler,svg,data.series[i],seriArgs,self.deps);series.events=self.events;svg.call(series.draw());self.series.push(series)});if(addTimeMarker){const toTime=new Date(xScale.domain()[1].getTime()+6e4);const currentTime=new Date;if(toTime>currentTime){new time_marker_TimeMarker(times,xScale,height).render(svg)}}return svg}))}}}const pie_chart_defaults={isDonut:false,showTooltip:true,color:undefined,fillColor:undefined};class pie_chart_PieChart extends _chart_Chart{constructor(handler,chartEl,chartData,deps){super(handler,chartEl,chartData,deps);const charts=this.handler.data.getVisData();this._validatePieData(charts);this._attr=external_osdSharedDeps_Lodash_default.a.defaults(handler.visConfig.get("chart",{}),pie_chart_defaults)}_validatePieData(charts){const isAllZeros=charts.every(chart=>chart.slices.children.length===0);if(isAllZeros){throw new PieContainsAllZeros}}addPathEvents(element){const events=this.events;return element.call(events.addHoverEvent()).call(events.addMouseoutEvent()).call(events.addClickEvent())}convertToPercentage(slices){(function assignPercentages(slices){if(slices.sumOfChildren!=null)return;const parent=slices;const children=parent.children;const parentPercent=parent.percentOfParent;const sum=parent.sumOfChildren=Math.abs(children.reduce((function(sum,child){return sum+Math.abs(child.size)}),0));children.forEach((function(child){child.percentOfGroup=Math.abs(child.size)/sum;child.percentOfParent=child.percentOfGroup;if(parentPercent!=null){child.percentOfParent*=parentPercent}if(child.children){assignPercentages(child)}}))})(slices)}addPath(width,height,svg,slices){const self=this;const marginFactor=.95;const isDonut=self._attr.isDonut;const radius=Math.min(width,height)/2*marginFactor;const color=self.handler.data.getPieColorFunc();const tooltip=self.tooltip;const isTooltip=self._attr.addTooltip;const arcs=svg.append("g").attr("class","arcs");const labels=svg.append("g").attr("class","labels");const showLabels=self._attr.labels.show;const showValues=self._attr.labels.values;const truncateLabelLength=self._attr.labels.truncate;const showOnlyOnLastLevel=self._attr.labels.last_level;const partition=d3_default.a.layout.partition().sort(null).value((function(d){return d.percentOfParent*100}));const x=d3_default.a.scale.linear().range([0,2*Math.PI]);const y=d3_default.a.scale.sqrt().range([0,showLabels?radius*.7:radius]);const startAngle=function(d){return Math.max(0,Math.min(2*Math.PI,x(d.x)))};const endAngle=function(d){if(d.dx<1e-8)return x(d.x);return Math.max(0,Math.min(2*Math.PI,x(d.x+d.dx)))};const arc=d3_default.a.svg.arc().startAngle(startAngle).endAngle(endAngle).innerRadius((function(d){if(d.depth===1&&!isDonut){return 0}return Math.max(0,y(d.y))})).outerRadius((function(d){return Math.max(0,y(d.y+d.dy))}));const outerArc=d3_default.a.svg.arc().startAngle(startAngle).endAngle(endAngle).innerRadius(radius*.8).outerRadius(radius*.8);let maxDepth=0;const path=arcs.datum(slices).selectAll("path").data(partition.nodes).enter().append("path").attr("d",arc).attr("class",(function(d){if(d.depth===0){return}if(d.depth>maxDepth)maxDepth=d.depth;return"slice"})).attr("data-test-subj",(function(d){if(d.name){return`pieSlice-${d.name.split(" ").join("-")}`}})).call(self._addIdentifier,"name").style("fill",(function(d){if(d.depth===0){return"none"}return color(d.name)}));if(showLabels){const labelGroups=labels.datum(slices).selectAll(".label").data(partition.nodes);const svgParentNode=svg.node().parentNode.parentNode;const svgBBox={width:svgParentNode.clientWidth,height:svgParentNode.clientHeight};const labelLayout=d3_default.a.geom.quadtree().extent([[-svgBBox.width,-svgBBox.height],[svgBBox.width,svgBBox.height]]).x((function(d){return d.position.x})).y((function(d){return d.position.y}))([]);labelGroups.enter().append("g").attr("class","label").append("text").text((function(d){if(d.depth===0){d3_default.a.select(this.parentNode).remove();return}if(showValues){const value=external_osdSharedDeps_ElasticNumeral_default()(d.value/100).format("0.[00]%");return`${d.name} (${value})`}return d.name})).text((function(){return truncateLabel(this,truncateLabelLength)})).attr("text-anchor",(function(d){const midAngle=startAngle(d)+(endAngle(d)-startAngle(d))/2;return midAngle<Math.PI?"start":"end"})).attr("class","label-text").each((function resolveConflicts(d){if(d.depth===0)return;const parentNode=this.parentNode;if(showOnlyOnLastLevel&&maxDepth!==d.depth){d3_default.a.select(parentNode).remove();return}const bbox=this.getBBox();const pos=outerArc.centroid(d);const midAngle=startAngle(d)+(endAngle(d)-startAngle(d))/2;pos[1]+=4;pos[0]=(.7+d.depth/10)*radius*(midAngle<Math.PI?1:-1);d.position={x:pos[0],y:pos[1],left:midAngle<Math.PI?pos[0]:pos[0]-bbox.width,right:midAngle>Math.PI?pos[0]+bbox.width:pos[0],bottom:pos[1]+5,top:pos[1]-bbox.height-5};const conflicts=[];labelLayout.visit((function(node){if(!node.point)return;if(conflicts.length)return true;const point=node.point.position;const current=d.position;if(point){const horizontalConflict=point.left<0&&current.left<0||point.left>0&&current.left>0;const verticalConflict=point.top>=current.top&&point.top<=current.bottom||point.top<=current.top&&point.bottom>=current.top;if(horizontalConflict&&verticalConflict){point.point=node.point;conflicts.push(point)}return true}}));if(conflicts.length){d3_default.a.select(parentNode).remove();return}labelLayout.add(d)})).attr("x",(function(d){if(d.depth===0||!d.position){return}return d.position.x})).attr("y",(function(d){if(d.depth===0||!d.position){return}return d.position.y}));labelGroups.append("polyline").attr("points",(function(d){if(d.depth===0||!d.position){return}const pos1=outerArc.centroid(d);const x2=d.position.x>0?d.position.x-10:d.position.x+10;const pos2=[x2,d.position.y-4];pos1[1]=pos2[1];return[arc.centroid(d),pos1,pos2]})).attr("class","label-line")}if(isTooltip){path.call(tooltip.render())}return path}_validateContainerSize(width,height){const minWidth=20;const minHeight=20;if(width<=minWidth||height<=minHeight){throw new ContainerTooSmall}}draw(){const self=this;return function(selection){selection.each((function(data){const slices=data.slices;const div=d3_default.a.select(this);const width=external_osdSharedDeps_Jquery_default()(this).width();const height=external_osdSharedDeps_Jquery_default()(this).height();if(!slices.children.length)return;self.convertToPercentage(slices);self._validateContainerSize(width,height);const svg=div.append("svg").attr("width",width).attr("height",height).attr("focusable","false").append("g").attr("transform","translate("+width/2+","+height/2+")");const path=self.addPath(width,height,svg,slices);self.addPathEvents(path);self.events.emit("rendered",{chart:data});return svg}))}}}const arcAngles={angleFactor:.75,maxAngle:2*Math.PI*1.3,minAngle:2*Math.PI*.7};const circleAngles={angleFactor:1,maxAngle:2*Math.PI,minAngle:0};const defaultConfig={showTooltip:true,percentageMode:true,innerSpace:5,extents:[0,1e4],outline:false,scale:{show:true,color:"#666",width:2,ticks:10,tickLength:8},labels:{show:true,color:"#666"},style:{bgWidth:.5,width:.9}};class meter_MeterGauge{constructor(gaugeChart){this.gaugeChart=gaugeChart;this.gaugeConfig=gaugeChart.gaugeConfig;this.gaugeConfig=external_osdSharedDeps_Lodash_default.a.defaultsDeep(this.gaugeConfig,defaultConfig);this.gaugeChart.handler.visConfig.set("legend",{labels:this.getLabels(),colors:this.getColors()});const colors=this.gaugeChart.handler.visConfig.get("legend.colors",null);if(colors){this.gaugeChart.handler.vis.uiState.setSilent("vis.defaultColors",null);this.gaugeChart.handler.vis.uiState.setSilent("vis.defaultColors",colors)}this.colorFunc=this.gaugeChart.handler.data.getColorFunc()}getLabels(){const isPercentageMode=this.gaugeConfig.percentageMode;const colorsRange=this.gaugeConfig.colorsRange;const max=external_osdSharedDeps_Lodash_default.a.last(colorsRange).to;const labels=[];colorsRange.forEach(range=>{const from=isPercentageMode?Math.round(100*range.from/max):range.from;const to=isPercentageMode?Math.round(100*range.to/max):range.to;labels.push(`${from} - ${to}`)});return labels}getColors(){const invertColors=this.gaugeConfig.invertColors;const colorSchema=this.gaugeConfig.colorSchema;const colorsRange=this.gaugeConfig.colorsRange;const labels=this.getLabels();const colors={};for(let i=0;i<labels.length;i+=1){const divider=Math.max(colorsRange.length-1,1);const val=invertColors?1-i/divider:i/divider;colors[labels[i]]=Object(charts_public_["getHeatmapColors"])(val,colorSchema)}return colors}getBucket(val){let bucket=external_osdSharedDeps_Lodash_default.a.findIndex(this.gaugeConfig.colorsRange,range=>range.from<=val&&range.to>val);if(bucket===-1){if(val<this.gaugeConfig.colorsRange[0].from)bucket=0;else bucket=this.gaugeConfig.colorsRange.length-1}return bucket}getLabel(val){const bucket=this.getBucket(val);const labels=this.gaugeChart.handler.visConfig.get("legend.labels");return labels[bucket]}getColorBucket(val){const bucket=this.getBucket(val);const labels=this.gaugeChart.handler.visConfig.get("legend.labels");return this.colorFunc(labels[bucket])}drawScale(svg,radius,angle){const scaleWidth=this.gaugeConfig.scale.width;const tickLength=this.gaugeConfig.scale.tickLength;const scaleTicks=this.gaugeConfig.scale.ticks;const scale=svg.append("g");this.gaugeConfig.colorsRange.forEach(range=>{const color=this.getColorBucket(range.from);const scaleArc=d3_default.a.svg.arc().startAngle(angle(range.from)).endAngle(angle(range.to)).innerRadius(radius).outerRadius(radius+scaleWidth);scale.append("path").attr("d",scaleArc).style("stroke",color).style("fill",color)});const extents=angle.domain();for(let i=0;i<=scaleTicks;i++){const val=i*(extents[1]-extents[0])/scaleTicks;const tickAngle=angle(val)-Math.PI/2;const x0=Math.cos(tickAngle)*radius;const x1=Math.cos(tickAngle)*(radius-tickLength);const y0=Math.sin(tickAngle)*radius;const y1=Math.sin(tickAngle)*(radius-tickLength);const color=this.getColorBucket(val);scale.append("line").attr("x1",x0).attr("x2",x1).attr("y1",y0).attr("y2",y1).style("stroke-width",scaleWidth).style("stroke",color)}return scale}drawGauge(svg,data,width,height){const marginFactor=.95;const tooltip=this.gaugeChart.tooltip;const isTooltip=this.gaugeChart.handler.visConfig.get("addTooltip");const isDisplayWarning=this.gaugeChart.handler.visConfig.get("isDisplayWarning",false);const{angleFactor:angleFactor,maxAngle:maxAngle,minAngle:minAngle}=this.gaugeConfig.gaugeType==="Circle"?circleAngles:arcAngles;const maxRadius=Math.min(width,height/angleFactor)/2*marginFactor;const extendRange=this.gaugeConfig.extendRange;const maxY=external_osdSharedDeps_Lodash_default.a.max(data.values,"y").y;const min=this.gaugeConfig.colorsRange[0].from;const max=external_osdSharedDeps_Lodash_default.a.last(this.gaugeConfig.colorsRange).to;const angle=d3_default.a.scale.linear().range([minAngle,maxAngle]).domain([min,extendRange&&max<maxY?maxY:max]);const radius=d3_default.a.scale.linear().range([0,maxRadius]).domain([this.gaugeConfig.innerSpace+1,0]);const totalWidth=Math.abs(radius(0)-radius(1));const bgPadding=totalWidth*(1-this.gaugeConfig.style.bgWidth)/2;const gaugePadding=totalWidth*(1-this.gaugeConfig.style.width)/2;const getInnerFreeSpace=()=>radius(1)*2-(this.gaugeConfig.scale.show?this.gaugeConfig.scale.tickLength*2:-Math.max(bgPadding,gaugePadding)*2);const arc=d3_default.a.svg.arc().startAngle(minAngle).endAngle((function(d){return Math.max(0,Math.min(maxAngle,angle(Math.max(min,d.y))))})).innerRadius((function(d,i,j){return Math.max(0,radius(j+1)+gaugePadding)})).outerRadius((function(d,i,j){return Math.max(0,radius(j)-gaugePadding)}));const bgArc=d3_default.a.svg.arc().startAngle(minAngle).endAngle(maxAngle).innerRadius((function(d,i,j){return Math.max(0,radius(j+1)+bgPadding)})).outerRadius((function(d,i,j){return Math.max(0,radius(j)-bgPadding)}));const gaugeHolders=svg.selectAll("path").data([data]).enter().append("g").attr("data-label",d=>this.getLabel(d.values[0].y));const gauges=gaugeHolders.selectAll("g").data(d=>d.values).enter();gauges.append("path").attr("d",bgArc).attr("class",this.gaugeConfig.outline?"visGauge__meter--outline":undefined).style("fill",this.gaugeConfig.style.bgFill);const series=gauges.append("path").attr("d",arc).attr("class",this.gaugeConfig.outline?"visGauge__meter--outline":undefined).style("fill",d=>this.getColorBucket(Math.max(min,d.y)));const smallContainer=svg.node().getBBox().height<70;let hiddenLabels=smallContainer;let valueLabelHidden=false;gauges.append("text").attr("class","chart-label").attr("y",-5).text(d=>{if(this.gaugeConfig.percentageMode){const percentage=(d.y-min)/(max-min);return data.yAxisFormatter(percentage)}return data.yAxisFormatter(d.y)}).attr("style","dominant-baseline: central;").style("text-anchor","middle").style("font-size","2em").style("display",(function(){const textLength=this.getBBox().width;const textTooLong=textLength>=getInnerFreeSpace()-6;if(textTooLong){hiddenLabels=true;valueLabelHidden=true}return textTooLong?"none":"initial"}));if(this.gaugeConfig.labels.show){svg.append("text").attr("class","chart-label").text(data.label).attr("y",-30).attr("style","dominant-baseline: central; text-anchor: middle;").style("display",(function(){const textLength=this.getBBox().width;const textTooLong=textLength>maxRadius;if(textTooLong){hiddenLabels=true}return smallContainer||textTooLong?"none":"initial"}));svg.append("text").attr("class","chart-label").text(this.gaugeConfig.style.subText).attr("y",20).attr("style","dominant-baseline: central; text-anchor: middle;").style("display",(function(){const textLength=this.getBBox().width;const textTooLong=textLength>maxRadius;if(textTooLong){hiddenLabels=true}return valueLabelHidden||smallContainer||textTooLong?"none":"initial"}))}if(this.gaugeConfig.scale.show){this.drawScale(svg,radius(1),angle)}if(isTooltip){series.each((function(){const gauge=d3_default.a.select(this);gauge.call(tooltip.render())}))}if(hiddenLabels&&isDisplayWarning){this.gaugeChart.handler.alerts.show("Some labels were hidden due to size constraints")}const transformX=width/2;const transformY=height/2>maxRadius?height/2:maxRadius;svg.attr("transform",`translate(${transformX}, ${transformY})`);return series}}const gaugeTypes={meter:meter_MeterGauge};class gauge_chart_GaugeChart extends _chart_Chart{constructor(handler,chartEl,chartData,deps){super(handler,chartEl,chartData,deps);this.gaugeConfig=handler.visConfig.get("gauge",{});this.gauge=new gaugeTypes[this.gaugeConfig.type](this)}addEvents(element){const events=this.events;return element.call(events.addHoverEvent()).call(events.addMouseoutEvent())}calcGaugeDim(alignment,containerDom,nrOfItems){const containerWidth=containerDom.clientWidth;const containerHeight=containerDom.clientHeight;const containerMargin=25;const gaugeBottomMargin=Math.ceil(25/nrOfItems);const availableWidth=containerWidth-containerMargin;const availableHeight=containerHeight-containerMargin;const adaptedWidth=Math.floor(availableWidth/nrOfItems);const adaptedHeight=Math.floor(availableHeight/nrOfItems)-gaugeBottomMargin;switch(alignment){case"vertical":return{width:containerWidth,height:adaptedHeight,alignment:alignment};case"horizontal":return{width:adaptedWidth,height:availableHeight,alignment:alignment};default:return{width:availableWidth<availableHeight?containerWidth:adaptedWidth,height:availableWidth<availableHeight?adaptedHeight:availableHeight,alignment:availableWidth<availableHeight?"vertical":"horizontal"}}}draw(){const self=this;const{gaugeConfig:gaugeConfig}=this;return function(selection){selection.each((function(data){const div=d3_default.a.select(this);const{width:width,height:height}=self.calcGaugeDim(gaugeConfig.alignment,this,data.series.length);if(height<0||width<0)return;div.style("text-align","center").style("overflow-y","auto");data.series.forEach(series=>{const svg=div.append("svg").style("display","inline-block").style("overflow","hidden").attr("focusable","false").attr("width",width);const g=svg.append("g");const gauges=self.gauge.drawGauge(g,series,width,height);svg.attr("height",height);self.addEvents(gauges)});div.append("div").attr("class","chart-title").style("text-align","center").text(data.label||data.yAxisLabel);self.events.emit("rendered",{chart:data});return div}))}}}const visTypes={pie:pie_chart_PieChart,point_series:point_series_PointSeries,gauge:gauge_chart_GaugeChart,goal:gauge_chart_GaugeChart,metric:gauge_chart_GaugeChart};const markdownIt=new markdown_it_default.a({html:false,linkify:true});class handler_Handler{constructor(vis,visConfig,deps){this.el=visConfig.get("el");this.ChartClass=visTypes[visConfig.get("type")];this.deps=deps;this.charts=[];this.vis=vis;this.visConfig=visConfig;this.data=visConfig.data;this.categoryAxes=visConfig.get("categoryAxes").map(axisArgs=>new axis_Axis(visConfig,axisArgs));this.valueAxes=visConfig.get("valueAxes").map(axisArgs=>new axis_Axis(visConfig,axisArgs));this.chartTitle=new chart_title_ChartTitle(visConfig);this.alerts=new alerts_Alerts(this,visConfig.get("alerts"));this.grid=new chart_grid_ChartGrid(this,visConfig.get("grid"));if(visConfig.get("type")==="point_series"){this.data.stackData(this)}if(visConfig.get("resize",false)){this.resize=visConfig.get("resize")}this.layout=new layout_Layout(visConfig);this.binder=new binder_Binder;this.renderArray=external_osdSharedDeps_Lodash_default.a.filter([this.layout,this.chartTitle,this.alerts],Boolean);this.renderArray=this.renderArray.concat(this.valueAxes).concat(this.categoryAxes.slice().reverse());this.getProxyHandler=external_osdSharedDeps_Lodash_default.a.memoize((function(eventType){const self=this;return function(eventPayload){switch(eventType){case"brush":const xRaw=external_osdSharedDeps_Lodash_default.a.get(eventPayload.data,"series[0].values[0].xRaw");if(!xRaw)return;return self.vis.emit(eventType,{table:xRaw.table,range:eventPayload.range,column:xRaw.column});case"click":return self.vis.emit(eventType,eventPayload)}}}));this.enable=this.chartEventProxyToggle("on");this.disable=this.chartEventProxyToggle("off")}_validateData(){const dataType=this.data.type;if(!dataType){throw new errors_NoResults}}render(){if(this.visConfig.get("error",null))return this.error(this.visConfig.get("error"));const self=this;const{binder:binder,charts:charts=[]}=this;const selection=d3_default.a.select(this.el);selection.selectAll("*").remove();this._validateData();this.renderArray.forEach((function(property){if(typeof property.render==="function"){property.render()}}));let loadedCount=0;const chartSelection=selection.selectAll(".chart");chartSelection.each((function(chartData){const chart=new self.ChartClass(self,this,chartData,self.deps);self.vis.eventNames().forEach((function(event){self.enable(event,chart)}));binder.on(chart.events,"rendered",()=>{loadedCount++;if(loadedCount===chartSelection.length){self.vis.emit("renderComplete")}});charts.push(chart);chart.render()}))}chartEventProxyToggle(method){return function(event,chart){const proxyHandler=this.getProxyHandler(event);external_osdSharedDeps_Lodash_default.a.each(chart?[chart]:this.charts,(function(chart){chart.events[method](event,proxyHandler)}))}}removeAll(el){return d3_default.a.select(el).selectAll("*").remove()}error(message){this.removeAll(this.el);const div=d3_default.a.select(this.el).append("div").attr("class","visError chart error").attr("data-test-subj","visLibVisualizeError");div.append("h4").text(markdownIt.renderInline(message));Object(public_["dispatchRenderComplete"])(this.el);return div}destroy(){this.binder.destroy();this.renderArray.forEach((function(renderable){if(external_osdSharedDeps_Lodash_default.a.isFunction(renderable.destroy)){renderable.destroy()}}));this.charts.splice(0).forEach((function(chart){if(external_osdSharedDeps_Lodash_default.a.isFunction(chart.destroy)){chart.destroy()}}))}}class vis_Vis extends events_events["EventEmitter"]{constructor(element,visConfigArgs,deps){super();this.element=element.get?element.get(0):element;this.visConfigArgs=external_osdSharedDeps_Lodash_default.a.cloneDeep(visConfigArgs);this.visConfigArgs.dimmingOpacity=deps.uiSettings.get(DIMMING_OPACITY_SETTING);this.visConfigArgs.heatmapMaxBuckets=deps.uiSettings.get(HEATMAP_MAX_BUCKETS_SETTING);this.deps=deps}hasLegend(){return this.visConfigArgs.addLegend}initVisConfig(data,uiState){this.data=data;this.uiState=uiState;this.visConfig=new vis_config_VisConfig(this.visConfigArgs,this.data,this.uiState,this.element,this.deps.charts.colors.createColorLookupFunction.bind(this.deps.charts.colors))}render(data,uiState){if(!data){throw new Error("No valid data!")}if(this.handler){this.data=null;this._runOnHandler("destroy")}this.initVisConfig(data,uiState);this.handler=new handler_Handler(this,this.visConfig,this.deps);this._runOnHandler("render")}getLegendLabels(){return this.visConfig?this.visConfig.get("legend.labels",null):null}getLegendColors(){return this.visConfig?this.visConfig.get("legend.colors",null):null}_runOnHandler(method){try{this.handler[method]()}catch(error){if(error instanceof errors_VislibError){error.displayToScreen(this.handler)}else{throw error}}}destroy(){const selection=d3_default.a.select(this.element).select(".visWrapper");if(this.handler)this._runOnHandler("destroy");selection.remove()}set(name,val){this.visConfigArgs[name]=val;this.render(this.data,this.uiState)}get(name){return this.visConfig.get(name)}on(event,listener){const first=this.listenerCount(event)===0;const ret=events_events["EventEmitter"].prototype.on.call(this,event,listener);const added=this.listenerCount(event)>0;if(first&&added&&this.handler)this.handler.enable(event);return ret}off(event,listener){const last=this.listenerCount(event)===1;const ret=events_events["EventEmitter"].prototype.off.call(this,event,listener);const removed=this.listenerCount(event)===0;if(last&&removed&&this.handler)this.handler.disable(event);return ret}removeAllListeners(event){const ret=events_events["EventEmitter"].prototype.removeAllListeners.call(this,event);this.handler.disable(event);return ret}}},44:function(module,exports,__webpack_require__){exports.set=__webpack_require__(68);exports.setWith=__webpack_require__(111)},54:function(module,exports,__webpack_require__){var assignValue=__webpack_require__(69),castPath=__webpack_require__(80),isFunction=__webpack_require__(55),isIndex=__webpack_require__(109),isObject=__webpack_require__(48),toKey=__webpack_require__(110);function baseSet(object,path,value,customizer){if(!isObject(object)){return object}path=castPath(path,object);var index=-1,length=path.length,lastIndex=length-1,nested=object;while(nested!=null&&++index<length){var key=toKey(path[index]),newValue=value;if(key=="prototype"&&isFunction(nested)){throw new Error("Illegal access of function prototype")}if(index!=lastIndex){var objValue=hasOwnProperty.call(nested,key)?nested[key]:undefined;newValue=customizer?customizer(objValue,key,nested):undefined;if(newValue===undefined){newValue=isObject(objValue)?objValue:isIndex(path[index+1])?[]:{}}}assignValue(nested,key,newValue);nested=nested[key]}return object}module.exports=baseSet},68:function(module,exports,__webpack_require__){var baseSet=__webpack_require__(54);function set(object,path,value){return object==null?object:baseSet(object,path,value)}module.exports=set}}]);