/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import com.oracle.labs.mlrg.olcut.util.ChannelUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtil {
    private static final Logger logger = Logger.getLogger(FileUtil.class.getName());

    public static void deleteDirectory(File dir) {
        if (!dir.isDirectory()) {
            logger.warning(String.format("%s is not a directory, not deleting", dir));
            return;
        }
        if (!dir.exists()) {
            return;
        }
        File[] fs = dir.listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (f.isDirectory()) {
                    FileUtil.deleteDirectory(f);
                    continue;
                }
                if (f.delete()) continue;
                logger.log(Level.INFO, "Failed to delete file: " + f.getName());
            }
        }
        if (!dir.delete()) {
            logger.log(Level.INFO, "Failed to delete directory: " + dir.getName());
        }
    }

    public static void dirCopier(File source, File target) throws IOException {
        if (!source.isDirectory()) {
            throw new IOException(source + " is not a directory");
        }
        if (!target.exists() && !target.mkdirs()) {
            throw new IOException("Failed to create " + target.getName());
        }
        if (!target.isDirectory()) {
            throw new IOException(target + " is not a directory");
        }
        FileUtil.copyDir(source, target);
    }

    private static void copyDir(File sd, File td) throws IOException {
        File[] files = sd.listFiles();
        if (files != null) {
            for (File f : files) {
                File nt = new File(td, f.getName());
                if (f.isDirectory()) {
                    if (!nt.mkdir()) {
                        throw new IOException("Failed to make dir " + nt.getName());
                    }
                    FileUtil.copyDir(f, nt);
                    continue;
                }
                FileUtil.copyFile(f, nt);
            }
        }
    }

    private static void copyFile(File sf, File tf) throws IOException {
        RandomAccessFile sr = new RandomAccessFile(sf, "r");
        RandomAccessFile tr = new RandomAccessFile(tf, "rw");
        ChannelUtil.transferFully(sr.getChannel(), tr.getChannel());
        sr.close();
        tr.close();
    }
}

