# Interface for submodule: Image
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate


# Interface for class: Image
from ._proxies import ImageProxy as _ImageProxy
class _ImageTemplateGetter():
    def __getitem__(self, parameters) -> _ImageTemplate:
        """Specify class type with:
            	[INSERT_TYPE_NAMES_HERE]
            :return: ImageTemplate
            """
        ...


class _ImageTemplate(_itkTemplate, metaclass=_ImageTemplateGetter):
    """Interface for instantiating itk::Image< INSERT_TYPE_NAMES_HERE >
        Create a new Image Object (of default type):
            'itk.Image.New(**kwargs)
        Supports type specification through dictionary access:
            'itk.Image[INSERT_TYPE_NAMES_HERE].New(**kwargs)"""

    @staticmethod
    def New(**kwargs) -> _ImageProxy:
        """Instantiate itk::Image< INSERT_TYPE_NAMES_HERE >"""
        ...

Image = _ImageTemplate

