/* do not edit automatically generated by mc from M2ALU.  */
/* M2ALU.def gcc implementation of the M2ALU module.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2ALU_H)
#   define _M2ALU_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GNameKey.h"
#   include "GM2GCCDeclare.h"
#   include "Ggcctypes.h"

#   if defined (_M2ALU_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (M2ALU_PtrToValue_D)
#  define M2ALU_PtrToValue_D
   typedef void *M2ALU_PtrToValue;
#endif


/*
   InitValue - initializes and returns a value container.
*/

EXTERN M2ALU_PtrToValue M2ALU_InitValue (void);

/*
   IsValueTypeNone - returns TRUE if the value on the top stack has no value.
*/

EXTERN bool M2ALU_IsValueTypeNone (void);

/*
   IsValueTypeInteger - returns TRUE if the value on the top stack is an integer.
*/

EXTERN bool M2ALU_IsValueTypeInteger (void);

/*
   IsValueTypeReal - returns TRUE if the value on the top stack is a real.
*/

EXTERN bool M2ALU_IsValueTypeReal (void);

/*
   IsValueTypeComplex - returns TRUE if the value on the top stack is a complex.
*/

EXTERN bool M2ALU_IsValueTypeComplex (void);

/*
   IsValueTypeSet - returns TRUE if the value on the top stack is a set.
*/

EXTERN bool M2ALU_IsValueTypeSet (void);

/*
   IsValueTypeConstructor - returns TRUE if the value on the top
                            stack is a constructor.
*/

EXTERN bool M2ALU_IsValueTypeConstructor (void);

/*
   IsValueTypeArray - returns TRUE if the value on the top
                      stack is an array.
*/

EXTERN bool M2ALU_IsValueTypeArray (void);

/*
   IsValueTypeRecord - returns TRUE if the value on the top
                       stack is a record.
*/

EXTERN bool M2ALU_IsValueTypeRecord (void);

/*
   GetSetValueType - returns the set type on top of the ALU stack.
*/

EXTERN unsigned int M2ALU_GetSetValueType (void);

/*
   PushIntegerTree - pushes a gcc tree value onto the ALU stack.
*/

EXTERN void M2ALU_PushIntegerTree (tree t);

/*
   PopIntegerTree - pops a gcc tree value from the ALU stack.
*/

EXTERN tree M2ALU_PopIntegerTree (void);

/*
   PushRealTree - pushes a gcc tree value onto the ALU stack.
*/

EXTERN void M2ALU_PushRealTree (tree t);

/*
   PopRealTree - pops a gcc tree value from the ALU stack.
*/

EXTERN tree M2ALU_PopRealTree (void);

/*
   PushComplexTree - pushes a gcc tree value onto the ALU stack.
*/

EXTERN void M2ALU_PushComplexTree (tree t);

/*
   PopComplexTree - pops a gcc tree value from the ALU stack.
*/

EXTERN tree M2ALU_PopComplexTree (void);

/*
   PushSetTree - pushes a gcc tree onto the ALU stack.
                 The tree, t, is expected to contain a
                 word value. It is converted into a set
                 type (sym). Bit 0 maps onto MIN(sym).
*/

EXTERN void M2ALU_PushSetTree (unsigned int tokenno, tree t, unsigned int sym);

/*
   PopSetTree - pops a gcc tree from the ALU stack.
*/

EXTERN tree M2ALU_PopSetTree (unsigned int tokenno);

/*
   PopConstructorTree - returns a tree containing the compound literal.
*/

EXTERN tree M2ALU_PopConstructorTree (unsigned int tokenno);

/*
   PushFrom - pushes a copy of the contents of, v, onto stack.
*/

EXTERN void M2ALU_PushFrom (M2ALU_PtrToValue v);

/*
   PopInto - pops the top element from the stack and places it into, v.
*/

EXTERN void M2ALU_PopInto (M2ALU_PtrToValue v);

/*
   PushCard - pushes a cardinal onto the stack.
*/

EXTERN void M2ALU_PushCard (unsigned int c);

/*
   PushInt - pushes an integer onto the stack.
*/

EXTERN void M2ALU_PushInt (int i);

/*
   PushChar - pushes a char onto the stack.
*/

EXTERN void M2ALU_PushChar (char c);

/*
   PopChar - returns the value from the stack in a character.
*/

EXTERN char M2ALU_PopChar (unsigned int tokenno);

/*
   PushString - pushes the numerical value of the string onto the stack.
*/

EXTERN void M2ALU_PushString (unsigned int tokenno, NameKey_Name s, bool issueError);

/*
   CoerseLongRealToCard - performs a coersion between a REAL to a CARDINAL
*/

EXTERN void M2ALU_CoerseLongRealToCard (void);

/*
   ConvertRealToInt - converts a REAL into an INTEGER
*/

EXTERN void M2ALU_ConvertRealToInt (void);

/*
   ConvertToInt - converts the value into an INTEGER. This should be used
                  if we are computing the number of elements in a char set to
                  avoid an overflow.
*/

EXTERN void M2ALU_ConvertToInt (void);

/*
   ConvertToType - converts the top of stack to type, t.
*/

EXTERN void M2ALU_ConvertToType (unsigned int t);

/*
   IsSolved - returns true if the memory cell indicated by v
              has a known value.
*/

EXTERN bool M2ALU_IsSolved (M2ALU_PtrToValue v);

/*
   PutConstructorSolved - records that this constructor is solved.
*/

EXTERN void M2ALU_PutConstructorSolved (unsigned int sym);

/*
   EvaluateValue - attempts to evaluate the symbol, sym, value.
*/

EXTERN void M2ALU_EvaluateValue (unsigned int sym);

/*
   TryEvaluateValue - attempts to evaluate the symbol, sym, value.
*/

EXTERN void M2ALU_TryEvaluateValue (unsigned int sym);
EXTERN void M2ALU_Addn (void);

/*
   Sub - subtracts the top two elements on the stack.

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |                   <- Ptr
         |------------|    +------------+
         | Op2        |    | Op2 - Op1  |
         |------------|    |------------|
*/

EXTERN void M2ALU_Sub (void);
EXTERN void M2ALU_Multn (void);

/*
   DivFloor - divides the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 DIV Op1  |
              |------------|    |--------------|
*/

EXTERN void M2ALU_DivFloor (void);

/*
   ModFloor - modulus of the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 MOD Op1  |
              |------------|    |--------------|
*/

EXTERN void M2ALU_ModFloor (void);

/*
   DivTrunc - divides the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 DIV Op1  |
              |------------|    |--------------|
*/

EXTERN void M2ALU_DivTrunc (void);

/*
   ModTrunc - modulus of the top two elements on the stack.

              The Stack:

              Entry             Exit

       Ptr ->
              +------------+
              | Op1        |                     <- Ptr
              |------------|    +--------------+
              | Op2        |    | Op2 MOD Op1  |
              |------------|    |--------------|
*/

EXTERN void M2ALU_ModTrunc (void);

/*
   Equ - returns true if the top two elements on the stack
         are identical.

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |
         |------------|
         | Op2        |
         |------------|    Empty

         RETURN( Op2 = Op1 )
*/

EXTERN bool M2ALU_Equ (unsigned int tokenno);

/*
   NotEqu - returns true if the top two elements on the stack
            are not identical.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |
            |------------|
            | Op2        |
            |------------|    Empty

            RETURN( Op2 # Op1 )
*/

EXTERN bool M2ALU_NotEqu (unsigned int tokenno);

/*
   Less - returns true if Op2 < Op1.

          The Stack:

          Entry             Exit

   Ptr ->
          +------------+
          | Op1        |
          |------------|
          | Op2        |
          |------------|    Empty

          RETURN( Op2 < Op1 )
*/

EXTERN bool M2ALU_Less (unsigned int tokenno);

/*
   Gre - returns true if Op2 > Op1

         The Stack:

         Entry             Exit

  Ptr ->
         +------------+
         | Op1        |
         |------------|
         | Op2        |
         |------------|    Empty

         RETURN( Op2 > Op1 )
*/

EXTERN bool M2ALU_Gre (unsigned int tokenno);

/*
   LessEqu - returns true if Op2 <= Op1

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |
            |------------|
            | Op2        |
            |------------|    Empty

            RETURN( Op2 <= Op1 )
*/

EXTERN bool M2ALU_LessEqu (unsigned int tokenno);

/*
   GreEqu - returns true if Op2 >= Op1
            are not identical.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |
            |------------|
            | Op2        |
            |------------|    Empty

            RETURN( Op2 >= Op1 )
*/

EXTERN bool M2ALU_GreEqu (unsigned int tokenno);

/*
   IsNulSet - returns TRUE if the top element is the nul set constant, {}.
*/

EXTERN bool M2ALU_IsNulSet (void);

/*
   IsGenericNulSet - returns TRUE if the top element is the generic nul set constant, {}.
*/

EXTERN bool M2ALU_IsGenericNulSet (void);

/*
   PushNulSet - pushes an empty set {} onto the ALU stack. The subrange type used
                to construct the set is defined by, type. If this is NulSym then
                the set is generic and compatible with all sets.

                The Stack:

                Entry             Exit

                                                 <- Ptr
                                  +------------+
                                  | {}         |
                Ptr ->            |------------|

*/

EXTERN void M2ALU_PushNulSet (unsigned int settype);

/*
   AddBitRange - adds the range op1..op2 to the underlying set.

                 Ptr ->
                                                           <- Ptr
                        +------------+      +------------+
                        | Set        |      | Set        |
                        |------------|      |------------|
*/

EXTERN void M2ALU_AddBitRange (unsigned int tokenno, unsigned int op1, unsigned int op2);

/*
   AddBit - adds the bit op1 to the underlying set. INCL(Set, op1)

            Ptr ->
                                                      <- Ptr
                   +------------+      +------------+
                   | Set        |      | Set        |
                   |------------|      |------------|
*/

EXTERN void M2ALU_AddBit (unsigned int tokenno, unsigned int op1);

/*
   SubBit - removes a bit op1 from the underlying set. EXCL(Set, Op1)

            Ptr ->
                   +------------+
                   | Op1        |                     <- Ptr
                   |------------|      +------------+
                   | Set        |      | Set        |
                   |------------|      |------------|
*/

EXTERN void M2ALU_SubBit (unsigned int tokenno, unsigned int op1);

/*
   SetIn - returns true if the Op1 IN Set

           The Stack:

           Entry             Exit

    Ptr ->
           +------------+
           | Set        |
           |------------|
           | Op1        |
           |------------|    Empty

           RETURN( Op1 IN Set )
*/

EXTERN bool M2ALU_SetIn (unsigned int tokenno, unsigned int Op1);

/*
   SetOr -  performs an inclusive OR of the top two sets on the stack.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |                   <- Ptr
            |------------|    +------------+
            | Op2        |    | Op2 + Op1  |
            |------------|    |------------|

*/

EXTERN void M2ALU_SetOr (unsigned int tokenno);

/*
   SetAnd - performs a set AND the top two sets on the stack.

            The Stack:

            Entry             Exit

     Ptr ->
            +------------+
            | Op1        |                   <- Ptr
            |------------|    +------------+
            | Op2        |    | Op2 * Op1  |
            |------------|    |------------|
*/

EXTERN void M2ALU_SetAnd (unsigned int tokenno);

/*
   SetDifference - performs a set difference of the top two elements on the stack.
                   For each member in the set
                      if member in Op2 and not member in Op1

                   The Stack:

                   Entry             Exit

            Ptr ->
                   +------------+
                   | Op1        |                   <- Ptr
                   |------------|    +-------------------+
                   | Op2        |    | Op2 and (not Op1) |
                   |------------|    |-------------------|
*/

EXTERN void M2ALU_SetDifference (unsigned int tokenno);

/*
   SetSymmetricDifference - performs a set difference of the top two sets on the stack.

                            The Stack:

                            Entry             Exit

                     Ptr ->
                            +------------+
                            | Op1        |                   <- Ptr
                            |------------|    +------------+
                            | Op2        |    | Op2 - Op1  |
                            |------------|    |------------|
*/

EXTERN void M2ALU_SetSymmetricDifference (unsigned int tokenno);

/*
   SetNegate - negates the top set on the stack.

               Ptr ->                                               <- Ptr
                      +-----------+                  +------------+
                      | Set       |                  | Set        |
                      |-----------|                  |------------|
*/

EXTERN void M2ALU_SetNegate (unsigned int tokenno);

/*
   SetShift - if op1 is positive
              then
                 result := op2 << op1
              else
                 result := op2 >> op1
              fi


              The Stack:

                     Entry             Exit

              Ptr ->
                     +------------+
                     | Op1        |                   <- Ptr
                     |------------|    +------------+
                     | Op2        |    | result     |
                     |------------|    |------------|

*/

EXTERN void M2ALU_SetShift (unsigned int tokenno);

/*
   SetRotate - if op1 is positive
               then
                  result := ROTATERIGHT(op2, op1)
               else
                  result := ROTATELEFT(op2, op1)
               fi


               The Stack:

                      Entry             Exit

               Ptr ->
                      +------------+
                      | Op1        |                   <- Ptr
                      |------------|    +------------+
                      | Op2        |    | result     |
                      |------------|    |------------|
*/

EXTERN void M2ALU_SetRotate (unsigned int tokenno);

/*
   GetValue - returns and pops the value from the top of stack.
*/

EXTERN M2ALU_PtrToValue M2ALU_GetValue (unsigned int tokenno);

/*
   GetRange - returns TRUE if range number, n, exists in the value, v.
              A non empty set is defined by having 1..N ranges
*/

EXTERN bool M2ALU_GetRange (M2ALU_PtrToValue v, unsigned int n, unsigned int *low, unsigned int *high);

/*
   ConstructSetConstant - builds a struct of integers which represents the
                          set const, sym.
*/

EXTERN tree M2ALU_ConstructSetConstant (unsigned int tokenno, M2ALU_PtrToValue v);

/*
   BuildRange - returns a integer sized constant which represents the
                value  {e1..e2}.
*/

EXTERN tree M2ALU_BuildRange (unsigned int tokenno, tree e1, tree e2);

/*
   IsConstructorDependants - return TRUE if returned if all
                             q(dependants) of, sym, return TRUE.
*/

EXTERN bool M2ALU_IsConstructorDependants (unsigned int sym, M2GCCDeclare_IsAction q);

/*
   WalkConstructorDependants - walk the constructor, sym, calling
                               p for each dependant.
*/

EXTERN void M2ALU_WalkConstructorDependants (unsigned int sym, M2GCCDeclare_WalkAction p);

/*
   IsValueAndTreeKnown - returns TRUE if the value is known and the gcc tree
                         is defined.

                         The Stack:

                                Entry             Exit

                         Ptr ->
                                +------------+
                                | Op1        |                   <- Ptr
                                |------------|    +------------+
*/

EXTERN bool M2ALU_IsValueAndTreeKnown (void);

/*
   CheckOrResetOverflow - tests to see whether the tree, t, has caused
                          an overflow error and if so it generates an
                          error message.
*/

EXTERN void M2ALU_CheckOrResetOverflow (unsigned int tokenno, tree t, bool check);

/*
   AddElements - adds the elements, el BY, n, to the array constant.

                 Ptr ->
                                                           <- Ptr
                        +------------+      +------------+
                        | Array      |      | Array      |
                        |------------|      |------------|

*/

EXTERN void M2ALU_AddElements (unsigned int tokenno, unsigned int el, unsigned int n);

/*
   AddField - adds the field op1 to the underlying constructor.

              Ptr ->
                                                        <- Ptr
                     +------------+      +------------+
                     | const      |      | const      |
                     |------------|      |------------|

*/

EXTERN void M2ALU_AddField (unsigned int tokenno, unsigned int op1);

/*
   PushEmptyConstructor - pushes an empty constructor {} onto the ALU stack.
                          This is expected to be filled in by subsequent
                          calls to AddElements, AddRange or AddField.

                          The Stack:

                          Entry             Exit

                                                       <- Ptr
                                        +------------+
                                        | {}         |
                   Ptr ->               |------------|

*/

EXTERN void M2ALU_PushEmptyConstructor (unsigned int constype);

/*
   PushEmptyArray - pushes an empty array {} onto the ALU stack.
                    This is expected to be filled in by subsequent
                    calls to AddElements.

                    The Stack:

                    Entry             Exit

                                                     <- Ptr
                                      +------------+
                                      | {}         |
             Ptr ->                   |------------|

*/

EXTERN void M2ALU_PushEmptyArray (unsigned int arraytype);

/*
   PushEmptyRecord - pushes an empty record {} onto the ALU stack.
                     This is expected to be filled in by subsequent
                     calls to AddField.

                     The Stack:

                     Entry             Exit

                                                      <- Ptr
                                       +------------+
                                       | {}         |
              Ptr ->                   |------------|

*/

EXTERN void M2ALU_PushEmptyRecord (unsigned int recordtype);

/*
   ChangeToConstructor - change the top of stack value to a constructor, type.
*/

EXTERN void M2ALU_ChangeToConstructor (unsigned int tokenno, unsigned int constype);

/*
   IsValueConst - returns true if the memory cell indicated by v
                  is only defined by constants.  For example
                  no variables are used in the constructor.
*/

EXTERN bool M2ALU_IsValueConst (M2ALU_PtrToValue v);

/*
   PushTypeOfTree - pushes tree, gcc, to the stack and records the
                    front end type.
*/

EXTERN void M2ALU_PushTypeOfTree (unsigned int sym, tree gcc);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
