/* do not edit automatically generated by mc from M2AsmUtil.  */
/* M2AsmUtil.mod provides utilities relating symbols in the SymbolTable.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#define _M2AsmUtil_C

#include "GM2AsmUtil.h"
#   include "GSFIO.h"
#   include "GFIO.h"
#   include "GDynamicStrings.h"
#   include "GStdIO.h"
#   include "GStrIO.h"
#   include "GNameKey.h"
#   include "GM2Options.h"
#   include "GM2Printf.h"
#   include "GSymbolTable.h"
#   include "GM2Error.h"
#   include "Gm2configure.h"

#   define Debugging false

/*
   GetFullSymName - returns the NameKey for the symbol name (which also
                    may contain the module name).
*/

extern "C" NameKey_Name M2AsmUtil_GetFullSymName (unsigned int sym);

/*
   GetFullScopeAsmName - returns the fully qualified name for the symbol.
                         This will take the format
                         [DefImpModule|Module]_{InnerModule}_{Procedure}_SymbolName
*/

extern "C" NameKey_Name M2AsmUtil_GetFullScopeAsmName (unsigned int sym);

/*
   StringToKey - returns a Name, from a string and destroys the string.
*/

static NameKey_Name StringToKey (DynamicStrings_String s);

/*
   SymNeedsModulePrefix - return TRUE if symbol mod is required to have a prefix.
*/

static bool SymNeedsModulePrefix (unsigned int sym, unsigned int mod);

/*
   GetModulePrefix - returns a String containing the module prefix
                     for module, ModSym, providing symbol, Sym, is exported.
                     Name is marked if it is appended onto the new string.
*/

static DynamicStrings_String GetModulePrefix (DynamicStrings_String Name, unsigned int Sym, unsigned int ModSym);

/*
   GetFullScopePrefix - returns a String containing the full scope prefix
                        for symbol, Sym.  It honours IsExportQualified.
                        Name is marked if it is appended onto the new string.
*/

static DynamicStrings_String GetFullScopePrefix (DynamicStrings_String Name, unsigned int Scope, unsigned int Sym);


/*
   StringToKey - returns a Name, from a string and destroys the string.
*/

static NameKey_Name StringToKey (DynamicStrings_String s)
{
  NameKey_Name k;

  k = NameKey_makekey (DynamicStrings_string (s));
  s = DynamicStrings_KillString (s);
  return k;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SymNeedsModulePrefix - return TRUE if symbol mod is required to have a prefix.
*/

static bool SymNeedsModulePrefix (unsigned int sym, unsigned int mod)
{
  if (SymbolTable_IsDefImp (mod))
    {
      if (SymbolTable_IsExportUnQualified (sym))
        {
          return false;
        }
      else
        {
          /* We need to force the prefix if whole program is used otherwise
            local symbols from multipl modules might conflict.  */
          return M2Options_WholeProgram || (SymbolTable_IsExportQualified (sym));
        }
    }
  else if (SymbolTable_IsModule (mod))
    {
      /* avoid dangling else.  */
      return M2Options_WholeProgram;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetModulePrefix - returns a String containing the module prefix
                     for module, ModSym, providing symbol, Sym, is exported.
                     Name is marked if it is appended onto the new string.
*/

static DynamicStrings_String GetModulePrefix (DynamicStrings_String Name, unsigned int Sym, unsigned int ModSym)
{
  if ((ModSym != SymbolTable_NulSym) && (ModSym != (SymbolTable_GetBaseModule ())))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((SymbolTable_IsInnerModule (Sym)) || (SymbolTable_IsInnerModule (ModSym)))
        {
          return DynamicStrings_ConCat (DynamicStrings_ConCatChar (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (ModSym))), '_'), GetModulePrefix (Name, ModSym, SymbolTable_GetScope (ModSym)));
        }
      else if (SymNeedsModulePrefix (Sym, ModSym))
        {
          /* avoid dangling else.  */
          return DynamicStrings_ConCatChar (DynamicStrings_ConCat (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (ModSym))), DynamicStrings_Mark (Name)), '_');
        }
    }
  return Name;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFullScopePrefix - returns a String containing the full scope prefix
                        for symbol, Sym.  It honours IsExportQualified.
                        Name is marked if it is appended onto the new string.
*/

static DynamicStrings_String GetFullScopePrefix (DynamicStrings_String Name, unsigned int Scope, unsigned int Sym)
{
  if (Sym != SymbolTable_NulSym)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsInnerModule (Scope))
        {
          return DynamicStrings_ConCat (DynamicStrings_ConCatChar (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (Scope))), '_'), GetFullScopePrefix (Name, SymbolTable_GetScope (Scope), Sym));
        }
      else if ((SymbolTable_IsDefImp (Scope)) && (SymbolTable_IsExportQualified (Sym)))
        {
          /* avoid dangling else.  */
          return DynamicStrings_ConCatChar (DynamicStrings_ConCat (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (Scope))), DynamicStrings_Mark (Name)), '_');
        }
      else if (SymbolTable_IsProcedure (Scope))
        {
          /* avoid dangling else.  */
          return DynamicStrings_ConCatChar (DynamicStrings_ConCat (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (Scope))), DynamicStrings_Mark (Name)), '_');
        }
    }
  return Name;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFullSymName - returns the NameKey for the symbol name (which also
                    may contain the module name).
*/

extern "C" NameKey_Name M2AsmUtil_GetFullSymName (unsigned int sym)
{
  DynamicStrings_String libname;
  DynamicStrings_String fullsymname;
  DynamicStrings_String module;
  unsigned int scope;

  if ((SymbolTable_IsProcedure (sym)) && (SymbolTable_IsMonoName (sym)))
    {
      return SymbolTable_GetSymName (sym);
    }
  else
    {
      scope = SymbolTable_GetScope (sym);
      module = GetModulePrefix (DynamicStrings_InitString ((const char *) "", 0), sym, scope);
      fullsymname = DynamicStrings_ConCat (module, DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym))));
      if (((SymbolTable_IsVar (sym)) || (SymbolTable_IsProcedure (sym))) && (SymbolTable_IsExportQualified (sym)))
        {
          while (! (SymbolTable_IsDefImp (scope)))
            {
              scope = SymbolTable_GetScope (scope);
            }
          if ((SymbolTable_GetLibName (scope)) != NameKey_NulName)
            {
              if (Debugging)
                {
                  M2Printf_printf1 ((const char *) "before sym = %s  , ", 19, (const unsigned char *) &fullsymname, (sizeof (fullsymname)-1));
                }
              libname = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetLibName (scope)));
              if (! (DynamicStrings_EqualArray (libname, (const char *) "", 0)))
                {
                  if (Debugging)
                    {
                      M2Printf_printf1 ((const char *) "libname = %s  , ", 16, (const unsigned char *) &libname, (sizeof (libname)-1));
                    }
                  fullsymname = DynamicStrings_ConCat (DynamicStrings_ConCatChar (libname, '_'), fullsymname);
                }
              if (Debugging)
                {
                  M2Printf_printf1 ((const char *) "after sym = %s\\n", 16, (const unsigned char *) &fullsymname, (sizeof (fullsymname)-1));
                }
            }
        }
      return StringToKey (fullsymname);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFullScopeAsmName - returns the fully qualified name for the symbol.
                         This will take the format
                         [DefImpModule|Module]_{InnerModule}_{Procedure}_SymbolName
*/

extern "C" NameKey_Name M2AsmUtil_GetFullScopeAsmName (unsigned int sym)
{
  DynamicStrings_String leader;
  unsigned int scope;

  scope = SymbolTable_GetScope (sym);
  if (m2configure_UseUnderscoreForC)
    {
      leader = DynamicStrings_InitString ((const char *) "_", 1);
    }
  else
    {
      leader = DynamicStrings_InitString ((const char *) "", 0);
    }
  if ((SymbolTable_IsProcedure (sym)) && (SymbolTable_IsMonoName (sym)))
    {
      return StringToKey (DynamicStrings_ConCat (leader, DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym)))));
    }
  else
    {
      return StringToKey (DynamicStrings_ConCat (GetFullScopePrefix (leader, scope, sym), DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym)))));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2AsmUtil_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2AsmUtil_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
