/* do not edit automatically generated by mc from M2Bitset.  */
/* M2Bitset.mod provides the BITSET type.

Copyright (C) 2003-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#define _M2Bitset_C

#include "GM2Bitset.h"
#   include "GM2Debug.h"
#   include "Gm2linemap.h"
#   include "Gm2type.h"
#   include "Gm2decl.h"
#   include "Gm2expr.h"
#   include "GM2ALU.h"
#   include "GNameKey.h"
#   include "GM2System.h"
#   include "GM2Base.h"
#   include "GM2LexBuf.h"
#   include "GSymbolTable.h"

static unsigned int MinBitset;
static unsigned int MaxBitset;

/*
   MakeBitset - creates and declares the type BITSET.
*/

extern "C" void M2Bitset_MakeBitset (void);

/*
   GetBitsetMinMax - assigns min and max to the minimum and maximum values of BITSET.
*/

extern "C" void M2Bitset_GetBitsetMinMax (unsigned int *min, unsigned int *max);


/*
   MakeBitset - creates and declares the type BITSET.
*/

extern "C" void M2Bitset_MakeBitset (void)
{
  M2Bitset_Bitset = SymbolTable_MakeSet (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "BITSET", 6));  /* Base Type  */
  /* MinBitset  */
  MinBitset = SymbolTable_MakeConstLit (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
  /* MaxBitset  */
  MaxBitset = SymbolTable_MakeConstVar (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "MaxBitset", 9));
  M2ALU_PushCard (static_cast<unsigned int> ((m2decl_GetBitsPerBitset ())-1));
  SymbolTable_PopValue (MaxBitset);
  M2Debug_Assert (M2System_Word != SymbolTable_NulSym);
  M2Bitset_Bitnum = SymbolTable_MakeSubrange (M2LexBuf_BuiltinTokenNo, NameKey_MakeKey ((const char *) "BITNUM", 6));
  SymbolTable_PutSubrange (M2Bitset_Bitnum, MinBitset, MaxBitset, M2Base_Cardinal);
  SymbolTable_PutSet (M2Bitset_Bitset, M2Bitset_Bitnum, false);
  M2ALU_PushIntegerTree (m2expr_GetSizeOf (m2linemap_BuiltinsLocation (), m2type_GetWordType ()));
  SymbolTable_PopSize (M2Bitset_Bitset);
}


/*
   GetBitsetMinMax - assigns min and max to the minimum and maximum values of BITSET.
*/

extern "C" void M2Bitset_GetBitsetMinMax (unsigned int *min, unsigned int *max)
{
  (*min) = MinBitset;
  (*max) = MaxBitset;
}

extern "C" void _M2_M2Bitset_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2Bitset_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
