/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern1 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  switch (GET_CODE (x4))
    {
    case AND:
      return pattern0 (x1, pnum_clobbers); /* [-1, 0] */

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      return 1;

    default:
      return -1;
    }
}

int
pattern16 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern25 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern27 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode)
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x1) != E_V4DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern36 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 8
      || GET_MODE (x3) != E_XFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 9
      || GET_MODE (x5) != E_XFmode)
    return -1;
  x6 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x6) != CLOBBER)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 10
      || GET_MODE (x7) != E_XFmode)
    return -1;
  x8 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x8) != CLOBBER)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_CODE (x9) != REG
      || REGNO (x9) != 11
      || GET_MODE (x9) != E_XFmode)
    return -1;
  x10 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x10) != CLOBBER)
    return -1;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != REG
      || REGNO (x11) != 12
      || GET_MODE (x11) != E_XFmode)
    return -1;
  x12 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x12) != CLOBBER)
    return -1;
  x13 = XEXP (x12, 0);
  if (GET_CODE (x13) != REG
      || REGNO (x13) != 13
      || GET_MODE (x13) != E_XFmode)
    return -1;
  x14 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x14) != CLOBBER)
    return -1;
  x15 = XEXP (x14, 0);
  if (GET_CODE (x15) != REG
      || REGNO (x15) != 14
      || GET_MODE (x15) != E_XFmode)
    return -1;
  x16 = XVECEXP (x1, 0, 8);
  if (GET_CODE (x16) != CLOBBER)
    return -1;
  x17 = XEXP (x16, 0);
  if (GET_CODE (x17) != REG
      || REGNO (x17) != 15
      || GET_MODE (x17) != E_XFmode)
    return -1;
  return 0;
}

int
pattern47 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (x1))
    {
    case E_QImode:
      if (!nonimmediate_operand (operands[1], E_QImode)
          || !general_operand (operands[2], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!nonimmediate_operand (operands[1], E_HImode)
          || !general_operand (operands[2], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !x86_64_general_operand (operands[2], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !x86_64_general_operand (operands[2], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern55 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_CCmode)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[0] = x4;
  if (!register_operand (operands[0], i1))
    return -1;
  return 0;
}

int
pattern59 (rtx x1, int *pnum_clobbers, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i1))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern63 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i1))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], i1))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern69 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case ASHIFT:
      if (GET_MODE (x2) != E_TImode)
        return -1;
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != ZERO_EXTEND
          || GET_MODE (x3) != E_TImode)
        return -1;
      x4 = XEXP (x2, 1);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 64]
          || !nonimmediate_operand (operands[0], E_TImode)
          || GET_MODE (x1) != E_TImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_TImode
          || !nonimmediate_operand (operands[1], E_TImode)
          || !const_scalar_int_operand (operands[3], E_TImode))
        return -1;
      x6 = XEXP (x3, 0);
      operands[2] = x6;
      if (!nonimmediate_operand (operands[2], E_DImode))
        return -1;
      return 0;

    case ZERO_EXTEND:
      x3 = XEXP (x2, 0);
      operands[2] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (!nonimmediate_operand (operands[0], E_TImode)
              || GET_MODE (x1) != E_TImode)
            return -1;
          x5 = XEXP (x1, 0);
          if (GET_MODE (x5) != E_TImode
              || !nonimmediate_operand (operands[1], E_TImode)
              || !const_scalar_int_operand (operands[3], E_TImode)
              || GET_MODE (x2) != E_TImode
              || !nonimmediate_operand (operands[2], E_DImode))
            return -1;
          return 1;

        case E_DImode:
          if (!nonimmediate_operand (operands[0], E_DImode)
              || GET_MODE (x1) != E_DImode)
            return -1;
          x5 = XEXP (x1, 0);
          if (GET_MODE (x5) != E_DImode
              || !nonimmediate_operand (operands[1], E_DImode)
              || !const_int_operand (operands[3], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !nonimmediate_operand (operands[2], E_SImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern100 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 2);
  operands[2] = x4;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x5 = XEXP (x1, 1);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V2QImode:
      return pattern97 (x1, 
E_V2QImode); /* [-1, 0] */

    case E_V4QImode:
      res = pattern98 (x1, 
E_V4QImode);
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    case E_V8QImode:
      if (!memory_operand (operands[0], E_V8QImode)
          || GET_MODE (x1) != E_V8QImode
          || GET_MODE (x2) != E_V8QImode)
        return -1;
      res = pattern99 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    case E_V4HImode:
      res = pattern98 (x1, 
E_V4HImode);
      if (res >= 0)
        return res + 6; /* [6, 7] */
      return -1;

    case E_V2HImode:
      if (pattern97 (x1, 
E_V2HImode) != 0)
        return -1;
      return 8;

    case E_V2SImode:
      if (pattern97 (x1, 
E_V2SImode) != 0)
        return -1;
      return 9;

    default:
      return -1;
    }
}

int
pattern115 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (!nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 0;

    case E_SImode:
      if (!nonimmediate_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern124 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_MODE (x2))
    {
    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern131 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern139 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern146 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern148 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 2);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern146 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern146 (x1, 
E_V8SImode, 
E_QImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern146 (x1, 
E_V4SImode, 
E_QImode) != 0)
        return -1;
      return 2;

    case E_V8DImode:
      if (pattern146 (x1, 
E_V8DImode, 
E_QImode) != 0)
        return -1;
      return 3;

    case E_V4DImode:
      if (pattern146 (x1, 
E_V4DImode, 
E_QImode) != 0)
        return -1;
      return 4;

    case E_V2DImode:
      if (pattern146 (x1, 
E_V2DImode, 
E_QImode) != 0)
        return -1;
      return 5;

    case E_V64QImode:
      if (pattern146 (x1, 
E_V64QImode, 
E_DImode) != 0)
        return -1;
      return 6;

    case E_V16QImode:
      if (pattern146 (x1, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 7;

    case E_V32QImode:
      if (pattern146 (x1, 
E_V32QImode, 
E_SImode) != 0)
        return -1;
      return 8;

    case E_V32HImode:
      if (pattern146 (x1, 
E_V32HImode, 
E_SImode) != 0)
        return -1;
      return 9;

    case E_V16HImode:
      if (pattern147 (x1, 
E_V16HImode) != 0)
        return -1;
      return 10;

    case E_V8HImode:
      if (pattern146 (x1, 
E_V8HImode, 
E_QImode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern161 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern152 (x3, 
E_V16SImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern152 (x3, 
E_V8SImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern152 (x3, 
E_V4SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern170 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V4SImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  if (!register_operand (operands[1], E_V4SImode))
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  operands[2] = x3;
  if (!register_operand (operands[2], E_V4SImode))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  operands[3] = x4;
  if (!vector_operand (operands[3], E_V4SImode))
    return -1;
  return 0;
}

int
pattern178 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V8SImode:
      return pattern172 (x3, 
E_V8SImode); /* [-1, 0] */

    case E_V4SImode:
      if (pattern172 (x3, 
E_V4SImode) != 0)
        return -1;
      return 1;

    case E_V16SImode:
      if (pattern172 (x3, 
E_V16SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern185 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !const0_operand (operands[3], i1)
      || !vector_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern191 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i3))
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern195 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || !ternlog_operand (operands[1], E_V32HFmode))
        return -1;
      return 0;

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || !ternlog_operand (operands[1], E_V16HFmode))
        return -1;
      return 1;

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || !ternlog_operand (operands[1], E_V8HFmode))
        return -1;
      return 2;

    case E_V32BFmode:
      if (!register_operand (operands[0], E_V32BFmode)
          || !ternlog_operand (operands[1], E_V32BFmode))
        return -1;
      return 3;

    case E_V16BFmode:
      if (!register_operand (operands[0], E_V16BFmode)
          || !ternlog_operand (operands[1], E_V16BFmode))
        return -1;
      return 4;

    case E_V8BFmode:
      if (!register_operand (operands[0], E_V8BFmode)
          || !ternlog_operand (operands[1], E_V8BFmode))
        return -1;
      return 5;

    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || !ternlog_operand (operands[1], E_V16SFmode))
        return -1;
      return 6;

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || !ternlog_operand (operands[1], E_V8SFmode))
        return -1;
      return 7;

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || !ternlog_operand (operands[1], E_V4SFmode))
        return -1;
      return 8;

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || !ternlog_operand (operands[1], E_V8DFmode))
        return -1;
      return 9;

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || !ternlog_operand (operands[1], E_V4DFmode))
        return -1;
      return 10;

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || !ternlog_operand (operands[1], E_V2DFmode))
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern204 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      return pattern202 (x4); /* [-1, 7] */

    case ASHIFT:
      x7 = XEXP (x4, 0);
      operands[0] = x7;
      x8 = XEXP (x6, 0);
      operands[1] = x8;
      x9 = XEXP (x6, 1);
      operands[2] = x9;
      if (!const_int_operand (operands[2], E_QImode))
        return -1;
      x10 = XEXP (x5, 1);
      operands[3] = x10;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern203 (x5, 
E_DImode) != 0)
            return -1;
          return 8;

        case E_TImode:
          if (pattern203 (x5, 
E_TImode) != 0)
            return -1;
          return 9;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern214 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x4, 1);
  operands[2] = x6;
  x7 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x7))
    {
    case CLOBBER:
      x8 = XEXP (x7, 0);
      if (GET_CODE (x8) != REG
          || REGNO (x8) != 17
          || GET_MODE (x8) != E_CCmode)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          return pattern211 (x4, 
E_DImode); /* [-1, 0] */

        case E_TImode:
          if (pattern211 (x4, 
E_TImode) != 0)
            return -1;
          return 1;

        case E_QImode:
          if (pattern211 (x4, 
E_QImode) != 0)
            return -1;
          return 2;

        case E_HImode:
          if (pattern211 (x4, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_SImode:
          if (pattern211 (x4, 
E_SImode) != 0)
            return -1;
          return 4;

        default:
          return -1;
        }

    case UNSPEC:
      if (pattern213 (x1) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern231 (rtx x1, machine_mode i1, unsigned int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != CLOBBER)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != i2
      || GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern237 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!mask_reg_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !mask_reg_operand (operands[1], i1)
      || !mask_reg_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern243 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  x7 = XEXP (x2, 1);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[2] = x7;
      x8 = XEXP (x2, 2);
      operands[3] = x8;
      return 0;

    case ZERO_EXTEND:
      if (GET_MODE (x7) != E_DImode)
        return -1;
      x8 = XEXP (x2, 2);
      if (GET_CODE (x8) != ZERO_EXTEND
          || GET_MODE (x8) != E_DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern258 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x2;
      return 0;

    case STRICT_LOW_PART:
      if (pnum_clobbers == NULL)
        return -1;
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      if (!nonmemory_operand (operands[2], E_QImode))
        return -1;
      x4 = XEXP (x1, 1);
      res = pattern39 (x4);
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    default:
      return -1;
    }
}

int
pattern264 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  return pattern263 (); /* [-1, 2] */
}

int
pattern269 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case SUBREG:
      if (pnum_clobbers == NULL
          || maybe_ne (SUBREG_BYTE (x2), 0)
          || GET_MODE (x2) != E_QImode)
        return -1;
      x3 = XEXP (x2, 0);
      switch (GET_CODE (x3))
        {
        case AND:
          x4 = XEXP (x3, 0);
          operands[2] = x4;
          if (!int248_register_operand (operands[2], E_VOIDmode))
            return -1;
          return pattern268 (x1); /* [-1, 1] */

        case PLUS:
          x4 = XEXP (x3, 0);
          operands[2] = x4;
          if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
            return -1;
          res = pattern268 (x1);
          if (res >= 0)
            return res + 2; /* [2, 3] */
          return -1;

        case MINUS:
          x4 = XEXP (x3, 0);
          operands[3] = x4;
          if (!const_int_operand (operands[3], E_VOIDmode))
            return -1;
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
            return -1;
          res = pattern2 (x1);
          if (res >= 0)
            return res + 4; /* [4, 5] */
          return -1;

        default:
          return -1;
        }

    case CONST_INT:
      return 6;

    default:
      return -1;
    }
}

int
pattern291 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  x5 = XEXP (x2, 1);
  switch (GET_CODE (x5))
    {
    case LTU:
    case UNLT:
      operands[4] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XEXP (x5, 0);
      operands[3] = x7;
      if (!flags_reg_operand (operands[3], E_VOIDmode))
        return -1;
      return 0;

    case EQ:
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XEXP (x5, 0);
      operands[3] = x7;
      if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern303 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_DImode
      || !register_operand (operands[0], E_DImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  if (!register_operand (operands[1], E_DImode))
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  operands[2] = x3;
  if (!register_mmxmem_operand (operands[2], E_DImode))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  operands[3] = x4;
  if (!const_0_to_255_mul_8_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern310 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_SImode
      || !nonimmediate_operand (operands[1], E_HImode)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern318 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !float_vector_all_ones_operand (operands[1], i1)
      || !const0_operand (operands[2], i1)
      || !register_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern323 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x2;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HImode:
          return 0;

        case E_V16SImode:
          return 1;

        case E_V8DImode:
          return 2;

        case E_V16HImode:
          return 3;

        case E_V8SImode:
          return 4;

        case E_V4DImode:
          return 5;

        case E_V8HImode:
          return 6;

        case E_V4SImode:
          return 7;

        case E_V2DImode:
          return 8;

        default:
          return -1;
        }

    case VEC_SELECT:
      if (GET_MODE (x2) != E_V2SFmode)
        return -1;
      x3 = XEXP (x2, 1);
      if (GET_CODE (x3) != PARALLEL
          || XVECLEN (x3, 0) != 2)
        return -1;
      x4 = XVECEXP (x3, 0, 0);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x5 = XVECEXP (x3, 0, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !register_operand (operands[0], E_V2DImode)
          || GET_MODE (x1) != E_V2DImode)
        return -1;
      x6 = XEXP (x2, 0);
      operands[1] = x6;
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 9;

    default:
      return -1;
    }
}

int
pattern331 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      return pattern330 (x1, 
E_V8HImode); /* [-1, 0] */

    case E_V4SImode:
      if (pattern330 (x1, 
E_V4SImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern335 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != VEC_SELECT)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PARALLEL)
    return -1;
  x6 = XEXP (x2, 1);
  if (GET_CODE (x6) != i1)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != VEC_SELECT)
    return -1;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != PARALLEL)
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != PLUS)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != i1)
    return -1;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != VEC_SELECT)
    return -1;
  x12 = XEXP (x11, 1);
  if (GET_CODE (x12) != PARALLEL)
    return -1;
  x13 = XEXP (x9, 1);
  if (GET_CODE (x13) != i1)
    return -1;
  x14 = XEXP (x13, 0);
  if (GET_CODE (x14) != VEC_SELECT)
    return -1;
  x15 = XEXP (x14, 1);
  if (GET_CODE (x15) != PARALLEL)
    return -1;
  x16 = XEXP (x4, 0);
  operands[1] = x16;
  x17 = XEXP (x7, 0);
  if (!rtx_equal_p (x17, operands[1]))
    return -1;
  x18 = XEXP (x11, 0);
  if (!rtx_equal_p (x18, operands[1]))
    return -1;
  x19 = XEXP (x14, 0);
  if (!rtx_equal_p (x19, operands[1]))
    return -1;
  switch (XVECLEN (x5, 0))
    {
    case 4:
      x20 = XVECEXP (x5, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x21 = XVECEXP (x5, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x22 = XVECEXP (x5, 0, 2);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x23 = XVECEXP (x5, 0, 3);
      if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 12]
          || XVECLEN (x8, 0) != 4)
        return -1;
      x24 = XVECEXP (x8, 0, 0);
      if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x25 = XVECEXP (x8, 0, 1);
      if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x26 = XVECEXP (x8, 0, 2);
      if (x26 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
        return -1;
      x27 = XVECEXP (x8, 0, 3);
      if (x27 != const_int_rtx[MAX_SAVED_CONST_INT + 13]
          || XVECLEN (x12, 0) != 4)
        return -1;
      x28 = XVECEXP (x12, 0, 0);
      if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x29 = XVECEXP (x12, 0, 1);
      if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x30 = XVECEXP (x12, 0, 2);
      if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
        return -1;
      x31 = XVECEXP (x12, 0, 3);
      if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 14]
          || XVECLEN (x15, 0) != 4)
        return -1;
      x32 = XVECEXP (x15, 0, 0);
      if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x33 = XVECEXP (x15, 0, 1);
      if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x34 = XVECEXP (x15, 0, 2);
      if (x34 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
        return -1;
      x35 = XVECEXP (x15, 0, 3);
      if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 15]
          || pattern334 (x1, 
E_V4QImode, 
E_V4SImode, 
E_V16QImode) != 0)
        return -1;
      return 0;

    case 2:
      x20 = XVECEXP (x5, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x21 = XVECEXP (x5, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 4]
          || XVECLEN (x8, 0) != 2)
        return -1;
      x24 = XVECEXP (x8, 0, 0);
      if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x25 = XVECEXP (x8, 0, 1);
      if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 5]
          || XVECLEN (x12, 0) != 2)
        return -1;
      x28 = XVECEXP (x12, 0, 0);
      if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x29 = XVECEXP (x12, 0, 1);
      if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 6]
          || XVECLEN (x15, 0) != 2)
        return -1;
      x32 = XVECEXP (x15, 0, 0);
      if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x33 = XVECEXP (x15, 0, 1);
      if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern334 (x1, 
E_V2HImode, 
E_V2DImode, 
E_V8HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern374 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != CLOBBER)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17
      || GET_MODE (x2) != E_CCmode)
    return -1;
  return 0;
}

int
pattern378 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern383 (rtx x1, int i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != UNSPEC
      || XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  return 0;
}

int
pattern388 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (!register_operand (operands[0], E_SFmode)
          || GET_MODE (x1) != E_SFmode)
        return -1;
      return 0;

    case E_DFmode:
      if (!register_operand (operands[0], E_DFmode)
          || GET_MODE (x1) != E_DFmode)
        return -1;
      return 1;

    case E_XFmode:
      if (!register_operand (operands[0], E_XFmode)
          || GET_MODE (x1) != E_XFmode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern396 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (XINT (x1, 1) != i1
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 20
      || GET_MODE (x2) != E_V2DImode)
    return -1;
  return 0;
}

int
pattern404 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  switch (GET_CODE (x4))
    {
    case ASHIFT:
      x5 = XEXP (x4, 1);
      operands[3] = x5;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[2] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              return pattern400 (x1, 
E_DImode, 
E_SImode); /* [-1, 0] */

            case E_TImode:
              if (pattern400 (x1, 
E_TImode, 
E_DImode) != 0)
                return -1;
              return 1;

            default:
              return -1;
            }

        case SIGN_EXTEND:
          res = pattern402 (x1);
          if (res >= 0)
            return res + 2; /* [2, 3] */
          return -1;

        case ZERO_EXTEND:
          res = pattern402 (x1);
          if (res >= 0)
            return res + 4; /* [4, 5] */
          return -1;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_WIDE_INT:
      operands[2] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern403 (x1, 
E_DImode, 
E_SImode) != 0)
            return -1;
          return 6;

        case E_TImode:
          if (pattern403 (x1, 
E_TImode, 
E_DImode) != 0)
            return -1;
          return 7;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern423 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (maybe_ne (SUBREG_BYTE (x3), 0)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != AND)
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  return pattern422 (x2, 
i1); /* [-1, 0] */
}

int
pattern431 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!const248_operand (operands[2], E_VOIDmode))
    return -1;
  return pattern430 (x1); /* [-1, 1] */
}

int
pattern438 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != ASHIFT
      || GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  return 0;
}

int
pattern443 (rtx x1, rtx_code i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != MINUS
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern451 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern460 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !vector_operand (operands[1], i2)
      || !vector_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i2))
    return -1;
  x3 = XEXP (x1, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[4], E_QImode))
    return -1;
  return 0;
}

int
pattern469 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  if (!const_0_to_255_operand (operands[2], E_SImode))
    return -1;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V32BFmode:
      return pattern468 (x1, 
E_V32BFmode, 
E_SImode); /* [-1, 0] */

    case E_V16BFmode:
      if (pattern468 (x1, 
E_V16BFmode, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_V8BFmode:
      if (pattern468 (x1, 
E_V8BFmode, 
E_QImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern477 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  if (!register_operand (x6, E_QImode))
    return -1;
  x7 = XEXP (x1, 1);
  switch (GET_CODE (x7))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x7;
      operands[5] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DImode:
          return pattern475 (x1, 
E_V8DImode); /* [-1, 0] */

        case E_V4DImode:
          if (pattern475 (x1, 
E_V4DImode) != 0)
            return -1;
          return 1;

        case E_V2DImode:
          if (pattern475 (x1, 
E_V2DImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      if (!rtx_equal_p (x7, operands[1]))
        return -1;
      operands[4] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DImode:
          if (pattern476 (x1, 
E_V8DImode) != 0)
            return -1;
          return 3;

        case E_V4DImode:
          if (pattern476 (x1, 
E_V4DImode) != 0)
            return -1;
          return 4;

        case E_V2DImode:
          if (pattern476 (x1, 
E_V2DImode) != 0)
            return -1;
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern494 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern497 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i3))
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i1
      || !nonimm_or_0_operand (operands[2], i2)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern503 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V2SImode)
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_CODE (x4) != CONST_VECTOR
      || XVECLEN (x4, 0) != 2
      || GET_MODE (x4) != E_V2SImode)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
      || !register_operand (operands[0], E_V4SImode)
      || GET_MODE (x1) != E_V4SImode
      || GET_MODE (x2) != E_V2SImode)
    return -1;
  x7 = XEXP (x3, 0);
  operands[1] = x7;
  if (!nonimmediate_operand (operands[1], E_V2DFmode))
    return -1;
  return pattern502 (x2); /* [-1, 1] */
}

int
pattern508 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4SImode:
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern516 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V16HFmode)
      || GET_MODE (x1) != E_V16HFmode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V16HImode:
      if (!vector_operand (operands[1], E_V16HImode))
        return -1;
      return 0;

    case E_V16SImode:
      if (!vector_operand (operands[1], E_V16SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern520 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i3)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i2)
      || !const0_operand (operands[2], i2)
      || !const0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern528 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !regmem_or_bitnot_regmem_operand (operands[1], i1)
      || !regmem_or_bitnot_regmem_operand (operands[2], i1)
      || !regmem_or_bitnot_regmem_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern532 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[3] = x3;
  x4 = XEXP (x2, 1);
  operands[4] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      return pattern526 (x1, 
E_V32HFmode); /* [-1, 0] */

    case E_V16HFmode:
      if (pattern526 (x1, 
E_V16HFmode) != 0)
        return -1;
      return 1;

    case E_V8HFmode:
      if (pattern526 (x1, 
E_V8HFmode) != 0)
        return -1;
      return 2;

    case E_V32BFmode:
      if (pattern526 (x1, 
E_V32BFmode) != 0)
        return -1;
      return 3;

    case E_V16BFmode:
      if (pattern526 (x1, 
E_V16BFmode) != 0)
        return -1;
      return 4;

    case E_V8BFmode:
      if (pattern526 (x1, 
E_V8BFmode) != 0)
        return -1;
      return 5;

    case E_V16SFmode:
      if (pattern526 (x1, 
E_V16SFmode) != 0)
        return -1;
      return 6;

    case E_V8SFmode:
      if (pattern526 (x1, 
E_V8SFmode) != 0)
        return -1;
      return 7;

    case E_V4SFmode:
      if (pattern526 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 8;

    case E_V8DFmode:
      if (pattern526 (x1, 
E_V8DFmode) != 0)
        return -1;
      return 9;

    case E_V4DFmode:
      if (pattern526 (x1, 
E_V4DFmode) != 0)
        return -1;
      return 10;

    case E_V2DFmode:
      if (pattern526 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern539 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern542 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_XFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != UNSPEC
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != i1
      || GET_MODE (x5) != E_XFmode)
    return -1;
  x6 = XEXP (x2, 0);
  operands[0] = x6;
  if (!register_operand (operands[0], E_XFmode))
    return -1;
  x7 = XVECEXP (x3, 0, 0);
  operands[2] = x7;
  if (!register_operand (operands[2], E_XFmode))
    return -1;
  x8 = XEXP (x4, 0);
  operands[1] = x8;
  if (!register_operand (operands[1], E_XFmode))
    return -1;
  x9 = XVECEXP (x5, 0, 0);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  return 0;
}

int
pattern550 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x6))
    {
    case CLOBBER:
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17
          || GET_MODE (x7) != E_CCmode)
        return -1;
      return 0;

    case UNSPEC:
      if (pnum_clobbers == NULL
          || XVECLEN (x6, 0) != 1
          || XINT (x6, 1) != 38)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern559 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != i1)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != CLOBBER)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != REG
      || REGNO (x6) != 17
      || GET_MODE (x6) != E_CCmode)
    return -1;
  x7 = XEXP (x3, 0);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  x9 = XEXP (x4, 0);
  operands[2] = x9;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      return pattern558 (x3, 
E_SImode, 
E_DImode); /* [-1, 0] */

    case E_TImode:
      if (pattern558 (x3, 
E_DImode, 
E_TImode) != 0)
        return -1;
      return 1;

    case E_HImode:
      if (pattern558 (x3, 
E_QImode, 
E_HImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern572 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], E_SImode)
      || !register_operand (operands[2], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern580 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  if (!int248_register_operand (operands[1], E_VOIDmode))
    return -1;
  x8 = XEXP (x4, 1);
  operands[2] = x8;
  if (!general_operand (operands[2], E_QImode))
    return -1;
  x9 = XVECEXP (x1, 0, 1);
  return pattern579 (x9); /* [-1, 2] */
}

int
pattern584 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  return pattern223 (x1); /* [-1, 1] */
}

int
pattern587 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != US_MINUS)
    return -1;
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XVECEXP (x1, 0, 1);
  operands[3] = x5;
  x6 = XVECEXP (x1, 0, 2);
  operands[4] = x6;
  if (!const_0_to_7_operand (operands[4], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      return pattern419 (x1, 
E_V64QImode, 
E_DImode); /* [-1, 0] */

    case E_HImode:
      res = pattern418 (x1);
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    case E_SImode:
      res = pattern454 (x1);
      if (res >= 0)
        return res + 3; /* [3, 4] */
      return -1;

    case E_QImode:
      if (pattern419 (x1, 
E_V8HImode, 
E_QImode) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern598 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 1);
  if (GET_CODE (x3) != AND)
    return -1;
  x4 = XEXP (x1, 0);
  if (GET_MODE (x4) != E_CCZmode
      || GET_MODE (x2) != E_CCZmode)
    return -1;
  x5 = XVECEXP (x2, 0, 0);
  x6 = XEXP (x5, 0);
  operands[0] = x6;
  x7 = XEXP (x5, 1);
  operands[1] = x7;
  x8 = XEXP (x3, 0);
  if (!rtx_equal_p (x8, operands[0]))
    return -1;
  x9 = XEXP (x3, 1);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  switch (GET_MODE (x5))
    {
    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || !vector_operand (operands[1], E_V16QImode)
          || GET_MODE (x3) != E_V16QImode)
        return -1;
      return 0;

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || !vector_operand (operands[1], E_V8HImode)
          || GET_MODE (x3) != E_V8HImode)
        return -1;
      return 1;

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || !vector_operand (operands[1], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode)
        return -1;
      return 2;

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || !vector_operand (operands[1], E_V2DImode)
          || GET_MODE (x3) != E_V2DImode)
        return -1;
      return 3;

    case E_V1TImode:
      if (!register_operand (operands[0], E_V1TImode)
          || !vector_operand (operands[1], E_V1TImode)
          || GET_MODE (x3) != E_V1TImode)
        return -1;
      return 4;

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || !vector_operand (operands[1], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode)
        return -1;
      return 5;

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || !vector_operand (operands[1], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode)
        return -1;
      return 6;

    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode)
          || !vector_operand (operands[1], E_V32QImode)
          || GET_MODE (x3) != E_V32QImode)
        return -1;
      return 7;

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || !vector_operand (operands[1], E_V16HImode)
          || GET_MODE (x3) != E_V16HImode)
        return -1;
      return 8;

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || !vector_operand (operands[1], E_V8SImode)
          || GET_MODE (x3) != E_V8SImode)
        return -1;
      return 9;

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || !vector_operand (operands[1], E_V4DImode)
          || GET_MODE (x3) != E_V4DImode)
        return -1;
      return 10;

    case E_V2TImode:
      if (!register_operand (operands[0], E_V2TImode)
          || !vector_operand (operands[1], E_V2TImode)
          || GET_MODE (x3) != E_V2TImode)
        return -1;
      return 11;

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || !vector_operand (operands[1], E_V8SFmode)
          || GET_MODE (x3) != E_V8SFmode)
        return -1;
      return 12;

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || !vector_operand (operands[1], E_V4DFmode)
          || GET_MODE (x3) != E_V4DFmode)
        return -1;
      return 13;

    default:
      return -1;
    }
}

int
pattern641 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern649 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern653 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[2], i1)
      || !register_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern658 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !vector_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !vector_all_ones_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern664 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern667 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != CONST_INT)
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x8) != CONST_INT)
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x9) != CONST_INT)
    return -1;
  x10 = XVECEXP (x1, 0, 8);
  if (GET_CODE (x10) != CONST_INT)
    return -1;
  x11 = XVECEXP (x1, 0, 9);
  if (GET_CODE (x11) != CONST_INT)
    return -1;
  x12 = XVECEXP (x1, 0, 10);
  if (GET_CODE (x12) != CONST_INT)
    return -1;
  x13 = XVECEXP (x1, 0, 11);
  if (GET_CODE (x13) != CONST_INT)
    return -1;
  x14 = XVECEXP (x1, 0, 12);
  if (GET_CODE (x14) != CONST_INT)
    return -1;
  x15 = XVECEXP (x1, 0, 13);
  if (GET_CODE (x15) != CONST_INT)
    return -1;
  x16 = XVECEXP (x1, 0, 14);
  if (GET_CODE (x16) != CONST_INT)
    return -1;
  x17 = XVECEXP (x1, 0, 15);
  if (GET_CODE (x17) != CONST_INT)
    return -1;
  x18 = XVECEXP (x1, 0, 16);
  if (GET_CODE (x18) != CONST_INT)
    return -1;
  x19 = XVECEXP (x1, 0, 17);
  if (GET_CODE (x19) != CONST_INT)
    return -1;
  x20 = XVECEXP (x1, 0, 18);
  if (GET_CODE (x20) != CONST_INT)
    return -1;
  x21 = XVECEXP (x1, 0, 19);
  if (GET_CODE (x21) != CONST_INT)
    return -1;
  x22 = XVECEXP (x1, 0, 20);
  if (GET_CODE (x22) != CONST_INT)
    return -1;
  x23 = XVECEXP (x1, 0, 21);
  if (GET_CODE (x23) != CONST_INT)
    return -1;
  x24 = XVECEXP (x1, 0, 22);
  if (GET_CODE (x24) != CONST_INT)
    return -1;
  x25 = XVECEXP (x1, 0, 23);
  if (GET_CODE (x25) != CONST_INT)
    return -1;
  x26 = XVECEXP (x1, 0, 24);
  if (GET_CODE (x26) != CONST_INT)
    return -1;
  x27 = XVECEXP (x1, 0, 25);
  if (GET_CODE (x27) != CONST_INT)
    return -1;
  x28 = XVECEXP (x1, 0, 26);
  if (GET_CODE (x28) != CONST_INT)
    return -1;
  x29 = XVECEXP (x1, 0, 27);
  if (GET_CODE (x29) != CONST_INT)
    return -1;
  x30 = XVECEXP (x1, 0, 28);
  if (GET_CODE (x30) != CONST_INT)
    return -1;
  x31 = XVECEXP (x1, 0, 29);
  if (GET_CODE (x31) != CONST_INT)
    return -1;
  x32 = XVECEXP (x1, 0, 30);
  if (GET_CODE (x32) != CONST_INT)
    return -1;
  x33 = XVECEXP (x1, 0, 31);
  if (GET_CODE (x33) != CONST_INT)
    return -1;
  return 0;
}

int
pattern702 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != UNSPEC_VOLATILE
      || XVECLEN (x6, 0) != 1
      || XINT (x6, 1) != i1
      || GET_MODE (x6) != E_CCCmode)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x8 = XEXP (x5, 0);
  if (GET_CODE (x8) != REG
      || REGNO (x8) != 17
      || GET_MODE (x8) != E_CCCmode)
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x3) != E_HImode)
        return -1;
      return 0;

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode)
        return -1;
      return 1;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern715 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[2], i1)
      || pattern714 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern722 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 2
      || peep2_current_count < 3
      || !general_reg_operand (operands[0], i1)
      || !general_reg_operand (operands[1], i1))
    return -1;
  x2 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x2) != SET)
    return -1;
  switch (GET_CODE (x1))
    {
    case SET:
      return 0;

    case PARALLEL:
      return 1;

    default:
      return -1;
    }
}

int
pattern728 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_mmxmem_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern731 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  operands[3] = x3;
  x4 = XEXP (x2, 1);
  operands[4] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      return pattern730 (x1, 
E_SFmode); /* [-1, 0] */

    case E_DFmode:
      if (pattern730 (x1, 
E_DFmode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern739 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern746 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x3, 0);
  operands[3] = x5;
  if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern745 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern745 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern757 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  if (maybe_ne (SUBREG_BYTE (x3), 0)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != AND)
    return -1;
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!int248_register_operand (operands[1], E_VOIDmode))
    return -1;
  x6 = XEXP (x4, 1);
  operands[2] = x6;
  if (!const_int_operand (operands[2], E_VOIDmode))
    return -1;
  return pattern286 (x1); /* [-1, 1] */
}

int
pattern766 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern773 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 2);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XEXP (x2, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x5, 1);
  operands[2] = x7;
  x8 = XEXP (x4, 1);
  operands[3] = x8;
  x9 = XEXP (x4, 2);
  operands[4] = x9;
  if (!register_operand (operands[4], E_QImode))
    return -1;
  x10 = XVECEXP (x1, 0, 1);
  operands[5] = x10;
  if (!const_4_or_8_to_11_operand (operands[5], E_SImode))
    return -1;
  return pattern772 (x1); /* [-1, 2] */
}

int
pattern785 (rtx x1, int i1, int i2, int i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern802 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!movq_parallel (operands[3], E_VOIDmode))
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  x6 = XVECEXP (x5, 0, 0);
  operands[4] = x6;
  if (!const_int_operand (operands[4], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern798 (x1, 
E_V64QImode, 
E_V128QImode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern798 (x1, 
E_V32QImode, 
E_V64QImode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern798 (x1, 
E_V16QImode, 
E_V32QImode) != 0)
        return -1;
      return 2;

    case E_V32HImode:
      if (pattern798 (x1, 
E_V32HImode, 
E_V64HImode) != 0)
        return -1;
      return 3;

    case E_V16HImode:
      if (pattern798 (x1, 
E_V16HImode, 
E_V32HImode) != 0)
        return -1;
      return 4;

    case E_V8HImode:
      if (pattern798 (x1, 
E_V8HImode, 
E_V16HImode) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern817 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!memory_operand (operands[2], E_HImode))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  x5 = XEXP (x4, 0);
  operands[3] = x5;
  if (!memory_operand (operands[3], E_HImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (pnum_clobbers == NULL
          || !nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x6 = XVECEXP (x1, 0, 0);
      x7 = XEXP (x6, 1);
      if (GET_MODE (x7) != E_DImode)
        return -1;
      return 0;

    case E_HImode:
      if (!nonimmediate_operand (operands[0], E_HImode))
        return -1;
      x6 = XVECEXP (x1, 0, 0);
      x7 = XEXP (x6, 1);
      if (GET_MODE (x7) != E_HImode)
        return -1;
      return 1;

    case E_SImode:
      if (!nonimmediate_operand (operands[0], E_SImode))
        return -1;
      x6 = XVECEXP (x1, 0, 0);
      x7 = XEXP (x6, 1);
      if (GET_MODE (x7) != E_SImode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern831 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || pattern830 (x1, 
i1, 
i2, 
i3, 
i4) != 0)
    return -1;
  return 0;
}

int
pattern842 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_mmxmem_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern845 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x3, 0);
  operands[3] = x5;
  if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern844 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern844 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern851 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !nonmemory_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern855 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern862 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_V32QImode:
      if (!register_operand (operands[1], E_V32QImode)
          || !nonimmediate_operand (operands[2], E_V32QImode))
        return -1;
      return 0;

    case E_V32HImode:
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern871 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  switch (GET_MODE (x3))
    {
    case E_DFmode:
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern879 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!nonimmediate_operand (operands[2], i2))
    return -1;
  x4 = XEXP (x1, 1);
  operands[1] = x4;
  if (!register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern890 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[2] = x4;
  return pattern889 (x3); /* [-1, 0] */
}

int
pattern894 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
      || !register_operand (operands[0], E_V2DImode)
      || GET_MODE (x1) != E_V2DImode
      || GET_MODE (x2) != E_V2DImode
      || GET_MODE (x3) != i2)
    return -1;
  x7 = XEXP (x3, 0);
  if (GET_MODE (x7) != i1
      || !nonimm_or_0_operand (operands[2], E_V2DImode))
    return -1;
  return 0;
}

int
pattern903 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern909 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V8QImode)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != VEC_SELECT
      || GET_MODE (x4) != E_V8QImode)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PARALLEL
      || XVECLEN (x5, 0) != 8)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x5, 0, 1);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x8 = XVECEXP (x5, 0, 2);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x9 = XVECEXP (x5, 0, 3);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x10 = XVECEXP (x5, 0, 4);
  if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x11 = XVECEXP (x5, 0, 5);
  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x12 = XVECEXP (x5, 0, 6);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x13 = XVECEXP (x5, 0, 7);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || !register_operand (operands[0], E_V16QImode)
      || GET_MODE (x1) != E_V16QImode
      || GET_MODE (x2) != E_V8QImode
      || !nonimmediate_operand (operands[1], E_V8HFmode))
    return -1;
  x14 = XEXP (x4, 0);
  operands[2] = x14;
  if (!nonimm_or_0_operand (operands[2], E_V16QImode))
    return -1;
  x15 = XEXP (x2, 2);
  operands[3] = x15;
  x16 = XEXP (x1, 1);
  operands[4] = x16;
  if (!const0_operand (operands[4], E_V8QImode))
    return -1;
  return 0;
}

int
pattern924 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V8QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V8QImode))
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!register_mmxmem_operand (operands[2], E_V8QImode))
    return -1;
  x6 = XVECEXP (x3, 0, 2);
  operands[4] = x6;
  if (!reg_or_const_vector_operand (operands[4], E_V4SImode))
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  x8 = XEXP (x7, 0);
  operands[3] = x8;
  if (!scratch_operand (operands[3], E_V4SImode))
    return -1;
  return 0;
}

int
pattern938 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (x1))
    {
    case E_QImode:
      if (!nonimmediate_operand (operands[1], E_QImode)
          || !general_operand (operands[2], E_QImode)
          || !scratch_operand (operands[0], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!nonimmediate_operand (operands[1], E_HImode)
          || !general_operand (operands[2], E_HImode)
          || !scratch_operand (operands[0], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !x86_64_general_operand (operands[2], E_SImode)
          || !scratch_operand (operands[0], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !x86_64_general_operand (operands[2], E_DImode)
          || !scratch_operand (operands[0], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern954 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || GET_MODE (x1) != E_QImode)
        return -1;
      return 0;

    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x1) != E_HImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern956 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern960 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_HImode)
      || GET_MODE (x1) != E_HImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_HImode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V16SImode:
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 0;

    case E_V16HFmode:
      if (!register_operand (operands[1], E_V16HFmode)
          || !nonimmediate_operand (operands[2], E_V16HFmode)
          || !const_0_to_31_operand (operands[3], E_SImode))
        return -1;
      return 1;

    case E_V16SFmode:
      if (!register_operand (operands[1], E_V16SFmode)
          || !nonimmediate_operand (operands[2], E_V16SFmode)
          || !const_0_to_31_operand (operands[3], E_SImode))
        return -1;
      return 2;

    case E_V16QImode:
      if (!register_operand (operands[1], E_V16QImode)
          || !nonimmediate_operand (operands[2], E_V16QImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 3;

    case E_V16HImode:
      if (!register_operand (operands[1], E_V16HImode)
          || !nonimmediate_operand (operands[2], E_V16HImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 4;

    default:
      return -1;
    }
}

int
pattern969 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (x1))
    {
    case E_V8SFmode:
      if (!register_operand (operands[1], E_V8SImode)
          || !const0_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!register_operand (operands[1], E_V4SImode)
          || !const0_operand (operands[2], E_V4SImode))
        return -1;
      return 1;

    case E_V4DFmode:
      if (!register_operand (operands[1], E_V4DImode)
          || !const0_operand (operands[2], E_V4DImode))
        return -1;
      return 2;

    case E_V2DFmode:
      if (!register_operand (operands[1], E_V2DImode)
          || !const0_operand (operands[2], E_V2DImode))
        return -1;
      return 3;

    case E_V32QImode:
      if (!register_operand (operands[1], E_V32QImode)
          || !const0_operand (operands[2], E_V32QImode))
        return -1;
      return 4;

    case E_V16QImode:
      if (!register_operand (operands[1], E_V16QImode)
          || !const0_operand (operands[2], E_V16QImode))
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern981 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!vector_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V8SFmode:
      if (!nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      return 1;

    case E_V8DFmode:
      if (!vector_operand (operands[1], E_V8DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern991 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (!nonimmediate_operand (x5, i1))
    return -1;
  x6 = XEXP (x3, 1);
  if (!nonimmediate_operand (x6, i1))
    return -1;
  return 0;
}

int
pattern1004 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !bcst_vector_operand (operands[1], i1)
      || !vector_all_ones_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1012 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1)
      || !const_4_or_8_to_11_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern1020 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1028 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != SUBREG
      || maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XEXP (x1, 0);
      if (GET_CODE (x8) != ZERO_EXTRACT)
        return -1;
      x9 = XEXP (x8, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x10 = XEXP (x8, 2);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      if (!int248_register_operand (operands[0], E_VOIDmode))
        return -1;
      x12 = XEXP (x5, 0);
      operands[1] = x12;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      x13 = XEXP (x3, 1);
      operands[2] = x13;
      if (!nonmemory_operand (operands[2], E_QImode))
        return -1;
      return pattern1027 (x1); /* [-1, 2] */

    default:
      return -1;
    }
}

int
pattern1041 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x5, 1);
  operands[2] = x7;
  x8 = XEXP (x4, 1);
  operands[3] = x8;
  x9 = XEXP (x3, 1);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      return pattern1040 (x3, 
E_HImode); /* [-1, 0] */

    case E_SImode:
      if (pattern1040 (x3, 
E_SImode) != 0)
        return -1;
      return 1;

    case E_DImode:
      if (pattern1040 (x3, 
E_DImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1046 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (!register_operand (x3, E_DImode))
    return -1;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != E_SImode)
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  if (!register_operand (x7, E_SImode))
    return -1;
  x8 = XEXP (x6, 1);
  if (GET_MODE (x8) != E_SImode)
    return -1;
  switch (GET_CODE (x5))
    {
    case DIV:
      return 0;

    case UDIV:
      return 1;

    case MOD:
      return 2;

    case UMOD:
      return 3;

    default:
      return -1;
    }
}

int
pattern1056 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 3
      || GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!general_reg_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 0);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  x4 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  x6 = XEXP (x4, 0);
  if (!rtx_equal_p (x6, operands[2]))
    return -1;
  return 0;
}

int
pattern1064 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_HImode)
      || GET_MODE (x1) != E_HImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_HImode)
    return -1;
  return pattern736 (); /* [-1, 2] */
}

int
pattern1070 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_carry_flag_unset_operator (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1079 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1085 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  if (!const_int_operand (operands[2], E_QImode))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_V8SFmode:
      if (GET_MODE (x2) != E_V8SImode
          || !register_operand (operands[1], E_V8SImode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (GET_MODE (x2) != E_V4SImode
          || !register_operand (operands[1], E_V4SImode))
        return -1;
      return 1;

    case E_V4DFmode:
      if (GET_MODE (x2) != E_V4DImode
          || !register_operand (operands[1], E_V4DImode))
        return -1;
      return 2;

    case E_V2DFmode:
      if (GET_MODE (x2) != E_V2DImode
          || !register_operand (operands[1], E_V2DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1093 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !register_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1100 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  if (XWINT (x2, 0) != 1L
      || !const_0_to_255_operand (operands[3], E_SImode))
    return -1;
  return pattern1099 (x1); /* [-1, 2] */
}

int
pattern1102 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern1109 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i3)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i3)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i3
      || !vector_operand (operands[1], i2))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i3
      || !vector_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1121 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V32HFmode
      || !register_operand (operands[0], E_V32HFmode)
      || GET_MODE (x1) != E_V32HFmode
      || !register_operand (operands[1], E_V32HFmode)
      || !register_operand (operands[2], E_V32HFmode)
      || !const_4_or_8_to_11_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern1128 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1135 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[5], i1)
      || !immediate_operand (operands[3], i1)
      || !register_operand (operands[4], i1)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1141 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ZERO_EXTEND)
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_CODE (x5) != ZERO_EXTEND)
    return -1;
  return pattern356 (x1); /* [-1, 3] */
}

int
pattern1146 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1155 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x3, 0);
      operands[2] = x4;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      return pattern1154 (x1); /* [-1, 3] */

    case PLUS:
      x4 = XEXP (x3, 0);
      operands[2] = x4;
      if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern1154 (x1);
      if (res >= 0)
        return res + 4; /* [4, 7] */
      return -1;

    case MINUS:
      x4 = XEXP (x3, 0);
      operands[3] = x4;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern205 (x1);
      if (res >= 0)
        return res + 8; /* [8, 11] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1173 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !const0_operand (operands[2], i2)
      || !vector_all_ones_operand (operands[3], i2)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1177 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != MINUS)
    return -1;
  x7 = XEXP (x2, 0);
  if (GET_MODE (x7) != E_CCmode
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x8 = XEXP (x3, 1);
  operands[2] = x8;
  if (!memory_operand (operands[2], i1))
    return -1;
  x9 = XEXP (x6, 0);
  if (!rtx_equal_p (x9, operands[0]))
    return -1;
  x10 = XEXP (x6, 1);
  if (!rtx_equal_p (x10, operands[2]))
    return -1;
  return 0;
}

int
pattern1186 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_QImode)
      || GET_MODE (x1) != E_QImode
      || !ix86_comparison_operator (operands[1], E_VOIDmode)
      || !register_operand (operands[2], E_QImode)
      || !register_operand (operands[3], E_QImode))
    return -1;
  return 0;
}

int
pattern1190 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1196 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case UNSPEC:
      if (XVECLEN (x1, 0) != 2
          || XINT (x1, 1) != 52
          || GET_MODE (x1) != E_V16QImode)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      operands[1] = x2;
      if (!register_operand (operands[1], E_V16QImode))
        return -1;
      x3 = XVECEXP (x1, 0, 1);
      operands[2] = x3;
      return 0;

    case VEC_SELECT:
      if (GET_MODE (x1) != E_V4SImode)
        return -1;
      x4 = XEXP (x1, 1);
      if (GET_CODE (x4) != PARALLEL
          || XVECLEN (x4, 0) != 4)
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x6 = XVECEXP (x4, 0, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x7 = XVECEXP (x4, 0, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x8 = XVECEXP (x4, 0, 3);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x9 = XEXP (x1, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1215 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1218 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != E_CCGOCmode)
    return -1;
  return pattern364 (x1, 
E_CCGOCmode); /* [-1, 3] */
}

int
pattern1223 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (maybe_ne (SUBREG_BYTE (x2), 0))
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ZERO_EXTEND)
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (GET_MODE (x1) != E_DImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_DImode)
        return -1;
      x6 = XEXP (x5, 1);
      if (!const_0_to_63_operand (x6, E_QImode))
        return -1;
      return 0;

    case E_SImode:
      if (GET_MODE (x1) != E_SImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_SImode)
        return -1;
      x6 = XEXP (x5, 1);
      if (!const_0_to_31_operand (x6, E_QImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1232 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x3) != CLOBBER)
    return -1;
  x4 = XVECEXP (x1, 0, 3);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode
      || !register_operand (operands[0], E_SImode))
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 1);
  x8 = XVECEXP (x7, 0, 0);
  operands[1] = x8;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x9 = XVECEXP (x7, 0, 1);
  operands[2] = x9;
  return 0;
}

int
pattern1244 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !fcmov_comparison_operator (operands[1], E_VOIDmode)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1248 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[3]))
    {
    case E_HImode:
      if (!extract_operator (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!extract_operator (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!extract_operator (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1256 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1263 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i3)
      || pattern481 (
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1272 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i3))
    return -1;
  return 0;
}

int
pattern1281 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !vector_operand (operands[2], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1290 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V16SImode)
      || GET_MODE (x1) != E_V16SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V16SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V16SImode
      || !nonimm_or_0_operand (operands[2], E_V16SImode)
      || !register_operand (operands[3], E_HImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V16HFmode:
      if (!register_operand (operands[1], E_V16HFmode))
        return -1;
      return 0;

    case E_V16SFmode:
      if (!register_operand (operands[1], E_V16SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1301 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XVECEXP (x4, 0, 4);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x10 = XVECEXP (x4, 0, 5);
  if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
    return -1;
  x11 = XVECEXP (x4, 0, 6);
  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
    return -1;
  x12 = XVECEXP (x4, 0, 7);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
    return -1;
  x13 = XEXP (x1, 1);
  x14 = XEXP (x13, 0);
  x15 = XEXP (x14, 1);
  return pattern1300 (x15, 
8); /* [-1, 0] */
}

int
pattern1314 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern1322 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_all_ones_operand (operands[2], i1)
      || !const0_operand (operands[3], i1)
      || !register_operand (operands[1], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1331 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  if (!rtx_equal_p (x6, operands[0]))
    return -1;
  x7 = XEXP (x4, 0);
  if (!rtx_equal_p (x7, operands[0]))
    return -1;
  return 0;
}

int
pattern1339 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1349 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], E_SImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_DImode)
    return -1;
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x6 = XEXP (x3, 1);
  operands[3] = x6;
  if (!const_0_to_63_operand (operands[3], E_QImode))
    return -1;
  x7 = XEXP (x1, 0);
  x8 = XEXP (x7, 0);
  if (!rtx_equal_p (x8, operands[0]))
    return -1;
  return 0;
}

int
pattern1358 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1370 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 2);
  return pattern1369 (x3, 
i1); /* [-1, 0] */
}

int
pattern1379 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x4 = XEXP (x2, 2);
  return pattern1369 (x4, 
i1); /* [-1, 0] */
}

int
pattern1388 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1394 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  operands[4] = x2;
  if (!const48_operand (operands[4], E_SImode))
    return -1;
  return pattern1393 (x1); /* [-1, 2] */
}

int
pattern1399 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1407 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[2] = x4;
  if (!register_operand (operands[2], E_XFmode))
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  operands[3] = x5;
  if (!register_operand (operands[3], E_XFmode))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_XFmode))
    return -1;
  x8 = XEXP (x6, 1);
  x9 = XVECEXP (x8, 0, 0);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  x10 = XVECEXP (x8, 0, 1);
  if (!rtx_equal_p (x10, operands[3]))
    return -1;
  return 0;
}

int
pattern1421 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x5 = XEXP (x3, 1);
  operands[3] = x5;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  return pattern198 (x1); /* [-1, 1] */
}

int
pattern1429 (rtx x1, int i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case PLUS:
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != ASHIFT)
        return -1;
      x5 = XEXP (x4, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
        return -1;
      x6 = XVECEXP (x1, 0, 3);
      if (GET_CODE (x6) != SET)
        return -1;
      x7 = XEXP (x6, 1);
      if (GET_CODE (x7) != MEM
          || GET_MODE (x7) != E_BLKmode)
        return -1;
      x8 = XEXP (x6, 0);
      if (GET_CODE (x8) != MEM
          || GET_MODE (x8) != E_BLKmode)
        return -1;
      x9 = XVECEXP (x1, 0, 0);
      x10 = XEXP (x9, 0);
      operands[2] = x10;
      x11 = XVECEXP (x1, 0, 1);
      x12 = XEXP (x11, 1);
      x13 = XEXP (x12, 0);
      x14 = XEXP (x13, 0);
      operands[5] = x14;
      x15 = XEXP (x2, 0);
      operands[1] = x15;
      x16 = XEXP (x3, 1);
      operands[4] = x16;
      x17 = XEXP (x4, 0);
      if (!rtx_equal_p (x17, operands[5]))
        return -1;
      x18 = XEXP (x7, 0);
      if (!rtx_equal_p (x18, operands[4]))
        return -1;
      x19 = XEXP (x8, 0);
      if (!rtx_equal_p (x19, operands[3]))
        return -1;
      x20 = XVECEXP (x1, 0, 4);
      x21 = XEXP (x20, 0);
      if (!rtx_equal_p (x21, operands[5]))
        return -1;
      switch (GET_MODE (operands[2]))
        {
        case E_SImode:
          return pattern1427 (x1, 
E_SImode); /* [-1, 0] */

        case E_DImode:
          if (pattern1427 (x1, 
E_DImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x3, 0) != 0L)
        return -1;
      x15 = XEXP (x2, 0);
      if (GET_CODE (x15) != MEM
          || GET_MODE (x15) != E_BLKmode)
        return -1;
      x6 = XVECEXP (x1, 0, 3);
      if (GET_CODE (x6) != USE)
        return -1;
      x9 = XVECEXP (x1, 0, 0);
      x10 = XEXP (x9, 0);
      operands[1] = x10;
      x11 = XVECEXP (x1, 0, 1);
      x12 = XEXP (x11, 1);
      x13 = XEXP (x12, 0);
      x14 = XEXP (x13, 0);
      operands[4] = x14;
      x8 = XEXP (x6, 0);
      operands[2] = x8;
      if (!register_operand (operands[2], i2))
        return -1;
      x22 = XEXP (x15, 0);
      if (!rtx_equal_p (x22, operands[3]))
        return -1;
      x20 = XVECEXP (x1, 0, 4);
      x21 = XEXP (x20, 0);
      if (!rtx_equal_p (x21, operands[4]))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_SImode:
          if (pattern1428 (x12, 
E_SImode) != 0)
            return -1;
          return 2;

        case E_DImode:
          if (pattern1428 (x12, 
E_DImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1475 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode)
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1487 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !x86_64_nonmemory_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1491 (rtx x1, int i1, int i2, int i3, int i4, int i5)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 7);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i5])
    return -1;
  x3 = XVECEXP (x1, 0, 8);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x4 = XVECEXP (x1, 0, 9);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x5 = XVECEXP (x1, 0, 10);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x6 = XVECEXP (x1, 0, 11);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + i1]
      || pattern1402 (x1) != 0)
    return -1;
  return 0;
}

int
pattern1506 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != i2
      || !vector_operand (operands[1], i1))
    return -1;
  x7 = XEXP (x5, 1);
  if (GET_MODE (x7) != i2
      || !vector_operand (operands[2], i1)
      || !const1_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1518 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1525 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1535 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_MODE (x5) != i1)
    return -1;
  x6 = XEXP (x2, 1);
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i1)
    return -1;
  x8 = XEXP (x6, 1);
  if (GET_MODE (x8) != i1)
    return -1;
  x9 = XEXP (x1, 1);
  x10 = XEXP (x9, 0);
  x11 = XEXP (x10, 0);
  if (GET_MODE (x11) != i1)
    return -1;
  x12 = XEXP (x10, 1);
  if (GET_MODE (x12) != i1)
    return -1;
  x13 = XEXP (x9, 1);
  x14 = XEXP (x13, 0);
  if (GET_MODE (x14) != i1)
    return -1;
  x15 = XEXP (x13, 1);
  if (GET_MODE (x15) != i1)
    return -1;
  return 0;
}

int
pattern1547 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1555 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x4, 1);
  if (!rtx_equal_p (x7, operands[1]))
    return -1;
  x8 = XVECEXP (x1, 0, 1);
  x9 = XEXP (x8, 1);
  x10 = XEXP (x9, 0);
  x11 = XEXP (x10, 0);
  if (!rtx_equal_p (x11, operands[1]))
    return -1;
  x12 = XEXP (x9, 1);
  if (!rtx_equal_p (x12, operands[1]))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_SImode:
      return pattern1554 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern1554 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1569 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x4 = XVECEXP (x3, 0, 2);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1579 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !register_operand (operands[2], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1588 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!vsib_mem_operator (operands[5], i1)
      || !register_operand (operands[6], E_QImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[3], i1))
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  switch (GET_MODE (x4))
    {
    case E_SImode:
      return pattern1587 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1587 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1599 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V4SImode:
      if (!register_operand (operands[2], E_V4SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!register_operand (operands[2], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1608 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !ix86_carry_flag_operator (operands[4], i1)
      || !nonimmediate_operand (operands[1], i1)
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1615 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1624 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i3)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i3)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i3)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != i3)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i3
      || !vector_operand (operands[1], i2))
    return -1;
  x8 = XEXP (x6, 1);
  if (GET_MODE (x8) != i3
      || !vector_operand (operands[2], i2)
      || !const1_operand (operands[3], i2)
      || !nonimm_or_0_operand (operands[4], i2)
      || !register_operand (operands[5], i1))
    return -1;
  return 0;
}

int
pattern1639 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[4], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!register_operand (operands[3], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1647 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !addsub_vs_operator (operands[7], i1)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !vector_operand (operands[3], i1)
      || !vector_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1658 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern1668 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[3] = x3;
  x4 = XEXP (x1, 0);
  x5 = XEXP (x4, 0);
  switch (GET_MODE (x5))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1678 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x3, 2);
  if (GET_MODE (x6) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  x7 = XEXP (x2, 1);
  if (!rtx_equal_p (x7, operands[1]))
    return -1;
  x8 = XEXP (x1, 1);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  return 0;
}

int
pattern1685 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!register_operand (operands[3], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1692 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_3_operand (operands[2], E_VOIDmode)
      || !const_0_to_3_operand (operands[3], E_VOIDmode)
      || !const_0_to_3_operand (operands[4], E_VOIDmode)
      || !const_0_to_3_operand (operands[5], E_VOIDmode)
      || !const_4_to_7_operand (operands[6], E_VOIDmode)
      || !const_4_to_7_operand (operands[7], E_VOIDmode)
      || !const_4_to_7_operand (operands[8], E_VOIDmode)
      || !const_4_to_7_operand (operands[9], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1703 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[6], E_QImode)
      || !vsib_mem_operator (operands[5], i1)
      || !scratch_operand (operands[1], E_QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1702 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1702 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1715 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 4);
  if (XWINT (x4, 0) != 6L)
    return -1;
  x5 = XVECEXP (x3, 0, 5);
  if (XWINT (x5, 0) != 14L)
    return -1;
  x6 = XVECEXP (x3, 0, 6);
  if (XWINT (x6, 0) != 7L)
    return -1;
  x7 = XVECEXP (x3, 0, 7);
  if (XWINT (x7, 0) != 15L)
    return -1;
  x8 = XEXP (x2, 0);
  x9 = XEXP (x8, 1);
  operands[2] = x9;
  x10 = XEXP (x1, 1);
  operands[3] = x10;
  x11 = XEXP (x1, 2);
  operands[4] = x11;
  return 0;
}

int
pattern1722 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode)
          || !register_operand (operands[3], E_V8SFmode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode)
          || !register_operand (operands[3], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1731 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[7], E_QImode)
      || !vsib_mem_operator (operands[6], i1)
      || !scratch_operand (operands[2], E_QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1730 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1730 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1745 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  if (!constm1_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (XVECLEN (x3, 0) != 2
      || XINT (x3, 1) != 110
      || GET_MODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PLUS
      || GET_MODE (x5) != i1)
    return -1;
  x6 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x6) != CLOBBER)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 17
      || GET_MODE (x7) != E_CCmode)
    return -1;
  x8 = XVECEXP (x3, 0, 0);
  operands[1] = x8;
  if (!memory_operand (operands[1], i1))
    return -1;
  x9 = XVECEXP (x3, 0, 1);
  operands[4] = x9;
  if (!const_int_operand (operands[4], E_SImode))
    return -1;
  x10 = XEXP (x2, 0);
  if (!rtx_equal_p (x10, operands[0]))
    return -1;
  x11 = XEXP (x5, 0);
  if (!rtx_equal_p (x11, operands[1]))
    return -1;
  x12 = XEXP (x5, 1);
  if (!rtx_equal_p (x12, operands[0]))
    return -1;
  x13 = XEXP (x4, 0);
  if (!rtx_equal_p (x13, operands[1]))
    return -1;
  x14 = PATTERN (peep2_next_insn (2));
  x15 = XEXP (x14, 1);
  x16 = XEXP (x15, 1);
  operands[3] = x16;
  if (!const_int_operand (operands[3], i1))
    return -1;
  x17 = XEXP (x15, 0);
  if (!rtx_equal_p (x17, operands[0]))
    return -1;
  return 0;
}

int
pattern1767 (rtx x1, machine_mode i1, machine_mode i2, rtx_code i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != MULT
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != i3
      || GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 4)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != SIGN_EXTEND
      || GET_MODE (x9) != i2)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != VEC_SELECT
      || GET_MODE (x10) != i1)
    return -1;
  x11 = XEXP (x10, 1);
  if (GET_CODE (x11) != PARALLEL
      || XVECLEN (x11, 0) != 4)
    return -1;
  x12 = XVECEXP (x11, 0, 0);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x11, 0, 1);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x14 = XVECEXP (x11, 0, 2);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x15 = XVECEXP (x11, 0, 3);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  return 0;
}

int
pattern1793 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[3], i1))
    return -1;
  x6 = XEXP (x2, 1);
  if (!rtx_equal_p (x6, operands[1]))
    return -1;
  x7 = XEXP (x1, 1);
  if (!rtx_equal_p (x7, operands[1]))
    return -1;
  return 0;
}

int
pattern1802 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode)
          || !register_operand (operands[3], E_V8SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode)
          || !register_operand (operands[3], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1810 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[2], i1)
      || !register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[3], i1)
      || !register_operand (operands[5], i1)
      || !register_operand (operands[1], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1817 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V8SImode:
      if (!register_operand (operands[3], E_V8SImode)
          || !register_operand (operands[4], E_V8SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[3], E_V4DImode)
          || !register_operand (operands[4], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1823 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[2], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return pattern1822 (x1, 
i1); /* [-1, 1] */
}

int
pattern1828 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_7_operand (operands[4], E_VOIDmode)
      || !const_0_to_7_operand (operands[5], E_VOIDmode)
      || !const_0_to_7_operand (operands[6], E_VOIDmode)
      || !const_8_to_15_operand (operands[7], E_VOIDmode)
      || !const_8_to_15_operand (operands[8], E_VOIDmode)
      || !const_8_to_15_operand (operands[9], E_VOIDmode)
      || !const_8_to_15_operand (operands[10], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1834 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[2], i2)
      || !vsib_mem_operator (operands[7], i3)
      || !register_operand (operands[5], i2)
      || !scratch_operand (operands[1], i1))
    return -1;
  x3 = XVECEXP (x2, 0, 1);
  x4 = XEXP (x3, 0);
  switch (GET_MODE (x4))
    {
    case E_SImode:
      if (!vsib_address_operand (operands[3], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!vsib_address_operand (operands[3], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1843 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (!x86_64_general_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (XINT (x3, 1) != 112
      || GET_MODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != COMPARE
      || GET_MODE (x5) != E_CCmode
      || !memory_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  x6 = XEXP (x4, 0);
  if (GET_MODE (x6) != E_CCmode)
    return -1;
  x7 = XEXP (x5, 0);
  if (!rtx_equal_p (x7, operands[2]))
    return -1;
  x8 = XEXP (x5, 1);
  if (!rtx_equal_p (x8, operands[0])
      || !register_operand (operands[5], i1)
      || !x86_64_general_operand (operands[6], i1))
    return -1;
  return 0;
}

int
pattern1850 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[4], E_SImode)
      || GET_MODE (x1) != E_SImode
      || !nonmemory_operand (operands[2], E_SImode))
    return -1;
  x2 = PATTERN (peep2_next_insn (3));
  x3 = XEXP (x2, 1);
  operands[5] = x3;
  if (!register_operand (operands[5], i1))
    return -1;
  x4 = PATTERN (peep2_next_insn (4));
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  operands[6] = x6;
  x7 = XEXP (x5, 1);
  operands[7] = x7;
  return 0;
}

int
pattern1858 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !ix86_carry_flag_operator (operands[4], i2))
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const_int_operand (operands[6], i2))
    return -1;
  x7 = XEXP (x3, 1);
  if (GET_MODE (x7) != i2)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_MODE (x8) != i1)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_MODE (x9) != i1
      || !ix86_carry_flag_operator (operands[5], i1))
    return -1;
  x10 = XVECEXP (x1, 0, 1);
  x11 = XEXP (x10, 1);
  return pattern1857 (x11, 
i1); /* [-1, 0] */
}

int
pattern1868 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 8);
  if (XWINT (x2, 0) != 12L)
    return -1;
  x3 = XVECEXP (x1, 0, 9);
  if (XWINT (x3, 0) != 44L)
    return -1;
  x4 = XVECEXP (x1, 0, 10);
  if (XWINT (x4, 0) != 13L)
    return -1;
  x5 = XVECEXP (x1, 0, 11);
  if (XWINT (x5, 0) != 45L)
    return -1;
  x6 = XVECEXP (x1, 0, 12);
  if (XWINT (x6, 0) != 14L)
    return -1;
  x7 = XVECEXP (x1, 0, 13);
  if (XWINT (x7, 0) != 46L)
    return -1;
  x8 = XVECEXP (x1, 0, 14);
  if (XWINT (x8, 0) != 15L)
    return -1;
  x9 = XVECEXP (x1, 0, 15);
  if (XWINT (x9, 0) != 47L)
    return -1;
  return 0;
}

 int
recog_4 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  res = recog_3 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (GET_CODE (x3) != SUBREG
      || pattern261 (x3) != 0)
    return -1;
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  if (!int248_register_operand (operands[0], E_VOIDmode))
    return -1;
  x6 = XEXP (x2, 1);
  operands[1] = x6;
  switch (pattern1341 ())
    {
    case 0:
      if (const0_operand (operands[1], E_QImode)
          && 
#line 1629 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
        return 24; /* *cmpqi_exthi_2 */
      if (general_operand (operands[1], E_QImode)
          && 
#line 1654 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)))
        return 27; /* *cmpqi_exthi_3 */
      break;

    case 1:
      if (const0_operand (operands[1], E_QImode)
          && 
#line 1629 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)))
        return 25; /* *cmpqi_extsi_2 */
      if (general_operand (operands[1], E_QImode)
          && 
#line 1654 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)))
        return 28; /* *cmpqi_extsi_3 */
      break;

    case 2:
      if (const0_operand (operands[1], E_QImode)
          && (
#line 1629 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCNOmode)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 26; /* *cmpqi_extdi_2 */
      if (general_operand (operands[1], E_QImode)
          && (
#line 1654 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 29; /* *cmpqi_extdi_3 */
      break;

    default:
      break;
    }
  if (GET_CODE (x6) != SUBREG
      || maybe_ne (SUBREG_BYTE (x6), 0)
      || GET_MODE (x6) != E_QImode)
    return -1;
  x7 = XEXP (x6, 0);
  switch (GET_CODE (x7))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x7;
      x8 = XEXP (x7, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x9 = XEXP (x7, 2);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x10 = XEXP (x7, 0);
      operands[1] = x10;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[2]))
        {
        case E_HImode:
          if (!extract_operator (operands[2], E_HImode)
              || !extract_operator (operands[3], E_HImode)
              || !
#line 1673 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)))
            return -1;
          return 30; /* *cmpqi_exthi_4 */

        case E_SImode:
          if (!extract_operator (operands[2], E_SImode)
              || !extract_operator (operands[3], E_SImode)
              || !
#line 1673 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)))
            return -1;
          return 31; /* *cmpqi_extsi_4 */

        case E_DImode:
          if (!extract_operator (operands[2], E_DImode)
              || !extract_operator (operands[3], E_DImode)
              || !(
#line 1673 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 32; /* *cmpqi_extdi_4 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_12 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 105:
      if (GET_MODE (x2) != E_TImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!push_operand (operands[0], E_TImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!register_operand (operands[2], E_DImode)
          || !
#line 3901 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_PUSH2POP2))
        return -1;
      return 159; /* push2_di */

    case 40:
      if (GET_MODE (x2) != E_CCCmode
          || pattern250 (x1) != 0)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case LTU:
          if (pattern712 (x4) != 0)
            return -1;
          x6 = XEXP (x4, 0);
          switch (GET_MODE (x6))
            {
            case E_CCmode:
              if (!
#line 9916 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_pre_reload_split ()))
                return -1;
              return 532; /* *setcc_qi_negqi_ccc_2_cc */

            case E_CCCmode:
              if (!
#line 9916 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_pre_reload_split ()))
                return -1;
              return 533; /* *setcc_qi_negqi_ccc_2_ccc */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          if (pnum_clobbers == NULL)
            return -1;
          operands[1] = x4;
          switch (GET_MODE (operands[1]))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode))
                return -1;
              *pnum_clobbers = 1;
              return 984; /* *negqi_ccc_2 */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode))
                return -1;
              *pnum_clobbers = 1;
              return 985; /* *neghi_ccc_2 */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode))
                return -1;
              *pnum_clobbers = 1;
              return 986; /* *negsi_ccc_2 */

            case E_DImode:
              if (!nonimmediate_operand (operands[1], E_DImode)
                  || !
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 987; /* *negdi_ccc_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 66:
      if (pnum_clobbers == NULL
          || GET_MODE (x2) != E_XFmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_XFmode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[2] = x4;
      if (!register_operand (operands[2], E_XFmode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[1] = x5;
      if (!register_operand (operands[1], E_XFmode)
          || !
#line 24165 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      *pnum_clobbers = 1;
      return 1721; /* atan2xf3 */

    case 67:
      if (pnum_clobbers == NULL
          || pattern159 (x1, 
E_XFmode) != 0
          || !
#line 24468 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      *pnum_clobbers = 1;
      return 1722; /* fyl2xxf3_i387 */

    case 68:
      if (pnum_clobbers == NULL
          || pattern159 (x1, 
E_XFmode) != 0
          || !
#line 24565 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
        return -1;
      *pnum_clobbers = 1;
      return 1723; /* fyl2xp1xf3_i387 */

    case 58:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          if (pattern61 (x2, 
E_SFmode) != 0
              || !
#line 24874 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512F))
            return -1;
          return 1727; /* avx512f_scalefsf2 */

        case E_DFmode:
          if (pattern61 (x2, 
E_DFmode) != 0
              || !
#line 24874 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512F))
            return -1;
          return 1728; /* avx512f_scalefdf2 */

        default:
          return -1;
        }

    case 94:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_15_operand (operands[2], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_HFmode:
          if (!register_operand (operands[0], E_HFmode)
              || GET_MODE (x2) != E_HFmode
              || !nonimmediate_operand (operands[1], E_HFmode)
              || !(
#line 24992 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1) && 
#line 1355 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16)))
            return -1;
          return 1729; /* sse4_1_roundhf2 */

        case E_SFmode:
          if (!register_operand (operands[0], E_SFmode)
              || GET_MODE (x2) != E_SFmode
              || !nonimmediate_operand (operands[1], E_SFmode)
              || !
#line 24992 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1))
            return -1;
          return 1730; /* sse4_1_roundsf2 */

        case E_DFmode:
          if (!register_operand (operands[0], E_DFmode)
              || GET_MODE (x2) != E_DFmode
              || !nonimmediate_operand (operands[1], E_DFmode)
              || !
#line 24992 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE4_1))
            return -1;
          return 1731; /* sse4_1_rounddf2 */

        default:
          return -1;
        }

    case 63:
      switch (pattern62 (x1))
        {
        case 0:
          if (!
#line 26793 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 1821; /* *ieee_smaxhf3 */

        case 1:
          if (!
#line 26805 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH))
            return -1;
          return 1823; /* *ieee_smaxsf3 */

        case 2:
          if (!
#line 26805 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH))
            return -1;
          return 1825; /* *ieee_smaxdf3 */

        default:
          return -1;
        }

    case 62:
      switch (pattern62 (x1))
        {
        case 0:
          if (!
#line 26793 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 1822; /* *ieee_sminhf3 */

        case 1:
          if (!
#line 26805 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH))
            return -1;
          return 1824; /* *ieee_sminsf3 */

        case 2:
          if (!
#line 26805 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH))
            return -1;
          return 1826; /* *ieee_smindf3 */

        default:
          return -1;
        }

    case 113:
      if (pattern63 (x1, 
E_V2SFmode) != 0
          || !
#line 911 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
        return -1;
      return 2060; /* mmx_rcpit1v2sf3 */

    case 114:
      if (pattern63 (x1, 
E_V2SFmode) != 0
          || !
#line 922 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
        return -1;
      return 2061; /* mmx_rcpit2v2sf3 */

    case 116:
      if (pattern63 (x1, 
E_V2SFmode) != 0
          || !
#line 959 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
        return -1;
      return 2063; /* mmx_rsqit1v2sf3 */

    case 57:
      switch (pattern65 (x1))
        {
        case 0:
          if (!
#line 4792 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2293; /* mmx_packuswb */

        case 1:
          if (!
#line 4831 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return -1;
          return 2295; /* mmx_packusdw */

        default:
          return -1;
        }

    case 52:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!vector_operand (operands[2], E_V16QImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8QImode:
          if (!register_operand (operands[0], E_V8QImode)
              || GET_MODE (x2) != E_V8QImode
              || !register_operand (operands[1], E_V8QImode)
              || !
#line 5489 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSSE3 && TARGET_MMX_WITH_SSE))
            return -1;
          return 2330; /* mmx_pshufbv8qi3 */

        case E_V4QImode:
          if (!register_operand (operands[0], E_V4QImode)
              || GET_MODE (x2) != E_V4QImode
              || !register_operand (operands[1], E_V4QImode)
              || !
#line 5507 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSSE3))
            return -1;
          return 2331; /* mmx_pshufbv4qi3 */

        default:
          return -1;
        }

    case 56:
      if (GET_MODE (x2) != E_V1DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_V1DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_mmxmem_operand (operands[1], E_V8QImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!register_mmxmem_operand (operands[2], E_V8QImode)
          || !
#line 6477 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && (TARGET_SSE || TARGET_3DNOW_A)
   && ix86_binary_operator_ok (PLUS, V8QImode, operands)))
        return -1;
      return 2383; /* *mmx_psadbw */

    case 176:
      if (pattern66 (x1) != 0)
        return -1;
      switch (pattern953 ())
        {
        case 0:
          if (!(
#line 2338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2082 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
            return -1;
          return 2610; /* ktestqi */

        case 1:
          if (!(
#line 2338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2082 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
            return -1;
          return 2611; /* ktesthi */

        case 2:
          if (!(
#line 2338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2083 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2612; /* ktestsi */

        case 3:
          if (!(
#line 2338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2083 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2613; /* ktestdi */

        default:
          return -1;
        }

    case 178:
      return recog_8 (x1, insn, pnum_clobbers);

    case 61:
      return recog_9 (x1, insn, pnum_clobbers);

    case 158:
      switch (pattern68 (x1))
        {
        case 0:
          if (!(
#line 19038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8040; /* avx512vl_testmv16qi3 */

        case 1:
          if (!(
#line 19038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8044; /* avx512vl_testmv16hi3 */

        case 2:
          if (!(
#line 19038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8048; /* avx512f_testmv16si3 */

        case 3:
          if (!(
#line 19038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8046; /* avx512vl_testmv8hi3 */

        case 4:
          if (!(
#line 19038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8050; /* avx512vl_testmv8si3 */

        case 5:
          if (!(
#line 19038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8052; /* avx512vl_testmv4si3 */

        case 6:
          if (!(
#line 19038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8054; /* avx512f_testmv8di3 */

        case 7:
          if (!(
#line 19038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8056; /* avx512vl_testmv4di3 */

        case 8:
          if (!(
#line 19038 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8058; /* avx512vl_testmv2di3 */

        default:
          return -1;
        }

    case 159:
      switch (pattern68 (x1))
        {
        case 0:
          if (!(
#line 19049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8064; /* avx512vl_testnmv16qi3 */

        case 1:
          if (!(
#line 19049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8068; /* avx512vl_testnmv16hi3 */

        case 2:
          if (!(
#line 19049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8072; /* avx512f_testnmv16si3 */

        case 3:
          if (!(
#line 19049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8070; /* avx512vl_testnmv8hi3 */

        case 4:
          if (!(
#line 19049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8074; /* avx512vl_testnmv8si3 */

        case 5:
          if (!(
#line 19049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8076; /* avx512vl_testnmv4si3 */

        case 6:
          if (!(
#line 19049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8078; /* avx512f_testnmv8di3 */

        case 7:
          if (!(
#line 19049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8080; /* avx512vl_testnmv4di3 */

        case 8:
          if (!(
#line 19049 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 8082; /* avx512vl_testnmv2di3 */

        default:
          return -1;
        }

    case 120:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V8QImode:
          if (pattern728 (x2, 
E_V8QImode) != 0
              || !
#line 23204 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return -1;
          return 8564; /* ssse3_psignv8qi3 */

        case E_V4HImode:
          if (pattern64 (x2, 
E_V4HImode) != 0
              || !
#line 23204 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return -1;
          return 8565; /* ssse3_psignv4hi3 */

        case E_V2SImode:
          if (pattern728 (x2, 
E_V2SImode) != 0
              || !
#line 23204 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return -1;
          return 8566; /* ssse3_psignv2si3 */

        default:
          return -1;
        }

    case 148:
      if (pattern66 (x1) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (!register_operand (operands[0], E_V8SFmode)
              || !nonimmediate_operand (operands[1], E_V8SFmode)
              || !
#line 25304 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 8861; /* avx_vtestps256 */

        case E_V4SFmode:
          if (!register_operand (operands[0], E_V4SFmode)
              || !nonimmediate_operand (operands[1], E_V4SFmode)
              || !
#line 25304 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 8862; /* avx_vtestps */

        case E_V4DFmode:
          if (!register_operand (operands[0], E_V4DFmode)
              || !nonimmediate_operand (operands[1], E_V4DFmode)
              || !
#line 25304 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 8863; /* avx_vtestpd256 */

        case E_V2DFmode:
          if (!register_operand (operands[0], E_V2DFmode)
              || !nonimmediate_operand (operands[1], E_V2DFmode)
              || !(
#line 25304 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 8864; /* avx_vtestpd */

        default:
          return -1;
        }

    case 130:
      return recog_10 (x1, insn, pnum_clobbers);

    case 150:
      if (GET_MODE (x2) != E_V4HImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_V4HImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_SImode)
          || !
#line 29159 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL))
        return -1;
      return 9585; /* *vcvtps2ph_store */

    case 193:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          switch (pattern637 (x2, 
E_HImode))
            {
            case 0:
              if (!(
#line 29857 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V16HFmode)) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 9910; /* avx512dq_fpclassv16hf */

            case 1:
              if (!(
#line 29857 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V16SFmode)) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9914; /* avx512dq_fpclassv16sf */

            default:
              return -1;
            }

        case E_QImode:
          if (!register_operand (operands[0], E_QImode)
              || GET_MODE (x2) != E_QImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!vector_operand (operands[1], E_V8HFmode)
                  || !(
#line 29857 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V8HFmode)) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 9912; /* avx512dq_fpclassv8hf */

            case E_V8SFmode:
              if (!vector_operand (operands[1], E_V8SFmode)
                  || !(
#line 29857 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V8SFmode)) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9916; /* avx512dq_fpclassv8sf */

            case E_V4SFmode:
              if (!vector_operand (operands[1], E_V4SFmode)
                  || !(
#line 29857 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V4SFmode)) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9918; /* avx512dq_fpclassv4sf */

            case E_V8DFmode:
              if (!vector_operand (operands[1], E_V8DFmode)
                  || !(
#line 29857 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V8DFmode)) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 9920; /* avx512dq_fpclassv8df */

            case E_V4DFmode:
              if (!vector_operand (operands[1], E_V4DFmode)
                  || !(
#line 29857 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V4DFmode)) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9922; /* avx512dq_fpclassv4df */

            case E_V2DFmode:
              if (!vector_operand (operands[1], E_V2DFmode)
                  || !(
#line 29857 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || VALID_AVX512FP16_REG_MODE(V2DFmode)) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 9924; /* avx512dq_fpclassv2df */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 214:
      if (GET_MODE (x2) != E_HImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_HImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16QImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!nonimmediate_operand (operands[2], E_V16QImode)
          || !(
#line 30940 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BITALG) && 
#line 327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10252; /* avx512vl_vpshufbitqmbv16qi */

    case 215:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_P2QImode:
          if (!register_operand (operands[0], E_P2QImode)
              || GET_MODE (x2) != E_P2QImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8DImode:
              if (!register_operand (operands[1], E_V8DImode)
                  || !vector_operand (operands[2], E_V8DImode)
                  || !(
#line 30980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30946 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 10258; /* avx512vp2intersect_2intersectv8di */

            case E_V4DImode:
              if (!register_operand (operands[1], E_V4DImode)
                  || !vector_operand (operands[2], E_V4DImode)
                  || !(
#line 30980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30947 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10259; /* avx512vp2intersect_2intersectv4di */

            case E_V2DImode:
              if (!register_operand (operands[1], E_V2DImode)
                  || !vector_operand (operands[2], E_V2DImode)
                  || !(
#line 30980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30947 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10260; /* avx512vp2intersect_2intersectv2di */

            case E_V8SImode:
              if (!register_operand (operands[1], E_V8SImode)
                  || !vector_operand (operands[2], E_V8SImode)
                  || !(
#line 30980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30948 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10261; /* avx512vp2intersect_2intersectv8si */

            case E_V4SImode:
              if (!register_operand (operands[1], E_V4SImode)
                  || !vector_operand (operands[2], E_V4SImode)
                  || !(
#line 30980 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT) && 
#line 30948 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 10262; /* avx512vp2intersect_2intersectv4si */

            default:
              return -1;
            }

        case E_P2HImode:
          if (pattern729 (x2, 
E_V16SImode, 
E_P2HImode) != 0
              || !
#line 30989 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT && TARGET_EVEX512))
            return -1;
          return 10263; /* avx512vp2intersect_2intersectv16si */

        default:
          return -1;
        }

    case 262:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x2) != E_HImode
              || !nonimmediate_operand (operands[1], E_V16BFmode)
              || !
#line 32456 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10646; /* avx10_2_fpclassbf16_v16bf */

        case E_QImode:
          if (!register_operand (operands[0], E_QImode)
              || GET_MODE (x2) != E_QImode
              || !nonimmediate_operand (operands[1], E_V8BFmode)
              || !
#line 32456 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10648; /* avx10_2_fpclassbf16_v8bf */

        default:
          return -1;
        }

    case 288:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_int_operand (operands[2], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!memory_operand (operands[0], E_QImode)
              || GET_MODE (x2) != E_QImode
              || !nonmemory_operand (operands[1], E_QImode))
            return -1;
          return 10907; /* atomic_storeqi_1 */

        case E_HImode:
          if (!memory_operand (operands[0], E_HImode)
              || GET_MODE (x2) != E_HImode
              || !nonmemory_operand (operands[1], E_HImode))
            return -1;
          return 10908; /* atomic_storehi_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_36 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
      switch (pattern1062 (x2))
        {
        case 0:
          switch (GET_MODE (operands[1]))
            {
            case E_V16SImode:
              if (!register_operand (operands[1], E_V16SImode)
                  || !nonimmediate_operand (operands[2], E_V16SImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3253; /* avx512f_cmpv16si3_mask */

            case E_V16HFmode:
              if (!register_operand (operands[1], E_V16HFmode)
                  || !nonimmediate_operand (operands[2], E_V16HFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 3272; /* avx512vl_cmpv16hf3_mask */

            case E_V16SFmode:
              if (!register_operand (operands[1], E_V16SFmode)
                  || !nonimmediate_operand (operands[2], E_V16SFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3277; /* avx512f_cmpv16sf3_mask */

            case E_V16QImode:
              if (!register_operand (operands[1], E_V16QImode)
                  || !nonimmediate_operand (operands[2], E_V16QImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4490 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3399; /* avx512vl_cmpv16qi3_mask */

            case E_V16HImode:
              if (!register_operand (operands[1], E_V16HImode)
                  || !nonimmediate_operand (operands[2], E_V16HImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4490 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3405; /* avx512vl_cmpv16hi3_mask */

            case E_V16BFmode:
              if (!register_operand (operands[1], E_V16BFmode)
                  || !nonimmediate_operand (operands[2], E_V16BFmode)
                  || !const_0_to_31_operand (operands[3], E_VOIDmode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32467 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10653; /* avx10_2_cmpbf16_v16bf_mask */

            default:
              return -1;
            }

        case 1:
          switch (GET_MODE (operands[1]))
            {
            case E_V8SImode:
              if (!register_operand (operands[1], E_V8SImode)
                  || !nonimmediate_operand (operands[2], E_V8SImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3256; /* avx512vl_cmpv8si3_mask */

            case E_V4SImode:
              if (!register_operand (operands[1], E_V4SImode)
                  || !nonimmediate_operand (operands[2], E_V4SImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3258; /* avx512vl_cmpv4si3_mask */

            case E_V8DImode:
              if (!register_operand (operands[1], E_V8DImode)
                  || !nonimmediate_operand (operands[2], E_V8DImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3261; /* avx512f_cmpv8di3_mask */

            case E_V4DImode:
              if (!register_operand (operands[1], E_V4DImode)
                  || !nonimmediate_operand (operands[2], E_V4DImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3264; /* avx512vl_cmpv4di3_mask */

            case E_V2DImode:
              if (!register_operand (operands[1], E_V2DImode)
                  || !nonimmediate_operand (operands[2], E_V2DImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3266; /* avx512vl_cmpv2di3_mask */

            case E_V8HFmode:
              if (!register_operand (operands[1], E_V8HFmode)
                  || !nonimmediate_operand (operands[2], E_V8HFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
                return -1;
              return 3274; /* avx512fp16_cmpv8hf3_mask */

            case E_V8SFmode:
              if (!register_operand (operands[1], E_V8SFmode)
                  || !nonimmediate_operand (operands[2], E_V8SFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3280; /* avx512vl_cmpv8sf3_mask */

            case E_V4SFmode:
              if (!register_operand (operands[1], E_V4SFmode)
                  || !nonimmediate_operand (operands[2], E_V4SFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3282; /* avx512vl_cmpv4sf3_mask */

            case E_V8DFmode:
              if (!register_operand (operands[1], E_V8DFmode)
                  || !nonimmediate_operand (operands[2], E_V8DFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 3285; /* avx512f_cmpv8df3_mask */

            case E_V4DFmode:
              if (!register_operand (operands[1], E_V4DFmode)
                  || !nonimmediate_operand (operands[2], E_V4DFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3288; /* avx512vl_cmpv4df3_mask */

            case E_V2DFmode:
              if (!register_operand (operands[1], E_V2DFmode)
                  || !nonimmediate_operand (operands[2], E_V2DFmode)
                  || !const_0_to_31_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4398 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3290; /* avx512vl_cmpv2df3_mask */

            case E_V8HImode:
              if (!register_operand (operands[1], E_V8HImode)
                  || !nonimmediate_operand (operands[2], E_V8HImode)
                  || !const_0_to_7_operand (operands[3], E_SImode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4490 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 3407; /* avx512vl_cmpv8hi3_mask */

            case E_V8BFmode:
              if (!register_operand (operands[1], E_V8BFmode)
                  || !nonimmediate_operand (operands[2], E_V8BFmode)
                  || !const_0_to_31_operand (operands[3], E_VOIDmode)
                  || !(
#line 122 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32467 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10655; /* avx10_2_cmpbf16_v8bf_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x3, 0) != 1L
          || pattern1189 (x2) != 0)
        return -1;
      switch (pattern1493 ())
        {
        case 0:
          if (!(
#line 4822 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 3618; /* avx512f_vmcmpv8hf3 */

        case 1:
          if (!
#line 4822 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 3620; /* avx512f_vmcmpv4sf3 */

        case 2:
          if (!(
#line 4822 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3622; /* avx512f_vmcmpv2df3 */

        default:
          return -1;
        }

    case AND:
      if (GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XEXP (x3, 1);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || pattern1189 (x2) != 0)
        return -1;
      x5 = XEXP (x3, 0);
      operands[4] = x5;
      if (!register_operand (operands[4], E_QImode))
        return -1;
      switch (pattern1493 ())
        {
        case 0:
          if (!(
#line 4840 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 3624; /* avx512f_vmcmpv8hf3_mask */

        case 1:
          if (!
#line 4840 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 3626; /* avx512f_vmcmpv4sf3_mask */

        case 2:
          if (!(
#line 4840 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3628; /* avx512f_vmcmpv2df3_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_49 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case LTU:
      switch (pattern43 (x1))
        {
        case 0:
          if (
#line 9905 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_pre_reload_split ()))
            return 530; /* *setcc_qi_negqi_ccc_1_cc */
          break;

        case 1:
          if (
#line 9905 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_pre_reload_split ()))
            return 531; /* *setcc_qi_negqi_ccc_1_ccc */
          break;

        default:
          break;
        }
      break;

    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case LTGT:
    case UNORDERED:
    case ORDERED:
    case UNEQ:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      res = recog_47 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    default:
      break;
    }
  operands[1] = x2;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) == REG
      && REGNO (x3) == 17)
    {
      res = recog_48 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
    }
  switch (GET_CODE (operands[1]))
    {
    case NE:
    case EQ:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      operands[2] = x3;
      x5 = XEXP (x2, 1);
      operands[3] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V8QImode:
          if (pattern741 (
E_V8QImode) != 0
              || !
#line 4218 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2235; /* *xop_maskcmp_unsv8qi3 */

        case E_V4HImode:
          if (pattern741 (
E_V4HImode) != 0
              || !
#line 4218 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2236; /* *xop_maskcmp_unsv4hi3 */

        case E_V2SImode:
          if (pattern741 (
E_V2SImode) != 0
              || !
#line 4218 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2237; /* *xop_maskcmp_unsv2si3 */

        case E_V4QImode:
          if (pattern741 (
E_V4QImode) != 0
              || !
#line 4228 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2238; /* *xop_maskcmp_unsv4qi3 */

        case E_V2QImode:
          if (pattern741 (
E_V2QImode) != 0
              || !
#line 4228 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2239; /* *xop_maskcmp_unsv2qi3 */

        case E_V2HImode:
          if (pattern741 (
E_V2HImode) != 0
              || !
#line 4228 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
            return -1;
          return 2240; /* *xop_maskcmp_unsv2hi3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_56 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x3) != E_HImode
              || !nonimmediate_operand (operands[1], E_HImode)
              || !general_operand (operands[2], E_HImode))
            return -1;
          if ((
#line 10616 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF) && 
#line 1191 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH)))
            return 590; /* *mulhi3_1_nf */
          if (pnum_clobbers == NULL
              || !(
#line 10616 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1191 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH)))
            return -1;
          *pnum_clobbers = 1;
          return 591; /* *mulhi3_1 */

        case E_QImode:
          if (pattern5 (x3, 
E_QImode) != 0)
            return -1;
          if (
#line 10703 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF))
            return 602; /* *mulqi3_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 10703 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 603; /* *mulqi3_1 */

        case E_HFmode:
          if (pattern5 (x3, 
E_HFmode) != 0
              || !
#line 23483 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 1678; /* *mulhf */

        case E_V2SImode:
          if (pattern7 (x3, 
E_V2SImode) != 0
              || !
#line 3352 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return -1;
          return 2158; /* mulv2si3 */

        case E_V4HImode:
          if (pattern8 (x3, 
E_V4HImode) != 0
              || !
#line 3381 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (MULT, V4HImode, operands)))
            return -1;
          return 2159; /* *mmx_mulv4hi3 */

        case E_V2HImode:
          if (pattern7 (x3, 
E_V2HImode) != 0
              || !
#line 3396 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2160; /* mulv2hi3 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != ZERO_EXTEND)
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[1] = x6;
          x7 = XEXP (x5, 0);
          operands[2] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_TImode:
              if (pnum_clobbers == NULL
                  || pattern849 (x3, 
E_DImode, 
E_TImode) != 0
                  || !(
#line 11006 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 618; /* *umulditi3_1 */

            case E_HImode:
              if (pattern849 (x3, 
E_QImode, 
E_HImode) != 0)
                return -1;
              if (
#line 11072 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF))
                return 625; /* *umulqihi3_1_nf */
              if (pnum_clobbers == NULL
                  || !
#line 11072 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
                return -1;
              *pnum_clobbers = 1;
              return 626; /* *umulqihi3_1 */

            default:
              return -1;
            }

        case VEC_SELECT:
          if (GET_MODE (x6) != E_V1SImode)
            return -1;
          x8 = XEXP (x6, 1);
          if (GET_CODE (x8) != PARALLEL
              || XVECLEN (x8, 0) != 1)
            return -1;
          x9 = XVECEXP (x8, 0, 0);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x7 = XEXP (x5, 0);
          if (GET_CODE (x7) != VEC_SELECT
              || GET_MODE (x7) != E_V1SImode)
            return -1;
          x10 = XEXP (x7, 1);
          if (GET_CODE (x10) != PARALLEL
              || XVECLEN (x10, 0) != 1)
            return -1;
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_V1DImode)
              || GET_MODE (x3) != E_V1DImode
              || GET_MODE (x4) != E_V1DImode)
            return -1;
          x12 = XEXP (x6, 0);
          operands[1] = x12;
          if (!register_mmxmem_operand (operands[1], E_V2SImode)
              || GET_MODE (x5) != E_V1DImode)
            return -1;
          x13 = XEXP (x7, 0);
          operands[2] = x13;
          if (!register_mmxmem_operand (operands[2], E_V2SImode)
              || !
#line 3636 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_SSE2
   && ix86_binary_operator_ok (MULT, V2SImode, operands)))
            return -1;
          return 2167; /* *sse2_umulv1siv1di3 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != SIGN_EXTEND)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x7 = XEXP (x5, 0);
      operands[2] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (pattern849 (x3, 
E_DImode, 
E_TImode) != 0)
            return -1;
          if ((
#line 11052 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 621; /* *mulditi3_1_nf */
          if (pnum_clobbers == NULL
              || !(
#line 1199 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && (
#line 11052 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return -1;
          *pnum_clobbers = 1;
          return 622; /* *mulditi3_1 */

        case E_HImode:
          if (pattern849 (x3, 
E_QImode, 
E_HImode) != 0)
            return -1;
          if (
#line 11072 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && TARGET_APX_NF))
            return 623; /* *mulqihi3_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 11072 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 624; /* *mulqihi3_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_64 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      switch (pattern45 (x3))
        {
        case 0:
          if (!
#line 3323 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (SS_PLUS, V8QImode, operands)))
            return -1;
          return 2138; /* *mmx_ssaddv8qi3 */

        case 1:
          if (!
#line 3323 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (SS_PLUS, V4HImode, operands)))
            return -1;
          return 2142; /* *mmx_ssaddv4hi3 */

        case 2:
          if (!
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2146; /* ssaddv4qi3 */

        case 3:
          if (!
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2150; /* ssaddv2qi3 */

        case 4:
          if (!
#line 3339 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2154; /* ssaddv2hi3 */

        default:
          return -1;
        }

    case VEC_SELECT:
      if (pattern101 (x3) != 0
          || !
#line 22618 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
        return -1;
      return 8523; /* ssse3_phaddswv4hi3 */

    case MULT:
      if (GET_MODE (x4) != E_V4HImode)
        return -1;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != ZERO_EXTEND
          || GET_MODE (x5) != E_V4HImode)
        return -1;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != VEC_SELECT
          || GET_MODE (x6) != E_V4QImode)
        return -1;
      x7 = XEXP (x6, 1);
      if (GET_CODE (x7) != PARALLEL
          || XVECLEN (x7, 0) != 4
          || pattern1068 (x7, 
6, 
4, 
2, 
0) != 0)
        return -1;
      x8 = XEXP (x4, 1);
      if (pattern1255 (x8, 
E_V4QImode, 
E_V4HImode) != 0)
        return -1;
      x9 = XEXP (x8, 0);
      x10 = XEXP (x9, 1);
      if (pattern1602 (x10, 
6, 
4, 
2, 
0) != 0)
        return -1;
      x11 = XEXP (x3, 1);
      if (pattern1767 (x11, 
E_V4QImode, 
E_V4HImode, 
ZERO_EXTEND) != 0
          || !register_operand (operands[0], E_V4HImode)
          || GET_MODE (x3) != E_V4HImode)
        return -1;
      x12 = XEXP (x6, 0);
      operands[1] = x12;
      if (!register_operand (operands[1], E_V8QImode))
        return -1;
      x13 = XEXP (x9, 0);
      operands[2] = x13;
      if (!register_mmxmem_operand (operands[2], E_V8QImode))
        return -1;
      x14 = XEXP (x11, 0);
      x15 = XEXP (x14, 0);
      x16 = XEXP (x15, 0);
      if (!rtx_equal_p (x16, operands[1]))
        return -1;
      x17 = XEXP (x11, 1);
      x18 = XEXP (x17, 0);
      x19 = XEXP (x18, 0);
      if (!rtx_equal_p (x19, operands[2])
          || !
#line 22902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
        return -1;
      return 8542; /* ssse3_pmaddubsw */

    default:
      return -1;
    }
}

 int
recog_68 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_DImode)
    return -1;
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  if (!nonimmediate_operand (operands[1], E_SImode))
    return -1;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_CODE (operands[2]))
    {
    case CONST_INT:
      if (pnum_clobbers == NULL
          || !const_int_operand (operands[2], E_QImode)
          || !
#line 17280 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && INTVAL (operands[2]) == 31
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)))
        return -1;
      *pnum_clobbers = 1;
      return 1170; /* *ashrsi3_cvt_zext */

    case REG:
    case SUBREG:
      if (!register_operand (operands[2], E_SImode)
          || !
#line 17459 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
        return -1;
      return 1185; /* *bmi2_ashrsi3_1_zext */

    default:
      return -1;
    }
}

 int
recog_69 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (XVECLEN (x3, 0))
    {
    case 1:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x2) != E_DImode
          || GET_MODE (x3) != E_SImode)
        return -1;
      switch (XINT (x3, 1))
        {
        case 19:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 23231 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_X32))
            return -1;
          return 1660; /* *load_tp_x32_zext */

        case 49:
          x4 = XVECEXP (x3, 0, 0);
          switch (GET_CODE (x4))
            {
            case REG:
            case SUBREG:
              operands[1] = x4;
              switch (GET_MODE (operands[1]))
                {
                case E_V8SFmode:
                  if (register_operand (operands[1], E_V8SFmode)
                      && (
#line 21947 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return 8440; /* *avx_movmskps256_uext */
                  break;

                case E_V4SFmode:
                  if (register_operand (operands[1], E_V4SFmode)
                      && 
#line 21947 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
                    return 8442; /* *sse_movmskps_uext */
                  break;

                case E_V4DFmode:
                  if (register_operand (operands[1], E_V4DFmode)
                      && (
#line 21947 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return 8444; /* *avx_movmskpd256_uext */
                  break;

                case E_V2DFmode:
                  if (register_operand (operands[1], E_V2DFmode)
                      && (
#line 21947 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return 8446; /* *sse2_movmskpd_uext */
                  break;

                case E_V32QImode:
                  if (register_operand (operands[1], E_V32QImode)
                      && (
#line 22102 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return 8485; /* *avx2_pmovmskb_zext */
                  break;

                case E_V16QImode:
                  if (register_operand (operands[1], E_V16QImode)
                      && 
#line 22102 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2))
                    return 8486; /* *sse2_pmovmskb_zext */
                  break;

                default:
                  break;
                }
              if (GET_CODE (x4) != SUBREG)
                return -1;
              switch (pattern1074 (x4))
                {
                case 0:
                  if (!(
#line 22029 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8464; /* *avx_movmskps256_uext_lt_avx512 */

                case 1:
                  if (!
#line 22029 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
                    return -1;
                  return 8466; /* *sse_movmskps_uext_lt_avx512 */

                case 2:
                  if (!(
#line 22029 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8468; /* *avx_movmskpd256_uext_lt_avx512 */

                case 3:
                  if (!(
#line 22029 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 8470; /* *sse2_movmskpd_uext_lt_avx512 */

                case 4:
                  if (!(
#line 22068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8476; /* *avx_movmskps256_uext_shift */

                case 5:
                  if (!
#line 22068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
                    return -1;
                  return 8478; /* *sse_movmskps_uext_shift */

                case 6:
                  if (!(
#line 22068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8480; /* *avx_movmskpd256_uext_shift */

                case 7:
                  if (!(
#line 22068 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 8482; /* *sse2_movmskpd_uext_shift */

                default:
                  return -1;
                }

            case LT:
              switch (pattern969 (x4))
                {
                case 0:
                  if (!(
#line 22004 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8456; /* *avx_movmskps256_uext_lt */

                case 1:
                  if (!
#line 22004 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
                    return -1;
                  return 8458; /* *sse_movmskps_uext_lt */

                case 2:
                  if (!(
#line 22004 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return -1;
                  return 8460; /* *avx_movmskpd256_uext_lt */

                case 3:
                  if (!(
#line 22004 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                    return -1;
                  return 8462; /* *sse2_movmskpd_uext_lt */

                case 4:
                  if (!(
#line 22264 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return -1;
                  return 8493; /* *avx2_pmovmskb_zext_lt */

                case 5:
                  if (!
#line 22264 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2))
                    return -1;
                  return 8494; /* *sse2_pmovmskb_zext_lt */

                default:
                  return -1;
                }

            case VEC_MERGE:
              switch (pattern971 (x4))
                {
                case 0:
                  if (!(
#line 22293 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                    return -1;
                  return 8495; /* *avx2_pmovmskb_zext_lt_avx512 */

                case 1:
                  if (!
#line 22293 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2))
                    return -1;
                  return 8496; /* *sse2_pmovmskb_zext_lt_avx512 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 2:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      switch (XINT (x3, 1))
        {
        case 95:
          if (GET_MODE (x3) != E_SImode
              || !register_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !register_operand (operands[1], E_SImode)
              || !nonimmediate_operand (operands[2], E_DImode)
              || !
#line 29096 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_CRC32))
            return -1;
          return 1894; /* sse4_2_crc32di */

        case 158:
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              switch (pattern863 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (DImode))) && 
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8084; /* *avx512bw_testmv64qi3_zext */

                case 1:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8087; /* *avx512vl_testmv32qi3_zext */

                case 2:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (SImode))) && 
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8093; /* *avx512bw_testmv32hi3_zext */

                case 3:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8090; /* *avx512vl_testmv16qi3_zext */

                case 4:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8096; /* *avx512vl_testmv16hi3_zext */

                case 5:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8102; /* *avx512f_testmv16si3_zext */

                case 6:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8099; /* *avx512vl_testmv8hi3_zext */

                case 7:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8105; /* *avx512vl_testmv8si3_zext */

                case 8:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8108; /* *avx512vl_testmv4si3_zext */

                case 9:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8111; /* *avx512f_testmv8di3_zext */

                case 10:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8114; /* *avx512vl_testmv4di3_zext */

                case 11:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8117; /* *avx512vl_testmv2di3_zext */

                default:
                  return -1;
                }

            case E_SImode:
              switch (pattern863 (x2, 
E_SImode))
                {
                case 0:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (DImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8085; /* *avx512bw_testmv64qi3_zext */

                case 1:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8088; /* *avx512vl_testmv32qi3_zext */

                case 2:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8094; /* *avx512bw_testmv32hi3_zext */

                case 3:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8091; /* *avx512vl_testmv16qi3_zext */

                case 4:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8097; /* *avx512vl_testmv16hi3_zext */

                case 5:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8103; /* *avx512f_testmv16si3_zext */

                case 6:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8100; /* *avx512vl_testmv8hi3_zext */

                case 7:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8106; /* *avx512vl_testmv8si3_zext */

                case 8:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8109; /* *avx512vl_testmv4si3_zext */

                case 9:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8112; /* *avx512f_testmv8di3_zext */

                case 10:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8115; /* *avx512vl_testmv4di3_zext */

                case 11:
                  if (!(
#line 19061 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8118; /* *avx512vl_testmv2di3_zext */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 159:
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              switch (pattern863 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (DImode))) && 
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8156; /* *avx512bw_testnmv64qi3_zext */

                case 1:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8159; /* *avx512vl_testnmv32qi3_zext */

                case 2:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (SImode))) && 
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                    return -1;
                  return 8165; /* *avx512bw_testnmv32hi3_zext */

                case 3:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8162; /* *avx512vl_testnmv16qi3_zext */

                case 4:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8168; /* *avx512vl_testnmv16hi3_zext */

                case 5:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8174; /* *avx512f_testnmv16si3_zext */

                case 6:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8171; /* *avx512vl_testnmv8hi3_zext */

                case 7:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8177; /* *avx512vl_testnmv8si3_zext */

                case 8:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8180; /* *avx512vl_testnmv4si3_zext */

                case 9:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8183; /* *avx512f_testnmv8di3_zext */

                case 10:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8186; /* *avx512vl_testnmv4di3_zext */

                case 11:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (8
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8189; /* *avx512vl_testnmv2di3_zext */

                default:
                  return -1;
                }

            case E_SImode:
              switch (pattern863 (x2, 
E_SImode))
                {
                case 0:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (DImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8157; /* *avx512bw_testnmv64qi3_zext */

                case 1:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8160; /* *avx512vl_testnmv32qi3_zext */

                case 2:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (SImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
                    return -1;
                  return 8166; /* *avx512bw_testnmv32hi3_zext */

                case 3:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8163; /* *avx512vl_testnmv16qi3_zext */

                case 4:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8169; /* *avx512vl_testnmv16hi3_zext */

                case 5:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (HImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8175; /* *avx512f_testnmv16si3_zext */

                case 6:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW))))
                    return -1;
                  return 8172; /* *avx512vl_testnmv8hi3_zext */

                case 7:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8178; /* *avx512vl_testnmv8si3_zext */

                case 8:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8181; /* *avx512vl_testnmv4si3_zext */

                case 9:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 8184; /* *avx512f_testnmv8di3_zext */

                case 10:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8187; /* *avx512vl_testnmv4di3_zext */

                case 11:
                  if (!(
#line 19091 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (4
       > GET_MODE_SIZE (QImode))) && ((
#line 19030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 8190; /* *avx512vl_testnmv2di3_zext */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 3:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x3, 0, 2);
      operands[3] = x6;
      if (!const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      switch (XINT (x3, 1))
        {
        case 59:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              switch (pattern1076 (x2, 
E_SImode))
                {
                case 0:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3292; /* *avx512f_cmpv16si3_zero_extendsi */

                case 1:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3313; /* *avx512vl_cmpv16hf3_zero_extendsi */

                case 2:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3319; /* *avx512f_cmpv16sf3_zero_extendsi */

                case 3:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V16QImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3412; /* *avx512vl_cmpv16qi3_zero_extendsi */

                case 4:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V16HImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3421; /* *avx512vl_cmpv16hi3_zero_extendsi */

                case 5:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3295; /* *avx512vl_cmpv8si3_zero_extendsi */

                case 6:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3298; /* *avx512vl_cmpv4si3_zero_extendsi */

                case 7:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3301; /* *avx512f_cmpv8di3_zero_extendsi */

                case 8:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3304; /* *avx512vl_cmpv4di3_zero_extendsi */

                case 9:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3307; /* *avx512vl_cmpv2di3_zero_extendsi */

                case 10:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3316; /* *avx512fp16_cmpv8hf3_zero_extendsi */

                case 11:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3322; /* *avx512vl_cmpv8sf3_zero_extendsi */

                case 12:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3325; /* *avx512vl_cmpv4sf3_zero_extendsi */

                case 13:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3328; /* *avx512f_cmpv8df3_zero_extendsi */

                case 14:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3331; /* *avx512vl_cmpv4df3_zero_extendsi */

                case 15:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3334; /* *avx512vl_cmpv2df3_zero_extendsi */

                case 16:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V8HImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3424; /* *avx512vl_cmpv8hi3_zero_extendsi */

                case 17:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
      < GET_MODE_PRECISION (SImode))) && 
#line 309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                    return -1;
                  return 3310; /* *avx512bw_cmpv32hf3_zero_extendsi */

                case 18:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V32QImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3415; /* *avx512vl_cmpv32qi3_zero_extendsi */

                case 19:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V32HImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3418; /* *avx512bw_cmpv32hi3_zero_extendsi */

                case 20:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V64QImode)
       < GET_MODE_PRECISION (SImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3409; /* *avx512bw_cmpv64qi3_zero_extendsi */

                default:
                  return -1;
                }

            case E_DImode:
              switch (pattern1076 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3293; /* *avx512f_cmpv16si3_zero_extenddi */

                case 1:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3314; /* *avx512vl_cmpv16hf3_zero_extenddi */

                case 2:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3320; /* *avx512f_cmpv16sf3_zero_extenddi */

                case 3:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V16QImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3413; /* *avx512vl_cmpv16qi3_zero_extenddi */

                case 4:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V16HImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3422; /* *avx512vl_cmpv16hi3_zero_extenddi */

                case 5:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3296; /* *avx512vl_cmpv8si3_zero_extenddi */

                case 6:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3299; /* *avx512vl_cmpv4si3_zero_extenddi */

                case 7:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3302; /* *avx512f_cmpv8di3_zero_extenddi */

                case 8:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3305; /* *avx512vl_cmpv4di3_zero_extenddi */

                case 9:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3308; /* *avx512vl_cmpv2di3_zero_extenddi */

                case 10:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3317; /* *avx512fp16_cmpv8hf3_zero_extenddi */

                case 11:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3323; /* *avx512vl_cmpv8sf3_zero_extenddi */

                case 12:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3326; /* *avx512vl_cmpv4sf3_zero_extenddi */

                case 13:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3329; /* *avx512f_cmpv8df3_zero_extenddi */

                case 14:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3332; /* *avx512vl_cmpv4df3_zero_extenddi */

                case 15:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3335; /* *avx512vl_cmpv2df3_zero_extenddi */

                case 16:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V8HImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3425; /* *avx512vl_cmpv8hi3_zero_extenddi */

                case 17:
                  if (!(
#line 4415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
      < GET_MODE_PRECISION (DImode))) && 
#line 309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                    return -1;
                  return 3311; /* *avx512bw_cmpv32hf3_zero_extenddi */

                case 18:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V32QImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3416; /* *avx512vl_cmpv32qi3_zero_extenddi */

                case 19:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V32HImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3419; /* *avx512bw_cmpv32hi3_zero_extenddi */

                case 20:
                  if (!(
#line 4505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && (GET_MODE_NUNITS (V64QImode)
       < GET_MODE_PRECISION (DImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3410; /* *avx512bw_cmpv64qi3_zero_extenddi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 157:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              switch (pattern1078 (x2, 
E_SImode))
                {
                case 0:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3493; /* *avx512bw_ucmpv64qi3_zero_extendsi */

                case 1:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3496; /* *avx512vl_ucmpv16qi3_zero_extendsi */

                case 2:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3505; /* *avx512vl_ucmpv16hi3_zero_extendsi */

                case 3:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3570; /* *avx512f_ucmpv16si3_zero_extendsi */

                case 4:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3499; /* *avx512vl_ucmpv32qi3_zero_extendsi */

                case 5:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3502; /* *avx512bw_ucmpv32hi3_zero_extendsi */

                case 6:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3508; /* *avx512vl_ucmpv8hi3_zero_extendsi */

                case 7:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3571; /* *avx512vl_ucmpv8si3_zero_extendsi */

                case 8:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3572; /* *avx512vl_ucmpv4si3_zero_extendsi */

                case 9:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3573; /* *avx512f_ucmpv8di3_zero_extendsi */

                case 10:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3574; /* *avx512vl_ucmpv4di3_zero_extendsi */

                case 11:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
      < GET_MODE_PRECISION (SImode))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3575; /* *avx512vl_ucmpv2di3_zero_extendsi */

                default:
                  return -1;
                }

            case E_DImode:
              switch (pattern1078 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3494; /* *avx512bw_ucmpv64qi3_zero_extenddi */

                case 1:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3497; /* *avx512vl_ucmpv16qi3_zero_extenddi */

                case 2:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3506; /* *avx512vl_ucmpv16hi3_zero_extenddi */

                case 3:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3576; /* *avx512f_ucmpv16si3_zero_extenddi */

                case 4:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3500; /* *avx512vl_ucmpv32qi3_zero_extenddi */

                case 5:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3503; /* *avx512bw_ucmpv32hi3_zero_extenddi */

                case 6:
                  if (!(
#line 4615 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3509; /* *avx512vl_ucmpv8hi3_zero_extenddi */

                case 7:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3577; /* *avx512vl_ucmpv8si3_zero_extenddi */

                case 8:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3578; /* *avx512vl_ucmpv4si3_zero_extenddi */

                case 9:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3579; /* *avx512f_ucmpv8di3_zero_extenddi */

                case 10:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3580; /* *avx512vl_ucmpv4di3_zero_extenddi */

                case 11:
                  if (!(
#line 4704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
      < GET_MODE_PRECISION (DImode))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3581; /* *avx512vl_ucmpv2di3_zero_extenddi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_132 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[3] = x6;
      x7 = XEXP (x2, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[4] = x7;
          x8 = XEXP (x2, 2);
          operands[5] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1353 (x2, 
E_V32HFmode, 
E_SImode) != 0
                  || !(
#line 6425 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 4025; /* fma_fmaddsub_v32hf_maskz_1 */

            case E_V16HFmode:
              if (pattern1353 (x2, 
E_V16HFmode, 
E_HImode) != 0
                  || !(
#line 6425 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4029; /* fma_fmaddsub_v16hf_maskz_1 */

            case E_V8HFmode:
              if (pattern1353 (x2, 
E_V8HFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4031; /* fma_fmaddsub_v8hf_maskz_1 */

            case E_V16SFmode:
              if (pattern1353 (x2, 
E_V16SFmode, 
E_HImode) != 0
                  || !(
#line 6425 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4033; /* fma_fmaddsub_v16sf_maskz_1 */

            case E_V8SFmode:
              if (pattern1353 (x2, 
E_V8SFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4037; /* fma_fmaddsub_v8sf_maskz_1 */

            case E_V4SFmode:
              if (pattern1353 (x2, 
E_V4SFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4039; /* fma_fmaddsub_v4sf_maskz_1 */

            case E_V8DFmode:
              if (pattern1353 (x2, 
E_V8DFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4041; /* fma_fmaddsub_v8df_maskz_1 */

            case E_V4DFmode:
              if (pattern1353 (x2, 
E_V4DFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4045; /* fma_fmaddsub_v4df_maskz_1 */

            case E_V2DFmode:
              if (pattern1353 (x2, 
E_V2DFmode, 
E_QImode) != 0
                  || !(
#line 6425 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4047; /* fma_fmaddsub_v2df_maskz_1 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          x8 = XEXP (x2, 2);
          operands[4] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1260 (x2, 
E_V32HFmode, 
E_SImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V32HFmode)
                  && vector_operand (operands[3], E_V32HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return 4048; /* avx512bw_fmaddsub_v32hf_mask */
              if (!nonimmediate_operand (operands[1], E_V32HFmode)
                  || !nonimmediate_operand (operands[3], E_V32HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 4066; /* avx512bw_fmaddsub_v32hf_mask3 */

            case E_V16HFmode:
              if (pattern1260 (x2, 
E_V16HFmode, 
E_HImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V16HFmode)
                  && vector_operand (operands[3], E_V16HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return 4050; /* avx512vl_fmaddsub_v16hf_mask */
              if (!nonimmediate_operand (operands[1], E_V16HFmode)
                  || !nonimmediate_operand (operands[3], E_V16HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4068; /* avx512vl_fmaddsub_v16hf_mask3 */

            case E_V8HFmode:
              if (pattern1260 (x2, 
E_V8HFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V8HFmode)
                  && vector_operand (operands[3], E_V8HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return 4052; /* avx512fp16_fmaddsub_v8hf_mask */
              if (!nonimmediate_operand (operands[1], E_V8HFmode)
                  || !nonimmediate_operand (operands[3], E_V8HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4070; /* avx512fp16_fmaddsub_v8hf_mask3 */

            case E_V16SFmode:
              if (pattern1260 (x2, 
E_V16SFmode, 
E_HImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V16SFmode)
                  && vector_operand (operands[3], E_V16SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 4054; /* avx512f_fmaddsub_v16sf_mask */
              if (!nonimmediate_operand (operands[1], E_V16SFmode)
                  || !nonimmediate_operand (operands[3], E_V16SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4072; /* avx512f_fmaddsub_v16sf_mask3 */

            case E_V8SFmode:
              if (pattern1260 (x2, 
E_V8SFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V8SFmode)
                  && vector_operand (operands[3], E_V8SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4056; /* avx512vl_fmaddsub_v8sf_mask */
              if (!nonimmediate_operand (operands[1], E_V8SFmode)
                  || !nonimmediate_operand (operands[3], E_V8SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4074; /* avx512vl_fmaddsub_v8sf_mask3 */

            case E_V4SFmode:
              if (pattern1260 (x2, 
E_V4SFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V4SFmode)
                  && vector_operand (operands[3], E_V4SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4058; /* avx512vl_fmaddsub_v4sf_mask */
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !nonimmediate_operand (operands[3], E_V4SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4076; /* avx512vl_fmaddsub_v4sf_mask3 */

            case E_V8DFmode:
              if (pattern1260 (x2, 
E_V8DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V8DFmode)
                  && vector_operand (operands[3], E_V8DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 4060; /* avx512f_fmaddsub_v8df_mask */
              if (!nonimmediate_operand (operands[1], E_V8DFmode)
                  || !nonimmediate_operand (operands[3], E_V8DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4078; /* avx512f_fmaddsub_v8df_mask3 */

            case E_V4DFmode:
              if (pattern1260 (x2, 
E_V4DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V4DFmode)
                  && vector_operand (operands[3], E_V4DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4062; /* avx512vl_fmaddsub_v4df_mask */
              if (!nonimmediate_operand (operands[1], E_V4DFmode)
                  || !nonimmediate_operand (operands[3], E_V4DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4080; /* avx512vl_fmaddsub_v4df_mask3 */

            case E_V2DFmode:
              if (pattern1260 (x2, 
E_V2DFmode, 
E_QImode) != 0)
                return -1;
              if (register_operand (operands[1], E_V2DFmode)
                  && vector_operand (operands[3], E_V2DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6444 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4064; /* avx512vl_fmaddsub_v2df_mask */
              if (!nonimmediate_operand (operands[1], E_V2DFmode)
                  || !nonimmediate_operand (operands[3], E_V2DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6462 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4082; /* avx512vl_fmaddsub_v2df_mask3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NEG:
      x9 = XEXP (x6, 0);
      operands[3] = x9;
      x7 = XEXP (x2, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[4] = x7;
          x8 = XEXP (x2, 2);
          operands[5] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1354 (x2, 
E_V32HFmode, 
E_SImode) != 0
                  || !(
#line 6495 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 4089; /* fma_fmsubadd_v32hf_maskz_1 */

            case E_V16HFmode:
              if (pattern1354 (x2, 
E_V16HFmode, 
E_HImode) != 0
                  || !(
#line 6495 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4093; /* fma_fmsubadd_v16hf_maskz_1 */

            case E_V8HFmode:
              if (pattern1354 (x2, 
E_V8HFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4095; /* fma_fmsubadd_v8hf_maskz_1 */

            case E_V16SFmode:
              if (pattern1354 (x2, 
E_V16SFmode, 
E_HImode) != 0
                  || !(
#line 6495 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4097; /* fma_fmsubadd_v16sf_maskz_1 */

            case E_V8SFmode:
              if (pattern1354 (x2, 
E_V8SFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4101; /* fma_fmsubadd_v8sf_maskz_1 */

            case E_V4SFmode:
              if (pattern1354 (x2, 
E_V4SFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4103; /* fma_fmsubadd_v4sf_maskz_1 */

            case E_V8DFmode:
              if (pattern1354 (x2, 
E_V8DFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4105; /* fma_fmsubadd_v8df_maskz_1 */

            case E_V4DFmode:
              if (pattern1354 (x2, 
E_V4DFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4109; /* fma_fmsubadd_v4df_maskz_1 */

            case E_V2DFmode:
              if (pattern1354 (x2, 
E_V2DFmode, 
E_QImode) != 0
                  || !(
#line 6495 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4111; /* fma_fmsubadd_v2df_maskz_1 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          x8 = XEXP (x2, 2);
          operands[4] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1261 (x2, 
E_V32HFmode, 
E_SImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V32HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return 4112; /* avx512bw_fmsubadd_v32hf_mask */
              if (!nonimmediate_operand (operands[3], E_V32HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 4130; /* avx512bw_fmsubadd_v32hf_mask3 */

            case E_V16HFmode:
              if (pattern1261 (x2, 
E_V16HFmode, 
E_HImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V16HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return 4114; /* avx512vl_fmsubadd_v16hf_mask */
              if (!nonimmediate_operand (operands[3], E_V16HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4132; /* avx512vl_fmsubadd_v16hf_mask3 */

            case E_V8HFmode:
              if (pattern1261 (x2, 
E_V8HFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V8HFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return 4116; /* avx512fp16_fmsubadd_v8hf_mask */
              if (!nonimmediate_operand (operands[3], E_V8HFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4134; /* avx512fp16_fmsubadd_v8hf_mask3 */

            case E_V16SFmode:
              if (pattern1261 (x2, 
E_V16SFmode, 
E_HImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V16SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 4118; /* avx512f_fmsubadd_v16sf_mask */
              if (!nonimmediate_operand (operands[3], E_V16SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4136; /* avx512f_fmsubadd_v16sf_mask3 */

            case E_V8SFmode:
              if (pattern1261 (x2, 
E_V8SFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V8SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4120; /* avx512vl_fmsubadd_v8sf_mask */
              if (!nonimmediate_operand (operands[3], E_V8SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4138; /* avx512vl_fmsubadd_v8sf_mask3 */

            case E_V4SFmode:
              if (pattern1261 (x2, 
E_V4SFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V4SFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4122; /* avx512vl_fmsubadd_v4sf_mask */
              if (!nonimmediate_operand (operands[3], E_V4SFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4140; /* avx512vl_fmsubadd_v4sf_mask3 */

            case E_V8DFmode:
              if (pattern1261 (x2, 
E_V8DFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V8DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 4124; /* avx512f_fmsubadd_v8df_mask */
              if (!nonimmediate_operand (operands[3], E_V8DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4142; /* avx512f_fmsubadd_v8df_mask3 */

            case E_V4DFmode:
              if (pattern1261 (x2, 
E_V4DFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V4DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4126; /* avx512vl_fmsubadd_v4df_mask */
              if (!nonimmediate_operand (operands[3], E_V4DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4144; /* avx512vl_fmsubadd_v4df_mask3 */

            case E_V2DFmode:
              if (pattern1261 (x2, 
E_V2DFmode, 
E_QImode) != 0)
                return -1;
              if (vector_operand (operands[3], E_V2DFmode)
                  && rtx_equal_p (x7, operands[1])
                  && (
#line 6515 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 4128; /* avx512vl_fmsubadd_v2df_mask */
              if (!nonimmediate_operand (operands[3], E_V2DFmode)
                  || !rtx_equal_p (x7, operands[3])
                  || !(
#line 6534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4146; /* avx512vl_fmsubadd_v2df_mask3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_156 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (operands[4]))
    {
    case REG:
    case SUBREG:
    case MEM:
      x2 = XEXP (x1, 1);
      switch (pattern1274 (x2))
        {
        case 0:
          if ((
#line 4121 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 3211; /* *avx_cmpv8sf3_1 */
          break;

        case 1:
          if (
#line 4121 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()))
            return 3212; /* *avx_cmpv4sf3_1 */
          break;

        case 2:
          if ((
#line 4121 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 3213; /* *avx_cmpv4df3_1 */
          break;

        case 3:
          if ((
#line 4121 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return 3214; /* *avx_cmpv2df3_1 */
          break;

        default:
          break;
        }
      break;

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      x2 = XEXP (x1, 1);
      x3 = XEXP (x2, 2);
      x4 = XVECEXP (x3, 0, 2);
      if (x4 == const_int_rtx[MAX_SAVED_CONST_INT + 1])
        {
          switch (GET_MODE (operands[0]))
            {
            case E_V32HImode:
              if (pattern1456 (x2, 
E_V32HImode, 
E_SImode) == 0
                  && (
#line 17143 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return 7561; /* *avx512_ashrv32hi3_1 */
              break;

            case E_V16HImode:
              if (pattern1456 (x2, 
E_V16HImode, 
E_HImode) == 0
                  && (
#line 17143 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 764 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
                return 7562; /* *avx512_ashrv16hi3_1 */
              break;

            case E_V8HImode:
              if (pattern1456 (x2, 
E_V8HImode, 
E_QImode) == 0
                  && (
#line 17143 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 765 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)))
                return 7563; /* *avx512_ashrv8hi3_1 */
              break;

            case E_V16SImode:
              if (pattern1456 (x2, 
E_V16SImode, 
E_HImode) == 0
                  && (
#line 17143 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 766 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 7564; /* *avx512_ashrv16si3_1 */
              break;

            case E_V8SImode:
              if (pattern1456 (x2, 
E_V8SImode, 
E_QImode) == 0
                  && (
#line 17143 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 766 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 7565; /* *avx512_ashrv8si3_1 */
              break;

            case E_V4SImode:
              if (pattern1456 (x2, 
E_V4SImode, 
E_QImode) == 0
                  && (
#line 17143 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 766 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 7566; /* *avx512_ashrv4si3_1 */
              break;

            case E_V8DImode:
              if (pattern1456 (x2, 
E_V8DImode, 
E_QImode) == 0
                  && (
#line 17143 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 767 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 7567; /* *avx512_ashrv8di3_1 */
              break;

            case E_V4DImode:
              if (pattern1456 (x2, 
E_V4DImode, 
E_QImode) == 0
                  && (
#line 17143 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 767 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 7568; /* *avx512_ashrv4di3_1 */
              break;

            case E_V2DImode:
              if (pattern1456 (x2, 
E_V2DImode, 
E_QImode) == 0
                  && (
#line 17143 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 767 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 7569; /* *avx512_ashrv2di3_1 */
              break;

            default:
              break;
            }
        }
      break;

    default:
      break;
    }
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 2);
  x4 = XVECEXP (x3, 0, 2);
  operands[5] = x4;
  switch (pattern1275 (x2))
    {
    case 0:
      if (vector_all_ones_operand (operands[1], E_V16QImode)
          && const0_operand (operands[2], E_V16QImode))
        {
          if (nonimm_or_0_operand (operands[3], E_V16QImode)
              && nonimm_or_0_operand (operands[4], E_V16QImode)
              && 
#line 17942 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* EQ is commutative.  */
   && ((INTVAL (operands[5]) == 0
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* NLE aka GT, 3 must be register.  */
       || (INTVAL (operands[5]) == 6
	   && !MEM_P (operands[3]))
	  /* LT, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 1
	   && !MEM_P (operands[4])))))
            return 7817; /* *avx2_pcmpv16qi3_1 */
          if (nonimmediate_operand (operands[3], E_V16QImode)
              && nonimmediate_operand (operands[4], E_V16QImode)
              && 
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)))
            return 7839; /* *avx2_pcmpv16qi3_6 */
        }
      if (!const0_operand (operands[1], E_V16QImode)
          || !vector_all_ones_operand (operands[2], E_V16QImode)
          || !nonimmediate_operand (operands[3], E_V16QImode)
          || !nonimmediate_operand (operands[4], E_V16QImode)
          || !
#line 18132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && (INTVAL (operands[5]) == 4
	  /* LE, 3 must be register.  */
       || INTVAL (operands[5]) == 2
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || INTVAL (operands[5]) == 5)))
        return -1;
      return 7855; /* *avx2_pcmpv16qi3_7 */

    case 1:
      if (vector_all_ones_operand (operands[1], E_V8HImode)
          && const0_operand (operands[2], E_V8HImode))
        {
          if (nonimm_or_0_operand (operands[3], E_V8HImode)
              && nonimm_or_0_operand (operands[4], E_V8HImode)
              && 
#line 17942 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* EQ is commutative.  */
   && ((INTVAL (operands[5]) == 0
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* NLE aka GT, 3 must be register.  */
       || (INTVAL (operands[5]) == 6
	   && !MEM_P (operands[3]))
	  /* LT, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 1
	   && !MEM_P (operands[4])))))
            return 7818; /* *avx2_pcmpv8hi3_1 */
          if (nonimmediate_operand (operands[3], E_V8HImode)
              && nonimmediate_operand (operands[4], E_V8HImode)
              && 
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)))
            return 7841; /* *avx2_pcmpv8hi3_6 */
        }
      if (!const0_operand (operands[1], E_V8HImode)
          || !vector_all_ones_operand (operands[2], E_V8HImode)
          || !nonimmediate_operand (operands[3], E_V8HImode)
          || !nonimmediate_operand (operands[4], E_V8HImode)
          || !
#line 18132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && (INTVAL (operands[5]) == 4
	  /* LE, 3 must be register.  */
       || INTVAL (operands[5]) == 2
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || INTVAL (operands[5]) == 5)))
        return -1;
      return 7856; /* *avx2_pcmpv8hi3_7 */

    case 2:
      if (vector_all_ones_operand (operands[1], E_V4SImode)
          && const0_operand (operands[2], E_V4SImode))
        {
          if (nonimm_or_0_operand (operands[3], E_V4SImode)
              && nonimm_or_0_operand (operands[4], E_V4SImode)
              && 
#line 17942 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* EQ is commutative.  */
   && ((INTVAL (operands[5]) == 0
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* NLE aka GT, 3 must be register.  */
       || (INTVAL (operands[5]) == 6
	   && !MEM_P (operands[3]))
	  /* LT, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 1
	   && !MEM_P (operands[4])))))
            return 7819; /* *avx2_pcmpv4si3_1 */
          if (nonimmediate_operand (operands[3], E_V4SImode)
              && nonimmediate_operand (operands[4], E_V4SImode)
              && 
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)))
            return 7843; /* *avx2_pcmpv4si3_6 */
        }
      if (!const0_operand (operands[1], E_V4SImode)
          || !vector_all_ones_operand (operands[2], E_V4SImode)
          || !nonimmediate_operand (operands[3], E_V4SImode)
          || !nonimmediate_operand (operands[4], E_V4SImode)
          || !
#line 18132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && (INTVAL (operands[5]) == 4
	  /* LE, 3 must be register.  */
       || INTVAL (operands[5]) == 2
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || INTVAL (operands[5]) == 5)))
        return -1;
      return 7857; /* *avx2_pcmpv4si3_7 */

    case 3:
      if (vector_all_ones_operand (operands[1], E_V2DImode)
          && const0_operand (operands[2], E_V2DImode))
        {
          if (nonimm_or_0_operand (operands[3], E_V2DImode)
              && nonimm_or_0_operand (operands[4], E_V2DImode)
              && 
#line 17942 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* EQ is commutative.  */
   && ((INTVAL (operands[5]) == 0
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* NLE aka GT, 3 must be register.  */
       || (INTVAL (operands[5]) == 6
	   && !MEM_P (operands[3]))
	  /* LT, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 1
	   && !MEM_P (operands[4])))))
            return 7820; /* *avx2_pcmpv2di3_1 */
          if (nonimmediate_operand (operands[3], E_V2DImode)
              && nonimmediate_operand (operands[4], E_V2DImode)
              && 
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)))
            return 7845; /* *avx2_pcmpv2di3_6 */
        }
      if (!const0_operand (operands[1], E_V2DImode)
          || !vector_all_ones_operand (operands[2], E_V2DImode)
          || !nonimmediate_operand (operands[3], E_V2DImode)
          || !nonimmediate_operand (operands[4], E_V2DImode)
          || !
#line 18132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && (INTVAL (operands[5]) == 4
	  /* LE, 3 must be register.  */
       || INTVAL (operands[5]) == 2
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || INTVAL (operands[5]) == 5)))
        return -1;
      return 7858; /* *avx2_pcmpv2di3_7 */

    case 4:
      if (vector_all_ones_operand (operands[1], E_V32QImode)
          && const0_operand (operands[2], E_V32QImode))
        {
          if (nonimm_or_0_operand (operands[3], E_V32QImode)
              && nonimm_or_0_operand (operands[4], E_V32QImode)
              && 
#line 17942 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* EQ is commutative.  */
   && ((INTVAL (operands[5]) == 0
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* NLE aka GT, 3 must be register.  */
       || (INTVAL (operands[5]) == 6
	   && !MEM_P (operands[3]))
	  /* LT, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 1
	   && !MEM_P (operands[4])))))
            return 7821; /* *avx2_pcmpv32qi3_1 */
          if (nonimmediate_operand (operands[3], E_V32QImode)
              && nonimmediate_operand (operands[4], E_V32QImode)
              && 
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)))
            return 7847; /* *avx2_pcmpv32qi3_6 */
        }
      if (!const0_operand (operands[1], E_V32QImode)
          || !vector_all_ones_operand (operands[2], E_V32QImode)
          || !nonimmediate_operand (operands[3], E_V32QImode)
          || !nonimmediate_operand (operands[4], E_V32QImode)
          || !
#line 18132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && (INTVAL (operands[5]) == 4
	  /* LE, 3 must be register.  */
       || INTVAL (operands[5]) == 2
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || INTVAL (operands[5]) == 5)))
        return -1;
      return 7859; /* *avx2_pcmpv32qi3_7 */

    case 5:
      if (vector_all_ones_operand (operands[1], E_V16HImode)
          && const0_operand (operands[2], E_V16HImode))
        {
          if (nonimm_or_0_operand (operands[3], E_V16HImode)
              && nonimm_or_0_operand (operands[4], E_V16HImode)
              && 
#line 17942 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* EQ is commutative.  */
   && ((INTVAL (operands[5]) == 0
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* NLE aka GT, 3 must be register.  */
       || (INTVAL (operands[5]) == 6
	   && !MEM_P (operands[3]))
	  /* LT, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 1
	   && !MEM_P (operands[4])))))
            return 7822; /* *avx2_pcmpv16hi3_1 */
          if (nonimmediate_operand (operands[3], E_V16HImode)
              && nonimmediate_operand (operands[4], E_V16HImode)
              && 
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)))
            return 7849; /* *avx2_pcmpv16hi3_6 */
        }
      if (!const0_operand (operands[1], E_V16HImode)
          || !vector_all_ones_operand (operands[2], E_V16HImode)
          || !nonimmediate_operand (operands[3], E_V16HImode)
          || !nonimmediate_operand (operands[4], E_V16HImode)
          || !
#line 18132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && (INTVAL (operands[5]) == 4
	  /* LE, 3 must be register.  */
       || INTVAL (operands[5]) == 2
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || INTVAL (operands[5]) == 5)))
        return -1;
      return 7860; /* *avx2_pcmpv16hi3_7 */

    case 6:
      if (vector_all_ones_operand (operands[1], E_V8SImode)
          && const0_operand (operands[2], E_V8SImode))
        {
          if (nonimm_or_0_operand (operands[3], E_V8SImode)
              && nonimm_or_0_operand (operands[4], E_V8SImode)
              && 
#line 17942 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* EQ is commutative.  */
   && ((INTVAL (operands[5]) == 0
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* NLE aka GT, 3 must be register.  */
       || (INTVAL (operands[5]) == 6
	   && !MEM_P (operands[3]))
	  /* LT, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 1
	   && !MEM_P (operands[4])))))
            return 7823; /* *avx2_pcmpv8si3_1 */
          if (nonimmediate_operand (operands[3], E_V8SImode)
              && nonimmediate_operand (operands[4], E_V8SImode)
              && 
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)))
            return 7851; /* *avx2_pcmpv8si3_6 */
        }
      if (!const0_operand (operands[1], E_V8SImode)
          || !vector_all_ones_operand (operands[2], E_V8SImode)
          || !nonimmediate_operand (operands[3], E_V8SImode)
          || !nonimmediate_operand (operands[4], E_V8SImode)
          || !
#line 18132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && (INTVAL (operands[5]) == 4
	  /* LE, 3 must be register.  */
       || INTVAL (operands[5]) == 2
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || INTVAL (operands[5]) == 5)))
        return -1;
      return 7861; /* *avx2_pcmpv8si3_7 */

    case 7:
      if (vector_all_ones_operand (operands[1], E_V4DImode)
          && const0_operand (operands[2], E_V4DImode))
        {
          if (nonimm_or_0_operand (operands[3], E_V4DImode)
              && nonimm_or_0_operand (operands[4], E_V4DImode)
              && 
#line 17942 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* EQ is commutative.  */
   && ((INTVAL (operands[5]) == 0
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* NLE aka GT, 3 must be register.  */
       || (INTVAL (operands[5]) == 6
	   && !MEM_P (operands[3]))
	  /* LT, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 1
	   && !MEM_P (operands[4])))))
            return 7824; /* *avx2_pcmpv4di3_1 */
          if (nonimmediate_operand (operands[3], E_V4DImode)
              && nonimmediate_operand (operands[4], E_V4DImode)
              && 
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)))
            return 7853; /* *avx2_pcmpv4di3_6 */
        }
      if (!const0_operand (operands[1], E_V4DImode)
          || !vector_all_ones_operand (operands[2], E_V4DImode)
          || !nonimmediate_operand (operands[3], E_V4DImode)
          || !nonimmediate_operand (operands[4], E_V4DImode)
          || !
#line 18132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && (INTVAL (operands[5]) == 4
	  /* LE, 3 must be register.  */
       || INTVAL (operands[5]) == 2
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || INTVAL (operands[5]) == 5)))
        return -1;
      return 7862; /* *avx2_pcmpv4di3_7 */

    default:
      return -1;
    }
}

 int
recog_164 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47, x48, x49;
  rtx x50, x51, x52, x53, x54, x55, x56, x57;
  rtx x58, x59, x60, x61, x62, x63, x64, x65;
  rtx x66, x67, x68, x69, x70;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (pattern888 (x4) != 0)
    return -1;
  x5 = XVECEXP (x4, 0, 32);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x4, 0, 33);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x4, 0, 34);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  x8 = XVECEXP (x4, 0, 35);
  if (GET_CODE (x8) != CONST_INT)
    return -1;
  x9 = XVECEXP (x4, 0, 36);
  if (GET_CODE (x9) != CONST_INT)
    return -1;
  x10 = XVECEXP (x4, 0, 37);
  if (GET_CODE (x10) != CONST_INT)
    return -1;
  x11 = XVECEXP (x4, 0, 38);
  if (GET_CODE (x11) != CONST_INT)
    return -1;
  x12 = XVECEXP (x4, 0, 39);
  if (GET_CODE (x12) != CONST_INT)
    return -1;
  x13 = XVECEXP (x4, 0, 40);
  if (GET_CODE (x13) != CONST_INT)
    return -1;
  x14 = XVECEXP (x4, 0, 41);
  if (GET_CODE (x14) != CONST_INT)
    return -1;
  x15 = XVECEXP (x4, 0, 42);
  if (GET_CODE (x15) != CONST_INT)
    return -1;
  x16 = XVECEXP (x4, 0, 43);
  if (GET_CODE (x16) != CONST_INT)
    return -1;
  x17 = XVECEXP (x4, 0, 44);
  if (GET_CODE (x17) != CONST_INT)
    return -1;
  x18 = XVECEXP (x4, 0, 45);
  if (GET_CODE (x18) != CONST_INT)
    return -1;
  x19 = XVECEXP (x4, 0, 46);
  if (GET_CODE (x19) != CONST_INT)
    return -1;
  x20 = XVECEXP (x4, 0, 47);
  if (GET_CODE (x20) != CONST_INT)
    return -1;
  x21 = XVECEXP (x4, 0, 48);
  if (GET_CODE (x21) != CONST_INT)
    return -1;
  x22 = XVECEXP (x4, 0, 49);
  if (GET_CODE (x22) != CONST_INT)
    return -1;
  x23 = XVECEXP (x4, 0, 50);
  if (GET_CODE (x23) != CONST_INT)
    return -1;
  x24 = XVECEXP (x4, 0, 51);
  if (GET_CODE (x24) != CONST_INT)
    return -1;
  x25 = XVECEXP (x4, 0, 52);
  if (GET_CODE (x25) != CONST_INT)
    return -1;
  x26 = XVECEXP (x4, 0, 53);
  if (GET_CODE (x26) != CONST_INT)
    return -1;
  x27 = XVECEXP (x4, 0, 54);
  if (GET_CODE (x27) != CONST_INT)
    return -1;
  x28 = XVECEXP (x4, 0, 55);
  if (GET_CODE (x28) != CONST_INT)
    return -1;
  x29 = XVECEXP (x4, 0, 56);
  if (GET_CODE (x29) != CONST_INT)
    return -1;
  x30 = XVECEXP (x4, 0, 57);
  if (GET_CODE (x30) != CONST_INT)
    return -1;
  x31 = XVECEXP (x4, 0, 58);
  if (GET_CODE (x31) != CONST_INT)
    return -1;
  x32 = XVECEXP (x4, 0, 59);
  if (GET_CODE (x32) != CONST_INT)
    return -1;
  x33 = XVECEXP (x4, 0, 60);
  if (GET_CODE (x33) != CONST_INT)
    return -1;
  x34 = XVECEXP (x4, 0, 61);
  if (GET_CODE (x34) != CONST_INT)
    return -1;
  x35 = XVECEXP (x4, 0, 62);
  if (GET_CODE (x35) != CONST_INT)
    return -1;
  x36 = XVECEXP (x4, 0, 63);
  if (GET_CODE (x36) != CONST_INT
      || pattern1202 (x2, 
E_V64QImode, 
E_V128QImode) != 0)
    return -1;
  x37 = XEXP (x2, 1);
  operands[3] = x37;
  if (!nonimm_or_0_operand (operands[3], E_V64QImode))
    return -1;
  x38 = XEXP (x2, 2);
  operands[4] = x38;
  if (!register_operand (operands[4], E_DImode))
    return -1;
  x39 = XVECEXP (x4, 0, 0);
  switch (XWINT (x39, 0))
    {
    case 8L:
      x40 = XVECEXP (x4, 0, 1);
      if (XWINT (x40, 0) != 72L)
        return -1;
      x41 = XVECEXP (x4, 0, 2);
      if (XWINT (x41, 0) != 9L)
        return -1;
      x42 = XVECEXP (x4, 0, 3);
      if (XWINT (x42, 0) != 73L)
        return -1;
      x43 = XVECEXP (x4, 0, 4);
      if (XWINT (x43, 0) != 10L)
        return -1;
      x44 = XVECEXP (x4, 0, 5);
      if (XWINT (x44, 0) != 74L)
        return -1;
      x45 = XVECEXP (x4, 0, 6);
      if (XWINT (x45, 0) != 11L)
        return -1;
      x46 = XVECEXP (x4, 0, 7);
      if (XWINT (x46, 0) != 75L)
        return -1;
      x47 = XVECEXP (x4, 0, 8);
      if (XWINT (x47, 0) != 12L)
        return -1;
      x48 = XVECEXP (x4, 0, 9);
      if (XWINT (x48, 0) != 76L)
        return -1;
      x49 = XVECEXP (x4, 0, 10);
      if (XWINT (x49, 0) != 13L)
        return -1;
      x50 = XVECEXP (x4, 0, 11);
      if (XWINT (x50, 0) != 77L)
        return -1;
      x51 = XVECEXP (x4, 0, 12);
      if (XWINT (x51, 0) != 14L)
        return -1;
      x52 = XVECEXP (x4, 0, 13);
      if (XWINT (x52, 0) != 78L)
        return -1;
      x53 = XVECEXP (x4, 0, 14);
      if (XWINT (x53, 0) != 15L)
        return -1;
      x54 = XVECEXP (x4, 0, 15);
      if (XWINT (x54, 0) != 79L)
        return -1;
      x55 = XVECEXP (x4, 0, 16);
      if (XWINT (x55, 0) != 24L)
        return -1;
      x56 = XVECEXP (x4, 0, 17);
      if (XWINT (x56, 0) != 88L)
        return -1;
      x57 = XVECEXP (x4, 0, 18);
      if (XWINT (x57, 0) != 25L)
        return -1;
      x58 = XVECEXP (x4, 0, 19);
      if (XWINT (x58, 0) != 89L)
        return -1;
      x59 = XVECEXP (x4, 0, 20);
      if (XWINT (x59, 0) != 26L)
        return -1;
      x60 = XVECEXP (x4, 0, 21);
      if (XWINT (x60, 0) != 90L)
        return -1;
      x61 = XVECEXP (x4, 0, 22);
      if (XWINT (x61, 0) != 27L)
        return -1;
      x62 = XVECEXP (x4, 0, 23);
      if (XWINT (x62, 0) != 91L)
        return -1;
      x63 = XVECEXP (x4, 0, 24);
      if (XWINT (x63, 0) != 28L)
        return -1;
      x64 = XVECEXP (x4, 0, 25);
      if (XWINT (x64, 0) != 92L)
        return -1;
      x65 = XVECEXP (x4, 0, 26);
      if (XWINT (x65, 0) != 29L)
        return -1;
      x66 = XVECEXP (x4, 0, 27);
      if (XWINT (x66, 0) != 93L)
        return -1;
      x67 = XVECEXP (x4, 0, 28);
      if (XWINT (x67, 0) != 30L)
        return -1;
      x68 = XVECEXP (x4, 0, 29);
      if (XWINT (x68, 0) != 94L)
        return -1;
      x69 = XVECEXP (x4, 0, 30);
      if (XWINT (x69, 0) != 31L)
        return -1;
      x70 = XVECEXP (x4, 0, 31);
      if (XWINT (x70, 0) != 95L
          || XWINT (x5, 0) != 40L
          || XWINT (x6, 0) != 104L
          || XWINT (x7, 0) != 41L
          || XWINT (x8, 0) != 105L
          || XWINT (x9, 0) != 42L
          || XWINT (x10, 0) != 106L
          || XWINT (x11, 0) != 43L
          || XWINT (x12, 0) != 107L
          || XWINT (x13, 0) != 44L
          || XWINT (x14, 0) != 108L
          || XWINT (x15, 0) != 45L
          || XWINT (x16, 0) != 109L
          || XWINT (x17, 0) != 46L
          || XWINT (x18, 0) != 110L
          || XWINT (x19, 0) != 47L
          || XWINT (x20, 0) != 111L
          || XWINT (x21, 0) != 56L
          || XWINT (x22, 0) != 120L
          || XWINT (x23, 0) != 57L
          || XWINT (x24, 0) != 121L
          || XWINT (x25, 0) != 58L
          || XWINT (x26, 0) != 122L
          || XWINT (x27, 0) != 59L
          || XWINT (x28, 0) != 123L
          || XWINT (x29, 0) != 60L
          || XWINT (x30, 0) != 124L
          || XWINT (x31, 0) != 61L
          || XWINT (x32, 0) != 125L
          || XWINT (x33, 0) != 62L
          || XWINT (x34, 0) != 126L
          || XWINT (x35, 0) != 63L
          || XWINT (x36, 0) != 127L
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19410 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
        return -1;
      return 8247; /* avx512bw_interleave_highv64qi_mask */

    case 0L:
      x40 = XVECEXP (x4, 0, 1);
      if (XWINT (x40, 0) != 64L)
        return -1;
      x41 = XVECEXP (x4, 0, 2);
      if (XWINT (x41, 0) != 1L)
        return -1;
      x42 = XVECEXP (x4, 0, 3);
      if (XWINT (x42, 0) != 65L)
        return -1;
      x43 = XVECEXP (x4, 0, 4);
      if (XWINT (x43, 0) != 2L)
        return -1;
      x44 = XVECEXP (x4, 0, 5);
      if (XWINT (x44, 0) != 66L)
        return -1;
      x45 = XVECEXP (x4, 0, 6);
      if (XWINT (x45, 0) != 3L)
        return -1;
      x46 = XVECEXP (x4, 0, 7);
      if (XWINT (x46, 0) != 67L)
        return -1;
      x47 = XVECEXP (x4, 0, 8);
      if (XWINT (x47, 0) != 4L)
        return -1;
      x48 = XVECEXP (x4, 0, 9);
      if (XWINT (x48, 0) != 68L)
        return -1;
      x49 = XVECEXP (x4, 0, 10);
      if (XWINT (x49, 0) != 5L)
        return -1;
      x50 = XVECEXP (x4, 0, 11);
      if (XWINT (x50, 0) != 69L)
        return -1;
      x51 = XVECEXP (x4, 0, 12);
      if (XWINT (x51, 0) != 6L)
        return -1;
      x52 = XVECEXP (x4, 0, 13);
      if (XWINT (x52, 0) != 70L)
        return -1;
      x53 = XVECEXP (x4, 0, 14);
      if (XWINT (x53, 0) != 7L)
        return -1;
      x54 = XVECEXP (x4, 0, 15);
      if (XWINT (x54, 0) != 71L)
        return -1;
      x55 = XVECEXP (x4, 0, 16);
      if (XWINT (x55, 0) != 16L)
        return -1;
      x56 = XVECEXP (x4, 0, 17);
      if (XWINT (x56, 0) != 80L)
        return -1;
      x57 = XVECEXP (x4, 0, 18);
      if (XWINT (x57, 0) != 17L)
        return -1;
      x58 = XVECEXP (x4, 0, 19);
      if (XWINT (x58, 0) != 81L)
        return -1;
      x59 = XVECEXP (x4, 0, 20);
      if (XWINT (x59, 0) != 18L)
        return -1;
      x60 = XVECEXP (x4, 0, 21);
      if (XWINT (x60, 0) != 82L)
        return -1;
      x61 = XVECEXP (x4, 0, 22);
      if (XWINT (x61, 0) != 19L)
        return -1;
      x62 = XVECEXP (x4, 0, 23);
      if (XWINT (x62, 0) != 83L)
        return -1;
      x63 = XVECEXP (x4, 0, 24);
      if (XWINT (x63, 0) != 20L)
        return -1;
      x64 = XVECEXP (x4, 0, 25);
      if (XWINT (x64, 0) != 84L)
        return -1;
      x65 = XVECEXP (x4, 0, 26);
      if (XWINT (x65, 0) != 21L)
        return -1;
      x66 = XVECEXP (x4, 0, 27);
      if (XWINT (x66, 0) != 85L)
        return -1;
      x67 = XVECEXP (x4, 0, 28);
      if (XWINT (x67, 0) != 22L)
        return -1;
      x68 = XVECEXP (x4, 0, 29);
      if (XWINT (x68, 0) != 86L)
        return -1;
      x69 = XVECEXP (x4, 0, 30);
      if (XWINT (x69, 0) != 23L)
        return -1;
      x70 = XVECEXP (x4, 0, 31);
      if (XWINT (x70, 0) != 87L
          || XWINT (x5, 0) != 32L
          || XWINT (x6, 0) != 96L
          || XWINT (x7, 0) != 33L
          || XWINT (x8, 0) != 97L
          || XWINT (x9, 0) != 34L
          || XWINT (x10, 0) != 98L
          || XWINT (x11, 0) != 35L
          || XWINT (x12, 0) != 99L
          || XWINT (x13, 0) != 36L
          || XWINT (x14, 0) != 100L
          || XWINT (x15, 0) != 37L
          || XWINT (x16, 0) != 101L
          || XWINT (x17, 0) != 38L
          || XWINT (x18, 0) != 102L
          || XWINT (x19, 0) != 39L
          || XWINT (x20, 0) != 103L
          || XWINT (x21, 0) != 48L
          || XWINT (x22, 0) != 112L
          || XWINT (x23, 0) != 49L
          || XWINT (x24, 0) != 113L
          || XWINT (x25, 0) != 50L
          || XWINT (x26, 0) != 114L
          || XWINT (x27, 0) != 51L
          || XWINT (x28, 0) != 115L
          || XWINT (x29, 0) != 52L
          || XWINT (x30, 0) != 116L
          || XWINT (x31, 0) != 53L
          || XWINT (x32, 0) != 117L
          || XWINT (x33, 0) != 54L
          || XWINT (x34, 0) != 118L
          || XWINT (x35, 0) != 55L
          || XWINT (x36, 0) != 119L
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
        return -1;
      return 8253; /* avx512bw_interleave_lowv64qi_mask */

    default:
      return -1;
    }
}

 int
recog_183 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (XVECLEN (x3, 0))
    {
    case 1:
      return recog_144 (x1, insn, pnum_clobbers);

    case 2:
      return recog_143 (x1, insn, pnum_clobbers);

    case 3:
      return recog_142 (x1, insn, pnum_clobbers);

    case 4:
      x4 = XVECEXP (x3, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x3, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x3, 0, 2);
      operands[3] = x6;
      x7 = XVECEXP (x3, 0, 3);
      operands[4] = x7;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      switch (XINT (x3, 1))
        {
        case 164:
          x8 = XEXP (x2, 1);
          switch (GET_CODE (x8))
            {
            case CONST_INT:
            case CONST_DOUBLE:
            case CONST_VECTOR:
              operands[5] = x8;
              x9 = XEXP (x2, 2);
              operands[6] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_V16SImode:
                  if (pattern1441 (x2, 
E_V16SImode, 
E_HImode) != 0
                      || !(
#line 13637 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 5369; /* avx512f_vternlogv16si_maskz_1 */

                case E_V8SImode:
                  if (pattern1441 (x2, 
E_V8SImode, 
E_QImode) != 0
                      || !(
#line 13637 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 5371; /* avx512vl_vternlogv8si_maskz_1 */

                case E_V4SImode:
                  if (pattern1441 (x2, 
E_V4SImode, 
E_QImode) != 0
                      || !(
#line 13637 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 5373; /* avx512vl_vternlogv4si_maskz_1 */

                case E_V8DImode:
                  if (pattern1441 (x2, 
E_V8DImode, 
E_QImode) != 0
                      || !(
#line 13637 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 5375; /* avx512f_vternlogv8di_maskz_1 */

                case E_V4DImode:
                  if (pattern1441 (x2, 
E_V4DImode, 
E_QImode) != 0
                      || !(
#line 13637 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 5377; /* avx512vl_vternlogv4di_maskz_1 */

                case E_V2DImode:
                  if (pattern1441 (x2, 
E_V2DImode, 
E_QImode) != 0
                      || !(
#line 13637 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 5379; /* avx512vl_vternlogv2di_maskz_1 */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
              if (!rtx_equal_p (x8, operands[1]))
                return -1;
              x9 = XEXP (x2, 2);
              operands[5] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_V16SImode:
                  if (pattern1442 (x2, 
E_V16SImode, 
E_HImode) != 0
                      || !(
#line 14007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 6940; /* *avx512f_vternlogv16si_mask */

                case E_V8SImode:
                  if (pattern1442 (x2, 
E_V8SImode, 
E_QImode) != 0
                      || !(
#line 14007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 6941; /* *avx512vl_vternlogv8si_mask */

                case E_V4SImode:
                  if (pattern1442 (x2, 
E_V4SImode, 
E_QImode) != 0
                      || !(
#line 14007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 6942; /* *avx512vl_vternlogv4si_mask */

                case E_V8DImode:
                  if (pattern1442 (x2, 
E_V8DImode, 
E_QImode) != 0
                      || !(
#line 14007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 6943; /* *avx512f_vternlogv8di_mask */

                case E_V4DImode:
                  if (pattern1442 (x2, 
E_V4DImode, 
E_QImode) != 0
                      || !(
#line 14007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 6944; /* *avx512vl_vternlogv4di_mask */

                case E_V2DImode:
                  if (pattern1442 (x2, 
E_V2DImode, 
E_QImode) != 0
                      || !(
#line 14007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 6945; /* *avx512vl_vternlogv2di_mask */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 163:
          x8 = XEXP (x2, 1);
          switch (GET_CODE (x8))
            {
            case CONST_INT:
            case CONST_DOUBLE:
            case CONST_VECTOR:
              operands[5] = x8;
              x9 = XEXP (x2, 2);
              operands[6] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_V16SFmode:
                  if (pattern1443 (x2, 
E_V16SFmode, 
E_V16SImode, 
E_HImode) != 0
                      || !(
#line 14132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 7016; /* avx512f_fixupimmv16sf_maskz_1 */

                case E_V8SFmode:
                  if (pattern1443 (x2, 
E_V8SFmode, 
E_V8SImode, 
E_QImode) != 0
                      || !(
#line 14132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 7020; /* avx512vl_fixupimmv8sf_maskz_1 */

                case E_V4SFmode:
                  if (pattern1443 (x2, 
E_V4SFmode, 
E_V4SImode, 
E_QImode) != 0
                      || !(
#line 14132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 7024; /* avx512vl_fixupimmv4sf_maskz_1 */

                case E_V8DFmode:
                  if (pattern1443 (x2, 
E_V8DFmode, 
E_V8DImode, 
E_QImode) != 0
                      || !(
#line 14132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 7028; /* avx512f_fixupimmv8df_maskz_1 */

                case E_V4DFmode:
                  if (pattern1443 (x2, 
E_V4DFmode, 
E_V4DImode, 
E_QImode) != 0
                      || !(
#line 14132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 7032; /* avx512vl_fixupimmv4df_maskz_1 */

                case E_V2DFmode:
                  if (pattern1443 (x2, 
E_V2DFmode, 
E_V2DImode, 
E_QImode) != 0
                      || !(
#line 14132 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 7036; /* avx512vl_fixupimmv2df_maskz_1 */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
              x9 = XEXP (x2, 2);
              switch (GET_CODE (x9))
                {
                case REG:
                case SUBREG:
                  operands[5] = x9;
                  if (!rtx_equal_p (x8, operands[1]))
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V16SFmode:
                      if (pattern1498 (x2, 
E_V16SImode, 
E_V16SFmode, 
E_HImode) != 0
                          || !(
#line 14148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return -1;
                      return 7038; /* avx512f_fixupimmv16sf_mask */

                    case E_V8SFmode:
                      if (pattern1498 (x2, 
E_V8SImode, 
E_V8SFmode, 
E_QImode) != 0
                          || !(
#line 14148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return -1;
                      return 7040; /* avx512vl_fixupimmv8sf_mask */

                    case E_V4SFmode:
                      if (pattern1498 (x2, 
E_V4SImode, 
E_V4SFmode, 
E_QImode) != 0
                          || !(
#line 14148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return -1;
                      return 7042; /* avx512vl_fixupimmv4sf_mask */

                    case E_V8DFmode:
                      if (pattern1498 (x2, 
E_V8DImode, 
E_V8DFmode, 
E_QImode) != 0
                          || !(
#line 14148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return -1;
                      return 7044; /* avx512f_fixupimmv8df_mask */

                    case E_V4DFmode:
                      if (pattern1498 (x2, 
E_V4DImode, 
E_V4DFmode, 
E_QImode) != 0
                          || !(
#line 14148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return -1;
                      return 7046; /* avx512vl_fixupimmv4df_mask */

                    case E_V2DFmode:
                      if (pattern1498 (x2, 
E_V2DImode, 
E_V2DFmode, 
E_QImode) != 0
                          || !(
#line 14148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return -1;
                      return 7048; /* avx512vl_fixupimmv2df_mask */

                    default:
                      return -1;
                    }

                case CONST_INT:
                  if (XWINT (x9, 0) != 1L
                      || !rtx_equal_p (x8, operands[2]))
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V4SFmode:
                      if (pattern1499 (x2, 
E_V4SImode, 
E_V4SFmode) != 0
                          || !
#line 14180 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                        return -1;
                      return 7050; /* avx512f_sfixupimmv4sf */

                    case E_V2DFmode:
                      if (pattern1499 (x2, 
E_V2DImode, 
E_V2DFmode) != 0
                          || !(
#line 14180 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                        return -1;
                      return 7054; /* avx512f_sfixupimmv2df */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_187 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern142 (x2))
    {
    case 0:
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7571; /* ashlv16hi3_mask */
      if (!register_operand (operands[1], E_V16HImode)
          || !nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9526; /* avx512vl_ashlvv16hi_mask */

    case 1:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7575; /* ashlv8hi3_mask */
      if (!register_operand (operands[1], E_V8HImode)
          || !nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9522; /* avx512vl_ashlvv8hi_mask */

    case 2:
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7579; /* ashlv8si3_mask */
      if (!register_operand (operands[1], E_V8SImode)
          || !nonimmediate_operand (operands[2], E_V8SImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9502; /* avx2_ashlvv8si_mask */

    case 3:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7583; /* ashlv4si3_mask */
      if (!register_operand (operands[1], E_V4SImode)
          || !nonimmediate_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9506; /* avx2_ashlvv4si_mask */

    case 4:
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7587; /* ashlv4di3_mask */
      if (!register_operand (operands[1], E_V4DImode)
          || !nonimmediate_operand (operands[2], E_V4DImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9514; /* avx2_ashlvv4di_mask */

    case 5:
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7591; /* ashlv2di3_mask */
      if (!register_operand (operands[1], E_V2DImode)
          || !nonimmediate_operand (operands[2], E_V2DImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9518; /* avx2_ashlvv2di_mask */

    case 6:
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
        return 7611; /* ashlv32hi3_mask */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9530; /* avx512bw_ashlvv32hi_mask */

    case 7:
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7615; /* ashlv16si3_mask */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 803 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9498; /* avx512f_ashlvv16si_mask */

    case 8:
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 785 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7619; /* ashlv8di3_mask */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9510; /* avx512f_ashlvv8di_mask */

    default:
      return -1;
    }
}

 int
recog_194 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  operands[3] = x6;
  x7 = XEXP (x2, 2);
  operands[4] = x7;
  switch (GET_CODE (operands[2]))
    {
    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern127 (x2, 
E_V8SFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL
   && (!true || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 428 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 3690; /* *xorv8sf3_mask */

        case E_V4SFmode:
          if (pattern127 (x2, 
E_V4SFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL
   && (!true || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
            return -1;
          return 3696; /* *xorv4sf3_mask */

        case E_V4DFmode:
          if (pattern127 (x2, 
E_V4DFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL
   && (!true || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 3702; /* *xorv4df3_mask */

        case E_V2DFmode:
          if (pattern127 (x2, 
E_V2DFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL
   && (!true || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 3708; /* *xorv2df3_mask */

        case E_V16SFmode:
          if (pattern128 (x2, 
E_V16SFmode, 
E_HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!true || 32 != 16)) && 
#line 493 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 3720; /* *xorv16sf3_mask */

        case E_V8DFmode:
          if (pattern128 (x2, 
E_V8DFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!true || 64 != 16)) && 
#line 494 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 3726; /* *xorv8df3_mask */

        case E_V16SImode:
          if (pattern487 (x2, 
E_V16SImode, 
E_HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (XOR, V16SImode, operands)) && 
#line 807 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 7936; /* *xorv16si3_mask */

        case E_V8SImode:
          if (pattern487 (x2, 
E_V8SImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (XOR, V8SImode, operands)) && 
#line 807 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 7942; /* *xorv8si3_mask */

        case E_V4SImode:
          if (pattern487 (x2, 
E_V4SImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (XOR, V4SImode, operands))))
            return -1;
          return 7948; /* *xorv4si3_mask */

        case E_V8DImode:
          if (pattern487 (x2, 
E_V8DImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (XOR, V8DImode, operands)) && 
#line 808 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 7954; /* *xorv8di3_mask */

        case E_V4DImode:
          if (pattern487 (x2, 
E_V4DImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (XOR, V4DImode, operands)) && 
#line 808 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 7960; /* *xorv4di3_mask */

        case E_V2DImode:
          if (pattern487 (x2, 
E_V2DImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (XOR, V2DImode, operands))))
            return -1;
          return 7966; /* *xorv2di3_mask */

        default:
          return -1;
        }

    case CONST_VECTOR:
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern1004 (x2, 
E_V16SImode, 
E_HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18344 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!true
       || SImode == SImode
       || SImode == DImode)) && 
#line 568 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 7884; /* one_cmplv16si2_mask */

        case E_V8DImode:
          if (pattern1004 (x2, 
E_V8DImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18344 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (64 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!true
       || DImode == SImode
       || DImode == DImode)) && 
#line 569 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 7886; /* one_cmplv8di2_mask */

        case E_V8SImode:
          if (pattern1004 (x2, 
E_V8SImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18344 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!true
       || SImode == SImode
       || SImode == DImode)) && 
#line 572 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 7894; /* one_cmplv8si2_mask */

        case E_V4SImode:
          if (pattern1004 (x2, 
E_V4SImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 18344 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!true
       || SImode == SImode
       || SImode == DImode))))
            return -1;
          return 7896; /* one_cmplv4si2_mask */

        case E_V4DImode:
          if (pattern1004 (x2, 
E_V4DImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18344 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (32 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!true
       || DImode == SImode
       || DImode == DImode)) && 
#line 573 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 7898; /* one_cmplv4di2_mask */

        case E_V2DImode:
          if (pattern1004 (x2, 
E_V2DImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 18344 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (16 == 64 || TARGET_AVX512VL || TARGET_EVEX512)
   && (!true
       || DImode == SImode
       || DImode == DImode))))
            return -1;
          return 7900; /* one_cmplv2di2_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_204 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  operands[3] = x6;
  x7 = XEXP (x2, 2);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V8SFmode:
      if (pattern127 (x2, 
E_V8SFmode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL
   && (!true || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 428 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 3688; /* *iorv8sf3_mask */

    case E_V4SFmode:
      if (pattern127 (x2, 
E_V4SFmode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL
   && (!true || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
        return -1;
      return 3694; /* *iorv4sf3_mask */

    case E_V4DFmode:
      if (pattern127 (x2, 
E_V4DFmode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL
   && (!true || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 3700; /* *iorv4df3_mask */

    case E_V2DFmode:
      if (pattern127 (x2, 
E_V2DFmode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL
   && (!true || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
        return -1;
      return 3706; /* *iorv2df3_mask */

    case E_V16SFmode:
      if (pattern128 (x2, 
E_V16SFmode, 
E_HImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!true || 32 != 16)) && 
#line 493 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 3718; /* *iorv16sf3_mask */

    case E_V8DFmode:
      if (pattern128 (x2, 
E_V8DFmode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!true || 64 != 16)) && 
#line 494 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 3724; /* *iorv8df3_mask */

    case E_V16SImode:
      if (pattern487 (x2, 
E_V16SImode, 
E_HImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (IOR, V16SImode, operands)) && 
#line 807 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 7934; /* *iorv16si3_mask */

    case E_V8SImode:
      if (pattern487 (x2, 
E_V8SImode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (IOR, V8SImode, operands)) && 
#line 807 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 7940; /* *iorv8si3_mask */

    case E_V4SImode:
      if (pattern487 (x2, 
E_V4SImode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (IOR, V4SImode, operands))))
        return -1;
      return 7946; /* *iorv4si3_mask */

    case E_V8DImode:
      if (pattern487 (x2, 
E_V8DImode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (64 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (IOR, V8DImode, operands)) && 
#line 808 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 7952; /* *iorv8di3_mask */

    case E_V4DImode:
      if (pattern487 (x2, 
E_V4DImode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (32 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (IOR, V4DImode, operands)) && 
#line 808 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 7958; /* *iorv4di3_mask */

    case E_V2DImode:
      if (pattern487 (x2, 
E_V2DImode, 
E_QImode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && (16 == 64 || TARGET_AVX512VL)
   && ix86_binary_operator_ok (IOR, V2DImode, operands))))
        return -1;
      return 7964; /* *iorv2di3_mask */

    default:
      return -1;
    }
}

 int
recog_214 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x2) != E_V16SImode
          || !nonimmediate_operand (operands[1], E_V16SImode)
          || !(
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9998; /* *conflictv16si */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x2) != E_V8SImode
          || !nonimmediate_operand (operands[1], E_V8SImode)
          || !(
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10000; /* *conflictv8si */

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x2) != E_V4SImode
          || !nonimmediate_operand (operands[1], E_V4SImode)
          || !(
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10002; /* *conflictv4si */

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x2) != E_V8DImode
          || !nonimmediate_operand (operands[1], E_V8DImode)
          || !(
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10004; /* *conflictv8di */

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x2) != E_V4DImode
          || !nonimmediate_operand (operands[1], E_V4DImode)
          || !(
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10006; /* *conflictv4di */

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x2) != E_V2DImode
          || !nonimmediate_operand (operands[1], E_V2DImode)
          || !(
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10008; /* *conflictv2di */

    default:
      return -1;
    }
}

 int
recog_218 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 0);
  switch (XINT (x4, 1))
    {
    case 63:
      switch (pattern901 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (64 == 64 || TARGET_AVX512VL)
   && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 3046; /* ieee_maxv32hf3_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (64 == 64 || TARGET_AVX512VL)
   && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 3062; /* ieee_maxv16sf3_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (64 == 64 || TARGET_AVX512VL)
   && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 3078; /* ieee_maxv8df3_mask_round */

        case 3:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 3123; /* avx512fp16_ieee_vmmaxv8hf3_round */

        case 4:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 3131; /* sse_ieee_vmmaxv4sf3_round */

        case 5:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 3139; /* sse2_ieee_vmmaxv2df3_round */

        default:
          return -1;
        }

    case 62:
      switch (pattern901 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (64 == 64 || TARGET_AVX512VL)
   && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 3050; /* ieee_minv32hf3_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (64 == 64 || TARGET_AVX512VL)
   && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 3066; /* ieee_minv16sf3_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3397 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (64 == 64 || TARGET_AVX512VL)
   && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))))
            return -1;
          return 3082; /* ieee_minv8df3_mask_round */

        case 3:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 3127; /* avx512fp16_ieee_vmminv8hf3_round */

        case 4:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
            return -1;
          return 3135; /* sse_ieee_vmminv4sf3_round */

        case 5:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 3143; /* sse2_ieee_vmminv2df3_round */

        default:
          return -1;
        }

    case 192:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      if (!const_0_to_255_operand (operands[2], E_SImode))
        return -1;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      x8 = XEXP (x3, 2);
      operands[4] = x8;
      x9 = XVECEXP (x2, 0, 1);
      operands[5] = x9;
      if (!const48_operand (operands[5], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern1532 (x2, 
E_V32HFmode, 
E_SImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V32HFmode))) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 3162; /* reducepv32hf_mask_round */

        case E_V16HFmode:
          if (pattern1532 (x2, 
E_V16HFmode, 
E_HImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V16HFmode))) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 3166; /* reducepv16hf_mask_round */

        case E_V8HFmode:
          if (pattern1532 (x2, 
E_V8HFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 3170; /* reducepv8hf_mask_round */

        case E_V16SFmode:
          if (pattern1532 (x2, 
E_V16SFmode, 
E_HImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V16SFmode))) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 3174; /* reducepv16sf_mask_round */

        case E_V8SFmode:
          if (pattern1532 (x2, 
E_V8SFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8SFmode))) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 3178; /* reducepv8sf_mask_round */

        case E_V4SFmode:
          if (pattern1532 (x2, 
E_V4SFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode))) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 3182; /* reducepv4sf_mask_round */

        case E_V8DFmode:
          if (pattern1532 (x2, 
E_V8DFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8DFmode))) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 3186; /* reducepv8df_mask_round */

        case E_V4DFmode:
          if (pattern1532 (x2, 
E_V4DFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4DFmode))) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 3190; /* reducepv4df_mask_round */

        case E_V2DFmode:
          if (pattern1532 (x2, 
E_V2DFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4028 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 3194; /* reducepv2df_mask_round */

        default:
          return -1;
        }

    case 221:
      switch (pattern902 (x2))
        {
        case 0:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 106 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7322 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4303; /* avx512bw_fmulc_v32hf_mask_round */

        case 1:
          if (!(
#line 437 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4329; /* avx512fp16_fmulcsh_v8hf_round */

        default:
          return -1;
        }

    case 222:
      switch (pattern902 (x2))
        {
        case 0:
          if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 106 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7322 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4307; /* avx512bw_fcmulc_v32hf_mask_round */

        case 1:
          if (!(
#line 437 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4333; /* avx512fp16_fcmulcsh_v8hf_round */

        default:
          return -1;
        }

    case 58:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      x9 = XVECEXP (x2, 0, 1);
      if (!const_4_or_8_to_11_operand (x9, E_SImode))
        return -1;
      x8 = XEXP (x3, 2);
      switch (GET_CODE (x8))
        {
        case CONST_INT:
          if (XWINT (x8, 0) != 1L)
            return -1;
          operands[3] = x9;
          switch (pattern1393 (x2))
            {
            case 0:
              if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 5321; /* avx512f_vmscalefv8hf_round */

            case 1:
              if (!
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 5325; /* avx512f_vmscalefv4sf_round */

            case 2:
              if (!(
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 5329; /* avx512f_vmscalefv2df_round */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          operands[4] = x8;
          x7 = XEXP (x3, 1);
          operands[3] = x7;
          operands[5] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1533 (x2, 
E_V32HFmode, 
E_SImode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
                return -1;
              return 5335; /* avx512bw_scalefv32hf_mask_round */

            case E_V16HFmode:
              if (pattern1533 (x2, 
E_V16HFmode, 
E_HImode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
                return -1;
              return 5339; /* avx512vl_scalefv16hf_mask_round */

            case E_V8HFmode:
              if (pattern1533 (x2, 
E_V8HFmode, 
E_QImode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
                return -1;
              return 5343; /* avx512fp16_scalefv8hf_mask_round */

            case E_V16SFmode:
              if (pattern1533 (x2, 
E_V16SFmode, 
E_HImode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 5347; /* avx512f_scalefv16sf_mask_round */

            case E_V8SFmode:
              if (pattern1533 (x2, 
E_V8SFmode, 
E_QImode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 5351; /* avx512vl_scalefv8sf_mask_round */

            case E_V4SFmode:
              if (pattern1533 (x2, 
E_V4SFmode, 
E_QImode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 5355; /* avx512vl_scalefv4sf_mask_round */

            case E_V8DFmode:
              if (pattern1533 (x2, 
E_V8DFmode, 
E_QImode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 5359; /* avx512f_scalefv8df_mask_round */

            case E_V4DFmode:
              if (pattern1533 (x2, 
E_V4DFmode, 
E_QImode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 5363; /* avx512vl_scalefv4df_mask_round */

            case E_V2DFmode:
              if (pattern1533 (x2, 
E_V2DFmode, 
E_QImode) != 0
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 5367; /* avx512vl_scalefv2df_mask_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 165:
      x8 = XEXP (x3, 2);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      x9 = XVECEXP (x2, 0, 1);
      operands[3] = x9;
      if (!const48_operand (operands[3], E_SImode))
        return -1;
      switch (pattern1393 (x2))
        {
        case 0:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
            return -1;
          return 6984; /* avx512f_sgetexpv8hf_round */

        case 1:
          if (!
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
            return -1;
          return 6988; /* avx512f_sgetexpv4sf_round */

        case 2:
          if (!(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 6992; /* avx512f_sgetexpv2df_round */

        default:
          return -1;
        }

    case 94:
      x6 = XVECEXP (x4, 0, 1);
      if (!const_0_to_255_operand (x6, E_SImode))
        return -1;
      x9 = XVECEXP (x2, 0, 1);
      if (!const48_operand (x9, E_SImode))
        return -1;
      x8 = XEXP (x3, 2);
      switch (GET_CODE (x8))
        {
        case REG:
        case SUBREG:
          operands[4] = x8;
          x5 = XVECEXP (x4, 0, 0);
          operands[1] = x5;
          operands[2] = x6;
          x7 = XEXP (x3, 1);
          operands[3] = x7;
          operands[5] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern1534 (x2, 
E_V32HFmode, 
E_SImode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
                return -1;
              return 7065; /* avx512bw_rndscalev32hf_mask_round */

            case E_V16HFmode:
              if (pattern1534 (x2, 
E_V16HFmode, 
E_HImode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
                return -1;
              return 7069; /* avx512vl_rndscalev16hf_mask_round */

            case E_V8HFmode:
              if (pattern1534 (x2, 
E_V8HFmode, 
E_QImode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
                return -1;
              return 7073; /* avx512fp16_rndscalev8hf_mask_round */

            case E_V16SFmode:
              if (pattern1534 (x2, 
E_V16SFmode, 
E_HImode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 7077; /* avx512f_rndscalev16sf_mask_round */

            case E_V8SFmode:
              if (pattern1534 (x2, 
E_V8SFmode, 
E_QImode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 7081; /* avx512vl_rndscalev8sf_mask_round */

            case E_V4SFmode:
              if (pattern1534 (x2, 
E_V4SFmode, 
E_QImode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 7085; /* avx512vl_rndscalev4sf_mask_round */

            case E_V8DFmode:
              if (pattern1534 (x2, 
E_V8DFmode, 
E_QImode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 7089; /* avx512f_rndscalev8df_mask_round */

            case E_V4DFmode:
              if (pattern1534 (x2, 
E_V4DFmode, 
E_QImode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 7093; /* avx512vl_rndscalev4df_mask_round */

            case E_V2DFmode:
              if (pattern1534 (x2, 
E_V2DFmode, 
E_QImode) != 0
                  || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 7097; /* avx512vl_rndscalev2df_mask_round */

            default:
              return -1;
            }

        case CONST_INT:
          if (XWINT (x8, 0) != 1L)
            return -1;
          x5 = XVECEXP (x4, 0, 0);
          operands[2] = x5;
          operands[3] = x6;
          x7 = XEXP (x3, 1);
          operands[1] = x7;
          operands[4] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern1567 (x2, 
E_V8HFmode) != 0
                  || !(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 7100; /* avx512f_rndscalev8hf_round */

            case E_V4SFmode:
              if (pattern1567 (x2, 
E_V4SFmode) != 0
                  || !
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 7104; /* avx512f_rndscalev4sf_round */

            case E_V2DFmode:
              if (pattern1567 (x2, 
E_V2DFmode) != 0
                  || !(
#line 463 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 7108; /* avx512f_rndscalev2df_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 150:
      if (GET_MODE (x4) != E_V16HImode
          || !register_operand (operands[0], E_V16HImode)
          || GET_MODE (x2) != E_V16HImode
          || GET_MODE (x3) != E_V16HImode)
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      if (!register_operand (operands[1], E_V16SFmode))
        return -1;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      if (!const_0_to_255_operand (operands[2], E_SImode))
        return -1;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      if (!nonimm_or_0_operand (operands[3], E_V16HImode))
        return -1;
      x8 = XEXP (x3, 2);
      operands[4] = x8;
      if (!register_operand (operands[4], E_HImode))
        return -1;
      x9 = XVECEXP (x2, 0, 1);
      operands[5] = x9;
      if (!const48_operand (operands[5], E_SImode)
          || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29221 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9593; /* avx512f_vcvtps2ph512_mask_round */

    case 166:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      if (!const_0_to_15_operand (operands[2], E_SImode))
        return -1;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      x8 = XEXP (x3, 2);
      operands[4] = x8;
      x9 = XVECEXP (x2, 0, 1);
      operands[5] = x9;
      if (!const48_operand (operands[5], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern1534 (x2, 
E_V32HFmode, 
E_SImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 9935; /* avx512bw_getmantv32hf_mask_round */

        case E_V16HFmode:
          if (pattern1534 (x2, 
E_V16HFmode, 
E_HImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 9939; /* avx512vl_getmantv16hf_mask_round */

        case E_V8HFmode:
          if (pattern1534 (x2, 
E_V8HFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 9943; /* avx512fp16_getmantv8hf_mask_round */

        case E_V16SFmode:
          if (pattern1534 (x2, 
E_V16SFmode, 
E_HImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 9947; /* avx512f_getmantv16sf_mask_round */

        case E_V8SFmode:
          if (pattern1534 (x2, 
E_V8SFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 9951; /* avx512vl_getmantv8sf_mask_round */

        case E_V4SFmode:
          if (pattern1534 (x2, 
E_V4SFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 9955; /* avx512vl_getmantv4sf_mask_round */

        case E_V8DFmode:
          if (pattern1534 (x2, 
E_V8DFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 9959; /* avx512f_getmantv8df_mask_round */

        case E_V4DFmode:
          if (pattern1534 (x2, 
E_V4DFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 9963; /* avx512vl_getmantv4df_mask_round */

        case E_V2DFmode:
          if (pattern1534 (x2, 
E_V2DFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 9967; /* avx512vl_getmantv2df_mask_round */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_234 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!const_0_to_15_operand (operands[2], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || GET_MODE (x3) != E_V32HFmode
          || !nonimmediate_operand (operands[1], E_V32HFmode)
          || !(
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 9932; /* avx512bw_getmantv32hf */

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || GET_MODE (x3) != E_V16HFmode
          || !nonimmediate_operand (operands[1], E_V16HFmode)
          || !(
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 9936; /* avx512vl_getmantv16hf */

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x3) != E_V8HFmode
          || !nonimmediate_operand (operands[1], E_V8HFmode)
          || !(
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 9940; /* avx512fp16_getmantv8hf */

    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x3) != E_V16SFmode
          || !nonimmediate_operand (operands[1], E_V16SFmode)
          || !(
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9944; /* avx512f_getmantv16sf */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x3) != E_V8SFmode
          || !nonimmediate_operand (operands[1], E_V8SFmode)
          || !(
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9948; /* avx512vl_getmantv8sf */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode
          || !nonimmediate_operand (operands[1], E_V4SFmode)
          || !(
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9952; /* avx512vl_getmantv4sf */

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x3) != E_V8DFmode
          || !nonimmediate_operand (operands[1], E_V8DFmode)
          || !(
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9956; /* avx512f_getmantv8df */

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x3) != E_V4DFmode
          || !nonimmediate_operand (operands[1], E_V4DFmode)
          || !(
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9960; /* avx512vl_getmantv4df */

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode
          || !nonimmediate_operand (operands[1], E_V2DFmode)
          || !(
#line 29885 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9964; /* avx512vl_getmantv2df */

    default:
      return -1;
    }
}

 int
recog_236 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17)
    return -1;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[0] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[1] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (register_operand (operands[0], E_QImode)
          && register_operand (operands[1], E_QImode)
          && (
#line 2350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
        return 2614; /* *kortestqi */
      break;

    case E_HImode:
      if (register_operand (operands[0], E_HImode)
          && register_operand (operands[1], E_HImode)
          && 
#line 2350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
        return 2615; /* *kortesthi */
      break;

    case E_SImode:
      if (register_operand (operands[0], E_SImode)
          && register_operand (operands[1], E_SImode)
          && (
#line 2350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
        return 2616; /* *kortestsi */
      break;

    case E_DImode:
      if (register_operand (operands[0], E_DImode)
          && register_operand (operands[1], E_DImode)
          && (
#line 2350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
        return 2617; /* *kortestdi */
      break;

    default:
      break;
    }
  switch (GET_MODE (x2))
    {
    case E_CCCmode:
      if (GET_MODE (x3) != E_CCCmode)
        return -1;
      switch (pattern953 ())
        {
        case 0:
          if (!(
#line 2362 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
            return -1;
          return 2618; /* kortestqi_ccc */

        case 1:
          if (!
#line 2362 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 2619; /* kortesthi_ccc */

        case 2:
          if (!(
#line 2362 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2620; /* kortestsi_ccc */

        case 3:
          if (!(
#line 2362 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2621; /* kortestdi_ccc */

        default:
          return -1;
        }

    case E_CCZmode:
      if (GET_MODE (x3) != E_CCZmode)
        return -1;
      switch (pattern953 ())
        {
        case 0:
          if (!(
#line 2370 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
            return -1;
          return 2622; /* kortestqi_ccz */

        case 1:
          if (!
#line 2370 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 2623; /* kortesthi_ccz */

        case 2:
          if (!(
#line 2370 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2624; /* kortestsi_ccz */

        case 3:
          if (!(
#line 2370 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2625; /* kortestdi_ccz */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_245 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 2);
  switch (GET_CODE (x4))
    {
    case LT:
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      switch (pattern652 (x3))
        {
        case 0:
          if ((
#line 3364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 3039; /* *minmaxv8sf3_2 */
          break;

        case 1:
          if (
#line 3364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))))
            return 3040; /* *minmaxv4sf3_2 */
          break;

        case 2:
          if ((
#line 3364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 3041; /* *minmaxv4df3_2 */
          break;

        case 3:
          if ((
#line 3364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return 3042; /* *minmaxv2df3_2 */
          break;

        case 4:
          if ((
#line 23584 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 8616; /* *avx_blendvps256_lt */
          break;

        case 5:
          if (
#line 23584 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return 8617; /* *sse4_1_blendvps_lt */
          break;

        case 6:
          if ((
#line 23584 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 8618; /* *avx_blendvpd256_lt */
          break;

        case 7:
          if ((
#line 23584 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return 8619; /* *sse4_1_blendvpd_lt */
          break;

        case 8:
          if ((
#line 23914 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return 8663; /* *avx2_pblendvb_lt */
          break;

        case 9:
          if (
#line 23914 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return 8664; /* *sse4_1_pblendvb_lt */
          break;

        default:
          break;
        }
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != SUBREG)
        return -1;
      switch (pattern654 (x3))
        {
        case 0:
          if (!(
#line 23964 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && GET_MODE_CLASS (GET_MODE (operands[3])) == MODE_VECTOR_INT
   && GET_MODE_SIZE (GET_MODE (operands[3])) == 32
   && ix86_pre_reload_split ()) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8667; /* *avx2_pblendvb_lt_subreg_not */

        case 1:
          if (!
#line 23964 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && GET_MODE_CLASS (GET_MODE (operands[3])) == MODE_VECTOR_INT
   && GET_MODE_SIZE (GET_MODE (operands[3])) == 16
   && ix86_pre_reload_split ()))
            return -1;
          return 8668; /* *sse4_1_pblendvb_lt_subreg_not */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      operands[3] = x4;
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      x7 = XVECEXP (x3, 0, 1);
      operands[2] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern1017 (x3, 
E_V8SFmode) == 0
              && (
#line 23520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 8610; /* avx_blendvps256 */
          break;

        case E_V4SFmode:
          if (pattern1017 (x3, 
E_V4SFmode) == 0
              && 
#line 23520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return 8611; /* sse4_1_blendvps */
          break;

        case E_V4DFmode:
          if (pattern1017 (x3, 
E_V4DFmode) == 0
              && (
#line 23520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 8612; /* avx_blendvpd256 */
          break;

        case E_V2DFmode:
          if (pattern1017 (x3, 
E_V2DFmode) == 0
              && (
#line 23520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return 8613; /* sse4_1_blendvpd */
          break;

        default:
          break;
        }
      operands[1] = x5;
      operands[2] = x7;
      if (GET_CODE (x4) == SUBREG
          && known_eq (SUBREG_BYTE (x4), 0))
        {
          x6 = XEXP (x4, 0);
          switch (GET_CODE (x6))
            {
            case LT:
              x8 = XEXP (x6, 0);
              operands[3] = x8;
              switch (pattern1209 (x3))
                {
                case 0:
                  if (
#line 23644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8624; /* *sse4_1_blendvps_ltint */
                  break;

                case 1:
                  if (
#line 23644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8625; /* *sse4_1_blendvpd_ltint */
                  break;

                case 2:
                  if ((
#line 23644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return 8626; /* *avx_blendvps256_ltint */
                  break;

                case 3:
                  if ((
#line 23644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return 8627; /* *avx_blendvpd256_ltint */
                  break;

                default:
                  break;
                }
              if (GET_CODE (x8) == SUBREG)
                {
                  switch (pattern1210 (x3))
                    {
                    case 0:
                      if (
#line 23711 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()))
                        return 8632; /* *sse4_1_blendvps_not_ltint */
                      break;

                    case 1:
                      if (
#line 23711 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()))
                        return 8633; /* *sse4_1_blendvpd_not_ltint */
                      break;

                    case 2:
                      if ((
#line 23711 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                        return 8634; /* *avx_blendvps256_not_ltint */
                      break;

                    case 3:
                      if ((
#line 23711 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                        return 8635; /* *avx_blendvpd256_not_ltint */
                      break;

                    default:
                      break;
                    }
                }
              break;

            case GT:
              x8 = XEXP (x6, 0);
              operands[3] = x8;
              switch (pattern1211 (x3))
                {
                case 0:
                  if (
#line 23676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8628; /* *sse4_1_blendvps_gtint */
                  break;

                case 1:
                  if (
#line 23676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8629; /* *sse4_1_blendvpd_gtint */
                  break;

                case 2:
                  if ((
#line 23676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return 8630; /* *avx_blendvps256_gtint */
                  break;

                case 3:
                  if ((
#line 23676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                    return 8631; /* *avx_blendvpd256_gtint */
                  break;

                default:
                  break;
                }
              if (GET_CODE (x8) == SUBREG)
                {
                  switch (pattern1212 (x3))
                    {
                    case 0:
                      if (
#line 23737 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()))
                        return 8636; /* *sse4_1_blendvps_not_gtint */
                      break;

                    case 1:
                      if (
#line 23737 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()))
                        return 8637; /* *sse4_1_blendvpd_not_gtint */
                      break;

                    case 2:
                      if ((
#line 23737 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                        return 8638; /* *avx_blendvps256_not_gtint */
                      break;

                    case 3:
                      if ((
#line 23737 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_pre_reload_split ()) && 
#line 611 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                        return 8639; /* *avx_blendvpd256_not_gtint */
                      break;

                    default:
                      break;
                    }
                }
              break;

            default:
              break;
            }
        }
      operands[3] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V32QImode:
          if (pattern1017 (x3, 
E_V32QImode) != 0
              || !(
#line 23863 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8661; /* avx2_pblendvb */

        case E_V16QImode:
          if (pattern1017 (x3, 
E_V16QImode) != 0
              || !
#line 23863 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return -1;
          return 8662; /* sse4_1_pblendvb */

        default:
          return -1;
        }

    case GT:
      x5 = XVECEXP (x3, 0, 0);
      operands[1] = x5;
      switch (pattern657 (x3))
        {
        case 0:
          if ((
#line 23610 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 8620; /* *avx_blendvps256_gt */
          break;

        case 1:
          if (
#line 23610 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return 8621; /* *sse4_1_blendvps_gt */
          break;

        case 2:
          if ((
#line 23610 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return 8622; /* *avx_blendvpd256_gt */
          break;

        case 3:
          if ((
#line 23610 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return 8623; /* *sse4_1_blendvpd_gt */
          break;

        case 4:
          if ((
#line 23938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return 8665; /* *avx2_pblendvb_gt */
          break;

        case 5:
          if (
#line 23938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return 8666; /* *sse4_1_pblendvb_gt */
          break;

        default:
          break;
        }
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != SUBREG)
        return -1;
      switch (pattern659 (x3))
        {
        case 0:
          if (!(
#line 23986 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && GET_MODE_CLASS (GET_MODE (operands[3])) == MODE_VECTOR_INT
   && GET_MODE_SIZE (GET_MODE (operands[3])) == 32
   && ix86_pre_reload_split ()) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8669; /* *avx2_pblendvb_gt_subreg_not */

        case 1:
          if (!
#line 23986 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && GET_MODE_CLASS (GET_MODE (operands[3])) == MODE_VECTOR_INT
   && GET_MODE_SIZE (GET_MODE (operands[3])) == 16
   && ix86_pre_reload_split ()))
            return -1;
          return 8670; /* *sse4_1_pblendvb_gt_subreg_not */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_253 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern176 (x1))
    {
    case 0:
      if (!(
#line 30478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10172; /* vpshldv_v32hi */

    case 1:
      if (!(
#line 30478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10173; /* vpshldv_v16si */

    case 2:
      if (!(
#line 30478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10174; /* vpshldv_v8di */

    case 3:
      if (!(
#line 30478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10175; /* vpshldv_v16hi */

    case 4:
      if (!(
#line 30478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10176; /* vpshldv_v8si */

    case 5:
      if (!(
#line 30478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10177; /* vpshldv_v4di */

    case 6:
      if (!(
#line 30478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10178; /* vpshldv_v8hi */

    case 7:
      if (!(
#line 30478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10179; /* vpshldv_v4si */

    case 8:
      if (!(
#line 30478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10180; /* vpshldv_v2di */

    default:
      return -1;
    }
}

 int
recog_258 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  if (!const_0_to_255_operand (operands[3], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8SFmode:
      if (pattern154 (x3, 
E_V8SFmode) != 0
          || !(
#line 23758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8640; /* avx_dpps256 */

    case E_V4SFmode:
      if (pattern154 (x3, 
E_V4SFmode) != 0
          || !
#line 23758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
        return -1;
      return 8641; /* sse4_1_dpps */

    case E_V4DFmode:
      if (pattern154 (x3, 
E_V4DFmode) != 0
          || !(
#line 23758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8642; /* avx_dppd256 */

    case E_V2DFmode:
      if (pattern154 (x3, 
E_V2DFmode) != 0
          || !(
#line 23758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 8643; /* sse4_1_dppd */

    default:
      return -1;
    }
}

 int
recog_264 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x2, 0);
  operands[2] = x5;
  x6 = XEXP (x3, 0);
  operands[1] = x6;
  switch (XVECLEN (x4, 0))
    {
    case 2:
      x7 = XVECEXP (x4, 0, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x8 = XVECEXP (x4, 0, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SFmode:
          if (!nonimmediate_operand (operands[0], E_V4SFmode)
              || GET_MODE (x2) != E_V4SFmode
              || !nonimmediate_operand (operands[2], E_V2SFmode)
              || GET_MODE (x3) != E_V2SFmode
              || !nonimmediate_operand (operands[1], E_V4SFmode)
              || !
#line 11661 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 5182; /* sse_loadlps */

        case E_V4DImode:
          if (pattern1213 (x2, 
E_V4DImode, 
E_V2DImode) != 0
              || !
#line 28436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
            return -1;
          return 9388; /* vec_set_lo_v4di */

        case E_V4DFmode:
          if (pattern1213 (x2, 
E_V4DFmode, 
E_V2DFmode) != 0
              || !
#line 28436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
            return -1;
          return 9390; /* vec_set_lo_v4df */

        default:
          return -1;
        }

    case 1:
      x7 = XVECEXP (x4, 0, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !nonimmediate_operand (operands[0], E_V2DFmode)
          || GET_MODE (x2) != E_V2DFmode
          || !nonimmediate_operand (operands[2], E_DFmode)
          || GET_MODE (x3) != E_DFmode
          || !nonimm_or_0_operand (operands[1], E_V2DFmode)
          || !
#line 14773 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7142; /* sse2_loadlpd */

    case 8:
      x7 = XVECEXP (x4, 0, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XVECEXP (x4, 0, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
        return -1;
      x9 = XVECEXP (x4, 0, 2);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 10]
          || pattern1214 (x4, 
15, 
14, 
13, 
12, 
11) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern1213 (x2, 
E_V16SFmode, 
E_V8SFmode) != 0
              || !(
#line 20081 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8324; /* vec_set_lo_v16sf */

        case E_V16SImode:
          if (pattern1213 (x2, 
E_V16SImode, 
E_V8SImode) != 0
              || !(
#line 20081 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8326; /* vec_set_lo_v16si */

        case E_V16HImode:
          if (pattern1213 (x2, 
E_V16HImode, 
E_V8HImode) != 0
              || !
#line 28533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9404; /* vec_set_lo_v16hi */

        case E_V16HFmode:
          if (pattern1213 (x2, 
E_V16HFmode, 
E_V8HFmode) != 0
              || !
#line 28533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9405; /* vec_set_lo_v16hf */

        case E_V16BFmode:
          if (pattern1213 (x2, 
E_V16BFmode, 
E_V8BFmode) != 0
              || !
#line 28533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9406; /* vec_set_lo_v16bf */

        default:
          return -1;
        }

    case 4:
      x7 = XVECEXP (x4, 0, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x8 = XVECEXP (x4, 0, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x9 = XVECEXP (x4, 0, 2);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x10 = XVECEXP (x4, 0, 3);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DFmode:
          if (pattern1213 (x2, 
E_V8DFmode, 
E_V4DFmode) != 0
              || !(
#line 20113 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8332; /* vec_set_lo_v8df */

        case E_V8DImode:
          if (pattern1213 (x2, 
E_V8DImode, 
E_V4DImode) != 0
              || !(
#line 20113 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 8334; /* vec_set_lo_v8di */

        case E_V8SImode:
          if (pattern1213 (x2, 
E_V8SImode, 
E_V4SImode) != 0
              || !
#line 28485 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9396; /* vec_set_lo_v8si */

        case E_V8SFmode:
          if (pattern1213 (x2, 
E_V8SFmode, 
E_V4SFmode) != 0
              || !
#line 28485 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9398; /* vec_set_lo_v8sf */

        default:
          return -1;
        }

    case 16:
      x7 = XVECEXP (x4, 0, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 16])
        return -1;
      x8 = XVECEXP (x4, 0, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 17])
        return -1;
      x9 = XVECEXP (x4, 0, 2);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 18]
          || pattern1214 (x4, 
23, 
22, 
21, 
20, 
19) != 0)
        return -1;
      x11 = XVECEXP (x4, 0, 8);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 24])
        return -1;
      x12 = XVECEXP (x4, 0, 9);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 25])
        return -1;
      x13 = XVECEXP (x4, 0, 10);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 26])
        return -1;
      x14 = XVECEXP (x4, 0, 11);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 27])
        return -1;
      x15 = XVECEXP (x4, 0, 12);
      if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 28])
        return -1;
      x16 = XVECEXP (x4, 0, 13);
      if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 29])
        return -1;
      x17 = XVECEXP (x4, 0, 14);
      if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 30])
        return -1;
      x18 = XVECEXP (x4, 0, 15);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 31]
          || pattern1213 (x2, 
E_V32QImode, 
E_V16QImode) != 0
          || !
#line 28581 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
        return -1;
      return 9410; /* vec_set_lo_v32qi */

    default:
      return -1;
    }
}

 int
recog_269 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  switch (GET_CODE (x2))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case LTGT:
    case UNORDERED:
    case ORDERED:
    case UNEQ:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      operands[3] = x2;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern793 (
E_V8SFmode) == 0)
            {
              if ((
#line 4333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && GET_RTX_CLASS (GET_CODE (operands[3])) == RTX_COMM_COMPARE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 3241; /* *avx_maskcmpv8sf3_comm */
              if ((
#line 4350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 3245; /* avx_maskcmpv8sf3 */
            }
          break;

        case E_V4SFmode:
          if (pattern793 (
E_V4SFmode) == 0)
            {
              if (
#line 4333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && GET_RTX_CLASS (GET_CODE (operands[3])) == RTX_COMM_COMPARE))
                return 3242; /* *sse_maskcmpv4sf3_comm */
              if (
#line 4350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return 3246; /* sse_maskcmpv4sf3 */
            }
          break;

        case E_V4DFmode:
          if (pattern793 (
E_V4DFmode) == 0)
            {
              if ((
#line 4333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && GET_RTX_CLASS (GET_CODE (operands[3])) == RTX_COMM_COMPARE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 3243; /* *avx_maskcmpv4df3_comm */
              if ((
#line 4350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return 3247; /* avx_maskcmpv4df3 */
            }
          break;

        case E_V2DFmode:
          if (pattern793 (
E_V2DFmode) == 0)
            {
              if ((
#line 4333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && GET_RTX_CLASS (GET_CODE (operands[3])) == RTX_COMM_COMPARE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return 3244; /* *sse2_maskcmpv2df3_comm */
              if ((
#line 4350 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return 3248; /* sse2_maskcmpv2df3 */
            }
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  switch (GET_CODE (x2))
    {
    case LT:
      switch (GET_MODE (operands[0]))
        {
        case E_V16HImode:
          if (pattern235 (x2, 
E_V16HImode) != 0
              || !(
#line 17113 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 743 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7549; /* *ashrv16hi3_1 */

        case E_V8HImode:
          if (pattern235 (x2, 
E_V8HImode) != 0
              || !
#line 17113 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
            return -1;
          return 7550; /* *ashrv8hi3_1 */

        case E_V8SImode:
          if (pattern235 (x2, 
E_V8SImode) != 0
              || !(
#line 17113 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 744 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 7551; /* *ashrv8si3_1 */

        case E_V4SImode:
          if (pattern235 (x2, 
E_V4SImode) != 0
              || !
#line 17113 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
            return -1;
          return 7552; /* *ashrv4si3_1 */

        default:
          return -1;
        }

    case EQ:
      switch (GET_MODE (operands[0]))
        {
        case E_V32QImode:
          if (pattern5 (x2, 
E_V32QImode) != 0
              || !
#line 17921 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7813; /* *avx2_eqv32qi3 */

        case E_V16HImode:
          if (pattern5 (x2, 
E_V16HImode) != 0
              || !
#line 17921 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7814; /* *avx2_eqv16hi3 */

        case E_V8SImode:
          if (pattern5 (x2, 
E_V8SImode) != 0
              || !
#line 17921 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7815; /* *avx2_eqv8si3 */

        case E_V4DImode:
          if (pattern5 (x2, 
E_V4DImode) != 0
              || !
#line 17921 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7816; /* *avx2_eqv4di3 */

        case E_V2DImode:
          if (pattern25 (x2, 
E_V2DImode) != 0
              || !
#line 18204 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7871; /* *sse4_1_eqv2di3 */

        case E_V16QImode:
          if (pattern25 (x2, 
E_V16QImode) != 0
              || !
#line 18221 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7872; /* *sse2_eqv16qi3 */

        case E_V8HImode:
          if (pattern25 (x2, 
E_V8HImode) != 0
              || !
#line 18221 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7873; /* *sse2_eqv8hi3 */

        case E_V4SImode:
          if (pattern25 (x2, 
E_V4SImode) != 0
              || !
#line 18221 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7874; /* *sse2_eqv4si3 */

        default:
          return -1;
        }

    case GT:
      switch (GET_MODE (operands[0]))
        {
        case E_V2DImode:
          if (pattern664 (x2, 
E_V2DImode) != 0
              || !
#line 18237 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
            return -1;
          return 7875; /* sse4_2_gtv2di3 */

        case E_V32QImode:
          if (pattern14 (x2, 
E_V32QImode) != 0
              || !
#line 18254 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 7876; /* avx2_gtv32qi3 */

        case E_V16HImode:
          if (pattern14 (x2, 
E_V16HImode) != 0
              || !
#line 18254 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 7877; /* avx2_gtv16hi3 */

        case E_V8SImode:
          if (pattern14 (x2, 
E_V8SImode) != 0
              || !
#line 18254 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 7878; /* avx2_gtv8si3 */

        case E_V4DImode:
          if (pattern14 (x2, 
E_V4DImode) != 0
              || !
#line 18254 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
            return -1;
          return 7879; /* avx2_gtv4di3 */

        case E_V16QImode:
          if (pattern664 (x2, 
E_V16QImode) != 0
              || !
#line 18286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 7880; /* *sse2_gtv16qi3 */

        case E_V8HImode:
          if (pattern664 (x2, 
E_V8HImode) != 0
              || !
#line 18286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 7881; /* *sse2_gtv8hi3 */

        case E_V4SImode:
          if (pattern664 (x2, 
E_V4SImode) != 0
              || !
#line 18286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 7882; /* *sse2_gtv4si3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_274 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (pattern918 (x3) != 0)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  switch (XWINT (x4, 0))
    {
    case 0L:
      x5 = XVECEXP (x3, 0, 1);
      switch (XWINT (x5, 0))
        {
        case 1L:
          x6 = XVECEXP (x3, 0, 2);
          if (XWINT (x6, 0) != 2L)
            return -1;
          x7 = XVECEXP (x3, 0, 3);
          if (XWINT (x7, 0) != 3L)
            return -1;
          x8 = XVECEXP (x3, 0, 4);
          if (XWINT (x8, 0) != 8L)
            return -1;
          x9 = XVECEXP (x3, 0, 5);
          if (XWINT (x9, 0) != 9L)
            return -1;
          x10 = XVECEXP (x3, 0, 6);
          if (XWINT (x10, 0) != 10L)
            return -1;
          x11 = XVECEXP (x3, 0, 7);
          if (XWINT (x11, 0) != 11L)
            return -1;
          x12 = XEXP (x2, 0);
          x13 = XEXP (x12, 1);
          operands[2] = x13;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HImode:
              if (pattern1468 (x2, 
E_V8HImode, 
E_V16HImode) != 0
                  || !
#line 11113 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (UNKNOWN, V8HImode, operands)))
                return -1;
              return 5147; /* sse_movlhps_v8hi */

            case E_V8HFmode:
              if (pattern1468 (x2, 
E_V8HFmode, 
E_V16HFmode) != 0
                  || !
#line 11113 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (UNKNOWN, V8HFmode, operands)))
                return -1;
              return 5148; /* sse_movlhps_v8hf */

            case E_V8BFmode:
              if (pattern1468 (x2, 
E_V8BFmode, 
E_V16BFmode) != 0
                  || !
#line 11113 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (UNKNOWN, V8BFmode, operands)))
                return -1;
              return 5149; /* sse_movlhps_v8bf */

            default:
              return -1;
            }

        case 8L:
          x6 = XVECEXP (x3, 0, 2);
          switch (XWINT (x6, 0))
            {
            case 1L:
              x7 = XVECEXP (x3, 0, 3);
              if (XWINT (x7, 0) != 9L)
                return -1;
              x12 = XEXP (x2, 0);
              x13 = XEXP (x12, 1);
              operands[2] = x13;
              x8 = XVECEXP (x3, 0, 4);
              switch (XWINT (x8, 0))
                {
                case 4L:
                  x9 = XVECEXP (x3, 0, 5);
                  if (XWINT (x9, 0) != 12L)
                    return -1;
                  x10 = XVECEXP (x3, 0, 6);
                  if (XWINT (x10, 0) != 5L)
                    return -1;
                  x11 = XVECEXP (x3, 0, 7);
                  if (XWINT (x11, 0) != 13L)
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V8SFmode:
                      if (pattern1401 (x2, 
E_V8SFmode, 
E_V16SFmode) != 0
                          || !
#line 11243 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
                        return -1;
                      return 5158; /* avx_unpcklps256 */

                    case E_V8SImode:
                      if (pattern1401 (x2, 
E_V8SImode, 
E_V16SImode) != 0
                          || !
#line 19765 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
                        return -1;
                      return 8300; /* avx2_interleave_lowv8si */

                    default:
                      return -1;
                    }

                case 2L:
                  x9 = XVECEXP (x3, 0, 5);
                  if (XWINT (x9, 0) != 10L)
                    return -1;
                  x10 = XVECEXP (x3, 0, 6);
                  if (XWINT (x10, 0) != 3L)
                    return -1;
                  x11 = XVECEXP (x3, 0, 7);
                  if (XWINT (x11, 0) != 11L)
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V8HImode:
                      if (pattern1469 (x2, 
E_V8HImode, 
E_V16HImode) != 0
                          || !
#line 19690 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
                        return -1;
                      return 8288; /* vec_interleave_lowv8hi */

                    case E_V8HFmode:
                      if (pattern1469 (x2, 
E_V8HFmode, 
E_V16HFmode) != 0
                          || !
#line 19690 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
                        return -1;
                      return 8290; /* vec_interleave_lowv8hf */

                    case E_V8BFmode:
                      if (pattern1469 (x2, 
E_V8BFmode, 
E_V16BFmode) != 0
                          || !
#line 19690 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
                        return -1;
                      return 8292; /* vec_interleave_lowv8bf */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case 2L:
              x7 = XVECEXP (x3, 0, 3);
              if (XWINT (x7, 0) != 10L)
                return -1;
              x8 = XVECEXP (x3, 0, 4);
              if (XWINT (x8, 0) != 4L)
                return -1;
              x9 = XVECEXP (x3, 0, 5);
              if (XWINT (x9, 0) != 12L)
                return -1;
              x10 = XVECEXP (x3, 0, 6);
              if (XWINT (x10, 0) != 6L)
                return -1;
              x11 = XVECEXP (x3, 0, 7);
              if (XWINT (x11, 0) != 14L)
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V8DFmode:
                  if (!register_operand (operands[0], E_V8DFmode)
                      || GET_MODE (x2) != E_V8DFmode)
                    return -1;
                  x12 = XEXP (x2, 0);
                  if (GET_MODE (x12) != E_V16DFmode)
                    return -1;
                  if (nonimmediate_operand (operands[1], E_V8DFmode))
                    {
                      x13 = XEXP (x12, 1);
                      if (rtx_equal_p (x13, operands[1])
                          && 
#line 13424 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                        return 5310; /* avx512f_movddup512 */
                    }
                  if (!register_operand (operands[1], E_V8DFmode))
                    return -1;
                  x13 = XEXP (x12, 1);
                  operands[2] = x13;
                  if (!nonimmediate_operand (operands[2], E_V8DFmode)
                      || !
#line 13440 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                    return -1;
                  return 5312; /* avx512f_unpcklpd512 */

                case E_V8DImode:
                  if (pattern1601 (x2, 
E_V8DImode, 
E_V16DImode) != 0
                      || !
#line 14517 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                    return -1;
                  return 7131; /* *avx512f_interleave_lowv8di */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 0L:
          if (pattern1641 (x3) != 0
              || pattern1772 (x2, 
E_V8SFmode, 
E_V16SFmode) != 0
              || !
#line 11382 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
            return -1;
          return 5168; /* avx_movsldup256 */

        default:
          return -1;
        }

    case 2L:
      x5 = XVECEXP (x3, 0, 1);
      if (XWINT (x5, 0) != 10L)
        return -1;
      x6 = XVECEXP (x3, 0, 2);
      if (XWINT (x6, 0) != 3L)
        return -1;
      x7 = XVECEXP (x3, 0, 3);
      if (XWINT (x7, 0) != 11L
          || pattern1690 (x2) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern1401 (x2, 
E_V8SFmode, 
E_V16SFmode) != 0
              || !
#line 11155 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
            return -1;
          return 5152; /* avx_unpckhps256 */

        case E_V8SImode:
          if (pattern1401 (x2, 
E_V8SImode, 
E_V16SImode) != 0
              || !
#line 19710 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && 1))
            return -1;
          return 8294; /* avx2_interleave_highv8si */

        default:
          return -1;
        }

    case 1L:
      x6 = XVECEXP (x3, 0, 2);
      if (XWINT (x6, 0) != 3L)
        return -1;
      x8 = XVECEXP (x3, 0, 4);
      if (XWINT (x8, 0) != 5L)
        return -1;
      x10 = XVECEXP (x3, 0, 6);
      if (XWINT (x10, 0) != 7L)
        return -1;
      x5 = XVECEXP (x3, 0, 1);
      switch (XWINT (x5, 0))
        {
        case 1L:
          x7 = XVECEXP (x3, 0, 3);
          if (XWINT (x7, 0) != 3L)
            return -1;
          x9 = XVECEXP (x3, 0, 5);
          if (XWINT (x9, 0) != 5L)
            return -1;
          x11 = XVECEXP (x3, 0, 7);
          if (XWINT (x11, 0) != 7L
              || pattern1772 (x2, 
E_V8SFmode, 
E_V16SFmode) != 0
              || !
#line 11329 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
            return -1;
          return 5162; /* avx_movshdup256 */

        case 9L:
          x7 = XVECEXP (x3, 0, 3);
          if (XWINT (x7, 0) != 11L)
            return -1;
          x9 = XVECEXP (x3, 0, 5);
          if (XWINT (x9, 0) != 13L)
            return -1;
          x11 = XVECEXP (x3, 0, 7);
          if (XWINT (x11, 0) != 15L)
            return -1;
          x12 = XEXP (x2, 0);
          x13 = XEXP (x12, 1);
          operands[2] = x13;
          switch (GET_MODE (operands[0]))
            {
            case E_V8DFmode:
              if (pattern1401 (x2, 
E_V8DFmode, 
E_V16DFmode) != 0
                  || !
#line 13310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                return -1;
              return 5304; /* *avx512f_unpckhpd512 */

            case E_V8DImode:
              if (pattern1401 (x2, 
E_V8DImode, 
E_V16DImode) != 0
                  || !
#line 14467 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                return -1;
              return 7125; /* *avx512f_interleave_highv8di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 4L:
      x5 = XVECEXP (x3, 0, 1);
      if (XWINT (x5, 0) != 12L)
        return -1;
      x6 = XVECEXP (x3, 0, 2);
      if (XWINT (x6, 0) != 5L)
        return -1;
      x7 = XVECEXP (x3, 0, 3);
      if (XWINT (x7, 0) != 13L
          || pattern1690 (x2) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HImode:
          if (pattern1469 (x2, 
E_V8HImode, 
E_V16HImode) != 0
              || !
#line 19622 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
            return -1;
          return 8270; /* vec_interleave_highv8hi */

        case E_V8HFmode:
          if (pattern1469 (x2, 
E_V8HFmode, 
E_V16HFmode) != 0
              || !
#line 19622 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
            return -1;
          return 8272; /* vec_interleave_highv8hf */

        case E_V8BFmode:
          if (pattern1469 (x2, 
E_V8BFmode, 
E_V16BFmode) != 0
              || !
#line 19622 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
            return -1;
          return 8274; /* vec_interleave_highv8bf */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_282 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  operands[2] = x4;
  if (const_0_to_7_operand (operands[2], E_VOIDmode))
    {
      x5 = XVECEXP (x3, 0, 1);
      operands[3] = x5;
      if (const_0_to_7_operand (operands[3], E_VOIDmode))
        {
          switch (GET_MODE (operands[0]))
            {
            case E_V2DFmode:
              if (nonimmediate_operand (operands[0], E_V2DFmode)
                  && GET_MODE (x2) == E_V2DFmode
                  && register_operand (operands[1], E_V8DFmode)
                  && (
#line 12440 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && INTVAL (operands[2]) % 2 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1) && 
#line 717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 5242; /* *avx512dq_vextractf64x2_1 */
              break;

            case E_V2DImode:
              if (nonimmediate_operand (operands[0], E_V2DImode)
                  && GET_MODE (x2) == E_V2DImode
                  && register_operand (operands[1], E_V8DImode)
                  && (
#line 12440 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && INTVAL (operands[2]) % 2 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1) && 
#line 717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 5243; /* *avx512dq_vextracti64x2_1 */
              break;

            default:
              break;
            }
        }
    }
  x5 = XVECEXP (x3, 0, 1);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  switch (XWINT (x4, 0))
    {
    case 0L:
      if (XWINT (x5, 0) != 1L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DImode:
          if (!nonimmediate_operand (operands[0], E_V2DImode)
              || GET_MODE (x2) != E_V2DImode
              || !nonimmediate_operand (operands[1], E_V4DImode)
              || !
#line 12866 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
            return -1;
          return 5266; /* vec_extract_lo_v4di */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[0], E_V2DFmode)
              || GET_MODE (x2) != E_V2DFmode
              || !nonimmediate_operand (operands[1], E_V4DFmode)
              || !
#line 12866 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
            return -1;
          return 5267; /* vec_extract_lo_v4df */

        default:
          return -1;
        }

    case 2L:
      if (XWINT (x5, 0) != 3L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DImode:
          if (!nonimmediate_operand (operands[0], E_V2DImode)
              || GET_MODE (x2) != E_V2DImode
              || !register_operand (operands[1], E_V4DImode)
              || !
#line 12902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 5270; /* vec_extract_hi_v4di */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[0], E_V2DFmode)
              || GET_MODE (x2) != E_V2DFmode
              || !register_operand (operands[1], E_V4DFmode)
              || !
#line 12902 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 5271; /* vec_extract_hi_v4df */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_285 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (pattern918 (x3) != 0)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  switch (XWINT (x4, 0))
    {
    case 8L:
      x5 = XVECEXP (x3, 0, 1);
      if (XWINT (x5, 0) != 9L)
        return -1;
      x6 = XVECEXP (x3, 0, 2);
      if (XWINT (x6, 0) != 10L)
        return -1;
      x7 = XVECEXP (x3, 0, 3);
      if (XWINT (x7, 0) != 11L)
        return -1;
      x8 = XVECEXP (x3, 0, 4);
      if (XWINT (x8, 0) != 12L)
        return -1;
      x9 = XVECEXP (x3, 0, 5);
      if (XWINT (x9, 0) != 13L)
        return -1;
      x10 = XVECEXP (x3, 0, 6);
      if (XWINT (x10, 0) != 14L)
        return -1;
      x11 = XVECEXP (x3, 0, 7);
      if (XWINT (x11, 0) != 15L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (!nonimmediate_operand (operands[0], E_V8SFmode)
              || GET_MODE (x2) != E_V8SFmode
              || !register_operand (operands[1], E_V16SFmode)
              || !(
#line 12693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5258; /* vec_extract_hi_v16sf */

        case E_V8SImode:
          if (!nonimmediate_operand (operands[0], E_V8SImode)
              || GET_MODE (x2) != E_V8SImode
              || !register_operand (operands[1], E_V16SImode)
              || !(
#line 12693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5259; /* vec_extract_hi_v16si */

        case E_V8HImode:
          if (!nonimmediate_operand (operands[0], E_V8HImode)
              || GET_MODE (x2) != E_V8HImode
              || !register_operand (operands[1], E_V16HImode)
              || !
#line 13081 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 5289; /* vec_extract_hi_v16hi */

        case E_V8HFmode:
          if (!nonimmediate_operand (operands[0], E_V8HFmode)
              || GET_MODE (x2) != E_V8HFmode
              || !register_operand (operands[1], E_V16HFmode)
              || !
#line 13081 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 5290; /* vec_extract_hi_v16hf */

        case E_V8BFmode:
          if (!nonimmediate_operand (operands[0], E_V8BFmode)
              || GET_MODE (x2) != E_V8BFmode
              || !register_operand (operands[1], E_V16BFmode)
              || !
#line 13081 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 5291; /* vec_extract_hi_v16bf */

        default:
          return -1;
        }

    case 0L:
      x5 = XVECEXP (x3, 0, 1);
      if (XWINT (x5, 0) != 1L)
        return -1;
      x6 = XVECEXP (x3, 0, 2);
      if (XWINT (x6, 0) != 2L)
        return -1;
      x7 = XVECEXP (x3, 0, 3);
      if (XWINT (x7, 0) != 3L)
        return -1;
      x8 = XVECEXP (x3, 0, 4);
      if (XWINT (x8, 0) != 4L)
        return -1;
      x9 = XVECEXP (x3, 0, 5);
      if (XWINT (x9, 0) != 5L)
        return -1;
      x10 = XVECEXP (x3, 0, 6);
      if (XWINT (x10, 0) != 6L)
        return -1;
      x11 = XVECEXP (x3, 0, 7);
      if (XWINT (x11, 0) != 7L)
        return -1;
      switch (pattern1514 (x2))
        {
        case 0:
          if (!(
#line 12798 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5262; /* vec_extract_lo_v16sf */

        case 1:
          if (!(
#line 12798 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5263; /* vec_extract_lo_v16si */

        case 2:
          if (!
#line 13067 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
            return -1;
          return 5286; /* vec_extract_lo_v16hi */

        case 3:
          if (!
#line 13067 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
            return -1;
          return 5287; /* vec_extract_lo_v16hf */

        case 4:
          if (!
#line 13067 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
            return -1;
          return 5288; /* vec_extract_lo_v16bf */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_297 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V16BFmode:
      if (GET_MODE (x2) != E_V16BFmode)
        return -1;
      if (register_operand (operands[0], E_V16BFmode)
          && vector_operand (operands[1], E_V16BFmode)
          && vector_operand (operands[2], E_V16BFmode)
          && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 426 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 3673; /* *andv16bf3 */
      if (!nonimmediate_operand (operands[0], E_V16BFmode)
          || !nonimmediate_operand (operands[1], E_V16BFmode)
          || !float_vector_all_ones_operand (operands[2], E_V16BFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 412 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 3728; /* *bit_and_float_vector_all_ones */

    case E_V8BFmode:
      if (GET_MODE (x2) != E_V8BFmode)
        return -1;
      if (register_operand (operands[0], E_V8BFmode)
          && vector_operand (operands[1], E_V8BFmode)
          && vector_operand (operands[2], E_V8BFmode)
          && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 426 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return 3676; /* *andv8bf3 */
      if (!nonimmediate_operand (operands[0], E_V8BFmode)
          || !nonimmediate_operand (operands[1], E_V8BFmode)
          || !float_vector_all_ones_operand (operands[2], E_V8BFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 412 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 3729; /* *bit_and_float_vector_all_ones */

    case E_V16HFmode:
      if (GET_MODE (x2) != E_V16HFmode)
        return -1;
      if (register_operand (operands[0], E_V16HFmode)
          && vector_operand (operands[1], E_V16HFmode)
          && vector_operand (operands[2], E_V16HFmode)
          && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 427 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 3679; /* *andv16hf3 */
      if (!nonimmediate_operand (operands[0], E_V16HFmode)
          || !nonimmediate_operand (operands[1], E_V16HFmode)
          || !float_vector_all_ones_operand (operands[2], E_V16HFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 414 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 3731; /* *bit_and_float_vector_all_ones */

    case E_V8HFmode:
      if (GET_MODE (x2) != E_V8HFmode)
        return -1;
      if (register_operand (operands[0], E_V8HFmode)
          && vector_operand (operands[1], E_V8HFmode)
          && vector_operand (operands[2], E_V8HFmode)
          && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 427 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return 3682; /* *andv8hf3 */
      if (!nonimmediate_operand (operands[0], E_V8HFmode)
          || !nonimmediate_operand (operands[1], E_V8HFmode)
          || !float_vector_all_ones_operand (operands[2], E_V8HFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 414 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 3732; /* *bit_and_float_vector_all_ones */

    case E_V8SFmode:
      if (GET_MODE (x2) != E_V8SFmode)
        return -1;
      if (register_operand (operands[0], E_V8SFmode)
          && vector_operand (operands[1], E_V8SFmode)
          && vector_operand (operands[2], E_V8SFmode)
          && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 428 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 3685; /* *andv8sf3 */
      if (!nonimmediate_operand (operands[0], E_V8SFmode)
          || !nonimmediate_operand (operands[1], E_V8SFmode)
          || !float_vector_all_ones_operand (operands[2], E_V8SFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 3734; /* *bit_and_float_vector_all_ones */

    case E_V4SFmode:
      if (GET_MODE (x2) != E_V4SFmode)
        return -1;
      if (register_operand (operands[0], E_V4SFmode)
          && vector_operand (operands[1], E_V4SFmode)
          && vector_operand (operands[2], E_V4SFmode)
          && 
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 3691; /* *andv4sf3 */
      if (!nonimmediate_operand (operands[0], E_V4SFmode)
          || !nonimmediate_operand (operands[1], E_V4SFmode)
          || !float_vector_all_ones_operand (operands[2], E_V4SFmode)
          || !
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()))
        return -1;
      return 3735; /* *bit_and_float_vector_all_ones */

    case E_V4DFmode:
      if (GET_MODE (x2) != E_V4DFmode)
        return -1;
      if (register_operand (operands[0], E_V4DFmode)
          && vector_operand (operands[1], E_V4DFmode)
          && vector_operand (operands[2], E_V4DFmode)
          && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 3697; /* *andv4df3 */
      if (!nonimmediate_operand (operands[0], E_V4DFmode)
          || !nonimmediate_operand (operands[1], E_V4DFmode)
          || !float_vector_all_ones_operand (operands[2], E_V4DFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 3737; /* *bit_and_float_vector_all_ones */

    case E_V2DFmode:
      if (GET_MODE (x2) != E_V2DFmode)
        return -1;
      if (register_operand (operands[0], E_V2DFmode)
          && vector_operand (operands[1], E_V2DFmode)
          && vector_operand (operands[2], E_V2DFmode)
          && (
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return 3703; /* *andv2df3 */
      if (!nonimmediate_operand (operands[0], E_V2DFmode)
          || !nonimmediate_operand (operands[1], E_V2DFmode)
          || !float_vector_all_ones_operand (operands[2], E_V2DFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 3738; /* *bit_and_float_vector_all_ones */

    case E_V32BFmode:
      if (GET_MODE (x2) != E_V32BFmode
          || !nonimmediate_operand (operands[1], E_V32BFmode))
        return -1;
      if (register_operand (operands[0], E_V32BFmode)
          && nonimmediate_operand (operands[2], E_V32BFmode)
          && (
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 16 != 16)) && 
#line 491 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 3709; /* *andv32bf3 */
      if (!nonimmediate_operand (operands[0], E_V32BFmode)
          || !float_vector_all_ones_operand (operands[2], E_V32BFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 411 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 3727; /* *bit_and_float_vector_all_ones */

    case E_V32HFmode:
      if (GET_MODE (x2) != E_V32HFmode
          || !nonimmediate_operand (operands[1], E_V32HFmode))
        return -1;
      if (register_operand (operands[0], E_V32HFmode)
          && nonimmediate_operand (operands[2], E_V32HFmode)
          && (
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 16 != 16)) && 
#line 492 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 3712; /* *andv32hf3 */
      if (!nonimmediate_operand (operands[0], E_V32HFmode)
          || !float_vector_all_ones_operand (operands[2], E_V32HFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 413 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 3730; /* *bit_and_float_vector_all_ones */

    case E_V16SFmode:
      if (GET_MODE (x2) != E_V16SFmode
          || !nonimmediate_operand (operands[1], E_V16SFmode))
        return -1;
      if (register_operand (operands[0], E_V16SFmode)
          && nonimmediate_operand (operands[2], E_V16SFmode)
          && (
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 32 != 16)) && 
#line 493 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 3715; /* *andv16sf3 */
      if (!nonimmediate_operand (operands[0], E_V16SFmode)
          || !float_vector_all_ones_operand (operands[2], E_V16SFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 415 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 3733; /* *bit_and_float_vector_all_ones */

    case E_V8DFmode:
      if (GET_MODE (x2) != E_V8DFmode
          || !nonimmediate_operand (operands[1], E_V8DFmode))
        return -1;
      if (register_operand (operands[0], E_V8DFmode)
          && nonimmediate_operand (operands[2], E_V8DFmode)
          && (
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 64 != 16)) && 
#line 494 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 3721; /* *andv8df3 */
      if (!nonimmediate_operand (operands[0], E_V8DFmode)
          || !float_vector_all_ones_operand (operands[2], E_V8DFmode)
          || !(
#line 5474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()) && 
#line 416 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 3736; /* *bit_and_float_vector_all_ones */

    case E_V16SImode:
      if (pattern182 (x2, 
E_V16SImode) != 0
          || !(
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (AND, V16SImode, operands)) && 
#line 807 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 7931; /* *andv16si3 */

    case E_V8SImode:
      if (pattern182 (x2, 
E_V8SImode) != 0
          || !(
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (AND, V8SImode, operands)) && 
#line 807 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 7937; /* *andv8si3 */

    case E_V4SImode:
      if (pattern182 (x2, 
E_V4SImode) != 0
          || !
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (AND, V4SImode, operands)))
        return -1;
      return 7943; /* *andv4si3 */

    case E_V8DImode:
      if (pattern182 (x2, 
E_V8DImode) != 0
          || !(
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (AND, V8DImode, operands)) && 
#line 808 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 7949; /* *andv8di3 */

    case E_V4DImode:
      if (pattern182 (x2, 
E_V4DImode) != 0
          || !(
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (AND, V4DImode, operands)) && 
#line 808 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 7955; /* *andv4di3 */

    case E_V2DImode:
      if (pattern182 (x2, 
E_V2DImode) != 0
          || !
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (AND, V2DImode, operands)))
        return -1;
      return 7961; /* *andv2di3 */

    case E_V64QImode:
      if (pattern25 (x2, 
E_V64QImode) != 0
          || !(
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 811 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 7967; /* *andv64qi3 */

    case E_V32QImode:
      if (pattern25 (x2, 
E_V32QImode) != 0
          || !(
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 811 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 7970; /* *andv32qi3 */

    case E_V16QImode:
      if (pattern25 (x2, 
E_V16QImode) != 0
          || !
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7973; /* *andv16qi3 */

    case E_V32HImode:
      if (pattern25 (x2, 
E_V32HImode) != 0
          || !(
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 812 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 7976; /* *andv32hi3 */

    case E_V16HImode:
      if (pattern25 (x2, 
E_V16HImode) != 0
          || !(
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 812 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 7979; /* *andv16hi3 */

    case E_V8HImode:
      if (pattern25 (x2, 
E_V8HImode) != 0
          || !
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7982; /* *andv8hi3 */

    case E_V1TImode:
      if (pattern664 (x2, 
E_V1TImode) != 0
          || !
#line 18916 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return -1;
      return 7985; /* andv1ti3 */

    default:
      return -1;
    }
}

 int
recog_306 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern533 (x2))
        {
        case 0:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5770; /* *avx512bw_vpternlogv32hf_1 */

        case 1:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5797; /* *avx512vl_vpternlogv16hf_1 */

        case 2:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5824; /* *avx512fp16_vpternlogv8hf_1 */

        case 3:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5851; /* *avx512bw_vpternlogv32bf_1 */

        case 4:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5878; /* *avx512vl_vpternlogv16bf_1 */

        case 5:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5905; /* *avx512vl_vpternlogv8bf_1 */

        case 6:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5932; /* *avx512f_vpternlogv16sf_1 */

        case 7:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5959; /* *avx512vl_vpternlogv8sf_1 */

        case 8:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5986; /* *avx512vl_vpternlogv4sf_1 */

        case 9:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6013; /* *avx512f_vpternlogv8df_1 */

        case 10:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6040; /* *avx512vl_vpternlogv4df_1 */

        case 11:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6067; /* *avx512vl_vpternlogv2df_1 */

        case 12:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5773; /* *avx512bw_vpternlogv32hf_1 */

        case 13:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5800; /* *avx512vl_vpternlogv16hf_1 */

        case 14:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5827; /* *avx512fp16_vpternlogv8hf_1 */

        case 15:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5854; /* *avx512bw_vpternlogv32bf_1 */

        case 16:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5881; /* *avx512vl_vpternlogv16bf_1 */

        case 17:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5908; /* *avx512vl_vpternlogv8bf_1 */

        case 18:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5935; /* *avx512f_vpternlogv16sf_1 */

        case 19:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5962; /* *avx512vl_vpternlogv8sf_1 */

        case 20:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5989; /* *avx512vl_vpternlogv4sf_1 */

        case 21:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6016; /* *avx512f_vpternlogv8df_1 */

        case 22:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6043; /* *avx512vl_vpternlogv4df_1 */

        case 23:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6070; /* *avx512vl_vpternlogv2df_1 */

        case 24:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5776; /* *avx512bw_vpternlogv32hf_1 */

        case 25:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5803; /* *avx512vl_vpternlogv16hf_1 */

        case 26:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5830; /* *avx512fp16_vpternlogv8hf_1 */

        case 27:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5857; /* *avx512bw_vpternlogv32bf_1 */

        case 28:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5884; /* *avx512vl_vpternlogv16bf_1 */

        case 29:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5911; /* *avx512vl_vpternlogv8bf_1 */

        case 30:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5938; /* *avx512f_vpternlogv16sf_1 */

        case 31:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5965; /* *avx512vl_vpternlogv8sf_1 */

        case 32:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5992; /* *avx512vl_vpternlogv4sf_1 */

        case 33:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6019; /* *avx512f_vpternlogv8df_1 */

        case 34:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6046; /* *avx512vl_vpternlogv4df_1 */

        case 35:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6073; /* *avx512vl_vpternlogv2df_1 */

        case 36:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6838; /* *avx512bw_vpternlogv32hf_3 */

        case 37:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6847; /* *avx512vl_vpternlogv16hf_3 */

        case 38:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6856; /* *avx512fp16_vpternlogv8hf_3 */

        case 39:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6865; /* *avx512bw_vpternlogv32bf_3 */

        case 40:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6874; /* *avx512vl_vpternlogv16bf_3 */

        case 41:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6883; /* *avx512vl_vpternlogv8bf_3 */

        case 42:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6892; /* *avx512f_vpternlogv16sf_3 */

        case 43:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6901; /* *avx512vl_vpternlogv8sf_3 */

        case 44:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6910; /* *avx512vl_vpternlogv4sf_3 */

        case 45:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6919; /* *avx512f_vpternlogv8df_3 */

        case 46:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6928; /* *avx512vl_vpternlogv4df_3 */

        case 47:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6937; /* *avx512vl_vpternlogv2df_3 */

        default:
          return -1;
        }

    case AND:
      switch (pattern534 (x2))
        {
        case 0:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6418; /* *avx512bw_vpternlogv32hf_2 */

        case 1:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6445; /* *avx512vl_vpternlogv16hf_2 */

        case 2:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6472; /* *avx512fp16_vpternlogv8hf_2 */

        case 3:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6499; /* *avx512bw_vpternlogv32bf_2 */

        case 4:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6526; /* *avx512vl_vpternlogv16bf_2 */

        case 5:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6553; /* *avx512vl_vpternlogv8bf_2 */

        case 6:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6580; /* *avx512f_vpternlogv16sf_2 */

        case 7:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6607; /* *avx512vl_vpternlogv8sf_2 */

        case 8:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6634; /* *avx512vl_vpternlogv4sf_2 */

        case 9:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6661; /* *avx512f_vpternlogv8df_2 */

        case 10:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6688; /* *avx512vl_vpternlogv4df_2 */

        case 11:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6715; /* *avx512vl_vpternlogv2df_2 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern534 (x2))
        {
        case 0:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6421; /* *avx512bw_vpternlogv32hf_2 */

        case 1:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6448; /* *avx512vl_vpternlogv16hf_2 */

        case 2:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6475; /* *avx512fp16_vpternlogv8hf_2 */

        case 3:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6502; /* *avx512bw_vpternlogv32bf_2 */

        case 4:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6529; /* *avx512vl_vpternlogv16bf_2 */

        case 5:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6556; /* *avx512vl_vpternlogv8bf_2 */

        case 6:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6583; /* *avx512f_vpternlogv16sf_2 */

        case 7:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6610; /* *avx512vl_vpternlogv8sf_2 */

        case 8:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6637; /* *avx512vl_vpternlogv4sf_2 */

        case 9:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6664; /* *avx512f_vpternlogv8df_2 */

        case 10:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6691; /* *avx512vl_vpternlogv4df_2 */

        case 11:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6718; /* *avx512vl_vpternlogv2df_2 */

        default:
          return -1;
        }

    case XOR:
      switch (pattern534 (x2))
        {
        case 0:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6424; /* *avx512bw_vpternlogv32hf_2 */

        case 1:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6451; /* *avx512vl_vpternlogv16hf_2 */

        case 2:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6478; /* *avx512fp16_vpternlogv8hf_2 */

        case 3:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6505; /* *avx512bw_vpternlogv32bf_2 */

        case 4:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6532; /* *avx512vl_vpternlogv16bf_2 */

        case 5:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6559; /* *avx512vl_vpternlogv8bf_2 */

        case 6:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6586; /* *avx512f_vpternlogv16sf_2 */

        case 7:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6613; /* *avx512vl_vpternlogv8sf_2 */

        case 8:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6640; /* *avx512vl_vpternlogv4sf_2 */

        case 9:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6667; /* *avx512f_vpternlogv8df_2 */

        case 10:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6694; /* *avx512vl_vpternlogv4df_2 */

        case 11:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6721; /* *avx512vl_vpternlogv2df_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_315 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XVECLEN (x2, 0))
    {
    case 1:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (XINT (x2, 1))
        {
        case 177:
          return recog_215 (x1, insn, pnum_clobbers);

        case 118:
          if (pnum_clobbers == NULL
              || GET_MODE (x2) != E_V4SImode
              || !register_operand (operands[0], E_V4SImode))
            return -1;
          x4 = XVECEXP (x2, 0, 0);
          operands[1] = x4;
          if (!nonimmediate_operand (operands[1], E_DImode)
              || !
#line 1881 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC))
            return -1;
          *pnum_clobbers = 1;
          return 2558; /* movdi_to_sse */

        case 119:
          x4 = XVECEXP (x2, 0, 0);
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_V32QImode:
              if (!register_operand (operands[0], E_V32QImode)
                  || GET_MODE (x2) != E_V32QImode
                  || !memory_operand (operands[1], E_V32QImode)
                  || !(
#line 1989 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3) && 
#line 600 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 2559; /* avx_lddqu256 */

            case E_V16QImode:
              if (!register_operand (operands[0], E_V16QImode)
                  || GET_MODE (x2) != E_V16QImode
                  || !memory_operand (operands[1], E_V16QImode)
                  || !
#line 1989 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3))
                return -1;
              return 2560; /* sse3_lddqu */

            default:
              return -1;
            }

        case 117:
          return recog_211 (x1, insn, pnum_clobbers);

        case 54:
          return recog_213 (x1, insn, pnum_clobbers);

        case 161:
          switch (pattern322 (x2))
            {
            case 0:
              if (!(
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 2888; /* *rcp14v16sf */

            case 1:
              if (!(
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 2890; /* *rcp14v8sf */

            case 2:
              if (!(
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 2892; /* *rcp14v4sf */

            case 3:
              if (!(
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 2894; /* *rcp14v8df */

            case 4:
              if (!(
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 2896; /* *rcp14v4df */

            case 5:
              if (!(
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 2898; /* *rcp14v2df */

            default:
              return -1;
            }

        case 55:
          return recog_212 (x1, insn, pnum_clobbers);

        case 162:
          switch (pattern322 (x2))
            {
            case 0:
              if (!(
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 2960; /* *rsqrt14v16sf */

            case 1:
              if (!(
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 2962; /* *rsqrt14v8sf */

            case 2:
              if (!(
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 2964; /* *rsqrt14v4sf */

            case 3:
              if (!(
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 2966; /* *rsqrt14v8df */

            case 4:
              if (!(
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 2968; /* *rsqrt14v4df */

            case 5:
              if (!(
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 2970; /* *rsqrt14v2df */

            default:
              return -1;
            }

        case 156:
          return recog_209 (x1, insn, pnum_clobbers);

        case 46:
          return recog_205 (x1, insn, pnum_clobbers);

        case 172:
          return recog_210 (x1, insn, pnum_clobbers);

        case 173:
          return recog_208 (x1, insn, pnum_clobbers);

        case 165:
          return recog_207 (x1, insn, pnum_clobbers);

        case 127:
          x4 = XVECEXP (x2, 0, 0);
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_V8DImode:
              if (!register_operand (operands[0], E_V8DImode)
                  || GET_MODE (x2) != E_V8DImode
                  || !memory_operand (operands[1], E_V8DImode)
                  || !(
#line 23782 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 707 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 8644; /* avx512f_movntdqa */

            case E_V4DImode:
              if (!register_operand (operands[0], E_V4DImode)
                  || GET_MODE (x2) != E_V4DImode
                  || !memory_operand (operands[1], E_V4DImode)
                  || !(
#line 23782 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 707 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return -1;
              return 8645; /* avx2_movntdqa */

            case E_V2DImode:
              if (!register_operand (operands[0], E_V2DImode)
                  || GET_MODE (x2) != E_V2DImode
                  || !memory_operand (operands[1], E_V2DImode)
                  || !
#line 23782 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                return -1;
              return 8646; /* sse4_1_movntdqa */

            default:
              return -1;
            }

        case 129:
          if (GET_MODE (x2) != E_V8HImode
              || !register_operand (operands[0], E_V8HImode))
            return -1;
          x4 = XVECEXP (x2, 0, 0);
          operands[1] = x4;
          if (!vector_operand (operands[1], E_V8HImode)
              || !
#line 24108 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return -1;
          return 8679; /* sse4_1_phminposuw */

        case 136:
          x4 = XVECEXP (x2, 0, 0);
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (!register_operand (operands[0], E_V4SFmode)
                  || GET_MODE (x2) != E_V4SFmode
                  || !nonimmediate_operand (operands[1], E_V4SFmode)
                  || !
#line 26995 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8982; /* xop_frczv4sf2 */

            case E_V2DFmode:
              if (!register_operand (operands[0], E_V2DFmode)
                  || GET_MODE (x2) != E_V2DFmode
                  || !nonimmediate_operand (operands[1], E_V2DFmode)
                  || !
#line 26995 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8983; /* xop_frczv2df2 */

            case E_V8SFmode:
              if (!register_operand (operands[0], E_V8SFmode)
                  || GET_MODE (x2) != E_V8SFmode
                  || !nonimmediate_operand (operands[1], E_V8SFmode)
                  || !
#line 26995 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8984; /* xop_frczv8sf2 */

            case E_V4DFmode:
              if (!register_operand (operands[0], E_V4DFmode)
                  || GET_MODE (x2) != E_V4DFmode
                  || !nonimmediate_operand (operands[1], E_V4DFmode)
                  || !
#line 26995 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                return -1;
              return 8985; /* xop_frczv4df2 */

            default:
              return -1;
            }

        case 134:
          x4 = XVECEXP (x2, 0, 0);
          switch (GET_CODE (x4))
            {
            case NE:
            case EQ:
            case GEU:
            case GTU:
            case LEU:
            case LTU:
              operands[1] = x4;
              x5 = XEXP (x4, 0);
              operands[2] = x5;
              x6 = XEXP (x4, 1);
              operands[3] = x6;
              switch (GET_MODE (operands[0]))
                {
                case E_V16QImode:
                  if (pattern1005 (x2, 
E_V16QImode) != 0
                      || !
#line 27058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                    return -1;
                  return 8996; /* xop_maskcmp_uns2v16qi3 */

                case E_V8HImode:
                  if (pattern1005 (x2, 
E_V8HImode) != 0
                      || !
#line 27058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                    return -1;
                  return 8997; /* xop_maskcmp_uns2v8hi3 */

                case E_V4SImode:
                  if (pattern1005 (x2, 
E_V4SImode) != 0
                      || !
#line 27058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                    return -1;
                  return 8998; /* xop_maskcmp_uns2v4si3 */

                case E_V2DImode:
                  if (pattern1005 (x2, 
E_V2DImode) != 0
                      || !
#line 27058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
                    return -1;
                  return 8999; /* xop_maskcmp_uns2v2di3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 141:
          if (GET_MODE (x2) != E_V2DImode
              || !register_operand (operands[0], E_V2DImode))
            return -1;
          x4 = XVECEXP (x2, 0, 0);
          operands[1] = x4;
          if (!vector_operand (operands[1], E_V2DImode)
              || !
#line 27172 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AES))
            return -1;
          return 9012; /* aesimc */

        case 149:
          x4 = XVECEXP (x2, 0, 0);
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (!register_operand (operands[0], E_V4SFmode)
                  || GET_MODE (x2) != E_V4SFmode
                  || !memory_operand (operands[1], E_V4HImode)
                  || !
#line 29090 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL))
                return -1;
              return 9575; /* *vcvtph2ps_load */

            case E_V8SFmode:
              if (!register_operand (operands[0], E_V8SFmode)
                  || GET_MODE (x2) != E_V8SFmode
                  || !nonimmediate_operand (operands[1], E_V8HImode)
                  || !
#line 29100 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL))
                return -1;
              return 9577; /* vcvtph2ps256 */

            case E_V16SFmode:
              if (!register_operand (operands[0], E_V16SFmode)
                  || GET_MODE (x2) != E_V16SFmode
                  || !vector_operand (operands[1], E_V16HImode)
                  || !
#line 29112 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                return -1;
              return 9579; /* *avx512f_vcvtph2ps512 */

            default:
              return -1;
            }

        case 168:
          return recog_214 (x1, insn, pnum_clobbers);

        case 253:
          switch (pattern324 (x2))
            {
            case 0:
              if (!
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10427; /* vcvtph2bf8v16hf */

            case 1:
              if (!
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10435; /* vcvtph2bf8v32hf */

            default:
              return -1;
            }

        case 254:
          switch (pattern324 (x2))
            {
            case 0:
              if (!
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10429; /* vcvtph2bf8sv16hf */

            case 1:
              if (!
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10437; /* vcvtph2bf8sv32hf */

            default:
              return -1;
            }

        case 255:
          switch (pattern324 (x2))
            {
            case 0:
              if (!
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10431; /* vcvtph2hf8v16hf */

            case 1:
              if (!
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10439; /* vcvtph2hf8v32hf */

            default:
              return -1;
            }

        case 256:
          switch (pattern324 (x2))
            {
            case 0:
              if (!
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10433; /* vcvtph2hf8sv16hf */

            case 1:
              if (!
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10441; /* vcvtph2hf8sv32hf */

            default:
              return -1;
            }

        case 257:
          x4 = XVECEXP (x2, 0, 0);
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (!register_operand (operands[0], E_V32HFmode)
                  || GET_MODE (x2) != E_V32HFmode
                  || !nonimmediate_operand (operands[1], E_V32QImode)
                  || !
#line 31931 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10443; /* vcvthf82phv32hf */

            case E_V16HFmode:
              if (!register_operand (operands[0], E_V16HFmode)
                  || GET_MODE (x2) != E_V16HFmode
                  || !nonimmediate_operand (operands[1], E_V16QImode)
                  || !
#line 31931 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10445; /* vcvthf82phv16hf */

            case E_V8HFmode:
              if (!register_operand (operands[0], E_V8HFmode)
                  || GET_MODE (x2) != E_V8HFmode
                  || !nonimmediate_operand (operands[1], E_V16QImode)
                  || !
#line 31931 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10447; /* vcvthf82phv8hf */

            default:
              return -1;
            }

        case 263:
          switch (pattern325 (x2, 
E_V32BFmode, 
E_V16BFmode, 
E_V8BFmode))
            {
            case 0:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10656; /* avx10_2_cvtbf162ibsv32bf */

            case 1:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10664; /* avx10_2_cvtbf162ibsv16bf */

            case 2:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10672; /* avx10_2_cvtbf162ibsv8bf */

            default:
              return -1;
            }

        case 264:
          switch (pattern325 (x2, 
E_V32BFmode, 
E_V16BFmode, 
E_V8BFmode))
            {
            case 0:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10658; /* avx10_2_cvtbf162iubsv32bf */

            case 1:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10666; /* avx10_2_cvtbf162iubsv16bf */

            case 2:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10674; /* avx10_2_cvtbf162iubsv8bf */

            default:
              return -1;
            }

        case 269:
          switch (pattern325 (x2, 
E_V32BFmode, 
E_V16BFmode, 
E_V8BFmode))
            {
            case 0:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10660; /* avx10_2_cvttbf162ibsv32bf */

            case 1:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10668; /* avx10_2_cvttbf162ibsv16bf */

            case 2:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10676; /* avx10_2_cvttbf162ibsv8bf */

            default:
              return -1;
            }

        case 270:
          switch (pattern325 (x2, 
E_V32BFmode, 
E_V16BFmode, 
E_V8BFmode))
            {
            case 0:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10662; /* avx10_2_cvttbf162iubsv32bf */

            case 1:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10670; /* avx10_2_cvttbf162iubsv16bf */

            case 2:
              if (!
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10678; /* avx10_2_cvttbf162iubsv8bf */

            default:
              return -1;
            }

        case 265:
          switch (pattern325 (x2, 
E_V32HFmode, 
E_V16HFmode, 
E_V8HFmode))
            {
            case 0:
              if (!(
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10680; /* avx10_2_cvtph2ibsv32hf */

            case 1:
              if (!
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10688; /* avx10_2_cvtph2ibsv16hf */

            case 2:
              if (!
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10692; /* avx10_2_cvtph2ibsv8hf */

            default:
              return -1;
            }

        case 266:
          switch (pattern325 (x2, 
E_V32HFmode, 
E_V16HFmode, 
E_V8HFmode))
            {
            case 0:
              if (!(
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10684; /* avx10_2_cvtph2iubsv32hf */

            case 1:
              if (!
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10690; /* avx10_2_cvtph2iubsv16hf */

            case 2:
              if (!
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10694; /* avx10_2_cvtph2iubsv8hf */

            default:
              return -1;
            }

        case 271:
          switch (pattern325 (x2, 
E_V32HFmode, 
E_V16HFmode, 
E_V8HFmode))
            {
            case 0:
              if (!(
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10696; /* avx10_2_cvttph2ibsv32hf */

            case 1:
              if (!
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10704; /* avx10_2_cvttph2ibsv16hf */

            case 2:
              if (!
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10708; /* avx10_2_cvttph2ibsv8hf */

            default:
              return -1;
            }

        case 272:
          switch (pattern325 (x2, 
E_V32HFmode, 
E_V16HFmode, 
E_V8HFmode))
            {
            case 0:
              if (!(
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10700; /* avx10_2_cvttph2iubsv32hf */

            case 1:
              if (!
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10706; /* avx10_2_cvttph2iubsv16hf */

            case 2:
              if (!
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10710; /* avx10_2_cvttph2iubsv8hf */

            default:
              return -1;
            }

        case 267:
          switch (pattern326 (x2))
            {
            case 0:
              if (!(
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10712; /* avx10_2_cvtps2ibsv16sf */

            case 1:
              if (!
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10720; /* avx10_2_cvtps2ibsv8sf */

            case 2:
              if (!
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10724; /* avx10_2_cvtps2ibsv4sf */

            default:
              return -1;
            }

        case 268:
          switch (pattern326 (x2))
            {
            case 0:
              if (!(
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10716; /* avx10_2_cvtps2iubsv16sf */

            case 1:
              if (!
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10722; /* avx10_2_cvtps2iubsv8sf */

            case 2:
              if (!
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10726; /* avx10_2_cvtps2iubsv4sf */

            default:
              return -1;
            }

        case 273:
          switch (pattern326 (x2))
            {
            case 0:
              if (!(
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10728; /* avx10_2_cvttps2ibsv16sf */

            case 1:
              if (!
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10736; /* avx10_2_cvttps2ibsv8sf */

            case 2:
              if (!
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10740; /* avx10_2_cvttps2ibsv4sf */

            default:
              return -1;
            }

        case 274:
          switch (pattern326 (x2))
            {
            case 0:
              if (!(
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10732; /* avx10_2_cvttps2iubsv16sf */

            case 1:
              if (!
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10738; /* avx10_2_cvttps2iubsv8sf */

            case 2:
              if (!
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10742; /* avx10_2_cvttps2iubsv4sf */

            default:
              return -1;
            }

        case 275:
          switch (pattern327 (x2))
            {
            case 0:
              if (!(
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 385 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10744; /* avx10_2_vcvttps2dqsv16sf */

            case 1:
              if (!
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10752; /* avx10_2_vcvttps2dqsv8sf */

            case 2:
              if (!(
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 386 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10760; /* avx10_2_vcvttpd2dqsv8df */

            case 3:
              if (!
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10756; /* avx10_2_vcvttps2dqsv4sf */

            case 4:
              if (!
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10768; /* avx10_2_vcvttpd2dqsv4df */

            case 5:
              if (!
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10772; /* avx10_2_vcvttpd2dqsv2df */

            case 6:
              if (!(
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 450 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10776; /* avx10_2_vcvttpd2qqsv8df */

            case 7:
              if (!(
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 617 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10792; /* avx10_2_vcvttps2qqsv8di */

            case 8:
              if (!
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10784; /* avx10_2_vcvttpd2qqsv4df */

            case 9:
              if (!
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10800; /* avx10_2_vcvttps2qqsv4di */

            case 10:
              if (!
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10788; /* avx10_2_vcvttpd2qqsv2df */

            case 11:
              if (!
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10804; /* avx10_2_vcvttps2qqsv2di */

            default:
              return -1;
            }

        case 276:
          switch (pattern327 (x2))
            {
            case 0:
              if (!(
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 385 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10748; /* avx10_2_vcvttps2udqsv16sf */

            case 1:
              if (!
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10754; /* avx10_2_vcvttps2udqsv8sf */

            case 2:
              if (!(
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 386 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10764; /* avx10_2_vcvttpd2udqsv8df */

            case 3:
              if (!
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10758; /* avx10_2_vcvttps2udqsv4sf */

            case 4:
              if (!
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10770; /* avx10_2_vcvttpd2udqsv4df */

            case 5:
              if (!
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10774; /* avx10_2_vcvttpd2udqsv2df */

            case 6:
              if (!(
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 450 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10780; /* avx10_2_vcvttpd2uqqsv8df */

            case 7:
              if (!(
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 617 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10796; /* avx10_2_vcvttps2uqqsv8di */

            case 8:
              if (!
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10786; /* avx10_2_vcvttpd2uqqsv4df */

            case 9:
              if (!
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10802; /* avx10_2_vcvttps2uqqsv4di */

            case 10:
              if (!
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10790; /* avx10_2_vcvttpd2uqqsv2df */

            case 11:
              if (!
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1))
                return -1;
              return 10806; /* avx10_2_vcvttps2uqqsv2di */

            default:
              return -1;
            }

        case 279:
          return recog_206 (x1, insn, pnum_clobbers);

        default:
          return -1;
        }

    case 2:
      return recog_263 (x1, insn, pnum_clobbers);

    case 3:
      return recog_262 (x1, insn, pnum_clobbers);

    case 4:
      return recog_261 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_321 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      if (nonimmediate_operand (operands[0], E_V64QImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V64QImode)
          && (
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V64QImode)
       || register_operand (operands[1], V64QImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return 2395; /* movv64qi_internal */
      if (!register_operand (operands[0], E_V64QImode)
          || !ternlog_operand (operands[1], E_V64QImode)
          || !(
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 5404; /* *avx512bw_vpternlogv64qi_0 */

    case E_V32QImode:
      if (nonimmediate_operand (operands[0], E_V32QImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V32QImode)
          && (
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V32QImode)
       || register_operand (operands[1], V32QImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 2396; /* movv32qi_internal */
      if (!register_operand (operands[0], E_V32QImode)
          || !ternlog_operand (operands[1], E_V32QImode)
          || !(
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 5405; /* *avx512vl_vpternlogv32qi_0 */

    case E_V16QImode:
      if (nonimmediate_operand (operands[0], E_V16QImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V16QImode)
          && 
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V16QImode)
       || register_operand (operands[1], V16QImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2397; /* movv16qi_internal */
      if (!register_operand (operands[0], E_V16QImode)
          || !ternlog_operand (operands[1], E_V16QImode)
          || !
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
        return -1;
      return 5406; /* *avx512vl_vpternlogv16qi_0 */

    case E_V32HImode:
      if (nonimmediate_operand (operands[0], E_V32HImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V32HImode)
          && (
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V32HImode)
       || register_operand (operands[1], V32HImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 283 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return 2398; /* movv32hi_internal */
      if (!register_operand (operands[0], E_V32HImode)
          || !ternlog_operand (operands[1], E_V32HImode)
          || !(
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 5407; /* *avx512bw_vpternlogv32hi_0 */

    case E_V16HImode:
      if (nonimmediate_operand (operands[0], E_V16HImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V16HImode)
          && (
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V16HImode)
       || register_operand (operands[1], V16HImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 283 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 2399; /* movv16hi_internal */
      if (!register_operand (operands[0], E_V16HImode)
          || !ternlog_operand (operands[1], E_V16HImode)
          || !(
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 5408; /* *avx512vl_vpternlogv16hi_0 */

    case E_V8HImode:
      if (nonimmediate_operand (operands[0], E_V8HImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V8HImode)
          && 
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V8HImode)
       || register_operand (operands[1], V8HImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2400; /* movv8hi_internal */
      if (!register_operand (operands[0], E_V8HImode)
          || !ternlog_operand (operands[1], E_V8HImode)
          || !
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
        return -1;
      return 5409; /* *avx512vl_vpternlogv8hi_0 */

    case E_V16SImode:
      if (nonimmediate_operand (operands[0], E_V16SImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V16SImode)
          && (
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V16SImode)
       || register_operand (operands[1], V16SImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 284 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return 2401; /* movv16si_internal */
      if (!register_operand (operands[0], E_V16SImode)
          || !ternlog_operand (operands[1], E_V16SImode)
          || !(
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 5410; /* *avx512f_vpternlogv16si_0 */

    case E_V8SImode:
      if (nonimmediate_operand (operands[0], E_V8SImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V8SImode)
          && (
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V8SImode)
       || register_operand (operands[1], V8SImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 284 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 2402; /* movv8si_internal */
      if (!register_operand (operands[0], E_V8SImode)
          || !ternlog_operand (operands[1], E_V8SImode)
          || !(
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 5411; /* *avx512vl_vpternlogv8si_0 */

    case E_V4SImode:
      if (nonimmediate_operand (operands[0], E_V4SImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V4SImode)
          && 
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V4SImode)
       || register_operand (operands[1], V4SImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2403; /* movv4si_internal */
      if (!register_operand (operands[0], E_V4SImode)
          || !ternlog_operand (operands[1], E_V4SImode)
          || !
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
        return -1;
      return 5412; /* *avx512vl_vpternlogv4si_0 */

    case E_V8DImode:
      if (nonimmediate_operand (operands[0], E_V8DImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V8DImode)
          && (
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V8DImode)
       || register_operand (operands[1], V8DImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return 2404; /* movv8di_internal */
      if (!register_operand (operands[0], E_V8DImode)
          || !ternlog_operand (operands[1], E_V8DImode)
          || !(
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 5413; /* *avx512f_vpternlogv8di_0 */

    case E_V4DImode:
      if (nonimmediate_operand (operands[0], E_V4DImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V4DImode)
          && (
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V4DImode)
       || register_operand (operands[1], V4DImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return 2405; /* movv4di_internal */
      if (!register_operand (operands[0], E_V4DImode)
          || !ternlog_operand (operands[1], E_V4DImode)
          || !(
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 5414; /* *avx512vl_vpternlogv4di_0 */

    case E_V2DImode:
      if (nonimmediate_operand (operands[0], E_V2DImode)
          && nonimmediate_or_sse_const_operand (operands[1], E_V2DImode)
          && 
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V2DImode)
       || register_operand (operands[1], V2DImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2406; /* movv2di_internal */
      if (!register_operand (operands[0], E_V2DImode)
          || !ternlog_operand (operands[1], E_V2DImode)
          || !
#line 13733 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
        return -1;
      return 5415; /* *avx512vl_vpternlogv2di_0 */

    case E_V4TImode:
      if (!nonimmediate_operand (operands[0], E_V4TImode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V4TImode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V4TImode)
       || register_operand (operands[1], V4TImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 2407; /* movv4ti_internal */

    case E_V2TImode:
      if (!nonimmediate_operand (operands[0], E_V2TImode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V2TImode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V2TImode)
       || register_operand (operands[1], V2TImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 286 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2408; /* movv2ti_internal */

    case E_V1TImode:
      if (!nonimmediate_operand (operands[0], E_V1TImode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V1TImode)
          || !
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V1TImode)
       || register_operand (operands[1], V1TImode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 2409; /* movv1ti_internal */

    case E_V32HFmode:
      if (!nonimmediate_operand (operands[0], E_V32HFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V32HFmode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V32HFmode)
       || register_operand (operands[1], V32HFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 287 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 2410; /* movv32hf_internal */

    case E_V16HFmode:
      if (!nonimmediate_operand (operands[0], E_V16HFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V16HFmode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V16HFmode)
       || register_operand (operands[1], V16HFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 287 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2411; /* movv16hf_internal */

    case E_V8HFmode:
      if (!nonimmediate_operand (operands[0], E_V8HFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V8HFmode)
          || !
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V8HFmode)
       || register_operand (operands[1], V8HFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 2412; /* movv8hf_internal */

    case E_V32BFmode:
      if (!nonimmediate_operand (operands[0], E_V32BFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V32BFmode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V32BFmode)
       || register_operand (operands[1], V32BFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 288 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 2413; /* movv32bf_internal */

    case E_V16BFmode:
      if (!nonimmediate_operand (operands[0], E_V16BFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V16BFmode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V16BFmode)
       || register_operand (operands[1], V16BFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 288 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2414; /* movv16bf_internal */

    case E_V8BFmode:
      if (!nonimmediate_operand (operands[0], E_V8BFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V8BFmode)
          || !
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V8BFmode)
       || register_operand (operands[1], V8BFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 2415; /* movv8bf_internal */

    case E_V16SFmode:
      if (!nonimmediate_operand (operands[0], E_V16SFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V16SFmode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V16SFmode)
       || register_operand (operands[1], V16SFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 289 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 2416; /* movv16sf_internal */

    case E_V8SFmode:
      if (!nonimmediate_operand (operands[0], E_V8SFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V8SFmode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V8SFmode)
       || register_operand (operands[1], V8SFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 289 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2417; /* movv8sf_internal */

    case E_V4SFmode:
      if (!nonimmediate_operand (operands[0], E_V4SFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V4SFmode)
          || !
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V4SFmode)
       || register_operand (operands[1], V4SFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 2418; /* movv4sf_internal */

    case E_V8DFmode:
      if (!nonimmediate_operand (operands[0], E_V8DFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V8DFmode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V8DFmode)
       || register_operand (operands[1], V8DFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 290 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 2419; /* movv8df_internal */

    case E_V4DFmode:
      if (!nonimmediate_operand (operands[0], E_V4DFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V4DFmode)
          || !(
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V4DFmode)
       || register_operand (operands[1], V4DFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])) && 
#line 290 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2420; /* movv4df_internal */

    case E_V2DFmode:
      if (!nonimmediate_operand (operands[0], E_V2DFmode)
          || !nonimmediate_or_sse_const_operand (operands[1], E_V2DFmode)
          || !
#line 1507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && (register_operand (operands[0], V2DFmode)
       || register_operand (operands[1], V2DFmode))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 2421; /* movv2df_internal */

    default:
      return -1;
    }
}

 int
recog_328 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          switch (pattern515 (x3))
            {
            case 0:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4408; /* avx512fp16_vcvtw2ph_v8hi */

            case 1:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4432; /* avx512fp16_vcvtdq2ph_v8si */

            case 2:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4448; /* avx512fp16_vcvtqq2ph_v8di */

            default:
              return -1;
            }

        case E_V16HFmode:
          switch (pattern516 (x3))
            {
            case 0:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4416; /* avx512fp16_vcvtw2ph_v16hi */

            case 1:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4440; /* avx512fp16_vcvtdq2ph_v16si */

            default:
              return -1;
            }

        case E_V32HFmode:
          if (!register_operand (operands[0], E_V32HFmode)
              || GET_MODE (x3) != E_V32HFmode
              || !vector_operand (operands[1], E_V32HImode)
              || !(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4424; /* avx512fp16_vcvtw2ph_v32hi */

        case E_V16SFmode:
          if (!register_operand (operands[0], E_V16SFmode)
              || GET_MODE (x3) != E_V16SFmode
              || !vector_operand (operands[1], E_V16SImode)
              || !(
#line 8628 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1) && 
#line 433 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 4744; /* floatv16siv16sf2 */

        case E_V8SFmode:
          if (!register_operand (operands[0], E_V8SFmode)
              || GET_MODE (x3) != E_V8SFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8SImode:
              if (!vector_operand (operands[1], E_V8SImode)
                  || !(
#line 8628 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1) && 
#line 433 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 4748; /* floatv8siv8sf2 */

            case E_V8DImode:
              if (!nonimmediate_operand (operands[1], E_V8DImode)
                  || !(
#line 9175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4900; /* floatv8div8sf2 */

            default:
              return -1;
            }

        case E_V4SFmode:
          if (!register_operand (operands[0], E_V4SFmode)
              || GET_MODE (x3) != E_V4SFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!vector_operand (operands[1], E_V4SImode)
                  || !
#line 8628 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
                return -1;
              return 4750; /* floatv4siv4sf2 */

            case E_V4DImode:
              if (!nonimmediate_operand (operands[1], E_V4DImode)
                  || !(
#line 9175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4908; /* floatv4div4sf2 */

            default:
              return -1;
            }

        case E_V2DFmode:
          switch (pattern517 (x3))
            {
            case 0:
              if (!
#line 8857 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return -1;
              return 4824; /* sse2_cvtpi2pd */

            case 1:
              if (!(
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4892; /* floatv2div2df2 */

            default:
              return -1;
            }

        case E_V8DFmode:
          switch (pattern518 (x3, 
E_V8DFmode))
            {
            case 0:
              if (!(
#line 9151 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1) && 
#line 467 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 4872; /* floatv8siv8df2 */

            case 1:
              if (!(
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4876; /* floatv8div8df2 */

            default:
              return -1;
            }

        case E_V4DFmode:
          switch (pattern519 (x3, 
E_V4DFmode))
            {
            case 0:
              if (!
#line 9151 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
                return -1;
              return 4874; /* floatv4siv4df2 */

            case 1:
              if (!(
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4884; /* floatv4div4df2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != PARALLEL)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      switch (XVECLEN (x5, 0))
        {
        case 8:
          if (pattern665 (x5) != 0
              || pattern916 (x3, 
E_V16SImode, 
E_V8SImode, 
E_V8DFmode) != 0
              || !
#line 9352 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 4924; /* avx512f_cvtdq2pd512_2 */

        case 4:
          if (pattern666 (x5, 
3, 
2, 
1) != 0
              || pattern916 (x3, 
E_V8SImode, 
E_V4SImode, 
E_V4DFmode) != 0
              || !
#line 9365 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 4925; /* avx_cvtdq2pd256_2 */

        case 2:
          x7 = XVECEXP (x5, 0, 0);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x8 = XVECEXP (x5, 0, 1);
          if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || pattern916 (x3, 
E_V4SImode, 
E_V2SImode, 
E_V2DFmode) != 0
              || !
#line 9377 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1))
            return -1;
          return 4926; /* sse2_cvtdq2pd */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_333 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          switch (pattern515 (x3))
            {
            case 0:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4412; /* avx512fp16_vcvtuw2ph_v8hi */

            case 1:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4436; /* avx512fp16_vcvtudq2ph_v8si */

            case 2:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4452; /* avx512fp16_vcvtuqq2ph_v8di */

            default:
              return -1;
            }

        case E_V16HFmode:
          switch (pattern516 (x3))
            {
            case 0:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4420; /* avx512fp16_vcvtuw2ph_v16hi */

            case 1:
              if (!(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4444; /* avx512fp16_vcvtudq2ph_v16si */

            default:
              return -1;
            }

        case E_V32HFmode:
          if (!register_operand (operands[0], E_V32HFmode)
              || GET_MODE (x3) != E_V32HFmode
              || !vector_operand (operands[1], E_V32HImode)
              || !(
#line 7650 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4428; /* avx512fp16_vcvtuw2ph_v32hi */

        case E_V16SFmode:
          if (!register_operand (operands[0], E_V16SFmode)
              || GET_MODE (x3) != E_V16SFmode
              || !nonimmediate_operand (operands[1], E_V16SImode)
              || !(
#line 8641 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4752; /* *floatunsv16siv16sf2 */

        case E_V8SFmode:
          switch (pattern518 (x3, 
E_V8SFmode))
            {
            case 0:
              if (!(
#line 8641 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4756; /* *floatunsv8siv8sf2 */

            case 1:
              if (!(
#line 9175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4904; /* floatunsv8div8sf2 */

            default:
              return -1;
            }

        case E_V4SFmode:
          switch (pattern519 (x3, 
E_V4SFmode))
            {
            case 0:
              if (!(
#line 8641 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4760; /* *floatunsv4siv4sf2 */

            case 1:
              if (!(
#line 9175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4910; /* floatunsv4div4sf2 */

            default:
              return -1;
            }

        case E_V2DFmode:
          switch (pattern517 (x3))
            {
            case 0:
              if (!
#line 8877 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_MMX_WITH_SSE && TARGET_AVX512VL))
                return -1;
              return 4825; /* floatunsv2siv2df2 */

            case 1:
              if (!(
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4896; /* floatunsv2div2df2 */

            default:
              return -1;
            }

        case E_V8DFmode:
          if (!register_operand (operands[0], E_V8DFmode)
              || GET_MODE (x3) != E_V8DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8DImode:
              if (!nonimmediate_operand (operands[1], E_V8DImode)
                  || !(
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4880; /* floatunsv8div8df2 */

            case E_V8SImode:
              if (!nonimmediate_operand (operands[1], E_V8SImode)
                  || !(
#line 9325 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4918; /* floatunsv8siv8df2 */

            default:
              return -1;
            }

        case E_V4DFmode:
          if (!register_operand (operands[0], E_V4DFmode)
              || GET_MODE (x3) != E_V4DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4DImode:
              if (!nonimmediate_operand (operands[1], E_V4DImode)
                  || !(
#line 9161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4888; /* floatunsv4div4df2 */

            case E_V4SImode:
              if (!nonimmediate_operand (operands[1], E_V4SImode)
                  || !(
#line 9325 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4920; /* floatunsv4siv4df2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      if (GET_MODE (x4) != E_V2SImode)
        return -1;
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != PARALLEL
          || XVECLEN (x5, 0) != 2)
        return -1;
      x6 = XVECEXP (x5, 0, 0);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XVECEXP (x5, 0, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode)
        return -1;
      x8 = XEXP (x4, 0);
      operands[1] = x8;
      if (!nonimmediate_operand (operands[1], E_V4SImode)
          || !
#line 9337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return -1;
      return 4922; /* *floatunsv2siv2df2 */

    default:
      return -1;
    }
}

 int
recog_341 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern28 (x1))
    {
    case 0:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4546; /* avx512fp16_fixuns_truncv8hi2 */

    case 1:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4554; /* avx512fp16_fixuns_truncv16hi2 */

    case 2:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4562; /* avx512fp16_fixuns_truncv32hi2 */

    case 3:
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4570; /* avx512fp16_fixuns_truncv8si2 */

        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode)
              || !
#line 9557 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 4961; /* fixuns_truncv8dfv8si2 */

        case E_V8SFmode:
          if (!nonimmediate_operand (operands[1], E_V8SFmode)
              || !(
#line 9900 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 440 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5062; /* *fixuns_truncv8sfv8si2 */

        default:
          return -1;
        }

    case 4:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4578; /* avx512fp16_fixuns_truncv16si2 */

    case 5:
      if (!
#line 8764 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 4812; /* fixuns_truncv16sfv16si2 */

    case 6:
      if (!(
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4586; /* avx512fp16_fixuns_truncv8di2 */

    case 7:
      if (!(
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4998; /* fixuns_truncv8dfv8di2 */

    case 8:
      if (!(
#line 9729 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 5042; /* fixuns_truncv8sfv8di2 */

    case 9:
      switch (GET_MODE (operands[1]))
        {
        case E_V4HFmode:
          if (!memory_operand (operands[1], E_V4HFmode)
              || !
#line 7919 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4608; /* *avx512fp16_fixuns_truncv4si2_load */

        case E_V4DFmode:
          if (!nonimmediate_operand (operands[1], E_V4DFmode)
              || !
#line 9665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512F))
            return -1;
          return 4976; /* fixuns_truncv4dfv4si2 */

        case E_V4SFmode:
          if (!nonimmediate_operand (operands[1], E_V4SFmode)
              || !
#line 9900 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 5064; /* *fixuns_truncv4sfv4si2 */

        default:
          return -1;
        }

    case 10:
      if (!
#line 7919 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4612; /* *avx512fp16_fixuns_truncv4di2_load */

    case 11:
      if (!(
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 5004; /* fixuns_truncv4dfv4di2 */

    case 12:
      if (!(
#line 9729 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 5048; /* fixuns_truncv4sfv4di2 */

    case 13:
      if (!
#line 7969 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4624; /* *avx512fp16_fixuns_truncv2di2_load */

    case 14:
      if (!(
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 5008; /* fixuns_truncv2dfv2di2 */

    case 15:
      if (!
#line 7909 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4600; /* avx512fp16_fixuns_truncv4si2 */

    case 16:
      if (!
#line 7909 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4604; /* avx512fp16_fixuns_truncv4di2 */

    case 17:
      if (!
#line 7959 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4620; /* avx512fp16_fixuns_truncv2di2 */

    case 18:
      if (!
#line 9752 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
        return -1;
      return 5056; /* avx512dq_fixuns_truncv2sfv2di2 */

    default:
      return -1;
    }
}

 int
recog_346 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x3) != E_V16SImode
          || !nonimmediate_operand (operands[1], E_V16SImode)
          || !(
#line 29938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9986; /* clzv16si2 */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x3) != E_V8SImode
          || !nonimmediate_operand (operands[1], E_V8SImode)
          || !(
#line 29938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9988; /* clzv8si2 */

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || !nonimmediate_operand (operands[1], E_V4SImode)
          || !(
#line 29938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9990; /* clzv4si2 */

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x3) != E_V8DImode
          || !nonimmediate_operand (operands[1], E_V8DImode)
          || !(
#line 29938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9992; /* clzv8di2 */

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x3) != E_V4DImode
          || !nonimmediate_operand (operands[1], E_V4DImode)
          || !(
#line 29938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9994; /* clzv4di2 */

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x3) != E_V2DImode
          || !nonimmediate_operand (operands[1], E_V2DImode)
          || !(
#line 29938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9996; /* clzv2di2 */

    default:
      return -1;
    }
}

 int
recog_350 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  res = recog_269 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  operands[1] = x3;
  operands[2] = x4;
  x5 = XEXP (x3, 1);
  operands[3] = x5;
  switch (GET_CODE (operands[1]))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
      switch (GET_MODE (operands[0]))
        {
        case E_V16QImode:
          if (pattern794 (
E_V16QImode) == 0
              && 
#line 27033 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return 8988; /* xop_maskcmpv16qi3 */
          break;

        case E_V8HImode:
          if (pattern794 (
E_V8HImode) == 0
              && 
#line 27033 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return 8989; /* xop_maskcmpv8hi3 */
          break;

        case E_V4SImode:
          if (pattern794 (
E_V4SImode) == 0
              && 
#line 27033 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return 8990; /* xop_maskcmpv4si3 */
          break;

        case E_V2DImode:
          if (pattern794 (
E_V2DImode) == 0
              && 
#line 27033 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return 8991; /* xop_maskcmpv2di3 */
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  switch (GET_CODE (operands[1]))
    {
    case NE:
    case EQ:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
      switch (GET_MODE (operands[0]))
        {
        case E_V16QImode:
          if (pattern795 (
E_V16QImode) != 0
              || !
#line 27043 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8992; /* xop_maskcmp_unsv16qi3 */

        case E_V8HImode:
          if (pattern795 (
E_V8HImode) != 0
              || !
#line 27043 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8993; /* xop_maskcmp_unsv8hi3 */

        case E_V4SImode:
          if (pattern795 (
E_V4SImode) != 0
              || !
#line 27043 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8994; /* xop_maskcmp_unsv4si3 */

        case E_V2DImode:
          if (pattern795 (
E_V2DImode) != 0
              || !
#line 27043 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8995; /* xop_maskcmp_unsv2di3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_355 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
    case MEM:
      res = recog_353 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    case STRICT_LOW_PART:
      x4 = XVECEXP (x1, 0, 1);
      if (pattern231 (x4, 
E_CCmode, 
17) == 0)
        {
          x5 = XEXP (x3, 0);
          operands[0] = x5;
          x6 = XEXP (x2, 1);
          operands[1] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (register_operand (operands[0], E_QImode)
                  && const0_operand (operands[1], E_QImode)
                  && 
#line 3462 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return 113; /* *movstrictqi_xor */
              break;

            case E_HImode:
              if (register_operand (operands[0], E_HImode)
                  && const0_operand (operands[1], E_HImode)
                  && 
#line 3462 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return 114; /* *movstricthi_xor */
              break;

            default:
              break;
            }
        }
      break;

    case PC:
      res = recog_354 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    default:
      break;
    }
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x7 = XEXP (x4, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 17
      || GET_MODE (x7) != E_CCmode)
    return -1;
  x6 = XEXP (x2, 1);
  switch (GET_CODE (x6))
    {
    case SUBREG:
      if (maybe_ne (SUBREG_BYTE (x6), 0))
        return -1;
      switch (pattern1029 (x2))
        {
        case 0:
          x8 = XEXP (x6, 0);
          x9 = XEXP (x8, 1);
          operands[2] = x9;
          if (general_operand (operands[2], E_QImode))
            {
              switch (pattern1027 (x2))
                {
                case 0:
                  return 333; /* *addqi_exthi_1 */

                case 1:
                  return 334; /* *addqi_extsi_1 */

                case 2:
                  if (
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return 335; /* *addqi_extdi_1 */
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x9) != SUBREG)
            return -1;
          switch (pattern1806 (x2))
            {
            case 0:
              return 336; /* *addqi_exthi_2 */

            case 1:
              return 338; /* *addqi_extsi_2 */

            case 2:
              if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 340; /* *addqi_extdi_2 */

            default:
              return -1;
            }

        case 1:
          x8 = XEXP (x6, 0);
          x9 = XEXP (x8, 1);
          if (GET_CODE (x9) == SUBREG)
            {
              switch (pattern1806 (x2))
                {
                case 0:
                  return 337; /* *subqi_exthi_2 */

                case 1:
                  return 339; /* *subqi_extsi_2 */

                case 2:
                  if (
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return 341; /* *subqi_extdi_2 */
                  break;

                default:
                  break;
                }
            }
          operands[2] = x9;
          if (!general_operand (operands[2], E_QImode))
            return -1;
          switch (pattern1027 (x2))
            {
            case 0:
              return 422; /* *subqi_exthi_1 */

            case 1:
              return 423; /* *subqi_extsi_1 */

            case 2:
              if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 424; /* *subqi_extdi_1 */

            default:
              return -1;
            }

        case 2:
          x8 = XEXP (x6, 0);
          x9 = XEXP (x8, 1);
          operands[2] = x9;
          if (general_operand (operands[2], E_QImode))
            {
              switch (pattern1027 (x2))
                {
                case 0:
                  return 773; /* *andqi_exthi_1 */

                case 1:
                  return 776; /* *andqi_extsi_1 */

                case 2:
                  if (
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return 779; /* *andqi_extdi_1 */
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x9) != SUBREG)
            return -1;
          switch (pattern1806 (x2))
            {
            case 0:
              return 791; /* *andqi_exthi_2 */

            case 1:
              return 794; /* *andqi_extsi_2 */

            case 2:
              if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 797; /* *andqi_extdi_2 */

            default:
              return -1;
            }

        case 3:
          x8 = XEXP (x6, 0);
          x9 = XEXP (x8, 1);
          operands[2] = x9;
          if (general_operand (operands[2], E_QImode))
            {
              switch (pattern1027 (x2))
                {
                case 0:
                  return 774; /* *iorqi_exthi_1 */

                case 1:
                  return 777; /* *iorqi_extsi_1 */

                case 2:
                  if (
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return 780; /* *iorqi_extdi_1 */
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x9) != SUBREG)
            return -1;
          switch (pattern1806 (x2))
            {
            case 0:
              return 792; /* *iorqi_exthi_2 */

            case 1:
              return 795; /* *iorqi_extsi_2 */

            case 2:
              if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 798; /* *iorqi_extdi_2 */

            default:
              return -1;
            }

        case 4:
          x8 = XEXP (x6, 0);
          x9 = XEXP (x8, 1);
          operands[2] = x9;
          if (general_operand (operands[2], E_QImode))
            {
              switch (pattern1027 (x2))
                {
                case 0:
                  return 775; /* *xorqi_exthi_1 */

                case 1:
                  return 778; /* *xorqi_extsi_1 */

                case 2:
                  if (
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return 781; /* *xorqi_extdi_1 */
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x9) != SUBREG)
            return -1;
          switch (pattern1806 (x2))
            {
            case 0:
              return 793; /* *xorqi_exthi_2 */

            case 1:
              return 796; /* *xorqi_extsi_2 */

            case 2:
              if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 799; /* *xorqi_extdi_2 */

            default:
              return -1;
            }

        case 5:
          return 988; /* *negqi_exthi_1 */

        case 6:
          return 989; /* *negqi_extsi_1 */

        case 7:
          if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 990; /* *negqi_extdi_1 */

        case 8:
          return 1119; /* *ashlqi_exthi_1 */

        case 9:
          return 1120; /* *ashlqi_extsi_1 */

        case 10:
          if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1121; /* *ashlqi_extdi_1 */

        case 11:
          operands[0] = x3;
          switch (pattern1216 (x6))
            {
            case 0:
              if ((
#line 16771 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(UINTVAL (operands[2]) < 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return 1138; /* lshrdi3_doubleword_lowpart */
              break;

            case 1:
              if ((
#line 16771 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(UINTVAL (operands[2]) < 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1140; /* lshrti3_doubleword_lowpart */
              break;

            default:
              break;
            }
          x8 = XEXP (x6, 0);
          if (GET_MODE (x8) != E_QImode)
            return -1;
          switch (pattern1028 (x2))
            {
            case 0:
              return 1238; /* *lshrqi_exthi_1 */

            case 1:
              return 1240; /* *lshrqi_extsi_1 */

            case 2:
              if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 1242; /* *lshrqi_extdi_1 */

            default:
              return -1;
            }

        case 12:
          operands[0] = x3;
          switch (pattern1216 (x6))
            {
            case 0:
              if ((
#line 16771 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(UINTVAL (operands[2]) < 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return 1139; /* ashrdi3_doubleword_lowpart */
              break;

            case 1:
              if ((
#line 16771 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(UINTVAL (operands[2]) < 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1141; /* ashrti3_doubleword_lowpart */
              break;

            default:
              break;
            }
          x8 = XEXP (x6, 0);
          if (GET_MODE (x8) != E_QImode)
            return -1;
          switch (pattern1028 (x2))
            {
            case 0:
              return 1239; /* *ashrqi_exthi_1 */

            case 1:
              return 1241; /* *ashrqi_extsi_1 */

            case 2:
              if (!
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 1243; /* *ashrqi_extdi_1 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case CONST_INT:
      if (GET_CODE (x3) != ZERO_EXTRACT)
        return -1;
      x10 = XEXP (x3, 1);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x5 = XEXP (x3, 0);
      operands[0] = x5;
      x11 = XEXP (x3, 2);
      operands[1] = x11;
      switch (XWINT (x6, 0))
        {
        case 0L:
          switch (GET_CODE (operands[1]))
            {
            case REG:
            case SUBREG:
              if (!register_operand (operands[1], E_QImode)
                  || GET_MODE (x3) != E_HImode)
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (!nonimmediate_operand (operands[0], E_QImode)
                      || !
#line 18995 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                    return -1;
                  return 1411; /* *btrqi_2 */

                case E_HImode:
                  if (!nonimmediate_operand (operands[0], E_HImode)
                      || !
#line 18995 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                    return -1;
                  return 1412; /* *btrhi_2 */

                default:
                  return -1;
                }

            case CONST_INT:
              if (!const_0_to_63_operand (operands[1], E_QImode)
                  || GET_MODE (x3) != E_DImode
                  || !nonimmediate_operand (operands[0], E_DImode)
                  || !
#line 19059 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && (TARGET_USE_BT || reload_completed)))
                return -1;
              return 1414; /* *btrq_imm */

            default:
              return -1;
            }

        case 1L:
          if (GET_MODE (x3) != E_DImode
              || !nonimmediate_operand (operands[0], E_DImode)
              || !const_0_to_63_operand (operands[1], E_QImode)
              || !
#line 19046 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && (TARGET_USE_BT || reload_completed)))
            return -1;
          return 1413; /* *btsq_imm */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_366 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  if (pattern340 (x1) != 0)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      switch (GET_CODE (operands[2]))
        {
        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case MEM:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          switch (pattern344 (x3))
            {
            case 0:
              if (!
#line 8156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 393; /* *subqi_1_zexthi */

            case 1:
              if (!
#line 8156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 395; /* *subqi_1_zextsi */

            case 2:
              if (!
#line 8170 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 399; /* *subhi_1_zextsi */

            case 3:
              if (!
#line 8156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 397; /* *subqi_1_zextdi */

            case 4:
              if (!
#line 8170 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 401; /* *subhi_1_zextdi */

            case 5:
              if (!
#line 8185 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 402; /* *subsi_1_zext */

            default:
              return -1;
            }

        case LTU:
        case UNLT:
          switch (pattern1408 (x3))
            {
            case 0:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !ix86_carry_flag_operator (operands[2], E_QImode)
                  || !
#line 9452 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 505; /* *subqi3_carry_zexthi_0 */

            case 1:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !ix86_carry_flag_operator (operands[2], E_QImode)
                  || !
#line 9452 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 506; /* *subqi3_carry_zextsi_0 */

            case 2:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !ix86_carry_flag_operator (operands[2], E_HImode)
                  || !
#line 9467 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 508; /* *subhi3_carry_zextsi_0 */

            case 3:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !ix86_carry_flag_operator (operands[2], E_QImode)
                  || !
#line 9452 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 507; /* *subqi3_carry_zextdi_0 */

            case 4:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !ix86_carry_flag_operator (operands[2], E_HImode)
                  || !
#line 9467 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 509; /* *subhi3_carry_zextdi_0 */

            case 5:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !ix86_carry_flag_operator (operands[2], E_SImode)
                  || !
#line 9482 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 510; /* *subsi3_carry_zext_0 */

            default:
              return -1;
            }

        case GE:
        case GEU:
          switch (pattern1408 (x3))
            {
            case 0:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !ix86_carry_flag_unset_operator (operands[2], E_QImode)
                  || !
#line 9500 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 511; /* *subqi3_carry_zexthi_0r */

            case 1:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !ix86_carry_flag_unset_operator (operands[2], E_QImode)
                  || !
#line 9500 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 512; /* *subqi3_carry_zextsi_0r */

            case 2:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !ix86_carry_flag_unset_operator (operands[2], E_HImode)
                  || !
#line 9515 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 514; /* *subhi3_carry_zextsi_0r */

            case 3:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !ix86_carry_flag_unset_operator (operands[2], E_QImode)
                  || !
#line 9500 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 513; /* *subqi3_carry_zextdi_0r */

            case 4:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !ix86_carry_flag_unset_operator (operands[2], E_HImode)
                  || !
#line 9515 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 515; /* *subhi3_carry_zextdi_0r */

            case 5:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !ix86_carry_flag_unset_operator (operands[2], E_SImode)
                  || !
#line 9530 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 516; /* *subsi3_carry_zext_0r */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case MINUS:
      x7 = XEXP (x5, 1);
      switch (GET_CODE (x7))
        {
        case LTU:
        case UNLT:
          operands[3] = x7;
          x8 = XEXP (x7, 0);
          if (GET_CODE (x8) != REG
              || REGNO (x8) != 17)
            return -1;
          x9 = XEXP (x7, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x10 = XEXP (x5, 0);
          operands[1] = x10;
          x6 = XEXP (x4, 1);
          operands[2] = x6;
          switch (pattern1138 (x3))
            {
            case 0:
              if (pattern1735 (x5, 
E_QImode) != 0
                  || !
#line 9392 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 499; /* *subqi3_carry_zexthi */

            case 1:
              if (pattern1735 (x5, 
E_QImode) != 0
                  || !
#line 9392 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 500; /* *subqi3_carry_zextsi */

            case 2:
              if (pattern1735 (x5, 
E_HImode) != 0
                  || !
#line 9412 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 502; /* *subhi3_carry_zextsi */

            case 3:
              if (pattern1735 (x5, 
E_QImode) != 0
                  || !
#line 9392 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 501; /* *subqi3_carry_zextdi */

            case 4:
              if (pattern1735 (x5, 
E_HImode) != 0
                  || !
#line 9412 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 503; /* *subhi3_carry_zextdi */

            case 5:
              if (pattern1735 (x5, 
E_SImode) != 0
                  || !
#line 9432 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 504; /* *subsi3_carry_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case CONST_INT:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || GET_MODE (x4) != E_SImode)
        return -1;
      x6 = XEXP (x4, 1);
      if (GET_MODE (x6) != E_SImode)
        return -1;
      switch (XWINT (x5, 0))
        {
        case 63L:
          if (GET_CODE (x6) != SUBREG
              || maybe_ne (SUBREG_BYTE (x6), 0))
            return -1;
          x11 = XEXP (x6, 0);
          if (GET_CODE (x11) != CLZ
              || GET_MODE (x11) != E_DImode)
            return -1;
          x12 = XEXP (x11, 0);
          operands[1] = x12;
          if (!nonimmediate_operand (operands[1], E_DImode)
              || !
#line 21282 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT))
            return -1;
          return 1526; /* bsr_rex64_1_zext */

        case 31L:
          if (GET_CODE (x6) != CLZ)
            return -1;
          x11 = XEXP (x6, 0);
          operands[1] = x11;
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !
#line 21322 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT))
            return -1;
          return 1529; /* bsr_zext_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_376 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x2))
    {
    case CLOBBER:
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      switch (GET_MODE (operands[1]))
        {
        case E_DImode:
          if (!nonimmediate_operand (operands[1], E_DImode)
              || !x86_64_immediate_operand (operands[2], E_DImode)
              || !scratch_operand (operands[0], E_DImode)
              || !
#line 7338 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_match_ccmode (insn, CCGCmode)))
            return -1;
          return 319; /* *adddi_4 */

        case E_QImode:
          if (!nonimmediate_operand (operands[1], E_QImode)
              || !const_int_operand (operands[2], E_QImode)
              || !scratch_operand (operands[0], E_QImode)
              || !
#line 7383 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGCmode)))
            return -1;
          return 320; /* *addqi_4 */

        case E_HImode:
          if (!nonimmediate_operand (operands[1], E_HImode)
              || !const_int_operand (operands[2], E_HImode)
              || !scratch_operand (operands[0], E_HImode)
              || !
#line 7383 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGCmode)))
            return -1;
          return 321; /* *addhi_4 */

        case E_SImode:
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !const_int_operand (operands[2], E_SImode)
              || !scratch_operand (operands[0], E_SImode)
              || !
#line 7383 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCGCmode)))
            return -1;
          return 322; /* *addsi_4 */

        default:
          return -1;
        }

    case SET:
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      x4 = XEXP (x2, 1);
      switch (GET_CODE (x4))
        {
        case MINUS:
          x5 = XEXP (x4, 0);
          if (!rtx_equal_p (x5, operands[1]))
            return -1;
          x6 = XEXP (x4, 1);
          if (!rtx_equal_p (x6, operands[2]))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_QImode:
              if (pattern1473 (x4, 
E_QImode) != 0
                  || !
#line 8682 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 445; /* *subqi_3 */

            case E_HImode:
              if (pattern1473 (x4, 
E_HImode) != 0
                  || !
#line 8682 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 446; /* *subhi_3 */

            case E_SImode:
              if (pattern1474 (x4, 
E_SImode) != 0
                  || !
#line 8682 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 447; /* *subsi_3 */

            case E_DImode:
              if (pattern1474 (x4, 
E_DImode) != 0
                  || !(
#line 8682 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 448; /* *subdi_3 */

            default:
              return -1;
            }

        case ZERO_EXTEND:
          if (GET_MODE (x4) != E_DImode)
            return -1;
          x5 = XEXP (x4, 0);
          if (GET_CODE (x5) != MINUS
              || GET_MODE (x5) != E_SImode
              || !nonimmediate_operand (operands[1], E_SImode)
              || !x86_64_general_operand (operands[2], E_SImode)
              || !register_operand (operands[0], E_DImode))
            return -1;
          x7 = XEXP (x5, 0);
          if (!rtx_equal_p (x7, operands[1]))
            return -1;
          x8 = XEXP (x5, 1);
          if (!rtx_equal_p (x8, operands[2])
              || !
#line 8784 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_match_ccmode (insn, CCmode)
   && ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 452; /* *subsi_3_zext */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_380 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17)
    return -1;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x6;
      x7 = XEXP (x5, 1);
      operands[2] = x7;
      x8 = XEXP (x4, 1);
      switch (GET_CODE (x8))
        {
        case CONST_INT:
          res = recog_374 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case REG:
        case SUBREG:
        case MEM:
          res = recog_375 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        default:
          break;
        }
      if (GET_MODE (x3) != E_CCCmode
          || GET_MODE (x4) != E_CCCmode)
        return -1;
      x9 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x9))
        {
        case CLOBBER:
          x10 = XEXP (x9, 0);
          operands[0] = x10;
          if (!rtx_equal_p (x8, operands[2]))
            return -1;
          switch (pattern938 (x5))
            {
            case 0:
              if (!
#line 10037 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 543; /* *addqi3_cconly_overflow_2 */

            case 1:
              if (!
#line 10037 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 544; /* *addhi3_cconly_overflow_2 */

            case 2:
              if (!
#line 10037 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 545; /* *addsi3_cconly_overflow_2 */

            case 3:
              if (!(
#line 10037 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 546; /* *adddi3_cconly_overflow_2 */

            default:
              return -1;
            }

        case SET:
          x10 = XEXP (x9, 0);
          operands[0] = x10;
          x11 = XEXP (x9, 1);
          switch (GET_CODE (x11))
            {
            case PLUS:
              x12 = XEXP (x11, 0);
              if (!rtx_equal_p (x12, operands[1]))
                return -1;
              x13 = XEXP (x11, 1);
              if (!rtx_equal_p (x13, operands[2]))
                return -1;
              switch (GET_MODE (x5))
                {
                case E_QImode:
                  if (pattern1610 (x1, 
E_QImode) != 0
                      || !
#line 10055 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)))
                    return -1;
                  return 547; /* *addqi3_cc_overflow_2 */

                case E_HImode:
                  if (pattern1610 (x1, 
E_HImode) != 0
                      || !
#line 10055 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)))
                    return -1;
                  return 548; /* *addhi3_cc_overflow_2 */

                case E_SImode:
                  if (!nonimmediate_operand (operands[1], E_SImode)
                      || !x86_64_general_operand (operands[2], E_SImode)
                      || !nonimmediate_operand (operands[0], E_SImode)
                      || GET_MODE (x11) != E_SImode
                      || !rtx_equal_p (x8, operands[2])
                      || !
#line 10055 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                    return -1;
                  return 549; /* *addsi3_cc_overflow_2 */

                case E_DImode:
                  if (!nonimmediate_operand (operands[1], E_DImode)
                      || !nonimmediate_operand (operands[0], E_DImode)
                      || GET_MODE (x11) != E_DImode)
                    return -1;
                  if (x86_64_general_operand (operands[2], E_DImode)
                      && rtx_equal_p (x8, operands[2])
                      && (
#line 10055 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 550; /* *adddi3_cc_overflow_2 */
                  if (!x86_64_hilo_general_operand (operands[2], E_DImode)
                      || !rtx_equal_p (x8, operands[1])
                      || !(
#line 10093 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                    return -1;
                  return 552; /* *adddi3_doubleword_cc_overflow_1 */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              if (GET_MODE (x11) != E_DImode)
                return -1;
              x12 = XEXP (x11, 0);
              if (GET_CODE (x12) != PLUS
                  || GET_MODE (x12) != E_SImode
                  || GET_MODE (x5) != E_SImode
                  || !nonimmediate_operand (operands[1], E_SImode)
                  || !x86_64_general_operand (operands[2], E_SImode)
                  || !register_operand (operands[0], E_DImode)
                  || !rtx_equal_p (x8, operands[2]))
                return -1;
              x14 = XEXP (x12, 0);
              if (!rtx_equal_p (x14, operands[1]))
                return -1;
              x15 = XEXP (x12, 1);
              if (!rtx_equal_p (x15, operands[2])
                  || !
#line 10074 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 551; /* *addsi3_zext_cc_overflow_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC_VOLATILE:
      if (XVECLEN (x6, 0) != 2
          || XINT (x6, 1) != 110)
        return -1;
      x8 = XEXP (x4, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x9 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x9) != SET)
        return -1;
      switch (pattern1218 (x1, 
PLUS))
        {
        case 0:
          return 10971; /* atomic_add_fetch_cmp_0qi_1 */

        case 1:
          return 10972; /* atomic_add_fetch_cmp_0hi_1 */

        case 2:
          return 10973; /* atomic_add_fetch_cmp_0si_1 */

        case 3:
          if (!
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 10974; /* atomic_add_fetch_cmp_0di_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_385 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      if (pattern680 (x1, 
PLUS) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SIGN_EXTEND:
          switch (pattern1544 (x1))
            {
            case 0:
              if (!
#line 7672 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 342; /* *addvqi4 */

            case 1:
              if (!
#line 7672 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 343; /* *addvhi4 */

            case 2:
              if (!
#line 7672 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 344; /* *addvsi4 */

            case 3:
              if (x86_64_sext_operand (operands[2], E_DImode)
                  && (
#line 7672 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 345; /* *addvdi4 */
              if (!nonimmediate_operand (operands[2], E_DImode)
                  || !(
#line 7725 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 350; /* *addvdi4_doubleword */

            case 4:
              if (!(
#line 7725 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 351; /* *addvti4_doubleword */

            case 5:
              if (!
#line 7694 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 346; /* addvqi4_1 */

            case 6:
              if (!
#line 7694 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 347; /* addvhi4_1 */

            case 7:
              if (!
#line 7694 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 348; /* addvsi4_1 */

            case 8:
              if (const_int_operand (operands[3], E_TImode)
                  && x86_64_immediate_operand (operands[2], E_DImode)
                  && (
#line 7694 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 349; /* addvdi4_1 */
              if (!const_scalar_int_operand (operands[3], E_TImode)
                  || !x86_64_hilo_general_operand (operands[2], E_DImode)
                  || !(
#line 7771 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 352; /* *addvdi4_doubleword_1 */

            case 9:
              if (!(
#line 7771 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 353; /* *addvti4_doubleword_1 */

            default:
              return -1;
            }

        case PLUS:
          x6 = XEXP (x5, 0);
          switch (GET_CODE (x6))
            {
            case LTU:
            case UNLT:
              operands[4] = x6;
              x7 = XEXP (x6, 1);
              if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x8 = XEXP (x5, 1);
              if (GET_CODE (x8) != SIGN_EXTEND)
                return -1;
              x9 = XEXP (x3, 1);
              x10 = XEXP (x9, 0);
              x11 = XEXP (x10, 0);
              if (GET_CODE (x11) != PLUS)
                return -1;
              x12 = XEXP (x11, 0);
              switch (GET_CODE (x12))
                {
                case LTU:
                case UNLT:
                  operands[5] = x12;
                  x13 = XEXP (x12, 1);
                  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                    return -1;
                  x14 = XVECEXP (x1, 0, 1);
                  x15 = XEXP (x14, 1);
                  x16 = XEXP (x15, 0);
                  if (GET_CODE (x16) != PLUS)
                    return -1;
                  x17 = XEXP (x16, 0);
                  switch (GET_CODE (x17))
                    {
                    case LTU:
                    case UNLT:
                      if (!rtx_equal_p (x17, operands[5]))
                        return -1;
                      x18 = XEXP (x6, 0);
                      operands[3] = x18;
                      if (!flags_reg_operand (operands[3], E_VOIDmode))
                        return -1;
                      x19 = XEXP (x8, 0);
                      operands[1] = x19;
                      x20 = XEXP (x12, 0);
                      if (!rtx_equal_p (x20, operands[3]))
                        return -1;
                      x21 = XEXP (x11, 1);
                      if (!rtx_equal_p (x21, operands[1]))
                        return -1;
                      x22 = XEXP (x16, 1);
                      if (!rtx_equal_p (x22, operands[1]))
                        return -1;
                      switch (pattern1839 (x1))
                        {
                        case 0:
                          if (pattern1855 (x1, 
E_QImode, 
E_HImode) != 0
                              || !
#line 7838 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 354; /* *addvqi4_overflow_1 */

                        case 1:
                          if (pattern1855 (x1, 
E_HImode, 
E_SImode) != 0
                              || !
#line 7838 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 355; /* *addvhi4_overflow_1 */

                        case 2:
                          if (pattern1856 (x1, 
E_SImode, 
E_DImode) != 0
                              || !
#line 7838 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 356; /* *addvsi4_overflow_1 */

                        case 3:
                          if (pattern1856 (x1, 
E_DImode, 
E_TImode) != 0
                              || !(
#line 7838 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                            return -1;
                          return 357; /* *addvdi4_overflow_1 */

                        case 4:
                          if (pattern1858 (x1, 
E_QImode, 
E_HImode) != 0
                              || !
#line 7871 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 358; /* *addvqi4_overflow_2 */

                        case 5:
                          if (pattern1858 (x1, 
E_HImode, 
E_SImode) != 0
                              || !
#line 7871 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 359; /* *addvhi4_overflow_2 */

                        case 6:
                          if (pattern1858 (x1, 
E_SImode, 
E_DImode) != 0
                              || !
#line 7871 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 360; /* *addvsi4_overflow_2 */

                        case 7:
                          if (pattern1858 (x1, 
E_DImode, 
E_TImode) != 0
                              || !(
#line 7871 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                            return -1;
                          return 361; /* *addvdi4_overflow_2 */

                        default:
                          return -1;
                        }

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case MINUS:
      if (pattern680 (x1, 
MINUS) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SIGN_EXTEND:
          switch (pattern1544 (x1))
            {
            case 0:
              if (!
#line 8447 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 425; /* *subvqi4 */

            case 1:
              if (!
#line 8447 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 426; /* *subvhi4 */

            case 2:
              if (!
#line 8447 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 427; /* *subvsi4 */

            case 3:
              if (x86_64_sext_operand (operands[2], E_DImode)
                  && (
#line 8447 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 428; /* *subvdi4 */
              if (!nonimmediate_operand (operands[2], E_DImode)
                  || !(
#line 8497 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 433; /* *subvdi4_doubleword */

            case 4:
              if (!(
#line 8497 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 434; /* *subvti4_doubleword */

            case 5:
              if (!
#line 8469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 429; /* subvqi4_1 */

            case 6:
              if (!
#line 8469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 430; /* subvhi4_1 */

            case 7:
              if (!
#line 8469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                return -1;
              return 431; /* subvsi4_1 */

            case 8:
              if (const_int_operand (operands[3], E_TImode)
                  && x86_64_immediate_operand (operands[2], E_DImode)
                  && (
#line 8469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 432; /* subvdi4_1 */
              if (!const_scalar_int_operand (operands[3], E_TImode)
                  || !x86_64_hilo_general_operand (operands[2], E_DImode)
                  || !(
#line 8541 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 435; /* *subvdi4_doubleword_1 */

            case 9:
              if (!(
#line 8541 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && CONST_SCALAR_INT_P (operands[2])
   && rtx_equal_p (operands[2], operands[3])) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 436; /* *subvti4_doubleword_1 */

            default:
              return -1;
            }

        case MINUS:
          x6 = XEXP (x5, 0);
          if (GET_CODE (x6) != SIGN_EXTEND)
            return -1;
          x8 = XEXP (x5, 1);
          switch (GET_CODE (x8))
            {
            case LTU:
            case UNLT:
              operands[4] = x8;
              x23 = XEXP (x8, 1);
              if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                return -1;
              x9 = XEXP (x3, 1);
              x10 = XEXP (x9, 0);
              x11 = XEXP (x10, 0);
              if (GET_CODE (x11) != MINUS)
                return -1;
              x21 = XEXP (x11, 1);
              switch (GET_CODE (x21))
                {
                case LTU:
                case UNLT:
                  operands[5] = x21;
                  x24 = XEXP (x21, 1);
                  if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
                    return -1;
                  x14 = XVECEXP (x1, 0, 1);
                  x15 = XEXP (x14, 1);
                  x16 = XEXP (x15, 0);
                  if (GET_CODE (x16) != MINUS)
                    return -1;
                  x22 = XEXP (x16, 1);
                  switch (GET_CODE (x22))
                    {
                    case LTU:
                    case UNLT:
                      if (!rtx_equal_p (x22, operands[5]))
                        return -1;
                      x18 = XEXP (x6, 0);
                      operands[1] = x18;
                      x19 = XEXP (x8, 0);
                      operands[3] = x19;
                      if (!flags_reg_operand (operands[3], E_VOIDmode))
                        return -1;
                      x12 = XEXP (x11, 0);
                      if (!rtx_equal_p (x12, operands[1]))
                        return -1;
                      x25 = XEXP (x21, 0);
                      if (!rtx_equal_p (x25, operands[3]))
                        return -1;
                      x17 = XEXP (x16, 0);
                      if (!rtx_equal_p (x17, operands[1]))
                        return -1;
                      switch (pattern1839 (x1))
                        {
                        case 0:
                          if (pattern1860 (x1, 
E_QImode, 
E_HImode) != 0
                              || !
#line 8606 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 437; /* *subvqi4_overflow_1 */

                        case 1:
                          if (pattern1860 (x1, 
E_HImode, 
E_SImode) != 0
                              || !
#line 8606 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 438; /* *subvhi4_overflow_1 */

                        case 2:
                          if (pattern1861 (x1, 
E_SImode, 
E_DImode) != 0
                              || !
#line 8606 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)))
                            return -1;
                          return 439; /* *subvsi4_overflow_1 */

                        case 3:
                          if (pattern1861 (x1, 
E_DImode, 
E_TImode) != 0
                              || !(
#line 8606 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                            return -1;
                          return 440; /* *subvdi4_overflow_1 */

                        case 4:
                          if (pattern1862 (x1, 
E_QImode, 
E_HImode) != 0
                              || !
#line 8639 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 441; /* *subvqi4_overflow_2 */

                        case 5:
                          if (pattern1862 (x1, 
E_HImode, 
E_SImode) != 0
                              || !
#line 8639 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 442; /* *subvhi4_overflow_2 */

                        case 6:
                          if (pattern1862 (x1, 
E_SImode, 
E_DImode) != 0
                              || !
#line 8639 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])))
                            return -1;
                          return 443; /* *subvsi4_overflow_2 */

                        case 7:
                          if (pattern1862 (x1, 
E_DImode, 
E_TImode) != 0
                              || !(
#line 8639 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[6])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                            return -1;
                          return 444; /* *subvdi4_overflow_2 */

                        default:
                          return -1;
                        }

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case MULT:
      if (pattern679 (x1, 
MULT) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case SIGN_EXTEND:
          x9 = XEXP (x3, 1);
          if (GET_CODE (x9) != SIGN_EXTEND)
            return -1;
          x10 = XEXP (x9, 0);
          if (GET_CODE (x10) != MULT)
            return -1;
          x6 = XEXP (x5, 0);
          operands[1] = x6;
          x11 = XEXP (x10, 0);
          if (!rtx_equal_p (x11, operands[1]))
            return -1;
          x14 = XVECEXP (x1, 0, 1);
          x15 = XEXP (x14, 1);
          x16 = XEXP (x15, 0);
          if (!rtx_equal_p (x16, operands[1]))
            return -1;
          x26 = XEXP (x4, 1);
          switch (GET_CODE (x26))
            {
            case SIGN_EXTEND:
              x27 = XEXP (x26, 0);
              operands[2] = x27;
              x28 = XEXP (x10, 1);
              if (!rtx_equal_p (x28, operands[2]))
                return -1;
              x29 = XEXP (x15, 1);
              if (!rtx_equal_p (x29, operands[2]))
                return -1;
              switch (GET_MODE (x4))
                {
                case E_DImode:
                  if (pattern1779 (x1, 
E_SImode, 
E_DImode) != 0
                      || !
#line 10754 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 604; /* *mulvsi4 */

                case E_TImode:
                  if (pattern1779 (x1, 
E_DImode, 
E_TImode) != 0
                      || !(
#line 10754 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 605; /* *mulvdi4 */

                case E_SImode:
                  if (pattern1780 (x1, 
E_HImode, 
E_SImode) != 0
                      || !
#line 10790 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 606; /* *mulvhi4 */

                case E_HImode:
                  if (pattern1780 (x1, 
E_QImode, 
E_HImode) != 0
                      || !
#line 10928 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 613; /* *mulvqi4 */

                default:
                  return -1;
                }

            case CONST_INT:
              operands[3] = x26;
              x28 = XEXP (x10, 1);
              operands[2] = x28;
              x29 = XEXP (x15, 1);
              if (!rtx_equal_p (x29, operands[2]))
                return -1;
              switch (GET_MODE (x4))
                {
                case E_SImode:
                  if (GET_MODE (x5) != E_SImode
                      || !nonimmediate_operand (operands[1], E_HImode)
                      || !const_int_operand (operands[3], E_SImode)
                      || GET_MODE (x9) != E_SImode
                      || GET_MODE (x10) != E_HImode
                      || !immediate_operand (operands[2], E_HImode)
                      || !register_operand (operands[0], E_HImode)
                      || GET_MODE (x15) != E_HImode
                      || !
#line 10814 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                    return -1;
                  return 607; /* *mulvhi4_1 */

                case E_DImode:
                  if (pattern1781 (x1, 
E_SImode, 
E_DImode) != 0
                      || !
#line 10814 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])))
                    return -1;
                  return 608; /* *mulvsi4_1 */

                case E_TImode:
                  if (pattern1781 (x1, 
E_DImode, 
E_TImode) != 0
                      || !(
#line 10814 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && CONST_INT_P (operands[2])
   && INTVAL (operands[2]) == INTVAL (operands[3])) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 609; /* *mulvdi4_1 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case ZERO_EXTEND:
          x26 = XEXP (x4, 1);
          if (GET_CODE (x26) != ZERO_EXTEND)
            return -1;
          x9 = XEXP (x3, 1);
          if (GET_CODE (x9) != ZERO_EXTEND)
            return -1;
          x10 = XEXP (x9, 0);
          if (GET_CODE (x10) != MULT)
            return -1;
          x6 = XEXP (x5, 0);
          operands[1] = x6;
          x27 = XEXP (x26, 0);
          operands[2] = x27;
          x11 = XEXP (x10, 0);
          if (!rtx_equal_p (x11, operands[1]))
            return -1;
          x28 = XEXP (x10, 1);
          if (!rtx_equal_p (x28, operands[2]))
            return -1;
          x14 = XVECEXP (x1, 0, 1);
          x15 = XEXP (x14, 1);
          x16 = XEXP (x15, 0);
          if (!rtx_equal_p (x16, operands[1]))
            return -1;
          x29 = XEXP (x15, 1);
          if (!rtx_equal_p (x29, operands[2]))
            return -1;
          switch (GET_MODE (x4))
            {
            case E_SImode:
              if (pnum_clobbers == NULL
                  || pattern1780 (x1, 
E_HImode, 
E_SImode) != 0
                  || !
#line 10884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              *pnum_clobbers = 1;
              return 610; /* *umulvhi4 */

            case E_DImode:
              if (pnum_clobbers == NULL
                  || pattern1780 (x1, 
E_SImode, 
E_DImode) != 0
                  || !
#line 10884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              *pnum_clobbers = 1;
              return 611; /* *umulvsi4 */

            case E_TImode:
              if (pnum_clobbers == NULL
                  || pattern1780 (x1, 
E_DImode, 
E_TImode) != 0
                  || !(
#line 10884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 612; /* *umulvdi4 */

            case E_HImode:
              if (pattern1780 (x1, 
E_QImode, 
E_HImode) != 0
                  || !
#line 10928 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 614; /* *umulvqi4 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ZERO_EXTRACT:
      switch (pattern681 (x1))
        {
        case 0:
          if (!
#line 19416 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
            return -1;
          return 1440; /* *btsi_setncqi_2 */

        case 1:
          if (!(
#line 19416 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1441; /* *btdi_setncqi_2 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], E_V2SFmode))
        return -1;
      x14 = XVECEXP (x1, 0, 1);
      if (pattern383 (x14, 
110, 
0) != 0)
        return -1;
      x30 = XEXP (x2, 0);
      operands[0] = x30;
      if (!register_operand (operands[0], E_V2SImode)
          || GET_MODE (x3) != E_V2SImode)
        return -1;
      x9 = XEXP (x3, 1);
      operands[2] = x9;
      if (!nonimmediate_operand (operands[2], E_V2SFmode)
          || !
#line 1203 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (EQ, V2SFmode, operands)))
        return -1;
      return 2069; /* *mmx_eqv2sf3 */

    default:
      return -1;
    }
}

 int
recog_408 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x6))
    {
    case CLOBBER:
      switch (pattern698 (x1))
        {
        case 0:
          if (!
#line 21536 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          return 1534; /* clzsi2_lzcnt */

        case 1:
          if (!(
#line 21536 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1535; /* clzdi2_lzcnt */

        default:
          return -1;
        }

    case UNSPEC:
      switch (pattern699 (x1))
        {
        case 0:
          if (
#line 21561 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_LZCNT))
            return 1536; /* *clzsi2_lzcnt_falsedep_nf */
          if (pnum_clobbers == NULL
              || !
#line 21574 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          *pnum_clobbers = 1;
          return 1538; /* *clzsi2_lzcnt_falsedep */

        case 1:
          if ((
#line 21561 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_LZCNT) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1537; /* *clzdi2_lzcnt_falsedep_nf */
          if (pnum_clobbers == NULL
              || !(
#line 21574 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1539; /* *clzdi2_lzcnt_falsedep */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_413 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != UNSPEC
      || XVECLEN (x4, 0) != 4
      || XINT (x4, 1) != 153)
    return -1;
  x5 = XVECEXP (x4, 0, 1);
  if (GET_CODE (x5) != MEM)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != UNSPEC
      || XVECLEN (x6, 0) != 3
      || XINT (x6, 1) != 154)
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (GET_CODE (x7) != MEM
      || GET_MODE (x7) != E_BLKmode)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_CODE (x8) != SCRATCH)
    return -1;
  x9 = XEXP (x3, 1);
  if (GET_CODE (x9) != PARALLEL
      || XVECLEN (x9, 0) != 4)
    return -1;
  x10 = XVECEXP (x9, 0, 0);
  if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x11 = XVECEXP (x9, 0, 1);
  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x12 = XVECEXP (x9, 0, 2);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x13 = XVECEXP (x9, 0, 3);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x14 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x14) != CLOBBER)
    return -1;
  x15 = XEXP (x2, 0);
  operands[0] = x15;
  x16 = XVECEXP (x6, 0, 1);
  if (!register_operand (x16, E_V4DImode))
    return -1;
  x17 = XVECEXP (x6, 0, 2);
  if (!const1248_operand (x17, E_SImode))
    return -1;
  x18 = XEXP (x14, 0);
  operands[1] = x18;
  x19 = XVECEXP (x4, 0, 0);
  switch (GET_CODE (x19))
    {
    case REG:
    case SUBREG:
      operands[2] = x19;
      operands[7] = x5;
      x20 = XVECEXP (x6, 0, 0);
      operands[3] = x20;
      operands[4] = x16;
      operands[6] = x17;
      x21 = XVECEXP (x4, 0, 3);
      operands[5] = x21;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SImode:
          switch (pattern1834 (x3, 
E_V8SImode, 
E_V4SImode, 
E_SImode))
            {
            case 0:
              if (!(
#line 29407 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 9660; /* *avx2_gatherdiv8si_3 */

            case 1:
              if (!(
#line 29407 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 9662; /* *avx2_gatherdiv8si_3 */

            default:
              return -1;
            }

        case E_V4SFmode:
          switch (pattern1834 (x3, 
E_V8SFmode, 
E_V4SFmode, 
E_SFmode))
            {
            case 0:
              if (!(
#line 29407 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 9661; /* *avx2_gatherdiv8sf_3 */

            case 1:
              if (!(
#line 29407 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 9663; /* *avx2_gatherdiv8sf_3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PC:
      operands[6] = x5;
      x20 = XVECEXP (x6, 0, 0);
      operands[2] = x20;
      operands[3] = x16;
      operands[5] = x17;
      x21 = XVECEXP (x4, 0, 3);
      operands[4] = x21;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SImode:
          switch (pattern1830 (x3, 
E_V8SImode, 
E_V4SImode, 
E_SImode))
            {
            case 0:
              if (!(
#line 29431 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 9664; /* *avx2_gatherdiv8si_4 */

            case 1:
              if (!(
#line 29431 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 9666; /* *avx2_gatherdiv8si_4 */

            default:
              return -1;
            }

        case E_V4SFmode:
          switch (pattern1830 (x3, 
E_V8SFmode, 
E_V4SFmode, 
E_SFmode))
            {
            case 0:
              if (!(
#line 29431 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 9665; /* *avx2_gatherdiv8sf_4 */

            case 1:
              if (!(
#line 29431 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 9667; /* *avx2_gatherdiv8sf_4 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_421 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  if (pattern230 (x1) != 0)
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PLUS)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 0);
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  x8 = XEXP (x5, 1);
  x9 = XEXP (x8, 0);
  operands[3] = x9;
  x10 = XVECEXP (x1, 0, 1);
  x11 = XEXP (x10, 0);
  operands[0] = x11;
  x12 = XEXP (x2, 0);
  operands[1] = x12;
  x13 = XEXP (x10, 1);
  x14 = XEXP (x13, 0);
  if (!rtx_equal_p (x14, operands[2]))
    return -1;
  x15 = XEXP (x3, 0);
  if (!rtx_equal_p (x15, operands[3]))
    return -1;
  x16 = XEXP (x13, 1);
  switch (XWINT (x16, 0))
    {
    case 8L:
      if (XWINT (x4, 0) != 8L)
        return -1;
      switch (pattern1645 (x1, 
E_DImode))
        {
        case 0:
          if (!(
#line 25654 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 1761; /* *strmovdi_rex_1 */

        case 1:
          if (!(
#line 25654 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 1762; /* *strmovdi_rex_1 */

        default:
          return -1;
        }

    case 4L:
      if (XWINT (x4, 0) != 4L)
        return -1;
      switch (pattern1645 (x1, 
E_SImode))
        {
        case 0:
          if (!(
#line 25671 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 1763; /* *strmovsi_1 */

        case 1:
          if (!(
#line 25671 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 1764; /* *strmovsi_1 */

        default:
          return -1;
        }

    case 2L:
      if (XWINT (x4, 0) != 2L)
        return -1;
      switch (pattern1645 (x1, 
E_HImode))
        {
        case 0:
          if (!(
#line 25687 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 1765; /* *strmovhi_1 */

        case 1:
          if (!(
#line 25687 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 1766; /* *strmovhi_1 */

        default:
          return -1;
        }

    case 1L:
      if (XWINT (x4, 0) != 1L)
        return -1;
      switch (pattern1645 (x1, 
E_QImode))
        {
        case 0:
          if (!(
#line 25703 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 1767; /* *strmovqi_1 */

        case 1:
          if (!(
#line 25703 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 1768; /* *strmovqi_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_426 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  if (pattern35 (x1) != 0)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  operands[5] = x5;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  operands[6] = x7;
  x8 = XVECEXP (x1, 0, 2);
  x9 = XEXP (x8, 0);
  operands[3] = x9;
  if (!immediate_operand (operands[3], E_SImode))
    return -1;
  x10 = XVECEXP (x1, 0, 3);
  x11 = XEXP (x10, 0);
  operands[0] = x11;
  x12 = XVECEXP (x1, 0, 4);
  x13 = XEXP (x12, 0);
  operands[1] = x13;
  x14 = XVECEXP (x1, 0, 5);
  x15 = XEXP (x14, 0);
  operands[2] = x15;
  switch (GET_MODE (operands[4]))
    {
    case E_SImode:
      if (pattern1804 (
E_SImode) != 0
          || !(
#line 26066 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[CX_REG] || fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
        return -1;
      return 1789; /* *cmpstrnqi_nz_1 */

    case E_DImode:
      if (pattern1804 (
E_DImode) != 0
          || !(
#line 26066 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(fixed_regs[CX_REG] || fixed_regs[SI_REG] || fixed_regs[DI_REG])
   && ix86_check_no_addr_space (insn)) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
        return -1;
      return 1790; /* *cmpstrnqi_nz_1 */

    default:
      return -1;
    }
}

 int
recog_428 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_CODE (x2))
    {
    case UNSPEC_VOLATILE:
      if (XVECLEN (x2, 0) != 1
          || XINT (x2, 1) != 97)
        return -1;
      x3 = XVECEXP (x2, 0, 0);
      if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      operands[0] = x1;
      if (!vzeroall_operation (operands[0], E_VOIDmode)
          || !
#line 27235 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
        return -1;
      return 9015; /* *avx_vzeroall */

    case USE:
      operands[0] = x1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (save_multiple (operands[0], E_VOIDmode))
        {
          switch (GET_MODE (operands[1]))
            {
            case E_SImode:
              if (symbol_operand (operands[1], E_SImode)
                  && (
#line 30296 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_64BIT) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return 10071; /* *save_multiplesi */
              break;

            case E_DImode:
              if (symbol_operand (operands[1], E_DImode)
                  && (
#line 30296 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_64BIT) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return 10072; /* *save_multipledi */
              break;

            default:
              break;
            }
        }
      if (!restore_multiple (operands[0], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_SImode:
          if (!symbol_operand (operands[1], E_SImode)
              || !(
#line 30303 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_64BIT) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 10073; /* *restore_multiplesi */

        case E_DImode:
          if (!symbol_operand (operands[1], E_DImode)
              || !(
#line 30303 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_64BIT) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 10074; /* *restore_multipledi */

        default:
          return -1;
        }

    case SET:
      x5 = XEXP (x2, 1);
      if (GET_CODE (x5) != UNSPEC_VOLATILE)
        return -1;
      switch (XVECLEN (x5, 0))
        {
        case 2:
          if (pattern396 (x5, 
107) != 0)
            return -1;
          operands[2] = x1;
          if (!encodekey128_operation (operands[2], E_VOIDmode))
            return -1;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          if (!register_operand (operands[0], E_SImode))
            return -1;
          x6 = XVECEXP (x5, 0, 0);
          operands[1] = x6;
          if (!register_operand (operands[1], E_SImode)
              || !
#line 31288 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10287; /* *encodekey128u32 */

        case 3:
          if (pattern396 (x5, 
108) != 0)
            return -1;
          x7 = XVECEXP (x5, 0, 2);
          if (GET_CODE (x7) != REG
              || REGNO (x7) != 21
              || GET_MODE (x7) != E_V2DImode)
            return -1;
          operands[2] = x1;
          if (!encodekey256_operation (operands[2], E_VOIDmode))
            return -1;
          x4 = XEXP (x2, 0);
          operands[0] = x4;
          if (!register_operand (operands[0], E_SImode))
            return -1;
          x6 = XVECEXP (x5, 0, 0);
          operands[1] = x6;
          if (!register_operand (operands[1], E_SImode)
              || !
#line 31346 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10288; /* *encodekey256u32 */

        case 1:
          x4 = XEXP (x2, 0);
          if (GET_CODE (x4) != REG
              || REGNO (x4) != 17
              || GET_MODE (x4) != E_CCZmode)
            return -1;
          operands[1] = x1;
          if (!aeswidekl_operation (operands[1], E_VOIDmode)
              || GET_MODE (x5) != E_CCZmode)
            return -1;
          x6 = XVECEXP (x5, 0, 0);
          operands[0] = x6;
          if (!memory_operand (operands[0], E_BLKmode))
            return -1;
          switch (XINT (x5, 1))
            {
            case 103:
              if (!
#line 31430 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_WIDEKL))
                return -1;
              return 10293; /* *aesdecwide128klu8 */

            case 105:
              if (!
#line 31430 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_WIDEKL))
                return -1;
              return 10294; /* *aesdecwide256klu8 */

            case 104:
              if (!
#line 31430 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_WIDEKL))
                return -1;
              return 10295; /* *aesencwide128klu8 */

            case 106:
              if (!
#line 31430 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_WIDEKL))
                return -1;
              return 10296; /* *aesencwide256klu8 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 rtx_insn *
split_2 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  rtx_insn *res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_DFmode:
      if (!push_operand (operands[0], E_DFmode))
        return NULL;
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_DFmode
          || !fp_register_operand (operands[1], E_SFmode))
        return NULL;
      if ((
#line 5270 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
        return gen_split_70 (insn, operands);
      if (!(
#line 5270 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
        return NULL;
      return gen_split_71 (insn, operands);

    case E_XFmode:
      if (!push_operand (operands[0], E_XFmode))
        return NULL;
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_XFmode)
        return NULL;
      switch (GET_MODE (operands[1]))
        {
        case E_SFmode:
          if (!fp_register_operand (operands[1], E_SFmode))
            return NULL;
          if ((
#line 5277 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return gen_split_72 (insn, operands);
          if (!(
#line 5277 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return NULL;
          return gen_split_73 (insn, operands);

        case E_DFmode:
          if (!fp_register_operand (operands[1], E_DFmode))
            return NULL;
          if ((
#line 5277 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return gen_split_74 (insn, operands);
          if (!(
#line 5277 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return NULL;
          return gen_split_75 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_3 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ZERO_EXTRACT)
    return NULL;
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return NULL;
  x6 = XEXP (x3, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return NULL;
  x7 = XEXP (x1, 0);
  operands[0] = x7;
  x8 = XEXP (x4, 0);
  operands[1] = x8;
  x9 = XEXP (x4, 2);
  operands[2] = x9;
  if (!register_operand (operands[2], E_QImode))
    return NULL;
  x10 = XEXP (x2, 1);
  operands[3] = x10;
  x11 = XEXP (x2, 2);
  operands[4] = x11;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      switch (pattern1510 (x2, 
E_HImode))
        {
        case 0:
          if (!
#line 19332 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && TARGET_CMOVE
   && !(MEM_P (operands[3]) && MEM_P (operands[4]))
   && ix86_pre_reload_split ()))
            return NULL;
          return gen_split_836 (insn, operands);

        case 1:
          if (!(
#line 19332 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && TARGET_CMOVE
   && !(MEM_P (operands[3]) && MEM_P (operands[4]))
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_837 (insn, operands);

        default:
          return NULL;
        }

    case E_SImode:
      switch (pattern1510 (x2, 
E_SImode))
        {
        case 0:
          if (!
#line 19332 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && TARGET_CMOVE
   && !(MEM_P (operands[3]) && MEM_P (operands[4]))
   && ix86_pre_reload_split ()))
            return NULL;
          return gen_split_838 (insn, operands);

        case 1:
          if (!(
#line 19332 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && TARGET_CMOVE
   && !(MEM_P (operands[3]) && MEM_P (operands[4]))
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_839 (insn, operands);

        default:
          return NULL;
        }

    case E_DImode:
      switch (pattern1510 (x2, 
E_DImode))
        {
        case 0:
          if (!(
#line 19332 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && TARGET_CMOVE
   && !(MEM_P (operands[3]) && MEM_P (operands[4]))
   && ix86_pre_reload_split ()) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_840 (insn, operands);

        case 1:
          if (!(
#line 19332 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && TARGET_CMOVE
   && !(MEM_P (operands[3]) && MEM_P (operands[4]))
   && ix86_pre_reload_split ()) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_841 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_8 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case AND:
      switch (pattern70 (x3))
        {
        case 0:
          if (!(
#line 3716 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == -1
   && CONST_WIDE_INT_ELT (operands[3], 1) == 0) && 
#line 3722 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_30 (insn, operands);

        case 1:
          if (!(
#line 3738 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == 0
   && CONST_WIDE_INT_ELT (operands[3], 1) == -1) && 
#line 3744 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_33 (insn, operands);

        case 2:
          if (!(
#line 3760 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && CONST_INT_P (operands[3])
   && UINTVAL (operands[3]) == 0xffffffff00000000ll) && 
#line 3764 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_36 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      x5 = XEXP (x4, 1);
      operands[2] = x5;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[1] = x6;
          x7 = XEXP (x3, 1);
          switch (GET_CODE (x7))
            {
            case CONST_INT:
            case CONST_WIDE_INT:
              operands[3] = x7;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern599 (x3, 
E_QImode) != 0
                      || !(
#line 8027 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && ((unsigned HOST_WIDE_INT) INTVAL (operands[3])
       < (HOST_WIDE_INT_1U << INTVAL (operands[2])))) && 
#line 8031 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_167 (insn, operands);

                case E_HImode:
                  if (pattern599 (x3, 
E_HImode) != 0
                      || !(
#line 8027 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && ((unsigned HOST_WIDE_INT) INTVAL (operands[3])
       < (HOST_WIDE_INT_1U << INTVAL (operands[2])))) && 
#line 8031 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_169 (insn, operands);

                case E_SImode:
                  if (pattern599 (x3, 
E_SImode) != 0
                      || !(
#line 8051 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[3])
   < (HOST_WIDE_INT_1U << INTVAL (operands[2]))) && 
#line 8054 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_171 (insn, operands);

                case E_DImode:
                  if (GET_MODE (x3) != E_DImode
                      || GET_MODE (x4) != E_DImode)
                    return NULL;
                  if (register_operand (operands[0], E_DImode)
                      && register_no_SP_operand (operands[1], E_DImode)
                      && const_0_to_3_operand (operands[2], E_VOIDmode)
                      && const_int_operand (operands[3], E_VOIDmode)
                      && ((
#line 8051 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[3])
   < (HOST_WIDE_INT_1U << INTVAL (operands[2]))) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8054 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return gen_split_173 (insn, operands);
                  if (!nonimmediate_operand (operands[0], E_DImode)
                      || !register_operand (operands[1], E_DImode)
                      || !const_int_operand (operands[2], E_QImode)
                      || !const_scalar_int_operand (operands[3], E_DImode)
                      || !((
#line 14151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT / 2
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14165 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_474 (insn, operands);

                case E_TImode:
                  if (pattern600 (x3, 
E_TImode) != 0
                      || !((
#line 14151 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 16 * BITS_PER_UNIT / 2
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1196 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14165 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_477 (insn, operands);

                default:
                  return NULL;
                }

            case ZERO_EXTEND:
              switch (pattern943 (x3))
                {
                case 0:
                  if (!((
#line 14074 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14076 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_438 (insn, operands);

                case 1:
                  if (!((
#line 14074 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14076 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_441 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case SIGN_EXTEND:
          switch (pattern711 (x3))
            {
            case 0:
              if (!((
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14112 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_450 (insn, operands);

            case 1:
              if (!((
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14112 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_456 (insn, operands);

            case 2:
              if (!((
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14197 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_480 (insn, operands);

            case 3:
              if (!((
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14197 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_486 (insn, operands);

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          switch (pattern711 (x3))
            {
            case 0:
              if (!((
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14112 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_453 (insn, operands);

            case 1:
              if (!((
#line 14110 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14112 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_459 (insn, operands);

            case 2:
              if (!((
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14197 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_483 (insn, operands);

            case 3:
              if (!((
#line 14183 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14197 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_489 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case ZERO_EXTEND:
      switch (pattern404 (x3))
        {
        case 0:
          if (!((
#line 14091 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14093 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_444 (insn, operands);

        case 1:
          if (!((
#line 14091 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14093 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_447 (insn, operands);

        case 2:
          if (!((
#line 14135 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14137 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_462 (insn, operands);

        case 3:
          if (!((
#line 14135 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14137 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_468 (insn, operands);

        case 4:
          if (!((
#line 14135 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14137 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_465 (insn, operands);

        case 5:
          if (!((
#line 14135 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14137 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_471 (insn, operands);

        case 6:
          if (!((
#line 14212 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(DImode == DImode
   ? CONST_INT_P (operands[2])
     && (UINTVAL (operands[2]) & GET_MODE_MASK (SImode)) == 0
     && !ix86_endbr_immediate_operand (operands[2], VOIDmode)
   : CONST_WIDE_INT_P (operands[2])
     && CONST_WIDE_INT_NUNITS (operands[2]) == 2
     && CONST_WIDE_INT_ELT (operands[2], 0) == 0
     && !ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[2],
								    1)),
				       VOIDmode)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14223 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_492 (insn, operands);

        case 7:
          if (!((
#line 14212 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TImode == DImode
   ? CONST_INT_P (operands[2])
     && (UINTVAL (operands[2]) & GET_MODE_MASK (SImode)) == 0
     && !ix86_endbr_immediate_operand (operands[2], VOIDmode)
   : CONST_WIDE_INT_P (operands[2])
     && CONST_WIDE_INT_NUNITS (operands[2]) == 2
     && CONST_WIDE_INT_ELT (operands[2], 0) == 0
     && !ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[2],
								    1)),
				       VOIDmode)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14223 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_495 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_16 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  switch (GET_CODE (x4))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[2] = x4;
      x5 = XEXP (x2, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
        case MEM:
          operands[0] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (pattern560 (x3, 
E_DImode) == 0
                  && ((
#line 8081 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 8083 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_174 (insn, operands);
              break;

            case E_TImode:
              if (pattern560 (x3, 
E_TImode) == 0
                  && ((
#line 8081 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8083 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_175 (insn, operands);
              break;

            default:
              break;
            }
          break;

        case STRICT_LOW_PART:
          switch (pattern1312 (x2))
            {
            case 0:
              if ((
#line 8201 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8205 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
                return gen_split_178 (insn, operands);
              break;

            case 1:
              if ((
#line 8201 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8205 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
                return gen_split_179 (insn, operands);
              break;

            default:
              break;
            }
          break;

        default:
          break;
        }
      if (GET_CODE (x4) != SUBREG
          || pattern811 (x4) != 0
          || GET_CODE (x5) != STRICT_LOW_PART)
        return NULL;
      x6 = XEXP (x5, 0);
      operands[0] = x6;
      if (!register_operand (operands[0], E_QImode)
          || GET_MODE (x3) != E_QImode
          || !nonimmediate_operand (operands[1], E_QImode))
        return NULL;
      x7 = XEXP (x4, 0);
      x8 = XEXP (x7, 0);
      operands[2] = x8;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return NULL;
      switch (pattern1782 ())
        {
        case 0:
          if (!(
#line 8227 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8231 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return NULL;
          return gen_split_180 (insn, operands);

        case 1:
          if (!(
#line 8227 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8231 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return NULL;
          return gen_split_181 (insn, operands);

        case 2:
          if (!((
#line 8227 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8231 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return NULL;
          return gen_split_182 (insn, operands);

        default:
          return NULL;
        }

    case ZERO_EXTEND:
      switch (pattern1149 (x2))
        {
        case 0:
          if (!((
#line 8115 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 8117 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_176 (insn, operands);

        case 1:
          if (!((
#line 8115 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 8117 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_177 (insn, operands);

        default:
          return NULL;
        }

    case EQ:
      x9 = XEXP (x4, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      switch (pattern685 (x2))
        {
        case 0:
          if (!(
#line 10319 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, QImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10322 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_236 (insn, operands);

        case 1:
          if (!(
#line 10319 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, HImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10322 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_237 (insn, operands);

        case 2:
          if (!(
#line 10319 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, SImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10322 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_238 (insn, operands);

        case 3:
          if (!((
#line 10319 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10322 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_239 (insn, operands);

        default:
          return NULL;
        }

    case NE:
      x9 = XEXP (x4, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      switch (pattern685 (x2))
        {
        case 0:
          if (!(
#line 10340 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, QImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10343 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_240 (insn, operands);

        case 1:
          if (!(
#line 10340 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, HImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10343 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_241 (insn, operands);

        case 2:
          if (!(
#line 10340 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, SImode, operands)
   && ix86_pre_reload_split ()) && 
#line 10343 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_242 (insn, operands);

        case 3:
          if (!((
#line 10340 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (MINUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 10343 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_243 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_26 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (pattern231 (x2, 
E_CCmode, 
17) != 0)
    return NULL;
  x3 = XVECEXP (x1, 0, 0);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      switch (pattern202 (x3))
        {
        case 0:
          x6 = XEXP (x3, 0);
          operands[0] = x6;
          x7 = XEXP (x4, 1);
          switch (GET_CODE (x7))
            {
            case REG:
            case SUBREG:
              if (GET_CODE (x7) == SUBREG)
                {
                  switch (pattern1320 (x4))
                    {
                    case 0:
                      if (((
#line 15217 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (4 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 4 * BITS_PER_UNIT - 1))
	 == (2 * 4 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 15222 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_558 (insn, operands);
                      break;

                    case 1:
                      if (((
#line 15217 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 15222 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_559 (insn, operands);
                      break;

                    default:
                      break;
                    }
                }
              operands[2] = x7;
              if (register_operand (operands[2], E_QImode)
                  && register_operand (operands[0], E_SImode)
                  && GET_MODE (x4) == E_SImode
                  && nonimmediate_operand (operands[1], E_SImode)
                  && 
#line 16002 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed))
                return gen_split_578 (insn, operands);
              if (GET_CODE (x7) == SUBREG
                  && known_eq (SUBREG_BYTE (x7), 0)
                  && GET_MODE (x7) == E_QImode)
                {
                  switch (pattern1152 (x4, 
E_SImode))
                    {
                    case 0:
                      if ((
#line 17854 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1))
      == 4 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 17859 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_644 (insn, operands);
                      break;

                    case 1:
                      if ((
#line 17902 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 17906 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_656 (insn, operands);
                      break;

                    case 2:
                      if ((
#line 17948 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 17952 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return gen_split_668 (insn, operands);
                      break;

                    default:
                      break;
                    }
                }
              break;

            case CONST_INT:
              operands[2] = x7;
              if (const_0_to_3_operand (operands[2], E_VOIDmode))
                {
                  switch (GET_MODE (operands[0]))
                    {
                    case E_QImode:
                      if (general_reg_operand (operands[0], E_QImode)
                          && GET_MODE (x4) == E_QImode
                          && index_reg_operand (operands[1], E_QImode)
                          && 
#line 16297 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && REGNO (operands[0]) != REGNO (operands[1])))
                        return gen_split_583 (insn, operands);
                      break;

                    case E_HImode:
                      if (general_reg_operand (operands[0], E_HImode)
                          && GET_MODE (x4) == E_HImode
                          && index_reg_operand (operands[1], E_HImode)
                          && 
#line 16297 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && REGNO (operands[0]) != REGNO (operands[1])))
                        return gen_split_584 (insn, operands);
                      break;

                    case E_SImode:
                      if (general_reg_operand (operands[0], E_SImode)
                          && GET_MODE (x4) == E_SImode
                          && index_reg_operand (operands[1], E_SImode)
                          && 
#line 16297 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
   && REGNO (operands[0]) != REGNO (operands[1])))
                        return gen_split_585 (insn, operands);
                      break;

                    default:
                      break;
                    }
                }
              break;

            default:
              break;
            }
          operands[2] = x7;
          res = split_19 (x1, insn);
          if (res != NULL_RTX)
            return res;
          if (GET_CODE (x7) != SUBREG)
            return NULL;
          switch (pattern1153 (x3, 
E_DImode))
            {
            case 0:
              if (!((
#line 17854 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1))
      == 8 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17859 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_647 (insn, operands);

            case 1:
              if (!((
#line 17902 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17906 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_659 (insn, operands);

            case 2:
              if (!((
#line 17948 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17952 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_671 (insn, operands);

            default:
              return NULL;
            }

        case 1:
          if (register_operand (operands[0], E_DImode)
              && register_operand (operands[1], E_DImode)
              && ((
#line 15278 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (4 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 4 * BITS_PER_UNIT - 1))
	 == (2 * 4 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 15283 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_560 (insn, operands);
          if (!nonimmediate_operand (operands[0], E_DImode)
              || !nonimmediate_operand (operands[1], E_DImode)
              || !((
#line 17879 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1))
      == 8 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_653 (insn, operands);

        case 2:
          if (!((
#line 15278 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 15283 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_561 (insn, operands);

        case 3:
          if (!(
#line 17879 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1))
      == 4 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 17884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_650 (insn, operands);

        case 4:
          if (!(
#line 17926 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 17930 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_662 (insn, operands);

        case 5:
          if (!((
#line 17926 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17930 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_665 (insn, operands);

        case 6:
          if (!(
#line 17978 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 17982 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_674 (insn, operands);

        case 7:
          if (!((
#line 17978 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 17982 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_677 (insn, operands);

        default:
          return NULL;
        }

    case SIGN_EXTEND:
      switch (pattern381 (x3))
        {
        case 0:
          if (!((
#line 15379 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 4 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 4 * BITS_PER_UNIT * 2) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 15382 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_564 (insn, operands);

        case 1:
          if (!((
#line 15379 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 8 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 8 * BITS_PER_UNIT * 2) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 15382 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_566 (insn, operands);

        default:
          return NULL;
        }

    case ZERO_EXTEND:
      switch (pattern381 (x3))
        {
        case 0:
          if (!((
#line 15379 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 4 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 4 * BITS_PER_UNIT * 2) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 15382 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_565 (insn, operands);

        case 1:
          if (!((
#line 15379 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 8 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 8 * BITS_PER_UNIT * 2) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 15382 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_567 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_33 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  switch (pattern406 (x1))
    {
    case 0:
      if (!(
#line 18204 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (QImode)-1))
      == GET_MODE_BITSIZE (QImode)-1
   && ix86_pre_reload_split ()) && 
#line 18209 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_700 (insn, operands);

    case 1:
      if (!(
#line 18204 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (HImode)-1))
      == GET_MODE_BITSIZE (HImode)-1
   && ix86_pre_reload_split ()) && 
#line 18209 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_702 (insn, operands);

    case 2:
      if (!(
#line 18204 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18209 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_704 (insn, operands);

    case 3:
      if (!((
#line 18204 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18209 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_706 (insn, operands);

    case 4:
      if (!(
#line 18285 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18289 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_732 (insn, operands);

    case 5:
      if (!(
#line 18285 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18289 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_734 (insn, operands);

    case 6:
      if (!(
#line 18285 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18289 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_736 (insn, operands);

    case 7:
      if (!((
#line 18285 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18289 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_738 (insn, operands);

    case 8:
      if (!(
#line 18354 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18358 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_764 (insn, operands);

    case 9:
      if (!(
#line 18354 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18358 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_766 (insn, operands);

    case 10:
      if (!(
#line 18354 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18358 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_768 (insn, operands);

    case 11:
      if (!((
#line 18354 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18358 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_770 (insn, operands);

    case 12:
      x2 = XVECEXP (x1, 0, 0);
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      x4 = XEXP (x2, 1);
      switch (pattern1167 (x4))
        {
        case 0:
          if ((
#line 18156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (QImode)-1))
      == GET_MODE_BITSIZE (QImode)-1
   && ix86_pre_reload_split ()) && 
#line 18161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_684 (insn, operands);
          break;

        case 1:
          if ((
#line 18156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (HImode)-1))
      == GET_MODE_BITSIZE (HImode)-1
   && ix86_pre_reload_split ()) && 
#line 18161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_686 (insn, operands);
          break;

        case 2:
          if ((
#line 18156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_688 (insn, operands);
          break;

        case 3:
          if (((
#line 18156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_690 (insn, operands);
          break;

        case 4:
          if ((
#line 18249 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18253 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_716 (insn, operands);
          break;

        case 5:
          if ((
#line 18249 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18253 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_718 (insn, operands);
          break;

        case 6:
          if ((
#line 18249 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18253 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_720 (insn, operands);
          break;

        case 7:
          if (((
#line 18249 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18253 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_722 (insn, operands);
          break;

        case 8:
          if ((
#line 18318 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18322 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_748 (insn, operands);
          break;

        case 9:
          if ((
#line 18318 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18322 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_750 (insn, operands);
          break;

        case 10:
          if ((
#line 18318 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 18322 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_752 (insn, operands);
          break;

        case 11:
          if (((
#line 18318 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18322 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_754 (insn, operands);
          break;

        case 12:
          x5 = XEXP (x4, 1);
          operands[2] = x5;
          switch (pattern1325 (x4))
            {
            case 0:
              if (
#line 18555 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed && !optimize_function_for_size_p (cfun)))
                return gen_split_788 (insn, operands);
              break;

            case 1:
              if ((
#line 18555 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && reload_completed && !optimize_function_for_size_p (cfun)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_789 (insn, operands);
              break;

            default:
              break;
            }
          if (XWINT (x5, 0) == 8L
              && QIreg_operand (operands[0], E_HImode)
              && GET_MODE (x4) == E_HImode)
            {
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0])
                  && 
#line 18755 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
  && (TARGET_USE_XCHGB || optimize_function_for_size_p (cfun))))
                return gen_split_800 (insn, operands);
            }
          break;

        default:
          break;
        }
      x5 = XEXP (x4, 1);
      operands[2] = x5;
      switch (pattern1168 (x2))
        {
        case 0:
          if (!(
#line 18722 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 18733 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_796 (insn, operands);

        case 1:
          if (!(
#line 18722 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 18733 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_798 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_43 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x2, 1);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x5 = XEXP (x1, 0);
      operands[0] = x5;
      if (!flags_reg_operand (operands[0], E_VOIDmode))
        return NULL;
      operands[1] = x2;
      if (!compare_operator (operands[1], E_VOIDmode))
        return NULL;
      x6 = XEXP (x3, 0);
      operands[2] = x6;
      if (!aligned_operand (operands[2], E_HImode))
        return NULL;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      if (!const_int_operand (operands[3], E_HImode)
          || !
#line 27749 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(! TARGET_PARTIAL_REG_STALL && reload_completed
   && ! TARGET_FAST_PREFIX
   && optimize_insn_for_speed_p ()
   /* Ensure that the operand will remain sign-extended immediate.  */
   && ix86_match_ccmode (insn, INTVAL (operands[3]) >= 0 ? CCNOmode : CCZmode)))
        return NULL;
      return gen_split_991 (insn, operands);

    case UNSPEC:
      if (XVECLEN (x3, 0) != 1
          || XINT (x3, 1) != 49
          || GET_MODE (x3) != E_SImode
          || pattern44 (x1, 
E_CCZmode) != 0)
        return NULL;
      x4 = XEXP (x2, 1);
      operands[2] = x4;
      if (!const_int_operand (operands[2], E_VOIDmode))
        return NULL;
      x8 = XVECEXP (x3, 0, 0);
      switch (GET_CODE (x8))
        {
        case EQ:
          x9 = XEXP (x8, 0);
          operands[0] = x9;
          x10 = XEXP (x8, 1);
          operands[1] = x10;
          switch (GET_MODE (x8))
            {
            case E_V32QImode:
              if (!vector_operand (operands[0], E_V32QImode)
                  || !const0_operand (operands[1], E_V32QImode)
                  || !(
#line 22401 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && (INTVAL (operands[2]) == (int) (0xffffffff))) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
                return NULL;
              return gen_split_3466 (insn, operands);

            case E_V16QImode:
              if (!vector_operand (operands[0], E_V16QImode)
                  || !const0_operand (operands[1], E_V16QImode)
                  || !
#line 22401 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && (INTVAL (operands[2]) == (int) (0xffff))))
                return NULL;
              return gen_split_3467 (insn, operands);

            default:
              return NULL;
            }

        case VEC_MERGE:
          switch (pattern1246 (x8))
            {
            case 0:
              if (!((
#line 22418 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && UINTVAL (operands[2]) <= 0xffffffff) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 22420 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3468 (insn, operands);

            case 1:
              if (!(
#line 22418 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && UINTVAL (operands[2]) <= 0xffff) && 
#line 22420 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3469 (insn, operands);

            case 2:
              if (!((
#line 22441 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && (INTVAL (operands[2]) == (int) (0xffffffff))) && 
#line 629 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 22443 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3470 (insn, operands);

            case 3:
              if (!(
#line 22441 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && (INTVAL (operands[2]) == (int) (0xffff))) && 
#line 22443 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3471 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_46 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT)
    return NULL;
  switch (pattern90 (x1))
    {
    case 0:
      x4 = XEXP (x3, 0);
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], E_V2SFmode))
        return NULL;
      x5 = XEXP (x3, 1);
      if (XVECLEN (x5, 0) != 1)
        return NULL;
      x6 = XEXP (x2, 1);
      x7 = XEXP (x6, 1);
      if (XVECLEN (x7, 0) != 1
          || !register_operand (operands[0], E_SFmode)
          || GET_MODE (x2) != E_SFmode
          || GET_MODE (x3) != E_SFmode)
        return NULL;
      x8 = XVECEXP (x5, 0, 0);
      operands[2] = x8;
      if (!const_0_to_1_operand (operands[2], E_SImode)
          || GET_MODE (x6) != E_SFmode)
        return NULL;
      x9 = XVECEXP (x7, 0, 0);
      operands[3] = x9;
      if (!const_0_to_1_operand (operands[3], E_SImode))
        return NULL;
      x10 = XEXP (x6, 0);
      if (!rtx_equal_p (x10, operands[1])
          || !(
#line 1012 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE3 && TARGET_MMX_WITH_SSE && ix86_partial_vec_fp_math
   && INTVAL (operands[2]) != INTVAL (operands[3])
   && ix86_pre_reload_split ()) && 
#line 1016 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( 1)))
        return NULL;
      return gen_split_1034 (insn, operands);

    case 1:
      switch (pattern847 (x2))
        {
        case 0:
          if (!
#line 22623 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && reload_completed
   && SSE_REGNO_P (REGNO (operands[0]))))
            return NULL;
          return gen_split_3472 (insn, operands);

        case 1:
          if (!
#line 22710 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && reload_completed
   && SSE_REGNO_P (REGNO (operands[0]))))
            return NULL;
          return gen_split_3476 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_48 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (GET_CODE (x4) != CONST_INT)
    return NULL;
  x5 = XEXP (x2, 0);
  operands[1] = x5;
  switch (XWINT (x4, 0))
    {
    case 0L:
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          switch (pattern963 (x2))
            {
            case 0:
              if ((
#line 1783 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1786 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return gen_split_1038 (insn, operands);
              break;

            case 1:
              if ((
#line 12309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 12311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1562 (insn, operands);
              break;

            default:
              break;
            }
          break;

        case E_SImode:
          if (nonimmediate_operand (operands[0], E_SImode)
              && GET_MODE (x2) == E_SImode)
            {
              switch (GET_MODE (operands[1]))
                {
                case E_V2SImode:
                  if (nonimmediate_operand (operands[1], E_V2SImode)
                      && (
#line 5729 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 5732 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                    return gen_split_1124 (insn, operands);
                  break;

                case E_V4SImode:
                  if (register_operand (operands[1], E_V4SImode)
                      && 
#line 21192 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
                    return gen_split_3396 (insn, operands);
                  break;

                default:
                  break;
                }
            }
          break;

        case E_HFmode:
          switch (pattern964 (x2))
            {
            case 0:
              if (((
#line 13218 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 548 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 13220 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1585 (insn, operands);
              break;

            case 1:
              if ((
#line 13218 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13220 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1586 (insn, operands);
              break;

            case 2:
              if ((
#line 13218 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13220 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1587 (insn, operands);
              break;

            default:
              break;
            }
          break;

        case E_BFmode:
          switch (pattern965 (x2))
            {
            case 0:
              if (((
#line 13218 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 13220 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1588 (insn, operands);
              break;

            case 1:
              if ((
#line 13218 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13220 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1589 (insn, operands);
              break;

            case 2:
              if ((
#line 13218 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 13220 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_1590 (insn, operands);
              break;

            default:
              break;
            }
          break;

        case E_DFmode:
          if (register_operand (operands[0], E_DFmode)
              && GET_MODE (x2) == E_DFmode
              && nonimmediate_operand (operands[1], E_V2DFmode)
              && 
#line 14656 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && reload_completed))
            return gen_split_3179 (insn, operands);
          break;

        case E_QImode:
          if (memory_operand (operands[0], E_QImode)
              && GET_MODE (x2) == E_QImode
              && register_operand (operands[1], E_V16QImode)
              && ((
#line 21052 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && !TARGET_SSE4_1
   && (TARGET_INTER_UNIT_MOVES_FROM_VEC
       || optimize_function_for_speed_p (cfun))
   && ix86_pre_reload_split ()) && 
#line 21045 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1)) && 
#line 21058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3393 (insn, operands);
          break;

        case E_HImode:
          if (memory_operand (operands[0], E_HImode)
              && GET_MODE (x2) == E_HImode
              && register_operand (operands[1], E_V8HImode)
              && (
#line 21052 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2
   && !TARGET_SSE4_1
   && (TARGET_INTER_UNIT_MOVES_FROM_VEC
       || optimize_function_for_speed_p (cfun))
   && ix86_pre_reload_split ()) && 
#line 21058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3394 (insn, operands);
          break;

        case E_TImode:
          if (nonimmediate_operand (operands[0], E_TImode)
              && GET_MODE (x2) == E_TImode)
            {
              switch (GET_MODE (operands[1]))
                {
                case E_V4TImode:
                  if (register_operand (operands[1], E_V4TImode)
                      && (
#line 21426 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && reload_completed
   && (TARGET_AVX512VL || !EXT_REX_SSE_REG_P (operands[1]))) && 
#line 21419 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                    return gen_split_3404 (insn, operands);
                  break;

                case E_V2TImode:
                  if (register_operand (operands[1], E_V2TImode)
                      && 
#line 21426 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX
   && reload_completed
   && (TARGET_AVX512VL || !EXT_REX_SSE_REG_P (operands[1]))))
                    return gen_split_3405 (insn, operands);
                  break;

                default:
                  break;
                }
            }
          break;

        default:
          break;
        }
      break;

    case 1L:
      switch (GET_MODE (operands[0]))
        {
        case E_SFmode:
          if (register_operand (operands[0], E_SFmode)
              && GET_MODE (x2) == E_SFmode
              && memory_operand (operands[1], E_V2SFmode)
              && 
#line 1827 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && reload_completed))
            return gen_split_1039 (insn, operands);
          break;

        case E_SImode:
          if (register_operand (operands[0], E_SImode)
              && GET_MODE (x2) == E_SImode
              && memory_operand (operands[1], E_V2SImode)
              && 
#line 5816 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && reload_completed))
            return gen_split_1126 (insn, operands);
          break;

        case E_DFmode:
          if (register_operand (operands[0], E_DFmode)
              && GET_MODE (x2) == E_DFmode
              && memory_operand (operands[1], E_V2DFmode)
              && 
#line 14603 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && reload_completed))
            return gen_split_3177 (insn, operands);
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (GET_MODE (x2) != E_SFmode)
        return NULL;
      if (nonimmediate_operand (operands[0], E_SFmode)
          && register_operand (operands[1], E_V4SFmode)
          && const_0_to_3_operand (operands[2], E_SImode)
          && (
#line 12320 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 12327 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed && SSE_REG_P (operands[0]))))
        return gen_split_1563 (insn, operands);
      if (!register_operand (operands[0], E_SFmode)
          || !memory_operand (operands[1], E_V4SFmode)
          || !const_0_to_3_operand (operands[2], E_VOIDmode)
          || !(
#line 12363 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 12365 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
        return NULL;
      return gen_split_1564 (insn, operands);

    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || GET_MODE (x2) != E_QImode
          || !memory_operand (operands[1], E_V16QImode)
          || !const_0_to_15_operand (operands[2], E_VOIDmode)
          || !
#line 21379 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
        return NULL;
      return gen_split_3400 (insn, operands);

    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x2) != E_HImode
          || !memory_operand (operands[1], E_V8HImode)
          || !const_0_to_7_operand (operands[2], E_VOIDmode)
          || !
#line 21379 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
        return NULL;
      return gen_split_3401 (insn, operands);

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x2) != E_SImode
          || !memory_operand (operands[1], E_V4SImode)
          || !const_0_to_3_operand (operands[2], E_VOIDmode)
          || !
#line 21379 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
        return NULL;
      return gen_split_3402 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_56 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (XINT (x2, 1) != 164)
    return NULL;
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XVECEXP (x2, 0, 3);
  operands[4] = x6;
  if (!const_0_to_255_operand (operands[4], E_SImode))
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      if (pattern958 (x2, 
E_V64QImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V64QImode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1593 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V64QImode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1617 (insn, operands);

    case E_V32QImode:
      if (pattern958 (x2, 
E_V32QImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V32QImode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1594 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V32QImode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1618 (insn, operands);

    case E_V16QImode:
      if (pattern958 (x2, 
E_V16QImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16QImode)
          && 
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1595 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16QImode)
          || !
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1619 (insn, operands);

    case E_V32HImode:
      if (pattern958 (x2, 
E_V32HImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V32HImode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1596 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V32HImode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1620 (insn, operands);

    case E_V16HImode:
      if (pattern958 (x2, 
E_V16HImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16HImode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1597 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16HImode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1621 (insn, operands);

    case E_V8HImode:
      if (pattern958 (x2, 
E_V8HImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8HImode)
          && 
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1598 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8HImode)
          || !
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1622 (insn, operands);

    case E_V16SImode:
      if (pattern958 (x2, 
E_V16SImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16SImode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1599 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16SImode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1623 (insn, operands);

    case E_V8SImode:
      if (pattern958 (x2, 
E_V8SImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8SImode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1600 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8SImode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1624 (insn, operands);

    case E_V4SImode:
      if (pattern958 (x2, 
E_V4SImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V4SImode)
          && 
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1601 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V4SImode)
          || !
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1625 (insn, operands);

    case E_V8DImode:
      if (pattern958 (x2, 
E_V8DImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8DImode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1602 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8DImode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1626 (insn, operands);

    case E_V4DImode:
      if (pattern958 (x2, 
E_V4DImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V4DImode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1603 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V4DImode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1627 (insn, operands);

    case E_V2DImode:
      if (pattern958 (x2, 
E_V2DImode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V2DImode)
          && 
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1604 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V2DImode)
          || !
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1628 (insn, operands);

    case E_V32HFmode:
      if (pattern958 (x2, 
E_V32HFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V32HFmode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1605 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V32HFmode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1629 (insn, operands);

    case E_V16HFmode:
      if (pattern958 (x2, 
E_V16HFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16HFmode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1606 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16HFmode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1630 (insn, operands);

    case E_V8HFmode:
      if (pattern958 (x2, 
E_V8HFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8HFmode)
          && 
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1607 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8HFmode)
          || !
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1631 (insn, operands);

    case E_V32BFmode:
      if (pattern958 (x2, 
E_V32BFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V32BFmode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1608 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V32BFmode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1632 (insn, operands);

    case E_V16BFmode:
      if (pattern958 (x2, 
E_V16BFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16BFmode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1609 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16BFmode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1633 (insn, operands);

    case E_V8BFmode:
      if (pattern958 (x2, 
E_V8BFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8BFmode)
          && 
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1610 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8BFmode)
          || !
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1634 (insn, operands);

    case E_V16SFmode:
      if (pattern958 (x2, 
E_V16SFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V16SFmode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1611 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V16SFmode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1635 (insn, operands);

    case E_V8SFmode:
      if (pattern958 (x2, 
E_V8SFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8SFmode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1612 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8SFmode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1636 (insn, operands);

    case E_V4SFmode:
      if (pattern958 (x2, 
E_V4SFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V4SFmode)
          && 
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3))
        return gen_split_1613 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V4SFmode)
          || !
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0))
        return NULL;
      return gen_split_1637 (insn, operands);

    case E_V8DFmode:
      if (pattern958 (x2, 
E_V8DFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V8DFmode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1614 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V8DFmode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1638 (insn, operands);

    case E_V4DFmode:
      if (pattern958 (x2, 
E_V4DFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V4DFmode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1615 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V4DFmode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1639 (insn, operands);

    case E_V2DFmode:
      if (pattern958 (x2, 
E_V2DFmode) != 0)
        return NULL;
      if (memory_operand (operands[3], E_V2DFmode)
          && (
#line 13685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) == 3) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return gen_split_1616 (insn, operands);
      if (!nonimmediate_operand (operands[3], E_V2DFmode)
          || !(
#line 13706 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(!reload_completed && vpternlog_redundant_operand_mask (operands[4]) != 0) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return NULL;
      return gen_split_1640 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_70 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern533 (x2))
        {
        case 0:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2007 (insn, operands);

        case 1:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2034 (insn, operands);

        case 2:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2061 (insn, operands);

        case 3:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2088 (insn, operands);

        case 4:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2115 (insn, operands);

        case 5:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2142 (insn, operands);

        case 6:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2169 (insn, operands);

        case 7:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2196 (insn, operands);

        case 8:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2223 (insn, operands);

        case 9:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2250 (insn, operands);

        case 10:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2277 (insn, operands);

        case 11:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2304 (insn, operands);

        case 12:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2010 (insn, operands);

        case 13:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2037 (insn, operands);

        case 14:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2064 (insn, operands);

        case 15:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2091 (insn, operands);

        case 16:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2118 (insn, operands);

        case 17:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2145 (insn, operands);

        case 18:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2172 (insn, operands);

        case 19:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2199 (insn, operands);

        case 20:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2226 (insn, operands);

        case 21:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2253 (insn, operands);

        case 22:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2280 (insn, operands);

        case 23:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2307 (insn, operands);

        case 24:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2013 (insn, operands);

        case 25:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2040 (insn, operands);

        case 26:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2067 (insn, operands);

        case 27:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2094 (insn, operands);

        case 28:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2121 (insn, operands);

        case 29:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2148 (insn, operands);

        case 30:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2175 (insn, operands);

        case 31:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2202 (insn, operands);

        case 32:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2229 (insn, operands);

        case 33:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2256 (insn, operands);

        case 34:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2283 (insn, operands);

        case 35:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2310 (insn, operands);

        case 36:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3075 (insn, operands);

        case 37:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3084 (insn, operands);

        case 38:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3093 (insn, operands);

        case 39:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3102 (insn, operands);

        case 40:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3111 (insn, operands);

        case 41:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3120 (insn, operands);

        case 42:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3129 (insn, operands);

        case 43:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3138 (insn, operands);

        case 44:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3147 (insn, operands);

        case 45:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3156 (insn, operands);

        case 46:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3165 (insn, operands);

        case 47:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3174 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      switch (pattern534 (x2))
        {
        case 0:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2655 (insn, operands);

        case 1:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2682 (insn, operands);

        case 2:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2709 (insn, operands);

        case 3:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2736 (insn, operands);

        case 4:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2763 (insn, operands);

        case 5:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2790 (insn, operands);

        case 6:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2817 (insn, operands);

        case 7:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2844 (insn, operands);

        case 8:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2871 (insn, operands);

        case 9:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2898 (insn, operands);

        case 10:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2925 (insn, operands);

        case 11:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2952 (insn, operands);

        default:
          return NULL;
        }

    case IOR:
      switch (pattern534 (x2))
        {
        case 0:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2658 (insn, operands);

        case 1:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2685 (insn, operands);

        case 2:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2712 (insn, operands);

        case 3:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2739 (insn, operands);

        case 4:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2766 (insn, operands);

        case 5:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2793 (insn, operands);

        case 6:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2820 (insn, operands);

        case 7:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2847 (insn, operands);

        case 8:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2874 (insn, operands);

        case 9:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2901 (insn, operands);

        case 10:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2928 (insn, operands);

        case 11:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2955 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern534 (x2))
        {
        case 0:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2661 (insn, operands);

        case 1:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2688 (insn, operands);

        case 2:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2715 (insn, operands);

        case 3:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2742 (insn, operands);

        case 4:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2769 (insn, operands);

        case 5:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2796 (insn, operands);

        case 6:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2823 (insn, operands);

        case 7:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2850 (insn, operands);

        case 8:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2877 (insn, operands);

        case 9:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2904 (insn, operands);

        case 10:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2931 (insn, operands);

        case 11:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2958 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_78 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case MINUS:
      x4 = XEXP (x2, 1);
      if (GET_CODE (x4) != PLUS)
        return NULL;
      operands[6] = x2;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      x7 = XEXP (x4, 0);
      operands[3] = x7;
      x8 = XEXP (x4, 1);
      operands[4] = x8;
      x9 = XEXP (x2, 2);
      operands[5] = x9;
      if (!const_int_operand (operands[5], E_VOIDmode))
        return NULL;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern1431 (x2, 
E_V8SFmode) != 0
              || !(
#line 3541 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_1306 (insn, operands);

        case E_V4SFmode:
          if (pattern1431 (x2, 
E_V4SFmode) != 0
              || !
#line 3541 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))))
            return NULL;
          return gen_split_1307 (insn, operands);

        case E_V4DFmode:
          if (pattern1431 (x2, 
E_V4DFmode) != 0
              || !(
#line 3541 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_1308 (insn, operands);

        case E_V2DFmode:
          if (pattern1431 (x2, 
E_V2DFmode) != 0
              || !(
#line 3541 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return NULL;
          return gen_split_1309 (insn, operands);

        default:
          return NULL;
        }

    case PLUS:
      x4 = XEXP (x2, 1);
      if (GET_CODE (x4) != MINUS)
        return NULL;
      operands[6] = x2;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      x7 = XEXP (x4, 0);
      operands[3] = x7;
      x8 = XEXP (x4, 1);
      operands[4] = x8;
      x9 = XEXP (x2, 2);
      operands[5] = x9;
      if (!const_int_operand (operands[5], E_VOIDmode))
        return NULL;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern1432 (x2, 
E_V8SFmode) != 0
              || !(
#line 3563 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_1310 (insn, operands);

        case E_V4SFmode:
          if (pattern1432 (x2, 
E_V4SFmode) != 0
              || !
#line 3563 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))))
            return NULL;
          return gen_split_1311 (insn, operands);

        case E_V4DFmode:
          if (pattern1432 (x2, 
E_V4DFmode) != 0
              || !(
#line 3563 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return NULL;
          return gen_split_1312 (insn, operands);

        case E_V2DFmode:
          if (pattern1432 (x2, 
E_V2DFmode) != 0
              || !(
#line 3563 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return NULL;
          return gen_split_1313 (insn, operands);

        default:
          return NULL;
        }

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case REG:
    case SUBREG:
    case MEM:
      switch (GET_CODE (x3))
        {
        case REG:
        case SUBREG:
        case MEM:
          res = split_57 (x1, insn);
          if (res != NULL_RTX)
            return res;
          break;

        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          switch (pattern317 (x2))
            {
            case 0:
              res = split_58 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case 1:
              if (vector_all_ones_operand (operands[1], E_V16QImode)
                  && const0_operand (operands[2], E_V16QImode)
                  && (
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3303 (insn, operands);
              if (const0_operand (operands[1], E_V16QImode)
                  && vector_all_ones_operand (operands[2], E_V16QImode)
                  && (
#line 18164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3326 (insn, operands);
              break;

            case 2:
              if (vector_all_ones_operand (operands[1], E_V8HImode)
                  && const0_operand (operands[2], E_V8HImode)
                  && (
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3305 (insn, operands);
              if (const0_operand (operands[1], E_V8HImode)
                  && vector_all_ones_operand (operands[2], E_V8HImode)
                  && (
#line 18164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3327 (insn, operands);
              break;

            case 3:
              if (vector_all_ones_operand (operands[1], E_V4SImode)
                  && const0_operand (operands[2], E_V4SImode)
                  && (
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3307 (insn, operands);
              if (const0_operand (operands[1], E_V4SImode)
                  && vector_all_ones_operand (operands[2], E_V4SImode)
                  && (
#line 18164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3328 (insn, operands);
              break;

            case 4:
              if (vector_all_ones_operand (operands[1], E_V2DImode)
                  && const0_operand (operands[2], E_V2DImode)
                  && (
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3309 (insn, operands);
              if (const0_operand (operands[1], E_V2DImode)
                  && vector_all_ones_operand (operands[2], E_V2DImode)
                  && (
#line 18164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3329 (insn, operands);
              break;

            case 5:
              if (vector_all_ones_operand (operands[1], E_V32QImode)
                  && const0_operand (operands[2], E_V32QImode)
                  && (
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3311 (insn, operands);
              if (const0_operand (operands[1], E_V32QImode)
                  && vector_all_ones_operand (operands[2], E_V32QImode)
                  && (
#line 18164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3330 (insn, operands);
              break;

            case 6:
              if (vector_all_ones_operand (operands[1], E_V16HImode)
                  && const0_operand (operands[2], E_V16HImode)
                  && (
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3313 (insn, operands);
              if (const0_operand (operands[1], E_V16HImode)
                  && vector_all_ones_operand (operands[2], E_V16HImode)
                  && (
#line 18164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3331 (insn, operands);
              break;

            case 7:
              if (vector_all_ones_operand (operands[1], E_V8SImode)
                  && const0_operand (operands[2], E_V8SImode)
                  && (
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3315 (insn, operands);
              if (const0_operand (operands[1], E_V8SImode)
                  && vector_all_ones_operand (operands[2], E_V8SImode)
                  && (
#line 18164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3332 (insn, operands);
              break;

            case 8:
              if (vector_all_ones_operand (operands[1], E_V4DImode)
                  && const0_operand (operands[2], E_V4DImode)
                  && (
#line 18106 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   && (INTVAL (operands[5]) == 2 || INTVAL (operands[5]) == 5)) && 
#line 18109 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3317 (insn, operands);
              if (const0_operand (operands[1], E_V4DImode)
                  && vector_all_ones_operand (operands[2], E_V4DImode)
                  && (
#line 18164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
     /* NE is commutative.  */
   && INTVAL (operands[5]) == 4) && 
#line 18169 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3333 (insn, operands);
              break;

            case 9:
              if (((
#line 4148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_1326 (insn, operands);
              break;

            case 10:
              if ((
#line 17981 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3294 (insn, operands);
              break;

            case 11:
              if ((
#line 4148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 4150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_1327 (insn, operands);
              break;

            case 12:
              if ((
#line 17981 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3290 (insn, operands);
              break;

            case 13:
              if (((
#line 4148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_1328 (insn, operands);
              break;

            case 14:
              if ((
#line 17981 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3295 (insn, operands);
              break;

            case 15:
              if (((
#line 4148 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 4150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_1329 (insn, operands);
              break;

            case 16:
              if ((
#line 17981 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3291 (insn, operands);
              break;

            case 17:
              if ((
#line 17981 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3288 (insn, operands);
              break;

            case 18:
              if ((
#line 17981 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3289 (insn, operands);
              break;

            case 19:
              if ((
#line 17981 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3292 (insn, operands);
              break;

            case 20:
              if ((
#line 17981 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
   /* NE is commutative.  */
   && ((INTVAL (operands[5]) == 4
	&& !(MEM_P (operands[3]) && MEM_P (operands[4])))
	  /* LE, 3 must be register.  */
       || (INTVAL (operands[5]) == 2
	   && !MEM_P (operands[3]))
	  /* NLT aka GE, 4 must be register and we swap operands.  */
       || (INTVAL (operands[5]) == 5
	   && !MEM_P (operands[4])))) && 
#line 17992 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_3293 (insn, operands);
              break;

            case 21:
              switch (GET_MODE (operands[0]))
                {
                case E_V16SImode:
                  if (register_operand (operands[0], E_V16SImode)
                      && GET_MODE (x2) == E_V16SImode
                      && register_operand (operands[1], E_HImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V16SImode)
                          && const0_operand (operands[3], E_V16SImode)
                          && ((
#line 10302 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 10306 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1528 (insn, operands);
                      if (const0_operand (operands[2], E_V16SImode)
                          && vector_all_ones_operand (operands[3], E_V16SImode)
                          && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1540 (insn, operands);
                    }
                  break;

                case E_V8SImode:
                  if (register_operand (operands[0], E_V8SImode)
                      && GET_MODE (x2) == E_V8SImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V8SImode)
                          && const0_operand (operands[3], E_V8SImode)
                          && ((
#line 10302 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10306 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1529 (insn, operands);
                      if (const0_operand (operands[2], E_V8SImode)
                          && vector_all_ones_operand (operands[3], E_V8SImode)
                          && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1541 (insn, operands);
                    }
                  break;

                case E_V4SImode:
                  if (register_operand (operands[0], E_V4SImode)
                      && GET_MODE (x2) == E_V4SImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V4SImode)
                          && const0_operand (operands[3], E_V4SImode)
                          && ((
#line 10302 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10306 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1530 (insn, operands);
                      if (const0_operand (operands[2], E_V4SImode)
                          && vector_all_ones_operand (operands[3], E_V4SImode)
                          && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1542 (insn, operands);
                    }
                  break;

                case E_V8DImode:
                  if (register_operand (operands[0], E_V8DImode)
                      && GET_MODE (x2) == E_V8DImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V8DImode)
                          && const0_operand (operands[3], E_V8DImode)
                          && ((
#line 10302 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 10306 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1531 (insn, operands);
                      if (const0_operand (operands[2], E_V8DImode)
                          && vector_all_ones_operand (operands[3], E_V8DImode)
                          && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1543 (insn, operands);
                    }
                  break;

                case E_V4DImode:
                  if (register_operand (operands[0], E_V4DImode)
                      && GET_MODE (x2) == E_V4DImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V4DImode)
                          && const0_operand (operands[3], E_V4DImode)
                          && ((
#line 10302 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10306 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1532 (insn, operands);
                      if (const0_operand (operands[2], E_V4DImode)
                          && vector_all_ones_operand (operands[3], E_V4DImode)
                          && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1544 (insn, operands);
                    }
                  break;

                case E_V2DImode:
                  if (register_operand (operands[0], E_V2DImode)
                      && GET_MODE (x2) == E_V2DImode
                      && register_operand (operands[1], E_QImode))
                    {
                      if (vector_all_ones_operand (operands[2], E_V2DImode)
                          && const0_operand (operands[3], E_V2DImode)
                          && ((
#line 10302 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10306 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( !TARGET_AVX512DQ && reload_completed
   && optimize_function_for_speed_p (cfun))))
                        return gen_split_1533 (insn, operands);
                      if (const0_operand (operands[2], E_V2DImode)
                          && vector_all_ones_operand (operands[3], E_V2DImode)
                          && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 511 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                        return gen_split_1545 (insn, operands);
                    }
                  break;

                case E_V64QImode:
                  if (pattern1173 (x2, 
E_DImode, 
E_V64QImode) == 0
                      && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1534 (insn, operands);
                  break;

                case E_V32QImode:
                  if (pattern1173 (x2, 
E_SImode, 
E_V32QImode) == 0
                      && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 505 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1535 (insn, operands);
                  break;

                case E_V16QImode:
                  if (pattern1173 (x2, 
E_HImode, 
E_V16QImode) == 0
                      && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 506 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1536 (insn, operands);
                  break;

                case E_V32HImode:
                  if (pattern1173 (x2, 
E_SImode, 
E_V32HImode) == 0
                      && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 507 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1537 (insn, operands);
                  break;

                case E_V16HImode:
                  if (pattern1173 (x2, 
E_HImode, 
E_V16HImode) == 0
                      && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 508 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1538 (insn, operands);
                  break;

                case E_V8HImode:
                  if (pattern1173 (x2, 
E_QImode, 
E_V8HImode) == 0
                      && ((
#line 10328 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 509 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW)) && 
#line 10330 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                    return gen_split_1539 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            default:
              break;
            }
          break;

        default:
          break;
        }
      operands[1] = x3;
      switch (pattern320 (x2))
        {
        case 0:
          if (!((
#line 4175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4177 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1330 (insn, operands);

        case 1:
          if (!(
#line 4175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 4177 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1331 (insn, operands);

        case 2:
          if (!((
#line 4175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4177 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1332 (insn, operands);

        case 3:
          if (!((
#line 4175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 4177 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1333 (insn, operands);

        case 4:
          if (!((
#line 4196 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4198 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1334 (insn, operands);

        case 5:
          if (!(
#line 4196 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 4198 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1335 (insn, operands);

        case 6:
          if (!((
#line 4196 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4198 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1336 (insn, operands);

        case 7:
          if (!((
#line 4196 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 4198 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1337 (insn, operands);

        default:
          return NULL;
        }

    case VEC_DUPLICATE:
      x5 = XEXP (x3, 0);
      switch (GET_CODE (x5))
        {
        case VEC_SELECT:
          x10 = XEXP (x5, 1);
          if (GET_CODE (x10) != PARALLEL
              || XVECLEN (x10, 0) != 1)
            return NULL;
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return NULL;
          x9 = XEXP (x2, 2);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return NULL;
          switch (pattern997 (x2))
            {
            case 0:
              if (!(
#line 12023 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 12025 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1546 (insn, operands);

            case 1:
              if (!(
#line 12023 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 12025 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1547 (insn, operands);

            case 2:
              if (!(
#line 12023 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 12025 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1548 (insn, operands);

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          switch (pattern312 (x2))
            {
            case 0:
              if (!((
#line 12063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 803 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 12065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1549 (insn, operands);

            case 1:
              if (!(
#line 12063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 12065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1550 (insn, operands);

            case 2:
              if (!(
#line 12063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 12065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1551 (insn, operands);

            case 3:
              if (!((
#line 12063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 12065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1552 (insn, operands);

            case 4:
              if (!((
#line 12177 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 614 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 12179 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1556 (insn, operands);

            case 5:
              if (!(
#line 12063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 12065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1553 (insn, operands);

            case 6:
              if (!((
#line 12177 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 614 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 12179 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1557 (insn, operands);

            case 7:
              if (!(
#line 12063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 12065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1554 (insn, operands);

            case 8:
              if (!(
#line 12177 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 12179 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1558 (insn, operands);

            default:
              return NULL;
            }

        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          x4 = XEXP (x2, 1);
          switch (GET_CODE (x4))
            {
            case SUBREG:
            case MEM:
              if (!rtx_equal_p (x4, operands[0]))
                return NULL;
              x9 = XEXP (x2, 2);
              if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                return NULL;
              operands[1] = x5;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SImode:
                  if (pattern1174 (x2, 
E_SImode, 
E_V4SImode) != 0
                      || !
#line 12253 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
                    return NULL;
                  return gen_split_1560 (insn, operands);

                case E_V4SFmode:
                  if (pattern1174 (x2, 
E_SFmode, 
E_V4SFmode) != 0
                      || !
#line 12253 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
                    return NULL;
                  return gen_split_1561 (insn, operands);

                default:
                  return NULL;
                }

            case REG:
              operands[1] = x4;
              operands[2] = x5;
              x9 = XEXP (x2, 2);
              operands[3] = x9;
              if (!const_int_operand (operands[3], E_SImode))
                return NULL;
              switch (GET_MODE (operands[0]))
                {
                case E_V8HImode:
                  if (pattern1053 (x2, 
E_V8HImode, 
E_HImode) != 0
                      || !
#line 19935 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && reload_completed
   && INTVAL (operands[3]) > 1
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V8HImode))))
                    return NULL;
                  return gen_split_3390 (insn, operands);

                case E_V8HFmode:
                  if (pattern1053 (x2, 
E_V8HFmode, 
E_HFmode) != 0
                      || !
#line 19935 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && reload_completed
   && INTVAL (operands[3]) > 1
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V8HFmode))))
                    return NULL;
                  return gen_split_3391 (insn, operands);

                case E_V8BFmode:
                  if (pattern1053 (x2, 
E_V8BFmode, 
E_BFmode) != 0
                      || !
#line 19935 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && reload_completed
   && INTVAL (operands[3]) > 1
   && ((unsigned) exact_log2 (INTVAL (operands[3]))
       < GET_MODE_NUNITS (V8BFmode))))
                    return NULL;
                  return gen_split_3392 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_1 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17)
    return NULL;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case NEG:
      if (GET_MODE (x4) != E_QImode)
        return NULL;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != LTU
          || GET_MODE (x5) != E_QImode)
        return NULL;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != REG
          || REGNO (x6) != 17
          || GET_MODE (x6) != E_CCCmode)
        return NULL;
      x7 = XEXP (x5, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x8 = XEXP (x3, 1);
      if (GET_CODE (x8) != GEU
          || GET_MODE (x8) != E_QImode)
        return NULL;
      x9 = XEXP (x8, 0);
      if (GET_CODE (x9) != REG
          || REGNO (x9) != 17
          || GET_MODE (x9) != E_CCCmode)
        return NULL;
      x10 = XEXP (x8, 1);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || GET_MODE (x2) != E_CCCmode
          || GET_MODE (x3) != E_CCCmode
          || !
#line 2162 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SLOW_STC && !optimize_insn_for_size_p ()))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_2 (insn, operands);

    case AND:
      x8 = XEXP (x3, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || GET_MODE (x2) != E_CCZmode
          || GET_MODE (x3) != E_CCZmode)
        return NULL;
      x5 = XEXP (x4, 0);
      operands[0] = x5;
      x11 = XEXP (x4, 1);
      operands[1] = x11;
      if (!const_int_operand (operands[1], E_VOIDmode))
        return NULL;
      switch (GET_MODE (x4))
        {
        case E_HImode:
          if (!memory_operand (operands[0], E_HImode)
              || !
#line 12426 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_MEMORY_READ_STALL
   && !MEM_VOLATILE_P (operands[0])
   && offsettable_memref_p (operands[0])))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_124 (insn, operands);

        case E_SImode:
          if (!memory_operand (operands[0], E_SImode)
              || !
#line 12426 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_MEMORY_READ_STALL
   && !MEM_VOLATILE_P (operands[0])
   && offsettable_memref_p (operands[0])))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_125 (insn, operands);

        case E_DImode:
          if (!memory_operand (operands[0], E_DImode)
              || !(
#line 12426 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_MEMORY_READ_STALL
   && !MEM_VOLATILE_P (operands[0])
   && offsettable_memref_p (operands[0])) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_126 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_2 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      switch (pattern411 (x3, 
E_SImode))
        {
        case 0:
          if (!
#line 5977 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_VECTOR_DECODE
   && SSE_FLOAT_MODE_P (SFmode)
   && optimize_insn_for_speed_p ()))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_56 (insn, operands);

        case 1:
          if (!
#line 5977 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_VECTOR_DECODE
   && SSE_FLOAT_MODE_P (DFmode)
   && optimize_insn_for_speed_p ()))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_58 (insn, operands);

        default:
          return NULL;
        }

    case E_DImode:
      switch (pattern411 (x3, 
E_DImode))
        {
        case 0:
          if (!(
#line 5977 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_VECTOR_DECODE
   && SSE_FLOAT_MODE_P (SFmode)
   && optimize_insn_for_speed_p ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_57 (insn, operands);

        case 1:
          if (!(
#line 5977 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_VECTOR_DECODE
   && SSE_FLOAT_MODE_P (DFmode)
   && optimize_insn_for_speed_p ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_59 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_4 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  rtx_insn *res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (register_operand (operands[0], E_DImode)
          && const_int_operand (operands[1], E_DImode)
          && 
#line 2809 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && optimize_insn_for_size_p ()
   && LEGACY_INT_REG_P (operands[0])
   && !x86_64_immediate_operand (operands[1], DImode)
   && !x86_64_zext_immediate_operand (operands[1], DImode)
   && !((UINTVAL (operands[1]) >> ctz_hwi (UINTVAL (operands[1])))
	& ~HOST_WIDE_INT_C (0xffffffff))
   && peep2_regno_dead_p (0, FLAGS_REG)))
        {
          *pmatch_len_ = 0;
          res = gen_peephole2_4 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      if (!general_reg_operand (operands[0], E_DImode))
        return NULL;
      if (const_int_operand (operands[1], E_DImode))
        {
          if ((
#line 2958 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_size_p () && optimize_size > 1
   && operands[1] != const0_rtx
   && (operands[1] != constm1_rtx
       || (DImode == DImode && LEGACY_INT_REG_P (operands[0])))
   && IN_RANGE (INTVAL (operands[1]), -128, 127)
   && !ix86_red_zone_used
   && REGNO (operands[0]) != SP_REG) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_7 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          if (peep2_current_count >= 2)
            {
              x2 = PATTERN (peep2_next_insn (1));
              switch (pattern1055 (x2))
                {
                case 0:
                  if ((
#line 3668 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 1;
                      res = gen_peephole2_36 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 1:
                  if ((
#line 3668 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 1;
                      res = gen_peephole2_38 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 2:
                  if ((
#line 3668 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 1;
                      res = gen_peephole2_40 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                default:
                  break;
                }
            }
        }
      if (peep2_current_count < 2)
        return NULL;
      x2 = PATTERN (peep2_next_insn (1));
      if (pattern946 (x2, 
E_DImode) != 0
          || !(
#line 3295 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(peep2_reg_dead_p (2, operands[0])
   && (const0_operand (operands[1], DImode)
       || (constm1_operand (operands[1], DImode)
	   && (8 > 1 || TARGET_AVX512DQ)))) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_14 (insn, operands);

    case E_HImode:
      if (!general_reg_operand (operands[0], E_HImode))
        return NULL;
      if (const_int_operand (operands[1], E_HImode)
          && 
#line 2958 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_size_p () && optimize_size > 1
   && operands[1] != const0_rtx
   && (operands[1] != constm1_rtx
       || (HImode == DImode && LEGACY_INT_REG_P (operands[0])))
   && IN_RANGE (INTVAL (operands[1]), -128, 127)
   && !ix86_red_zone_used
   && REGNO (operands[0]) != SP_REG))
        {
          *pmatch_len_ = 0;
          res = gen_peephole2_5 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      if (peep2_current_count < 2)
        return NULL;
      x2 = PATTERN (peep2_next_insn (1));
      if (pattern946 (x2, 
E_HImode) != 0
          || !
#line 3295 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(peep2_reg_dead_p (2, operands[0])
   && (const0_operand (operands[1], HImode)
       || (constm1_operand (operands[1], HImode)
	   && (2 > 1 || TARGET_AVX512DQ)))))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_12 (insn, operands);

    case E_SImode:
      if (!general_reg_operand (operands[0], E_SImode))
        return NULL;
      if (const_int_operand (operands[1], E_SImode))
        {
          if (
#line 2958 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_size_p () && optimize_size > 1
   && operands[1] != const0_rtx
   && (operands[1] != constm1_rtx
       || (SImode == DImode && LEGACY_INT_REG_P (operands[0])))
   && IN_RANGE (INTVAL (operands[1]), -128, 127)
   && !ix86_red_zone_used
   && REGNO (operands[0]) != SP_REG))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_6 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          if (peep2_current_count >= 2)
            {
              x2 = PATTERN (peep2_next_insn (1));
              switch (pattern1055 (x2))
                {
                case 0:
                  if (
#line 3668 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[2])))
                    {
                      *pmatch_len_ = 1;
                      res = gen_peephole2_35 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 1:
                  if (
#line 3668 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[2])))
                    {
                      *pmatch_len_ = 1;
                      res = gen_peephole2_37 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 2:
                  if ((
#line 3668 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 1;
                      res = gen_peephole2_39 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                default:
                  break;
                }
            }
        }
      if (peep2_current_count < 2)
        return NULL;
      x2 = PATTERN (peep2_next_insn (1));
      if (pattern946 (x2, 
E_SImode) != 0
          || !
#line 3295 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(peep2_reg_dead_p (2, operands[0])
   && (const0_operand (operands[1], SImode)
       || (constm1_operand (operands[1], SImode)
	   && (4 > 1 || TARGET_AVX512DQ)))))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_13 (insn, operands);

    case E_QImode:
      if (peep2_current_count < 2
          || !general_reg_operand (operands[0], E_QImode))
        return NULL;
      x2 = PATTERN (peep2_next_insn (1));
      if (pattern946 (x2, 
E_QImode) != 0
          || !
#line 3295 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(peep2_reg_dead_p (2, operands[0])
   && (const0_operand (operands[1], QImode)
       || (constm1_operand (operands[1], QImode)
	   && (1 > 1 || TARGET_AVX512DQ)))))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_11 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_8 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x2;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (GET_CODE (operands[0]))
        {
        case MEM:
          if (push_operand (operands[0], E_DImode)
              && immediate_operand (operands[1], E_DImode)
              && 
#line 2223 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !symbolic_operand (operands[1], DImode)
   && !x86_64_immediate_operand (operands[1], DImode)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_3 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case REG:
        case SUBREG:
          res = peephole2_4 (x1, insn, pmatch_len_);
          if (res != NULL_RTX)
            return res;
          break;

        default:
          break;
        }
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (memory_operand (operands[0], E_HImode)
              && const_int_operand (operands[1], E_HImode)
              && 
#line 2982 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((operands[1] == const0_rtx || operands[1] == constm1_rtx)
   && optimize_insn_for_size_p () && optimize_size > 1
   && peep2_regno_dead_p (0, FLAGS_REG)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_8 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case E_SImode:
          if (memory_operand (operands[0], E_SImode)
              && const_int_operand (operands[1], E_SImode)
              && 
#line 2982 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((operands[1] == const0_rtx || operands[1] == constm1_rtx)
   && optimize_insn_for_size_p () && optimize_size > 1
   && peep2_regno_dead_p (0, FLAGS_REG)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_9 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case E_DImode:
          if (memory_operand (operands[0], E_DImode)
              && const_int_operand (operands[1], E_DImode)
              && (
#line 2982 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((operands[1] == const0_rtx || operands[1] == constm1_rtx)
   && optimize_insn_for_size_p () && optimize_size > 1
   && peep2_regno_dead_p (0, FLAGS_REG)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_10 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        default:
          break;
        }
      if (x2 == const_int_rtx[MAX_SAVED_CONST_INT + 0])
        {
          res = peephole2_5 (x1, insn, pmatch_len_);
          if (res != NULL_RTX)
            return res;
        }
      operands[1] = x2;
      operands[0] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (memory_operand (operands[0], E_QImode)
              && immediate_operand (operands[1], E_QImode)
              && 
#line 27856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p ()
   && ((QImode == HImode
       && TARGET_LCP_STALL)
       || (TARGET_SPLIT_LONG_MOVES
          && get_attr_length (insn) >= ix86_cur_cost ()->large_insn))))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_259 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case E_HImode:
          if (memory_operand (operands[0], E_HImode)
              && immediate_operand (operands[1], E_HImode)
              && 
#line 27856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p ()
   && ((HImode == HImode
       && TARGET_LCP_STALL)
       || (TARGET_SPLIT_LONG_MOVES
          && get_attr_length (insn) >= ix86_cur_cost ()->large_insn))))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_260 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        default:
          break;
        }
      break;

    case REG:
      res = peephole2_6 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
      break;

    case SUBREG:
    case MEM:
      res = peephole2_7 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
      break;

    default:
      break;
    }
  if (peep2_current_count < 2)
    return NULL;
  x4 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x4) != SET)
    return NULL;
  x3 = XEXP (x1, 0);
  switch (GET_MODE (x3))
    {
    case E_HImode:
      if (peep2_current_count >= 3
          && peep2_current_count >= 4)
        {
          operands[2] = x3;
          if (general_reg_operand (operands[2], E_HImode))
            {
              operands[3] = x2;
              if (general_gr_operand (operands[3], E_HImode))
                {
                  x5 = XEXP (x4, 0);
                  operands[0] = x5;
                  if (general_reg_operand (operands[0], E_HImode))
                    {
                      x6 = XEXP (x4, 1);
                      if (pattern951 (x6, 
E_HImode) == 0
                          && 
#line 26563 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
  && REGNO (operands[2]) != REGNO (operands[0])
  && REGNO (operands[2]) != REGNO (operands[1])
  && peep2_reg_dead_p (2, operands[1])
  && peep2_reg_dead_p (4, operands[2])
  && !reg_overlap_mentioned_p (operands[0], operands[3])
  && !reg_mentioned_p (operands[2], operands[6])))
                        {
                          *pmatch_len_ = 3;
                          res = gen_peephole2_206 (insn, operands);
                          if (res != NULL_RTX)
                            return res;
                        }
                    }
                }
            }
        }
      operands[0] = x3;
      operands[1] = x2;
      if (x86_64_general_operand (operands[1], E_HImode)
          && general_reg_operand (operands[0], E_HImode))
        {
          x5 = XEXP (x4, 0);
          operands[2] = x5;
          if (general_reg_operand (operands[2], E_HImode))
            {
              x6 = XEXP (x4, 1);
              if (rtx_equal_p (x6, operands[0])
                  && 
#line 27160 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(peep2_reg_dead_p (2, operands[0])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_230 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
        }
      if (peep2_current_count < 3
          || pattern832 (x4, 
E_HImode) != 0)
        return NULL;
      switch (GET_MODE (operands[4]))
        {
        case E_HImode:
          x7 = PATTERN (peep2_next_insn (2));
          x8 = XVECEXP (x7, 0, 0);
          x9 = XEXP (x8, 1);
          if (pattern1849 (x9, 
E_HImode) != 0
              || !
#line 28421 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && (REGNO (operands[4]) == REGNO (operands[0])
       || REGNO (operands[4]) == REGNO (operands[3]))
   && (rtx_equal_p (operands[REGNO (operands[4]) == REGNO (operands[0])
			     ? 3 : 0], operands[5])
       ? rtx_equal_p (operands[2], operands[6])
       : rtx_equal_p (operands[2], operands[5])
	 && rtx_equal_p (operands[REGNO (operands[4]) == REGNO (operands[0])
				  ? 3 : 0], operands[6]))
   && peep2_reg_dead_p (4, operands[4])
   && peep2_reg_dead_p (5, operands[REGNO (operands[4]) == REGNO (operands[0])
				    ? 3 : 0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[3], operands[0])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[2])
   && (HImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))))
            return NULL;
          *pmatch_len_ = 4;
          return gen_peephole2_326 (insn, operands);

        case E_SImode:
          x7 = PATTERN (peep2_next_insn (2));
          x8 = XVECEXP (x7, 0, 0);
          x9 = XEXP (x8, 1);
          if (pattern1850 (x9, 
E_HImode) != 0
              || !
#line 28465 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && (REGNO (operands[5]) == REGNO (operands[0])
       || REGNO (operands[5]) == REGNO (operands[3]))
   && REGNO (operands[5]) == REGNO (operands[4])
   && (rtx_equal_p (operands[REGNO (operands[5]) == REGNO (operands[0])
			     ? 3 : 0], operands[6])
       ? (REG_P (operands[2])
	  ? REG_P (operands[7]) && REGNO (operands[2]) == REGNO (operands[7])
	  : rtx_equal_p (operands[2], operands[7]))
       : (rtx_equal_p (operands[REGNO (operands[5]) == REGNO (operands[0])
				? 3 : 0], operands[7])
	  && REG_P (operands[2])
	  && REGNO (operands[2]) == REGNO (operands[6])))
   && peep2_reg_dead_p (4, operands[5])
   && peep2_reg_dead_p (5, operands[REGNO (operands[5]) == REGNO (operands[0])
				    ? 3 : 0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[3], operands[0])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[2])
   && (HImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))))
            return NULL;
          *pmatch_len_ = 4;
          return gen_peephole2_330 (insn, operands);

        default:
          return NULL;
        }

    case E_QImode:
      operands[0] = x3;
      operands[1] = x2;
      if (x86_64_general_operand (operands[1], E_QImode)
          && general_reg_operand (operands[0], E_QImode))
        {
          x5 = XEXP (x4, 0);
          operands[2] = x5;
          if (general_reg_operand (operands[2], E_QImode))
            {
              x6 = XEXP (x4, 1);
              if (rtx_equal_p (x6, operands[0])
                  && 
#line 27160 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(peep2_reg_dead_p (2, operands[0])))
                {
                  *pmatch_len_ = 1;
                  res = gen_peephole2_229 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
        }
      if (peep2_current_count < 3
          || pattern832 (x4, 
E_QImode) != 0)
        return NULL;
      switch (GET_MODE (operands[4]))
        {
        case E_QImode:
          x7 = PATTERN (peep2_next_insn (2));
          x8 = XVECEXP (x7, 0, 0);
          x9 = XEXP (x8, 1);
          if (pattern1849 (x9, 
E_QImode) != 0
              || !
#line 28421 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && (REGNO (operands[4]) == REGNO (operands[0])
       || REGNO (operands[4]) == REGNO (operands[3]))
   && (rtx_equal_p (operands[REGNO (operands[4]) == REGNO (operands[0])
			     ? 3 : 0], operands[5])
       ? rtx_equal_p (operands[2], operands[6])
       : rtx_equal_p (operands[2], operands[5])
	 && rtx_equal_p (operands[REGNO (operands[4]) == REGNO (operands[0])
				  ? 3 : 0], operands[6]))
   && peep2_reg_dead_p (4, operands[4])
   && peep2_reg_dead_p (5, operands[REGNO (operands[4]) == REGNO (operands[0])
				    ? 3 : 0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[3], operands[0])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[2])
   && (QImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))))
            return NULL;
          *pmatch_len_ = 4;
          return gen_peephole2_325 (insn, operands);

        case E_SImode:
          x7 = PATTERN (peep2_next_insn (2));
          x8 = XVECEXP (x7, 0, 0);
          x9 = XEXP (x8, 1);
          if (pattern1850 (x9, 
E_QImode) != 0
              || !
#line 28465 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && (REGNO (operands[5]) == REGNO (operands[0])
       || REGNO (operands[5]) == REGNO (operands[3]))
   && REGNO (operands[5]) == REGNO (operands[4])
   && (rtx_equal_p (operands[REGNO (operands[5]) == REGNO (operands[0])
			     ? 3 : 0], operands[6])
       ? (REG_P (operands[2])
	  ? REG_P (operands[7]) && REGNO (operands[2]) == REGNO (operands[7])
	  : rtx_equal_p (operands[2], operands[7]))
       : (rtx_equal_p (operands[REGNO (operands[5]) == REGNO (operands[0])
				? 3 : 0], operands[7])
	  && REG_P (operands[2])
	  && REGNO (operands[2]) == REGNO (operands[6])))
   && peep2_reg_dead_p (4, operands[5])
   && peep2_reg_dead_p (5, operands[REGNO (operands[5]) == REGNO (operands[0])
				    ? 3 : 0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[3], operands[0])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[2])
   && (QImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))))
            return NULL;
          *pmatch_len_ = 4;
          return gen_peephole2_329 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_16 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  if (register_operand (operands[0], E_DImode))
    {
      res = peephole2_15 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (peep2_current_count < 2
      || peep2_current_count < 3
      || !general_reg_operand (operands[0], E_DImode))
    return NULL;
  x3 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x3) == PARALLEL
      && XVECLEN (x3, 0) == 2)
    {
      x4 = XVECEXP (x3, 0, 0);
      if (GET_CODE (x4) == SET)
        {
          if (memory_operand (operands[1], E_DImode))
            {
              switch (pattern1182 (x3, 
E_DImode, 
E_TImode))
                {
                case 0:
                  if ((
#line 8713 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_71 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 1:
                  if ((
#line 9146 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_87 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 2:
                  if ((
#line 9633 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_99 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 3:
                  if ((
#line 9999 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_111 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 4:
                  if ((
#line 8830 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_79 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 5:
                  if ((
#line 8856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_83 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 6:
                  if ((
#line 9314 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_93 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 7:
                  if ((
#line 9340 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_97 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                default:
                  break;
                }
            }
          if (peep2_current_count >= 4
              && pattern1184 (x3, 
E_DImode) == 0
              && (
#line 14300 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[2])
   && !reg_mentioned_p (operands[0], operands[1])
   && !reg_mentioned_p (operands[2], operands[1])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 3;
              res = gen_peephole2_152 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          if (general_reg_operand (operands[1], E_DImode))
            {
              x5 = PATTERN (peep2_next_insn (2));
              if (GET_CODE (x5) == SET)
                {
                  x6 = XEXP (x4, 1);
                  if (GET_CODE (x6) == NEG
                      && pattern1333 (x3, 
E_DImode) == 0
                      && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_158 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  if (peep2_current_count >= 4
                      && pattern1335 (x3, 
E_DImode) == 0
                      && (
#line 26529 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
  && REGNO (operands[2]) != REGNO (operands[0])
  && REGNO (operands[2]) != REGNO (operands[1])
  && peep2_reg_dead_p (1, operands[1])
  && peep2_reg_dead_p (4, operands[2])
  && !reg_overlap_mentioned_p (operands[0], operands[3])) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_205 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                }
            }
        }
    }
  if (!immediate_operand (operands[1], E_DImode)
      || GET_CODE (x3) != SET)
    return NULL;
  switch (pattern948 (x3, 
E_TImode, 
E_DImode))
    {
    case 0:
      if (!(
#line 11097 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[3]) != AX_REG
   && REGNO (operands[0]) != REGNO (operands[2])
   && REGNO (operands[0]) != REGNO (operands[3])
   && (REGNO (operands[0]) == REGNO (operands[4])
       || REGNO (operands[0]) == DX_REG
       || peep2_reg_dead_p (3, operands[0]))) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_115 (insn, operands);

    case 1:
      if (!(
#line 11119 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[3]) != DX_REG
   && REGNO (operands[0]) != REGNO (operands[2])
   && REGNO (operands[0]) != REGNO (operands[3])
   && (REGNO (operands[0]) == REGNO (operands[4])
       || REGNO (operands[0]) == REGNO (operands[5])
       || peep2_reg_dead_p (3, operands[0]))
   && (REGNO (operands[2]) == REGNO (operands[4])
       || REGNO (operands[2]) == REGNO (operands[5])
       || peep2_reg_dead_p (3, operands[2]))) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_117 (insn, operands);

    case 2:
      if (!general_reg_operand (operands[4], E_DImode))
        return NULL;
      x5 = PATTERN (peep2_next_insn (2));
      x7 = XVECEXP (x5, 0, 0);
      x8 = XEXP (x7, 1);
      if (GET_MODE (x8) != E_DImode)
        return NULL;
      x9 = XVECEXP (x5, 0, 1);
      x10 = XEXP (x9, 0);
      if (!rtx_equal_p (x10, operands[2]))
        return NULL;
      switch (GET_CODE (x8))
        {
        case SMUL_HIGHPART:
          x11 = XEXP (x8, 0);
          if (!rtx_equal_p (x11, operands[2]))
            return NULL;
          x12 = XEXP (x8, 1);
          if (!rtx_equal_p (x12, operands[0])
              || !(
#line 11258 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[3]) != AX_REG
   && REGNO (operands[0]) != REGNO (operands[2])
   && REGNO (operands[0]) != REGNO (operands[3])
   && (REGNO (operands[0]) == REGNO (operands[4])
       || peep2_reg_dead_p (3, operands[0]))) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 2;
          return gen_peephole2_120 (insn, operands);

        case UMUL_HIGHPART:
          x11 = XEXP (x8, 0);
          if (!rtx_equal_p (x11, operands[2]))
            return NULL;
          x12 = XEXP (x8, 1);
          if (!rtx_equal_p (x12, operands[0])
              || !(
#line 11258 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[3]) != AX_REG
   && REGNO (operands[0]) != REGNO (operands[2])
   && REGNO (operands[0]) != REGNO (operands[3])
   && (REGNO (operands[0]) == REGNO (operands[4])
       || peep2_reg_dead_p (3, operands[0]))) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          *pmatch_len_ = 2;
          return gen_peephole2_121 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_29 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
    case LTGT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
    case UNORDERED:
    case ORDERED:
    case UNEQ:
    case UNGE:
    case UNGT:
    case UNLE:
    case UNLT:
      operands[1] = x3;
      switch (pattern243 (x1))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              if (pattern1185 (x2, 
E_HImode) != 0
                  || !
#line 26461 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE && TARGET_AVOID_MEM_OPND_FOR_CMOVE
   && (MEM_P (operands[2]) || MEM_P (operands[3]))
   && optimize_insn_for_speed_p ()))
                return NULL;
              *pmatch_len_ = 0;
              return gen_peephole2_199 (insn, operands);

            case E_SImode:
              if (pattern1185 (x2, 
E_SImode) != 0
                  || !
#line 26461 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE && TARGET_AVOID_MEM_OPND_FOR_CMOVE
   && (MEM_P (operands[2]) || MEM_P (operands[3]))
   && optimize_insn_for_speed_p ()))
                return NULL;
              *pmatch_len_ = 0;
              return gen_peephole2_200 (insn, operands);

            case E_DImode:
              if (pattern1185 (x2, 
E_DImode) != 0
                  || !(
#line 26461 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE && TARGET_AVOID_MEM_OPND_FOR_CMOVE
   && (MEM_P (operands[2]) || MEM_P (operands[3]))
   && optimize_insn_for_speed_p ()) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 0;
              return gen_peephole2_201 (insn, operands);

            case E_SFmode:
              if (!general_reg_operand (operands[0], E_SFmode)
                  || pattern1244 (x2, 
E_SFmode) != 0
                  || !
#line 26713 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((SFmode != DFmode || TARGET_64BIT)
   && TARGET_80387 && TARGET_CMOVE
   && TARGET_AVOID_MEM_OPND_FOR_CMOVE
   && (MEM_P (operands[2]) || MEM_P (operands[3]))
   && optimize_insn_for_speed_p ()))
                return NULL;
              *pmatch_len_ = 0;
              return gen_peephole2_209 (insn, operands);

            case E_DFmode:
              if (!general_reg_operand (operands[0], E_DFmode)
                  || pattern1244 (x2, 
E_DFmode) != 0
                  || !
#line 26713 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((DFmode != DFmode || TARGET_64BIT)
   && TARGET_80387 && TARGET_CMOVE
   && TARGET_AVOID_MEM_OPND_FOR_CMOVE
   && (MEM_P (operands[2]) || MEM_P (operands[3]))
   && optimize_insn_for_speed_p ()))
                return NULL;
              *pmatch_len_ = 0;
              return gen_peephole2_210 (insn, operands);

            default:
              return NULL;
            }

        case 1:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !ix86_comparison_operator (operands[1], E_VOIDmode))
            return NULL;
          x4 = XEXP (x2, 1);
          x5 = XEXP (x4, 0);
          operands[2] = x5;
          if (!nonimmediate_operand (operands[2], E_SImode))
            return NULL;
          x6 = XEXP (x2, 2);
          x7 = XEXP (x6, 0);
          operands[3] = x7;
          if (!nonimmediate_operand (operands[3], E_SImode)
              || !
#line 26491 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && TARGET_CMOVE && TARGET_AVOID_MEM_OPND_FOR_CMOVE
   && (MEM_P (operands[2]) || MEM_P (operands[3]))
   && optimize_insn_for_speed_p ()))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_202 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_36 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (XWINT (x2, 0) == -1L)
    {
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (general_reg_operand (operands[0], E_HImode)
              && 
#line 28536 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_MOVE_M1_VIA_OR || optimize_insn_for_size_p ())
   && peep2_regno_dead_p (0, FLAGS_REG)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_335 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case E_SImode:
          if (general_reg_operand (operands[0], E_SImode)
              && 
#line 28536 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_MOVE_M1_VIA_OR || optimize_insn_for_size_p ())
   && peep2_regno_dead_p (0, FLAGS_REG)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_336 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case E_DImode:
          if (general_reg_operand (operands[0], E_DImode)
              && (
#line 28536 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_MOVE_M1_VIA_OR || optimize_insn_for_size_p ())
   && peep2_regno_dead_p (0, FLAGS_REG)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_337 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        default:
          break;
        }
    }
  if (peep2_current_count < 2
      || peep2_current_count < 3)
    return NULL;
  operands[2] = x2;
  x3 = PATTERN (peep2_next_insn (1));
  if (pattern595 (x3, 
2) != 0)
    return NULL;
  x4 = XVECEXP (x3, 0, 0);
  x5 = XEXP (x4, 1);
  if (XINT (x5, 1) != 110)
    return NULL;
  x6 = XVECEXP (x3, 0, 1);
  if (GET_CODE (x6) != SET)
    return NULL;
  x7 = XEXP (x6, 1);
  if (GET_CODE (x7) != PLUS
      || pattern1492 (x3) != 0
      || pattern1674 (x3) != 0)
    return NULL;
  x8 = PATTERN (peep2_next_insn (2));
  x9 = XEXP (x8, 1);
  x10 = XEXP (x9, 1);
  operands[3] = x10;
  x11 = XEXP (x9, 0);
  if (!rtx_equal_p (x11, operands[0]))
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      if (pattern1842 (x3, 
E_HImode) != 0
          || !
#line 724 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_416 (insn, operands);

    case E_SImode:
      if (pattern1842 (x3, 
E_SImode) != 0
          || !
#line 724 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_417 (insn, operands);

    case E_DImode:
      if (pattern1842 (x3, 
E_DImode) != 0
          || !(
#line 724 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_418 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_44 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 2)
    return NULL;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UMUL_HIGHPART)
    return NULL;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  x8 = XEXP (x6, 1);
  operands[3] = x8;
  x9 = XEXP (x2, 0);
  operands[1] = x9;
  x10 = XEXP (x3, 0);
  if (!rtx_equal_p (x10, operands[2]))
    return NULL;
  x11 = XEXP (x3, 1);
  if (!rtx_equal_p (x11, operands[3]))
    return NULL;
  x12 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x12) != SET)
    return NULL;
  x13 = XEXP (x12, 0);
  operands[4] = x13;
  x14 = XEXP (x12, 1);
  operands[5] = x14;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (pattern1559 (x1, 
E_SImode) != 0
          || !(
#line 10982 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2
   && ((REGNO (operands[5]) == REGNO (operands[0])
        && REGNO (operands[1]) != REGNO (operands[4]))
       || (REGNO (operands[5]) == REGNO (operands[1])
	   && REGNO (operands[0]) != REGNO (operands[4])))
   && peep2_reg_dead_p (2, operands[5])) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_112 (insn, operands);

    case E_DImode:
      if (pattern1559 (x1, 
E_DImode) != 0
          || !(
#line 10982 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2
   && ((REGNO (operands[5]) == REGNO (operands[0])
        && REGNO (operands[1]) != REGNO (operands[4]))
       || (REGNO (operands[5]) == REGNO (operands[1])
	   && REGNO (operands[0]) != REGNO (operands[4])))
   && peep2_reg_dead_p (2, operands[5])) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_113 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_47 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (!arith_or_logical_operator (operands[3], E_QImode))
        return NULL;
      if (register_operand (operands[0], E_QImode))
        {
          x4 = XEXP (x2, 1);
          x5 = XEXP (x4, 1);
          operands[1] = x5;
          if (memory_operand (operands[1], E_QImode))
            {
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0])
                  && 
#line 27988 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_271 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (memory_operand (operands[1], E_QImode)
              && rtx_equal_p (x5, operands[0])
              && 
#line 28001 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_275 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (!memory_operand (operands[0], E_QImode))
        return NULL;
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      operands[1] = x5;
      if (nonmemory_operand (operands[1], E_QImode))
        {
          x6 = XEXP (x4, 0);
          if (rtx_equal_p (x6, operands[0])
              && 
#line 28076 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_285 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!nonmemory_operand (operands[1], E_QImode)
          || !rtx_equal_p (x5, operands[0])
          || !
#line 28090 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_289 (insn, operands);

    case E_HImode:
      if (!arith_or_logical_operator (operands[3], E_HImode))
        return NULL;
      if (register_operand (operands[0], E_HImode))
        {
          x4 = XEXP (x2, 1);
          x5 = XEXP (x4, 1);
          operands[1] = x5;
          if (memory_operand (operands[1], E_HImode))
            {
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0])
                  && 
#line 27988 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_272 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (memory_operand (operands[1], E_HImode)
              && rtx_equal_p (x5, operands[0])
              && 
#line 28001 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_276 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (!memory_operand (operands[0], E_HImode))
        return NULL;
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      operands[1] = x5;
      if (nonmemory_operand (operands[1], E_HImode))
        {
          x6 = XEXP (x4, 0);
          if (rtx_equal_p (x6, operands[0])
              && 
#line 28076 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_286 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!nonmemory_operand (operands[1], E_HImode)
          || !rtx_equal_p (x5, operands[0])
          || !
#line 28090 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_290 (insn, operands);

    case E_SImode:
      if (!arith_or_logical_operator (operands[3], E_SImode))
        return NULL;
      if (register_operand (operands[0], E_SImode))
        {
          x4 = XEXP (x2, 1);
          x5 = XEXP (x4, 1);
          operands[1] = x5;
          if (memory_operand (operands[1], E_SImode))
            {
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0])
                  && 
#line 27988 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_273 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (memory_operand (operands[1], E_SImode)
              && rtx_equal_p (x5, operands[0])
              && 
#line 28001 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_277 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (!memory_operand (operands[0], E_SImode))
        return NULL;
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      operands[1] = x5;
      if (x86_64_nonmemory_operand (operands[1], E_SImode))
        {
          x6 = XEXP (x4, 0);
          if (rtx_equal_p (x6, operands[0])
              && 
#line 28076 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_287 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!x86_64_nonmemory_operand (operands[1], E_SImode)
          || !rtx_equal_p (x5, operands[0])
          || !
#line 28090 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_291 (insn, operands);

    case E_DImode:
      if (!arith_or_logical_operator (operands[3], E_DImode))
        return NULL;
      if (register_operand (operands[0], E_DImode))
        {
          x4 = XEXP (x2, 1);
          x5 = XEXP (x4, 1);
          operands[1] = x5;
          if (memory_operand (operands[1], E_DImode))
            {
              x6 = XEXP (x4, 0);
              if (rtx_equal_p (x6, operands[0])
                  && (
#line 27988 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pmatch_len_ = 0;
                  res = gen_peephole2_274 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (memory_operand (operands[1], E_DImode)
              && rtx_equal_p (x5, operands[0])
              && (
#line 28001 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY || optimize_insn_for_size_p ())) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_278 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (!memory_operand (operands[0], E_DImode))
        return NULL;
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      operands[1] = x5;
      if (x86_64_nonmemory_operand (operands[1], E_DImode))
        {
          x6 = XEXP (x4, 0);
          if (rtx_equal_p (x6, operands[0])
              && (
#line 28076 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 0;
              res = gen_peephole2_288 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      if (!x86_64_nonmemory_operand (operands[1], E_DImode)
          || !rtx_equal_p (x5, operands[0])
          || !(
#line 28090 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 0;
      return gen_peephole2_292 (insn, operands);

    default:
      return NULL;
    }
}
