/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern0 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!register_operand (operands[0], E_TImode)
      || GET_MODE (x2) != E_TImode
      || !register_operand (operands[1], E_TImode))
    return -1;
  x5 = XEXP (x3, 0);
  operands[2] = x5;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x6 = XEXP (x3, 1);
  operands[3] = x6;
  if (!const_int_operand (operands[3], E_QImode))
    return -1;
  return 0;
}

int
pattern18 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  return pattern17 (x1); /* [-1, 1] */
}

int
pattern22 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern32 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_CODE (operands[2]))
    {
    case CONST_INT:
      switch (GET_MODE (operands[0]))
        {
        case E_V1TImode:
          return pattern30 (x3); /* [-1, 0] */

        case E_V16SImode:
          if (pattern31 (x3, 
E_V16SImode) != 0)
            return -1;
          return 1;

        case E_V8SImode:
          if (pattern31 (x3, 
E_V8SImode) != 0)
            return -1;
          return 2;

        case E_V4SImode:
          if (!register_operand (operands[0], E_V4SImode)
              || GET_MODE (x3) != E_V4SImode
              || !nonimmediate_operand (operands[1], E_V4SImode))
            return -1;
          return 3;

        case E_V8DImode:
          if (pattern31 (x3, 
E_V8DImode) != 0)
            return -1;
          return 4;

        case E_V4DImode:
          if (pattern31 (x3, 
E_V4DImode) != 0)
            return -1;
          return 5;

        case E_V2DImode:
          if (!register_operand (operands[0], E_V2DImode)
              || GET_MODE (x3) != E_V2DImode
              || !nonimmediate_operand (operands[1], E_V2DImode))
            return -1;
          return 6;

        case E_V16QImode:
          if (!register_operand (operands[0], E_V16QImode)
              || GET_MODE (x3) != E_V16QImode
              || !nonimmediate_operand (operands[1], E_V16QImode)
              || !const_0_to_7_operand (operands[2], E_SImode))
            return -1;
          return 7;

        case E_V8HImode:
          if (!register_operand (operands[0], E_V8HImode)
              || GET_MODE (x3) != E_V8HImode
              || !nonimmediate_operand (operands[1], E_V8HImode)
              || !const_0_to_15_operand (operands[2], E_SImode))
            return -1;
          return 8;

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern14 (x3, 
E_V16SImode) != 0)
            return -1;
          return 9;

        case E_V8SImode:
          if (pattern14 (x3, 
E_V8SImode) != 0)
            return -1;
          return 10;

        case E_V4SImode:
          if (pattern14 (x3, 
E_V4SImode) != 0)
            return -1;
          return 11;

        case E_V8DImode:
          if (pattern14 (x3, 
E_V8DImode) != 0)
            return -1;
          return 12;

        case E_V4DImode:
          if (pattern14 (x3, 
E_V4DImode) != 0)
            return -1;
          return 13;

        case E_V2DImode:
          if (pattern14 (x3, 
E_V2DImode) != 0)
            return -1;
          return 14;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern54 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V4HImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != E_V4HImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != VEC_CONCAT
      || GET_MODE (x4) != E_V8HImode)
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_CODE (x5) != PARALLEL
      || XVECLEN (x5, 0) != 4)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x5, 0, 1);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x8 = XVECEXP (x5, 0, 2);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x9 = XVECEXP (x5, 0, 3);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x10 = XEXP (x2, 1);
  if (GET_CODE (x10) != VEC_SELECT
      || GET_MODE (x10) != E_V4HImode)
    return -1;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != VEC_CONCAT
      || GET_MODE (x11) != E_V8HImode)
    return -1;
  x12 = XEXP (x10, 1);
  if (GET_CODE (x12) != PARALLEL
      || XVECLEN (x12, 0) != 4)
    return -1;
  x13 = XVECEXP (x12, 0, 0);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x14 = XVECEXP (x12, 0, 1);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x15 = XVECEXP (x12, 0, 2);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x16 = XVECEXP (x12, 0, 3);
  if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x17 = XEXP (x1, 0);
  operands[0] = x17;
  if (!register_operand (operands[0], E_V4HImode)
      || pattern53 (x2) != 0)
    return -1;
  return 0;
}

int
pattern72 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      x4 = XEXP (x1, 1);
      return pattern71 (x4, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      x4 = XEXP (x1, 1);
      if (pattern71 (x4, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern81 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_QImode
      || !register_operand (operands[0], E_HImode)
      || GET_MODE (x1) != E_HImode)
    return -1;
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  if (!nonimmediate_operand (operands[1], E_QImode))
    return -1;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  return 0;
}

int
pattern88 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern92 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_BLKmode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!memory_operand (operands[0], E_BLKmode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!register_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern101 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V4HImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_CONCAT
      || GET_MODE (x3) != E_V8HImode)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 4)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != VEC_SELECT
      || GET_MODE (x9) != E_V4HImode)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != VEC_CONCAT
      || GET_MODE (x10) != E_V8HImode)
    return -1;
  x11 = XEXP (x9, 1);
  if (GET_CODE (x11) != PARALLEL
      || XVECLEN (x11, 0) != 4)
    return -1;
  x12 = XVECEXP (x11, 0, 0);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x11, 0, 1);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x14 = XVECEXP (x11, 0, 2);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x15 = XVECEXP (x11, 0, 3);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || !register_operand (operands[0], E_V4HImode)
      || GET_MODE (x1) != E_V4HImode
      || pattern53 (x1) != 0)
    return -1;
  return 0;
}

int
pattern119 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_DImode
      || pattern41 (x1, 
E_SImode, 
E_DImode) != 0)
    return -1;
  return 0;
}

int
pattern125 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  if (GET_CODE (x3) != VEC_SELECT)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 1)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  x7 = XEXP (x3, 0);
  operands[1] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern124 (x2, 
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern124 (x2, 
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern136 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern145 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern128 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern128 (x1, 
E_V8SImode, 
E_QImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern129 (x1, 
E_QImode, 
E_V4SImode) != 0)
        return -1;
      return 2;

    case E_V8DImode:
      if (pattern128 (x1, 
E_V8DImode, 
E_QImode) != 0)
        return -1;
      return 3;

    case E_V4DImode:
      if (pattern128 (x1, 
E_V4DImode, 
E_QImode) != 0)
        return -1;
      return 4;

    case E_V2DImode:
      if (pattern128 (x1, 
E_V2DImode, 
E_QImode) != 0)
        return -1;
      return 5;

    case E_V64QImode:
      if (pattern128 (x1, 
E_V64QImode, 
E_DImode) != 0)
        return -1;
      return 6;

    case E_V16QImode:
      if (pattern128 (x1, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 7;

    case E_V32QImode:
      if (pattern128 (x1, 
E_V32QImode, 
E_SImode) != 0)
        return -1;
      return 8;

    case E_V32HImode:
      if (pattern128 (x1, 
E_V32HImode, 
E_SImode) != 0)
        return -1;
      return 9;

    case E_V16HImode:
      if (pattern128 (x1, 
E_V16HImode, 
E_HImode) != 0)
        return -1;
      return 10;

    case E_V8HImode:
      if (pattern129 (x1, 
E_QImode, 
E_V8HImode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern157 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern152 (x3, 
E_V64QImode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern152 (x3, 
E_V32QImode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern152 (x3, 
E_V16QImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern164 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern163 (x3, 
E_V64QImode, 
E_V32HFmode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern163 (x3, 
E_V32QImode, 
E_V16HFmode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern163 (x3, 
E_V16QImode, 
E_V8HFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern173 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V8DImode:
      return pattern172 (x3, 
E_V8DImode); /* [-1, 0] */

    case E_V4DImode:
      if (pattern172 (x3, 
E_V4DImode) != 0)
        return -1;
      return 1;

    case E_V2DImode:
      if (pattern172 (x3, 
E_V2DImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern180 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x1) != E_V8HFmode)
        return -1;
      switch (GET_MODE (x2))
        {
        case E_V4HFmode:
          if (!const0_operand (operands[2], E_V4HFmode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!vector_operand (operands[1], E_V4SImode))
                return -1;
              return 0;

            case E_V4DImode:
              if (!vector_operand (operands[1], E_V4DImode))
                return -1;
              return 1;

            default:
              return -1;
            }

        case E_V2HFmode:
          if (!vector_operand (operands[1], E_V2DImode)
              || !const0_operand (operands[2], E_V6HFmode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_V4SFmode:
      if (pattern179 (x1, 
E_V2SFmode, 
E_V2DImode, 
E_V4SFmode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern192 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x1, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != VEC_SELECT)
    return -1;
  x7 = XEXP (x6, 1);
  if (GET_CODE (x7) != PARALLEL)
    return -1;
  x8 = XEXP (x3, 0);
  operands[1] = x8;
  x9 = XEXP (x6, 0);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  switch (XVECLEN (x4, 0))
    {
    case 8:
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x11 = XVECEXP (x4, 0, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x12 = XVECEXP (x4, 0, 2);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x13 = XVECEXP (x4, 0, 3);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x14 = XVECEXP (x4, 0, 4);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x15 = XVECEXP (x4, 0, 5);
      if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
        return -1;
      x16 = XVECEXP (x4, 0, 6);
      if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
        return -1;
      x17 = XVECEXP (x4, 0, 7);
      if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 14]
          || XVECLEN (x7, 0) != 8)
        return -1;
      x18 = XVECEXP (x7, 0, 0);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x19 = XVECEXP (x7, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x20 = XVECEXP (x7, 0, 2);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x21 = XVECEXP (x7, 0, 3);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x22 = XVECEXP (x7, 0, 4);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
        return -1;
      x23 = XVECEXP (x7, 0, 5);
      if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
        return -1;
      x24 = XVECEXP (x7, 0, 6);
      if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
        return -1;
      x25 = XVECEXP (x7, 0, 7);
      if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 15]
          || pattern191 (x1, 
E_V8QImode, 
E_V8HImode, 
E_V16QImode) != 0)
        return -1;
      return 0;

    case 4:
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x11 = XVECEXP (x4, 0, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x12 = XVECEXP (x4, 0, 2);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x13 = XVECEXP (x4, 0, 3);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 6]
          || XVECLEN (x7, 0) != 4)
        return -1;
      x18 = XVECEXP (x7, 0, 0);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x19 = XVECEXP (x7, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x20 = XVECEXP (x7, 0, 2);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x21 = XVECEXP (x7, 0, 3);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern191 (x1, 
E_V4HImode, 
E_V4SImode, 
E_V8HImode) != 0)
        return -1;
      return 1;

    case 2:
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x11 = XVECEXP (x4, 0, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2]
          || XVECLEN (x7, 0) != 2)
        return -1;
      x18 = XVECEXP (x7, 0, 0);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x19 = XVECEXP (x7, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
          || pattern191 (x1, 
E_V2SImode, 
E_V2DImode, 
E_V4SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern222 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != USE)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x3) != CLOBBER)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != E_CCmode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 0);
  operands[0] = x6;
  x7 = XEXP (x5, 1);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  x9 = XEXP (x2, 0);
  operands[2] = x9;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      return pattern221 (x7, 
E_V8HFmode, 
E_HFmode); /* [-1, 0] */

    case E_SFmode:
      if (pattern221 (x7, 
E_V4SFmode, 
E_SFmode) != 0)
        return -1;
      return 1;

    case E_DFmode:
      if (pattern221 (x7, 
E_V2DFmode, 
E_DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern236 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V4HImode:
      return pattern235 (x1, 
E_V4HImode); /* [-1, 0] */

    case E_V2SImode:
      if (pattern235 (x1, 
E_V2SImode) != 0)
        return -1;
      return 1;

    case E_V2HImode:
      if (pattern235 (x1, 
E_V2HImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern246 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x6, 1);
  operands[2] = x8;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  return pattern245 (x6); /* [-1, 1] */
}

int
pattern256 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V2QImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!memory_operand (operands[0], E_HImode)
      || GET_MODE (x2) != E_HImode)
    return -1;
  x5 = XEXP (x3, 0);
  operands[1] = x5;
  if (!register_operand (operands[1], E_V2DImode))
    return -1;
  return 0;
}

int
pattern262 (rtx x1, int *pnum_clobbers, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL
      || !nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern268 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[3] = x4;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  return pattern2 (x1); /* [-1, 1] */
}

int
pattern274 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1)
      || !register_mmxmem_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern279 (rtx x1, int *pnum_clobbers, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (!nonimmediate_operand (x3, i2))
    return -1;
  x4 = XEXP (x1, 1);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      if (pnum_clobbers == NULL)
        return -1;
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], i1))
        return -1;
      operands[2] = x3;
      return 0;

    case ASHIFT:
      if (GET_MODE (x4) != i1)
        return -1;
      operands[1] = x3;
      res = pattern37 (x4, 
i1, 
i2);
      if (res >= 0)
        return res + 1; /* [1, 3] */
      return -1;

    case CONST_INT:
    case CONST_WIDE_INT:
      operands[2] = x4;
      if (!const_scalar_int_operand (operands[2], i1))
        return -1;
      operands[1] = x3;
      return 4;

    default:
      return -1;
    }
}

int
pattern295 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_V4QImode:
      switch (GET_MODE (operands[1]))
        {
        case E_V4SImode:
          if (!register_operand (operands[1], E_V4SImode))
            return -1;
          return 0;

        case E_V4DImode:
          if (!register_operand (operands[1], E_V4DImode))
            return -1;
          return 1;

        default:
          return -1;
        }

    case E_V2HImode:
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern307 (rtx x1, int i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != VEC_SELECT
      || GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 2)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern315 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern319 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !float_vector_all_ones_operand (operands[1], i1)
      || !const0_operand (operands[2], i1)
      || !register_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern325 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HImode:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x1) != E_V32HImode
          || !vector_operand (operands[1], i1))
        return -1;
      return 0;

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x1) != E_V16HImode
          || !vector_operand (operands[1], i2))
        return -1;
      return 1;

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode
          || !vector_operand (operands[1], i3))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern330 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern332 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_V4SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != SIGN_EXTEND
      || GET_MODE (x2) != E_V4SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != E_V4HImode)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 4)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != SIGN_EXTEND)
    return -1;
  return 0;
}

int
pattern339 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V4DImode:
      return pattern338 (x1, 
E_V4DImode); /* [-1, 0] */

    case E_V2DImode:
      if (pattern338 (x1, 
E_V2DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern343 (rtx x1, int *pnum_clobbers, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != i1
      || GET_MODE (x6) != E_SImode)
    return -1;
  x7 = XEXP (x2, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_DImode)
      || GET_MODE (x3) != E_DImode)
    return -1;
  return 0;
}

int
pattern348 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern352 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (XVECLEN (x4, 0) != 3)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != UNSPEC
      || XVECLEN (x6, 0) != 3)
    return -1;
  return 0;
}

int
pattern355 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  x6 = XEXP (x1, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern359 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern364 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XVECEXP (x5, 0, 0);
  operands[0] = x6;
  x7 = XVECEXP (x5, 0, 1);
  operands[2] = x7;
  if (!const_int_operand (operands[2], E_SImode))
    return -1;
  x8 = XEXP (x4, 1);
  operands[1] = x8;
  x9 = XVECEXP (x1, 0, 1);
  x10 = XEXP (x9, 1);
  x11 = XEXP (x10, 0);
  if (!rtx_equal_p (x11, operands[0]))
    return -1;
  x12 = XEXP (x10, 1);
  if (!rtx_equal_p (x12, operands[1]))
    return -1;
  x13 = XEXP (x9, 0);
  if (!rtx_equal_p (x13, operands[0]))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_QImode:
      return pattern363 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern363 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern363 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern363 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern377 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x2, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x5;
      x6 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x6))
        {
        case CLOBBER:
          return 0;

        case USE:
          return 1;

        default:
          return -1;
        }

    case STRICT_LOW_PART:
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17
          || GET_MODE (x7) != E_CCmode)
        return -1;
      x8 = XEXP (x5, 0);
      operands[0] = x8;
      res = pattern376 (x3);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern394 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 3);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 0);
  operands[0] = x7;
  x8 = XEXP (x6, 1);
  x9 = XEXP (x8, 0);
  operands[2] = x9;
  x10 = XEXP (x8, 1);
  operands[3] = x10;
  x11 = XEXP (x2, 0);
  operands[1] = x11;
  x12 = XEXP (x3, 0);
  if (!rtx_equal_p (x12, operands[2]))
    return -1;
  x13 = XEXP (x3, 1);
  if (!rtx_equal_p (x13, operands[3]))
    return -1;
  x14 = XVECEXP (x1, 0, 2);
  switch (GET_CODE (x14))
    {
    case UNSPEC:
      return pattern391 (x1); /* [-1, 1] */

    case USE:
      res = pattern393 (x1);
      if (res >= 0)
        return res + 2; /* [2, 4] */
      return -1;

    default:
      return -1;
    }
}

int
pattern411 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_SFmode:
      if (!memory_operand (operands[1], E_SFmode))
        return -1;
      return 0;

    case E_DFmode:
      if (!memory_operand (operands[1], E_DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern415 (rtx x1, rtx_code i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != PARALLEL
      || XVECLEN (x1, 0) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern419 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !const0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern426 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_HImode:
      if (!nonimmediate_operand (operands[1], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern435 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  x6 = XEXP (x3, 0);
  operands[2] = x6;
  if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return pattern434 (x2, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern434 (x2, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern449 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  return pattern448 (x1); /* [-1, 1] */
}

int
pattern454 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_MODE (x2))
    {
    case E_V32QImode:
      if (!vector_operand (operands[1], E_V32QImode)
          || !vector_operand (operands[2], E_V32QImode)
          || !const0_operand (operands[3], E_V32QImode))
        return -1;
      return 0;

    case E_V32HImode:
      if (!vector_operand (operands[1], E_V32HImode)
          || !vector_operand (operands[2], E_V32HImode)
          || !const0_operand (operands[3], E_V32HImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern464 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i3)
      || !nonimmediate_operand (operands[2], i3)
      || !nonimm_or_0_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern470 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !vector_operand (operands[1], i2)
      || !vector_operand (operands[2], i2)
      || !vector_operand (operands[3], i2)
      || !const0_operand (operands[4], i2))
    return -1;
  x3 = XEXP (x1, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[5], E_QImode))
    return -1;
  return 0;
}

int
pattern478 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[4], i1)
      || !register_operand (operands[5], i2))
    return -1;
  return 0;
}

int
pattern486 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  x7 = XEXP (x1, 1);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
      if (!rtx_equal_p (x7, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          return pattern480 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

        case E_V8SImode:
          if (pattern480 (x1, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          return 1;

        case E_V4SImode:
          if (pattern480 (x1, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[5] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern485 (x1, 
E_V16SImode, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V8SImode:
          if (pattern485 (x1, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          return 4;

        case E_V4SImode:
          if (pattern485 (x1, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern498 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x1) != E_V8HFmode
          || GET_MODE (x2) != E_V2HFmode)
        return -1;
      x7 = XEXP (x2, 0);
      if (GET_MODE (x7) != E_V2HFmode
          || !vector_operand (operands[1], i1)
          || GET_MODE (x3) != E_V2HFmode
          || !nonimm_or_0_operand (operands[2], E_V8HFmode)
          || !const0_operand (operands[4], E_V6HFmode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (pattern497 (x1, 
E_V2SFmode, 
E_V4SFmode, 
i1) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern506 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HImode:
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      return 0;

    case E_V8SImode:
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      return 1;

    case E_V8DImode:
      if (!register_operand (operands[1], E_V8DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern511 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const0_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4DImode:
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      return 0;

    case E_V4SImode:
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern517 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V2DFmode)
      || GET_MODE (x1) != E_V2DFmode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V2SImode:
      if (!nonimmediate_operand (operands[1], E_V2SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!nonimmediate_operand (operands[1], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern522 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i3)
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !permvar_truncate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern530 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !regmem_or_bitnot_regmem_operand (operands[1], i1)
      || !regmem_or_bitnot_regmem_operand (operands[2], i1)
      || !regmem_or_bitnot_regmem_operand (operands[3], i1)
      || !regmem_or_bitnot_regmem_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern533 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  switch (GET_CODE (x5))
    {
    case AND:
      return pattern532 (x1); /* [-1, 11] */

    case IOR:
      res = pattern532 (x1);
      if (res >= 0)
        return res + 12; /* [12, 23] */
      return -1;

    case XOR:
      res = pattern532 (x1);
      if (res >= 0)
        return res + 24; /* [24, 35] */
      return -1;

    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      operands[3] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern528 (x1, 
E_V32HFmode) != 0)
            return -1;
          return 36;

        case E_V16HFmode:
          if (pattern528 (x1, 
E_V16HFmode) != 0)
            return -1;
          return 37;

        case E_V8HFmode:
          if (pattern528 (x1, 
E_V8HFmode) != 0)
            return -1;
          return 38;

        case E_V32BFmode:
          if (pattern528 (x1, 
E_V32BFmode) != 0)
            return -1;
          return 39;

        case E_V16BFmode:
          if (pattern528 (x1, 
E_V16BFmode) != 0)
            return -1;
          return 40;

        case E_V8BFmode:
          if (pattern528 (x1, 
E_V8BFmode) != 0)
            return -1;
          return 41;

        case E_V16SFmode:
          if (pattern528 (x1, 
E_V16SFmode) != 0)
            return -1;
          return 42;

        case E_V8SFmode:
          if (pattern528 (x1, 
E_V8SFmode) != 0)
            return -1;
          return 43;

        case E_V4SFmode:
          if (pattern528 (x1, 
E_V4SFmode) != 0)
            return -1;
          return 44;

        case E_V8DFmode:
          if (pattern528 (x1, 
E_V8DFmode) != 0)
            return -1;
          return 45;

        case E_V4DFmode:
          if (pattern528 (x1, 
E_V4DFmode) != 0)
            return -1;
          return 46;

        case E_V2DFmode:
          if (pattern528 (x1, 
E_V2DFmode) != 0)
            return -1;
          return 47;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern546 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  return 0;
}

int
pattern552 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      x4 = XEXP (x1, 1);
      return pattern551 (x4, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      x4 = XEXP (x1, 1);
      if (pattern551 (x4, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern557 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern562 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode
      || !nonimmediate_operand (operands[1], E_SImode)
      || !x86_64_general_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern568 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!ix86_carry_flag_operator (operands[1], E_VOIDmode))
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17)
    return -1;
  x3 = XEXP (x1, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern573 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!const123_operand (operands[2], E_VOIDmode))
    return -1;
  return pattern430 (x1); /* [-1, 1] */
}

int
pattern578 (rtx x1, rtx_code i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != i2)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern583 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != USE)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != E_CCmode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 0);
  operands[0] = x6;
  x7 = XEXP (x5, 1);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  x9 = XEXP (x2, 0);
  operands[2] = x9;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      return pattern221 (x7, 
E_V8HFmode, 
E_HFmode); /* [-1, 0] */

    case E_SFmode:
      if (GET_MODE (x7) != E_SFmode)
        return -1;
      return 1;

    case E_DFmode:
      if (GET_MODE (x7) != E_DFmode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern590 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SUBREG
      || maybe_ne (SUBREG_BYTE (x2), 0))
    return -1;
  x3 = XVECEXP (x1, 0, 0);
  operands[1] = x3;
  return pattern589 (x1); /* [-1, 2] */
}

int
pattern594 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 1);
  if (!commutative_operator (x2, E_VOIDmode))
    return -1;
  operands[3] = x2;
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  if (!memory_operand (operands[2], E_VOIDmode))
    return -1;
  x4 = XEXP (x2, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  x5 = XEXP (x1, 0);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  return 0;
}

int
pattern600 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !const_int_operand (operands[2], E_QImode)
      || !const_scalar_int_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern606 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern611 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!const_1_to_63_operand (operands[2], E_QImode)
      || !register_operand (operands[0], E_TImode)
      || GET_MODE (x1) != E_TImode
      || !register_operand (operands[1], E_TImode))
    return -1;
  return 0;
}

int
pattern618 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != SUBREG
      || maybe_ne (SUBREG_BYTE (x2), 0)
      || GET_MODE (x2) != E_QImode)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      return pattern449 (x1); /* [-1, 1] */

    case PLUS:
      res = pattern449 (x1);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      x4 = XEXP (x3, 0);
      operands[3] = x4;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern16 (x1);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern631 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 2);
  operands[3] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern628 (x1, 
E_V16SImode, 
E_HImode, 
E_V16SFmode); /* [-1, 0] */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x1) != E_V8SImode
          || GET_MODE (x2) != E_V8SImode
          || !nonimm_or_0_operand (operands[2], E_V8SImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8SFmode:
          if (!vector_operand (operands[1], E_V8SFmode))
            return -1;
          return 1;

        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode
          || GET_MODE (x2) != E_V4SImode
          || !nonimm_or_0_operand (operands[2], E_V4SImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V4SFmode:
          if (!vector_operand (operands[1], E_V4SFmode))
            return -1;
          return 3;

        case E_V4DFmode:
          if (!vector_operand (operands[1], E_V4DFmode))
            return -1;
          return 4;

        case E_V2DFmode:
          if (!vector_operand (operands[1], E_V2DFmode))
            return -1;
          return 5;

        default:
          return -1;
        }

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x1) != E_V8DImode
          || GET_MODE (x2) != E_V8DImode
          || !nonimm_or_0_operand (operands[2], E_V8DImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode))
            return -1;
          return 6;

        case E_V8SFmode:
          if (!vector_operand (operands[1], E_V8SFmode))
            return -1;
          return 7;

        default:
          return -1;
        }

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x1) != E_V4DImode
          || GET_MODE (x2) != E_V4DImode
          || !nonimm_or_0_operand (operands[2], E_V4DImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V4DFmode:
          if (!vector_operand (operands[1], E_V4DFmode))
            return -1;
          return 8;

        case E_V4SFmode:
          if (!vector_operand (operands[1], E_V4SFmode))
            return -1;
          return 9;

        default:
          return -1;
        }

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x1) != E_V2DImode
          || GET_MODE (x2) != E_V2DImode
          || !nonimm_or_0_operand (operands[2], E_V2DImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V2DFmode:
          if (!vector_operand (operands[1], E_V2DFmode))
            return -1;
          return 10;

        case E_V4SFmode:
          if (!vector_operand (operands[1], E_V4SFmode))
            return -1;
          return 11;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern670 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_BFmode:
      if (!memory_operand (operands[1], E_BFmode))
        return -1;
      return 0;

    case E_HFmode:
      if (!memory_operand (operands[1], E_HFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern676 (rtx x1, rtx_code i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != i2)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern679 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCOmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  x6 = XEXP (x2, 1);
  if (GET_MODE (x6) != E_CCOmode)
    return -1;
  x7 = XEXP (x4, 0);
  operands[0] = x7;
  return 0;
}

int
pattern686 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x6) != CLOBBER)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 17
      || GET_MODE (x7) != E_CCmode)
    return -1;
  return pattern685 (x2); /* [-1, 3] */
}

int
pattern691 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V2SFmode)
      || GET_MODE (x1) != E_V2SFmode
      || !register_operand (operands[1], E_V2SFmode)
      || !nonimmediate_operand (operands[2], E_V2SFmode))
    return -1;
  return 0;
}

int
pattern698 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  return pattern407 (x5); /* [-1, 1] */
}

int
pattern704 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case UNSPEC:
      if (XVECLEN (x1, 0) != 1
          || XINT (x1, 1) != 37)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      return 0;

    case SET:
      x3 = XEXP (x1, 1);
      if (GET_CODE (x3) != PLUS
          || GET_MODE (x3) != E_SImode)
        return -1;
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != REG
          || REGNO (x4) != 7
          || GET_MODE (x4) != E_SImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_CODE (x5) != REG
          || REGNO (x5) != 7
          || GET_MODE (x5) != E_SImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern710 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i2)
      || !const_scalar_int_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern718 (rtx x1, machine_mode i1, unsigned int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != i2
      || GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern723 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (!rtx_equal_p (x3, operands[0]))
    return -1;
  x4 = XEXP (x1, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  x5 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (!rtx_equal_p (x6, operands[0]))
    return -1;
  x7 = PATTERN (peep2_next_insn (3));
  if (GET_CODE (x7) != SET)
    return -1;
  return 0;
}

int
pattern729 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern733 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != EQ)
    return -1;
  x4 = XEXP (x3, 0);
  operands[3] = x4;
  x5 = XEXP (x3, 1);
  operands[4] = x5;
  x6 = XEXP (x2, 1);
  operands[5] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V8QImode:
      return pattern732 (x1, 
E_V8QImode); /* [-1, 0] */

    case E_V4QImode:
      if (pattern732 (x1, 
E_V4QImode) != 0)
        return -1;
      return 1;

    case E_V2QImode:
      if (pattern732 (x1, 
E_V2QImode) != 0)
        return -1;
      return 2;

    case E_V2HImode:
      if (pattern732 (x1, 
E_V2HImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern744 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != i1)
    return -1;
  x5 = XEXP (x3, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x4, 0);
  operands[2] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V4HImode:
      if (!register_operand (operands[0], E_V4HImode)
          || GET_MODE (x1) != E_V4HImode
          || GET_MODE (x2) != E_V4SImode
          || GET_MODE (x3) != E_V4SImode
          || GET_MODE (x5) != E_V4SImode
          || !register_mmxmem_operand (operands[1], E_V4HImode)
          || GET_MODE (x4) != E_V4SImode
          || !register_mmxmem_operand (operands[2], E_V4HImode))
        return -1;
      return 0;

    case E_V2HImode:
      if (!register_operand (operands[0], E_V2HImode)
          || GET_MODE (x1) != E_V2HImode
          || GET_MODE (x2) != E_V2SImode
          || GET_MODE (x3) != E_V2SImode
          || GET_MODE (x5) != E_V2SImode
          || !register_operand (operands[1], E_V2HImode)
          || GET_MODE (x4) != E_V2SImode
          || !register_operand (operands[2], E_V2HImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern768 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern772 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      return pattern771 (x1, 
E_V8HFmode); /* [-1, 0] */

    case E_V4SFmode:
      if (pattern771 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    case E_V2DFmode:
      if (pattern771 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern779 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern788 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i3)
      || GET_MODE (x1) != i3
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern796 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const0_operand (operands[2], i1)
      || !pmovzx_parallel (operands[3], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern806 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern811 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (maybe_ne (SUBREG_BYTE (x1), 0)
      || GET_MODE (x1) != E_QImode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x2;
      x3 = XEXP (x2, 1);
      if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x4 = XEXP (x2, 2);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      return 0;

    default:
      return -1;
    }
}

int
pattern816 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_XFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != USE)
    return -1;
  x5 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x5) != USE
      || !register_operand (operands[0], E_XFmode)
      || !register_operand (operands[1], E_XFmode))
    return -1;
  x6 = XEXP (x4, 0);
  operands[2] = x6;
  if (!memory_operand (operands[2], E_HImode))
    return -1;
  x7 = XEXP (x5, 0);
  operands[3] = x7;
  if (!memory_operand (operands[3], E_HImode))
    return -1;
  return 0;
}

int
pattern823 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !x86_64_nonmemory_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern827 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V2SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      return pattern691 (x5); /* [-1, 0] */

    case E_V2BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V2BFmode) != 0)
        return -1;
      return 1;

    case E_V4BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V4BFmode) != 0)
        return -1;
      return 2;

    case E_V2HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V2HFmode) != 0)
        return -1;
      return 3;

    case E_V4HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern692 (x5, 
E_V4HFmode) != 0)
        return -1;
      return 4;

    case E_V32BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V32BFmode) != 0)
        return -1;
      return 5;

    case E_V16BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16BFmode) != 0)
        return -1;
      return 6;

    case E_V8BFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8BFmode) != 0)
        return -1;
      return 7;

    case E_V32HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V32HFmode) != 0)
        return -1;
      return 8;

    case E_V16HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16HFmode) != 0)
        return -1;
      return 9;

    case E_V8HFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8HFmode) != 0)
        return -1;
      return 10;

    case E_V16SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V16SFmode) != 0)
        return -1;
      return 11;

    case E_V8SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8SFmode) != 0)
        return -1;
      return 12;

    case E_V4SFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V4SFmode) != 0)
        return -1;
      return 13;

    case E_V8DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V8DFmode) != 0)
        return -1;
      return 14;

    case E_V4DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V4DFmode) != 0)
        return -1;
      return 15;

    case E_V2DFmode:
      x4 = XVECEXP (x1, 0, 0);
      x5 = XEXP (x4, 1);
      if (pattern690 (x5, 
E_V2DFmode) != 0)
        return -1;
      return 16;

    default:
      return -1;
    }
}

int
pattern863 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_DImode:
      if (!register_operand (operands[1], E_V64QImode)
          || !nonimmediate_operand (operands[2], E_V64QImode))
        return -1;
      return 0;

    case E_SImode:
      res = pattern862 ();
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    case E_HImode:
      res = pattern736 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    case E_QImode:
      res = pattern737 ();
      if (res >= 0)
        return res + 6; /* [6, 11] */
      return -1;

    default:
      return -1;
    }
}

int
pattern873 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !const_int_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern882 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern888 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != CONST_INT)
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x8) != CONST_INT)
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x9) != CONST_INT)
    return -1;
  x10 = XVECEXP (x1, 0, 8);
  if (GET_CODE (x10) != CONST_INT)
    return -1;
  x11 = XVECEXP (x1, 0, 9);
  if (GET_CODE (x11) != CONST_INT)
    return -1;
  x12 = XVECEXP (x1, 0, 10);
  if (GET_CODE (x12) != CONST_INT)
    return -1;
  x13 = XVECEXP (x1, 0, 11);
  if (GET_CODE (x13) != CONST_INT)
    return -1;
  x14 = XVECEXP (x1, 0, 12);
  if (GET_CODE (x14) != CONST_INT)
    return -1;
  x15 = XVECEXP (x1, 0, 13);
  if (GET_CODE (x15) != CONST_INT)
    return -1;
  x16 = XVECEXP (x1, 0, 14);
  if (GET_CODE (x16) != CONST_INT)
    return -1;
  x17 = XVECEXP (x1, 0, 15);
  if (GET_CODE (x17) != CONST_INT)
    return -1;
  x18 = XVECEXP (x1, 0, 16);
  if (GET_CODE (x18) != CONST_INT)
    return -1;
  x19 = XVECEXP (x1, 0, 17);
  if (GET_CODE (x19) != CONST_INT)
    return -1;
  x20 = XVECEXP (x1, 0, 18);
  if (GET_CODE (x20) != CONST_INT)
    return -1;
  x21 = XVECEXP (x1, 0, 19);
  if (GET_CODE (x21) != CONST_INT)
    return -1;
  x22 = XVECEXP (x1, 0, 20);
  if (GET_CODE (x22) != CONST_INT)
    return -1;
  x23 = XVECEXP (x1, 0, 21);
  if (GET_CODE (x23) != CONST_INT)
    return -1;
  x24 = XVECEXP (x1, 0, 22);
  if (GET_CODE (x24) != CONST_INT)
    return -1;
  x25 = XVECEXP (x1, 0, 23);
  if (GET_CODE (x25) != CONST_INT)
    return -1;
  x26 = XVECEXP (x1, 0, 24);
  if (GET_CODE (x26) != CONST_INT)
    return -1;
  x27 = XVECEXP (x1, 0, 25);
  if (GET_CODE (x27) != CONST_INT)
    return -1;
  x28 = XVECEXP (x1, 0, 26);
  if (GET_CODE (x28) != CONST_INT)
    return -1;
  x29 = XVECEXP (x1, 0, 27);
  if (GET_CODE (x29) != CONST_INT)
    return -1;
  x30 = XVECEXP (x1, 0, 28);
  if (GET_CODE (x30) != CONST_INT)
    return -1;
  x31 = XVECEXP (x1, 0, 29);
  if (GET_CODE (x31) != CONST_INT)
    return -1;
  x32 = XVECEXP (x1, 0, 30);
  if (GET_CODE (x32) != CONST_INT)
    return -1;
  x33 = XVECEXP (x1, 0, 31);
  if (GET_CODE (x33) != CONST_INT)
    return -1;
  return 0;
}

int
pattern917 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x2) != CONST_INT)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x7) != CONST_INT)
    return -1;
  return 0;
}

int
pattern925 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!nonimmediate_operand (operands[1], E_SImode))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  return pattern812 (x6, pnum_clobbers); /* [-1, 1] */
}

int
pattern933 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern940 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x3, 1);
  if (!rtx_equal_p (x6, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern203 (x3, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern203 (x3, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern947 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], i1)
      || !general_reg_operand (operands[1], i1))
    return -1;
  switch (GET_CODE (x1))
    {
    case SET:
      if (peep2_current_count < 4)
        return -1;
      x2 = XEXP (x1, 0);
      operands[2] = x2;
      if (!general_reg_operand (operands[2], i1))
        return -1;
      x3 = XEXP (x1, 1);
      if (!rtx_equal_p (x3, operands[1]))
        return -1;
      x4 = PATTERN (peep2_next_insn (2));
      if (GET_CODE (x4) != PARALLEL
          || XVECLEN (x4, 0) != 2)
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x5) != SET)
        return -1;
      x6 = XEXP (x5, 1);
      if (GET_CODE (x6) != ASHIFTRT
          || GET_MODE (x6) != i1)
        return -1;
      x7 = XVECEXP (x4, 0, 1);
      if (GET_CODE (x7) != CLOBBER)
        return -1;
      x8 = XEXP (x7, 0);
      if (GET_CODE (x8) != REG
          || REGNO (x8) != 17
          || GET_MODE (x8) != E_CCmode)
        return -1;
      x9 = XEXP (x6, 1);
      operands[4] = x9;
      if (!const_int_operand (operands[4], E_VOIDmode))
        return -1;
      x10 = XEXP (x6, 0);
      if (!rtx_equal_p (x10, operands[2]))
        return -1;
      x11 = XEXP (x5, 0);
      if (!rtx_equal_p (x11, operands[2]))
        return -1;
      x12 = PATTERN (peep2_next_insn (3));
      if (GET_CODE (x12) != SET)
        return -1;
      x13 = XEXP (x12, 0);
      operands[3] = x13;
      if (!memory_operand (operands[3], i1))
        return -1;
      x14 = XEXP (x12, 1);
      if (!rtx_equal_p (x14, operands[2]))
        return -1;
      return 0;

    case PARALLEL:
      if (XVECLEN (x1, 0) != 2)
        return -1;
      x15 = XVECEXP (x1, 0, 0);
      if (GET_CODE (x15) != SET)
        return -1;
      x16 = XEXP (x15, 1);
      if (GET_CODE (x16) != ASHIFTRT
          || GET_MODE (x16) != i1)
        return -1;
      x17 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x17) != CLOBBER)
        return -1;
      x18 = XEXP (x17, 0);
      if (GET_CODE (x18) != REG
          || REGNO (x18) != 17
          || GET_MODE (x18) != E_CCmode)
        return -1;
      x19 = XEXP (x15, 0);
      operands[2] = x19;
      if (!general_reg_operand (operands[2], i1))
        return -1;
      x20 = XEXP (x16, 1);
      operands[4] = x20;
      if (!const_int_operand (operands[4], E_VOIDmode))
        return -1;
      x21 = XEXP (x16, 0);
      if (!rtx_equal_p (x21, operands[1]))
        return -1;
      x4 = PATTERN (peep2_next_insn (2));
      if (GET_CODE (x4) != SET)
        return -1;
      x22 = XEXP (x4, 0);
      operands[3] = x22;
      if (!memory_operand (operands[3], i1))
        return -1;
      x23 = XEXP (x4, 1);
      if (!rtx_equal_p (x23, operands[2]))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern970 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vector_all_ones_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern976 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_SImode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V32HFmode:
      if (!register_operand (operands[1], E_V32HFmode)
          || !nonimmediate_operand (operands[2], E_V32HFmode)
          || !const_0_to_31_operand (operands[3], E_SImode))
        return -1;
      return 0;

    case E_V32QImode:
      if (!register_operand (operands[1], E_V32QImode)
          || !nonimmediate_operand (operands[2], E_V32QImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 1;

    case E_V32HImode:
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !const_0_to_7_operand (operands[3], E_SImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern987 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern990 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  return 0;
}

int
pattern999 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1008 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V8SImode)
      || GET_MODE (x1) != E_V8SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V8SImode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V8DFmode:
      if (!register_operand (operands[1], E_V8DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1019 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1027 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_HImode:
      x3 = XEXP (x1, 1);
      if (GET_MODE (x3) != E_HImode
          || !extract_operator (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      x3 = XEXP (x1, 1);
      if (GET_MODE (x3) != E_SImode
          || !extract_operator (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      x3 = XEXP (x1, 1);
      if (GET_MODE (x3) != E_DImode
          || !extract_operator (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1035 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[2] = x5;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x6 = XEXP (x1, 0);
  switch (GET_CODE (x6))
    {
    case STRICT_LOW_PART:
      x7 = XEXP (x6, 0);
      operands[0] = x7;
      if (!register_operand (operands[0], E_QImode))
        return -1;
      return pattern1034 (); /* [-1, 2] */

    case REG:
    case SUBREG:
      operands[0] = x6;
      if (!register_operand (operands[0], E_QImode))
        return -1;
      res = pattern1034 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1042 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1045 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1049 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x1, 1);
  operands[3] = x4;
  switch (GET_CODE (x3))
    {
    case SUBREG:
      if (maybe_ne (SUBREG_BYTE (x3), 0))
        return -1;
      x5 = XEXP (x3, 0);
      if (GET_CODE (x5) != AND)
        return -1;
      x6 = XEXP (x5, 0);
      operands[1] = x6;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      x7 = XEXP (x5, 1);
      operands[2] = x7;
      if (!const_int_operand (operands[2], E_VOIDmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          return pattern371 (x1, 
E_SImode); /* [-1, 0] */

        case E_DImode:
          if (pattern371 (x1, 
E_DImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case AND:
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      if (!register_operand (operands[1], E_QImode))
        return -1;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      if (!const_int_operand (operands[2], E_QImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern371 (x1, 
E_SImode) != 0)
            return -1;
          return 2;

        case E_DImode:
          if (pattern371 (x1, 
E_DImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1074 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  if (maybe_ne (SUBREG_BYTE (x1), 0))
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case VEC_MERGE:
      x3 = XEXP (x2, 2);
      if (GET_CODE (x3) != UNSPEC
          || XVECLEN (x3, 0) != 3
          || XINT (x3, 1) != 59
          || GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XVECEXP (x3, 0, 2);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x5 = XEXP (x2, 0);
      operands[3] = x5;
      x6 = XEXP (x2, 1);
      operands[4] = x6;
      x7 = XVECEXP (x3, 0, 0);
      operands[1] = x7;
      x8 = XVECEXP (x3, 0, 1);
      operands[2] = x8;
      switch (GET_MODE (x1))
        {
        case E_V8SFmode:
          return pattern1073 (x2, 
E_V8SImode); /* [-1, 0] */

        case E_V4SFmode:
          if (pattern1073 (x2, 
E_V4SImode) != 0)
            return -1;
          return 1;

        case E_V4DFmode:
          if (pattern1073 (x2, 
E_V4DImode) != 0)
            return -1;
          return 2;

        case E_V2DFmode:
          if (pattern1073 (x2, 
E_V2DImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    case ASHIFTRT:
      x5 = XEXP (x2, 0);
      operands[1] = x5;
      x6 = XEXP (x2, 1);
      operands[2] = x6;
      if (!const_int_operand (operands[2], E_QImode))
        return -1;
      switch (GET_MODE (x1))
        {
        case E_V8SFmode:
          if (GET_MODE (x2) != E_V8SImode
              || !register_operand (operands[1], E_V8SImode))
            return -1;
          return 4;

        case E_V4SFmode:
          if (GET_MODE (x2) != E_V4SImode
              || !register_operand (operands[1], E_V4SImode))
            return -1;
          return 5;

        case E_V4DFmode:
          if (GET_MODE (x2) != E_V4DImode
              || !register_operand (operands[1], E_V4DImode))
            return -1;
          return 6;

        case E_V2DFmode:
          if (GET_MODE (x2) != E_V2DImode
              || !register_operand (operands[1], E_V2DImode))
            return -1;
          return 7;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1098 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1106 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[2], i1)
      || !register_operand (operands[1], i1)
      || !avx2_pblendw_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern1113 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i4
      || !nonimmediate_operand (operands[2], i3))
    return -1;
  x4 = XEXP (x2, 1);
  return pattern1112 (x4, 
i1, 
i2, 
i3, 
i4); /* [-1, 0] */
}

int
pattern1119 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1125 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1131 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x4 = XEXP (x1, 2);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1140 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != 19
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern1145 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1152 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  return pattern1151 (x3); /* [-1, 2] */
}

int
pattern1159 (rtx x1, machine_mode i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != UNSPEC_VOLATILE
      || XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != i2
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern1165 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (maybe_ne (SUBREG_BYTE (x2), 0)
      || GET_MODE (x2) != E_QImode)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x3;
      x4 = XEXP (x3, 1);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x5 = XEXP (x3, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8]
          || GET_MODE (x1) != E_QImode)
        return -1;
      x6 = XEXP (x3, 0);
      if (!int248_register_operand (x6, E_VOIDmode))
        return -1;
      return 0;

    default:
      return -1;
    }
}

int
pattern1178 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PLUS)
    return -1;
  x7 = XEXP (x2, 0);
  if (GET_MODE (x7) != E_CCCmode
      || GET_MODE (x3) != E_CCCmode)
    return -1;
  x8 = XEXP (x4, 1);
  operands[2] = x8;
  if (!memory_operand (operands[2], i1))
    return -1;
  x9 = XEXP (x4, 0);
  if (!rtx_equal_p (x9, operands[0]))
    return -1;
  x10 = XEXP (x3, 1);
  if (!rtx_equal_p (x10, operands[0]))
    return -1;
  x11 = XEXP (x6, 0);
  if (!rtx_equal_p (x11, operands[0]))
    return -1;
  x12 = XEXP (x6, 1);
  if (!rtx_equal_p (x12, operands[2]))
    return -1;
  return 0;
}

int
pattern1188 (rtx x1, machine_mode i1, rtx_code i2, machine_mode i3, rtx_code i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != i4
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != i2
      || GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1192 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1195 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1203 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern1211 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[4] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x1) != E_V16QImode
          || !vector_operand (operands[1], E_V16QImode)
          || !register_operand (operands[2], E_V16QImode)
          || GET_MODE (x2) != E_V16QImode)
        return -1;
      switch (GET_MODE (x3))
        {
        case E_V4SImode:
          if (!register_operand (operands[3], E_V4SImode)
              || !vector_all_ones_operand (operands[4], E_V4SImode))
            return -1;
          return 0;

        case E_V2DImode:
          if (!register_operand (operands[3], E_V2DImode)
              || !vector_all_ones_operand (operands[4], E_V2DImode))
            return -1;
          return 1;

        default:
          return -1;
        }

    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode)
          || GET_MODE (x1) != E_V32QImode
          || !vector_operand (operands[1], E_V32QImode)
          || !register_operand (operands[2], E_V32QImode)
          || GET_MODE (x2) != E_V32QImode)
        return -1;
      switch (GET_MODE (x3))
        {
        case E_V8SImode:
          if (!register_operand (operands[3], E_V8SImode)
              || !vector_all_ones_operand (operands[4], E_V8SImode))
            return -1;
          return 2;

        case E_V4DImode:
          if (!register_operand (operands[3], E_V4DImode)
              || !vector_all_ones_operand (operands[4], E_V4DImode))
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1229 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[2] = x4;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x5 = XEXP (x1, 1);
  operands[1] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern1228 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern1228 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1237 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V4QImode:
      if (GET_MODE (x1) != E_V4QImode)
        return -1;
      return 0;

    case E_V2QImode:
      if (GET_MODE (x1) != E_V2QImode)
        return -1;
      return 1;

    case E_V2HImode:
      if (GET_MODE (x1) != E_V2HImode)
        return -1;
      return 2;

    case E_QImode:
      if (pattern1236 (x1, 
E_QImode) != 0)
        return -1;
      return 3;

    case E_HImode:
      if (pattern1236 (x1, 
E_HImode) != 0)
        return -1;
      return 4;

    case E_SImode:
      if (pattern1236 (x1, 
E_SImode) != 0)
        return -1;
      return 5;

    case E_DImode:
      if (pattern1236 (x1, 
E_DImode) != 0)
        return -1;
      return 6;

    default:
      return -1;
    }
}

int
pattern1249 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  operands[1] = x3;
  if (!nonimmediate_operand (operands[1], E_QImode))
    return -1;
  x4 = XEXP (x1, 0);
  switch (GET_CODE (x4))
    {
    case STRICT_LOW_PART:
      x5 = XEXP (x4, 0);
      operands[0] = x5;
      if (!register_operand (operands[0], E_QImode))
        return -1;
      return pattern1248 (); /* [-1, 2] */

    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x4;
      if (!nonimmediate_operand (operands[0], E_QImode))
        return -1;
      res = pattern1248 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1264 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i3)
      || !nonimmediate_operand (operands[2], i3)
      || !nonimm_or_0_operand (operands[4], i2)
      || !register_operand (operands[5], i1))
    return -1;
  return 0;
}

int
pattern1273 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !vector_all_ones_operand (operands[1], i2)
      || !const0_operand (operands[2], i2)
      || !register_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1283 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !vector_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern1291 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!const48_operand (operands[4], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      return pattern1288 (x1, 
E_QImode, 
E_V8HImode, 
E_V8HFmode); /* [-1, 0] */

    case E_V16HImode:
      if (pattern1288 (x1, 
E_HImode, 
E_V16HImode, 
E_V16HFmode) != 0)
        return -1;
      return 1;

    case E_V32HImode:
      if (pattern1288 (x1, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0)
        return -1;
      return 2;

    case E_V8SImode:
      res = pattern1289 (x1);
      if (res >= 0)
        return res + 3; /* [3, 4] */
      return -1;

    case E_V16SImode:
      res = pattern1290 (x1);
      if (res >= 0)
        return res + 5; /* [5, 6] */
      return -1;

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x1) != E_V8DImode)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      if (GET_MODE (x2) != E_V8DImode)
        return -1;
      x3 = XEXP (x2, 0);
      if (GET_MODE (x3) != E_V8DImode
          || !nonimm_or_0_operand (operands[2], E_V8DImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!register_operand (operands[1], E_V8HFmode))
            return -1;
          return 7;

        case E_V8DFmode:
          if (!register_operand (operands[1], E_V8DFmode))
            return -1;
          return 8;

        case E_V8SFmode:
          if (!register_operand (operands[1], E_V8SFmode))
            return -1;
          return 9;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1313 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1319 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1328 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_QImode:
      if (!general_reg_operand (operands[1], E_QImode)
          || !nonimmediate_operand (operands[2], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!general_reg_operand (operands[1], E_HImode)
          || !nonimmediate_operand (operands[2], E_HImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1335 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x2, 1);
  operands[5] = x5;
  x6 = XEXP (x4, 1);
  operands[6] = x6;
  x7 = XEXP (x4, 0);
  if (!rtx_equal_p (x7, operands[0]))
    return -1;
  x8 = PATTERN (peep2_next_insn (2));
  return pattern1334 (x8, 
i1); /* [-1, 0] */
}

int
pattern1345 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[4], i1)
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1353 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !vector_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || !register_operand (operands[5], i2))
    return -1;
  return 0;
}

int
pattern1360 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !bcst_vector_operand (operands[1], i1)
      || pattern1359 (
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1368 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x3 = XEXP (x2, 2);
  return pattern1367 (x3, 
i1, 
i2); /* [-1, 0] */
}

int
pattern1378 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2))
    return -1;
  x4 = XEXP (x2, 2);
  return pattern1367 (x4, 
i1, 
i2); /* [-1, 0] */
}

int
pattern1387 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      x5 = XEXP (x3, 2);
      operands[4] = x5;
      x6 = XVECEXP (x1, 0, 1);
      operands[5] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          return pattern1386 (x1, 
E_V8HFmode); /* [-1, 0] */

        case E_V4SFmode:
          if (pattern1386 (x1, 
E_V4SFmode) != 0)
            return -1;
          return 1;

        case E_V2DFmode:
          if (pattern1386 (x1, 
E_V2DFmode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x4;
      x7 = XEXP (x3, 0);
      x8 = XEXP (x7, 0);
      x9 = XEXP (x8, 0);
      operands[2] = x9;
      x10 = XEXP (x7, 1);
      operands[1] = x10;
      x5 = XEXP (x3, 2);
      operands[5] = x5;
      x6 = XVECEXP (x1, 0, 1);
      operands[6] = x6;
      x11 = XEXP (x2, 1);
      if (!rtx_equal_p (x11, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          return 3;

        case E_V4SFmode:
          return 4;

        case E_V2DFmode:
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1410 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !general_operand (operands[2], i1)
      || !nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  return 0;
}

int
pattern1413 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != i1
      || GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 1);
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != E_SImode
      || !nonimmediate_operand (operands[1], E_SImode)
      || !x86_64_general_operand (operands[2], E_SImode)
      || !register_operand (operands[0], E_DImode))
    return -1;
  x8 = XEXP (x4, 0);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  x9 = XEXP (x4, 1);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  return 0;
}

int
pattern1431 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !addsub_vm_operator (operands[6], i1))
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !vector_operand (operands[3], i1)
      || !vector_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1438 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern1448 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1456 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_all_ones_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 2);
  return pattern1455 (x2, 
i1, 
i2); /* [-1, 0] */
}

int
pattern1461 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern1468 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1474 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1)
      || !nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  return 0;
}

int
pattern1481 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !memory_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1488 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XVECEXP (x1, 0, 1);
  x8 = XEXP (x7, 0);
  operands[0] = x8;
  x9 = XEXP (x4, 1);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  return pattern1477 (x1); /* [-1, 1] */
}

int
pattern1495 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern1503 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_3_operand (operands[3], E_VOIDmode)
      || !const_0_to_3_operand (operands[4], E_VOIDmode)
      || !const_4_to_7_operand (operands[5], E_VOIDmode)
      || !const_4_to_7_operand (operands[6], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1510 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      if (!register_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1519 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[1], i2))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i1
      || !register_operand (operands[2], i2))
    return -1;
  x7 = XEXP (x3, 1);
  if (GET_MODE (x7) != i1)
    return -1;
  return 0;
}

int
pattern1529 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 4);
  operands[2] = x2;
  if (!const_4_to_7_operand (operands[2], E_VOIDmode))
    return -1;
  x3 = XVECEXP (x1, 0, 5);
  operands[3] = x3;
  if (!const_4_to_7_operand (operands[3], E_VOIDmode))
    return -1;
  x4 = XVECEXP (x1, 0, 6);
  operands[4] = x4;
  if (!const_4_to_7_operand (operands[4], E_VOIDmode))
    return -1;
  x5 = XVECEXP (x1, 0, 7);
  operands[5] = x5;
  if (!const_4_to_7_operand (operands[5], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1538 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (XWINT (x2, 0) != 2L)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (XWINT (x3, 0) != 3L)
    return -1;
  x4 = XVECEXP (x1, 0, 4);
  if (XWINT (x4, 0) != 4L)
    return -1;
  x5 = XVECEXP (x1, 0, 5);
  if (XWINT (x5, 0) != 5L)
    return -1;
  x6 = XVECEXP (x1, 0, 6);
  if (XWINT (x6, 0) != 6L)
    return -1;
  x7 = XVECEXP (x1, 0, 7);
  if (XWINT (x7, 0) != 7L)
    return -1;
  return 0;
}

int
pattern1551 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !memory_operand (operands[1], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1
      || !nonmemory_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1560 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], i1)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !x86_64_sext_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1565 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1576 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[2], i2))
    return -1;
  x4 = XEXP (x3, 2);
  if (GET_MODE (x4) != i2
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1585 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!vsib_mem_operator (operands[5], i1)
      || !register_operand (operands[6], E_QImode))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[3], i1))
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  switch (GET_MODE (x4))
    {
    case E_SImode:
      return pattern1584 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1584 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1595 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1603 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x5 = XEXP (x3, 0);
  if (!rtx_equal_p (x5, operands[1]))
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 1);
  x8 = XVECEXP (x7, 0, 0);
  switch (GET_MODE (x8))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !register_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode)
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1620 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x1, 1);
  if (!nonimm_or_0_operand (x4, i1))
    return -1;
  return 0;
}

int
pattern1627 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i2)
      || !register_operand (operands[3], i2)
      || !const0_operand (operands[4], i2)
      || !register_operand (operands[5], i1))
    return -1;
  return 0;
}

int
pattern1636 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[7], E_QImode)
      || !vsib_mem_operator (operands[6], i1))
    return -1;
  return 0;
}

int
pattern1645 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_SImode:
      return pattern1644 (x1, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern1644 (x1, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1656 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !const_0_to_7_operand (operands[3], E_VOIDmode)
      || pattern1655 () != 0)
    return -1;
  return 0;
}

int
pattern1665 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1670 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 2);
  if (maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != AND)
    return -1;
  x6 = XEXP (x5, 0);
  operands[2] = x6;
  x7 = XEXP (x5, 1);
  operands[3] = x7;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  x8 = XEXP (x1, 1);
  x9 = XEXP (x8, 0);
  operands[4] = x9;
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1669 (x5, 
E_SImode); /* [-1, 2] */

    case E_DImode:
      res = pattern1669 (x5, 
E_DImode);
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1681 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[5], i3))
    return -1;
  return 0;
}

int
pattern1691 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_7_operand (operands[2], E_VOIDmode)
      || !const_0_to_7_operand (operands[3], E_VOIDmode)
      || !const_0_to_7_operand (operands[4], E_VOIDmode)
      || !const_0_to_7_operand (operands[5], E_VOIDmode)
      || !const_0_to_7_operand (operands[6], E_VOIDmode)
      || !const_0_to_7_operand (operands[7], E_VOIDmode)
      || !const_0_to_7_operand (operands[8], E_VOIDmode)
      || !const_0_to_7_operand (operands[9], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1702 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1709 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[6], E_QImode)
      || !vsib_mem_operator (operands[5], i1)
      || !scratch_operand (operands[1], E_QImode))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1708 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1708 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1721 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode)
          || !register_operand (operands[3], E_V8SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode)
          || !register_operand (operands[3], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1726 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !vsib_mem_operator (operands[7], i2)
      || !register_operand (operands[5], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1725 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1725 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1739 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !const_0_to_7_operand (operands[3], E_VOIDmode)
      || !const_0_to_7_operand (operands[4], E_VOIDmode)
      || !const_0_to_7_operand (operands[5], E_VOIDmode)
      || !const_0_to_7_operand (operands[6], E_VOIDmode)
      || !const_8_to_15_operand (operands[7], E_VOIDmode)
      || !const_8_to_15_operand (operands[8], E_VOIDmode)
      || !const_8_to_15_operand (operands[9], E_VOIDmode)
      || !const_8_to_15_operand (operands[10], E_VOIDmode)
      || !nonimm_or_0_operand (operands[11], i1))
    return -1;
  return 0;
}

int
pattern1754 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V16SImode:
      return pattern1752 (
E_HImode, 
E_V16SFmode, 
E_V16SImode); /* [-1, 0] */

    case E_V8DImode:
      if (pattern1752 (
E_QImode, 
E_V8SFmode, 
E_V8DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1762 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], i1)
      || !register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[3], i1)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1768 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 12);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 13);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 14);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 15);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  x6 = XVECEXP (x1, 0, 16);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x7 = XVECEXP (x1, 0, 17);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
    return -1;
  x8 = XVECEXP (x1, 0, 18);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
    return -1;
  x9 = XVECEXP (x1, 0, 19);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
    return -1;
  return 0;
}

int
pattern1782 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[3]))
    {
    case E_HImode:
      if (!extract_operator (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!extract_operator (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!extract_operator (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1792 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_3_operand (operands[2], E_VOIDmode)
      || !const_0_to_3_operand (operands[3], E_VOIDmode)
      || !const_0_to_3_operand (operands[4], E_VOIDmode)
      || !const_0_to_3_operand (operands[5], E_VOIDmode)
      || !const_4_to_7_operand (operands[6], E_VOIDmode)
      || !const_4_to_7_operand (operands[7], E_VOIDmode)
      || !const_4_to_7_operand (operands[8], E_VOIDmode)
      || !const_4_to_7_operand (operands[9], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1800 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47, x48, x49;
  rtx x50, x51, x52, x53, x54, x55;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != VEC_SELECT
      || GET_MODE (x5) != E_V2QImode)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PARALLEL
      || XVECLEN (x6, 0) != 2)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x8 = XVECEXP (x6, 0, 1);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x9 = XEXP (x3, 1);
  if (GET_CODE (x9) != i1)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != VEC_SELECT
      || GET_MODE (x10) != E_V2QImode)
    return -1;
  x11 = XEXP (x10, 1);
  if (GET_CODE (x11) != PARALLEL
      || XVECLEN (x11, 0) != 2)
    return -1;
  x12 = XVECEXP (x11, 0, 0);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x11, 0, 1);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
    return -1;
  x14 = XEXP (x2, 1);
  x15 = XEXP (x14, 0);
  if (GET_CODE (x15) != i1)
    return -1;
  x16 = XEXP (x15, 0);
  if (GET_CODE (x16) != VEC_SELECT
      || GET_MODE (x16) != E_V2QImode)
    return -1;
  x17 = XEXP (x16, 1);
  if (GET_CODE (x17) != PARALLEL
      || XVECLEN (x17, 0) != 2)
    return -1;
  x18 = XVECEXP (x17, 0, 0);
  if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x19 = XVECEXP (x17, 0, 1);
  if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
    return -1;
  x20 = XEXP (x14, 1);
  if (GET_CODE (x20) != i1)
    return -1;
  x21 = XEXP (x20, 0);
  if (GET_CODE (x21) != VEC_SELECT
      || GET_MODE (x21) != E_V2QImode)
    return -1;
  x22 = XEXP (x21, 1);
  if (GET_CODE (x22) != PARALLEL
      || XVECLEN (x22, 0) != 2)
    return -1;
  x23 = XVECEXP (x22, 0, 0);
  if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x24 = XVECEXP (x22, 0, 1);
  if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
    return -1;
  x25 = XEXP (x1, 1);
  x26 = XEXP (x25, 0);
  x27 = XEXP (x26, 0);
  if (GET_CODE (x27) != i1)
    return -1;
  x28 = XEXP (x27, 0);
  if (GET_CODE (x28) != VEC_SELECT
      || GET_MODE (x28) != E_V2QImode)
    return -1;
  x29 = XEXP (x28, 1);
  if (GET_CODE (x29) != PARALLEL
      || XVECLEN (x29, 0) != 2)
    return -1;
  x30 = XVECEXP (x29, 0, 0);
  if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x31 = XVECEXP (x29, 0, 1);
  if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
    return -1;
  x32 = XEXP (x26, 1);
  if (GET_CODE (x32) != i1)
    return -1;
  x33 = XEXP (x32, 0);
  if (GET_CODE (x33) != VEC_SELECT
      || GET_MODE (x33) != E_V2QImode)
    return -1;
  x34 = XEXP (x33, 1);
  if (GET_CODE (x34) != PARALLEL
      || XVECLEN (x34, 0) != 2)
    return -1;
  x35 = XVECEXP (x34, 0, 0);
  if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x36 = XVECEXP (x34, 0, 1);
  if (x36 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x37 = XEXP (x25, 1);
  x38 = XEXP (x37, 0);
  if (GET_CODE (x38) != i1)
    return -1;
  x39 = XEXP (x38, 0);
  if (GET_CODE (x39) != VEC_SELECT
      || GET_MODE (x39) != E_V2QImode)
    return -1;
  x40 = XEXP (x39, 1);
  if (GET_CODE (x40) != PARALLEL
      || XVECLEN (x40, 0) != 2)
    return -1;
  x41 = XVECEXP (x40, 0, 0);
  if (x41 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x42 = XVECEXP (x40, 0, 1);
  if (x42 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
    return -1;
  x43 = XEXP (x37, 1);
  if (GET_CODE (x43) != i1)
    return -1;
  x44 = XEXP (x43, 0);
  if (GET_CODE (x44) != VEC_SELECT
      || GET_MODE (x44) != E_V2QImode)
    return -1;
  x45 = XEXP (x44, 1);
  if (GET_CODE (x45) != PARALLEL
      || XVECLEN (x45, 0) != 2)
    return -1;
  x46 = XVECEXP (x45, 0, 0);
  if (x46 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x47 = XVECEXP (x45, 0, 1);
  if (x47 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  x48 = XEXP (x5, 0);
  operands[1] = x48;
  if (!nonimmediate_operand (operands[1], E_V16QImode))
    return -1;
  x49 = XEXP (x10, 0);
  if (!rtx_equal_p (x49, operands[1]))
    return -1;
  x50 = XEXP (x16, 0);
  if (!rtx_equal_p (x50, operands[1]))
    return -1;
  x51 = XEXP (x21, 0);
  if (!rtx_equal_p (x51, operands[1]))
    return -1;
  x52 = XEXP (x28, 0);
  if (!rtx_equal_p (x52, operands[1]))
    return -1;
  x53 = XEXP (x33, 0);
  if (!rtx_equal_p (x53, operands[1]))
    return -1;
  x54 = XEXP (x39, 0);
  if (!rtx_equal_p (x54, operands[1]))
    return -1;
  x55 = XEXP (x44, 0);
  if (!rtx_equal_p (x55, operands[1]))
    return -1;
  return 0;
}

int
pattern1855 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !ix86_carry_flag_operator (operands[4], i2))
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x7 = XEXP (x4, 1);
  if (GET_MODE (x7) != i2
      || !sext_operand (operands[2], i1)
      || pattern1854 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1862 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[4], i2)
      || !const_int_operand (operands[6], i2))
    return -1;
  x7 = XEXP (x3, 1);
  if (GET_MODE (x7) != i2)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_MODE (x8) != i1)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_MODE (x9) != i1
      || !ix86_carry_flag_operator (operands[5], i1))
    return -1;
  x10 = XVECEXP (x1, 0, 1);
  x11 = XEXP (x10, 1);
  return pattern1857 (x11, 
i1); /* [-1, 0] */
}

int
pattern1872 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 24);
  if (XWINT (x2, 0) != 28L)
    return -1;
  x3 = XVECEXP (x1, 0, 25);
  if (XWINT (x3, 0) != 60L)
    return -1;
  x4 = XVECEXP (x1, 0, 26);
  if (XWINT (x4, 0) != 29L)
    return -1;
  x5 = XVECEXP (x1, 0, 27);
  if (XWINT (x5, 0) != 61L)
    return -1;
  x6 = XVECEXP (x1, 0, 28);
  if (XWINT (x6, 0) != 30L)
    return -1;
  x7 = XVECEXP (x1, 0, 29);
  if (XWINT (x7, 0) != 62L)
    return -1;
  x8 = XVECEXP (x1, 0, 30);
  if (XWINT (x8, 0) != 31L)
    return -1;
  x9 = XVECEXP (x1, 0, 31);
  if (XWINT (x9, 0) != 63L)
    return -1;
  return 0;
}

 int
recog_7 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_HImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], E_HImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  if (GET_MODE (x4) != E_CCFPmode)
    return -1;
  switch (GET_CODE (x4))
    {
    case COMPARE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      switch (GET_CODE (x6))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case REG:
        case SUBREG:
        case MEM:
          operands[2] = x6;
          switch (GET_MODE (operands[1]))
            {
            case E_XFmode:
              if (!register_operand (operands[1], E_XFmode)
                  || !reg_or_0_operand (operands[2], E_XFmode)
                  || !
#line 1936 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 35; /* *cmpxf_i387 */

            case E_SFmode:
              if (!register_operand (operands[1], E_SFmode)
                  || !nonimm_or_0_operand (operands[2], E_SFmode)
                  || !
#line 1949 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 36; /* *cmpsf_i387 */

            case E_DFmode:
              if (!register_operand (operands[1], E_DFmode)
                  || !nonimm_or_0_operand (operands[2], E_DFmode)
                  || !
#line 1949 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 37; /* *cmpdf_i387 */

            default:
              return -1;
            }

        case FLOAT:
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          switch (GET_MODE (operands[1]))
            {
            case E_SFmode:
              switch (pattern1247 (x6, 
E_SFmode))
                {
                case 0:
                  if (!
#line 1963 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_HIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 38; /* *cmpsf_hi_i387 */

                case 1:
                  if (!
#line 1963 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_SIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 41; /* *cmpsf_si_i387 */

                default:
                  return -1;
                }

            case E_DFmode:
              switch (pattern1247 (x6, 
E_DFmode))
                {
                case 0:
                  if (!
#line 1963 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_HIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 39; /* *cmpdf_hi_i387 */

                case 1:
                  if (!
#line 1963 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_SIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 42; /* *cmpdf_si_i387 */

                default:
                  return -1;
                }

            case E_XFmode:
              switch (pattern1247 (x6, 
E_XFmode))
                {
                case 0:
                  if (!
#line 1963 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_HIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 40; /* *cmpxf_hi_i387 */

                case 1:
                  if (!
#line 1963 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_SIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 43; /* *cmpxf_si_i387 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x4, 0) != 1
          || XINT (x4, 1) != 26)
        return -1;
      x8 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x8) != COMPARE
          || GET_MODE (x8) != E_CCFPmode)
        return -1;
      x9 = XEXP (x8, 0);
      operands[1] = x9;
      x10 = XEXP (x8, 1);
      operands[2] = x10;
      switch (GET_MODE (operands[1]))
        {
        case E_SFmode:
          if (!register_operand (operands[1], E_SFmode)
              || !register_operand (operands[2], E_SFmode)
              || !
#line 1981 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 44; /* *cmpusf_i387 */

        case E_DFmode:
          if (!register_operand (operands[1], E_DFmode)
              || !register_operand (operands[2], E_DFmode)
              || !
#line 1981 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 45; /* *cmpudf_i387 */

        case E_XFmode:
          if (!register_operand (operands[1], E_XFmode)
              || !register_operand (operands[2], E_XFmode)
              || !
#line 1981 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 46; /* *cmpuxf_i387 */

        default:
          return -1;
        }

    case REG:
      if (REGNO (x4) != 18
          || !
#line 23896 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
        return -1;
      return 1714; /* x86_fnstsw_1 */

    default:
      return -1;
    }
}

 int
recog_15 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V1TImode:
      if (!push_operand (operands[0], E_V1TImode)
          || !register_operand (operands[1], E_V1TImode))
        return -1;
      if ((
#line 2175 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
        return 65; /* *pushv1ti2 */
      if (!(
#line 2175 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
        return -1;
      return 66; /* *pushv1ti2 */

    case E_DImode:
      if (push_operand (operands[0], E_DImode)
          && general_no_elim_operand (operands[1], E_DImode))
        {
          if (
#line 1195 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 67; /* *pushdi2 */
          if (
#line 2206 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 69; /* *pushdi2_rex64 */
        }
      if (nonimmediate_operand (operands[0], E_DImode)
          && pop_operand (operands[1], E_DImode)
          && 
#line 1403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
        return 77; /* *popdi1 */
      if (pnum_clobbers != NULL
          && const0_operand (operands[1], E_DImode))
        {
          if (register_operand (operands[0], E_DImode)
              && (
#line 2424 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 85; /* *movdi_xor */
            }
          if (memory_operand (operands[0], E_DImode)
              && (
#line 2436 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 88; /* *movdi_and */
            }
        }
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      if (pnum_clobbers != NULL
          && constm1_operand (operands[1], E_DImode)
          && (
#line 2451 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pnum_clobbers = 1;
          return 91; /* *movdi_or */
        }
      if (!general_operand (operands[1], E_DImode)
          || !
#line 2594 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 95; /* *movdi_internal */

    case E_TImode:
      if (push_operand (operands[0], E_TImode)
          && general_no_elim_operand (operands[1], E_TImode)
          && 
#line 1196 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return 68; /* *pushti2 */
      if (!nonimmediate_operand (operands[0], E_TImode)
          || !general_operand (operands[1], E_TImode)
          || !
#line 2510 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_64BIT
    && !(MEM_P (operands[0]) && MEM_P (operands[1])))
   || (TARGET_SSE
       && nonimmediate_or_sse_const_operand (operands[1], TImode)
       && (register_operand (operands[0], TImode)
	   || register_operand (operands[1], TImode)))))
        return -1;
      return 94; /* *movti_internal */

    case E_SImode:
      if (push_operand (operands[0], E_SImode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_SImode)
              && 
#line 2249 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 70; /* *pushsi2_rex64 */
          if (general_no_elim_operand (operands[1], E_SImode)
              && 
#line 2259 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 71; /* *pushsi2 */
        }
      if (nonimmediate_operand (operands[0], E_SImode)
          && pop_operand (operands[1], E_SImode)
          && 
#line 1403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
        return 76; /* *popsi1 */
      if (pnum_clobbers != NULL
          && const0_operand (operands[1], E_SImode))
        {
          if (register_operand (operands[0], E_SImode)
              && 
#line 2424 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
            {
              *pnum_clobbers = 1;
              return 84; /* *movsi_xor */
            }
          if (memory_operand (operands[0], E_SImode)
              && 
#line 2436 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
            {
              *pnum_clobbers = 1;
              return 87; /* *movsi_and */
            }
        }
      if (!nonimmediate_operand (operands[0], E_SImode))
        return -1;
      if (pnum_clobbers != NULL
          && constm1_operand (operands[1], E_SImode)
          && 
#line 2451 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        {
          *pnum_clobbers = 1;
          return 90; /* *movsi_or */
        }
      if (!general_operand (operands[1], E_SImode)
          || !
#line 2834 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 96; /* *movsi_internal */

    case E_QImode:
      if (push_operand (operands[0], E_QImode)
          && nonmemory_no_elim_operand (operands[1], E_QImode))
        return 72; /* *pushqi2 */
      if (!nonimmediate_operand (operands[0], E_QImode)
          || !general_operand (operands[1], E_QImode)
          || !
#line 3156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 98; /* *movqi_internal */

    case E_HImode:
      if (push_operand (operands[0], E_HImode)
          && nonmemory_no_elim_operand (operands[1], E_HImode))
        return 73; /* *pushhi2 */
      if (pnum_clobbers != NULL
          && memory_operand (operands[0], E_HImode)
          && const0_operand (operands[1], E_HImode)
          && 
#line 2436 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        {
          *pnum_clobbers = 1;
          return 86; /* *movhi_and */
        }
      if (!nonimmediate_operand (operands[0], E_HImode))
        return -1;
      if (pnum_clobbers != NULL
          && constm1_operand (operands[1], E_HImode)
          && 
#line 2451 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        {
          *pnum_clobbers = 1;
          return 89; /* *movhi_or */
        }
      if (!general_operand (operands[1], E_HImode)
          || !
#line 2993 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 97; /* *movhi_internal */

    case E_TFmode:
      if (push_operand (operands[0], E_TFmode)
          && general_no_elim_operand (operands[1], E_TFmode)
          && 
#line 3777 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT || TARGET_SSE))
        return 152; /* *pushtf */
      if (!nonimmediate_operand (operands[0], E_TFmode)
          || !general_operand (operands[1], E_TFmode)
          || !
#line 4046 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_64BIT || TARGET_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || (standard_sse_constant_p (operands[1], TFmode) == 1
	   && !memory_operand (operands[0], TFmode))
       || (!TARGET_MEMORY_MISMATCH_STALL
	   && memory_operand (operands[0], TFmode)))))
        return -1;
      return 167; /* *movtf_internal */

    case E_XFmode:
      if (push_operand (operands[0], E_XFmode)
          && general_no_elim_operand (operands[1], E_XFmode))
        return 153; /* *pushxf */
      if (!nonimmediate_operand (operands[0], E_XFmode)
          || !general_operand (operands[1], E_XFmode)
          || !
#line 4106 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || ((optimize_function_for_size_p (cfun)
	    || (ix86_cmodel == CM_LARGE || ix86_cmodel == CM_LARGE_PIC))
	   && standard_80387_constant_p (operands[1]) > 0
	   && !memory_operand (operands[0], XFmode))
       || (!TARGET_MEMORY_MISMATCH_STALL
	   && memory_operand (operands[0], XFmode))
       || !TARGET_HARD_XF_REGS)))
        return -1;
      return 168; /* *movxf_internal */

    case E_DFmode:
      if (push_operand (operands[0], E_DFmode)
          && general_no_elim_operand (operands[1], E_DFmode))
        return 154; /* *pushdf */
      if (!nonimmediate_operand (operands[0], E_DFmode)
          || !general_operand (operands[1], E_DFmode)
          || !
#line 4178 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || ((optimize_function_for_size_p (cfun)
	    || (ix86_cmodel == CM_LARGE || ix86_cmodel == CM_LARGE_PIC))
	   && IS_STACK_MODE (DFmode)
	   && standard_80387_constant_p (operands[1]) > 0
	   && !memory_operand (operands[0], DFmode))
       || (TARGET_SSE2 && TARGET_SSE_MATH
	   && standard_sse_constant_p (operands[1], DFmode) == 1
	   && !memory_operand (operands[0], DFmode))
       || ((TARGET_64BIT || !TARGET_MEMORY_MISMATCH_STALL)
	   && memory_operand (operands[0], DFmode))
       || !TARGET_HARD_DF_REGS)))
        return -1;
      return 169; /* *movdf_internal */

    case E_HFmode:
      if (push_operand (operands[0], E_HFmode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_HFmode)
              && 
#line 3873 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 155; /* *pushhf_rex64 */
          if (general_no_elim_operand (operands[1], E_HFmode)
              && 
#line 3886 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 157; /* *pushhf */
        }
      if (!nonimmediate_operand (operands[0], E_HFmode)
          || !general_operand (operands[1], E_HFmode)
          || !
#line 4490 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
  && (lra_in_progress
      || reload_completed
      || !CONST_DOUBLE_P (operands[1])
      || (TARGET_SSE2
	  && standard_sse_constant_p (operands[1], HFmode) == 1)
      || memory_operand (operands[0], HFmode))))
        return -1;
      return 171; /* *movhf_internal */

    case E_BFmode:
      if (push_operand (operands[0], E_BFmode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_BFmode)
              && 
#line 3873 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 156; /* *pushbf_rex64 */
          if (general_no_elim_operand (operands[1], E_BFmode)
              && 
#line 3886 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 158; /* *pushbf */
        }
      if (!nonimmediate_operand (operands[0], E_BFmode)
          || !general_operand (operands[1], E_BFmode)
          || !
#line 4490 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
  && (lra_in_progress
      || reload_completed
      || !CONST_DOUBLE_P (operands[1])
      || (TARGET_SSE2
	  && standard_sse_constant_p (operands[1], BFmode) == 1)
      || memory_operand (operands[0], BFmode))))
        return -1;
      return 172; /* *movbf_internal */

    case E_SFmode:
      if (push_operand (operands[0], E_SFmode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_SFmode)
              && 
#line 3961 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 165; /* *pushsf_rex64 */
          if (general_no_elim_operand (operands[1], E_SFmode)
              && 
#line 3975 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 166; /* *pushsf */
        }
      if (!nonimmediate_operand (operands[0], E_SFmode)
          || !general_operand (operands[1], E_SFmode)
          || !
#line 4355 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || ((optimize_function_for_size_p (cfun)
	    || (ix86_cmodel == CM_LARGE || ix86_cmodel == CM_LARGE_PIC))
	   && IS_STACK_MODE (SFmode)
	   && standard_80387_constant_p (operands[1]) > 0)
       || (TARGET_SSE && TARGET_SSE_MATH
	   && standard_sse_constant_p (operands[1], SFmode) == 1)
       || memory_operand (operands[0], SFmode)
       || !TARGET_HARD_SF_REGS)))
        return -1;
      return 170; /* *movsf_internal */

    case E_V8QImode:
      if (nonimmediate_operand (operands[0], E_V8QImode)
          && nonimm_or_0_operand (operands[1], E_V8QImode)
          && 
#line 189 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2019; /* *movv8qi_internal */
      if (!memory_operand (operands[0], E_V8QImode)
          || !x86_64_const_vector_operand (operands[1], E_V8QImode)
          || !
#line 87 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2035; /* *movv8qi_imm */

    case E_V4HImode:
      if (nonimmediate_operand (operands[0], E_V4HImode)
          && nonimm_or_0_operand (operands[1], E_V4HImode)
          && 
#line 189 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2020; /* *movv4hi_internal */
      if (!memory_operand (operands[0], E_V4HImode)
          || !x86_64_const_vector_operand (operands[1], E_V4HImode)
          || !
#line 87 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2036; /* *movv4hi_imm */

    case E_V2SImode:
      if (nonimmediate_operand (operands[0], E_V2SImode)
          && nonimm_or_0_operand (operands[1], E_V2SImode)
          && 
#line 189 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2021; /* *movv2si_internal */
      if (!memory_operand (operands[0], E_V2SImode)
          || !x86_64_const_vector_operand (operands[1], E_V2SImode)
          || !
#line 89 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2039; /* *movv2si_imm */

    case E_V1DImode:
      if (!nonimmediate_operand (operands[0], E_V1DImode)
          || !nonimm_or_0_operand (operands[1], E_V1DImode)
          || !
#line 189 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 2022; /* *movv1di_internal */

    case E_V2SFmode:
      if (nonimmediate_operand (operands[0], E_V2SFmode)
          && nonimm_or_0_operand (operands[1], E_V2SFmode)
          && 
#line 189 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2023; /* *movv2sf_internal */
      if (!memory_operand (operands[0], E_V2SFmode)
          || !x86_64_const_vector_operand (operands[1], E_V2SFmode)
          || !
#line 89 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2040; /* *movv2sf_imm */

    case E_V4HFmode:
      if (nonimmediate_operand (operands[0], E_V4HFmode)
          && nonimm_or_0_operand (operands[1], E_V4HFmode)
          && 
#line 189 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2024; /* *movv4hf_internal */
      if (!memory_operand (operands[0], E_V4HFmode)
          || !x86_64_const_vector_operand (operands[1], E_V4HFmode)
          || !
#line 88 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2037; /* *movv4hf_imm */

    case E_V4BFmode:
      if (nonimmediate_operand (operands[0], E_V4BFmode)
          && nonimm_or_0_operand (operands[1], E_V4BFmode)
          && 
#line 189 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2025; /* *movv4bf_internal */
      if (!memory_operand (operands[0], E_V4BFmode)
          || !x86_64_const_vector_operand (operands[1], E_V4BFmode)
          || !
#line 88 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2038; /* *movv4bf_imm */

    case E_V4QImode:
      if (nonimmediate_operand (operands[0], E_V4QImode)
          && general_operand (operands[1], E_V4QImode)
          && 
#line 344 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2026; /* *movv4qi_internal */
      if (memory_operand (operands[0], E_V4QImode)
          && x86_64_const_vector_operand (operands[1], E_V4QImode))
        return 2032; /* *movv4qi_imm */
      if (!push_operand (operands[0], E_V4QImode)
          || !nonmemory_no_elim_operand (operands[1], E_V4QImode)
          || !
#line 430 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2041; /* *pushv4qi2_rex64 */

    case E_V2HImode:
      if (nonimmediate_operand (operands[0], E_V2HImode)
          && general_operand (operands[1], E_V2HImode)
          && 
#line 344 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2027; /* *movv2hi_internal */
      if (memory_operand (operands[0], E_V2HImode)
          && x86_64_const_vector_operand (operands[1], E_V2HImode))
        return 2033; /* *movv2hi_imm */
      if (!push_operand (operands[0], E_V2HImode)
          || !nonmemory_no_elim_operand (operands[1], E_V2HImode)
          || !
#line 430 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2042; /* *pushv2hi2_rex64 */

    case E_V1SImode:
      if (nonimmediate_operand (operands[0], E_V1SImode)
          && general_operand (operands[1], E_V1SImode)
          && 
#line 344 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2028; /* *movv1si_internal */
      if (!push_operand (operands[0], E_V1SImode)
          || !nonmemory_no_elim_operand (operands[1], E_V1SImode)
          || !
#line 430 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2043; /* *pushv1si2_rex64 */

    case E_V2HFmode:
      if (nonimmediate_operand (operands[0], E_V2HFmode)
          && general_operand (operands[1], E_V2HFmode)
          && 
#line 344 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2029; /* *movv2hf_internal */
      if (memory_operand (operands[0], E_V2HFmode)
          && x86_64_const_vector_operand (operands[1], E_V2HFmode))
        return 2034; /* *movv2hf_imm */
      if (!push_operand (operands[0], E_V2HFmode)
          || !nonmemory_no_elim_operand (operands[1], E_V2HFmode)
          || !
#line 430 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2044; /* *pushv2hf2_rex64 */

    case E_V2BFmode:
      if (nonimmediate_operand (operands[0], E_V2BFmode)
          && general_operand (operands[1], E_V2BFmode)
          && 
#line 344 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2030; /* *movv2bf_internal */
      if (!push_operand (operands[0], E_V2BFmode)
          || !nonmemory_no_elim_operand (operands[1], E_V2BFmode)
          || !
#line 430 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2045; /* *pushv2bf2_rex64 */

    case E_V2QImode:
      if (memory_operand (operands[0], E_V2QImode)
          && x86_64_const_vector_operand (operands[1], E_V2QImode))
        return 2031; /* *movv2qi_imm */
      if (nonimmediate_operand (operands[0], E_V2QImode)
          && general_operand (operands[1], E_V2QImode)
          && 
#line 472 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))))
        return 2046; /* *movv2qi_internal */
      if (!push_operand (operands[0], E_V2QImode)
          || !nonmemory_no_elim_operand (operands[1], E_V2QImode))
        return -1;
      return 2047; /* *pushv2qi2 */

    case E_P2QImode:
      if (!nonimmediate_operand (operands[0], E_P2QImode)
          || !nonimmediate_operand (operands[1], E_P2QImode)
          || !
#line 30964 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
        return -1;
      return 10256; /* *movp2qi_internal */

    case E_P2HImode:
      if (!nonimmediate_operand (operands[0], E_P2HImode)
          || !nonimmediate_operand (operands[1], E_P2HImode)
          || !
#line 30964 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
        return -1;
      return 10257; /* *movp2hi_internal */

    default:
      return -1;
    }
}

 int
recog_29 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (GET_MODE (x3) != E_SFmode)
        return -1;
      if (nonimm_ssenomem_operand (operands[0], E_SFmode)
          && register_ssemem_operand (operands[1], E_DFmode)
          && 
#line 5542 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)))
        return 206; /* truncdfsf2 */
      if (!nonimmediate_operand (operands[0], E_SFmode)
          || !register_operand (operands[1], E_XFmode)
          || !
#line 5670 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
        return -1;
      return 207; /* truncxfsf2 */

    case E_DFmode:
      if (!nonimmediate_operand (operands[0], E_DFmode)
          || GET_MODE (x3) != E_DFmode
          || !register_operand (operands[1], E_XFmode)
          || !
#line 5670 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
        return -1;
      return 208; /* truncxfdf2 */

    case E_HFmode:
      if (!register_operand (operands[0], E_HFmode))
        return -1;
      switch (pattern425 (x3, 
E_HFmode))
        {
        case 0:
          if (!
#line 5711 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 209; /* *truncsfhf2 */

        case 1:
          if (!
#line 5711 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 210; /* *truncdfhf2 */

        default:
          return -1;
        }

    case E_BFmode:
      if (!register_operand (operands[0], E_BFmode)
          || GET_MODE (x3) != E_BFmode
          || !register_operand (operands[1], E_SFmode)
          || !
#line 5727 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE2 && !HONOR_NANS (BFmode) && !flag_rounding_math
   && (flag_unsafe_math_optimizations
       || TARGET_AVXNECONVERT
       || (TARGET_AVX512BF16 && TARGET_AVX512VL))))
        return -1;
      return 211; /* truncsfbf2 */

    case E_V2SFmode:
      if (!register_operand (operands[0], E_V2SFmode)
          || GET_MODE (x3) != E_V2SFmode
          || !vector_operand (operands[1], E_V2DFmode)
          || !
#line 10138 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_MMX_WITH_SSE))
        return -1;
      return 5088; /* truncv2dfv2sf2 */

    default:
      return -1;
    }
}

 int
recog_34 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (pattern82 (x1, pnum_clobbers))
    {
    case 0:
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          x2 = XEXP (x1, 1);
          if (pattern73 (x2, pnum_clobbers) != 0
              || !(
#line 12515 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 704; /* *andti3_doubleword */

        case E_HImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_HImode) != 0)
            return -1;
          if (
#line 12685 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, HImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 719; /* *andhi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 12685 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, HImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 720; /* *andhi_1 */

        case E_QImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_QImode) != 0)
            return -1;
          if (
#line 12723 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, QImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 723; /* *andqi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 12723 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, QImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 724; /* *andqi_1 */

        case E_V2SFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2SFmode) != 0
              || !
#line 1357 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
            return -1;
          return 2077; /* andv2sf3 */

        case E_V2BFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2BFmode) != 0
              || !
#line 2582 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
            return -1;
          return 2111; /* andv2bf3 */

        case E_V4BFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V4BFmode) != 0
              || !(
#line 2582 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2224 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return -1;
          return 2114; /* andv4bf3 */

        case E_V2HFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2HFmode) != 0
              || !
#line 2582 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
            return -1;
          return 2117; /* andv2hf3 */

        case E_V4HFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V4HFmode) != 0
              || !(
#line 2582 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2225 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return -1;
          return 2120; /* andv4hf3 */

        case E_V8QImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V8QImode) != 0
              || !
#line 4687 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (AND, V8QImode, operands)))
            return -1;
          return 2274; /* *mmx_andv8qi3 */

        case E_V4HImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V4HImode) != 0
              || !
#line 4687 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (AND, V4HImode, operands)))
            return -1;
          return 2277; /* *mmx_andv4hi3 */

        case E_V2SImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V2SImode) != 0
              || !
#line 4687 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (AND, V2SImode, operands)))
            return -1;
          return 2280; /* *mmx_andv2si3 */

        case E_V4QImode:
          x2 = XEXP (x1, 1);
          if (pattern75 (x2, pnum_clobbers, 
E_V4QImode) != 0
              || !
#line 4713 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V4QImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 2283; /* *andv4qi3 */

        case E_V2QImode:
          x2 = XEXP (x1, 1);
          if (pattern75 (x2, pnum_clobbers, 
E_V2QImode) != 0
              || !
#line 4713 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V2QImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 2286; /* *andv2qi3 */

        case E_V2HImode:
          x2 = XEXP (x1, 1);
          if (pattern75 (x2, pnum_clobbers, 
E_V2HImode) != 0
              || !
#line 4713 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V2HImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 2289; /* *andv2hi3 */

        case E_BFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_BFmode) != 0
              || !
#line 5666 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3745; /* andbf3 */

        case E_HFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_HFmode) != 0
              || !
#line 5666 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3748; /* andhf3 */

        case E_SFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_SFmode) != 0
              || !
#line 5666 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3751; /* andsf3 */

        case E_DFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_DFmode) != 0
              || !(
#line 5666 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1352 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE2)))
            return -1;
          return 3754; /* anddf3 */

        case E_TFmode:
          x2 = XEXP (x1, 1);
          if (pattern25 (x2, 
E_TFmode) != 0
              || !
#line 5740 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 3757; /* *andtf3 */

        default:
          return -1;
        }

    case 1:
      if (!
#line 12755 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 725; /* *andqi_1_slp */

    case 2:
      if (!
#line 12755 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 728; /* *andhi_1_slp */

    default:
      return -1;
    }
}

 int
recog_41 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x3;
      x4 = XEXP (x2, 1);
      switch (GET_CODE (x4))
        {
        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          if (pnum_clobbers != NULL
              && GET_CODE (x4) == SUBREG
              && pattern423 (x1, 
E_TImode) == 0
              && (
#line 15217 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1053; /* *ashlti3_doubleword_mask */
            }
          operands[2] = x4;
          switch (pattern258 (x1, pnum_clobbers))
            {
            case 0:
              switch (GET_MODE (operands[0]))
                {
                case E_TImode:
                  if (pnum_clobbers == NULL
                      || !register_operand (operands[0], E_TImode)
                      || GET_MODE (x2) != E_TImode
                      || !reg_or_pm1_operand (operands[1], E_TImode)
                      || !nonmemory_operand (operands[2], E_QImode)
                      || !
#line 1196 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1057; /* ashlti3_doubleword */

                case E_HImode:
                  if (pattern619 (x2, 
E_HImode) != 0)
                    return -1;
                  if (
#line 16109 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, HImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
                    return 1104; /* *ashlhi3_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 16109 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, HImode, operands, TARGET_APX_NDD)
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1105; /* *ashlhi3_1 */

                case E_QImode:
                  if (pattern619 (x2, 
E_QImode) != 0)
                    return -1;
                  if (
#line 16168 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, QImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
                    return 1106; /* *ashlqi3_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 16168 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, QImode, operands, TARGET_APX_NDD)
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1107; /* *ashlqi3_1 */

                case E_V4HImode:
                  if (pattern734 (x2, 
E_V4HImode, 
E_DImode) != 0
                      || !
#line 3891 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return -1;
                  return 2202; /* mmx_ashlv4hi3 */

                case E_V2SImode:
                  if (pattern734 (x2, 
E_V2SImode, 
E_DImode) != 0
                      || !
#line 3891 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return -1;
                  return 2204; /* mmx_ashlv2si3 */

                case E_V1DImode:
                  if (pattern734 (x2, 
E_V1DImode, 
E_DImode) != 0
                      || !
#line 3891 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return -1;
                  return 2206; /* mmx_ashlv1di3 */

                case E_V1SImode:
                  if (pattern734 (x2, 
E_V1SImode, 
E_DImode) != 0
                      || !
#line 3928 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2208; /* mmx_ashlv1si3 */

                case E_V2HImode:
                  if (pattern734 (x2, 
E_V2HImode, 
E_DImode) != 0
                      || !
#line 3945 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2210; /* ashlv2hi3 */

                case E_V2QImode:
                  if (pnum_clobbers == NULL
                      || pattern734 (x2, 
E_V2QImode, 
E_QImode) != 0
                      || !
#line 4007 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size))
                    return -1;
                  *pnum_clobbers = 1;
                  return 2214; /* ashlv2qi3 */

                default:
                  return -1;
                }

            case 1:
              if (!
#line 16247 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 1108; /* *ashlqi3_1_slp */

            case 2:
              if (!
#line 16247 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 1109; /* *ashlhi3_1_slp */

            default:
              return -1;
            }

        case AND:
          if (pattern0 (x1, pnum_clobbers) != 0
              || !(
#line 15278 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1055; /* *ashlti3_doubleword_mask_1 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      if (pattern42 (x1, pnum_clobbers) != 0
          || !(
#line 15379 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 8 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 8 * BITS_PER_UNIT * 2) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1060; /* *ashlti3_doubleword_highpart */

    case ZERO_EXTEND:
      if (pattern42 (x1, pnum_clobbers) != 0
          || !(
#line 15379 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 8 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 8 * BITS_PER_UNIT * 2) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1061; /* *ashlti3_doubleword_highpart */

    default:
      return -1;
    }
}

 int
recog_47 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  switch (GET_CODE (x3))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
      res = recog_46 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    default:
      break;
    }
  operands[3] = x3;
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (pattern740 (
E_SFmode) != 0
          || !
#line 19708 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode)))
        return -1;
      return 1455; /* setcc_sf_sse */

    case E_DFmode:
      if (pattern740 (
E_DFmode) != 0
          || !
#line 19708 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode)))
        return -1;
      return 1456; /* setcc_df_sse */

    default:
      return -1;
    }
}

 int
recog_51 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (pattern82 (x1, pnum_clobbers))
    {
    case 0:
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          x2 = XEXP (x1, 1);
          if (pattern73 (x2, pnum_clobbers) != 0
              || !(
#line 6477 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 267; /* *addti3_doubleword */

        case E_HImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_HImode) != 0)
            return -1;
          if (
#line 6825 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
  && TARGET_APX_NF))
            return 297; /* *addhi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 6825 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          *pnum_clobbers = 1;
          return 298; /* *addhi_1 */

        case E_QImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_QImode) != 0)
            return -1;
          if (
#line 6882 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
  && TARGET_APX_NF))
            return 299; /* *addqi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 6882 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          *pnum_clobbers = 1;
          return 300; /* *addqi_1 */

        case E_HFmode:
          x2 = XEXP (x1, 1);
          if (pattern5 (x2, 
E_HFmode) != 0
              || !
#line 23483 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 1676; /* *addhf */

        case E_V8QImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V8QImode) != 0
              || !
#line 3211 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V8QImode, operands)))
            return -1;
          return 2124; /* *mmx_addv8qi3 */

        case E_V4HImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V4HImode) != 0
              || !
#line 3211 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V4HImode, operands)))
            return -1;
          return 2126; /* *mmx_addv4hi3 */

        case E_V2SImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V2SImode) != 0
              || !
#line 3211 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V2SImode, operands)))
            return -1;
          return 2128; /* *mmx_addv2si3 */

        case E_V1DImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V1DImode) != 0
              || !(
#line 3211 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V1DImode, operands)) && 
#line 50 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2)))
            return -1;
          return 2130; /* *mmx_addv1di3 */

        case E_V4QImode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V4QImode) != 0
              || !
#line 3227 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2132; /* addv4qi3 */

        case E_V2HImode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2HImode) != 0
              || !
#line 3227 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2134; /* addv2hi3 */

        case E_V2QImode:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2QImode) != 0
              || !
#line 3241 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size || TARGET_SSE2))
            return -1;
          *pnum_clobbers = 1;
          return 2136; /* addv2qi3 */

        default:
          return -1;
        }

    case 1:
      if (!
#line 6958 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 301; /* *addqi_1_slp */

    case 2:
      if (!
#line 6958 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 302; /* *addhi_1_slp */

    default:
      return -1;
    }
}

 int
recog_59 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      if (pattern95 (x3, 
E_V2SFmode, 
E_SFmode) != 0)
        return -1;
      x5 = XEXP (x3, 1);
      x6 = XEXP (x5, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!nonimmediate_operand (operands[2], E_V2SFmode)
          || pattern1832 (x3) != 0
          || !
#line 995 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW
   && INTVAL (operands[3]) != INTVAL (operands[4])
   && INTVAL (operands[5]) != INTVAL (operands[6])))
        return -1;
      return 2064; /* *mmx_haddv2sf3 */

    case MINUS:
      if (pattern96 (x4, 
E_SFmode) != 0
          || !register_operand (operands[0], E_V2SFmode)
          || GET_MODE (x3) != E_V2SFmode)
        return -1;
      x8 = XEXP (x4, 0);
      x9 = XEXP (x8, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_V2SFmode))
        return -1;
      x5 = XEXP (x3, 1);
      if (GET_MODE (x5) != E_SFmode)
        return -1;
      x10 = XEXP (x4, 1);
      x11 = XEXP (x10, 0);
      if (!rtx_equal_p (x11, operands[1]))
        return -1;
      switch (GET_CODE (x5))
        {
        case MINUS:
          if (pattern1536 (x5, 
E_SFmode) != 0)
            return -1;
          x6 = XEXP (x5, 0);
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          if (!nonimmediate_operand (operands[2], E_V2SFmode))
            return -1;
          x12 = XEXP (x5, 1);
          x13 = XEXP (x12, 0);
          if (!rtx_equal_p (x13, operands[2])
              || !
#line 1043 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW_A))
            return -1;
          return 2066; /* mmx_hsubv2sf3 */

        case PLUS:
          x6 = XEXP (x5, 0);
          if (GET_CODE (x6) != VEC_SELECT
              || GET_MODE (x6) != E_SFmode)
            return -1;
          x14 = XEXP (x6, 1);
          if (GET_CODE (x14) != PARALLEL
              || XVECLEN (x14, 0) != 1)
            return -1;
          x12 = XEXP (x5, 1);
          if (GET_CODE (x12) != VEC_SELECT
              || GET_MODE (x12) != E_SFmode)
            return -1;
          x15 = XEXP (x12, 1);
          if (GET_CODE (x15) != PARALLEL
              || XVECLEN (x15, 0) != 1)
            return -1;
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          if (!nonimmediate_operand (operands[2], E_V2SFmode))
            return -1;
          x16 = XVECEXP (x14, 0, 0);
          operands[3] = x16;
          if (!const_0_to_1_operand (operands[3], E_SImode))
            return -1;
          x17 = XVECEXP (x15, 0, 0);
          operands[4] = x17;
          if (!const_0_to_1_operand (operands[4], E_SImode))
            return -1;
          x13 = XEXP (x12, 0);
          if (!rtx_equal_p (x13, operands[2])
              || !
#line 1105 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW_A
   && INTVAL (operands[3]) != INTVAL (operands[4])))
            return -1;
          return 2068; /* *mmx_haddsubv2sf3 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V2SFmode:
          if (!register_operand (operands[0], E_V2SFmode)
              || GET_MODE (x3) != E_V2SFmode
              || !nonimmediate_operand (operands[1], E_SFmode))
            return -1;
          if (nonimm_or_0_operand (operands[2], E_SFmode))
            {
              if (
#line 1755 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX && !TARGET_SSE))
                return 2092; /* *mmx_concatv2sf */
              if (
#line 11739 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return 5190; /* *vec_concatv2sf_sse4_1 */
            }
          if (!reg_or_0_operand (operands[2], E_SFmode)
              || !
#line 11803 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 5191; /* *vec_concatv2sf_sse */

        case E_V2SImode:
          if (!register_operand (operands[0], E_V2SImode)
              || GET_MODE (x3) != E_V2SImode
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          if (nonimm_or_0_operand (operands[2], E_SImode))
            {
              if (
#line 5701 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX && !TARGET_SSE))
                return 2348; /* *mmx_concatv2si */
              if (
#line 21493 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return 8406; /* *vec_concatv2si_sse4_1 */
            }
          if (!reg_or_0_operand (operands[2], E_SImode)
              || !
#line 21542 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !TARGET_SSE4_1))
            return -1;
          return 8407; /* *vec_concatv2si */

        default:
          return -1;
        }

    case SS_TRUNCATE:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != SS_TRUNCATE)
        return -1;
      switch (pattern272 (x3))
        {
        case 0:
          if (!
#line 4771 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2292; /* mmx_packsswb */

        case 1:
          if (!
#line 4812 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2294; /* mmx_packssdw */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_65 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case LSHIFTRT:
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case MULT:
          if (XWINT (x5, 0) != 16L)
            return -1;
          x7 = XEXP (x6, 0);
          switch (GET_CODE (x7))
            {
            case SIGN_EXTEND:
              switch (pattern744 (x3, 
SIGN_EXTEND))
                {
                case 0:
                  if (!
#line 3447 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (MULT, V4HImode, operands)))
                    return -1;
                  return 2161; /* *mmx_smulv4hi3_highpart */

                case 1:
                  if (!
#line 3516 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2163; /* smulv2hi3_highpart */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              switch (pattern744 (x3, 
ZERO_EXTEND))
                {
                case 0:
                  if (!
#line 3482 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && ix86_binary_operator_ok (MULT, V4HImode, operands)))
                    return -1;
                  return 2162; /* *mmx_umulv4hi3_highpart */

                case 1:
                  if (!
#line 3516 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2164; /* umulv2hi3_highpart */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case PLUS:
          x7 = XEXP (x6, 0);
          switch (GET_CODE (x7))
            {
            case MULT:
              if (GET_MODE (x7) != E_V4SImode)
                return -1;
              x8 = XEXP (x7, 0);
              if (GET_CODE (x8) != SIGN_EXTEND
                  || GET_MODE (x8) != E_V4SImode)
                return -1;
              x9 = XEXP (x7, 1);
              if (GET_CODE (x9) != SIGN_EXTEND
                  || GET_MODE (x9) != E_V4SImode)
                return -1;
              x10 = XEXP (x6, 1);
              if (GET_CODE (x10) != CONST_VECTOR
                  || XVECLEN (x10, 0) != 4
                  || GET_MODE (x10) != E_V4SImode)
                return -1;
              x11 = XVECEXP (x10, 0, 0);
              if (GET_CODE (x11) != CONST_INT
                  || XWINT (x11, 0) != 32768L)
                return -1;
              x12 = XVECEXP (x10, 0, 1);
              if (GET_CODE (x12) != CONST_INT
                  || XWINT (x12, 0) != 32768L)
                return -1;
              x13 = XVECEXP (x10, 0, 2);
              if (GET_CODE (x13) != CONST_INT
                  || XWINT (x13, 0) != 32768L)
                return -1;
              x14 = XVECEXP (x10, 0, 3);
              if (GET_CODE (x14) != CONST_INT
                  || XWINT (x14, 0) != 32768L
                  || XWINT (x5, 0) != 16L
                  || !register_operand (operands[0], E_V4HImode)
                  || GET_MODE (x3) != E_V4HImode
                  || GET_MODE (x4) != E_V4SImode
                  || GET_MODE (x6) != E_V4SImode)
                return -1;
              x15 = XEXP (x8, 0);
              operands[1] = x15;
              if (!nonimmediate_operand (operands[1], E_V4HImode))
                return -1;
              x16 = XEXP (x9, 0);
              operands[2] = x16;
              if (!nonimmediate_operand (operands[2], E_V4HImode)
                  || !
#line 3605 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (MULT, V4HImode, operands)))
                return -1;
              return 2166; /* *mmx_pmulhrwv4hi3 */

            case PLUS:
              x8 = XEXP (x7, 0);
              if (GET_CODE (x8) != ZERO_EXTEND)
                return -1;
              x9 = XEXP (x7, 1);
              if (GET_CODE (x9) != ZERO_EXTEND)
                return -1;
              x10 = XEXP (x6, 1);
              if (GET_CODE (x10) != CONST_VECTOR
                  || XWINT (x5, 0) != 1L)
                return -1;
              x15 = XEXP (x8, 0);
              operands[1] = x15;
              x16 = XEXP (x9, 0);
              operands[2] = x16;
              switch (XVECLEN (x10, 0))
                {
                case 8:
                  if (pattern1346 (x10, 
E_V8HImode) != 0
                      || pattern1616 (x3, 
E_V8QImode, 
E_V8HImode) != 0
                      || !
#line 6332 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 2378; /* *mmx_uavgv8qi3 */

                case 4:
                  x11 = XVECEXP (x10, 0, 0);
                  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x12 = XVECEXP (x10, 0, 1);
                  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x13 = XVECEXP (x10, 0, 2);
                  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x14 = XVECEXP (x10, 0, 3);
                  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V4HImode:
                      if (pattern1616 (x3, 
E_V4HImode, 
E_V4SImode) != 0
                          || GET_MODE (x10) != E_V4SImode
                          || !
#line 6376 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                        return -1;
                      return 2379; /* *mmx_uavgv4hi3 */

                    case E_V4QImode:
                      if (pattern1519 (x3, 
E_V4HImode, 
E_V4QImode) != 0
                          || !
#line 6416 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                        return -1;
                      return 2380; /* uavgv4qi3_ceil */

                    default:
                      return -1;
                    }

                case 2:
                  x11 = XVECEXP (x10, 0, 0);
                  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x12 = XVECEXP (x10, 0, 1);
                  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V2QImode:
                      if (pattern1519 (x3, 
E_V2HImode, 
E_V2QImode) != 0
                          || !
#line 6436 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                        return -1;
                      return 2381; /* uavgv2qi3_ceil */

                    case E_V2HImode:
                      if (pattern1519 (x3, 
E_V2SImode, 
E_V2HImode) != 0
                          || !
#line 6456 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                        return -1;
                      return 2382; /* uavgv2hi3_ceil */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case LSHIFTRT:
              if (pattern612 (x7) != 0
                  || XWINT (x5, 0) != 1L)
                return -1;
              x8 = XEXP (x7, 0);
              x15 = XEXP (x8, 0);
              x17 = XEXP (x15, 0);
              operands[1] = x17;
              x18 = XEXP (x8, 1);
              x19 = XEXP (x18, 0);
              operands[2] = x19;
              x10 = XEXP (x6, 1);
              operands[3] = x10;
              switch (GET_MODE (operands[0]))
                {
                case E_V4HImode:
                  if (pattern1496 (x3, 
E_V4SImode, 
E_V4HImode) != 0
                      || !register_mmxmem_operand (operands[1], E_V4HImode)
                      || GET_MODE (x18) != E_V4SImode
                      || !register_mmxmem_operand (operands[2], E_V4HImode)
                      || !const1_operand (operands[3], E_V4HImode)
                      || !
#line 23058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_SSSE3
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8549; /* *ssse3_pmulhrswv4hi3 */

                case E_V2HImode:
                  if (pattern1496 (x3, 
E_V2SImode, 
E_V2HImode) != 0
                      || !register_operand (operands[1], E_V2HImode)
                      || GET_MODE (x18) != E_V2SImode
                      || !register_operand (operands[2], E_V2HImode)
                      || !const1_operand (operands[3], E_V2HImode)
                      || !
#line 23103 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8550; /* *smulhrsv2hi3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V4QImode:
          if (GET_MODE (x3) != E_V4QImode)
            return -1;
          if (register_operand (operands[0], E_V4QImode)
              && register_operand (operands[1], E_V4HImode)
              && (
#line 5144 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_AVX512BW) && 
#line 73 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return 2312; /* avx512vl_truncv4hiv4qi2 */
          if (!memory_operand (operands[0], E_V4QImode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!register_operand (operands[1], E_V4SImode)
                  || !
#line 15481 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7238; /* *avx512vl_truncatev4siv4qi2_store_1 */

            case E_V4DImode:
              if (!register_operand (operands[1], E_V4DImode)
                  || !
#line 15481 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7241; /* *avx512vl_truncatev4div4qi2_store_1 */

            default:
              return -1;
            }

        case E_V2QImode:
          if (GET_MODE (x3) != E_V2QImode)
            return -1;
          if (register_operand (operands[0], E_V2QImode))
            {
              switch (GET_MODE (operands[1]))
                {
                case E_V2HImode:
                  if (register_operand (operands[1], E_V2HImode)
                      && 
#line 5144 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_AVX512BW))
                    return 2313; /* avx512vl_truncv2hiv2qi2 */
                  break;

                case E_V2SImode:
                  if (register_operand (operands[1], E_V2SImode)
                      && 
#line 5170 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_MMX_WITH_SSE))
                    return 2314; /* avx512vl_truncv2siv2qi2 */
                  break;

                default:
                  break;
                }
            }
          if (!memory_operand (operands[0], E_V2QImode)
              || !register_operand (operands[1], E_V2DImode)
              || !
#line 15386 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7223; /* *avx512vl_truncatev2div2qi2_store_1 */

        case E_V2HImode:
          if (GET_MODE (x3) != E_V2HImode)
            return -1;
          if (register_operand (operands[0], E_V2HImode)
              && register_operand (operands[1], E_V2SImode)
              && 
#line 5170 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_MMX_WITH_SSE))
            return 2315; /* avx512vl_truncv2siv2hi2 */
          if (!memory_operand (operands[0], E_V2HImode)
              || !register_operand (operands[1], E_V2DImode)
              || !
#line 15832 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7338; /* *avx512vl_truncatev2div2hi2_store_1 */

        case E_V8QImode:
          switch (pattern12 (x3))
            {
            case 0:
              if (!(
#line 15579 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return -1;
              return 7268; /* *avx512vl_truncatev8hiv8qi2_store_1 */

            case 1:
              if (!
#line 15579 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7271; /* *avx512vl_truncatev8siv8qi2_store_1 */

            case 2:
              if (!
#line 16095 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                return -1;
              return 7375; /* *avx512f_truncatev8div16qi2_store_1 */

            default:
              return -1;
            }

        case E_V4HImode:
          switch (pattern11 (x3, 
E_V4HImode))
            {
            case 0:
              if (!
#line 15741 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7308; /* *avx512vl_truncatev4siv4hi2_store_1 */

            case 1:
              if (!
#line 15741 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7311; /* *avx512vl_truncatev4div4hi2_store_1 */

            default:
              return -1;
            }

        case E_V2SImode:
          if (!memory_operand (operands[0], E_V2SImode)
              || GET_MODE (x3) != E_V2SImode
              || !register_operand (operands[1], E_V2DImode)
              || !
#line 15982 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7357; /* *avx512vl_truncatev2div2si2_store_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_75 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      return recog_70 (x1, insn, pnum_clobbers);

    case MINUS:
      return recog_72 (x1, insn, pnum_clobbers);

    case MULT:
      return recog_74 (x1, insn, pnum_clobbers);

    case SMUL_HIGHPART:
      if (pattern106 (x3, pnum_clobbers) != 0
          || !
#line 11162 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 2;
      return 631; /* *smulsi3_highpart_zext */

    case UMUL_HIGHPART:
      if (pattern106 (x3, pnum_clobbers) != 0
          || !
#line 11162 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 2;
      return 632; /* *umulsi3_highpart_zext */

    case TRUNCATE:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_SImode)
        return -1;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != LSHIFTRT
          || GET_MODE (x5) != E_DImode)
        return -1;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != MULT
          || GET_MODE (x6) != E_DImode)
        return -1;
      x7 = XEXP (x5, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 32]
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x8 = XEXP (x6, 0);
      if (GET_MODE (x8) != E_DImode)
        return -1;
      x9 = XEXP (x6, 1);
      if (GET_MODE (x9) != E_DImode)
        return -1;
      switch (GET_CODE (x8))
        {
        case SIGN_EXTEND:
          if (GET_CODE (x9) != SIGN_EXTEND)
            return -1;
          x10 = XEXP (x8, 0);
          operands[1] = x10;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x11 = XEXP (x9, 0);
          operands[2] = x11;
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !
#line 11210 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 635; /* *smulsi3_highpart_zext */

        case ZERO_EXTEND:
          if (GET_CODE (x9) != ZERO_EXTEND)
            return -1;
          x10 = XEXP (x8, 0);
          operands[1] = x10;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x11 = XEXP (x9, 0);
          operands[2] = x11;
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !
#line 11210 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 636; /* *umulsi3_highpart_zext */

        default:
          return -1;
        }

    case AND:
      return recog_71 (x1, insn, pnum_clobbers);

    case IOR:
      switch (pattern108 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 847; /* *iorqi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 848; /* *iorqi_1_zextsi */

        case 1:
          if (
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 855; /* *iorhi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 856; /* *iorhi_1_zextsi */

        case 2:
          if (
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 851; /* *iorqi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 852; /* *iorqi_1_zextdi */

        case 3:
          if (
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 859; /* *iorhi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 860; /* *iorhi_1_zextdi */

        case 4:
          if (!
#line 13759 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (IOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 863; /* *iorsi_1_zext */

        default:
          return -1;
        }

    case XOR:
      switch (pattern108 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 849; /* *xorqi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 850; /* *xorqi_1_zextsi */

        case 1:
          if (
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 857; /* *xorhi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 858; /* *xorhi_1_zextsi */

        case 2:
          if (
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 853; /* *xorqi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 854; /* *xorqi_1_zextdi */

        case 3:
          if (
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 861; /* *xorhi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 862; /* *xorhi_1_zextdi */

        case 4:
          if (!
#line 13759 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 864; /* *xorsi_1_zext */

        default:
          return -1;
        }

    case NEG:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern283 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 14374 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 964; /* *negqi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14374 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 965; /* *negqi_1_zextsi */

        case 1:
          if (
#line 14384 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 968; /* *neghi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14384 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 969; /* *neghi_1_zextsi */

        case 2:
          if (
#line 14374 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 966; /* *negqi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14374 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 967; /* *negqi_1_zextdi */

        case 3:
          if (
#line 14384 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 970; /* *neghi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14384 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 971; /* *neghi_1_zextdi */

        case 4:
          if (!
#line 14395 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_unary_operator_ok (NEG, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 972; /* *negsi_1_zext */

        default:
          return -1;
        }

    case NOT:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          switch (pattern282 (x3))
            {
            case 0:
              if (!
#line 15016 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1036; /* *one_cmplqi2_1_zextsi */

            case 1:
              if (!
#line 15025 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1038; /* *one_cmplhi2_1_zextsi */

            default:
              return -1;
            }

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !
#line 15016 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1037; /* *one_cmplqi2_1_zextdi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 15025 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1039; /* *one_cmplhi2_1_zextdi */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 15034 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_unary_operator_ok (NOT, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1040; /* *one_cmplsi2_1_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ASHIFT:
      switch (pattern109 (x3))
        {
        case 0:
          if (register_operand (operands[2], E_SImode)
              && 
#line 16012 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
            return 1092; /* *bmi2_ashlsi3_1_zext */
          if (pnum_clobbers == NULL
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 16045 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 1103; /* *ashlsi3_1_zext */

        case 1:
          if (
#line 16022 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1097; /* *ashlqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16022 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1098; /* *ashlqi3_1_zextdi */

        case 2:
          if (
#line 16033 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1101; /* *ashlhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16033 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1102; /* *ashlhi3_1_zextdi */

        case 3:
          if (
#line 16022 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1095; /* *ashlqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16022 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1096; /* *ashlqi3_1_zextsi */

        case 4:
          if (
#line 16033 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1099; /* *ashlhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16033 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1100; /* *ashlhi3_1_zextsi */

        default:
          return -1;
        }

    case ASHIFTRT:
      if (GET_MODE (x4) == E_SImode
          && register_operand (operands[0], E_DImode))
        {
          res = recog_68 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
        }
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern284 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1192; /* *ashrqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1193; /* *ashrqi3_1_zextsi */

        case 1:
          if (
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1200; /* *ashrhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1201; /* *ashrhi3_1_zextsi */

        case 2:
          if (
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1196; /* *ashrqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1197; /* *ashrqi3_1_zextdi */

        case 3:
          if (
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1204; /* *ashrhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1205; /* *ashrhi3_1_zextdi */

        case 4:
          if (!
#line 17492 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 1207; /* *ashrsi3_1_zext */

        default:
          return -1;
        }

    case LSHIFTRT:
      switch (pattern109 (x3))
        {
        case 0:
          if (register_operand (operands[2], E_SImode)
              && 
#line 17459 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
            return 1184; /* *bmi2_lshrsi3_1_zext */
          if (pnum_clobbers == NULL
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 17492 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (LSHIFTRT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 1206; /* *lshrsi3_1_zext */

        case 1:
          if (
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1194; /* *lshrqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1195; /* *lshrqi3_1_zextdi */

        case 2:
          if (
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1202; /* *lshrhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1203; /* *lshrhi3_1_zextdi */

        case 3:
          if (
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1190; /* *lshrqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1191; /* *lshrqi3_1_zextsi */

        case 4:
          if (
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1198; /* *lshrhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1199; /* *lshrhi3_1_zextsi */

        default:
          return -1;
        }

    case ROTATERT:
      switch (pattern109 (x3))
        {
        case 0:
          if (const_0_to_31_operand (operands[2], E_QImode)
              && 
#line 18592 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && !optimize_function_for_size_p (cfun)))
            return 1350; /* *bmi2_rorxsi3_1_zext */
          if (pnum_clobbers == NULL
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 18625 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATERT, SImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 1372; /* *rotrsi3_1_zext */

        case 1:
          if (
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1361; /* *rotrqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1362; /* *rotrqi3_1_zextdi */

        case 2:
          if (
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1369; /* *rotrhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1370; /* *rotrhi3_1_zextdi */

        case 3:
          if (
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1357; /* *rotrqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1358; /* *rotrqi3_1_zextsi */

        case 4:
          if (
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1365; /* *rotrhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1366; /* *rotrhi3_1_zextsi */

        default:
          return -1;
        }

    case ROTATE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern284 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1355; /* *rotlqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1356; /* *rotlqi3_1_zextsi */

        case 1:
          if (
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1363; /* *rotlhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1364; /* *rotlhi3_1_zextsi */

        case 2:
          if (
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1359; /* *rotlqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1360; /* *rotlqi3_1_zextdi */

        case 3:
          if (
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1367; /* *rotlhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1368; /* *rotlhi3_1_zextdi */

        case 4:
          if (!
#line 18625 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATE, SImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 1371; /* *rotlsi3_1_zext */

        default:
          return -1;
        }

    case CTZ:
      if (pattern110 (x3, pnum_clobbers, 
E_SImode, 
E_DImode) != 0
          || !
#line 21193 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 1521; /* *ctzsidi2_uext */

    case CLZ:
      if (pattern110 (x3, pnum_clobbers, 
E_SImode, 
E_DImode) != 0
          || !
#line 21628 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT && TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 1543; /* *clzsi2_lzcnt_zext_2 */

    case POPCOUNT:
      if (pnum_clobbers == NULL)
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern613 (x3, 
E_DImode, 
E_SImode) != 0
              || !
#line 22465 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1634; /* *popcountsi2_zext_2 */

        case E_SImode:
          if (pattern613 (x3, 
E_SImode, 
E_HImode) != 0
              || !
#line 22531 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1637; /* *popcounthi2_2 */

        default:
          return -1;
        }

    case UNSPEC:
      return recog_69 (x1, insn, pnum_clobbers);

    case IF_THEN_ELSE:
      if (GET_MODE (x4) != E_SImode)
        return -1;
      x5 = XEXP (x4, 0);
      if (!ix86_comparison_operator (x5, E_VOIDmode))
        return -1;
      operands[1] = x5;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != REG
          || REGNO (x6) != 17)
        return -1;
      x7 = XEXP (x5, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || !nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x12 = XEXP (x4, 1);
      operands[2] = x12;
      if (!nonimmediate_operand (operands[2], E_SImode))
        return -1;
      x13 = XEXP (x4, 2);
      operands[3] = x13;
      if (!nonimmediate_operand (operands[3], E_SImode)
          || !
#line 26393 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && TARGET_CMOVE && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
        return -1;
      return 1807; /* *movsicc_noc_zext_1 */

    case VEC_SELECT:
      return recog_73 (x1, insn, pnum_clobbers);

    case SUBREG:
      if (pattern111 (x3) != 0
          || !
#line 22139 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
        return -1;
      return 8488; /* *sse2_pmovskb_zexthisi */

    default:
      return -1;
    }
}

 int
recog_102 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (pattern20 (x1, pnum_clobbers))
    {
    case 0:
      if (!
#line 18204 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1297; /* *rotrsi3_mask_1 */

    case 1:
      if (!(
#line 18204 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1299; /* *rotrdi3_mask_1 */

    case 2:
      if (!
#line 18285 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1313; /* *rotrsi3_add_1 */

    case 3:
      if (!(
#line 18285 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1315; /* *rotrdi3_add_1 */

    case 4:
      if (!
#line 18354 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1329; /* *rotrsi3_sub_1 */

    case 5:
      if (!(
#line 18354 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1331; /* *rotrdi3_sub_1 */

    case 6:
      x2 = XEXP (x1, 1);
      x3 = XEXP (x2, 1);
      switch (GET_CODE (x3))
        {
        case SUBREG:
          switch (pattern450 (x2, pnum_clobbers))
            {
            case 0:
              if (
#line 18156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                {
                  *pnum_clobbers = 1;
                  return 1289; /* *rotrsi3_mask */
                }
              break;

            case 1:
              if ((
#line 18156 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 1291; /* *rotrdi3_mask */
                }
              break;

            case 2:
              if (
#line 18249 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                {
                  *pnum_clobbers = 1;
                  return 1305; /* *rotrsi3_add */
                }
              break;

            case 3:
              if ((
#line 18249 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 1307; /* *rotrdi3_add */
                }
              break;

            case 4:
              if (
#line 18318 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                {
                  *pnum_clobbers = 1;
                  return 1321; /* *rotrsi3_sub */
                }
              break;

            case 5:
              if ((
#line 18318 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 1323; /* *rotrdi3_sub */
                }
              break;

            default:
              break;
            }
          break;

        case CONST_INT:
          operands[2] = x3;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (pattern609 (x2, pnum_clobbers, 
E_DImode) == 0
                  && const_1_to_31_operand (operands[2], E_QImode)
                  && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                {
                  *pnum_clobbers = 2;
                  return 1334; /* ix86_rotrdi3_doubleword */
                }
              break;

            case E_SImode:
              if (register_operand (operands[0], E_SImode)
                  && GET_MODE (x2) == E_SImode
                  && nonimmediate_operand (operands[1], E_SImode)
                  && const_0_to_31_operand (operands[2], E_QImode)
                  && 
#line 18500 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && !optimize_function_for_size_p (cfun)))
                return 1340; /* *bmi2_rorxsi3_1 */
              break;

            default:
              break;
            }
          if (register_operand (operands[0], E_DImode)
              && GET_MODE (x2) == E_DImode)
            {
              if (XWINT (x3, 0) == 32L
                  && register_operand (operands[1], E_DImode)
                  && 
#line 18459 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return 1337; /* rotr32di2_doubleword */
              if (nonimmediate_operand (operands[1], E_DImode))
                {
                  operands[2] = x3;
                  if (const_0_to_63_operand (operands[2], E_QImode)
                      && (
#line 18500 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && !optimize_function_for_size_p (cfun)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1341; /* *bmi2_rorxdi3_1 */
                }
            }
          break;

        default:
          break;
        }
      operands[2] = x3;
      if (!nonmemory_operand (operands[2], E_QImode))
        return -1;
      switch (pattern16 (x2))
        {
        case 0:
          if (
#line 18510 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 1344; /* *rotrsi3_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 18510 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 1345; /* *rotrsi3_1 */

        case 1:
          if ((
#line 18510 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1348; /* *rotrdi3_1_nf */
          if (pnum_clobbers == NULL
              || !(
#line 18510 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1349; /* *rotrdi3_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_114 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (pattern126 (x3))
        {
        case 0:
          if (
#line 22318 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_POPCNT))
            return 1624; /* popcountsi2_nf */
          if (pnum_clobbers == NULL
              || !
#line 22343 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT))
            return -1;
          *pnum_clobbers = 1;
          return 1626; /* popcountsi2 */

        case 1:
          if ((
#line 22318 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_POPCNT) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1625; /* popcountdi2_nf */
          if (pnum_clobbers == NULL
              || !(
#line 22343 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1627; /* popcountdi2 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      if (pattern110 (x3, pnum_clobbers, 
E_HImode, 
E_SImode) != 0
          || !
#line 22513 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1636; /* *popcounthi2_1 */

    default:
      return -1;
    }
}

 int
recog_117 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  switch (XWINT (x4, 0))
    {
    case 0L:
      if (nonimmediate_operand (operands[0], E_SImode)
          && GET_MODE (x2) == E_SImode)
        {
          switch (GET_MODE (operands[1]))
            {
            case E_V2SImode:
              if (nonimmediate_operand (operands[1], E_V2SImode)
                  && 
#line 5729 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
                return 2349; /* *vec_extractv2si_0 */
              break;

            case E_V4SImode:
              if (nonimmediate_operand (operands[1], E_V4SImode)
                  && 
#line 21145 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
                return 8394; /* *vec_extractv4si_0 */
              break;

            default:
              break;
            }
        }
      break;

    case 1L:
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (nonimmediate_operand (operands[0], E_SImode)
              && GET_MODE (x2) == E_SImode
              && nonimmediate_operand (operands[1], E_V2SImode)
              && 
#line 5786 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
            return 2352; /* *vec_extractv2si_1 */
          break;

        case E_DImode:
          if (nonimmediate_operand (operands[0], E_DImode)
              && GET_MODE (x2) == E_DImode
              && nonimmediate_operand (operands[1], E_V2DImode)
              && 
#line 21314 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
            return 8403; /* *vec_extractv2di_1 */
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (GET_MODE (x2) != E_SImode)
        return -1;
      if (register_operand (operands[0], E_SImode))
        {
          switch (GET_MODE (operands[1]))
            {
            case E_V16SImode:
              if (register_operand (operands[1], E_V16SImode)
                  && const_0_to_15_operand (operands[2], E_VOIDmode)
                  && (
#line 14058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && INTVAL(operands[2]) * GET_MODE_SIZE (SImode) >= 16) && 
#line 300 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 7006; /* *vec_extractv16sisi_valign */
              break;

            case E_V8SImode:
              if (register_operand (operands[1], E_V8SImode)
                  && const_0_to_7_operand (operands[2], E_VOIDmode)
                  && (
#line 14058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && INTVAL(operands[2]) * GET_MODE_SIZE (SImode) >= 16) && 
#line 300 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 7007; /* *vec_extractv8sisi_valign */
              break;

            default:
              break;
            }
        }
      if (nonimmediate_operand (operands[0], E_SImode)
          && register_operand (operands[1], E_V4SImode)
          && const_0_to_3_operand (operands[2], E_SImode)
          && 
#line 21235 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
        return 8399; /* *vec_extractv4si */
      if (!register_operand (operands[0], E_SImode)
          || !memory_operand (operands[1], E_V4SImode)
          || !const_0_to_3_operand (operands[2], E_VOIDmode)
          || !
#line 21292 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
        return -1;
      return 8401; /* *vec_extractv4si_mem */

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x2) != E_DImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8DImode:
          if (!register_operand (operands[1], E_V8DImode)
              || !const_0_to_7_operand (operands[2], E_VOIDmode)
              || !(
#line 14058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && INTVAL(operands[2]) * GET_MODE_SIZE (DImode) >= 16) && 
#line 301 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7008; /* *vec_extractv8didi_valign */

        case E_V4DImode:
          if (!register_operand (operands[1], E_V4DImode)
              || !const_0_to_3_operand (operands[2], E_VOIDmode)
              || !(
#line 14058 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && INTVAL(operands[2]) * GET_MODE_SIZE (DImode) >= 16) && 
#line 301 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7009; /* *vec_extractv4didi_valign */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_122 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XEXP (x2, 2);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      if (pattern628 (x2, 
E_V8HImode, 
E_QImode, 
E_V8HFmode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4500; /* unspec_avx512fp16_fixuns_truncv8hi2_mask */

    case E_V16HImode:
      if (pattern628 (x2, 
E_V16HImode, 
E_HImode, 
E_V16HFmode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4508; /* unspec_avx512fp16_fixuns_truncv16hi2_mask */

    case E_V32HImode:
      if (pattern628 (x2, 
E_V32HImode, 
E_SImode, 
E_V32HFmode) != 0
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4516; /* unspec_avx512fp16_fixuns_truncv32hi2_mask */

    case E_V8SImode:
      if (pattern136 (x2, 
E_V8SImode, 
E_QImode) != 0)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4524; /* unspec_avx512fp16_fixuns_truncv8si2_mask */

        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9547 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 4955; /* unspec_fixuns_truncv8dfv8si2_mask */

        case E_V8SFmode:
          if (!nonimmediate_operand (operands[1], E_V8SFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9890 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 440 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 5059; /* unspec_fixuns_truncv8sfv8si2_mask */

        default:
          return -1;
        }

    case E_V16SImode:
      switch (pattern982 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4532; /* unspec_avx512fp16_fixuns_truncv16si2_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8754 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 4806; /* unspec_fixuns_truncv16sfv16si2_mask */

        default:
          return -1;
        }

    case E_V8DImode:
      switch (pattern983 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4540; /* unspec_avx512fp16_fixuns_truncv8di2_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4984; /* unspec_fixuns_truncv8dfv8di2_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9719 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 5032; /* unspec_fixuns_truncv8sfv8di2_mask */

        default:
          return -1;
        }

    case E_V4SImode:
      if (pattern136 (x2, 
E_V4SImode, 
E_QImode) != 0)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!register_operand (operands[1], E_V8HFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7897 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4593; /* unspec_avx512fp16_fixuns_truncv4si2_mask */

        case E_V4DFmode:
          if (!nonimmediate_operand (operands[1], E_V4DFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9656 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512F)))
            return -1;
          return 4975; /* unspec_fixuns_truncv4dfv4si2_mask */

        case E_V4SFmode:
          if (!nonimmediate_operand (operands[1], E_V4SFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9890 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 5061; /* unspec_fixuns_truncv4sfv4si2_mask */

        default:
          return -1;
        }

    case E_V4DImode:
      switch (pattern984 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7897 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4597; /* unspec_avx512fp16_fixuns_truncv4di2_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4989; /* unspec_fixuns_truncv4dfv4di2_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9719 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 5037; /* unspec_fixuns_truncv4sfv4di2_mask */

        default:
          return -1;
        }

    case E_V2DImode:
      switch (pattern985 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7947 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4617; /* unspec_avx512fp16_fixuns_truncv2di2_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4993; /* unspec_fixuns_truncv2dfv2di2_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9740 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL)))
            return -1;
          return 5053; /* unspec_avx512dq_fixuns_truncv2sfv2di2_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_128 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 2);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
      operands[4] = x3;
      x4 = XEXP (x2, 0);
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      if (!const_0_to_255_operand (operands[2], E_SImode))
        return -1;
      x7 = XEXP (x2, 1);
      operands[3] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern468 (x2, 
E_V32HFmode, 
E_SImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
            return -1;
          return 7064; /* avx512bw_rndscalev32hf_mask */

        case E_V16HFmode:
          if (pattern468 (x2, 
E_V16HFmode, 
E_HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 7068; /* avx512vl_rndscalev16hf_mask */

        case E_V8HFmode:
          if (pattern468 (x2, 
E_V8HFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 7072; /* avx512fp16_rndscalev8hf_mask */

        case E_V16SFmode:
          if (pattern468 (x2, 
E_V16SFmode, 
E_HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7076; /* avx512f_rndscalev16sf_mask */

        case E_V8SFmode:
          if (pattern468 (x2, 
E_V8SFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7080; /* avx512vl_rndscalev8sf_mask */

        case E_V4SFmode:
          if (pattern468 (x2, 
E_V4SFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7084; /* avx512vl_rndscalev4sf_mask */

        case E_V8DFmode:
          if (pattern468 (x2, 
E_V8DFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 7088; /* avx512f_rndscalev8df_mask */

        case E_V4DFmode:
          if (pattern468 (x2, 
E_V4DFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7092; /* avx512vl_rndscalev4df_mask */

        case E_V2DFmode:
          if (pattern468 (x2, 
E_V2DFmode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14210 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 7096; /* avx512vl_rndscalev2df_mask */

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x3, 0) != 1L)
        return -1;
      x4 = XEXP (x2, 0);
      x5 = XVECEXP (x4, 0, 0);
      operands[2] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[3] = x6;
      x7 = XEXP (x2, 1);
      operands[1] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          if (pattern1198 (x2, 
E_V8HFmode) != 0)
            return -1;
          if (const_0_to_255_operand (operands[3], E_SImode)
              && (
#line 14225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return 7098; /* avx512f_rndscalev8hf */
          if (!const_0_to_15_operand (operands[3], E_SImode)
              || !(
#line 25576 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 8898; /* sse4_1_roundsh */

        case E_V4SFmode:
          if (pattern1198 (x2, 
E_V4SFmode) != 0)
            return -1;
          if (const_0_to_255_operand (operands[3], E_SImode)
              && 
#line 14225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 7102; /* avx512f_rndscalev4sf */
          if (!const_0_to_15_operand (operands[3], E_SImode)
              || !
#line 25576 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return -1;
          return 8899; /* sse4_1_roundss */

        case E_V2DFmode:
          if (pattern1198 (x2, 
E_V2DFmode) != 0)
            return -1;
          if (const_0_to_255_operand (operands[3], E_SImode)
              && (
#line 14225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return 7106; /* avx512f_rndscalev2df */
          if (!const_0_to_15_operand (operands[3], E_SImode)
              || !(
#line 25576 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 8900; /* sse4_1_roundsd */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_137 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  x7 = XEXP (x2, 2);
  if (!register_operand (x7, E_QImode))
    return -1;
  x8 = XEXP (x2, 1);
  switch (GET_CODE (x8))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x8;
      operands[5] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern1355 (x2, 
E_V16SFmode, 
E_V32BFmode) != 0
              || !(
#line 31209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 10278; /* avx512f_dpbf16ps_v16sf_maskz_1 */

        case E_V8SFmode:
          if (pattern1355 (x2, 
E_V8SFmode, 
E_V16BFmode) != 0
              || !(
#line 31209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10280; /* avx512f_dpbf16ps_v8sf_maskz_1 */

        case E_V4SFmode:
          if (pattern1355 (x2, 
E_V4SFmode, 
E_V8BFmode) != 0
              || !(
#line 31209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10282; /* avx512f_dpbf16ps_v4sf_maskz_1 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      if (!rtx_equal_p (x8, operands[1]))
        return -1;
      operands[4] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern1356 (x2, 
E_V32BFmode, 
E_V16SFmode) != 0
              || !(
#line 31222 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 10283; /* avx512f_dpbf16ps_v16sf_mask */

        case E_V8SFmode:
          if (pattern1356 (x2, 
E_V16BFmode, 
E_V8SFmode) != 0
              || !(
#line 31222 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10284; /* avx512f_dpbf16ps_v8sf_mask */

        case E_V4SFmode:
          if (pattern1356 (x2, 
E_V8BFmode, 
E_V4SFmode) != 0
              || !(
#line 31222 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10285; /* avx512f_dpbf16ps_v4sf_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_144 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  x4 = XEXP (x2, 0);
  switch (XINT (x4, 1))
    {
    case 177:
      return recog_120 (x1, insn, pnum_clobbers);

    case 54:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XEXP (x2, 2);
      switch (GET_CODE (x6))
        {
        case CONST_INT:
          switch (pattern875 (x2))
            {
            case 0:
              if (!
#line 2932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return -1;
              return 2877; /* sse_vmrcpv4sf2 */

            case 1:
              if (!
#line 2982 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 2885; /* avx512fp16_vmrcpv8hf2 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          operands[3] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern622 (x2, 
E_V32HFmode, 
E_SImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2969 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 2880; /* avx512fp16_rcpv32hf2_mask */

            case E_V16HFmode:
              if (pattern622 (x2, 
E_V16HFmode, 
E_HImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2969 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 2882; /* avx512fp16_rcpv16hf2_mask */

            case E_V8HFmode:
              if (pattern622 (x2, 
E_V8HFmode, 
E_QImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2969 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 2884; /* avx512fp16_rcpv8hf2_mask */

            case E_V32BFmode:
              if (pattern622 (x2, 
E_V32BFmode, 
E_SImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32417 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10615; /* avx10_2_rcpbf16_v32bf_mask */

            case E_V16BFmode:
              if (pattern622 (x2, 
E_V16BFmode, 
E_HImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32417 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10617; /* avx10_2_rcpbf16_v16bf_mask */

            case E_V8BFmode:
              if (pattern622 (x2, 
E_V8BFmode, 
E_QImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32417 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10619; /* avx10_2_rcpbf16_v8bf_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 161:
      switch (pattern624 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 2889; /* rcp14v16sf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 2891; /* rcp14v8sf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 2893; /* rcp14v4sf_mask */

        case 3:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 2895; /* rcp14v8df_mask */

        case 4:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 2897; /* rcp14v4df_mask */

        case 5:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 2899; /* rcp14v2df_mask */

        case 6:
          if (!
#line 3021 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 2900; /* srcp14v4sf */

        case 7:
          if (!(
#line 3021 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2901; /* srcp14v2df */

        default:
          return -1;
        }

    case 55:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XEXP (x2, 2);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[3] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_V32HFmode:
              if (pattern986 (x2, 
E_V32HFmode, 
E_SImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 2955; /* avx512fp16_rsqrtv32hf2_mask */

            case E_V16HFmode:
              if (pattern986 (x2, 
E_V16HFmode, 
E_HImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 2957; /* avx512fp16_rsqrtv16hf2_mask */

            case E_V8HFmode:
              if (pattern986 (x2, 
E_V8HFmode, 
E_QImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 2959; /* avx512fp16_rsqrtv8hf2_mask */

            case E_V32BFmode:
              if (pattern622 (x2, 
E_V32BFmode, 
E_SImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32400 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10603; /* avx10_2_rsqrtbf16_v32bf_mask */

            case E_V16BFmode:
              if (pattern622 (x2, 
E_V16BFmode, 
E_HImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32400 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10605; /* avx10_2_rsqrtbf16_v16bf_mask */

            case E_V8BFmode:
              if (pattern622 (x2, 
E_V8BFmode, 
E_QImode) != 0
                  || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32400 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10607; /* avx10_2_rsqrtbf16_v8bf_mask */

            default:
              return -1;
            }

        case CONST_INT:
          switch (pattern875 (x2))
            {
            case 0:
              if (!
#line 3205 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return -1;
              return 2976; /* sse_vmrsqrtv4sf2 */

            case 1:
              if (!
#line 3240 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 2978; /* avx512fp16_vmrsqrtv8hf2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 162:
      switch (pattern624 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 2961; /* rsqrt14v16sf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 2963; /* rsqrt14v8sf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 2965; /* rsqrt14v4sf_mask */

        case 3:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 2967; /* rsqrt14v8df_mask */

        case 4:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 2969; /* rsqrt14v4df_mask */

        case 5:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3161 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 2971; /* rsqrt14v2df_mask */

        case 6:
          if (!
#line 3175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 2972; /* rsqrt14v4sf */

        case 7:
          if (!(
#line 3175 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2973; /* rsqrt14v2df */

        default:
          return -1;
        }

    case 156:
      return recog_124 (x1, insn, pnum_clobbers);

    case 46:
      return recog_121 (x1, insn, pnum_clobbers);

    case 172:
      return recog_123 (x1, insn, pnum_clobbers);

    case 173:
      return recog_122 (x1, insn, pnum_clobbers);

    case 165:
      return recog_126 (x1, insn, pnum_clobbers);

    case 136:
      x6 = XEXP (x2, 2);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SFmode:
          if (pattern987 (x2, 
E_V4SFmode) != 0
              || !
#line 27021 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return -1;
          return 8986; /* *xop_vmfrczv4sf2 */

        case E_V2DFmode:
          if (pattern987 (x2, 
E_V2DFmode) != 0
              || !(
#line 27021 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP) && 
#line 474 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 8987; /* *xop_vmfrczv2df2 */

        default:
          return -1;
        }

    case 149:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XEXP (x2, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SFmode:
          if (!register_operand (operands[0], E_V4SFmode)
              || GET_MODE (x2) != E_V4SFmode
              || GET_MODE (x4) != E_V4SFmode
              || !memory_operand (operands[1], E_V4HImode)
              || !nonimm_or_0_operand (operands[2], E_V4SFmode)
              || !register_operand (operands[3], E_QImode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29090 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL)))
            return -1;
          return 9576; /* *vcvtph2ps_load_mask */

        case E_V8SFmode:
          if (pattern626 (x2, 
E_V8SFmode, 
E_QImode, 
E_V8HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29100 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL)))
            return -1;
          return 9578; /* vcvtph2ps256_mask */

        case E_V16SFmode:
          if (pattern628 (x2, 
E_V16SFmode, 
E_HImode, 
E_V16HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29112 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9581; /* avx512f_vcvtph2ps512_mask */

        default:
          return -1;
        }

    case 168:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XEXP (x2, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern622 (x2, 
E_V16SImode, 
E_HImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 9999; /* conflictv16si_mask */

        case E_V8SImode:
          if (pattern622 (x2, 
E_V8SImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10001; /* conflictv8si_mask */

        case E_V4SImode:
          if (pattern622 (x2, 
E_V4SImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10003; /* conflictv4si_mask */

        case E_V8DImode:
          if (pattern622 (x2, 
E_V8DImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 10005; /* conflictv8di_mask */

        case E_V4DImode:
          if (pattern622 (x2, 
E_V4DImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10007; /* conflictv4di_mask */

        case E_V2DImode:
          if (pattern622 (x2, 
E_V2DImode, 
E_QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29949 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10009; /* conflictv2di_mask */

        default:
          return -1;
        }

    case 253:
      switch (pattern627 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10428; /* vcvtph2bf8v16hf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10436; /* vcvtph2bf8v32hf_mask */

        default:
          return -1;
        }

    case 254:
      switch (pattern627 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10430; /* vcvtph2bf8sv16hf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10438; /* vcvtph2bf8sv32hf_mask */

        default:
          return -1;
        }

    case 255:
      switch (pattern627 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10432; /* vcvtph2hf8v16hf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10440; /* vcvtph2hf8v32hf_mask */

        default:
          return -1;
        }

    case 256:
      switch (pattern627 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10434; /* vcvtph2hf8sv16hf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31922 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10442; /* vcvtph2hf8sv32hf_mask */

        default:
          return -1;
        }

    case 257:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XEXP (x2, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern626 (x2, 
E_V32HFmode, 
E_SImode, 
E_V32QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31931 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10444; /* vcvthf82phv32hf_mask */

        case E_V16HFmode:
          if (pattern626 (x2, 
E_V16HFmode, 
E_HImode, 
E_V16QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31931 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10446; /* vcvthf82phv16hf_mask */

        case E_V8HFmode:
          if (pattern626 (x2, 
E_V8HFmode, 
E_QImode, 
E_V16QImode) != 0
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31931 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10448; /* vcvthf82phv8hf_mask */

        default:
          return -1;
        }

    case 263:
      switch (pattern629 (x2, 
E_V32BFmode, 
E_V16BFmode, 
E_V8BFmode))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10657; /* avx10_2_cvtbf162ibsv32bf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10665; /* avx10_2_cvtbf162ibsv16bf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10673; /* avx10_2_cvtbf162ibsv8bf_mask */

        default:
          return -1;
        }

    case 264:
      switch (pattern629 (x2, 
E_V32BFmode, 
E_V16BFmode, 
E_V8BFmode))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10659; /* avx10_2_cvtbf162iubsv32bf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10667; /* avx10_2_cvtbf162iubsv16bf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10675; /* avx10_2_cvtbf162iubsv8bf_mask */

        default:
          return -1;
        }

    case 269:
      switch (pattern629 (x2, 
E_V32BFmode, 
E_V16BFmode, 
E_V8BFmode))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10661; /* avx10_2_cvttbf162ibsv32bf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10669; /* avx10_2_cvttbf162ibsv16bf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10677; /* avx10_2_cvttbf162ibsv8bf_mask */

        default:
          return -1;
        }

    case 270:
      switch (pattern629 (x2, 
E_V32BFmode, 
E_V16BFmode, 
E_V8BFmode))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10663; /* avx10_2_cvttbf162iubsv32bf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10671; /* avx10_2_cvttbf162iubsv16bf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32504 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10679; /* avx10_2_cvttbf162iubsv8bf_mask */

        default:
          return -1;
        }

    case 265:
      switch (pattern629 (x2, 
E_V32HFmode, 
E_V16HFmode, 
E_V8HFmode))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10682; /* avx10_2_cvtph2ibsv32hf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10689; /* avx10_2_cvtph2ibsv16hf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10693; /* avx10_2_cvtph2ibsv8hf_mask */

        default:
          return -1;
        }

    case 266:
      switch (pattern629 (x2, 
E_V32HFmode, 
E_V16HFmode, 
E_V8HFmode))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10686; /* avx10_2_cvtph2iubsv32hf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10691; /* avx10_2_cvtph2iubsv16hf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10695; /* avx10_2_cvtph2iubsv8hf_mask */

        default:
          return -1;
        }

    case 271:
      switch (pattern629 (x2, 
E_V32HFmode, 
E_V16HFmode, 
E_V8HFmode))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10698; /* avx10_2_cvttph2ibsv32hf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10705; /* avx10_2_cvttph2ibsv16hf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10709; /* avx10_2_cvttph2ibsv8hf_mask */

        default:
          return -1;
        }

    case 272:
      switch (pattern629 (x2, 
E_V32HFmode, 
E_V16HFmode, 
E_V8HFmode))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10702; /* avx10_2_cvttph2iubsv32hf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10707; /* avx10_2_cvttph2iubsv16hf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10711; /* avx10_2_cvttph2iubsv8hf_mask */

        default:
          return -1;
        }

    case 267:
      switch (pattern630 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10714; /* avx10_2_cvtps2ibsv16sf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10721; /* avx10_2_cvtps2ibsv8sf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10725; /* avx10_2_cvtps2ibsv4sf_mask */

        default:
          return -1;
        }

    case 268:
      switch (pattern630 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10718; /* avx10_2_cvtps2iubsv16sf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10723; /* avx10_2_cvtps2iubsv8sf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10727; /* avx10_2_cvtps2iubsv4sf_mask */

        default:
          return -1;
        }

    case 273:
      switch (pattern630 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10730; /* avx10_2_cvttps2ibsv16sf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10737; /* avx10_2_cvttps2ibsv8sf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10741; /* avx10_2_cvttps2ibsv4sf_mask */

        default:
          return -1;
        }

    case 274:
      switch (pattern630 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10734; /* avx10_2_cvttps2iubsv16sf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10739; /* avx10_2_cvttps2iubsv8sf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10743; /* avx10_2_cvttps2iubsv4sf_mask */

        default:
          return -1;
        }

    case 275:
      switch (pattern631 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 385 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10746; /* avx10_2_vcvttps2dqsv16sf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10753; /* avx10_2_vcvttps2dqsv8sf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 386 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10762; /* avx10_2_vcvttpd2dqsv8df_mask */

        case 3:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10757; /* avx10_2_vcvttps2dqsv4sf_mask */

        case 4:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10769; /* avx10_2_vcvttpd2dqsv4df_mask */

        case 5:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10773; /* avx10_2_vcvttpd2dqsv2df_mask */

        case 6:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 450 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10778; /* avx10_2_vcvttpd2qqsv8df_mask */

        case 7:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 617 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10794; /* avx10_2_vcvttps2qqsv8di_mask */

        case 8:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10785; /* avx10_2_vcvttpd2qqsv4df_mask */

        case 9:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10801; /* avx10_2_vcvttps2qqsv4di_mask */

        case 10:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10789; /* avx10_2_vcvttpd2qqsv2df_mask */

        case 11:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10805; /* avx10_2_vcvttps2qqsv2di_mask */

        default:
          return -1;
        }

    case 276:
      switch (pattern631 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 385 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10750; /* avx10_2_vcvttps2udqsv16sf_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10755; /* avx10_2_vcvttps2udqsv8sf_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 386 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10766; /* avx10_2_vcvttpd2udqsv8df_mask */

        case 3:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10759; /* avx10_2_vcvttps2udqsv4sf_mask */

        case 4:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10771; /* avx10_2_vcvttpd2udqsv4df_mask */

        case 5:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10775; /* avx10_2_vcvttpd2udqsv2df_mask */

        case 6:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 450 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10782; /* avx10_2_vcvttpd2uqqsv8df_mask */

        case 7:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 617 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10798; /* avx10_2_vcvttps2uqqsv8di_mask */

        case 8:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10787; /* avx10_2_vcvttpd2uqqsv4df_mask */

        case 9:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10803; /* avx10_2_vcvttps2uqqsv4di_mask */

        case 10:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10791; /* avx10_2_vcvttpd2uqqsv2df_mask */

        case 11:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10807; /* avx10_2_vcvttps2uqqsv2di_mask */

        default:
          return -1;
        }

    case 279:
      return recog_125 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_169 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (pattern917 (x4) != 0)
    return -1;
  x5 = XEXP (x2, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 2);
  operands[3] = x6;
  if (!register_operand (operands[3], E_QImode))
    return -1;
  x7 = XVECEXP (x4, 0, 0);
  switch (XWINT (x7, 0))
    {
    case 8L:
      x8 = XVECEXP (x4, 0, 1);
      if (XWINT (x8, 0) != 9L)
        return -1;
      x9 = XVECEXP (x4, 0, 2);
      if (XWINT (x9, 0) != 10L)
        return -1;
      x10 = XVECEXP (x4, 0, 3);
      if (XWINT (x10, 0) != 11L)
        return -1;
      x11 = XVECEXP (x4, 0, 4);
      if (XWINT (x11, 0) != 12L)
        return -1;
      x12 = XVECEXP (x4, 0, 5);
      if (XWINT (x12, 0) != 13L)
        return -1;
      x13 = XVECEXP (x4, 0, 6);
      if (XWINT (x13, 0) != 14L)
        return -1;
      x14 = XVECEXP (x4, 0, 7);
      if (XWINT (x14, 0) != 15L)
        return -1;
      switch (pattern1805 (x2))
        {
        case 0:
          if (!(
#line 12677 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5256; /* vec_extract_hi_v16sf_mask */

        case 1:
          if (!(
#line 12677 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5257; /* vec_extract_hi_v16si_mask */

        default:
          return -1;
        }

    case 0L:
      x8 = XVECEXP (x4, 0, 1);
      if (XWINT (x8, 0) != 1L
          || pattern1538 (x4) != 0)
        return -1;
      switch (pattern1805 (x2))
        {
        case 0:
          if (!(
#line 12781 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5260; /* vec_extract_lo_v16sf_mask */

        case 1:
          if (!(
#line 12781 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5261; /* vec_extract_lo_v16si_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_173 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 1);
  operands[3] = x5;
  x6 = XVECEXP (x4, 0, 2);
  operands[4] = x6;
  x7 = XVECEXP (x4, 0, 3);
  operands[5] = x7;
  x8 = XVECEXP (x4, 0, 5);
  operands[7] = x8;
  x9 = XVECEXP (x4, 0, 6);
  operands[8] = x9;
  x10 = XVECEXP (x4, 0, 7);
  operands[9] = x10;
  x11 = XVECEXP (x4, 0, 8);
  operands[10] = x11;
  x12 = XVECEXP (x4, 0, 9);
  operands[11] = x12;
  x13 = XVECEXP (x4, 0, 10);
  operands[12] = x13;
  x14 = XVECEXP (x4, 0, 11);
  operands[13] = x14;
  x15 = XVECEXP (x4, 0, 12);
  operands[14] = x15;
  x16 = XVECEXP (x4, 0, 13);
  operands[15] = x16;
  x17 = XVECEXP (x4, 0, 14);
  operands[16] = x17;
  x18 = XVECEXP (x4, 0, 15);
  operands[17] = x18;
  x19 = XEXP (x2, 1);
  operands[18] = x19;
  x20 = XEXP (x2, 2);
  operands[19] = x20;
  if (!register_operand (operands[19], E_HImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x2) != E_V16SFmode
          || GET_MODE (x3) != E_V16SFmode
          || !register_operand (operands[1], E_V16SFmode)
          || pattern1836 () != 0
          || !nonimm_or_0_operand (operands[18], E_V16SFmode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20453 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 8361; /* *avx512f_shuf_f32x4_1_mask_1 */

    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x2) != E_V16SImode
          || GET_MODE (x3) != E_V16SImode
          || !nonimm_or_0_operand (operands[18], E_V16SImode))
        return -1;
      if (register_operand (operands[1], E_V16SImode)
          && pattern1836 () == 0
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20453 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 8363; /* *avx512f_shuf_i32x4_1_mask_1 */
      if (!nonimmediate_operand (operands[1], E_V16SImode)
          || pattern1792 () != 0
          || !const_8_to_11_operand (operands[10], E_VOIDmode)
          || !const_8_to_11_operand (operands[11], E_VOIDmode)
          || !const_8_to_11_operand (operands[12], E_VOIDmode)
          || !const_8_to_11_operand (operands[13], E_VOIDmode)
          || !const_12_to_15_operand (operands[14], E_VOIDmode)
          || !const_12_to_15_operand (operands[15], E_VOIDmode)
          || !const_12_to_15_operand (operands[16], E_VOIDmode)
          || !const_12_to_15_operand (operands[17], E_VOIDmode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 20535 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512
   && INTVAL (operands[2]) + 4 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 4 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 4 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 4 == INTVAL (operands[9])
   && INTVAL (operands[2]) + 8 == INTVAL (operands[10])
   && INTVAL (operands[3]) + 8 == INTVAL (operands[11])
   && INTVAL (operands[4]) + 8 == INTVAL (operands[12])
   && INTVAL (operands[5]) + 8 == INTVAL (operands[13])
   && INTVAL (operands[2]) + 12 == INTVAL (operands[14])
   && INTVAL (operands[3]) + 12 == INTVAL (operands[15])
   && INTVAL (operands[4]) + 12 == INTVAL (operands[16])
   && INTVAL (operands[5]) + 12 == INTVAL (operands[17]))))
        return -1;
      return 8365; /* avx512f_pshufd_1_mask */

    default:
      return -1;
    }
}

 int
recog_184 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  operands[3] = x6;
  x7 = XEXP (x2, 2);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V16HImode:
      if (pattern129 (x2, 
E_HImode, 
E_V16HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17080 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 793 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7536; /* ashrv16hi3_mask */
      if (!register_operand (operands[1], E_V16HImode)
          || !nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28916 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9494; /* avx512vl_ashrvv16hi_mask */

    case E_V8HImode:
      if (pattern129 (x2, 
E_QImode, 
E_V8HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17080 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 793 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7538; /* ashrv8hi3_mask */
      if (!register_operand (operands[1], E_V8HImode)
          || !nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28916 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9492; /* avx512vl_ashrvv8hi_mask */

    case E_V8SImode:
      if (pattern129 (x2, 
E_QImode, 
E_V8SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17080 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7540; /* ashrv8si3_mask */
      if (!register_operand (operands[1], E_V8SImode)
          || !nonimmediate_operand (operands[2], E_V8SImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28905 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9482; /* avx2_ashrvv8si_mask */

    case E_V4SImode:
      if (pattern129 (x2, 
E_QImode, 
E_V4SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17080 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7542; /* ashrv4si3_mask */
      if (!register_operand (operands[1], E_V4SImode)
          || !nonimmediate_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28905 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9480; /* avx2_ashrvv4si_mask */

    case E_V2DImode:
      if (pattern129 (x2, 
E_QImode, 
E_V2DImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17080 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7544; /* ashrv2di3_mask */
      if (!register_operand (operands[1], E_V2DImode)
          || !nonimmediate_operand (operands[2], E_V2DImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28905 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL)) && 
#line 681 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9486; /* avx2_ashrvv2di_mask */

    case E_V32HImode:
      if (pattern129 (x2, 
E_SImode, 
E_V32HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 788 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
        return 7554; /* ashrv32hi3_mask */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28916 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9496; /* avx512bw_ashrvv32hi_mask */

    case E_V4DImode:
      if (pattern129 (x2, 
E_QImode, 
E_V4DImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return 7556; /* ashrv4di3_mask */
      if (!register_operand (operands[1], E_V4DImode)
          || !nonimmediate_operand (operands[2], E_V4DImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28905 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL)) && 
#line 681 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9488; /* avx2_ashrvv4di_mask */

    case E_V16SImode:
      if (pattern129 (x2, 
E_HImode, 
E_V16SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7558; /* ashrv16si3_mask */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28905 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 680 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9484; /* avx512f_ashrvv16si_mask */

    case E_V8DImode:
      if (pattern129 (x2, 
E_QImode, 
E_V8DImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7560; /* ashrv8di3_mask */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28905 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 682 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9490; /* avx512f_ashrvv8di_mask */

    default:
      return -1;
    }
}

 int
recog_186 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern142 (x2))
    {
    case 0:
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7573; /* lshrv16hi3_mask */
      if (!register_operand (operands[1], E_V16HImode)
          || !nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9528; /* avx512vl_lshrvv16hi_mask */

    case 1:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7577; /* lshrv8hi3_mask */
      if (!register_operand (operands[1], E_V8HImode)
          || !nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9524; /* avx512vl_lshrvv8hi_mask */

    case 2:
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7581; /* lshrv8si3_mask */
      if (!register_operand (operands[1], E_V8SImode)
          || !nonimmediate_operand (operands[2], E_V8SImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9504; /* avx2_lshrvv8si_mask */

    case 3:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7585; /* lshrv4si3_mask */
      if (!register_operand (operands[1], E_V4SImode)
          || !nonimmediate_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9508; /* avx2_lshrvv4si_mask */

    case 4:
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7589; /* lshrv4di3_mask */
      if (!register_operand (operands[1], E_V4DImode)
          || !nonimmediate_operand (operands[2], E_V4DImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9516; /* avx2_lshrvv4di_mask */

    case 5:
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7593; /* lshrv2di3_mask */
      if (!register_operand (operands[1], E_V2DImode)
          || !nonimmediate_operand (operands[2], E_V2DImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9520; /* avx2_lshrvv2di_mask */

    case 6:
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
        return 7613; /* lshrv32hi3_mask */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28938 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9532; /* avx512bw_lshrvv32hi_mask */

    case 7:
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7617; /* lshrv16si3_mask */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 803 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9500; /* avx512f_lshrvv16si_mask */

    case 8:
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 785 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7621; /* lshrv8di3_mask */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 28927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 804 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9512; /* avx512f_lshrvv8di_mask */

    default:
      return -1;
    }
}

 int
recog_191 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  switch (GET_CODE (x6))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case REG:
    case SUBREG:
    case MEM:
      switch (pattern488 (x2))
        {
        case 0:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V32HFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
            return -1;
          return 2689; /* *subv32hf3_mask */

        case 1:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V16HFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 390 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 2697; /* *subv16hf3_mask */

        case 2:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V8HFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 391 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
            return -1;
          return 2705; /* *subv8hf3_mask */

        case 3:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V16SFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 2713; /* *subv16sf3_mask */

        case 4:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V8SFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 2721; /* *subv8sf3_mask */

        case 5:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V4SFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && 1)))
            return -1;
          return 2729; /* *subv4sf3_mask */

        case 6:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V8DFmode, operands)
   && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 2737; /* *subv8df3_mask */

        case 7:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V4DFmode, operands)
   && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 2745; /* *subv4df3_mask */

        case 8:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2664 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_binary_operator_ok (MINUS, V2DFmode, operands)
   && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 394 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
            return -1;
          return 2753; /* *subv2df3_mask */

        case 9:
          if (!(
#line 16271 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V16SImode, operands)) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7414; /* *subv16si3_mask */

        case 10:
          if (!(
#line 16271 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V8SImode, operands)) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7416; /* *subv8si3_mask */

        case 11:
          if (!(
#line 16271 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V4SImode, operands)) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7418; /* *subv4si3_mask */

        case 12:
          if (!(
#line 16271 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V8DImode, operands)) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7420; /* *subv8di3_mask */

        case 13:
          if (!(
#line 16271 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V4DImode, operands)) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7422; /* *subv4di3_mask */

        case 14:
          if (!(
#line 16271 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_binary_operator_ok (MINUS, V2DImode, operands)) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7424; /* *subv2di3_mask */

        case 15:
          if (!(
#line 16285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V64QImode, operands)) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7426; /* *subv64qi3_mask */

        case 16:
          if (!(
#line 16285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V16QImode, operands)) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7428; /* *subv16qi3_mask */

        case 17:
          if (!(
#line 16285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V32QImode, operands)) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7430; /* *subv32qi3_mask */

        case 18:
          if (!(
#line 16285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V32HImode, operands)) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 7432; /* *subv32hi3_mask */

        case 19:
          if (!(
#line 16285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V16HImode, operands)) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7434; /* *subv16hi3_mask */

        case 20:
          if (!(
#line 16285 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_binary_operator_ok (MINUS, V8HImode, operands)) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 7436; /* *subv8hi3_mask */

        case 21:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32131 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10533; /* avx10_2_subbf16_v32bf_mask */

        case 22:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32131 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10541; /* avx10_2_subbf16_v16bf_mask */

        case 23:
          if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32131 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
            return -1;
          return 10549; /* avx10_2_subbf16_v8bf_mask */

        case 24:
          if (!(
#line 2713 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2765; /* avx512fp16_vmsubv8hf3 */

        case 25:
          if (!
#line 2713 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 2773; /* sse_vmsubv4sf3 */

        case 26:
          if (!(
#line 2713 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 2781; /* sse2_vmsubv2df3 */

        default:
          return -1;
        }

    case PLUS:
      x7 = XEXP (x2, 2);
      if (GET_CODE (x7) != CONST_INT)
        return -1;
      x8 = XEXP (x6, 0);
      if (!rtx_equal_p (x8, operands[1]))
        return -1;
      x9 = XEXP (x6, 1);
      if (!rtx_equal_p (x9, operands[2]))
        return -1;
      switch (XWINT (x7, 0))
        {
        case 85L:
          if (pattern1102 (x2, 
E_V8SFmode) != 0
              || !(
#line 3510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3145; /* vec_addsubv8sf3 */

        case 5L:
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1102 (x2, 
E_V4SFmode) != 0
                  || !
#line 3510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3))
                return -1;
              return 3146; /* vec_addsubv4sf3 */

            case E_V4DFmode:
              if (pattern1102 (x2, 
E_V4DFmode) != 0
                  || !(
#line 3510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 3147; /* vec_addsubv4df3 */

            default:
              return -1;
            }

        case 1L:
          if (pattern1102 (x2, 
E_V2DFmode) != 0
              || !(
#line 3510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3148; /* vec_addsubv2df3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_200 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern138 (x2))
    {
    case 0:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4548; /* avx512fp16_fixuns_truncv8hi2_mask */

    case 1:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4556; /* avx512fp16_fixuns_truncv16hi2_mask */

    case 2:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4564; /* avx512fp16_fixuns_truncv32hi2_mask */

    case 3:
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4572; /* avx512fp16_fixuns_truncv8si2_mask */

        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9557 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 4963; /* fixuns_truncv8dfv8si2_mask */

        case E_V8SFmode:
          if (!nonimmediate_operand (operands[1], E_V8SFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9900 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 440 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 5063; /* fixuns_truncv8sfv8si2_mask */

        default:
          return -1;
        }

    case 4:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4580; /* avx512fp16_fixuns_truncv16si2_mask */

    case 5:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8764 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 4814; /* fixuns_truncv16sfv16si2_mask */

    case 6:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4588; /* avx512fp16_fixuns_truncv8di2_mask */

    case 7:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 5000; /* fixuns_truncv8dfv8di2_mask */

    case 8:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9729 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 5044; /* fixuns_truncv8sfv8di2_mask */

    case 9:
      switch (GET_MODE (operands[1]))
        {
        case E_V4HFmode:
          if (!memory_operand (operands[1], E_V4HFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7919 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4609; /* *avx512fp16_fixuns_truncv4si2_load_mask */

        case E_V4DFmode:
          if (!nonimmediate_operand (operands[1], E_V4DFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512F)))
            return -1;
          return 4977; /* fixuns_truncv4dfv4si2_mask */

        case E_V4SFmode:
          if (!nonimmediate_operand (operands[1], E_V4SFmode)
              || !(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9900 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 5065; /* fixuns_truncv4sfv4si2_mask */

        default:
          return -1;
        }

    case 10:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7919 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4613; /* *avx512fp16_fixuns_truncv4di2_load_mask */

    case 11:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 5005; /* fixuns_truncv4dfv4di2_mask */

    case 12:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9729 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 5049; /* fixuns_truncv4sfv4di2_mask */

    case 13:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7969 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4625; /* *avx512fp16_fixuns_truncv2di2_load_mask */

    case 14:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 5009; /* fixuns_truncv2dfv2di2_mask */

    case 15:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7909 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4601; /* avx512fp16_fixuns_truncv4si2_mask */

    case 16:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7909 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4605; /* avx512fp16_fixuns_truncv4di2_mask */

    case 17:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7959 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4621; /* avx512fp16_fixuns_truncv2di2_mask */

    case 18:
      if (!(
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9752 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL)))
        return -1;
      return 5057; /* avx512dq_fixuns_truncv2sfv2di2_mask */

    default:
      return -1;
    }
}

 int
recog_212 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x2) != E_V8SFmode
          || !vector_operand (operands[1], E_V8SFmode)
          || !(
#line 3138 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 440 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2952; /* avx_rsqrtv8sf2 */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x2) != E_V4SFmode
          || !vector_operand (operands[1], E_V4SFmode)
          || !
#line 3138 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
        return -1;
      return 2953; /* sse_rsqrtv4sf2 */

    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || GET_MODE (x2) != E_V32HFmode
          || !vector_operand (operands[1], E_V32HFmode)
          || !(
#line 3150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2954; /* avx512fp16_rsqrtv32hf2 */

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || GET_MODE (x2) != E_V16HFmode
          || !vector_operand (operands[1], E_V16HFmode)
          || !(
#line 3150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2956; /* avx512fp16_rsqrtv16hf2 */

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x2) != E_V8HFmode
          || !vector_operand (operands[1], E_V8HFmode)
          || !(
#line 3150 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2958; /* avx512fp16_rsqrtv8hf2 */

    case E_V32BFmode:
      if (!register_operand (operands[0], E_V32BFmode)
          || GET_MODE (x2) != E_V32BFmode
          || !nonimmediate_operand (operands[1], E_V32BFmode)
          || !
#line 32400 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10602; /* avx10_2_rsqrtbf16_v32bf */

    case E_V16BFmode:
      if (!register_operand (operands[0], E_V16BFmode)
          || GET_MODE (x2) != E_V16BFmode
          || !nonimmediate_operand (operands[1], E_V16BFmode)
          || !
#line 32400 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10604; /* avx10_2_rsqrtbf16_v16bf */

    case E_V8BFmode:
      if (!register_operand (operands[0], E_V8BFmode)
          || GET_MODE (x2) != E_V8BFmode
          || !nonimmediate_operand (operands[1], E_V8BFmode)
          || !
#line 32400 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10606; /* avx10_2_rsqrtbf16_v8bf */

    default:
      return -1;
    }
}

 int
recog_219 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 0);
  x5 = XVECEXP (x4, 0, 0);
  operands[1] = x5;
  x6 = XEXP (x3, 1);
  operands[2] = x6;
  x7 = XEXP (x3, 2);
  operands[3] = x7;
  x8 = XVECEXP (x2, 0, 1);
  operands[4] = x8;
  switch (XINT (x4, 1))
    {
    case 156:
      if (!const_4_or_8_to_11_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HImode:
          if (pattern1288 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4339; /* avx512fp16_vcvtph2uw_v32hi_mask_round */

        case E_V16SImode:
          if (pattern1298 (x2, 
E_V16SImode, 
E_HImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V16HFmode:
              if (!register_operand (operands[1], E_V16HFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4347; /* avx512fp16_vcvtph2udq_v16si_mask_round */

            case E_V16SFmode:
              if (!nonimmediate_operand (operands[1], E_V16SFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8697 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4775; /* avx512f_fixuns_notruncv16sfv16si_mask_round */

            default:
              return -1;
            }

        case E_V8DImode:
          switch (pattern1460 (x2, 
E_V8DImode))
            {
            case 0:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4355; /* avx512fp16_vcvtph2uqq_v8di_mask_round */

            case 1:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8730 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
							      || V8DImode == V8DFmode
							      || V8DImode == V8DImode
							      || V8DImode == V16SImode
							      || V8DImode == V32HFmode)) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4795; /* avx512dq_cvtps2uqqv8di_mask_round */

            case 2:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9708 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 5021; /* fixuns_notruncv8dfv8di2_mask_round */

            default:
              return -1;
            }

        case E_V16HImode:
          if (pattern1288 (x2, 
E_HImode, 
E_V16HImode, 
E_V16HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4363; /* avx512fp16_vcvtph2uw_v16hi_mask_round */

        case E_V8SImode:
          switch (pattern1460 (x2, 
E_V8SImode))
            {
            case 0:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4371; /* avx512fp16_vcvtph2udq_v8si_mask_round */

            case 1:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8697 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4779; /* avx512vl_fixuns_notruncv8sfv8si_mask_round */

            case 2:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4941; /* fixuns_notruncv8dfv8si2_mask_round */

            default:
              return -1;
            }

        case E_V4DImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V4DImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4379; /* avx512fp16_vcvtph2uqq_v4di_mask_round */

        case E_V8HImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V8HImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4387; /* avx512fp16_vcvtph2uw_v8hi_mask_round */

        case E_V4SImode:
          if (pattern1298 (x2, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!register_operand (operands[1], E_V8HFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4395; /* avx512fp16_vcvtph2udq_v4si_mask_round */

            case E_V4SFmode:
              if (!nonimmediate_operand (operands[1], E_V4SFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8697 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4783; /* avx512vl_fixuns_notruncv4sfv4si_mask_round */

            case E_V4DFmode:
              if (!nonimmediate_operand (operands[1], E_V4DFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9489 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4945; /* fixuns_notruncv4dfv4si2_mask_round */

            default:
              return -1;
            }

        case E_V2DImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V2DImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4403; /* avx512fp16_vcvtph2uqq_v2di_mask_round */

        default:
          return -1;
        }

    case 46:
      if (!const_4_or_8_to_11_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HImode:
          if (pattern1288 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4343; /* avx512fp16_vcvtph2w_v32hi_mask_round */

        case E_V16SImode:
          switch (pattern1290 (x2))
            {
            case 0:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4351; /* avx512fp16_vcvtph2dq_v16si_mask_round */

            case 1:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8686 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 4771; /* avx512f_fix_notruncv16sfv16si_mask_round */

            default:
              return -1;
            }

        case E_V8DImode:
          if (pattern1298 (x2, 
E_V8DImode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!register_operand (operands[1], E_V8HFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4359; /* avx512fp16_vcvtph2qq_v8di_mask_round */

            case E_V8SFmode:
              if (!nonimmediate_operand (operands[1], E_V8SFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8707 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
							      || V8DImode == V8DFmode
							      || V8DImode == V8DImode
							      || V8DImode == V16SImode
							      || V8DImode == V32HFmode)) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 4787; /* avx512dq_cvtps2qqv8di_mask_round */

            case E_V8DFmode:
              if (!register_operand (operands[1], E_V8DFmode)
                  || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9697 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
							      || V8DFmode == V8DFmode
							      || V8DFmode == V8DImode
							      || V8DFmode == V16SImode
							      || V8DFmode == V32HFmode)) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                return -1;
              return 5013; /* fix_notruncv8dfv8di2_mask_round */

            default:
              return -1;
            }

        case E_V16HImode:
          if (pattern1288 (x2, 
E_HImode, 
E_V16HImode, 
E_V16HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4367; /* avx512fp16_vcvtph2w_v16hi_mask_round */

        case E_V8SImode:
          switch (pattern1289 (x2))
            {
            case 0:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
                return -1;
              return 4375; /* avx512fp16_vcvtph2dq_v8si_mask_round */

            case 1:
              if (!(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9388 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 4931; /* avx512f_cvtpd2dq512_mask_round */

            default:
              return -1;
            }

        case E_V4DImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V4DImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4383; /* avx512fp16_vcvtph2qq_v4di_mask_round */

        case E_V8HImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V8HImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4391; /* avx512fp16_vcvtph2w_v8hi_mask_round */

        case E_V4SImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V4SImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4399; /* avx512fp16_vcvtph2dq_v4si_mask_round */

        case E_V2DImode:
          if (pattern1288 (x2, 
E_QImode, 
E_V2DImode, 
E_V8HFmode) != 0
              || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7634 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4407; /* avx512fp16_vcvtph2qq_v2di_mask_round */

        default:
          return -1;
        }

    case 172:
      switch (pattern1291 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4497; /* unspec_avx512fp16_fix_truncv8hi2_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4505; /* unspec_avx512fp16_fix_truncv16hi2_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4513; /* unspec_avx512fp16_fix_truncv32hi2_mask_round */

        case 3:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4521; /* unspec_avx512fp16_fix_truncv8si2_mask_round */

        case 4:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9547 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4952; /* unspec_fix_truncv8dfv8si2_mask_round */

        case 5:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4529; /* unspec_avx512fp16_fix_truncv16si2_mask_round */

        case 6:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8754 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4803; /* unspec_fix_truncv16sfv16si2_mask_round */

        case 7:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4537; /* unspec_avx512fp16_fix_truncv8di2_mask_round */

        case 8:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4981; /* unspec_fix_truncv8dfv8di2_mask_round */

        case 9:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9719 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 5029; /* unspec_fix_truncv8sfv8di2_mask_round */

        default:
          return -1;
        }

    case 173:
      switch (pattern1291 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4501; /* unspec_avx512fp16_fixuns_truncv8hi2_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4509; /* unspec_avx512fp16_fixuns_truncv16hi2_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4517; /* unspec_avx512fp16_fixuns_truncv32hi2_mask_round */

        case 3:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 4525; /* unspec_avx512fp16_fixuns_truncv8si2_mask_round */

        case 4:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9547 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4956; /* unspec_fixuns_truncv8dfv8si2_mask_round */

        case 5:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4533; /* unspec_avx512fp16_fixuns_truncv16si2_mask_round */

        case 6:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8754 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
            return -1;
          return 4807; /* unspec_fixuns_truncv16sfv16si2_mask_round */

        case 7:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7859 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4541; /* unspec_avx512fp16_fixuns_truncv8di2_mask_round */

        case 8:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9676 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 536 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 4985; /* unspec_fixuns_truncv8dfv8di2_mask_round */

        case 9:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9719 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 626 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 5033; /* unspec_fixuns_truncv8sfv8di2_mask_round */

        default:
          return -1;
        }

    case 165:
      if (!const48_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern1461 (x2, 
E_V32HFmode, 
E_SImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))))
            return -1;
          return 6949; /* avx512bw_getexpv32hf_mask_round */

        case E_V16HFmode:
          if (pattern1461 (x2, 
E_V16HFmode, 
E_HImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 6953; /* avx512vl_getexpv16hf_mask_round */

        case E_V8HFmode:
          if (pattern1461 (x2, 
E_V8HFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))))
            return -1;
          return 6957; /* avx512fp16_getexpv8hf_mask_round */

        case E_V16SFmode:
          if (pattern1461 (x2, 
E_V16SFmode, 
E_HImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 6961; /* avx512f_getexpv16sf_mask_round */

        case E_V8SFmode:
          if (pattern1461 (x2, 
E_V8SFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 6965; /* avx512vl_getexpv8sf_mask_round */

        case E_V4SFmode:
          if (pattern1461 (x2, 
E_V4SFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 6969; /* avx512vl_getexpv4sf_mask_round */

        case E_V8DFmode:
          if (pattern1461 (x2, 
E_V8DFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
            return -1;
          return 6973; /* avx512f_getexpv8df_mask_round */

        case E_V4DFmode:
          if (pattern1461 (x2, 
E_V4DFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 6977; /* avx512vl_getexpv4df_mask_round */

        case E_V2DFmode:
          if (pattern1461 (x2, 
E_V2DFmode, 
E_QImode) != 0
              || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))))
            return -1;
          return 6981; /* avx512vl_getexpv2df_mask_round */

        default:
          return -1;
        }

    case 149:
      if (pattern1292 (x2, 
E_HImode, 
E_V16SFmode, 
E_V16HImode) != 0
          || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29112 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9582; /* avx512f_vcvtph2ps512_mask_round */

    case 265:
      if (pattern1293 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
          || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10683; /* avx10_2_cvtph2ibsv32hf_mask_round */

    case 266:
      if (pattern1293 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
          || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32519 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10687; /* avx10_2_cvtph2iubsv32hf_mask_round */

    case 271:
      if (pattern1292 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
          || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10699; /* avx10_2_cvttph2ibsv32hf_mask_round */

    case 272:
      if (pattern1292 (x2, 
E_SImode, 
E_V32HImode, 
E_V32HFmode) != 0
          || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32534 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V32HFmode == V16SFmode
									      || V32HFmode == V8DFmode
									      || V32HFmode == V8DImode
									      || V32HFmode == V16SImode
									      || V32HFmode == V32HFmode)) && 
#line 561 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10703; /* avx10_2_cvttph2iubsv32hf_mask_round */

    case 267:
      if (pattern1293 (x2, 
E_HImode, 
E_V16SImode, 
E_V16SFmode) != 0
          || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10715; /* avx10_2_cvtps2ibsv16sf_mask_round */

    case 268:
      if (pattern1293 (x2, 
E_HImode, 
E_V16SImode, 
E_V16SFmode) != 0
          || !(
#line 221 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32549 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
							      || V16SFmode == V8DFmode
							      || V16SFmode == V8DImode
							      || V16SFmode == V16SImode
							      || V16SFmode == V32HFmode)) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10719; /* avx10_2_cvtps2iubsv16sf_mask_round */

    case 273:
      if (pattern1292 (x2, 
E_HImode, 
E_V16SImode, 
E_V16SFmode) != 0
          || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10731; /* avx10_2_cvttps2ibsv16sf_mask_round */

    case 274:
      if (pattern1292 (x2, 
E_HImode, 
E_V16SImode, 
E_V16SFmode) != 0
          || !(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32564 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 545 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
        return -1;
      return 10735; /* avx10_2_cvttps2iubsv16sf_mask_round */

    case 275:
      switch (pattern1294 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 385 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10747; /* avx10_2_vcvttps2dqsv16sf_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 386 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10763; /* avx10_2_vcvttpd2dqsv8df_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 450 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10779; /* avx10_2_vcvttpd2qqsv8df_mask_round */

        case 3:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 617 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10795; /* avx10_2_vcvttps2qqsv8di_mask_round */

        default:
          return -1;
        }

    case 276:
      switch (pattern1294 (x2))
        {
        case 0:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 385 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10751; /* avx10_2_vcvttps2udqsv16sf_mask_round */

        case 1:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 386 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10767; /* avx10_2_vcvttpd2udqsv8df_mask_round */

        case 2:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 450 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10783; /* avx10_2_vcvttpd2uqqsv8df_mask_round */

        case 3:
          if (!(
#line 263 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/tmp/pkg/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32605 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && (V8DImode == V16SFmode
									      || V8DImode == V8DFmode
									      || V8DImode == V8DImode
									      || V8DImode == V16SImode
									      || V8DImode == V32HFmode)) && 
#line 617 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))))
            return -1;
          return 10799; /* avx10_2_vcvttps2uqqsv8di_mask_round */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_241 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != E_V16QImode)
    return -1;
  x4 = XEXP (x1, 0);
  if (GET_CODE (x4) != MEM
      || GET_MODE (x4) != E_V16QImode)
    return -1;
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  if (GET_MODE (x2) != E_V16QImode)
    return -1;
  switch (pattern1059 (x2, 
E_V16QImode))
    {
    case 0:
      if (!(
#line 22464 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
        return -1;
      return 8506; /* *sse2_maskmovdqu */

    case 1:
      if (!(
#line 22464 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
        return -1;
      return 8507; /* *sse2_maskmovdqu */

    default:
      return -1;
    }
}

 int
recog_246 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_CODE (operands[3]))
    {
    case REG:
    case SUBREG:
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern1020 (x3, 
E_HImode, 
E_V16SImode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9848; /* expandv16si_mask */

        case E_V16SFmode:
          if (pattern1020 (x3, 
E_HImode, 
E_V16SFmode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9849; /* expandv16sf_mask */

        case E_V8DImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8DImode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9850; /* expandv8di_mask */

        case E_V8DFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8DFmode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9851; /* expandv8df_mask */

        case E_V8SImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8SImode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9852; /* expandv8si_mask */

        case E_V8SFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8SFmode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9853; /* expandv8sf_mask */

        case E_V4DImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V4DImode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9854; /* expandv4di_mask */

        case E_V4DFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V4DFmode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9855; /* expandv4df_mask */

        case E_V4SImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V4SImode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9856; /* expandv4si_mask */

        case E_V4SFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V4SFmode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9857; /* expandv4sf_mask */

        case E_V2DImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V2DImode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9858; /* expandv2di_mask */

        case E_V2DFmode:
          if (pattern1020 (x3, 
E_QImode, 
E_V2DFmode) != 0
              || !(
#line 29721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9859; /* expandv2df_mask */

        case E_V64QImode:
          if (pattern1020 (x3, 
E_DImode, 
E_V64QImode) != 0
              || !(
#line 29735 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9860; /* expandv64qi_mask */

        case E_V16QImode:
          if (pattern1020 (x3, 
E_HImode, 
E_V16QImode) != 0
              || !(
#line 29735 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9861; /* expandv16qi_mask */

        case E_V32QImode:
          if (pattern1020 (x3, 
E_SImode, 
E_V32QImode) != 0
              || !(
#line 29735 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9862; /* expandv32qi_mask */

        case E_V32HImode:
          if (pattern1020 (x3, 
E_SImode, 
E_V32HImode) != 0
              || !(
#line 29735 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9863; /* expandv32hi_mask */

        case E_V16HImode:
          if (pattern1020 (x3, 
E_HImode, 
E_V16HImode) != 0
              || !(
#line 29735 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9864; /* expandv16hi_mask */

        case E_V8HImode:
          if (pattern1020 (x3, 
E_QImode, 
E_V8HImode) != 0
              || !(
#line 29735 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9865; /* expandv8hi_mask */

        default:
          return -1;
        }

    case CONST_INT:
      switch (pattern906 (x3))
        {
        case 0:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16SImode)) >= 4)) && 
#line 1016 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9866; /* *expandv16si_mask */

        case 1:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16SFmode)) >= 4)) && 
#line 1017 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9867; /* *expandv16sf_mask */

        case 2:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8DImode)) >= 4)) && 
#line 1018 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9868; /* *expandv8di_mask */

        case 3:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8DFmode)) >= 4)) && 
#line 1019 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9869; /* *expandv8df_mask */

        case 4:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8SImode)) >= 4)) && 
#line 1020 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9870; /* *expandv8si_mask */

        case 5:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8SFmode)) >= 4)) && 
#line 1020 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9871; /* *expandv8sf_mask */

        case 6:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4DImode)) >= 4)) && 
#line 1021 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9872; /* *expandv4di_mask */

        case 7:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4DFmode)) >= 4)) && 
#line 1021 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9873; /* *expandv4df_mask */

        case 8:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4SImode)) >= 4)) && 
#line 1022 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9874; /* *expandv4si_mask */

        case 9:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4SFmode)) >= 4)) && 
#line 1022 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9875; /* *expandv4sf_mask */

        case 10:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V2DImode)) >= 4)) && 
#line 1023 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9876; /* *expandv2di_mask */

        case 11:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V2DFmode)) >= 4)) && 
#line 1023 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9877; /* *expandv2df_mask */

        case 12:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V64QImode)) >= 4)) && 
#line 1024 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9878; /* *expandv64qi_mask */

        case 13:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16QImode)) >= 4)) && 
#line 1024 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9879; /* *expandv16qi_mask */

        case 14:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V32QImode)) >= 4)) && 
#line 1024 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9880; /* *expandv32qi_mask */

        case 15:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V32HImode)) >= 4)) && 
#line 1025 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9881; /* *expandv32hi_mask */

        case 16:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16HImode)) >= 4)) && 
#line 1025 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9882; /* *expandv16hi_mask */

        case 17:
          if (!(
#line 29749 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8HImode)) >= 4)) && 
#line 1025 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9883; /* *expandv8hi_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_251 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  if (!const_0_to_15_operand (operands[3], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (pattern152 (x3, 
E_V16SFmode) != 0
          || !(
#line 29815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9884; /* avx512dq_rangepv16sf */

    case E_V8SFmode:
      if (pattern152 (x3, 
E_V8SFmode) != 0
          || !(
#line 29815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9888; /* avx512dq_rangepv8sf */

    case E_V4SFmode:
      if (pattern152 (x3, 
E_V4SFmode) != 0
          || !(
#line 29815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 520 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9890; /* avx512dq_rangepv4sf */

    case E_V8DFmode:
      if (pattern152 (x3, 
E_V8DFmode) != 0
          || !(
#line 29815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9892; /* avx512dq_rangepv8df */

    case E_V4DFmode:
      if (pattern152 (x3, 
E_V4DFmode) != 0
          || !(
#line 29815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9896; /* avx512dq_rangepv4df */

    case E_V2DFmode:
      if (pattern152 (x3, 
E_V2DFmode) != 0
          || !(
#line 29815 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 521 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9898; /* avx512dq_rangepv2df */

    default:
      return -1;
    }
}

 int
recog_255 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern176 (x1))
    {
    case 0:
      if (!(
#line 30421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10145; /* vpshrdv_v32hi */

    case 1:
      if (!(
#line 30421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10146; /* vpshrdv_v16si */

    case 2:
      if (!(
#line 30421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10147; /* vpshrdv_v8di */

    case 3:
      if (!(
#line 30421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10148; /* vpshrdv_v16hi */

    case 4:
      if (!(
#line 30421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10149; /* vpshrdv_v8si */

    case 5:
      if (!(
#line 30421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10150; /* vpshrdv_v4di */

    case 6:
      if (!(
#line 30421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10151; /* vpshrdv_v8hi */

    case 7:
      if (!(
#line 30421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10152; /* vpshrdv_v4si */

    case 8:
      if (!(
#line 30421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10153; /* vpshrdv_v2di */

    default:
      return -1;
    }
}

 int
recog_262 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 51:
      return recog_245 (x1, insn, pnum_clobbers);

    case 59:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!cmpps_imm_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern61 (x2, 
E_V8SFmode) != 0
              || !(
#line 4100 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3207; /* avx_cmpv8sf3 */

        case E_V4SFmode:
          if (pattern61 (x2, 
E_V4SFmode) != 0
              || !
#line 4100 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3208; /* avx_cmpv4sf3 */

        case E_V4DFmode:
          if (pattern61 (x2, 
E_V4DFmode) != 0
              || !(
#line 4100 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3209; /* avx_cmpv4df3 */

        case E_V2DFmode:
          if (pattern61 (x2, 
E_V2DFmode) != 0
              || !(
#line 4100 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3210; /* avx_cmpv2df3 */

        default:
          return -1;
        }

    case 133:
      return recog_244 (x1, insn, pnum_clobbers);

    case 217:
      return recog_260 (x1, insn, pnum_clobbers);

    case 219:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (pattern661 (x2))
        {
        case 0:
          if ((
#line 7164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 4256; /* fma_fcmaddc_v32hf */
          break;

        case 1:
          if ((
#line 7164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4262; /* fma_fcmaddc_v16hf */
          break;

        case 2:
          if ((
#line 7164 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4266; /* fma_fcmaddc_v8hf */
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG
          || maybe_ne (SUBREG_BYTE (x5), 0))
        return -1;
      switch (pattern589 (x2))
        {
        case 0:
          if (!(
#line 7270 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4289; /* fma_v32hf_fcmaddc_bcst */

        case 1:
          if (!(
#line 7270 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4290; /* fma_v16hf_fcmaddc_bcst */

        case 2:
          if (!(
#line 7270 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4291; /* fma_v8hf_fcmaddc_bcst */

        default:
          return -1;
        }

    case 218:
      switch (pattern169 (x1))
        {
        case 0:
          if (!(
#line 7229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4280; /* fma_fmaddc_v16sf_pair */

        case 1:
          if (!(
#line 7229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4282; /* fma_fmaddc_v8sf_pair */

        case 2:
          if (!(
#line 7229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4284; /* fma_fmaddc_v4sf_pair */

        default:
          return -1;
        }

    case 220:
      switch (pattern169 (x1))
        {
        case 0:
          if (!(
#line 7229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4281; /* fma_fcmaddc_v16sf_pair */

        case 1:
          if (!(
#line 7229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4283; /* fma_fcmaddc_v8sf_pair */

        case 2:
          if (!(
#line 7229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4285; /* fma_fcmaddc_v4sf_pair */

        default:
          return -1;
        }

    case 50:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[2] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[1] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SImode:
          if (pattern957 (x2, 
E_V4SImode) != 0
              || !
#line 12216 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return -1;
          return 5234; /* sse4_1_insertps_v4si */

        case E_V4SFmode:
          if (pattern957 (x2, 
E_V4SFmode) != 0
              || !
#line 12216 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return -1;
          return 5235; /* sse4_1_insertps_v4sf */

        default:
          return -1;
        }

    case 167:
      return recog_252 (x1, insn, pnum_clobbers);

    case 155:
      return recog_247 (x1, insn, pnum_clobbers);

    case 47:
      return recog_243 (x1, insn, pnum_clobbers);

    case 121:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_mul_8_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V4TImode:
          if (pattern152 (x2, 
E_V4TImode) != 0
              || !(
#line 23244 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 725 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8570; /* avx512bw_palignrv4ti */

        case E_V2TImode:
          if (pattern152 (x2, 
E_V2TImode) != 0
              || !(
#line 23244 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 725 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8571; /* avx2_palignrv2ti */

        case E_V1TImode:
          if (pattern152 (x2, 
E_V1TImode) != 0
              || !
#line 23244 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
            return -1;
          return 8572; /* ssse3_palignrv1ti */

        default:
          return -1;
        }

    case 122:
      if (GET_MODE (x2) != E_V2DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_V2DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_VOIDmode))
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_VOIDmode)
          || !
#line 23438 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4A))
        return -1;
      return 8602; /* sse4a_extrqi */

    case 126:
      return recog_258 (x1, insn, pnum_clobbers);

    case 128:
      return recog_259 (x1, insn, pnum_clobbers);

    case 53:
      if (pattern63 (x1, 
E_V16QImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!nonimmediate_operand (operands[3], E_V16QImode)
          || !
#line 26487 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
        return -1;
      return 8955; /* xop_pperm */

    case 135:
      return recog_257 (x1, insn, pnum_clobbers);

    case 143:
      if (pattern160 (x1, 
E_V2DImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode)
          || !
#line 27200 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_PCLMUL))
        return -1;
      return 9014; /* pclmulqdq */

    case 152:
      if (pattern63 (x1, 
E_V4DImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode)
          || !
#line 27657 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
        return -1;
      return 9104; /* avx2_permv2ti */

    case 146:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SImode:
          if (pattern61 (x2, 
E_V8SImode) != 0
              || !
#line 28310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9374; /* *avx_vperm2f128v8si_full */

        case E_V8SFmode:
          if (pattern61 (x2, 
E_V8SFmode) != 0
              || !
#line 28310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9375; /* *avx_vperm2f128v8sf_full */

        case E_V4DFmode:
          if (pattern61 (x2, 
E_V4DFmode) != 0
              || !
#line 28310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9376; /* *avx_vperm2f128v4df_full */

        default:
          return -1;
        }

    case 153:
      return recog_242 (x1, insn, pnum_clobbers);

    case 169:
      return recog_249 (x1, insn, pnum_clobbers);

    case 170:
      return recog_248 (x1, insn, pnum_clobbers);

    case 171:
      return recog_246 (x1, insn, pnum_clobbers);

    case 194:
      return recog_251 (x1, insn, pnum_clobbers);

    case 186:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HImode:
          if (pattern163 (x2, 
E_V8HImode, 
E_V16QImode) != 0
              || !(
#line 29927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9980; /* *avx512bw_dbpsadbwv8hi */

        case E_V16HImode:
          if (pattern163 (x2, 
E_V16HImode, 
E_V32QImode) != 0
              || !(
#line 29927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9982; /* *avx512bw_dbpsadbwv16hi */

        case E_V32HImode:
          if (pattern163 (x2, 
E_V32HImode, 
E_V64QImode) != 0
              || !(
#line 29927 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9984; /* *avx512bw_dbpsadbwv32hi */

        default:
          return -1;
        }

    case 182:
      if (pattern160 (x1, 
E_V4SImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_3_operand (operands[3], E_SImode)
          || !
#line 29995 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10013; /* sha1rnds4 */

    case 185:
      if (pattern160 (x1, 
E_V4SImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!register_operand (operands[3], E_V4SImode)
          || !
#line 30030 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10016; /* sha256rnds2 */

    case 224:
      if (pattern171 (x1) != 0
          || !
#line 30043 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM3))
        return -1;
      return 10017; /* vsm3msg1 */

    case 225:
      if (pattern171 (x1) != 0
          || !
#line 30055 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM3))
        return -1;
      return 10018; /* vsm3msg2 */

    case 241:
      if (pattern159 (x1, 
E_V4DImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!register_operand (operands[3], E_V2DImode)
          || !
#line 30103 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA512))
        return -1;
      return 10022; /* vsha512rnds2 */

    case 195:
      switch (pattern173 (x1))
        {
        case 0:
          if (!
#line 30212 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512IFMA && TARGET_EVEX512))
            return -1;
          return 10035; /* vpmadd52luqv8di */

        case 1:
          if (!(
#line 30225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)) && 
#line 704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10037; /* vpmadd52luqv4di */

        case 2:
          if (!
#line 30225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)))
            return -1;
          return 10039; /* vpmadd52luqv2di */

        default:
          return -1;
        }

    case 196:
      switch (pattern173 (x1))
        {
        case 0:
          if (!
#line 30212 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512IFMA && TARGET_EVEX512))
            return -1;
          return 10036; /* vpmadd52huqv8di */

        case 1:
          if (!(
#line 30225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)) && 
#line 704 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10038; /* vpmadd52huqv4di */

        case 2:
          if (!
#line 30225 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)))
            return -1;
          return 10040; /* vpmadd52huqv2di */

        default:
          return -1;
        }

    case 198:
      switch (pattern174 (x1))
        {
        case 0:
          if (!(
#line 30349 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10091; /* vgf2p8affineinvqb_v64qi */

        case 1:
          if (!(
#line 30349 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10093; /* vgf2p8affineinvqb_v32qi */

        case 2:
          if (!
#line 30349 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI))
            return -1;
          return 10095; /* vgf2p8affineinvqb_v16qi */

        default:
          return -1;
        }

    case 199:
      switch (pattern174 (x1))
        {
        case 0:
          if (!(
#line 30366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10097; /* vgf2p8affineqb_v64qi */

        case 1:
          if (!(
#line 30366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10099; /* vgf2p8affineqb_v32qi */

        case 2:
          if (!
#line 30366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI))
            return -1;
          return 10101; /* vgf2p8affineqb_v16qi */

        default:
          return -1;
        }

    case 202:
      return recog_256 (x1, insn, pnum_clobbers);

    case 201:
      return recog_254 (x1, insn, pnum_clobbers);

    case 203:
      return recog_255 (x1, insn, pnum_clobbers);

    case 204:
      return recog_253 (x1, insn, pnum_clobbers);

    case 205:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30583 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10199; /* vpdpbusd_v16si */

        case 1:
          if (!(
#line 30594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10200; /* vpdpbusd_v8si */

        case 2:
          if (!
#line 30594 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10201; /* vpdpbusd_v4si */

        default:
          return -1;
        }

    case 206:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30652 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10208; /* vpdpbusds_v16si */

        case 1:
          if (!(
#line 30663 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10209; /* vpdpbusds_v8si */

        case 2:
          if (!
#line 30663 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10210; /* vpdpbusds_v4si */

        default:
          return -1;
        }

    case 207:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10217; /* vpdpwssd_v16si */

        case 1:
          if (!(
#line 30732 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10218; /* vpdpwssd_v8si */

        case 2:
          if (!
#line 30732 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10219; /* vpdpwssd_v4si */

        default:
          return -1;
        }

    case 208:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30790 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10226; /* vpdpwssds_v16si */

        case 1:
          if (!(
#line 30801 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10227; /* vpdpwssds_v8si */

        case 2:
          if (!
#line 30801 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10228; /* vpdpwssds_v4si */

        default:
          return -1;
        }

    case 213:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DImode:
          if (pattern152 (x2, 
E_V8DImode) != 0
              || !(
#line 30930 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_VPCLMULQDQ) && 
#line 620 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10247; /* vpclmulqdq_v8di */

        case E_V4DImode:
          if (pattern152 (x2, 
E_V4DImode) != 0
              || !
#line 30930 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_VPCLMULQDQ))
            return -1;
          return 10248; /* vpclmulqdq_v4di */

        case E_V2DImode:
          if (pattern152 (x2, 
E_V2DImode) != 0
              || !(
#line 30930 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_VPCLMULQDQ) && 
#line 620 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10249; /* vpclmulqdq_v2di */

        default:
          return -1;
        }

    case 216:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern907 (x2, 
E_V32BFmode, 
E_V16SFmode) != 0
              || !(
#line 31209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 10277; /* avx512f_dpbf16ps_v16sf */

        case E_V8SFmode:
          if (pattern907 (x2, 
E_V16BFmode, 
E_V8SFmode) != 0
              || !(
#line 31209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10279; /* avx512f_dpbf16ps_v8sf */

        case E_V4SFmode:
          if (pattern907 (x2, 
E_V8BFmode, 
E_V4SFmode) != 0
              || !(
#line 31209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10281; /* avx512f_dpbf16ps_v4sf */

        default:
          return -1;
        }

    case 227:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10297; /* vpdpbssd_v8si */

        case 1:
          if (!
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10303; /* vpdpbssd_v4si */

        case 2:
          if (!
#line 31593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10309; /* vpdpbssd_v16si */

        default:
          return -1;
        }

    case 228:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10298; /* vpdpbssds_v8si */

        case 1:
          if (!
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10304; /* vpdpbssds_v4si */

        case 2:
          if (!
#line 31593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10310; /* vpdpbssds_v16si */

        default:
          return -1;
        }

    case 229:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10299; /* vpdpbsud_v8si */

        case 1:
          if (!
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10305; /* vpdpbsud_v4si */

        case 2:
          if (!
#line 31593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10311; /* vpdpbsud_v16si */

        default:
          return -1;
        }

    case 230:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10300; /* vpdpbsuds_v8si */

        case 1:
          if (!
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10306; /* vpdpbsuds_v4si */

        case 2:
          if (!
#line 31593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10312; /* vpdpbsuds_v16si */

        default:
          return -1;
        }

    case 231:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10301; /* vpdpbuud_v8si */

        case 1:
          if (!
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10307; /* vpdpbuud_v4si */

        case 2:
          if (!
#line 31593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10313; /* vpdpbuud_v16si */

        default:
          return -1;
        }

    case 232:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10302; /* vpdpbuuds_v8si */

        case 1:
          if (!
#line 31582 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10308; /* vpdpbuuds_v4si */

        case 2:
          if (!
#line 31593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10314; /* vpdpbuuds_v16si */

        default:
          return -1;
        }

    case 233:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10449; /* vpdpwusd_v8si */

        case 1:
          if (!
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10455; /* vpdpwusd_v4si */

        case 2:
          if (!
#line 32002 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10461; /* vpdpwusd_v16si */

        default:
          return -1;
        }

    case 234:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10450; /* vpdpwusds_v8si */

        case 1:
          if (!
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10456; /* vpdpwusds_v4si */

        case 2:
          if (!
#line 32002 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10462; /* vpdpwusds_v16si */

        default:
          return -1;
        }

    case 235:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10451; /* vpdpwsud_v8si */

        case 1:
          if (!
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10457; /* vpdpwsud_v4si */

        case 2:
          if (!
#line 32002 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10463; /* vpdpwsud_v16si */

        default:
          return -1;
        }

    case 236:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10452; /* vpdpwsuds_v8si */

        case 1:
          if (!
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10458; /* vpdpwsuds_v4si */

        case 2:
          if (!
#line 32002 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10464; /* vpdpwsuds_v16si */

        default:
          return -1;
        }

    case 237:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10453; /* vpdpwuud_v8si */

        case 1:
          if (!
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10459; /* vpdpwuud_v4si */

        case 2:
          if (!
#line 32002 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10465; /* vpdpwuud_v16si */

        default:
          return -1;
        }

    case 238:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10454; /* vpdpwuuds_v8si */

        case 1:
          if (!
#line 31991 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10460; /* vpdpwuuds_v4si */

        case 2:
          if (!
#line 32002 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10466; /* vpdpwuuds_v16si */

        default:
          return -1;
        }

    case 244:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern172 (x2, 
E_V16SFmode) != 0
              || !
#line 32054 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10503; /* vdpphps_v16sf */

        case E_V8SFmode:
          if (pattern172 (x2, 
E_V8SFmode) != 0
              || !
#line 32054 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10504; /* vdpphps_v8sf */

        case E_V4SFmode:
          if (pattern172 (x2, 
E_V4SFmode) != 0
              || !
#line 32054 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10505; /* vdpphps_v4sf */

        default:
          return -1;
        }

    case 277:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32BFmode:
          if (pattern1021 (x2, 
E_V32BFmode) != 0
              || !
#line 32644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10824; /* avx10_2_minmaxbf16_v32bf */

        case E_V16BFmode:
          if (pattern1021 (x2, 
E_V16BFmode) != 0
              || !
#line 32644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10826; /* avx10_2_minmaxbf16_v16bf */

        case E_V8BFmode:
          if (pattern1021 (x2, 
E_V8BFmode) != 0
              || !
#line 32644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10828; /* avx10_2_minmaxbf16_v8bf */

        default:
          return -1;
        }

    case 278:
      return recog_250 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_287 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 4);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  operands[6] = x4;
  res = recog_286 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (XWINT (x4, 0) != 4L)
    return -1;
  x5 = XVECEXP (x3, 0, 5);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x6 = XVECEXP (x3, 0, 6);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x7 = XVECEXP (x3, 0, 7);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || !register_operand (operands[0], E_V8HImode)
      || GET_MODE (x2) != E_V8HImode
      || !vector_operand (operands[1], E_V8HImode)
      || pattern668 (x3) != 0
      || !
#line 20834 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
    return -1;
  return 8374; /* sse2_pshuflw_1 */
}

 int
recog_290 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 1);
  operands[3] = x4;
  x5 = XVECEXP (x3, 0, 2);
  operands[4] = x5;
  x6 = XVECEXP (x3, 0, 3);
  operands[5] = x6;
  x7 = XVECEXP (x3, 0, 5);
  operands[7] = x7;
  x8 = XVECEXP (x3, 0, 6);
  operands[8] = x8;
  x9 = XVECEXP (x3, 0, 7);
  operands[9] = x9;
  x10 = XVECEXP (x3, 0, 8);
  operands[10] = x10;
  x11 = XVECEXP (x3, 0, 9);
  operands[11] = x11;
  x12 = XVECEXP (x3, 0, 10);
  operands[12] = x12;
  x13 = XVECEXP (x3, 0, 11);
  operands[13] = x13;
  x14 = XVECEXP (x3, 0, 12);
  operands[14] = x14;
  x15 = XVECEXP (x3, 0, 13);
  operands[15] = x15;
  x16 = XVECEXP (x3, 0, 14);
  operands[16] = x16;
  x17 = XVECEXP (x3, 0, 15);
  operands[17] = x17;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x2) != E_V16SFmode
          || !register_operand (operands[1], E_V16SFmode)
          || pattern1814 () != 0
          || !(
#line 20453 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 8360; /* *avx512f_shuf_f32x4_1_1 */

    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x2) != E_V16SImode)
        return -1;
      if (register_operand (operands[1], E_V16SImode)
          && pattern1814 () == 0
          && (
#line 20453 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return 8362; /* *avx512f_shuf_i32x4_1_1 */
      if (!nonimmediate_operand (operands[1], E_V16SImode)
          || pattern1692 () != 0
          || !const_8_to_11_operand (operands[10], E_VOIDmode)
          || !const_8_to_11_operand (operands[11], E_VOIDmode)
          || !const_8_to_11_operand (operands[12], E_VOIDmode)
          || !const_8_to_11_operand (operands[13], E_VOIDmode)
          || !const_12_to_15_operand (operands[14], E_VOIDmode)
          || !const_12_to_15_operand (operands[15], E_VOIDmode)
          || !const_12_to_15_operand (operands[16], E_VOIDmode)
          || !const_12_to_15_operand (operands[17], E_VOIDmode)
          || !
#line 20535 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512
   && INTVAL (operands[2]) + 4 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 4 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 4 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 4 == INTVAL (operands[9])
   && INTVAL (operands[2]) + 8 == INTVAL (operands[10])
   && INTVAL (operands[3]) + 8 == INTVAL (operands[11])
   && INTVAL (operands[4]) + 8 == INTVAL (operands[12])
   && INTVAL (operands[5]) + 8 == INTVAL (operands[13])
   && INTVAL (operands[2]) + 12 == INTVAL (operands[14])
   && INTVAL (operands[3]) + 12 == INTVAL (operands[15])
   && INTVAL (operands[4]) + 12 == INTVAL (operands[16])
   && INTVAL (operands[5]) + 12 == INTVAL (operands[17])))
        return -1;
      return 8364; /* avx512f_pshufd_1 */

    default:
      return -1;
    }
}

 int
recog_303 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern529 (x2))
        {
        case 0:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5448; /* *avx512bw_vpternlogv64qi_1 */

        case 1:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5475; /* *avx512vl_vpternlogv32qi_1 */

        case 2:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5502; /* *avx512vl_vpternlogv16qi_1 */

        case 3:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5529; /* *avx512bw_vpternlogv32hi_1 */

        case 4:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5556; /* *avx512vl_vpternlogv16hi_1 */

        case 5:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5583; /* *avx512vl_vpternlogv8hi_1 */

        case 6:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5610; /* *avx512f_vpternlogv16si_1 */

        case 7:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5637; /* *avx512vl_vpternlogv8si_1 */

        case 8:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5664; /* *avx512vl_vpternlogv4si_1 */

        case 9:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5691; /* *avx512f_vpternlogv8di_1 */

        case 10:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5718; /* *avx512vl_vpternlogv4di_1 */

        case 11:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5745; /* *avx512vl_vpternlogv2di_1 */

        case 12:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5451; /* *avx512bw_vpternlogv64qi_1 */

        case 13:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5478; /* *avx512vl_vpternlogv32qi_1 */

        case 14:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5505; /* *avx512vl_vpternlogv16qi_1 */

        case 15:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5532; /* *avx512bw_vpternlogv32hi_1 */

        case 16:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5559; /* *avx512vl_vpternlogv16hi_1 */

        case 17:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5586; /* *avx512vl_vpternlogv8hi_1 */

        case 18:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5613; /* *avx512f_vpternlogv16si_1 */

        case 19:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5640; /* *avx512vl_vpternlogv8si_1 */

        case 20:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5667; /* *avx512vl_vpternlogv4si_1 */

        case 21:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5694; /* *avx512f_vpternlogv8di_1 */

        case 22:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5721; /* *avx512vl_vpternlogv4di_1 */

        case 23:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5748; /* *avx512vl_vpternlogv2di_1 */

        case 24:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5454; /* *avx512bw_vpternlogv64qi_1 */

        case 25:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5481; /* *avx512vl_vpternlogv32qi_1 */

        case 26:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5508; /* *avx512vl_vpternlogv16qi_1 */

        case 27:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5535; /* *avx512bw_vpternlogv32hi_1 */

        case 28:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5562; /* *avx512vl_vpternlogv16hi_1 */

        case 29:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5589; /* *avx512vl_vpternlogv8hi_1 */

        case 30:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5616; /* *avx512f_vpternlogv16si_1 */

        case 31:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5643; /* *avx512vl_vpternlogv8si_1 */

        case 32:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5670; /* *avx512vl_vpternlogv4si_1 */

        case 33:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5697; /* *avx512f_vpternlogv8di_1 */

        case 34:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5724; /* *avx512vl_vpternlogv4di_1 */

        case 35:
          if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5751; /* *avx512vl_vpternlogv2di_1 */

        case 36:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6732; /* *avx512bw_vpternlogv64qi_3 */

        case 37:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6741; /* *avx512vl_vpternlogv32qi_3 */

        case 38:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6750; /* *avx512vl_vpternlogv16qi_3 */

        case 39:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6759; /* *avx512bw_vpternlogv32hi_3 */

        case 40:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6768; /* *avx512vl_vpternlogv16hi_3 */

        case 41:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6777; /* *avx512vl_vpternlogv8hi_3 */

        case 42:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6786; /* *avx512f_vpternlogv16si_3 */

        case 43:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6795; /* *avx512vl_vpternlogv8si_3 */

        case 44:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6804; /* *avx512vl_vpternlogv4si_3 */

        case 45:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6813; /* *avx512f_vpternlogv8di_3 */

        case 46:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6822; /* *avx512vl_vpternlogv4di_3 */

        case 47:
          if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6831; /* *avx512vl_vpternlogv2di_3 */

        default:
          return -1;
        }

    case AND:
      switch (pattern531 (x2))
        {
        case 0:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6096; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6123; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6150; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6177; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6204; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6231; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6258; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6285; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6312; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6339; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6366; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6393; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6099; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6126; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6153; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6180; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6207; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6234; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6261; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6288; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6315; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6342; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6369; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6396; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case XOR:
      switch (pattern531 (x2))
        {
        case 0:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6102; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6129; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6156; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6183; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6210; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6237; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6264; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6291; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6318; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6345; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6372; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6399; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_312 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      operands[1] = x3;
      x4 = XEXP (x2, 1);
      operands[2] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V16BFmode:
          if (pattern25 (x2, 
E_V16BFmode) != 0
              || !(
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 426 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3674; /* *iorv16bf3 */

        case E_V8BFmode:
          if (pattern25 (x2, 
E_V8BFmode) != 0
              || !(
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 426 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3677; /* *iorv8bf3 */

        case E_V16HFmode:
          if (pattern25 (x2, 
E_V16HFmode) != 0
              || !(
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 427 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3680; /* *iorv16hf3 */

        case E_V8HFmode:
          if (pattern25 (x2, 
E_V8HFmode) != 0
              || !(
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 16 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 427 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3683; /* *iorv8hf3 */

        case E_V8SFmode:
          if (pattern25 (x2, 
E_V8SFmode) != 0
              || !(
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 428 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3687; /* *iorv8sf3 */

        case E_V4SFmode:
          if (pattern25 (x2, 
E_V4SFmode) != 0
              || !
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 32 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 3693; /* *iorv4sf3 */

        case E_V4DFmode:
          if (pattern25 (x2, 
E_V4DFmode) != 0
              || !(
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3699; /* *iorv4df3 */

        case E_V2DFmode:
          if (pattern25 (x2, 
E_V2DFmode) != 0
              || !(
#line 5366 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && (!false || 64 != 16)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 429 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3705; /* *iorv2df3 */

        case E_V32BFmode:
          if (pattern5 (x2, 
E_V32BFmode) != 0
              || !(
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 16 != 16)) && 
#line 491 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 3710; /* *iorv32bf3 */

        case E_V32HFmode:
          if (pattern5 (x2, 
E_V32HFmode) != 0
              || !(
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 16 != 16)) && 
#line 492 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 3713; /* *iorv32hf3 */

        case E_V16SFmode:
          if (pattern5 (x2, 
E_V16SFmode) != 0
              || !(
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 32 != 16)) && 
#line 493 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 3717; /* *iorv16sf3 */

        case E_V8DFmode:
          if (pattern5 (x2, 
E_V8DFmode) != 0
              || !(
#line 5436 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (!false || 64 != 16)) && 
#line 494 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 3723; /* *iorv8df3 */

        case E_V16SImode:
          if (pattern182 (x2, 
E_V16SImode) != 0
              || !(
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (IOR, V16SImode, operands)) && 
#line 807 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 7933; /* *iorv16si3 */

        case E_V8SImode:
          if (pattern182 (x2, 
E_V8SImode) != 0
              || !(
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (IOR, V8SImode, operands)) && 
#line 807 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 7939; /* *iorv8si3 */

        case E_V4SImode:
          if (pattern182 (x2, 
E_V4SImode) != 0
              || !
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (IOR, V4SImode, operands)))
            return -1;
          return 7945; /* *iorv4si3 */

        case E_V8DImode:
          if (pattern182 (x2, 
E_V8DImode) != 0
              || !(
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (IOR, V8DImode, operands)) && 
#line 808 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 7951; /* *iorv8di3 */

        case E_V4DImode:
          if (pattern182 (x2, 
E_V4DImode) != 0
              || !(
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (IOR, V4DImode, operands)) && 
#line 808 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 7957; /* *iorv4di3 */

        case E_V2DImode:
          if (pattern182 (x2, 
E_V2DImode) != 0
              || !
#line 18717 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && 1
   && ix86_binary_operator_ok (IOR, V2DImode, operands)))
            return -1;
          return 7963; /* *iorv2di3 */

        case E_V64QImode:
          if (pattern25 (x2, 
E_V64QImode) != 0
              || !(
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 811 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 7968; /* *iorv64qi3 */

        case E_V32QImode:
          if (pattern25 (x2, 
E_V32QImode) != 0
              || !(
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 811 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 7971; /* *iorv32qi3 */

        case E_V16QImode:
          if (pattern25 (x2, 
E_V16QImode) != 0
              || !
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7974; /* *iorv16qi3 */

        case E_V32HImode:
          if (pattern25 (x2, 
E_V32HImode) != 0
              || !(
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 812 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 7977; /* *iorv32hi3 */

        case E_V16HImode:
          if (pattern25 (x2, 
E_V16HImode) != 0
              || !(
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 812 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 7980; /* *iorv16hi3 */

        case E_V8HImode:
          if (pattern25 (x2, 
E_V8HImode) != 0
              || !
#line 18819 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 7983; /* *iorv8hi3 */

        case E_V1TImode:
          if (pattern664 (x2, 
E_V1TImode) != 0
              || !
#line 18916 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 7986; /* iorv1ti3 */

        default:
          return -1;
        }

    case AND:
      x5 = XEXP (x3, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern529 (x2))
            {
            case 0:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5429; /* *avx512bw_vpternlogv64qi_1 */

            case 1:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5456; /* *avx512vl_vpternlogv32qi_1 */

            case 2:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5483; /* *avx512vl_vpternlogv16qi_1 */

            case 3:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5510; /* *avx512bw_vpternlogv32hi_1 */

            case 4:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5537; /* *avx512vl_vpternlogv16hi_1 */

            case 5:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5564; /* *avx512vl_vpternlogv8hi_1 */

            case 6:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5591; /* *avx512f_vpternlogv16si_1 */

            case 7:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5618; /* *avx512vl_vpternlogv8si_1 */

            case 8:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5645; /* *avx512vl_vpternlogv4si_1 */

            case 9:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5672; /* *avx512f_vpternlogv8di_1 */

            case 10:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5699; /* *avx512vl_vpternlogv4di_1 */

            case 11:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5726; /* *avx512vl_vpternlogv2di_1 */

            case 12:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5432; /* *avx512bw_vpternlogv64qi_1 */

            case 13:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5459; /* *avx512vl_vpternlogv32qi_1 */

            case 14:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5486; /* *avx512vl_vpternlogv16qi_1 */

            case 15:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5513; /* *avx512bw_vpternlogv32hi_1 */

            case 16:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5540; /* *avx512vl_vpternlogv16hi_1 */

            case 17:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5567; /* *avx512vl_vpternlogv8hi_1 */

            case 18:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5594; /* *avx512f_vpternlogv16si_1 */

            case 19:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5621; /* *avx512vl_vpternlogv8si_1 */

            case 20:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5648; /* *avx512vl_vpternlogv4si_1 */

            case 21:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5675; /* *avx512f_vpternlogv8di_1 */

            case 22:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5702; /* *avx512vl_vpternlogv4di_1 */

            case 23:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5729; /* *avx512vl_vpternlogv2di_1 */

            case 24:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5435; /* *avx512bw_vpternlogv64qi_1 */

            case 25:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5462; /* *avx512vl_vpternlogv32qi_1 */

            case 26:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5489; /* *avx512vl_vpternlogv16qi_1 */

            case 27:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5516; /* *avx512bw_vpternlogv32hi_1 */

            case 28:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5543; /* *avx512vl_vpternlogv16hi_1 */

            case 29:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5570; /* *avx512vl_vpternlogv8hi_1 */

            case 30:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5597; /* *avx512f_vpternlogv16si_1 */

            case 31:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5624; /* *avx512vl_vpternlogv8si_1 */

            case 32:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5651; /* *avx512vl_vpternlogv4si_1 */

            case 33:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5678; /* *avx512f_vpternlogv8di_1 */

            case 34:
              if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5705; /* *avx512vl_vpternlogv4di_1 */

            case 35:
              if (!
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5732; /* *avx512vl_vpternlogv2di_1 */

            case 36:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6725; /* *avx512bw_vpternlogv64qi_3 */

            case 37:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6734; /* *avx512vl_vpternlogv32qi_3 */

            case 38:
              if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6743; /* *avx512vl_vpternlogv16qi_3 */

            case 39:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6752; /* *avx512bw_vpternlogv32hi_3 */

            case 40:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6761; /* *avx512vl_vpternlogv16hi_3 */

            case 41:
              if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6770; /* *avx512vl_vpternlogv8hi_3 */

            case 42:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6779; /* *avx512f_vpternlogv16si_3 */

            case 43:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6788; /* *avx512vl_vpternlogv8si_3 */

            case 44:
              if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6797; /* *avx512vl_vpternlogv4si_3 */

            case 45:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6806; /* *avx512f_vpternlogv8di_3 */

            case 46:
              if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6815; /* *avx512vl_vpternlogv4di_3 */

            case 47:
              if (!
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6824; /* *avx512vl_vpternlogv2di_3 */

            default:
              return -1;
            }

        case AND:
          switch (pattern531 (x2))
            {
            case 0:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6077; /* *avx512bw_vpternlogv64qi_2 */

            case 1:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6104; /* *avx512vl_vpternlogv32qi_2 */

            case 2:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6131; /* *avx512vl_vpternlogv16qi_2 */

            case 3:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6158; /* *avx512bw_vpternlogv32hi_2 */

            case 4:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6185; /* *avx512vl_vpternlogv16hi_2 */

            case 5:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6212; /* *avx512vl_vpternlogv8hi_2 */

            case 6:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6239; /* *avx512f_vpternlogv16si_2 */

            case 7:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6266; /* *avx512vl_vpternlogv8si_2 */

            case 8:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6293; /* *avx512vl_vpternlogv4si_2 */

            case 9:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6320; /* *avx512f_vpternlogv8di_2 */

            case 10:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6347; /* *avx512vl_vpternlogv4di_2 */

            case 11:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6374; /* *avx512vl_vpternlogv2di_2 */

            default:
              return -1;
            }

        case IOR:
          switch (pattern531 (x2))
            {
            case 0:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6080; /* *avx512bw_vpternlogv64qi_2 */

            case 1:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6107; /* *avx512vl_vpternlogv32qi_2 */

            case 2:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6134; /* *avx512vl_vpternlogv16qi_2 */

            case 3:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6161; /* *avx512bw_vpternlogv32hi_2 */

            case 4:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6188; /* *avx512vl_vpternlogv16hi_2 */

            case 5:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6215; /* *avx512vl_vpternlogv8hi_2 */

            case 6:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6242; /* *avx512f_vpternlogv16si_2 */

            case 7:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6269; /* *avx512vl_vpternlogv8si_2 */

            case 8:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6296; /* *avx512vl_vpternlogv4si_2 */

            case 9:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6323; /* *avx512f_vpternlogv8di_2 */

            case 10:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6350; /* *avx512vl_vpternlogv4di_2 */

            case 11:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6377; /* *avx512vl_vpternlogv2di_2 */

            default:
              return -1;
            }

        case XOR:
          switch (pattern531 (x2))
            {
            case 0:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6083; /* *avx512bw_vpternlogv64qi_2 */

            case 1:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6110; /* *avx512vl_vpternlogv32qi_2 */

            case 2:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6137; /* *avx512vl_vpternlogv16qi_2 */

            case 3:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6164; /* *avx512bw_vpternlogv32hi_2 */

            case 4:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6191; /* *avx512vl_vpternlogv16hi_2 */

            case 5:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6218; /* *avx512vl_vpternlogv8hi_2 */

            case 6:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6245; /* *avx512f_vpternlogv16si_2 */

            case 7:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6272; /* *avx512vl_vpternlogv8si_2 */

            case 8:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6299; /* *avx512vl_vpternlogv4si_2 */

            case 9:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6326; /* *avx512f_vpternlogv8di_2 */

            case 10:
              if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6353; /* *avx512vl_vpternlogv4di_2 */

            case 11:
              if (!
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6380; /* *avx512vl_vpternlogv2di_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case IOR:
      return recog_302 (x1, insn, pnum_clobbers);

    case XOR:
      return recog_301 (x1, insn, pnum_clobbers);

    case NOT:
      switch (pattern337 (x2))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_V16SImode:
              if (pattern921 (x2, 
E_V16SImode) != 0
                  || !(
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16SImode)
       || register_operand (operands[2], V16SImode))) && 
#line 568 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7988; /* *iornotv16si3 */

            case E_V8DImode:
              if (pattern921 (x2, 
E_V8DImode) != 0
                  || !(
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8DImode)
       || register_operand (operands[2], V8DImode))) && 
#line 569 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 7989; /* *iornotv8di3 */

            case E_V64QImode:
              if (pattern921 (x2, 
E_V64QImode) != 0
                  || !(
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V64QImode)
       || register_operand (operands[2], V64QImode))) && 
#line 570 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 7990; /* *iornotv64qi3 */

            case E_V32QImode:
              if (pattern921 (x2, 
E_V32QImode) != 0
                  || !(
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V32QImode)
       || register_operand (operands[2], V32QImode))) && 
#line 570 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7991; /* *iornotv32qi3 */

            case E_V16QImode:
              if (pattern921 (x2, 
E_V16QImode) != 0
                  || !
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16QImode)
       || register_operand (operands[2], V16QImode))))
                return -1;
              return 7992; /* *iornotv16qi3 */

            case E_V32HImode:
              if (pattern921 (x2, 
E_V32HImode) != 0
                  || !(
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V32HImode)
       || register_operand (operands[2], V32HImode))) && 
#line 571 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
                return -1;
              return 7993; /* *iornotv32hi3 */

            case E_V16HImode:
              if (pattern921 (x2, 
E_V16HImode) != 0
                  || !(
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16HImode)
       || register_operand (operands[2], V16HImode))) && 
#line 571 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7994; /* *iornotv16hi3 */

            case E_V8HImode:
              if (pattern921 (x2, 
E_V8HImode) != 0
                  || !
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8HImode)
       || register_operand (operands[2], V8HImode))))
                return -1;
              return 7995; /* *iornotv8hi3 */

            case E_V8SImode:
              if (pattern921 (x2, 
E_V8SImode) != 0
                  || !(
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8SImode)
       || register_operand (operands[2], V8SImode))) && 
#line 572 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7996; /* *iornotv8si3 */

            case E_V4SImode:
              if (pattern921 (x2, 
E_V4SImode) != 0
                  || !
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V4SImode)
       || register_operand (operands[2], V4SImode))))
                return -1;
              return 7997; /* *iornotv4si3 */

            case E_V4DImode:
              if (pattern921 (x2, 
E_V4DImode) != 0
                  || !(
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V4DImode)
       || register_operand (operands[2], V4DImode))) && 
#line 573 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 7998; /* *iornotv4di3 */

            case E_V2DImode:
              if (pattern921 (x2, 
E_V2DImode) != 0
                  || !
#line 18943 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V2DImode)
       || register_operand (operands[2], V2DImode))))
                return -1;
              return 7999; /* *iornotv2di3 */

            default:
              return -1;
            }

        case 1:
          if (!(
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16SImode)
       || register_operand (operands[2], V16SImode))) && 
#line 568 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 8013; /* *nandv16si3 */

        case 2:
          if (!(
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8DImode)
       || register_operand (operands[2], V8DImode))) && 
#line 569 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 8015; /* *nandv8di3 */

        case 3:
          if (!(
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V64QImode)
       || register_operand (operands[2], V64QImode))) && 
#line 570 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8017; /* *nandv64qi3 */

        case 4:
          if (!(
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V32QImode)
       || register_operand (operands[2], V32QImode))) && 
#line 570 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 8019; /* *nandv32qi3 */

        case 5:
          if (!
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16QImode)
       || register_operand (operands[2], V16QImode))))
            return -1;
          return 8021; /* *nandv16qi3 */

        case 6:
          if (!(
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V32HImode)
       || register_operand (operands[2], V32HImode))) && 
#line 571 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8023; /* *nandv32hi3 */

        case 7:
          if (!(
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V16HImode)
       || register_operand (operands[2], V16HImode))) && 
#line 571 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 8025; /* *nandv16hi3 */

        case 8:
          if (!
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8HImode)
       || register_operand (operands[2], V8HImode))))
            return -1;
          return 8027; /* *nandv8hi3 */

        case 9:
          if (!(
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V8SImode)
       || register_operand (operands[2], V8SImode))) && 
#line 572 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 8029; /* *nandv8si3 */

        case 10:
          if (!
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V4SImode)
       || register_operand (operands[2], V4SImode))))
            return -1;
          return 8031; /* *nandv4si3 */

        case 11:
          if (!(
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V4DImode)
       || register_operand (operands[2], V4DImode))) && 
#line 573 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 8033; /* *nandv4di3 */

        case 12:
          if (!
#line 19007 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && (register_operand (operands[1], V2DImode)
       || register_operand (operands[2], V2DImode))))
            return -1;
          return 8035; /* *nandv2di3 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_337 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern26 (x1))
    {
    case 0:
      if (!(
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 389 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 2986; /* *sminv32hf3 */

    case 1:
      if (!(
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 390 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 2992; /* *sminv16hf3 */

    case 2:
      if (!(
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 391 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 2996; /* *sminv8hf3 */

    case 3:
      if (!(
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 3002; /* *sminv16sf3 */

    case 4:
      if (!(
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 392 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 3008; /* *sminv8sf3 */

    case 5:
      if (!
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1))
        return -1;
      return 3012; /* *sminv4sf3 */

    case 6:
      if (!(
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 3018; /* *sminv8df3 */

    case 7:
      if (!(
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 393 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 3024; /* *sminv4df3 */

    case 8:
      if (!(
#line 3309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && 1
   && 1) && 
#line 394 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 3028; /* *sminv2df3 */

    case 9:
      if (
#line 17653 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7686; /* *avx2_sminv32qi3 */
      if (!(
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7763; /* *avx512bw_sminv32qi3 */

    case 10:
      if (
#line 17653 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7690; /* *avx2_sminv16hi3 */
      if (!(
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7779; /* *avx512bw_sminv16hi3 */

    case 11:
      if (
#line 17653 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7694; /* *avx2_sminv8si3 */
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7707; /* *avx512f_sminv8si3 */

    case 12:
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7699; /* *avx512f_sminv16si3 */

    case 13:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonimmediate_operand (operands[2], E_V4SImode)
          && (
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7715; /* *avx512f_sminv4si3 */
      if (!vector_operand (operands[1], E_V4SImode)
          || !vector_operand (operands[2], E_V4SImode)
          || !
#line 17797 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7799; /* *sse4_1_sminv4si3 */

    case 14:
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7723; /* *avx512f_sminv8di3 */

    case 15:
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7731; /* *avx512f_sminv4di3 */

    case 16:
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7739; /* *avx512f_sminv2di3 */

    case 17:
      if (!(
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7747; /* *avx512bw_sminv64qi3 */

    case 18:
      if (nonimmediate_operand (operands[1], E_V16QImode)
          && nonimmediate_operand (operands[2], E_V16QImode)
          && (
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7755; /* *avx512bw_sminv16qi3 */
      if (!vector_operand (operands[1], E_V16QImode)
          || !vector_operand (operands[2], E_V16QImode)
          || !
#line 17797 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7795; /* *sse4_1_sminv16qi3 */

    case 19:
      if (!(
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7771; /* *avx512bw_sminv32hi3 */

    case 20:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonimmediate_operand (operands[2], E_V8HImode)
          && (
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7787; /* *avx512bw_sminv8hi3 */
      if (!vector_operand (operands[1], E_V8HImode)
          || !vector_operand (operands[2], E_V8HImode)
          || !
#line 17816 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7802; /* *sminv8hi3 */

    case 21:
      if (!
#line 32121 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10520; /* avx10_2_sminbf16_v32bf */

    case 22:
      if (!
#line 32121 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10524; /* avx10_2_sminbf16_v16bf */

    case 23:
      if (!
#line 32121 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
        return -1;
      return 10528; /* avx10_2_sminbf16_v8bf */

    default:
      return -1;
    }
}

 int
recog_344 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern33 (x1))
    {
    case 0:
      if (
#line 17653 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7687; /* *avx2_umaxv32qi3 */
      if (!(
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7765; /* *avx512bw_umaxv32qi3 */

    case 1:
      if (
#line 17653 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7691; /* *avx2_umaxv16hi3 */
      if (!(
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7781; /* *avx512bw_umaxv16hi3 */

    case 2:
      if (
#line 17653 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return 7695; /* *avx2_umaxv8si3 */
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7709; /* *avx512f_umaxv8si3 */

    case 3:
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7701; /* *avx512f_umaxv16si3 */

    case 4:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonimmediate_operand (operands[2], E_V4SImode)
          && (
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7717; /* *avx512f_umaxv4si3 */
      if (!vector_operand (operands[1], E_V4SImode)
          || !vector_operand (operands[2], E_V4SImode)
          || !
#line 17881 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7807; /* *sse4_1_umaxv4si3 */

    case 5:
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7725; /* *avx512f_umaxv8di3 */

    case 6:
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7733; /* *avx512f_umaxv4di3 */

    case 7:
      if (!(
#line 17694 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7741; /* *avx512f_umaxv2di3 */

    case 8:
      if (!(
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7749; /* *avx512bw_umaxv64qi3 */

    case 9:
      if (nonimmediate_operand (operands[1], E_V16QImode)
          && nonimmediate_operand (operands[2], E_V16QImode)
          && (
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7757; /* *avx512bw_umaxv16qi3 */
      if (!vector_operand (operands[1], E_V16QImode)
          || !vector_operand (operands[2], E_V16QImode)
          || !
#line 17900 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7811; /* *umaxv16qi3 */

    case 10:
      if (!(
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7773; /* *avx512bw_umaxv32hi3 */

    case 11:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonimmediate_operand (operands[2], E_V8HImode)
          && (
#line 17705 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7789; /* *avx512bw_umaxv8hi3 */
      if (!vector_operand (operands[1], E_V8HImode)
          || !vector_operand (operands[2], E_V8HImode)
          || !
#line 17881 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && 1
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
        return -1;
      return 7803; /* *sse4_1_umaxv8hi3 */

    default:
      return -1;
    }
}

 int
recog_353 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x4))
    {
    case CLOBBER:
      x5 = XEXP (x2, 1);
      operands[1] = x5;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case MEM:
          if (GET_MODE (x6) != E_BLKmode)
            return -1;
          x7 = XEXP (x6, 0);
          if (GET_CODE (x7) != SCRATCH)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (push_operand (operands[0], E_SImode)
                  && general_no_elim_operand (operands[1], E_SImode)
                  && 
#line 1403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
                return 74; /* *pushsi2_prologue */
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || !pop_operand (operands[1], E_SImode)
                  || !
#line 1403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
                return -1;
              return 78; /* *popsi1_epilogue */

            case E_DImode:
              if (push_operand (operands[0], E_DImode)
                  && general_no_elim_operand (operands[1], E_DImode)
                  && 
#line 1403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
                return 75; /* *pushdi2_prologue */
              if (!nonimmediate_operand (operands[0], E_DImode)
                  || !pop_operand (operands[1], E_DImode)
                  || !
#line 1403 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
                return -1;
              return 79; /* *popdi1_epilogue */

            default:
              return -1;
            }

        case REG:
          if (REGNO (x6) != 17
              || GET_MODE (x6) != E_CCmode)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (const0_operand (operands[1], E_SImode))
                {
                  if (register_operand (operands[0], E_SImode)
                      && 
#line 2424 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                    return 84; /* *movsi_xor */
                  if (memory_operand (operands[0], E_SImode)
                      && 
#line 2436 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                    return 87; /* *movsi_and */
                }
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || !constm1_operand (operands[1], E_SImode)
                  || !
#line 2451 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return -1;
              return 90; /* *movsi_or */

            case E_DImode:
              if (const0_operand (operands[1], E_DImode))
                {
                  if (register_operand (operands[0], E_DImode)
                      && (
#line 2424 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 85; /* *movdi_xor */
                  if (memory_operand (operands[0], E_DImode)
                      && (
#line 2436 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 88; /* *movdi_and */
                }
              if (!nonimmediate_operand (operands[0], E_DImode)
                  || !constm1_operand (operands[1], E_DImode)
                  || !(
#line 2451 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 91; /* *movdi_or */

            case E_HImode:
              if (memory_operand (operands[0], E_HImode)
                  && const0_operand (operands[1], E_HImode)
                  && 
#line 2436 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return 86; /* *movhi_and */
              if (!nonimmediate_operand (operands[0], E_HImode)
                  || !constm1_operand (operands[1], E_HImode)
                  || !
#line 2451 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return -1;
              return 89; /* *movhi_or */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SET:
      x8 = XEXP (x4, 1);
      switch (GET_CODE (x8))
        {
        case REG:
        case SUBREG:
          if (!rtx_equal_p (x8, operands[0]))
            return -1;
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          x6 = XEXP (x4, 0);
          if (!rtx_equal_p (x6, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !register_operand (operands[1], E_SImode))
                return -1;
              return 107; /* swapsi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !register_operand (operands[1], E_DImode)
                  || !
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 108; /* swapdi */

            case E_QImode:
              if (!register_operand (operands[0], E_QImode)
                  || !register_operand (operands[1], E_QImode))
                return -1;
              return 109; /* *swapqi */

            case E_HImode:
              if (!register_operand (operands[0], E_HImode)
                  || !register_operand (operands[1], E_HImode))
                return -1;
              return 110; /* *swaphi */

            case E_XFmode:
              if (!register_operand (operands[0], E_XFmode)
                  || !register_operand (operands[1], E_XFmode)
                  || !
#line 4656 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 173; /* *swapxf */

            default:
              return -1;
            }

        case UNSPEC:
          if (XVECLEN (x8, 0) != 1
              || XINT (x8, 1) != 72
              || GET_MODE (x8) != E_XFmode
              || !register_operand (operands[0], E_SFmode))
            return -1;
          x5 = XEXP (x2, 1);
          operands[3] = x5;
          if (!const1_operand (operands[3], E_SFmode))
            return -1;
          x6 = XEXP (x4, 0);
          operands[1] = x6;
          if (!register_operand (operands[1], E_XFmode))
            return -1;
          x9 = XVECEXP (x8, 0, 0);
          operands[2] = x9;
          if (!register_operand (operands[2], E_XFmode)
              || !
#line 24123 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
            return -1;
          return 1720; /* fptanxf4_i387 */

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x4, 0) != 1
          || XINT (x4, 1) != 108
          || GET_MODE (x4) != E_DImode)
        return -1;
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x5 = XEXP (x2, 1);
      operands[1] = x5;
      if (register_operand (operands[1], E_DImode)
          && push_operand (operands[0], E_DImode)
          && 
#line 3922 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return 161; /* pushp_di */
      if (!pop_operand (operands[1], E_DImode)
          || !register_operand (operands[0], E_DImode)
          || !
#line 3930 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_PPX))
        return -1;
      return 162; /* popp_di */

    default:
      return -1;
    }
}

 int
recog_365 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  if (pattern340 (x1) != 0)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x3) != E_HImode
              || GET_MODE (x4) != E_QImode
              || !nonimmediate_operand (operands[1], E_QImode)
              || !general_operand (operands[2], E_QImode)
              || !
#line 6689 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 287; /* *addqi_1_zexthi */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !general_operand (operands[2], E_QImode)
                  || !
#line 6689 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 289; /* *addqi_1_zextsi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !general_operand (operands[2], E_HImode)
                  || !
#line 6727 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 293; /* *addhi_1_zextsi */

            default:
              return -1;
            }

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !general_operand (operands[2], E_QImode)
                  || !
#line 6689 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 291; /* *addqi_1_zextdi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !general_operand (operands[2], E_HImode)
                  || !
#line 6727 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 295; /* *addhi_1_zextdi */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !x86_64_general_operand (operands[2], E_SImode)
                  || !
#line 6772 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 296; /* addsi_1_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      x7 = XEXP (x5, 0);
      switch (GET_CODE (x7))
        {
        case LTU:
        case UNLT:
          operands[3] = x7;
          x8 = XEXP (x7, 0);
          if (GET_CODE (x8) != REG
              || REGNO (x8) != 17)
            return -1;
          x9 = XEXP (x7, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x10 = XEXP (x5, 1);
          operands[1] = x10;
          x6 = XEXP (x4, 1);
          operands[2] = x6;
          switch (pattern1138 (x3))
            {
            case 0:
              if (pattern1734 (x5, 
E_QImode) != 0
                  || !
#line 8907 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 465; /* *addqi3_carry_zexthi */

            case 1:
              if (pattern1734 (x5, 
E_QImode) != 0
                  || !
#line 8907 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 466; /* *addqi3_carry_zextsi */

            case 2:
              if (pattern1734 (x5, 
E_HImode) != 0
                  || !
#line 8926 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 468; /* *addhi3_carry_zextsi */

            case 3:
              if (pattern1734 (x5, 
E_QImode) != 0
                  || !
#line 8907 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 467; /* *addqi3_carry_zextdi */

            case 4:
              if (pattern1734 (x5, 
E_HImode) != 0
                  || !
#line 8926 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 469; /* *addhi3_carry_zextdi */

            case 5:
              if (pattern1734 (x5, 
E_SImode) != 0
                  || !
#line 8945 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 470; /* *addsi3_carry_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case LTU:
    case UNLT:
      switch (pattern1139 (x3))
        {
        case 0:
          if (!ix86_carry_flag_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 8964 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 471; /* *addqi3_carry_zexthi_0 */

        case 1:
          if (!ix86_carry_flag_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 8964 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 472; /* *addqi3_carry_zextsi_0 */

        case 2:
          if (!ix86_carry_flag_operator (operands[2], E_HImode)
              || !nonimmediate_operand (operands[1], E_HImode)
              || !
#line 8978 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 474; /* *addhi3_carry_zextsi_0 */

        case 3:
          if (!ix86_carry_flag_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 8964 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 473; /* *addqi3_carry_zextdi_0 */

        case 4:
          if (!ix86_carry_flag_operator (operands[2], E_HImode)
              || !nonimmediate_operand (operands[1], E_HImode)
              || !
#line 8978 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 475; /* *addhi3_carry_zextdi_0 */

        case 5:
          if (!ix86_carry_flag_operator (operands[2], E_SImode)
              || !nonimmediate_operand (operands[1], E_SImode)
              || !
#line 8992 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 476; /* *addsi3_carry_zext_0 */

        default:
          return -1;
        }

    case GE:
    case GEU:
      switch (pattern1139 (x3))
        {
        case 0:
          if (!ix86_carry_flag_unset_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 9009 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 477; /* *addqi3_carry_zexthi_0r */

        case 1:
          if (!ix86_carry_flag_unset_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 9009 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 478; /* *addqi3_carry_zextsi_0r */

        case 2:
          if (!ix86_carry_flag_unset_operator (operands[2], E_HImode)
              || !nonimmediate_operand (operands[1], E_HImode)
              || !
#line 9023 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 480; /* *addhi3_carry_zextsi_0r */

        case 3:
          if (!ix86_carry_flag_unset_operator (operands[2], E_QImode)
              || !nonimmediate_operand (operands[1], E_QImode)
              || !
#line 9009 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 479; /* *addqi3_carry_zextdi_0r */

        case 4:
          if (!ix86_carry_flag_unset_operator (operands[2], E_HImode)
              || !nonimmediate_operand (operands[1], E_HImode)
              || !
#line 9023 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
            return -1;
          return 481; /* *addhi3_carry_zextdi_0r */

        case 5:
          if (!ix86_carry_flag_unset_operator (operands[2], E_SImode)
              || !nonimmediate_operand (operands[1], E_SImode)
              || !
#line 9037 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 482; /* *addsi3_carry_zext_0r */

        default:
          return -1;
        }

    case UNSPEC:
      if (pattern1140 (x5) != 0
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode
          || GET_MODE (x4) != E_SImode)
        return -1;
      x6 = XEXP (x4, 1);
      operands[1] = x6;
      if (!register_operand (operands[1], E_SImode)
          || !
#line 23269 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_X32))
        return -1;
      return 1663; /* *add_tp_x32_zext */

    default:
      return -1;
    }
}

 int
recog_367 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      if (pattern340 (x1) != 0)
        return -1;
      switch (pattern1137 (x3))
        {
        case 0:
          if (!
#line 4851 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)))
            return -1;
          return 178; /* zero_extendqisi2_and */

        case 1:
          if (!
#line 4851 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)))
            return -1;
          return 179; /* zero_extendhisi2_and */

        case 2:
          if (!
#line 4905 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)))
            return -1;
          return 182; /* zero_extendqihi2_and */

        default:
          return -1;
        }

    case PLUS:
      return recog_365 (x1, insn, pnum_clobbers);

    case MINUS:
      return recog_366 (x1, insn, pnum_clobbers);

    case MULT:
      if (pattern341 (x1) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || GET_MODE (x4) != E_HImode
              || !nonimmediate_operand (operands[1], E_HImode)
              || !immediate_operand (operands[2], E_HImode)
              || !
#line 10655 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_ZU && true))
            return -1;
          return 597; /* *imulhisizu */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !immediate_operand (operands[2], E_HImode)
                  || !
#line 10655 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_ZU && true))
                return -1;
              return 599; /* *imulhidizu */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !x86_64_general_operand (operands[2], E_SImode)
                  || !
#line 10667 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
                return -1;
              return 601; /* *mulsi3_1_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case DIV:
      if (pattern342 (x1, pnum_clobbers, 
MOD) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x6 = XEXP (x4, 1);
      operands[3] = x6;
      if (!nonimmediate_operand (operands[3], E_SImode))
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[1] = x8;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      x9 = XEXP (x7, 1);
      x10 = XEXP (x9, 0);
      if (!rtx_equal_p (x10, operands[2]))
        return -1;
      x11 = XEXP (x9, 1);
      if (!rtx_equal_p (x11, operands[3])
          || !
#line 11696 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 655; /* *divmodsi4_zext_1 */

    case UDIV:
      if (pattern342 (x1, pnum_clobbers, 
UMOD) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x6 = XEXP (x4, 1);
      operands[3] = x6;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[1] = x8;
      if (!register_operand (operands[1], E_SImode))
        return -1;
      x9 = XEXP (x7, 1);
      switch (pattern1604 (x9))
        {
        case 0:
          if (!
#line 11731 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 656; /* *udivmodsi4_zext_1 */

        case 1:
          if (!
#line 11753 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)))
            return -1;
          *pnum_clobbers = 1;
          return 657; /* *udivmodsi4_pow2_zext_1 */

        default:
          return -1;
        }

    case MOD:
      if (pattern343 (x1, pnum_clobbers, 
DIV) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x6 = XEXP (x4, 1);
      operands[3] = x6;
      if (!nonimmediate_operand (operands[3], E_SImode))
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[0] = x8;
      if (!register_operand (operands[0], E_SImode))
        return -1;
      x9 = XEXP (x7, 1);
      x10 = XEXP (x9, 0);
      if (!rtx_equal_p (x10, operands[2]))
        return -1;
      x11 = XEXP (x9, 1);
      if (!rtx_equal_p (x11, operands[3])
          || !
#line 11779 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 658; /* *divmodsi4_zext_2 */

    case UMOD:
      if (pattern343 (x1, pnum_clobbers, 
UDIV) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      operands[2] = x5;
      if (!register_operand (operands[2], E_SImode))
        return -1;
      x6 = XEXP (x4, 1);
      operands[3] = x6;
      x7 = XVECEXP (x1, 0, 1);
      x8 = XEXP (x7, 0);
      operands[0] = x8;
      if (!register_operand (operands[0], E_SImode))
        return -1;
      x9 = XEXP (x7, 1);
      switch (pattern1604 (x9))
        {
        case 0:
          if (!
#line 11815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 659; /* *udivmodsi4_zext_2 */

        case 1:
          if (!
#line 11837 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)))
            return -1;
          *pnum_clobbers = 1;
          return 660; /* *udivmodsi4_pow2_zext_2 */

        default:
          return -1;
        }

    case AND:
      if (pattern340 (x1) != 0)
        return -1;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
        case MEM:
          switch (pattern345 (x3))
            {
            case 0:
              if (!
#line 12640 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 709; /* *andqi_1_zexthi */

            case 1:
              if (!
#line 12640 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 711; /* *andqi_1_zextsi */

            case 2:
              if (!
#line 12654 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 715; /* *andhi_1_zextsi */

            case 3:
              if (!
#line 12640 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 713; /* *andqi_1_zextdi */

            case 4:
              if (!
#line 12654 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return -1;
              return 717; /* *andhi_1_zextdi */

            case 5:
              if (!
#line 12670 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (AND, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 718; /* *andsi_1_zext */

            default:
              return -1;
            }

        case PLUS:
          if (pattern688 (x5) != 0
              || !register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || GET_MODE (x4) != E_SImode)
            return -1;
          x12 = XEXP (x5, 0);
          x13 = XEXP (x12, 1);
          operands[2] = x13;
          if (!register_operand (operands[2], E_QImode))
            return -1;
          x6 = XEXP (x4, 1);
          operands[1] = x6;
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !
#line 22132 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
            return -1;
          return 1598; /* *bmi2_bzhi_zero_extendsidi_4 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern346 (x1))
        {
        case 0:
          if (!
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 844; /* *iorqi_1_zexthi */

        case 1:
          if (!
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 848; /* *iorqi_1_zextsi */

        case 2:
          if (!
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 856; /* *iorhi_1_zextsi */

        case 3:
          if (!
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 852; /* *iorqi_1_zextdi */

        case 4:
          if (!
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 860; /* *iorhi_1_zextdi */

        case 5:
          if (!
#line 13759 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (IOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 863; /* *iorsi_1_zext */

        default:
          return -1;
        }

    case XOR:
      switch (pattern346 (x1))
        {
        case 0:
          if (!
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 846; /* *xorqi_1_zexthi */

        case 1:
          if (!
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 850; /* *xorqi_1_zextsi */

        case 2:
          if (!
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 858; /* *xorhi_1_zextsi */

        case 3:
          if (!
#line 13729 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 854; /* *xorqi_1_zextdi */

        case 4:
          if (!
#line 13743 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 862; /* *xorhi_1_zextdi */

        case 5:
          if (!
#line 13759 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 864; /* *xorsi_1_zext */

        default:
          return -1;
        }

    case NEG:
      if (pattern347 (x1) != 0)
        return -1;
      switch (pattern349 (x3))
        {
        case 0:
          if (!
#line 14374 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 963; /* *negqi_1_zexthi */

        case 1:
          if (!
#line 14374 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 965; /* *negqi_1_zextsi */

        case 2:
          if (!
#line 14384 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 969; /* *neghi_1_zextsi */

        case 3:
          if (!
#line 14374 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 967; /* *negqi_1_zextdi */

        case 4:
          if (!
#line 14384 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 971; /* *neghi_1_zextdi */

        case 5:
          if (!
#line 14395 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_unary_operator_ok (NEG, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 972; /* *negsi_1_zext */

        default:
          return -1;
        }

    case ASHIFT:
      switch (pattern351 (x1))
        {
        case 0:
          if (!
#line 16022 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1094; /* *ashlqi3_1_zexthi */

        case 1:
          if (!
#line 16022 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1096; /* *ashlqi3_1_zextsi */

        case 2:
          if (!
#line 16033 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1100; /* *ashlhi3_1_zextsi */

        case 3:
          if (!
#line 16022 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1098; /* *ashlqi3_1_zextdi */

        case 4:
          if (!
#line 16033 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1102; /* *ashlhi3_1_zextdi */

        case 5:
          if (!
#line 16045 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          return 1103; /* *ashlsi3_1_zext */

        default:
          return -1;
        }

    case ASHIFTRT:
      if (pattern341 (x1) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode))
                return -1;
              if (const_int_operand (operands[2], E_QImode)
                  && 
#line 17280 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && INTVAL (operands[2]) == 31
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)))
                return 1170; /* *ashrsi3_cvt_zext */
              if (!nonmemory_operand (operands[2], E_QImode)
                  || !
#line 17492 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1207; /* *ashrsi3_1_zext */

            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !nonmemory_operand (operands[2], E_QImode)
                  || !
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1197; /* *ashrqi3_1_zextdi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !nonmemory_operand (operands[2], E_QImode)
                  || !
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1205; /* *ashrhi3_1_zextdi */

            default:
              return -1;
            }

        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x3) != E_HImode
              || GET_MODE (x4) != E_QImode
              || !nonimmediate_operand (operands[1], E_QImode)
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1189; /* *ashrqi3_1_zexthi */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode
              || !nonmemory_operand (operands[2], E_QImode))
            return -1;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1193; /* *ashrqi3_1_zextsi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1201; /* *ashrhi3_1_zextsi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case LSHIFTRT:
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      x7 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x7))
        {
        case CLOBBER:
          x8 = XEXP (x7, 0);
          if (GET_CODE (x8) != REG
              || REGNO (x8) != 17
              || GET_MODE (x8) != E_CCmode)
            return -1;
          switch (pattern350 (x3))
            {
            case 0:
              if (!
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1187; /* *lshrqi3_1_zexthi */

            case 1:
              if (!
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1191; /* *lshrqi3_1_zextsi */

            case 2:
              if (!
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1199; /* *lshrhi3_1_zextsi */

            case 3:
              if (!
#line 17469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1195; /* *lshrqi3_1_zextdi */

            case 4:
              if (!
#line 17480 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              return 1203; /* *lshrhi3_1_zextdi */

            case 5:
              if (!
#line 17492 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (LSHIFTRT, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1206; /* *lshrsi3_1_zext */

            default:
              return -1;
            }

        case UNSPEC:
          if (XVECLEN (x7, 0) != 1
              || XINT (x7, 1) != 174)
            return -1;
          x15 = XVECEXP (x7, 0, 0);
          if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || pattern1215 (x3, 
E_SImode, 
E_DImode) != 0
              || !const_0_to_31_operand (operands[2], E_VOIDmode)
              || !
#line 2310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))
            return -1;
          return 2609; /* *klshrsi3_1_zext */

        default:
          return -1;
        }

    case ROTATE:
      switch (pattern351 (x1))
        {
        case 0:
          if (!
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1352; /* *rotlqi3_1_zexthi */

        case 1:
          if (!
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1356; /* *rotlqi3_1_zextsi */

        case 2:
          if (!
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1364; /* *rotlhi3_1_zextsi */

        case 3:
          if (!
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1360; /* *rotlqi3_1_zextdi */

        case 4:
          if (!
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1368; /* *rotlhi3_1_zextdi */

        case 5:
          if (!
#line 18625 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATE, SImode, operands)))
            return -1;
          return 1371; /* *rotlsi3_1_zext */

        default:
          return -1;
        }

    case ROTATERT:
      switch (pattern351 (x1))
        {
        case 0:
          if (!
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1354; /* *rotrqi3_1_zexthi */

        case 1:
          if (!
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1358; /* *rotrqi3_1_zextsi */

        case 2:
          if (!
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1366; /* *rotrhi3_1_zextsi */

        case 3:
          if (!
#line 18602 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1362; /* *rotrqi3_1_zextdi */

        case 4:
          if (!
#line 18613 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          return 1370; /* *rotrhi3_1_zextdi */

        case 5:
          if (!
#line 18625 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATERT, SImode, operands)))
            return -1;
          return 1372; /* *rotrsi3_1_zext */

        default:
          return -1;
        }

    case CTZ:
      if (GET_MODE (x4) != E_SImode)
        return -1;
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      switch (pattern925 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 21193 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1521; /* *ctzsidi2_uext */

        case 1:
          if (!
#line 21233 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1523; /* *ctzsidi2_uext_falsedep */

        default:
          return -1;
        }

    case CLZ:
      if (GET_MODE (x4) != E_SImode)
        return -1;
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      switch (pattern550 (x1, pnum_clobbers))
        {
        case 0:
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !
#line 21628 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT && TARGET_64BIT))
            return -1;
          return 1543; /* *clzsi2_lzcnt_zext_2 */

        case 1:
          x7 = XVECEXP (x1, 0, 1);
          x15 = XVECEXP (x7, 0, 0);
          switch (pattern1409 (x15))
            {
            case 0:
              if (!
#line 21653 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
                return -1;
              *pnum_clobbers = 1;
              return 1544; /* *clzsi2_lzcnt_zext_2_falsedep */

            case 1:
              if (!(
#line 21653 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1545; /* *clzsi2_lzcnt_zext_2_falsedep */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case POPCOUNT:
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      switch (pattern550 (x1, pnum_clobbers))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (pattern348 (x3, 
E_SImode, 
E_DImode) != 0
                  || !
#line 22465 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT))
                return -1;
              return 1634; /* *popcountsi2_zext_2 */

            case E_SImode:
              if (pattern348 (x3, 
E_HImode, 
E_SImode) != 0
                  || !
#line 22531 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()))
                return -1;
              return 1637; /* *popcounthi2_2 */

            default:
              return -1;
            }

        case 1:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || GET_MODE (x4) != E_SImode
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x7 = XVECEXP (x1, 0, 1);
          x15 = XVECEXP (x7, 0, 0);
          operands[2] = x15;
          if (!register_operand (operands[2], E_DImode)
              || !
#line 22496 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1635; /* *popcountsi2_zext_2_falsedep */

        default:
          return -1;
        }

    case NOT:
      if (GET_MODE (x4) != E_SImode)
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      if (pattern383 (x7, 
174, 
0) != 0)
        return -1;
      x14 = XEXP (x2, 0);
      operands[0] = x14;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!register_operand (operands[1], E_SImode)
          || !
#line 2233 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))
        return -1;
      return 2596; /* *knotsi_1_zext */

    case UNSPEC:
      return recog_364 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_391 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      x6 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x6))
        {
        case CLOBBER:
          x7 = XEXP (x6, 0);
          if (GET_CODE (x7) != REG
              || REGNO (x7) != 17
              || GET_MODE (x7) != E_CCmode)
            return -1;
          operands[1] = x5;
          x8 = XEXP (x4, 1);
          operands[2] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              if (!register_operand (operands[0], E_HImode)
                  || GET_MODE (x4) != E_HImode
                  || !nonimmediate_operand (operands[1], E_HImode)
                  || !general_operand (operands[2], E_HImode)
                  || !(
#line 10616 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1191 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH)))
                return -1;
              return 591; /* *mulhi3_1 */

            case E_SImode:
              if (pattern1313 (x4, 
E_SImode) != 0
                  || !
#line 10616 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
                return -1;
              return 593; /* *mulsi3_1 */

            case E_DImode:
              if (pattern1313 (x4, 
E_DImode) != 0
                  || !(
#line 10616 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1192 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 595; /* *muldi3_1 */

            case E_QImode:
              if (pattern212 (x4, 
E_QImode) != 0
                  || !
#line 10703 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
                return -1;
              return 603; /* *mulqi3_1 */

            default:
              return -1;
            }

        case SET:
          x9 = XEXP (x6, 1);
          if (GET_CODE (x9) != UMUL_HIGHPART)
            return -1;
          switch (pattern585 (x1))
            {
            case 0:
              if (!(
#line 10967 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 615; /* *bmi2_umulsidi3_1 */

            case 1:
              if (!(
#line 10967 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 616; /* *bmi2_umulditi3_1 */

            default:
              return -1;
            }

        case UNSPEC:
          if (XVECLEN (x6, 0) != 1
              || XINT (x6, 1) != 110)
            return -1;
          x10 = XVECEXP (x6, 0, 0);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_V2SFmode)
              || GET_MODE (x4) != E_V2SFmode)
            return -1;
          operands[1] = x5;
          if (!nonimmediate_operand (operands[1], E_V2SFmode))
            return -1;
          x8 = XEXP (x4, 1);
          operands[2] = x8;
          if (!nonimmediate_operand (operands[2], E_V2SFmode)
              || !
#line 795 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (MULT, V2SFmode, operands)))
            return -1;
          return 2054; /* *mmx_mulv2sf3 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      switch (pattern559 (x1, 
ZERO_EXTEND))
        {
        case 0:
          if (!(
#line 11006 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 617; /* *umulsidi3_1 */

        case 1:
          if (!(
#line 11006 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 618; /* *umulditi3_1 */

        case 2:
          if (!
#line 11072 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
            return -1;
          return 626; /* *umulqihi3_1 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      switch (pattern559 (x1, 
SIGN_EXTEND))
        {
        case 0:
          if (!(
#line 11052 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 620; /* *mulsidi3_1 */

        case 1:
          if (!(
#line 1199 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && (
#line 11052 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))))
            return -1;
          return 622; /* *mulditi3_1 */

        case 2:
          if (!
#line 11072 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_QIMODE_MATH
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && true))
            return -1;
          return 624; /* *mulqihi3_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_397 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (pattern566 (x1))
        {
        case 0:
          if (
#line 12755 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 727; /* *xorqi_1_slp */
          break;

        case 1:
          if (
#line 12755 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 730; /* *xorhi_1_slp */
          break;

        case 2:
          if (x86_64_hilo_general_operand (operands[2], E_DImode)
              && (
#line 13541 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return 820; /* *xordi3_doubleword */
          if (x86_64_general_operand (operands[2], E_DImode)
              && (
#line 13599 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 834; /* *xordi_1 */
          if (const_int_operand (operands[2], E_DImode)
              && 
#line 13669 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_USE_BT
   && ix86_binary_operator_ok (XOR, DImode, operands)
   && IN_RANGE (exact_log2 (INTVAL (operands[2])), 31, 63)))
            return 839; /* *xordi_1_btc */
          break;

        case 3:
          if ((
#line 13541 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 822; /* *xorti3_doubleword */
          break;

        case 4:
          if (
#line 13599 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, HImode, operands, TARGET_APX_NDD)
   && true))
            return 826; /* *xorhi_1 */
          break;

        case 5:
          if (
#line 13599 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)
   && true))
            return 830; /* *xorsi_1 */
          break;

        case 6:
          if (
#line 4713 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (XOR, V4QImode, operands)))
            return 2285; /* *xorv4qi3 */
          break;

        case 7:
          if (
#line 4713 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (XOR, V2QImode, operands)))
            return 2288; /* *xorv2qi3 */
          break;

        case 8:
          if (
#line 4713 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (XOR, V2HImode, operands)))
            return 2291; /* *xorv2hi3 */
          break;

        case 9:
          if (
#line 2097 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 2574; /* kxorqi */
          break;

        case 10:
          if (
#line 2097 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 2577; /* kxorhi */
          break;

        case 11:
          if ((
#line 2097 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2580; /* kxorsi */
          break;

        case 12:
          if ((
#line 2097 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2583; /* kxordi */
          break;

        default:
          break;
        }
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != CLOBBER
          || pattern567 (x1) != 0)
        return -1;
      if (GET_CODE (x4) == SUBREG
          && pattern555 (x4) == 0)
        {
          x6 = XEXP (x4, 0);
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          switch (pattern1606 (x2))
            {
            case 0:
              if (
#line 12782 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 733; /* *xorqi_exthi_1_slp */
              break;

            case 1:
              if (
#line 12782 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 736; /* *xorqi_extsi_1_slp */
              break;

            case 2:
              if ((
#line 12782 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 739; /* *xorqi_extdi_1_slp */
              break;

            case 3:
              return 757; /* *xorqi_exthi_0 */

            case 4:
              return 760; /* *xorqi_extsi_0 */

            case 5:
              if (
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return 763; /* *xorqi_extdi_0 */
              break;

            default:
              break;
            }
          x8 = XEXP (x3, 1);
          if (GET_CODE (x8) == SUBREG)
            {
              switch (pattern1607 (x2))
                {
                case 0:
                  if (
#line 12815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 742; /* *xorqi_exthi_2_slp */
                  break;

                case 1:
                  if (
#line 12815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 745; /* *xorqi_extsi_2_slp */
                  break;

                case 2:
                  if ((
#line 12815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 748; /* *xorqi_extdi_2_slp */
                  break;

                case 3:
                  return 766; /* *xorqi_ext2hi_0 */

                case 4:
                  return 769; /* *xorqi_ext2si_0 */

                case 5:
                  if (
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return 772; /* *xorqi_ext2di_0 */
                  break;

                default:
                  break;
                }
            }
        }
      x9 = XEXP (x2, 0);
      operands[0] = x9;
      if (!nonimmediate_operand (operands[0], E_QImode))
        return -1;
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], E_QImode))
        return -1;
      x8 = XEXP (x3, 1);
      operands[2] = x8;
      if (!general_operand (operands[2], E_QImode)
          || !
#line 13789 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, QImode, operands, TARGET_APX_NDD)
   && true))
        return -1;
      return 870; /* *xorqi_1 */

    case AND:
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != XOR)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (pattern353 (x5) != 0)
        return -1;
      switch (pattern1041 (x2))
        {
        case 0:
          if (!
#line 13698 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()))
            return -1;
          return 840; /* *xor2andn */

        case 1:
          if (!
#line 13698 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()))
            return -1;
          return 841; /* *xor2andn */

        case 2:
          if (!(
#line 13698 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 842; /* *xor2andn */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      if (pattern370 (x1) != 0
          || !
#line 13776 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)))
        return -1;
      return 866; /* *xorsi_1_zext_imm */

    case ASHIFT:
      switch (pattern373 (x1, 
1))
        {
        case 0:
          x10 = XEXP (x4, 1);
          operands[2] = x10;
          if (register_operand (operands[2], E_QImode))
            {
              switch (pattern934 (x3))
                {
                case 0:
                  if (
#line 18837 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT))
                    return 1392; /* *btcsi */
                  break;

                case 1:
                  if ((
#line 18837 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1394; /* *btcdi */
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x10) != SUBREG)
            return -1;
          switch (pattern1316 (x3))
            {
            case 0:
              if (!
#line 18856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                return -1;
              return 1396; /* *btcsi_mask */

            case 1:
              if (!(
#line 18856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1398; /* *btcdi_mask */

            default:
              return -1;
            }

        case 1:
          if (!
#line 18884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
            return -1;
          return 1400; /* *btcsi_mask_1 */

        case 2:
          if (!(
#line 18884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1402; /* *btcdi_mask_1 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      if (GET_MODE (x4) != E_DImode)
        return -1;
      x6 = XEXP (x4, 0);
      if (GET_CODE (x6) != MINUS
          || GET_MODE (x6) != E_SImode)
        return -1;
      x7 = XEXP (x6, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 63])
        return -1;
      x11 = XEXP (x6, 1);
      if (GET_CODE (x11) != SUBREG
          || maybe_ne (SUBREG_BYTE (x11), 0)
          || GET_MODE (x11) != E_SImode)
        return -1;
      x12 = XEXP (x11, 0);
      if (GET_CODE (x12) != CLZ
          || GET_MODE (x12) != E_DImode)
        return -1;
      x8 = XEXP (x3, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 63])
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (pattern231 (x5, 
E_CCmode, 
17) != 0)
        return -1;
      x9 = XEXP (x2, 0);
      operands[0] = x9;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x13 = XEXP (x12, 0);
      operands[1] = x13;
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !
#line 21341 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT && ix86_pre_reload_split ()))
        return -1;
      return 1530; /* *bsr_rex64_2 */

    case PLUS:
      x10 = XEXP (x4, 1);
      if (GET_CODE (x10) != CONST_INT
          || pattern347 (x1) != 0)
        return -1;
      x8 = XEXP (x3, 1);
      if (!rtx_equal_p (x8, operands[1]))
        return -1;
      switch (XWINT (x10, 0))
        {
        case -1L:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern203 (x3, 
E_SImode) != 0
                  || !
#line 21895 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                return -1;
              return 1578; /* *bmi_blsmsk_si */

            case E_DImode:
              if (pattern203 (x3, 
E_DImode) != 0
                  || !(
#line 21895 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1579; /* *bmi_blsmsk_di */

            default:
              return -1;
            }

        case 1L:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern203 (x3, 
E_SImode) != 0
                  || !
#line 22241 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
                return -1;
              return 1612; /* *tbm_blcmsk_si */

            case E_DImode:
              if (pattern203 (x3, 
E_DImode) != 0
                  || !(
#line 22241 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1613; /* *tbm_blcmsk_di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_406 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x6))
    {
    case CLOBBER:
      switch (pattern698 (x1))
        {
        case 0:
          return 1514; /* ctzsi2 */

        case 1:
          if (!
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1515; /* ctzdi2 */

        default:
          return -1;
        }

    case UNSPEC:
      if (pnum_clobbers == NULL)
        return -1;
      switch (pattern699 (x1))
        {
        case 0:
          *pnum_clobbers = 1;
          return 1516; /* *ctzsi2_falsedep */

        case 1:
          if (!
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1517; /* *ctzdi2_falsedep */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_410 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  switch (XVECLEN (x4, 0))
    {
    case 1:
      switch (XINT (x4, 1))
        {
        case 2:
          x5 = XVECEXP (x1, 0, 1);
          if (pattern231 (x5, 
E_CCmode, 
17) != 0)
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[1] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || GET_MODE (x4) != E_SImode
                  || !register_operand (operands[1], E_SImode)
                  || !(
#line 27234 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_target_stack_probe ()) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1859; /* allocate_stack_worker_probe_si */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x4) != E_DImode
                  || !register_operand (operands[1], E_DImode)
                  || !(
#line 27234 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_target_stack_probe ()) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1860; /* allocate_stack_worker_probe_di */

            default:
              return -1;
            }

        case 11:
          if (pattern700 (x1, 
11) != 0
              || !
#line 29118 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1896; /* rdpmc_rex64 */

        case 9:
          if (pattern701 (x1, 
E_DImode, 
9) != 0
              || !
#line 29136 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1898; /* rdtsc_rex64 */

        case 10:
          if (pattern701 (x1, 
E_SImode, 
10) != 0
              || !
#line 29146 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1899; /* rdtscp */

        case 36:
          if (pattern700 (x1, 
36) != 0
              || !
#line 29360 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1926; /* xgetbv_rex64 */

        case 44:
          switch (pattern702 (x1, 
44))
            {
            case 0:
              if (!
#line 29521 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDRND))
                return -1;
              return 1949; /* rdrandhi */

            case 1:
              if (!
#line 29521 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDRND))
                return -1;
              return 1950; /* rdrandsi */

            case 2:
              if (!(
#line 29521 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDRND) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1951; /* rdranddi */

            default:
              return -1;
            }

        case 45:
          switch (pattern702 (x1, 
45))
            {
            case 0:
              if (!
#line 29531 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDSEED))
                return -1;
              return 1952; /* rdseedhi */

            case 1:
              if (!
#line 29531 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDSEED))
                return -1;
              return 1953; /* rdseedsi */

            case 2:
              if (!(
#line 29531 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_RDSEED) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1954; /* rdseeddi */

            default:
              return -1;
            }

        case 56:
          if (GET_MODE (x4) != E_SImode)
            return -1;
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != SET)
            return -1;
          x7 = XEXP (x5, 1);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_SImode))
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[2] = x6;
          if (!register_operand (operands[2], E_SImode))
            return -1;
          x8 = XEXP (x5, 0);
          operands[1] = x8;
          if (!register_operand (operands[1], E_SImode)
              || !
#line 29774 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_PKU))
            return -1;
          return 1980; /* *rdpkru */

        default:
          return -1;
        }

    case 2:
      switch (XINT (x4, 1))
        {
        case 3:
          x5 = XVECEXP (x1, 0, 1);
          if (pattern231 (x5, 
E_CCmode, 
17) != 0)
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[1] = x6;
          x9 = XVECEXP (x4, 0, 1);
          operands[2] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern1423 (x4, 
E_SImode) != 0
                  || !
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))
                return -1;
              return 1865; /* probe_stack_range_si */

            case E_DImode:
              if (pattern1423 (x4, 
E_DImode) != 0
                  || !
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))
                return -1;
              return 1866; /* probe_stack_range_di */

            default:
              return -1;
            }

        case 99:
          if (pattern703 (x1, 
99) != 0
              || !
#line 31367 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10289; /* aesdec128klu8 */

        case 101:
          if (pattern703 (x1, 
101) != 0
              || !
#line 31367 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10290; /* aesdec256klu8 */

        case 100:
          if (pattern703 (x1, 
100) != 0
              || !
#line 31367 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10291; /* aesenc128klu8 */

        case 102:
          if (pattern703 (x1, 
102) != 0
              || !
#line 31367 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
            return -1;
          return 10292; /* aesenc256klu8 */

        case 110:
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != SET)
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[1] = x6;
          x9 = XVECEXP (x4, 0, 1);
          operands[3] = x9;
          if (!const_int_operand (operands[3], E_SImode))
            return -1;
          x8 = XEXP (x5, 0);
          if (!rtx_equal_p (x8, operands[1]))
            return -1;
          x7 = XEXP (x5, 1);
          switch (GET_CODE (x7))
            {
            case PLUS:
              if (pnum_clobbers == NULL)
                return -1;
              x10 = XEXP (x7, 1);
              operands[2] = x10;
              x11 = XEXP (x7, 0);
              if (!rtx_equal_p (x11, operands[1]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern1551 (x1, 
E_QImode) != 0
                      || !
#line 703 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(TARGET_XADD))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10922; /* atomic_fetch_addqi */

                case E_HImode:
                  if (pattern1551 (x1, 
E_HImode) != 0
                      || !
#line 703 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(TARGET_XADD))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10923; /* atomic_fetch_addhi */

                case E_SImode:
                  if (pattern1551 (x1, 
E_SImode) != 0
                      || !
#line 703 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(TARGET_XADD))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10924; /* atomic_fetch_addsi */

                case E_DImode:
                  if (pattern1551 (x1, 
E_DImode) != 0
                      || !(
#line 703 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(TARGET_XADD) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10925; /* atomic_fetch_adddi */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
              operands[2] = x7;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern1481 (x4, 
E_QImode) != 0)
                    return -1;
                  return 10930; /* atomic_exchangeqi */

                case E_HImode:
                  if (pattern1481 (x4, 
E_HImode) != 0)
                    return -1;
                  return 10931; /* atomic_exchangehi */

                case E_SImode:
                  if (pattern1481 (x4, 
E_SImode) != 0)
                    return -1;
                  return 10932; /* atomic_exchangesi */

                case E_DImode:
                  if (pattern1481 (x4, 
E_DImode) != 0
                      || !
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10933; /* atomic_exchangedi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 111:
          x5 = XVECEXP (x1, 0, 1);
          if (pattern231 (x5, 
E_CCmode, 
17) != 0)
            return -1;
          x9 = XVECEXP (x4, 0, 1);
          operands[2] = x9;
          if (!const_int_operand (operands[2], E_SImode))
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          switch (GET_CODE (x6))
            {
            case PLUS:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10942; /* atomic_addqi */

                case 1:
                  return 10943; /* atomic_addhi */

                case 2:
                  return 10944; /* atomic_addsi */

                case 3:
                  if (!
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10945; /* atomic_adddi */

                default:
                  return -1;
                }

            case MINUS:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10946; /* atomic_subqi */

                case 1:
                  return 10947; /* atomic_subhi */

                case 2:
                  return 10948; /* atomic_subsi */

                case 3:
                  if (!
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10949; /* atomic_subdi */

                default:
                  return -1;
                }

            case AND:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10950; /* atomic_andqi */

                case 1:
                  return 10953; /* atomic_andhi */

                case 2:
                  return 10956; /* atomic_andsi */

                case 3:
                  if (!
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10959; /* atomic_anddi */

                default:
                  return -1;
                }

            case IOR:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10951; /* atomic_orqi */

                case 1:
                  return 10954; /* atomic_orhi */

                case 2:
                  return 10957; /* atomic_orsi */

                case 3:
                  if (!
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10960; /* atomic_ordi */

                default:
                  return -1;
                }

            case XOR:
              switch (pattern1425 (x4))
                {
                case 0:
                  return 10952; /* atomic_xorqi */

                case 1:
                  return 10955; /* atomic_xorhi */

                case 2:
                  return 10958; /* atomic_xorsi */

                case 3:
                  if (!
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  return 10961; /* atomic_xordi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_429 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != RETURN)
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x3) != USE)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 38
      || pattern718 (x4, 
E_DImode, 
7) != 0)
    return -1;
  x6 = XEXP (x3, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[1]))
    {
    case E_SImode:
      if (!symbol_operand (operands[1], E_SImode)
          || !(
#line 30313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_64BIT) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
        return -1;
      return 10075; /* *restore_multiple_and_returnsi */

    case E_DImode:
      if (!symbol_operand (operands[1], E_DImode)
          || !(
#line 30313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_64BIT) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
        return -1;
      return 10076; /* *restore_multiple_and_returndi */

    default:
      return -1;
    }
}

 int
recog_431 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  switch (XVECLEN (x1, 0))
    {
    case 1:
      switch (XINT (x1, 1))
        {
        case 1:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 1486; /* blockage */

        case 5:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          return 1488; /* prologue_use */

        case 8:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!const_int_operand (operands[0], E_VOIDmode)
              || !
#line 20728 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
            return -1;
          return 1496; /* nops */

        case 6:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!const_int_operand (operands[0], E_SImode))
            return -1;
          return 1506; /* split_stack_return */

        case 7:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 1760; /* cld */

        case 0:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 1886; /* ud2 */

        case 21:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_BLKmode)
              || !
#line 29193 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_FXSR))
            return -1;
          return 1903; /* fxrstor */

        case 23:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_BLKmode)
              || !
#line 29203 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FXSR))
            return -1;
          return 1904; /* fxrstor64 */

        case 41:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_BLKmode)
              || !
#line 29401 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          *pnum_clobbers = 8;
          return 1928; /* fldenv */

        case 43:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29420 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 1930; /* fnclex */

        case 12:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !(
#line 29435 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1931; /* lwp_llwpcbsi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29435 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1932; /* lwp_llwpcbdi */

            default:
              return -1;
            }

        case 18:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !
#line 29501 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE))
                return -1;
              return 1943; /* wrfsbasesi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29501 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1945; /* wrfsbasedi */

            default:
              return -1;
            }

        case 19:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !
#line 29501 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE))
                return -1;
              return 1944; /* wrgsbasesi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29501 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1946; /* wrgsbasedi */

            default:
              return -1;
            }

        case 78:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || !
#line 29510 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_PTWRITE))
                return -1;
              return 1947; /* ptwritesi */

            case E_DImode:
              if (!nonimmediate_operand (operands[0], E_DImode)
                  || !(
#line 29510 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_PTWRITE) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1948; /* ptwritedi */

            default:
              return -1;
            }

        case 60:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !
#line 29568 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK || (flag_cf_protection & CF_RETURN)))
                return -1;
              return 1958; /* incsspsi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29568 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK || (flag_cf_protection & CF_RETURN)) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1959; /* incsspdi */

            default:
              return -1;
            }

        case 61:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29575 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
            return -1;
          return 1960; /* saveprevssp */

        case 62:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_DImode)
              || !
#line 29583 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
            return -1;
          return 1961; /* rstorssp */

        case 65:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29608 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
            return -1;
          return 1966; /* setssbsy */

        case 66:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_DImode)
              || !
#line 29616 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
            return -1;
          return 1967; /* clrssbsy */

        case 58:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29623 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((flag_cf_protection & CF_BRANCH)))
            return -1;
          return 1968; /* nop_endbr */

        case 47:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29669 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_RTM))
            return -1;
          return 1970; /* xend */

        case 48:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!const_0_to_255_operand (operands[0], E_SImode)
              || !
#line 29677 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_RTM))
            return -1;
          return 1971; /* xabort */

        case 51:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!address_operand (operands[0], E_VOIDmode)
              || !
#line 29705 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLWB))
            return -1;
          return 1973; /* clwb */

        case 52:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!address_operand (operands[0], E_VOIDmode)
              || !
#line 29714 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLFLUSHOPT))
            return -1;
          return 1974; /* clflushopt */

        case 55:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !(
#line 29750 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLZERO) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1978; /* clzero_si */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29750 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLZERO) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1979; /* clzero_di */

            default:
              return -1;
            }

        case 38:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 1984; /* wbinvd */

        case 39:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29821 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_WBNOINVD))
            return -1;
          return 1985; /* wbnoinvd */

        case 67:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29849 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_TSXLDTRK))
            return -1;
          return 1990; /* xsusldtrk */

        case 68:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29849 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_TSXLDTRK))
            return -1;
          return 1991; /* xresldtrk */

        case 72:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29874 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_UINTR && TARGET_64BIT))
            return -1;
          return 1996; /* clui */

        case 73:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29874 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_UINTR && TARGET_64BIT))
            return -1;
          return 1997; /* stui */

        case 75:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!register_operand (operands[0], E_DImode)
              || !
#line 29891 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_UINTR && TARGET_64BIT))
            return -1;
          return 1999; /* senduipi */

        case 70:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !(
#line 29920 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_WAITPKG) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 2002; /* umonitor_si */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29920 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_WAITPKG) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 2003; /* umonitor_di */

            default:
              return -1;
            }

        case 76:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!address_operand (operands[0], E_VOIDmode)
              || !
#line 29947 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CLDEMOTE))
            return -1;
          return 2006; /* cldemote */

        case 77:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          return 2007; /* speculation_barrier */

        case 81:
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 29961 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SERIALIZE))
            return -1;
          return 2008; /* serialize */

        case 83:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!register_operand (operands[0], E_SImode)
              || !
#line 29983 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_HRESET))
            return -1;
          return 2010; /* hreset */

        case 87:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_BLKmode)
              || !
#line 30101 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AMX_TILE))
            return -1;
          return 2013; /* ldtilecfg */

        case 90:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 6868 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX))
            return -1;
          *pnum_clobbers = 16;
          return 2387; /* *mmx_emms */

        case 91:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XVECEXP (x1, 0, 0);
          if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !
#line 6869 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
            return -1;
          *pnum_clobbers = 16;
          return 2388; /* *mmx_femms */

        case 92:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!memory_operand (operands[0], E_SImode)
              || !
#line 22486 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 8508; /* sse_ldmxcsr */

        case 94:
          x2 = XVECEXP (x1, 0, 0);
          operands[0] = x2;
          if (!address_operand (operands[0], E_VOIDmode)
              || !
#line 22510 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 8510; /* sse2_clflush */

        default:
          return -1;
        }

    case 2:
      x2 = XVECEXP (x1, 0, 0);
      operands[0] = x2;
      x3 = XVECEXP (x1, 0, 1);
      operands[1] = x3;
      switch (XINT (x1, 1))
        {
        case 4:
          return 1497; /* max_skip_align */

        case 84:
          if (!local_func_symbolic_operand (operands[0], E_VOIDmode)
              || !const_int_operand (operands[1], E_SImode)
              || !
#line 29040 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_PREFETCHI && TARGET_64BIT))
            return -1;
          return 1889; /* prefetchi */

        case 25:
          if (GET_MODE (x1) != E_BLKmode
              || !memory_operand (operands[0], E_BLKmode)
              || !register_operand (operands[1], E_DImode)
              || !
#line 29292 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1917; /* xrstor */

        case 31:
          if (GET_MODE (x1) != E_BLKmode
              || !memory_operand (operands[0], E_BLKmode)
              || !register_operand (operands[1], E_DImode)
              || !(
#line 29292 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_XSAVE) && 
#line 29235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_XSAVES)))
            return -1;
          return 1918; /* xrstors */

        case 37:
          if (GET_MODE (x1) != E_SImode
              || !register_operand (operands[0], E_SImode)
              || !register_operand (operands[1], E_DImode)
              || !
#line 29332 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1923; /* xsetbv */

        case 63:
          switch (pattern397 ())
            {
            case 0:
              if (!
#line 29592 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
                return -1;
              return 1962; /* wrsssi */

            case 1:
              if (!(
#line 29592 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1963; /* wrssdi */

            default:
              return -1;
            }

        case 64:
          switch (pattern397 ())
            {
            case 0:
              if (!
#line 29601 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK))
                return -1;
              return 1964; /* wrusssi */

            case 1:
              if (!(
#line 29601 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1965; /* wrussdi */

            default:
              return -1;
            }

        case 82:
          if (!const_int_operand (operands[0], E_VOIDmode)
              || !const_int_operand (operands[1], E_VOIDmode))
            return -1;
          return 2009; /* patchable_area */

        case 86:
          if (!x86_64_szext_nonmemory_operand (operands[0], E_DImode)
              || !register_operand (operands[1], E_DImode)
              || !
#line 30093 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USER_MSR && TARGET_64BIT))
            return -1;
          return 2012; /* uwrmsr */

        case 96:
          if (!register_operand (operands[0], E_SImode)
              || !register_operand (operands[1], E_SImode)
              || !
#line 22523 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_MWAIT))
            return -1;
          return 8511; /* sse3_mwait */

        default:
          return -1;
        }

    case 3:
      x2 = XVECEXP (x1, 0, 0);
      operands[0] = x2;
      x3 = XVECEXP (x1, 0, 1);
      operands[1] = x3;
      x4 = XVECEXP (x1, 0, 2);
      operands[2] = x4;
      switch (XINT (x1, 1))
        {
        case 25:
          if (pattern570 (x1) != 0
              || !
#line 29305 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1919; /* xrstor_rex64 */

        case 31:
          if (pattern570 (x1) != 0
              || !(
#line 29305 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE) && 
#line 29235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_XSAVES)))
            return -1;
          return 1920; /* xrstors_rex64 */

        case 27:
          if (pattern570 (x1) != 0
              || !
#line 29319 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1921; /* xrstor64 */

        case 33:
          if (pattern570 (x1) != 0
              || !(
#line 29319 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE) && 
#line 29239 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_XSAVES)))
            return -1;
          return 1922; /* xrstors64 */

        case 37:
          if (pattern571 (x1) != 0
              || !
#line 29342 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1924; /* xsetbv_rex64 */

        case 14:
          if (!nonimmediate_operand (operands[1], E_SImode)
              || !const_int_operand (operands[2], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || !
#line 29455 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP))
                return -1;
              return 1935; /* lwp_lwpvalsi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || !(
#line 29455 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1936; /* lwp_lwpvaldi */

            default:
              return -1;
            }

        case 54:
          if (!register_operand (operands[0], E_SImode)
              || !register_operand (operands[1], E_SImode)
              || !register_operand (operands[2], E_SImode)
              || !
#line 29726 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_MWAITX))
            return -1;
          return 1975; /* mwaitx */

        case 53:
          switch (pattern572 ())
            {
            case 0:
              if (!(
#line 29738 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_MWAITX) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1976; /* monitorx_si */

            case 1:
              if (!(
#line 29738 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_MWAITX) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1977; /* monitorx_di */

            default:
              return -1;
            }

        case 56:
          if (pattern571 (x1) != 0
              || !
#line 29793 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_PKU))
            return -1;
          return 1981; /* *wrpkru */

        case 95:
          switch (pattern572 ())
            {
            case 0:
              if (!(
#line 22535 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_MWAIT) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 8512; /* sse3_monitor_si */

            case 1:
              if (!(
#line 22535 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_MWAIT) && 
#line 1398 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 8513; /* sse3_monitor_di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 4:
      if (pnum_clobbers == NULL
          || XINT (x1, 1) != 98
          || GET_MODE (x1) != E_V2DImode)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      operands[0] = x2;
      if (!register_operand (operands[0], E_V2DImode))
        return -1;
      x3 = XVECEXP (x1, 0, 1);
      operands[1] = x3;
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      x4 = XVECEXP (x1, 0, 2);
      operands[2] = x4;
      if (!register_operand (operands[2], E_V2DImode))
        return -1;
      x5 = XVECEXP (x1, 0, 3);
      operands[3] = x5;
      if (!register_operand (operands[3], E_SImode)
          || !
#line 31233 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
        return -1;
      *pnum_clobbers = 1;
      return 10286; /* loadiwkey */

    default:
      return -1;
    }
}

 rtx_insn *
split_14 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return NULL;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return NULL;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return NULL;
      x8 = XEXP (x4, 0);
      operands[0] = x8;
      switch (pattern1472 (x5))
        {
        case 0:
          return gen_split_26 (insn, operands);

        case 1:
          if (!
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return NULL;
          return gen_split_27 (insn, operands);

        default:
          return NULL;
        }

    case ZERO_EXTRACT:
      x8 = XEXP (x4, 0);
      if (GET_CODE (x8) == SUBREG)
        {
          switch (pattern1304 (x4))
            {
            case 0:
              if ((
#line 19356 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 19358 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_842 (insn, operands);
              break;

            case 1:
              if (((
#line 19356 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19358 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_843 (insn, operands);
              break;

            default:
              break;
            }
        }
      x7 = XEXP (x5, 2);
      if (GET_CODE (x7) != SUBREG)
        return NULL;
      switch (pattern1306 (x4))
        {
        case 0:
          if (!(
#line 19437 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 19442 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_850 (insn, operands);

        case 1:
          if (!((
#line 19437 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 19442 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_851 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_20 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (pattern231 (x2, 
E_CCmode, 
17) != 0)
    return NULL;
  x3 = XVECEXP (x1, 0, 0);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x5;
      switch (pattern1166 (x3))
        {
        case 0:
          if ((
#line 12755 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12759 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
            return gen_split_295 (insn, operands);
          break;

        case 1:
          if ((
#line 12755 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12759 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
            return gen_split_298 (insn, operands);
          break;

        case 2:
          if (nonimmediate_operand (operands[0], E_DImode)
              && nonimmediate_operand (operands[1], E_DImode))
            {
              if (x86_64_hilo_general_operand (operands[2], E_DImode)
                  && ((
#line 13541 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 13543 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_394 (insn, operands);
              if (const_int_operand (operands[2], E_DImode)
                  && (
#line 13669 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_USE_BT
   && ix86_binary_operator_ok (XOR, DImode, operands)
   && IN_RANGE (exact_log2 (INTVAL (operands[2])), 31, 63)) && 
#line 13673 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_401 (insn, operands);
            }
          if (const_int_operand (operands[2], E_DImode))
            {
              if (QIreg_operand (operands[0], E_DImode)
                  && register_operand (operands[1], E_DImode)
                  && (
#line 13966 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_429 (insn, operands);
              if (any_QIreg_operand (operands[0], E_DImode)
                  && general_operand (operands[1], E_DImode)
                  && (
#line 14004 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_435 (insn, operands);
            }
          break;

        case 3:
          if (((
#line 13541 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13543 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return gen_split_396 (insn, operands);
          break;

        case 4:
          if (QIreg_operand (operands[0], E_HImode)
              && register_operand (operands[1], E_HImode)
              && 
#line 13966 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))))
            return gen_split_425 (insn, operands);
          if (any_QIreg_operand (operands[0], E_HImode)
              && general_operand (operands[1], E_HImode)
              && 
#line 14004 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_431 (insn, operands);
          break;

        case 5:
          if (QIreg_operand (operands[0], E_SImode)
              && register_operand (operands[1], E_SImode)
              && 
#line 13966 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))))
            return gen_split_427 (insn, operands);
          if (any_QIreg_operand (operands[0], E_SImode)
              && general_operand (operands[1], E_SImode)
              && 
#line 14004 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_433 (insn, operands);
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG
          || pattern1165 (x4) != 0)
        return NULL;
      x6 = XEXP (x5, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      switch (pattern1666 (x3))
        {
        case 0:
          if ((
#line 12782 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_301 (insn, operands);
          break;

        case 1:
          if ((
#line 12782 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_304 (insn, operands);
          break;

        case 2:
          if (((
#line 12782 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12786 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_307 (insn, operands);
          break;

        default:
          break;
        }
      operands[1] = x7;
      switch (pattern1667 (x3))
        {
        case 0:
          if (!(
#line 12815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_310 (insn, operands);

        case 1:
          if (!(
#line 12815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_313 (insn, operands);

        case 2:
          if (!((
#line 12815 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12817 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_316 (insn, operands);

        case 3:
          if (!
#line 13058 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_330 (insn, operands);

        case 4:
          if (!
#line 13058 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_333 (insn, operands);

        case 5:
          if (!(
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 13058 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_336 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != IOR)
        return NULL;
      x8 = XEXP (x3, 0);
      operands[0] = x8;
      x7 = XEXP (x6, 0);
      operands[1] = x7;
      x9 = XEXP (x6, 1);
      operands[2] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern1226 (x4, 
E_SImode) != 0)
            return NULL;
          x10 = XEXP (x4, 1);
          operands[3] = x10;
          if (nonimmediate_operand (operands[3], E_SImode))
            {
              if (nonimmediate_operand (operands[2], E_SImode))
                {
                  x11 = XEXP (x5, 1);
                  if (rtx_equal_p (x11, operands[1])
                      && 
#line 13450 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                    return gen_split_385 (insn, operands);
                }
              if (register_operand (operands[2], E_SImode))
                {
                  x11 = XEXP (x5, 1);
                  if (rtx_equal_p (x11, operands[2])
                      && 
#line 13469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                    return gen_split_387 (insn, operands);
                }
            }
          x11 = XEXP (x5, 1);
          operands[3] = x11;
          if (!nonimmediate_operand (operands[3], E_SImode))
            return NULL;
          if (nonimmediate_operand (operands[2], E_SImode)
              && rtx_equal_p (x10, operands[1])
              && 
#line 13488 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return gen_split_389 (insn, operands);
          if (!register_operand (operands[2], E_SImode)
              || !rtx_equal_p (x10, operands[2])
              || !
#line 13507 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return NULL;
          return gen_split_391 (insn, operands);

        case E_DImode:
          if (pattern1226 (x4, 
E_DImode) != 0)
            return NULL;
          x10 = XEXP (x4, 1);
          operands[3] = x10;
          if (nonimmediate_operand (operands[3], E_DImode))
            {
              if (nonimmediate_operand (operands[2], E_DImode))
                {
                  x11 = XEXP (x5, 1);
                  if (rtx_equal_p (x11, operands[1])
                      && (
#line 13450 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return gen_split_386 (insn, operands);
                }
              if (register_operand (operands[2], E_DImode))
                {
                  x11 = XEXP (x5, 1);
                  if (rtx_equal_p (x11, operands[2])
                      && (
#line 13469 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return gen_split_388 (insn, operands);
                }
            }
          x11 = XEXP (x5, 1);
          operands[3] = x11;
          if (!nonimmediate_operand (operands[3], E_DImode))
            return NULL;
          if (nonimmediate_operand (operands[2], E_DImode)
              && rtx_equal_p (x10, operands[1])
              && (
#line 13488 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return gen_split_390 (insn, operands);
          if (!register_operand (operands[2], E_DImode)
              || !rtx_equal_p (x10, operands[2])
              || !(
#line 13507 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_392 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != XOR)
        return NULL;
      switch (pattern1041 (x3))
        {
        case 0:
          if (!(
#line 13698 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()) && 
#line 13700 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_402 (insn, operands);

        case 1:
          if (!(
#line 13698 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()) && 
#line 13700 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_403 (insn, operands);

        case 2:
          if (!((
#line 13698 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13700 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_404 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      switch (pattern1050 (x3, 
1))
        {
        case 0:
          if (!(
#line 18856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18861 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_803 (insn, operands);

        case 1:
          if (!((
#line 18856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18861 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_805 (insn, operands);

        case 2:
          if (!(
#line 18884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18889 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_807 (insn, operands);

        case 3:
          if (!((
#line 18884 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18889 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_809 (insn, operands);

        default:
          return NULL;
        }

    case SIGN_EXTEND:
      if (GET_MODE (x5) != E_DImode)
        return NULL;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != MINUS
          || GET_MODE (x6) != E_SImode)
        return NULL;
      x7 = XEXP (x6, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 63])
        return NULL;
      x9 = XEXP (x6, 1);
      if (GET_CODE (x9) != SUBREG
          || maybe_ne (SUBREG_BYTE (x9), 0)
          || GET_MODE (x9) != E_SImode)
        return NULL;
      x12 = XEXP (x9, 0);
      if (GET_CODE (x12) != CLZ
          || GET_MODE (x12) != E_DImode)
        return NULL;
      x10 = XEXP (x4, 1);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 63])
        return NULL;
      x8 = XEXP (x3, 0);
      operands[0] = x8;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x4) != E_DImode)
        return NULL;
      x13 = XEXP (x12, 0);
      operands[1] = x13;
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !(
#line 21341 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 21343 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_884 (insn, operands);

    case PLUS:
      x11 = XEXP (x5, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
        return NULL;
      switch (pattern940 (x3))
        {
        case 0:
          if (!
#line 21897 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_FALSE_DEP_FOR_BLS
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])))
            return NULL;
          return gen_split_908 (insn, operands);

        case 1:
          if (!(
#line 21897 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_FALSE_DEP_FOR_BLS
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_909 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_30 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (pattern340 (x1) != 0)
    return NULL;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (pattern1137 (x3))
        {
        case 0:
          if (!(
#line 4851 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 4853 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_63 (insn, operands);

        case 1:
          if (!(
#line 4851 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 4853 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_64 (insn, operands);

        case 2:
          if (!(
#line 4905 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 4907 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_65 (insn, operands);

        default:
          return NULL;
        }

    case PLUS:
      if (GET_MODE (x4) != E_SImode
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return NULL;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
          operands[1] = x5;
          if (!register_operand (operands[1], E_SImode))
            return NULL;
          x6 = XEXP (x4, 1);
          operands[2] = x6;
          if (!x86_64_nonmemory_operand (operands[2], E_SImode))
            return NULL;
          if (
#line 7077 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && reload_completed && ix86_avoid_lea_for_add (insn, operands)))
            return gen_split_130 (insn, operands);
          if (!
#line 7127 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_139 (insn, operands);

        case UNSPEC:
          if (pattern1140 (x5) != 0)
            return NULL;
          x6 = XEXP (x4, 1);
          operands[1] = x6;
          if (!register_operand (operands[1], E_SImode)
              || !(
#line 23269 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_X32) && 
#line 23271 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_928 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      if (GET_MODE (x4) != E_SImode
          || GET_MODE (x3) != E_DImode)
        return NULL;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      switch (GET_CODE (operands[2]))
        {
        case REG:
        case SUBREG:
          if (!register_operand (operands[2], E_QImode)
              || !register_operand (operands[0], E_DImode)
              || !nonimmediate_operand (operands[1], E_SImode)
              || !
#line 16100 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed))
            return NULL;
          return gen_split_580 (insn, operands);

        case CONST_INT:
          if (!const_0_to_3_operand (operands[2], E_VOIDmode)
              || !general_reg_operand (operands[0], E_DImode)
              || !index_reg_operand (operands[1], E_SImode)
              || !
#line 16335 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed
   && REGNO (operands[0]) != REGNO (operands[1])))
            return NULL;
          return gen_split_591 (insn, operands);

        default:
          return NULL;
        }

    case LSHIFTRT:
      if (pattern1161 (x3) != 0
          || !
#line 17536 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed))
        return NULL;
      return gen_split_632 (insn, operands);

    case ASHIFTRT:
      if (pattern1161 (x3) != 0
          || !
#line 17536 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed))
        return NULL;
      return gen_split_633 (insn, operands);

    case ROTATE:
      if (pattern1162 (x3) != 0
          || !
#line 18666 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed
   && !optimize_function_for_size_p (cfun)))
        return NULL;
      return gen_split_794 (insn, operands);

    case ROTATERT:
      if (pattern1162 (x3) != 0
          || !
#line 18682 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed
   && !optimize_function_for_size_p (cfun)))
        return NULL;
      return gen_split_795 (insn, operands);

    case CTZ:
      if (pattern1163 (x3, 
E_SImode, 
E_DImode) != 0
          || !
#line 21203 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_BMI || TARGET_CPU_P (GENERIC))
   && (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])))
        return NULL;
      return gen_split_883 (insn, operands);

    case CLZ:
      if (pattern1163 (x3, 
E_SImode, 
E_DImode) != 0
          || !(
#line 21628 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT && TARGET_64BIT) && 
#line 21630 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
        return NULL;
      return gen_split_895 (insn, operands);

    case POPCOUNT:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern348 (x3, 
E_SImode, 
E_DImode) != 0
              || !(
#line 22465 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT) && 
#line 22473 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
            return NULL;
          return gen_split_919 (insn, operands);

        case E_SImode:
          if (pattern348 (x3, 
E_HImode, 
E_SImode) != 0
              || !(
#line 22531 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()) && 
#line 22534 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_921 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_37 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case LSHIFTRT:
      if (GET_MODE (x5) != E_SImode)
        return NULL;
      x6 = XVECEXP (x1, 0, 1);
      if (pattern231 (x6, 
E_CCmode, 
17) != 0
          || !mask_reg_operand (operands[0], E_DImode)
          || GET_MODE (x4) != E_DImode)
        return NULL;
      x7 = XEXP (x5, 0);
      operands[1] = x7;
      if (!mask_reg_operand (operands[1], E_SImode))
        return NULL;
      x8 = XEXP (x5, 1);
      operands[2] = x8;
      if (!const_0_to_31_operand (operands[2], E_VOIDmode)
          || !
#line 2323 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && reload_completed))
        return NULL;
      return gen_split_1238 (insn, operands);

    case UNSPEC:
      if (pattern352 (x1) != 0)
        return NULL;
      switch (pattern1033 (x1))
        {
        case 0:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1350 (insn, operands);

        case 1:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1371 (insn, operands);

        case 2:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1377 (insn, operands);

        case 3:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1413 (insn, operands);

        case 4:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1422 (insn, operands);

        case 5:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1353 (insn, operands);

        case 6:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1356 (insn, operands);

        case 7:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1359 (insn, operands);

        case 8:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1362 (insn, operands);

        case 9:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1365 (insn, operands);

        case 10:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1374 (insn, operands);

        case 11:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1380 (insn, operands);

        case 12:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1383 (insn, operands);

        case 13:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1386 (insn, operands);

        case 14:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1389 (insn, operands);

        case 15:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1392 (insn, operands);

        case 16:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1425 (insn, operands);

        case 17:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1368 (insn, operands);

        case 18:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1416 (insn, operands);

        case 19:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1419 (insn, operands);

        case 20:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1410 (insn, operands);

        case 21:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1351 (insn, operands);

        case 22:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1372 (insn, operands);

        case 23:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1378 (insn, operands);

        case 24:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1414 (insn, operands);

        case 25:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1423 (insn, operands);

        case 26:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1354 (insn, operands);

        case 27:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1357 (insn, operands);

        case 28:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1360 (insn, operands);

        case 29:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1363 (insn, operands);

        case 30:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1366 (insn, operands);

        case 31:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1375 (insn, operands);

        case 32:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1381 (insn, operands);

        case 33:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1384 (insn, operands);

        case 34:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1387 (insn, operands);

        case 35:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1390 (insn, operands);

        case 36:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1393 (insn, operands);

        case 37:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1426 (insn, operands);

        case 38:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1369 (insn, operands);

        case 39:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1417 (insn, operands);

        case 40:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1420 (insn, operands);

        case 41:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1411 (insn, operands);

        case 42:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1352 (insn, operands);

        case 43:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 310 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1373 (insn, operands);

        case 44:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1379 (insn, operands);

        case 45:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1415 (insn, operands);

        case 46:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1424 (insn, operands);

        case 47:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1355 (insn, operands);

        case 48:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1358 (insn, operands);

        case 49:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1361 (insn, operands);

        case 50:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1364 (insn, operands);

        case 51:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1367 (insn, operands);

        case 52:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 311 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1376 (insn, operands);

        case 53:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1382 (insn, operands);

        case 54:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1385 (insn, operands);

        case 55:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1388 (insn, operands);

        case 56:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1391 (insn, operands);

        case 57:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1394 (insn, operands);

        case 58:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1427 (insn, operands);

        case 59:
          if (!((
#line 4439 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 309 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)) && 
#line 4445 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1370 (insn, operands);

        case 60:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1418 (insn, operands);

        case 61:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1421 (insn, operands);

        case 62:
          if (!((
#line 4528 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1412 (insn, operands);

        case 63:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1440 (insn, operands);

        case 64:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1443 (insn, operands);

        case 65:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1452 (insn, operands);

        case 66:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1458 (insn, operands);

        case 67:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1446 (insn, operands);

        case 68:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1449 (insn, operands);

        case 69:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1455 (insn, operands);

        case 70:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1459 (insn, operands);

        case 71:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1460 (insn, operands);

        case 72:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1461 (insn, operands);

        case 73:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1462 (insn, operands);

        case 74:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1463 (insn, operands);

        case 75:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1441 (insn, operands);

        case 76:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1444 (insn, operands);

        case 77:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1453 (insn, operands);

        case 78:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1464 (insn, operands);

        case 79:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1447 (insn, operands);

        case 80:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1450 (insn, operands);

        case 81:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1456 (insn, operands);

        case 82:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1465 (insn, operands);

        case 83:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1466 (insn, operands);

        case 84:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1467 (insn, operands);

        case 85:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1468 (insn, operands);

        case 86:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1469 (insn, operands);

        case 87:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1442 (insn, operands);

        case 88:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1445 (insn, operands);

        case 89:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1454 (insn, operands);

        case 90:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1470 (insn, operands);

        case 91:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1448 (insn, operands);

        case 92:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1451 (insn, operands);

        case 93:
          if (!((
#line 4638 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1457 (insn, operands);

        case 94:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1471 (insn, operands);

        case 95:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1472 (insn, operands);

        case 96:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1473 (insn, operands);

        case 97:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1474 (insn, operands);

        case 98:
          if (!((
#line 4728 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1475 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_72 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern533 (x2))
        {
        case 0:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1991 (insn, operands);

        case 1:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2018 (insn, operands);

        case 2:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2045 (insn, operands);

        case 3:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2072 (insn, operands);

        case 4:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2099 (insn, operands);

        case 5:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2126 (insn, operands);

        case 6:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2153 (insn, operands);

        case 7:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2180 (insn, operands);

        case 8:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2207 (insn, operands);

        case 9:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2234 (insn, operands);

        case 10:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2261 (insn, operands);

        case 11:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2288 (insn, operands);

        case 12:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1994 (insn, operands);

        case 13:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2021 (insn, operands);

        case 14:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2048 (insn, operands);

        case 15:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2075 (insn, operands);

        case 16:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2102 (insn, operands);

        case 17:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2129 (insn, operands);

        case 18:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2156 (insn, operands);

        case 19:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2183 (insn, operands);

        case 20:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2210 (insn, operands);

        case 21:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2237 (insn, operands);

        case 22:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2264 (insn, operands);

        case 23:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2291 (insn, operands);

        case 24:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1997 (insn, operands);

        case 25:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2024 (insn, operands);

        case 26:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2051 (insn, operands);

        case 27:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2078 (insn, operands);

        case 28:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2105 (insn, operands);

        case 29:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2132 (insn, operands);

        case 30:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2159 (insn, operands);

        case 31:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2186 (insn, operands);

        case 32:
          if (!(
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2213 (insn, operands);

        case 33:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2240 (insn, operands);

        case 34:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2267 (insn, operands);

        case 35:
          if (!((
#line 13763 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2294 (insn, operands);

        case 36:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3071 (insn, operands);

        case 37:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3080 (insn, operands);

        case 38:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3089 (insn, operands);

        case 39:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3098 (insn, operands);

        case 40:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3107 (insn, operands);

        case 41:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3116 (insn, operands);

        case 42:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3125 (insn, operands);

        case 43:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3134 (insn, operands);

        case 44:
          if (!(
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3143 (insn, operands);

        case 45:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3152 (insn, operands);

        case 46:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3161 (insn, operands);

        case 47:
          if (!((
#line 13932 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3170 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      switch (pattern534 (x2))
        {
        case 0:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2639 (insn, operands);

        case 1:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2666 (insn, operands);

        case 2:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2693 (insn, operands);

        case 3:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2720 (insn, operands);

        case 4:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2747 (insn, operands);

        case 5:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2774 (insn, operands);

        case 6:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2801 (insn, operands);

        case 7:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2828 (insn, operands);

        case 8:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2855 (insn, operands);

        case 9:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2882 (insn, operands);

        case 10:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2909 (insn, operands);

        case 11:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2936 (insn, operands);

        default:
          return NULL;
        }

    case IOR:
      switch (pattern534 (x2))
        {
        case 0:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2642 (insn, operands);

        case 1:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2669 (insn, operands);

        case 2:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2696 (insn, operands);

        case 3:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2723 (insn, operands);

        case 4:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2750 (insn, operands);

        case 5:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2777 (insn, operands);

        case 6:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2804 (insn, operands);

        case 7:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2831 (insn, operands);

        case 8:
          if (!(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2858 (insn, operands);

        case 9:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2885 (insn, operands);

        case 10:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2912 (insn, operands);

        case 11:
          if (!((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2939 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern1175 (x2, 
E_V32HFmode) != 0
              || !((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2645 (insn, operands);

        case E_V16HFmode:
          if (pattern990 (x2, 
E_V16HFmode) != 0)
            return NULL;
          if (regmem_or_bitnot_regmem_operand (operands[1], E_V16HFmode)
              && regmem_or_bitnot_regmem_operand (operands[2], E_V16HFmode)
              && regmem_or_bitnot_regmem_operand (operands[3], E_V16HFmode))
            {
              x8 = XEXP (x2, 1);
              operands[4] = x8;
              if (regmem_or_bitnot_regmem_operand (operands[4], E_V16HFmode)
                  && ((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_2672 (insn, operands);
            }
          if (!register_operand (operands[1], E_V16HFmode)
              || !register_operand (operands[2], E_V16HFmode)
              || !nonimmediate_operand (operands[3], E_V16HFmode))
            return NULL;
          x8 = XEXP (x2, 1);
          if (rtx_equal_p (x8, operands[1])
              && 
#line 26229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return gen_split_3709 (insn, operands);
          if (!rtx_equal_p (x8, operands[2])
              || !
#line 26241 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return NULL;
          return gen_split_3725 (insn, operands);

        case E_V8HFmode:
          if (pattern990 (x2, 
E_V8HFmode) != 0)
            return NULL;
          if (regmem_or_bitnot_regmem_operand (operands[1], E_V8HFmode)
              && regmem_or_bitnot_regmem_operand (operands[2], E_V8HFmode)
              && regmem_or_bitnot_regmem_operand (operands[3], E_V8HFmode))
            {
              x8 = XEXP (x2, 1);
              operands[4] = x8;
              if (regmem_or_bitnot_regmem_operand (operands[4], E_V8HFmode)
                  && (
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_2699 (insn, operands);
            }
          if (!register_operand (operands[1], E_V8HFmode)
              || !register_operand (operands[2], E_V8HFmode)
              || !nonimmediate_operand (operands[3], E_V8HFmode))
            return NULL;
          x8 = XEXP (x2, 1);
          if (rtx_equal_p (x8, operands[1])
              && 
#line 26229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return gen_split_3710 (insn, operands);
          if (!rtx_equal_p (x8, operands[2])
              || !
#line 26241 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return NULL;
          return gen_split_3726 (insn, operands);

        case E_V32BFmode:
          if (pattern1175 (x2, 
E_V32BFmode) != 0
              || !((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2726 (insn, operands);

        case E_V16BFmode:
          if (pattern1175 (x2, 
E_V16BFmode) != 0
              || !((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2753 (insn, operands);

        case E_V8BFmode:
          if (pattern1175 (x2, 
E_V8BFmode) != 0
              || !(
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2780 (insn, operands);

        case E_V16SFmode:
          if (pattern1175 (x2, 
E_V16SFmode) != 0
              || !((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2807 (insn, operands);

        case E_V8SFmode:
          if (pattern990 (x2, 
E_V8SFmode) != 0)
            return NULL;
          if (regmem_or_bitnot_regmem_operand (operands[1], E_V8SFmode)
              && regmem_or_bitnot_regmem_operand (operands[2], E_V8SFmode)
              && regmem_or_bitnot_regmem_operand (operands[3], E_V8SFmode))
            {
              x8 = XEXP (x2, 1);
              operands[4] = x8;
              if (regmem_or_bitnot_regmem_operand (operands[4], E_V8SFmode)
                  && ((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_2834 (insn, operands);
            }
          if (!register_operand (operands[1], E_V8SFmode)
              || !register_operand (operands[2], E_V8SFmode)
              || !nonimmediate_operand (operands[3], E_V8SFmode))
            return NULL;
          x8 = XEXP (x2, 1);
          if (rtx_equal_p (x8, operands[1])
              && 
#line 26229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return gen_split_3711 (insn, operands);
          if (!rtx_equal_p (x8, operands[2])
              || !
#line 26241 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return NULL;
          return gen_split_3727 (insn, operands);

        case E_V4SFmode:
          if (pattern990 (x2, 
E_V4SFmode) != 0)
            return NULL;
          if (regmem_or_bitnot_regmem_operand (operands[1], E_V4SFmode)
              && regmem_or_bitnot_regmem_operand (operands[2], E_V4SFmode)
              && regmem_or_bitnot_regmem_operand (operands[3], E_V4SFmode))
            {
              x8 = XEXP (x2, 1);
              operands[4] = x8;
              if (regmem_or_bitnot_regmem_operand (operands[4], E_V4SFmode)
                  && (
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_2861 (insn, operands);
            }
          if (!register_operand (operands[1], E_V4SFmode)
              || !register_operand (operands[2], E_V4SFmode)
              || !nonimmediate_operand (operands[3], E_V4SFmode))
            return NULL;
          x8 = XEXP (x2, 1);
          if (rtx_equal_p (x8, operands[1])
              && 
#line 26229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return gen_split_3712 (insn, operands);
          if (!rtx_equal_p (x8, operands[2])
              || !
#line 26241 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return NULL;
          return gen_split_3728 (insn, operands);

        case E_V8DFmode:
          if (pattern1175 (x2, 
E_V8DFmode) != 0
              || !((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2888 (insn, operands);

        case E_V4DFmode:
          if (pattern990 (x2, 
E_V4DFmode) != 0)
            return NULL;
          if (regmem_or_bitnot_regmem_operand (operands[1], E_V4DFmode)
              && regmem_or_bitnot_regmem_operand (operands[2], E_V4DFmode)
              && regmem_or_bitnot_regmem_operand (operands[3], E_V4DFmode))
            {
              x8 = XEXP (x2, 1);
              operands[4] = x8;
              if (regmem_or_bitnot_regmem_operand (operands[4], E_V4DFmode)
                  && ((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_2915 (insn, operands);
            }
          if (!register_operand (operands[1], E_V4DFmode)
              || !register_operand (operands[2], E_V4DFmode)
              || !nonimmediate_operand (operands[3], E_V4DFmode))
            return NULL;
          x8 = XEXP (x2, 1);
          if (rtx_equal_p (x8, operands[1])
              && 
#line 26229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return gen_split_3713 (insn, operands);
          if (!rtx_equal_p (x8, operands[2])
              || !
#line 26241 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return NULL;
          return gen_split_3729 (insn, operands);

        case E_V2DFmode:
          if (pattern990 (x2, 
E_V2DFmode) != 0)
            return NULL;
          if (regmem_or_bitnot_regmem_operand (operands[1], E_V2DFmode)
              && regmem_or_bitnot_regmem_operand (operands[2], E_V2DFmode)
              && regmem_or_bitnot_regmem_operand (operands[3], E_V2DFmode))
            {
              x8 = XEXP (x2, 1);
              operands[4] = x8;
              if (regmem_or_bitnot_regmem_operand (operands[4], E_V2DFmode)
                  && ((
#line 13848 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return gen_split_2942 (insn, operands);
            }
          if (!register_operand (operands[1], E_V2DFmode)
              || !register_operand (operands[2], E_V2DFmode)
              || !nonimmediate_operand (operands[3], E_V2DFmode))
            return NULL;
          x8 = XEXP (x2, 1);
          if (rtx_equal_p (x8, operands[1])
              && 
#line 26229 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return gen_split_3714 (insn, operands);
          if (!rtx_equal_p (x8, operands[2])
              || !
#line 26241 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
            return NULL;
          return gen_split_3730 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_83 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL)
    return NULL;
  x4 = XEXP (x2, 0);
  switch (GET_CODE (x4))
    {
    case VEC_CONCAT:
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case MINUS:
          switch (pattern721 (x2, 
PLUS))
            {
            case 0:
              if (pattern1647 (x4, 
E_V8SFmode, 
E_V16SFmode) != 0
                  || !(
#line 3593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return NULL;
              return gen_split_1314 (insn, operands);

            case 1:
              if (pattern1647 (x4, 
E_V4SFmode, 
E_V8SFmode) != 0
                  || !
#line 3593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))))
                return NULL;
              return gen_split_1315 (insn, operands);

            case 2:
              if (pattern1647 (x4, 
E_V4DFmode, 
E_V8DFmode) != 0
                  || !(
#line 3593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return NULL;
              return gen_split_1316 (insn, operands);

            case 3:
              if (pattern1647 (x4, 
E_V2DFmode, 
E_V4DFmode) != 0
                  || !(
#line 3593 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return NULL;
              return gen_split_1317 (insn, operands);

            default:
              return NULL;
            }

        case PLUS:
          switch (pattern721 (x2, 
MINUS))
            {
            case 0:
              if (pattern1648 (x4, 
E_V8SFmode, 
E_V16SFmode) != 0
                  || !(
#line 3627 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 421 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return NULL;
              return gen_split_1318 (insn, operands);

            case 1:
              if (pattern1648 (x4, 
E_V4SFmode, 
E_V8SFmode) != 0
                  || !
#line 3627 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))))
                return NULL;
              return gen_split_1319 (insn, operands);

            case 2:
              if (pattern1648 (x4, 
E_V4DFmode, 
E_V8DFmode) != 0
                  || !(
#line 3627 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return NULL;
              return gen_split_1320 (insn, operands);

            case 3:
              if (pattern1648 (x4, 
E_V2DFmode, 
E_V4DFmode) != 0
                  || !(
#line 3627 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3
   && can_create_pseudo_p ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))) && 
#line 422 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return NULL;
              return gen_split_1321 (insn, operands);

            default:
              return NULL;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x5;
          res = split_59 (x1, insn);
          if (res != NULL_RTX)
            return res;
          if (XVECLEN (x3, 0) < 1)
            return NULL;
          operands[4] = x3;
          switch (pattern801 (x2))
            {
            case 0:
              if ((
#line 24156 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 24158 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3517 (insn, operands);
              break;

            case 1:
              if ((
#line 24156 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 24158 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3518 (insn, operands);
              break;

            case 2:
              if ((
#line 24156 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 24158 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3519 (insn, operands);
              break;

            case 3:
              if (((
#line 24209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 953 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 24211 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3521 (insn, operands);
              break;

            case 4:
              if (((
#line 24209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 953 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 24211 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3522 (insn, operands);
              break;

            case 5:
              if (((
#line 24209 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512) && 
#line 953 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 24211 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3523 (insn, operands);
              break;

            case 6:
              if ((
#line 24320 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 24322 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3529 (insn, operands);
              break;

            case 7:
              if ((
#line 24320 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 24322 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3530 (insn, operands);
              break;

            case 8:
              if ((
#line 24320 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 24322 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3531 (insn, operands);
              break;

            case 9:
              if (((
#line 24553 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 956 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 24555 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3541 (insn, operands);
              break;

            case 10:
              if (((
#line 24553 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 956 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 24555 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3542 (insn, operands);
              break;

            case 11:
              if (((
#line 24553 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 956 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 24555 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3543 (insn, operands);
              break;

            case 12:
              if ((
#line 24607 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 24609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3545 (insn, operands);
              break;

            case 13:
              if ((
#line 24607 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 24609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3546 (insn, operands);
              break;

            case 14:
              if ((
#line 24607 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 24609 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3547 (insn, operands);
              break;

            case 15:
              if ((
#line 24725 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 24727 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3553 (insn, operands);
              break;

            case 16:
              if ((
#line 24725 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 24727 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3554 (insn, operands);
              break;

            case 17:
              if ((
#line 24725 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 24727 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return gen_split_3555 (insn, operands);
              break;

            default:
              break;
            }
          operands[3] = x3;
          switch (pattern802 (x2))
            {
            case 0:
              if (!((
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 29065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3776 (insn, operands);

            case 1:
              if (!((
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 331 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 29065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3777 (insn, operands);

            case 2:
              if (!(
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 29065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3778 (insn, operands);

            case 3:
              if (!((
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 29065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3779 (insn, operands);

            case 4:
              if (!((
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 332 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 29065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3780 (insn, operands);

            case 5:
              if (!(
#line 29063 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 29065 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3781 (insn, operands);

            default:
              return NULL;
            }

        case VEC_CONCAT:
          switch (pattern521 (x2))
            {
            case 0:
              if (!(
#line 25108 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512) && 
#line 25110 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3576 (insn, operands);

            case 1:
              if (!(
#line 25160 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2) && 
#line 25162 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3578 (insn, operands);

            case 2:
              if (!(
#line 25256 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 25258 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_3584 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      res = split_63 (x1, insn);
      if (res != NULL_RTX)
        return res;
      if (GET_CODE (x4) != SUBREG)
        return NULL;
      switch (pattern523 (x2))
        {
        case 0:
          if (!(
#line 15021 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512 && ix86_pre_reload_split ()) && 
#line 15023 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3184 (insn, operands);

        case 1:
          if (!(
#line 15074 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 15076 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3186 (insn, operands);

        default:
          return NULL;
        }

    case UNSPEC:
      if (XVECLEN (x4, 0) != 2)
        return NULL;
      switch (pattern525 (x2))
        {
        case 0:
          if (!(
#line 14996 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512 && ix86_pre_reload_split ()) && 
#line 14998 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3183 (insn, operands);

        case 1:
          if (!(
#line 15258 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512VBMI
   && ix86_pre_reload_split ()) && 
#line 15261 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3189 (insn, operands);

        case 2:
          if (!(
#line 15053 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 15055 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3185 (insn, operands);

        case 3:
          if (!(
#line 15105 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512 && ix86_pre_reload_split ()) && 
#line 15107 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3187 (insn, operands);

        case 4:
          if (!(
#line 15177 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI && TARGET_EVEX512 && ix86_pre_reload_split ()) && 
#line 15179 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3188 (insn, operands);

        case 5:
          if (!(
#line 15277 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()) && 
#line 15279 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3190 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_insns (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  rtx_insn *res ATTRIBUTE_UNUSED;
  recog_data.insn = NULL;
  switch (GET_CODE (x1))
    {
    case EH_RETURN:
      if (!
#line 20878 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(epilogue_completed))
        return NULL;
      return gen_split_875 (insn, operands);

    case PARALLEL:
    case UNSPEC:
    case UNSPEC_VOLATILE:
    case SET:
      switch (GET_CODE (x1))
        {
        case SET:
          res = split_13 (x1, insn);
          if (res != NULL_RTX)
            return res;
          break;

        case PARALLEL:
          res = split_35 (x1, insn);
          if (res != NULL_RTX)
            return res;
          break;

        default:
          break;
        }
      operands[0] = x1;
      if (tls_address_pattern (operands[0], E_VOIDmode)
          && 
#line 23414 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_TLS_DIRECT_SEG_REFS))
        return gen_split_932 (insn, operands);
      switch (GET_CODE (x1))
        {
        case PARALLEL:
          return split_85 (x1, insn);

        case SET:
          x2 = XEXP (x1, 1);
          switch (GET_CODE (x2))
            {
            case NEG:
              res = split_39 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case IF_THEN_ELSE:
              res = split_41 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case UNSPEC:
              res = split_42 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case COMPARE:
              res = split_43 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case NOT:
              res = split_44 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case REG:
            case SUBREG:
            case MEM:
              res = split_45 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case CONST_INT:
            case CONST_DOUBLE:
            case CONST_VECTOR:
              operands[1] = x2;
              x3 = XEXP (x1, 0);
              operands[0] = x3;
              switch (GET_MODE (operands[0]))
                {
                case E_V8QImode:
                  if (nonimmediate_gr_operand (operands[0], E_V8QImode)
                      && const0_operand (operands[1], E_V8QImode)
                      && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_64BIT && reload_completed))
                    return gen_split_1002 (insn, operands);
                  if (memory_operand (operands[0], E_V8QImode)
                      && x86_64_const_vector_operand (operands[1], E_V8QImode)
                      && (
#line 87 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                    return gen_split_1013 (insn, operands);
                  break;

                case E_V4HImode:
                  if (nonimmediate_gr_operand (operands[0], E_V4HImode)
                      && const0_operand (operands[1], E_V4HImode)
                      && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_64BIT && reload_completed))
                    return gen_split_1003 (insn, operands);
                  if (memory_operand (operands[0], E_V4HImode)
                      && x86_64_const_vector_operand (operands[1], E_V4HImode)
                      && (
#line 87 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                    return gen_split_1014 (insn, operands);
                  break;

                case E_V2SImode:
                  if (nonimmediate_gr_operand (operands[0], E_V2SImode)
                      && const0_operand (operands[1], E_V2SImode)
                      && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_64BIT && reload_completed))
                    return gen_split_1004 (insn, operands);
                  if (memory_operand (operands[0], E_V2SImode)
                      && x86_64_const_vector_operand (operands[1], E_V2SImode)
                      && (
#line 89 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                    return gen_split_1017 (insn, operands);
                  break;

                case E_V1DImode:
                  if (nonimmediate_gr_operand (operands[0], E_V1DImode)
                      && const0_operand (operands[1], E_V1DImode)
                      && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_64BIT && reload_completed))
                    return gen_split_1005 (insn, operands);
                  break;

                case E_V2SFmode:
                  if (nonimmediate_gr_operand (operands[0], E_V2SFmode)
                      && const0_operand (operands[1], E_V2SFmode)
                      && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_64BIT && reload_completed))
                    return gen_split_1006 (insn, operands);
                  if (memory_operand (operands[0], E_V2SFmode)
                      && x86_64_const_vector_operand (operands[1], E_V2SFmode)
                      && (
#line 89 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                    return gen_split_1018 (insn, operands);
                  break;

                case E_V4HFmode:
                  if (nonimmediate_gr_operand (operands[0], E_V4HFmode)
                      && const0_operand (operands[1], E_V4HFmode)
                      && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_64BIT && reload_completed))
                    return gen_split_1007 (insn, operands);
                  if (memory_operand (operands[0], E_V4HFmode)
                      && x86_64_const_vector_operand (operands[1], E_V4HFmode)
                      && (
#line 88 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                    return gen_split_1015 (insn, operands);
                  break;

                case E_V4BFmode:
                  if (nonimmediate_gr_operand (operands[0], E_V4BFmode)
                      && const0_operand (operands[1], E_V4BFmode)
                      && 
#line 317 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_64BIT && reload_completed))
                    return gen_split_1008 (insn, operands);
                  if (memory_operand (operands[0], E_V4BFmode)
                      && x86_64_const_vector_operand (operands[1], E_V4BFmode)
                      && (
#line 88 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT) && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                    return gen_split_1016 (insn, operands);
                  break;

                case E_V2QImode:
                  if (memory_operand (operands[0], E_V2QImode)
                      && x86_64_const_vector_operand (operands[1], E_V2QImode)
                      && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed))
                    return gen_split_1009 (insn, operands);
                  break;

                case E_V4QImode:
                  if (memory_operand (operands[0], E_V4QImode)
                      && x86_64_const_vector_operand (operands[1], E_V4QImode)
                      && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed))
                    return gen_split_1010 (insn, operands);
                  break;

                case E_V2HImode:
                  if (memory_operand (operands[0], E_V2HImode)
                      && x86_64_const_vector_operand (operands[1], E_V2HImode)
                      && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed))
                    return gen_split_1011 (insn, operands);
                  break;

                case E_V2HFmode:
                  if (memory_operand (operands[0], E_V2HFmode)
                      && x86_64_const_vector_operand (operands[1], E_V2HFmode)
                      && 
#line 417 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( reload_completed))
                    return gen_split_1012 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            case PLUS:
              res = split_46 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case MINUS:
              res = split_47 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case VEC_SELECT:
              res = split_49 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case LT:
              x3 = XEXP (x1, 0);
              operands[0] = x3;
              switch (pattern236 (x2))
                {
                case 0:
                  if ((
#line 3873 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()) && 
#line 3875 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( 1)))
                    return gen_split_1058 (insn, operands);
                  break;

                case 1:
                  if ((
#line 3873 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()) && 
#line 3875 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( 1)))
                    return gen_split_1059 (insn, operands);
                  break;

                case 2:
                  if ((
#line 3962 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()) && 
#line 3964 "/tmp/pkg/src/gcc/gcc/config/i386/mmx.md"
( 1)))
                    return gen_split_1063 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            case AND:
              res = split_50 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case VEC_CONCAT:
              res = split_51 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case VEC_MERGE:
              res = split_52 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case ZERO_EXTEND:
              res = split_53 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case IOR:
              x3 = XEXP (x1, 0);
              operands[0] = x3;
              switch (pattern238 (x2))
                {
                case 0:
                  if (
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                    return gen_split_1190 (insn, operands);
                  break;

                case 1:
                  if (
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                    return gen_split_1193 (insn, operands);
                  break;

                case 2:
                  if ((
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                    return gen_split_1196 (insn, operands);
                  break;

                case 3:
                  if ((
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                    return gen_split_1199 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            case XOR:
              x3 = XEXP (x1, 0);
              operands[0] = x3;
              switch (pattern238 (x2))
                {
                case 0:
                  if (
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                    return gen_split_1191 (insn, operands);
                  break;

                case 1:
                  if (
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                    return gen_split_1194 (insn, operands);
                  break;

                case 2:
                  if ((
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                    return gen_split_1197 (insn, operands);
                  break;

                case 3:
                  if ((
#line 2118 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                    return gen_split_1200 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            case ASHIFT:
              switch (pattern52 (x1))
                {
                case 0:
                  if (
#line 2282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                    return gen_split_1222 (insn, operands);
                  break;

                case 1:
                  if (
#line 2282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                    return gen_split_1224 (insn, operands);
                  break;

                case 2:
                  if ((
#line 2282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                    return gen_split_1226 (insn, operands);
                  break;

                case 3:
                  if ((
#line 2282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                    return gen_split_1228 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            case LSHIFTRT:
              switch (pattern52 (x1))
                {
                case 0:
                  if (
#line 2282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                    return gen_split_1223 (insn, operands);
                  break;

                case 1:
                  if (
#line 2282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                    return gen_split_1225 (insn, operands);
                  break;

                case 2:
                  if ((
#line 2282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                    return gen_split_1227 (insn, operands);
                  break;

                case 3:
                  if ((
#line 2282 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                    return gen_split_1229 (insn, operands);
                  break;

                default:
                  break;
                }
              break;

            case SIGN_EXTEND:
              res = split_54 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            case SS_PLUS:
              if (pattern54 (x1) == 0
                  && 
#line 22623 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && reload_completed
   && SSE_REGNO_P (REGNO (operands[0]))))
                return gen_split_3473 (insn, operands);
              break;

            case SS_MINUS:
              if (pattern54 (x1) == 0
                  && 
#line 22623 "/tmp/pkg/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && reload_completed
   && SSE_REGNO_P (REGNO (operands[0]))))
                return gen_split_3475 (insn, operands);
              break;

            case NE:
            case EQ:
              res = split_55 (x1, insn);
              if (res != NULL_RTX)
                return res;
              break;

            default:
              break;
            }
          x3 = XEXP (x1, 0);
          operands[0] = x3;
          return split_84 (x1, insn);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_3 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 2
      || peep2_current_count < 3)
    return NULL;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  if (!bt_comparison_operator (operands[1], E_QImode))
    return NULL;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCZmode)
    return NULL;
  x4 = XEXP (x2, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return NULL;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  if (!nonimmediate_operand (operands[0], E_QImode))
    return NULL;
  x6 = PATTERN (peep2_next_insn (1));
  if (pattern1240 (x6, 
0) != 0)
    return NULL;
  x7 = PATTERN (peep2_next_insn (2));
  x8 = XEXP (x7, 1);
  x9 = XEXP (x8, 0);
  operands[2] = x9;
  if (pattern1764 (x7) != 0)
    return NULL;
  x10 = XEXP (x8, 1);
  operands[3] = x10;
  if (!
#line 19683 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(peep2_regno_dead_p (3, FLAGS_REG)))
    return NULL;
  *pmatch_len_ = 2;
  return gen_peephole2_168 (insn, operands);
}

 rtx_insn *
peephole2_5 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case REG:
      if (peep2_current_count < 2)
        return NULL;
      operands[0] = x2;
      x3 = PATTERN (peep2_next_insn (1));
      if (GET_CODE (x3) != SET)
        return NULL;
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != STRICT_LOW_PART)
        return NULL;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!general_reg_operand (operands[0], E_SImode))
            return NULL;
          switch (pattern1328 ())
            {
            case 0:
              if (!
#line 4960 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (SImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_45 (insn, operands);

            case 1:
              if (!
#line 4960 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (SImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_47 (insn, operands);

            default:
              return NULL;
            }

        case E_DImode:
          if (!general_reg_operand (operands[0], E_DImode))
            return NULL;
          switch (pattern1328 ())
            {
            case 0:
              if (!(
#line 4960 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (DImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_46 (insn, operands);

            case 1:
              if (!(
#line 4960 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) == REGNO (operands[1])
   && (DImode != SImode
       || !TARGET_ZERO_EXTEND_WITH_AND
       || !optimize_function_for_speed_p (cfun))) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              *pmatch_len_ = 1;
              return gen_peephole2_48 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case SUBREG:
    case MEM:
      operands[0] = x2;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!memory_operand (operands[0], E_QImode)
              || !
#line 27840 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p ()
   && ((QImode == HImode
       && TARGET_LCP_STALL)
       || (!TARGET_USE_MOV0
          && TARGET_SPLIT_LONG_MOVES
          && get_attr_length (insn) >= ix86_cur_cost ()->large_insn))
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_256 (insn, operands);

        case E_HImode:
          if (!memory_operand (operands[0], E_HImode)
              || !
#line 27840 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(optimize_insn_for_speed_p ()
   && ((HImode == HImode
       && TARGET_LCP_STALL)
       || (!TARGET_USE_MOV0
          && TARGET_SPLIT_LONG_MOVES
          && get_attr_length (insn) >= ix86_cur_cost ()->large_insn))
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_257 (insn, operands);

        default:
          return NULL;
        }

    case STRICT_LOW_PART:
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!general_reg_operand (operands[0], E_QImode)
              || !
#line 28527 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((! TARGET_USE_MOV0 || optimize_insn_for_size_p ())
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_333 (insn, operands);

        case E_HImode:
          if (!general_reg_operand (operands[0], E_HImode)
              || !
#line 28527 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((! TARGET_USE_MOV0 || optimize_insn_for_size_p ())
   && peep2_regno_dead_p (0, FLAGS_REG)))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_334 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_7 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  switch (GET_CODE (operands[0]))
    {
    case REG:
    case SUBREG:
      if (peep2_current_count < 2
          || peep2_current_count < 3)
        return NULL;
      x4 = PATTERN (peep2_next_insn (1));
      if (GET_CODE (x4) != PARALLEL
          || pattern835 (x4) != 0)
        return NULL;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!memory_operand (operands[1], E_QImode))
            return NULL;
          if (general_reg_operand (operands[0], E_QImode))
            {
              switch (pattern1515 (x4, 
E_QImode))
                {
                case 0:
                  if (
#line 8713 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_68 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 1:
                  if (
#line 9999 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_108 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 2:
                  if (
#line 8830 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_76 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 3:
                  if (
#line 8856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_80 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 4:
                  if (
#line 9314 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_90 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 5:
                  if (
#line 9340 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_94 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                default:
                  break;
                }
            }
          if (!register_operand (operands[0], E_QImode))
            return NULL;
          switch (pattern1516 (x4, 
E_QImode))
            {
            case 0:
              x5 = PATTERN (peep2_next_insn (2));
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[1])
                  && 
#line 28145 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && ix86_match_ccmode (peep2_next_insn (1),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                {
                  *pmatch_len_ = 2;
                  res = gen_peephole2_297 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (peep2_current_count < 4
                  || pattern1787 (x6, 
E_QImode) != 0
                  || !
#line 28385 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && ix86_match_ccmode (peep2_next_insn (1),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_321 (insn, operands);

            case 1:
              x5 = PATTERN (peep2_next_insn (2));
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[1]))
                {
                  x7 = PATTERN (peep2_next_insn (3));
                  if (pattern1785 (x7) == 0
                      && 
#line 28268 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[0]) == REGNO (operands[4])
   && peep2_reg_dead_p (4, operands[0])
   && (QImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_313 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                }
              if (peep2_current_count < 5
                  || pattern1829 (x6, 
E_QImode) != 0
                  || !
#line 28345 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[0]) == REGNO (operands[4])
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[5])
   && (QImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                return NULL;
              *pmatch_len_ = 4;
              return gen_peephole2_319 (insn, operands);

            default:
              return NULL;
            }

        case E_HImode:
          if (!memory_operand (operands[1], E_HImode))
            return NULL;
          if (general_reg_operand (operands[0], E_HImode))
            {
              switch (pattern1515 (x4, 
E_HImode))
                {
                case 0:
                  if (
#line 8713 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_69 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 1:
                  if (
#line 9999 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_109 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 2:
                  if (
#line 8830 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_77 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 3:
                  if (
#line 8856 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_81 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 4:
                  if (
#line 9314 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
                    {
                      *pmatch_len_ = 2;
                      res = gen_peephole2_91 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                case 5:
                  if (
#line 9340 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[5])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_95 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                  break;

                default:
                  break;
                }
            }
          if (!register_operand (operands[0], E_HImode))
            return NULL;
          switch (pattern1516 (x4, 
E_HImode))
            {
            case 0:
              x5 = PATTERN (peep2_next_insn (2));
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[1])
                  && 
#line 28145 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && ix86_match_ccmode (peep2_next_insn (1),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                {
                  *pmatch_len_ = 2;
                  res = gen_peephole2_298 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
              if (peep2_current_count < 4
                  || pattern1787 (x6, 
E_HImode) != 0
                  || !
#line 28385 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (4, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && ix86_match_ccmode (peep2_next_insn (1),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                return NULL;
              *pmatch_len_ = 3;
              return gen_peephole2_322 (insn, operands);

            case 1:
              x5 = PATTERN (peep2_next_insn (2));
              x6 = XEXP (x5, 0);
              if (rtx_equal_p (x6, operands[1]))
                {
                  x7 = PATTERN (peep2_next_insn (3));
                  if (pattern1785 (x7) == 0
                      && 
#line 28268 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[0]) == REGNO (operands[4])
   && peep2_reg_dead_p (4, operands[0])
   && (HImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                    {
                      *pmatch_len_ = 3;
                      res = gen_peephole2_314 (insn, operands);
                      if (res != NULL_RTX)
                        return res;
                    }
                }
              if (peep2_current_count < 5
                  || pattern1829 (x6, 
E_HImode) != 0
                  || !
#line 28345 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[0]) == REGNO (operands[4])
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[5])
   && (HImode != QImode
       || immediate_operand (operands[2], SImode)
       || any_QIreg_operand (operands[2], SImode))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[5], operands[1])
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                return NULL;
              *pmatch_len_ = 4;
              return gen_peephole2_320 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case MEM:
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!push_operand (operands[0], E_QImode)
              || !memory_operand (operands[1], E_QImode)
              || !
#line 27818 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_PUSH_MEMORY || optimize_insn_for_size_p ())
   && !RTX_FRAME_RELATED_P (peep2_next_insn (0))))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_251 (insn, operands);

        case E_HImode:
          if (!push_operand (operands[0], E_HImode)
              || !memory_operand (operands[1], E_HImode)
              || !
#line 27818 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_PUSH_MEMORY || optimize_insn_for_size_p ())
   && !RTX_FRAME_RELATED_P (peep2_next_insn (0))))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_252 (insn, operands);

        case E_SFmode:
          if (!push_operand (operands[0], E_SFmode)
              || !memory_operand (operands[1], E_SFmode)
              || !
#line 27829 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_PUSH_MEMORY || optimize_insn_for_size_p ())
   && !RTX_FRAME_RELATED_P (peep2_next_insn (0))))
            return NULL;
          *pmatch_len_ = 0;
          return gen_peephole2_255 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_17 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 0);
  if (!general_reg_operand (x3, E_DImode))
    return NULL;
  operands[8] = x3;
  switch (pattern949 (x1, 
E_DImode, 
E_TImode))
    {
    case 0:
      if ((
#line 9672 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 3;
          res = gen_peephole2_101 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    case 1:
      if ((
#line 9727 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (6, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && !reg_overlap_mentioned_p (operands[0], operands[10])
   && !reg_overlap_mentioned_p (operands[10], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[11])
   && !reg_overlap_mentioned_p (operands[11], operands[1])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 5;
          res = gen_peephole2_103 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    default:
      break;
    }
  operands[0] = x3;
  if (pattern952 (x1, 
E_DImode) != 0
      || !(
#line 26563 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
  && REGNO (operands[2]) != REGNO (operands[0])
  && REGNO (operands[2]) != REGNO (operands[1])
  && peep2_reg_dead_p (2, operands[1])
  && peep2_reg_dead_p (4, operands[2])
  && !reg_overlap_mentioned_p (operands[0], operands[3])
  && !reg_mentioned_p (operands[2], operands[6])) && 
#line 1164 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
    return NULL;
  *pmatch_len_ = 3;
  return gen_peephole2_208 (insn, operands);
}

 rtx_insn *
peephole2_21 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 1);
  if (!binary_fp_operator (x3, E_VOIDmode))
    return NULL;
  operands[2] = x3;
  x4 = XEXP (x2, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return NULL;
  x5 = XEXP (x3, 0);
  switch (GET_CODE (x5))
    {
    case REG:
      if (!rtx_equal_p (x5, operands[0]))
        return NULL;
      x6 = XEXP (x3, 1);
      operands[3] = x6;
      if (!memory_operand (operands[3], E_VOIDmode)
          || !
#line 26871 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_211 (insn, operands);

    case SUBREG:
    case MEM:
      operands[3] = x5;
      if (!memory_operand (operands[3], E_VOIDmode))
        return NULL;
      x6 = XEXP (x3, 1);
      if (!rtx_equal_p (x6, operands[0])
          || !
#line 26893 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])))
        return NULL;
      *pmatch_len_ = 1;
      return gen_peephole2_212 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_22 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count >= 3)
    {
      res = peephole2_20 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  operands[1] = x3;
  if (fp_register_operand (operands[1], E_VOIDmode)
      && fp_register_operand (operands[0], E_VOIDmode))
    {
      res = peephole2_21 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (general_reg_operand (operands[1], E_QImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern414 (x4, 
E_QImode) == 0
          && 
#line 28018 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   && (QImode != QImode
       || any_QIreg_operand (operands[1], QImode))))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_279 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (general_reg_operand (operands[1], E_HImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern414 (x4, 
E_HImode) == 0
          && 
#line 28018 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   && (HImode != QImode
       || any_QIreg_operand (operands[1], QImode))))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_280 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (general_reg_operand (operands[1], E_DImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern414 (x4, 
E_DImode) == 0
          && (
#line 28018 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   && (DImode != QImode
       || any_QIreg_operand (operands[1], QImode))) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_282 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (peep2_current_count < 3
      || peep2_current_count < 4)
    return NULL;
  if (memory_operand (operands[1], E_QImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern724 (x4, 
E_QImode) == 0)
        {
          x5 = PATTERN (peep2_next_insn (2));
          x6 = XEXP (x5, 0);
          if (rtx_equal_p (x6, operands[1]))
            {
              x7 = PATTERN (peep2_next_insn (3));
              if (pattern1785 (x7) == 0
                  && 
#line 28109 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (QImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                {
                  *pmatch_len_ = 3;
                  res = gen_peephole2_293 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          if (peep2_current_count >= 5
              && pattern1786 (x6, 
E_QImode) == 0
              && 
#line 28307 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && (QImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
            {
              *pmatch_len_ = 4;
              res = gen_peephole2_315 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
    }
  if (memory_operand (operands[1], E_HImode))
    {
      x4 = PATTERN (peep2_next_insn (1));
      if (pattern724 (x4, 
E_HImode) == 0)
        {
          x5 = PATTERN (peep2_next_insn (2));
          x6 = XEXP (x5, 0);
          if (rtx_equal_p (x6, operands[1]))
            {
              x7 = PATTERN (peep2_next_insn (3));
              if (pattern1785 (x7) == 0
                  && 
#line 28109 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (HImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
                {
                  *pmatch_len_ = 3;
                  res = gen_peephole2_294 (insn, operands);
                  if (res != NULL_RTX)
                    return res;
                }
            }
          if (peep2_current_count >= 5
              && pattern1786 (x6, 
E_HImode) == 0
              && 
#line 28307 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && (HImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)))
            {
              *pmatch_len_ = 4;
              res = gen_peephole2_316 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
    }
  if (!memory_operand (operands[1], E_DImode)
      || !register_operand (operands[0], E_DImode))
    return NULL;
  x4 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 2)
    return NULL;
  x8 = XVECEXP (x4, 0, 0);
  if (GET_CODE (x8) != SET)
    return NULL;
  x9 = XEXP (x8, 1);
  if (!plusminuslogic_operator (x9, E_DImode))
    return NULL;
  operands[3] = x9;
  x10 = XVECEXP (x4, 0, 1);
  if (GET_CODE (x10) != CLOBBER)
    return NULL;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != REG
      || REGNO (x11) != 17
      || GET_MODE (x11) != E_CCmode)
    return NULL;
  x12 = XEXP (x9, 1);
  operands[2] = x12;
  if (!x86_64_nonmemory_operand (operands[2], E_DImode)
      || pattern723 (x8) != 0)
    return NULL;
  x5 = PATTERN (peep2_next_insn (2));
  x6 = XEXP (x5, 0);
  if (rtx_equal_p (x6, operands[1]))
    {
      x7 = PATTERN (peep2_next_insn (3));
      if (pattern1785 (x7) == 0
          && (
#line 28109 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (DImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 3;
          res = gen_peephole2_296 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (peep2_current_count < 5
      || pattern1786 (x6, 
E_DImode) != 0
      || !(
#line 28307 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (3, operands[0])
   && peep2_reg_dead_p (5, operands[4])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && !reg_overlap_mentioned_p (operands[4], operands[1])
   && (DImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (4),
			 (GET_CODE (operands[3]) == PLUS
			  || GET_CODE (operands[3]) == MINUS)
			 ? CCGOCmode : CCNOmode)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
    return NULL;
  *pmatch_len_ = 4;
  return gen_peephole2_318 (insn, operands);
}

 rtx_insn *
peephole2_35 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 3)
    return NULL;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  if (!register_operand (operands[0], E_QImode))
    return NULL;
  x3 = PATTERN (peep2_next_insn (1));
  if (pattern415 (x3, 
UNSPEC_VOLATILE, 
3) != 0)
    return NULL;
  x4 = XVECEXP (x3, 0, 0);
  x5 = XEXP (x4, 1);
  if (XVECLEN (x5, 0) == 4
      && XINT (x5, 1) == 109
      && GET_MODE (x5) == E_QImode)
    {
      res = peephole2_34 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (XVECLEN (x5, 0) != 2
      || XINT (x5, 1) != 110
      || GET_MODE (x5) != E_QImode)
    return NULL;
  x6 = XEXP (x1, 1);
  operands[2] = x6;
  if (!const_int_operand (operands[2], E_QImode))
    return NULL;
  x7 = XVECEXP (x3, 0, 1);
  if (GET_CODE (x7) != SET)
    return NULL;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != PLUS
      || GET_MODE (x8) != E_QImode
      || pattern1492 (x3) != 0
      || !memory_operand (operands[1], E_QImode)
      || pattern1674 (x3) != 0)
    return NULL;
  x9 = PATTERN (peep2_next_insn (2));
  x10 = XEXP (x9, 1);
  x11 = XEXP (x10, 1);
  operands[3] = x11;
  if (!const_int_operand (operands[3], E_QImode))
    return NULL;
  x12 = XEXP (x10, 0);
  if (!rtx_equal_p (x12, operands[0])
      || !
#line 724 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
    return NULL;
  *pmatch_len_ = 2;
  return gen_peephole2_415 (insn, operands);
}

 rtx_insn *
peephole2_40 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (pattern231 (x2, 
E_CCmode, 
17) != 0)
    return NULL;
  x3 = XVECEXP (x1, 0, 0);
  x4 = XEXP (x3, 1);
  switch (XWINT (x4, 0))
    {
    case 0L:
      res = peephole2_39 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
      break;

    case 1L:
      x5 = XEXP (x3, 0);
      if (GET_CODE (x5) == ZERO_EXTRACT
          && pattern1057 (x5) == 0
          && 
#line 19089 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && !TARGET_USE_BT))
        {
          *pmatch_len_ = 0;
          res = gen_peephole2_165 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    default:
      break;
    }
  if (peep2_current_count < 2
      || peep2_current_count < 3)
    return NULL;
  x5 = XEXP (x3, 0);
  operands[0] = x5;
  x6 = PATTERN (peep2_next_insn (1));
  if (pattern415 (x6, 
UNSPEC_VOLATILE, 
3) != 0)
    return NULL;
  x7 = XVECEXP (x6, 0, 1);
  if (GET_CODE (x7) != SET)
    return NULL;
  x8 = PATTERN (peep2_next_insn (2));
  if (pattern1517 (x8) != 0)
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode))
        return NULL;
      operands[1] = x4;
      switch (pattern1789 (x6, 
E_SImode))
        {
        case 0:
          if (
#line 557 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_407 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 1:
          if (
#line 557 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_409 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 2:
          if (
#line 557 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_411 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 3:
          if ((
#line 557 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_413 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        default:
          break;
        }
      operands[2] = x4;
      if (pattern1745 (x6, 
E_SImode) != 0
          || !
#line 754 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_421 (insn, operands);

    case E_DImode:
      if (!register_operand (operands[0], E_DImode))
        return NULL;
      operands[1] = x4;
      switch (pattern1789 (x6, 
E_DImode))
        {
        case 0:
          if ((
#line 557 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_408 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 1:
          if ((
#line 557 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_410 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 2:
          if ((
#line 557 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_412 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 3:
          if ((
#line 557 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_414 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        default:
          break;
        }
      operands[2] = x4;
      if (pattern1745 (x6, 
E_DImode) != 0
          || !(
#line 754 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_422 (insn, operands);

    case E_QImode:
      if (pattern1746 (x4, 
E_QImode) != 0
          || !
#line 754 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_419 (insn, operands);

    case E_HImode:
      if (pattern1746 (x4, 
E_HImode) != 0
          || !
#line 754 "/tmp/pkg/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_420 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_48 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 3)
    return NULL;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  x4 = XEXP (x2, 0);
  operands[0] = x4;
  x5 = XEXP (x3, 1);
  operands[1] = x5;
  x6 = XEXP (x3, 0);
  if (!rtx_equal_p (x6, operands[0]))
    return NULL;
  x7 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x7) != SET)
    return NULL;
  x8 = XEXP (x7, 1);
  if (!rtx_equal_p (x8, operands[0]))
    return NULL;
  x9 = XEXP (x7, 0);
  if (!rtx_equal_p (x9, operands[1]))
    return NULL;
  x10 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x10) != SET)
    return NULL;
  x11 = XEXP (x10, 1);
  if (GET_CODE (x11) != COMPARE)
    return NULL;
  x12 = XEXP (x11, 1);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return NULL;
  x13 = XEXP (x10, 0);
  if (GET_CODE (x13) != REG
      || REGNO (x13) != 17)
    return NULL;
  x14 = XEXP (x11, 0);
  if (!rtx_equal_p (x14, operands[0]))
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || !plusminuslogic_operator (operands[2], E_QImode)
          || !memory_operand (operands[1], E_QImode)
          || !
#line 28209 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && COMMUTATIVE_ARITH_P (operands[2])
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && ix86_match_ccmode (peep2_next_insn (2),
			 GET_CODE (operands[2]) == PLUS
			 ? CCGOCmode : CCNOmode)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_305 (insn, operands);

    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || !plusminuslogic_operator (operands[2], E_HImode)
          || !memory_operand (operands[1], E_HImode)
          || !
#line 28209 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && COMMUTATIVE_ARITH_P (operands[2])
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && ix86_match_ccmode (peep2_next_insn (2),
			 GET_CODE (operands[2]) == PLUS
			 ? CCGOCmode : CCNOmode)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_306 (insn, operands);

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || !plusminuslogic_operator (operands[2], E_SImode)
          || !memory_operand (operands[1], E_SImode)
          || !
#line 28209 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && COMMUTATIVE_ARITH_P (operands[2])
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && ix86_match_ccmode (peep2_next_insn (2),
			 GET_CODE (operands[2]) == PLUS
			 ? CCGOCmode : CCNOmode)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_307 (insn, operands);

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || !plusminuslogic_operator (operands[2], E_DImode)
          || !memory_operand (operands[1], E_DImode)
          || !(
#line 28209 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && COMMUTATIVE_ARITH_P (operands[2])
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && ix86_match_ccmode (peep2_next_insn (2),
			 GET_CODE (operands[2]) == PLUS
			 ? CCGOCmode : CCNOmode)) && 
#line 1161 "/tmp/pkg/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_308 (insn, operands);

    default:
      return NULL;
    }
}
