/* do not edit automatically generated by mc from M2StackAddress.  */
/* M2StackAddress.def provides a generic stack for ADDRESS sized objects.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2StackAddress_H)
#   define _M2StackAddress_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"

#   if defined (_M2StackAddress_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (M2StackAddress_StackOfAddress_D)
#  define M2StackAddress_StackOfAddress_D
   typedef void *M2StackAddress_StackOfAddress;
#endif


/*
   InitStackAddress - creates and returns a new stack.
*/

EXTERN M2StackAddress_StackOfAddress M2StackAddress_InitStackAddress (void);

/*
   KillStackAddress - destroys a stack, returning NIL.
*/

EXTERN M2StackAddress_StackOfAddress M2StackAddress_KillStackAddress (M2StackAddress_StackOfAddress s);

/*
   PushAddress - pushes a word, w, onto, s.
*/

EXTERN void M2StackAddress_PushAddress (M2StackAddress_StackOfAddress s, void * w);

/*
   PopAddress - pops an element from stack, s.
*/

EXTERN void * M2StackAddress_PopAddress (M2StackAddress_StackOfAddress s);

/*
   IsEmptyAddress - returns TRUE if stack, s, is empty.
*/

EXTERN bool M2StackAddress_IsEmptyAddress (M2StackAddress_StackOfAddress s);

/*
   PeepAddress - returns the element at, n, items below in the stack.
                 Top of stack can be seen via Peep(s, 1)
*/

EXTERN void * M2StackAddress_PeepAddress (M2StackAddress_StackOfAddress s, unsigned int n);

/*
   ReduceAddress - reduce the stack by n elements.
*/

EXTERN void M2StackAddress_ReduceAddress (M2StackAddress_StackOfAddress s, unsigned int n);
EXTERN unsigned int M2StackAddress_NoOfItemsInStackAddress (M2StackAddress_StackOfAddress s);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
