/* do not edit automatically generated by mc from M2Comp.  */
/* M2Comp.mod continually calls the compiler for every source file.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Comp_C

#include "GM2Comp.h"
#   include "GM2Pass.h"
#   include "GM2Reserved.h"
#   include "GM2Search.h"
#   include "GM2Code.h"
#   include "GM2LexBuf.h"
#   include "GM2FileName.h"
#   include "GM2Preprocess.h"
#   include "Glibc.h"
#   include "GM2Error.h"
#   include "GM2MetaError.h"
#   include "GFormatStrings.h"
#   include "GP0SymBuild.h"
#   include "GM2Debug.h"
#   include "Gm2flex.h"
#   include "GP0SyntaxCheck.h"
#   include "GP1Build.h"
#   include "GP2Build.h"
#   include "GPCBuild.h"
#   include "GP3Build.h"
#   include "GPHBuild.h"
#   include "GPCSymBuild.h"
#   include "GDynamicStrings.h"
#   include "GM2Batch.h"
#   include "GSymbolTable.h"
#   include "GFIO.h"
#   include "GSFIO.h"
#   include "GNameKey.h"
#   include "GM2Printf.h"
#   include "GM2Quiet.h"
#   include "GM2Options.h"
#   include "GPathName.h"
#   include "GLists.h"
#   include "GIndexing.h"

#   define Debugging false
static enum {M2Comp_None, M2Comp_Definition, M2Comp_Implementation, M2Comp_Program} ModuleType;
static Indexing_Index DepContent;
static DynamicStrings_String DepOutput;

/*
   compile - compile the filename.
*/

extern "C" void M2Comp_compile (void * filename);

/*
   CompilingDefinitionModule - returns true if the current module being
                               compiled is a definition module.
*/

extern "C" bool M2Comp_CompilingDefinitionModule (void);

/*
   CompilingImplementationModule - returns true if the current module being
                                   compiled is an implementation module.
*/

extern "C" bool M2Comp_CompilingImplementationModule (void);

/*
   CompilingProgramModule - returns true if the current module being
                            compiled is a program module.
*/

extern "C" bool M2Comp_CompilingProgramModule (void);

/*
   NeedToParseImplementation -
*/

static bool NeedToParseImplementation (unsigned int sym);

/*
   GenerateDefDependency - generate a single dependency for the definition module
                           providing that it can be found and is not blocked by -MM.
*/

static void GenerateDefDependency (unsigned int module);

/*
   GenerateDependenciesFromImport - lookup the module associated with the import
                                    and call GenerateDefDependency.
*/

static void GenerateDependenciesFromImport (unsigned int import);

/*
   GenerateDependenciesFromList - iterative over the import lists and for
                                  each module issue a dependency.
*/

static void GenerateDependenciesFromList (Lists_List dep);

/*
   GenerateDependencies - generate a list of dependencies for the main module where
                          the source code is found in sourcefile.
*/

static void GenerateDependencies (void);

/*
   Compile - compile file, s, using a 5 pass technique.
*/

static void Compile (DynamicStrings_String s);

/*
   ExamineHeader - examines up until the ';', '[' or eof and determines if the source file
                   is a program, implementation/definition module.
*/

static void ExamineHeader (void * *name, bool *isdefimp, bool *module);

/*
   ExamineCompilationUnit - opens the source file to obtain the module name and kind of module.
*/

static unsigned int ExamineCompilationUnit (void);

/*
   PeepInto - peeps into source, s, and initializes a definition/implementation or
              program module accordingly.
*/

static void PeepInto (DynamicStrings_String s);

/*
   qprintLibName - print the libname.
*/

static void qprintLibName (DynamicStrings_String LibName);

/*
   CreateFileStem - create a stem using the template LibName_ModuleName.
*/

static DynamicStrings_String CreateFileStem (DynamicStrings_String SymName, DynamicStrings_String LibName);
static DynamicStrings_String BaseName (DynamicStrings_String Path, bool CutExt);

/*
   IsLibrary - return TRUE if line contains a library module.
*/

static bool IsLibrary (DynamicStrings_String line);

/*
   IsUnique - return TRUE if line is unique in array content.
*/

static bool IsUnique (Indexing_Index content, DynamicStrings_String line);

/*
   Append - append line to array content.
*/

static void Append (Indexing_Index content, DynamicStrings_String line);

/*
   MergeDep - if line is unique in array content then append.
              Check to see (and ignore) if line is a library module and -MM
              is present.
*/

static void MergeDep (Indexing_Index content, DynamicStrings_String line);

/*
   splitLine - split a line into words separated by spaces
               and call MergeDep on each word.
*/

static void splitLine (Indexing_Index content, DynamicStrings_String line);

/*
   MergeDeps - foreach dependency in ChildDep do
                  add dependency to ChildDep if not already present.
               ignore all ChildDep if -MM and libname # "".
*/

static void MergeDeps (Indexing_Index content, DynamicStrings_String ChildDep, DynamicStrings_String LibName);

/*
   GetRuleTarget - return the rule target which is derived from the -MT arg
                   or -o arg or filename.mod.
*/

static DynamicStrings_String GetRuleTarget (DynamicStrings_String filename);

/*
   ReadDepContents - reads the contents of file dep into a dynamic array
                     and return the array.  The file will be split into words
                     and each word stored as an entry in the array.
*/

static Indexing_Index ReadDepContents (DynamicStrings_String filename, DynamicStrings_String dep);

/*
   WriteDep - write the dependencies and target to file out.
*/

static void WriteDep (Indexing_Index contents, FIO_File out);

/*
   WritePhonyDep - write the dependencies and target to file out.
*/

static void WritePhonyDep (Indexing_Index contents, FIO_File out);

/*
   WriteDepContents - write the dynamic array to filename dep (or StdOut) if
                      the GetMF file is NIL.
*/

static void WriteDepContents (DynamicStrings_String dep, Indexing_Index contents);

/*
   CreateDepFilename - return a dependency filename associated with filename or use GetMF.
*/

static DynamicStrings_String CreateDepFilename (DynamicStrings_String filename);

/*
   Pass0CheckDef -
*/

static bool Pass0CheckDef (unsigned int sym);

/*
   Pass0CheckMod -
*/

static bool Pass0CheckMod (unsigned int sym, DynamicStrings_String PPSource);

/*
   DoPass0 -
*/

static void DoPass0 (DynamicStrings_String filename);

/*
   DoPass1 - parses the sources of all modules necessary to compile
             the required module, Main.
*/

static void DoPass1 (void);

/*
   DoPass2 - parses the sources of all modules necessary to compile
             the required module, Main.
*/

static void DoPass2 (void);

/*
   DoPassC - parses the sources of all modules necessary to compile
             the required module, Main.
*/

static void DoPassC (void);

/*
   DoPass3 - parses the sources of all modules necessary to compile
             the required module, Main.
*/

static void DoPass3 (void);


/*
   NeedToParseImplementation -
*/

static bool NeedToParseImplementation (unsigned int sym)
{
  return ((((SymbolTable_IsDefImp (sym)) && (SymbolTable_IsHiddenTypeDeclared (sym))) && M2Options_ExtendedOpaque) || ((SymbolTable_IsDefImp (sym)) && (SymbolTable_IsBuiltinInModule (sym)))) || (M2Options_WholeProgram && (! (SymbolTable_IsDefinitionForC (sym))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GenerateDefDependency - generate a single dependency for the definition module
                           providing that it can be found and is not blocked by -MM.
*/

static void GenerateDefDependency (unsigned int module)
{
  DynamicStrings_String stem;
  DynamicStrings_String fullpath;
  DynamicStrings_String named;

  stem = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (module)));
  named = static_cast<DynamicStrings_String> (NULL);
  if (M2Search_FindSourceDefFile (stem, &fullpath, &named))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((DynamicStrings_EqualArray (named, (const char *) "", 0)) || (! (M2Options_GetMM ())))
        {
          MergeDep (DepContent, fullpath);
        }
      else
        {
          fullpath = DynamicStrings_KillString (fullpath);
        }
    }
  stem = DynamicStrings_KillString (stem);
  named = DynamicStrings_KillString (named);
}


/*
   GenerateDependenciesFromImport - lookup the module associated with the import
                                    and call GenerateDefDependency.
*/

static void GenerateDependenciesFromImport (unsigned int import)
{
  unsigned int module;

  M2Debug_Assert (SymbolTable_IsImport (import));
  module = SymbolTable_GetImportModule (import);
  GenerateDefDependency (module);
}


/*
   GenerateDependenciesFromList - iterative over the import lists and for
                                  each module issue a dependency.
*/

static void GenerateDependenciesFromList (Lists_List dep)
{
  Lists_List importList;
  unsigned int import;
  unsigned int i;
  unsigned int n;
  unsigned int j;
  unsigned int m;

  n = Lists_NoOfItemsInList (dep);
  i = 1;
  while (i <= n)
    {
      import = static_cast<unsigned int> (Lists_GetItemFromList (dep, i));
      if (SymbolTable_IsImportStatement (import))
        {
          importList = SymbolTable_GetImportStatementList (import);
          j = 1;
          m = Lists_NoOfItemsInList (importList);
          while (j <= m)
            {
              import = static_cast<unsigned int> (Lists_GetItemFromList (importList, j));
              GenerateDependenciesFromImport (import);
              j += 1;
            }
        }
      else
        {
          GenerateDependenciesFromImport (import);
        }
      i += 1;
    }
}


/*
   GenerateDependencies - generate a list of dependencies for the main module where
                          the source code is found in sourcefile.
*/

static void GenerateDependencies (void)
{
  if (SymbolTable_IsDefImp (SymbolTable_GetMainModule ()))
    {
      GenerateDependenciesFromList (SymbolTable_GetModuleDefImportStatementList (SymbolTable_GetMainModule ()));
      GenerateDefDependency (SymbolTable_GetMainModule ());
    }
  GenerateDependenciesFromList (SymbolTable_GetModuleModImportStatementList (SymbolTable_GetMainModule ()));
  WriteDepContents (DepOutput, DepContent);
}


/*
   Compile - compile file, s, using a 5 pass technique.
*/

static void Compile (DynamicStrings_String s)
{
  DoPass0 (s);
  M2Error_FlushWarnings ();
  M2Error_FlushErrors ();
  M2LexBuf_ResetForNewPass ();
  M2Error_ResetErrorScope ();
  M2Quiet_qprintf0 ((const char *) "Pass 1: scopes, enumerated types, imports and exports\\n", 55);
  DoPass1 ();
  M2Error_FlushWarnings ();
  M2Error_FlushErrors ();
  if ((M2Options_GetM ()) || (M2Options_GetMM ()))
    {
      GenerateDependencies ();
    }
  if (! M2Options_PPonly)
    {
      M2Quiet_qprintf0 ((const char *) "Pass 2: constants and types\\n", 29);
      M2LexBuf_ResetForNewPass ();
      M2Error_ResetErrorScope ();
      DoPass2 ();
      M2Error_FlushWarnings ();
      M2Error_FlushErrors ();
      M2Quiet_qprintf0 ((const char *) "Pass C: aggregate constants\\n", 29);
      M2LexBuf_ResetForNewPass ();
      M2Error_ResetErrorScope ();
      DoPassC ();
      M2Error_FlushWarnings ();
      M2Error_FlushErrors ();
      M2Quiet_qprintf0 ((const char *) "Pass 3: quadruple generation\\n", 30);
      M2LexBuf_ResetForNewPass ();
      M2Error_ResetErrorScope ();
      DoPass3 ();
      M2Error_FlushWarnings ();
      M2Error_FlushErrors ();
      M2Quiet_qprintf0 ((const char *) "Pass 4: gcc tree generation\\n", 29);
      M2Code_Code ();
      M2Error_FlushWarnings ();
      M2Error_FlushErrors ();
    }
}


/*
   ExamineHeader - examines up until the ';', '[' or eof and determines if the source file
                   is a program, implementation/definition module.
*/

static void ExamineHeader (void * *name, bool *isdefimp, bool *module)
{
  /* Stop if we see one of eof ';' '['.  */
  while (((M2LexBuf_currenttoken != M2Reserved_eoftok) && (M2LexBuf_currenttoken != M2Reserved_semicolontok)) && (M2LexBuf_currenttoken != M2Reserved_lsbratok))
    {
      if ((*name) == NULL)
        {
          if ((M2LexBuf_currenttoken == M2Reserved_implementationtok) || (M2LexBuf_currenttoken == M2Reserved_definitiontok))
            {
              (*isdefimp) = true;
              M2LexBuf_GetToken ();
            }
          if (M2LexBuf_currenttoken == M2Reserved_moduletok)
            {
              (*module) = true;
              M2LexBuf_GetToken ();
              if (M2LexBuf_currenttoken == M2Reserved_identtok)
                {
                  (*name) = M2LexBuf_currentstring;
                }
            }
        }
      M2LexBuf_GetToken ();
    }
}


/*
   ExamineCompilationUnit - opens the source file to obtain the module name and kind of module.
*/

static unsigned int ExamineCompilationUnit (void)
{
  DynamicStrings_String Message;
  void * name;
  bool module;
  bool isdefimp;

  name = NULL;
  isdefimp = false;  /* default to program module  */
  module = false;  /* Seen module keyword?  */
  ExamineHeader (&name, &isdefimp, &module);  /* Seen module keyword?  */
  if (name == NULL)
    {
      if (module)
        {
          Message = M2MetaError_MetaString0 (DynamicStrings_InitString ((const char *) "no {%kMODULE} keyword seen", 26));
        }
      else
        {
          Message = M2MetaError_MetaString0 (DynamicStrings_InitString ((const char *) "no module ident seen", 20));
        }
      m2flex_M2Error (DynamicStrings_string (Message));
      libc_exit (1);
    }
  else
    {
      /* The token used is will be overwritten when P0 is underway.
         At this point we are determining the module kind and the tokens
         read will be discarded (see ReInitialize below).  */
      if (isdefimp)
        {
          return M2Batch_MakeImplementationSource (M2LexBuf_BuiltinTokenNo, NameKey_makekey (name));
        }
      else
        {
          return M2Batch_MakeProgramSource (M2LexBuf_BuiltinTokenNo, NameKey_makekey (name));
        }
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2Comp.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PeepInto - peeps into source, s, and initializes a definition/implementation or
              program module accordingly.
*/

static void PeepInto (DynamicStrings_String s)
{
  unsigned int mainModule;

  if (M2LexBuf_OpenSource (s))
    {
      mainModule = ExamineCompilationUnit ();
      if (mainModule != SymbolTable_NulSym)
        {
          SymbolTable_SetMainModule (mainModule);
        }
      M2LexBuf_CloseSource ();
      M2LexBuf_ReInitialize ();
    }
  else
    {
      M2Printf_fprintf1 (FIO_StdErr, (const char *) "failed to open %s\\n", 19, (const unsigned char *) &s, (sizeof (s)-1));
      libc_exit (1);
    }
}


/*
   qprintLibName - print the libname.
*/

static void qprintLibName (DynamicStrings_String LibName)
{
  if ((LibName != NULL) && (! (DynamicStrings_EqualArray (LibName, (const char *) "", 0))))
    {
      M2Quiet_qprintf1 ((const char *) " [%s]", 5, (const unsigned char *) &LibName, (sizeof (LibName)-1));
    }
}


/*
   CreateFileStem - create a stem using the template LibName_ModuleName.
*/

static DynamicStrings_String CreateFileStem (DynamicStrings_String SymName, DynamicStrings_String LibName)
{
  if ((DynamicStrings_Length (LibName)) > 0)
    {
      return DynamicStrings_ConCat (DynamicStrings_Dup (LibName), DynamicStrings_ConCat (DynamicStrings_InitStringChar ('_'), SymName));
    }
  else
    {
      return SymName;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

static DynamicStrings_String BaseName (DynamicStrings_String Path, bool CutExt)
{
  int ext;
  int basename;

  /* 
   Return basename of path.  CutExt determines whether the .extension
   should be removed.
  */
  basename = DynamicStrings_RIndex (Path, '/', 0);
  if (basename == -1)
    {
      basename = 0;
    }
  else
    {
      basename = basename+1;
    }
  if (CutExt)
    {
      /* avoid dangling else.  */
      ext = DynamicStrings_RIndex (Path, '.', 0);
      if (ext == -1)
        {
          ext = 0;
        }
    }
  else
    {
      ext = 0;
    }
  return DynamicStrings_Slice (Path, basename, ext);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsLibrary - return TRUE if line contains a library module.
*/

static bool IsLibrary (DynamicStrings_String line)
{
  DynamicStrings_String moduleName;
  DynamicStrings_String libname;
  DynamicStrings_String filename;
  bool result;

  result = false;
  moduleName = BaseName (line, true);
  filename = static_cast<DynamicStrings_String> (NULL);
  libname = static_cast<DynamicStrings_String> (NULL);
  if (M2Search_FindSourceDefFile (moduleName, &filename, &libname))
    {
      moduleName = DynamicStrings_KillString (moduleName);
      if ((DynamicStrings_Length (libname)) > 0)
        {
          moduleName = BaseName (line, false);
          line = BaseName (line, false);
          result = DynamicStrings_Equal (line, moduleName);
          line = DynamicStrings_KillString (line);
        }
    }
  libname = DynamicStrings_KillString (libname);
  filename = DynamicStrings_KillString (filename);
  moduleName = DynamicStrings_KillString (moduleName);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsUnique - return TRUE if line is unique in array content.
*/

static bool IsUnique (Indexing_Index content, DynamicStrings_String line)
{
  unsigned int high;
  unsigned int i;

  high = Indexing_HighIndice (content);
  i = 1;
  while (i <= high)
    {
      if (DynamicStrings_Equal (line, static_cast<DynamicStrings_String> (Indexing_GetIndice (content, i))))
        {
          return false;
        }
      i += 1;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Append - append line to array content.
*/

static void Append (Indexing_Index content, DynamicStrings_String line)
{
  unsigned int high;

  high = Indexing_HighIndice (content);
  Indexing_PutIndice (content, high+1, reinterpret_cast <void *> (line));
}


/*
   MergeDep - if line is unique in array content then append.
              Check to see (and ignore) if line is a library module and -MM
              is present.
*/

static void MergeDep (Indexing_Index content, DynamicStrings_String line)
{
  line = DynamicStrings_RemoveWhitePrefix (line);
  if ((! (DynamicStrings_EqualArray (line, (const char *) "\\", 1))) && ((DynamicStrings_Length (line)) > 0))
    {
      /* Ignore if -MM and is a library module.  */
      if (! ((M2Options_GetMM ()) && (IsLibrary (line))))
        {
          if (IsUnique (content, line))
            {
              Append (content, line);
            }
        }
    }
}


/*
   splitLine - split a line into words separated by spaces
               and call MergeDep on each word.
*/

static void splitLine (Indexing_Index content, DynamicStrings_String line)
{
  DynamicStrings_String word;
  int space;

  do {
    line = DynamicStrings_RemoveWhitePrefix (line);
    space = DynamicStrings_Index (line, ' ', 0);
    if (space > 0)
      {
        word = DynamicStrings_Slice (line, 0, space);
        word = DynamicStrings_RemoveWhitePrefix (word);
        if ((DynamicStrings_Length (word)) > 0)
          {
            MergeDep (content, word);
          }
        line = DynamicStrings_Slice (line, space, 0);
      }
    else if (space < 0)
      {
        /* avoid dangling else.  */
        MergeDep (content, line);
      }
  } while (! (space <= 0));
}


/*
   MergeDeps - foreach dependency in ChildDep do
                  add dependency to ChildDep if not already present.
               ignore all ChildDep if -MM and libname # "".
*/

static void MergeDeps (Indexing_Index content, DynamicStrings_String ChildDep, DynamicStrings_String LibName)
{
  DynamicStrings_String line;
  FIO_File in;

  if ((content != NULL) && (! ((M2Options_GetMM ()) && ((DynamicStrings_Length (LibName)) > 0))))
    {
      in = SFIO_OpenToRead (ChildDep);
      if (FIO_IsNoError (in))
        {
          line = SFIO_ReadS (in);  /* Skip over first line containing the module object.  */
          while (! (FIO_EOF (in)))  /* Skip over first line containing the module object.  */
            {
              line = SFIO_ReadS (in);
              splitLine (content, line);
            }
        }
      FIO_Close (in);
    }
}


/*
   GetRuleTarget - return the rule target which is derived from the -MT arg
                   or -o arg or filename.mod.
*/

static DynamicStrings_String GetRuleTarget (DynamicStrings_String filename)
{
  if ((M2Options_GetDepTarget ()) != NULL)
    {
      return DynamicStrings_InitStringCharStar (M2Options_GetDepTarget ());
    }
  else if ((M2Options_GetMF ()) != NULL)
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitStringCharStar (M2Options_GetMF ());
    }
  else
    {
      /* avoid dangling else.  */
      return DynamicStrings_ConCat (BaseName (filename, true), DynamicStrings_InitString ((const char *) ".o", 2));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ReadDepContents - reads the contents of file dep into a dynamic array
                     and return the array.  The file will be split into words
                     and each word stored as an entry in the array.
*/

static Indexing_Index ReadDepContents (DynamicStrings_String filename, DynamicStrings_String dep)
{
  Indexing_Index content;
  DynamicStrings_String line;
  FIO_File in;

  content = static_cast<Indexing_Index> (NULL);
  if ((M2Options_GetM ()) || (M2Options_GetMM ()))
    {
      in = SFIO_OpenToRead (dep);
      /* The file might not be created (if -MD or -MMD is used as these options
         operate without preprocessing) in which case we create an dynamic
         array with the source filename and target.  */
      content = Indexing_InitIndex (1);
      if (((M2Options_GetMD ()) || (M2Options_GetMMD ())) || (! (FIO_IsNoError (in))))
        {
          /* No preprocessing done therefore create first two lines using
            target and source.  */
          Indexing_PutIndice (content, 1, reinterpret_cast <void *> (DynamicStrings_ConCatChar (GetRuleTarget (filename), ':')));
          Indexing_PutIndice (content, 2, reinterpret_cast <void *> (DynamicStrings_Dup (filename)));
        }
      else
        {
          /* Preprocessing (using cc1) has created one for us, so we read it.  */
          while (! (FIO_EOF (in)))
            {
              line = SFIO_ReadS (in);
              splitLine (content, line);
            }
        }
      FIO_Close (in);
    }
  return content;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WriteDep - write the dependencies and target to file out.
*/

static void WriteDep (Indexing_Index contents, FIO_File out)
{
  unsigned int i;
  unsigned int h;
  DynamicStrings_String line;

  i = 1;
  h = Indexing_HighIndice (contents);
  while (i <= h)
    {
      line = static_cast<DynamicStrings_String> (Indexing_GetIndice (contents, i));
      line = DynamicStrings_RemoveWhitePrefix (line);
      if ((DynamicStrings_Length (line)) > 0)
        {
          if (i == 1)
            {
              /* avoid dangling else.  */
              /* First line is always the target.  */
              if ((M2Options_GetDepTarget ()) != NULL)
                {
                  line = DynamicStrings_ConCatChar (DynamicStrings_InitStringCharStar (M2Options_GetDepTarget ()), ':');
                }
            }
          else if (i > 1)
            {
              /* avoid dangling else.  */
              FIO_WriteChar (out, ' ');
            }
          line = SFIO_WriteS (out, line);
          if (i < h)
            {
              FIO_WriteChar (out, ' ');
              FIO_WriteChar (out, '\\');
            }
          FIO_WriteLine (out);
        }
      i += 1;
    }
}


/*
   WritePhonyDep - write the dependencies and target to file out.
*/

static void WritePhonyDep (Indexing_Index contents, FIO_File out)
{
  unsigned int i;
  unsigned int h;
  DynamicStrings_String line;

  /* The first line is always the target and the second line is always
      the top level source file.  */
  i = 3;
  h = Indexing_HighIndice (contents);
  while (i <= h)
    {
      line = static_cast<DynamicStrings_String> (Indexing_GetIndice (contents, i));
      line = DynamicStrings_RemoveWhitePrefix (line);
      if ((DynamicStrings_Length (line)) > 0)
        {
          line = SFIO_WriteS (out, line);
          FIO_WriteChar (out, ':');
          FIO_WriteLine (out);
        }
      i += 1;
    }
}


/*
   WriteDepContents - write the dynamic array to filename dep (or StdOut) if
                      the GetMF file is NIL.
*/

static void WriteDepContents (DynamicStrings_String dep, Indexing_Index contents)
{
  FIO_File out;

  if ((contents != NULL) && ((M2Options_GetM ()) || (M2Options_GetMM ())))
    {
      if ((M2Options_GetMF ()) == NULL)
        {
          out = FIO_StdOut;
          dep = M2Preprocess_OnExitDelete (dep);
        }
      else
        {
          out = SFIO_OpenToWrite (dep);
        }
      if (FIO_IsNoError (out))
        {
          WriteDep (contents, out);
          if (M2Options_GetMP ())
            {
              WritePhonyDep (contents, out);
            }
        }
      if ((M2Options_GetMF ()) == NULL)
        {
          FIO_FlushOutErr ();
        }
      else
        {
          FIO_Close (out);
        }
      contents = Indexing_KillIndex (contents);
    }
}


/*
   CreateDepFilename - return a dependency filename associated with filename or use GetMF.
*/

static DynamicStrings_String CreateDepFilename (DynamicStrings_String filename)
{
  DynamicStrings_String depfile;

  if ((M2Options_GetMF ()) == NULL)
    {
      depfile = M2Preprocess_MakeSaveTempsFileNameExt (filename, DynamicStrings_InitString ((const char *) ".d", 2));
      return M2Preprocess_OnExitDelete (depfile);
    }
  else
    {
      return DynamicStrings_InitStringCharStar (M2Options_GetMF ());
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Pass0CheckDef -
*/

static bool Pass0CheckDef (unsigned int sym)
{
  DynamicStrings_String ChildDep;
  DynamicStrings_String SymName;
  DynamicStrings_String FileName;
  DynamicStrings_String LibName;

  LibName = static_cast<DynamicStrings_String> (NULL);
  FileName = static_cast<DynamicStrings_String> (NULL);
  SymName = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym)));
  if (SymbolTable_IsDefImp (sym))
    {
      if (M2Search_FindSourceDefFile (SymName, &FileName, &LibName))
        {
          ModuleType = M2Comp_Definition;
          ChildDep = M2Preprocess_MakeSaveTempsFileNameExt (CreateFileStem (SymName, LibName), DynamicStrings_InitString ((const char *) ".def.d", 6));
          if (M2LexBuf_OpenSource (M2Batch_AssociateDefinition (M2Preprocess_PreprocessModule (FileName, false, true, ChildDep), sym)))
            {
              if (! (P0SyntaxCheck_CompilationUnit ()))
                {
                  M2Error_WriteFormat0 ((const char *) "compilation failed", 18);
                  M2LexBuf_CloseSource ();
                  SymName = DynamicStrings_KillString (SymName);
                  FileName = DynamicStrings_KillString (FileName);
                  LibName = DynamicStrings_KillString (LibName);
                  return false;
                }
              M2Quiet_qprintf2 ((const char *) "   Module %-20s : %s", 20, (const unsigned char *) &SymName, (sizeof (SymName)-1), (const unsigned char *) &FileName, (sizeof (FileName)-1));
              qprintLibName (LibName);
              SymbolTable_PutLibName (sym, NameKey_makekey (DynamicStrings_string (LibName)));
              if (SymbolTable_IsDefinitionForC (sym))
                {
                  M2Quiet_qprintf0 ((const char *) " (for C)", 8);
                }
              if (SymbolTable_IsDefLink (sym))
                {
                  M2Quiet_qprintf0 ((const char *) " (linking)", 10);
                }
              M2Quiet_qprintf0 ((const char *) "\\n", 2);
              M2LexBuf_CloseSource ();
              MergeDeps (DepContent, ChildDep, LibName);
            }
          else
            {
              /* Unrecoverable error.  */
              M2MetaError_MetaErrorString1 (FormatStrings_Sprintf1 (DynamicStrings_InitString ((const char *) "file {%%1EUAF%s} containing module {%%1a} cannot be found", 57), (const unsigned char *) &FileName, (sizeof (FileName)-1)), sym);
            }
        }
      else
        {
          /* Unrecoverable error.  */
          M2MetaError_MetaError1 ((const char *) "the file containing the definition module {%1EMAa} cannot be found", 66, sym);
        }
      ModuleType = M2Comp_Implementation;
    }
  else
    {
      ModuleType = M2Comp_Program;
    }
  SymName = DynamicStrings_KillString (SymName);
  FileName = DynamicStrings_KillString (FileName);
  LibName = DynamicStrings_KillString (LibName);
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Pass0CheckMod -
*/

static bool Pass0CheckMod (unsigned int sym, DynamicStrings_String PPSource)
{
  unsigned int Main;
  DynamicStrings_String ChildDep;
  DynamicStrings_String SymName;
  DynamicStrings_String FileName;
  DynamicStrings_String LibName;

  SymName = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym)));
  FileName = static_cast<DynamicStrings_String> (NULL);
  LibName = static_cast<DynamicStrings_String> (NULL);
  Main = SymbolTable_GetMainModule ();
  if ((Main == sym) || (NeedToParseImplementation (sym)))
    {
      /* avoid dangling else.  */
      /* Only need to read implementation module if hidden types are
         declared or it is the main module.  */
      if (Main == sym)
        {
          FileName = DynamicStrings_Dup (PPSource);
          LibName = DynamicStrings_InitStringCharStar (M2Options_GetM2Prefix ());
          SymbolTable_PutLibName (sym, NameKey_makekey (DynamicStrings_string (LibName)));
        }
      else
        {
          if (M2Search_FindSourceModFile (SymName, &FileName, &LibName))
            {
              ChildDep = M2Preprocess_MakeSaveTempsFileNameExt (CreateFileStem (SymName, LibName), DynamicStrings_InitString ((const char *) ".mod.d", 6));
              FileName = M2Preprocess_PreprocessModule (FileName, false, true, ChildDep);
              SymbolTable_PutLibName (sym, NameKey_makekey (DynamicStrings_string (LibName)));
              MergeDeps (DepContent, ChildDep, LibName);
            }
          else
            {
              M2Quiet_qprintf1 ((const char *) "   Module %-20s : implementation source file not found\\n", 56, (const unsigned char *) &SymName, (sizeof (SymName)-1));
            }
        }
      if (FileName != NULL)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (M2LexBuf_OpenSource (M2Batch_AssociateModule (DynamicStrings_Dup (FileName), sym)))
            {
              if (! (P0SyntaxCheck_CompilationUnit ()))
                {
                  M2Error_WriteFormat0 ((const char *) "compilation failed", 18);
                  M2LexBuf_CloseSource ();
                  SymName = DynamicStrings_KillString (SymName);
                  FileName = DynamicStrings_KillString (FileName);
                  LibName = DynamicStrings_KillString (LibName);
                  return false;
                }
              M2Quiet_qprintf2 ((const char *) "   Module %-20s : %s", 20, (const unsigned char *) &SymName, (sizeof (SymName)-1), (const unsigned char *) &FileName, (sizeof (FileName)-1));
              qprintLibName (LibName);
              if (SymbolTable_IsModLink (sym))
                {
                  M2Quiet_qprintf0 ((const char *) " (linking)", 10);
                }
              M2Quiet_qprintf0 ((const char *) "\\n", 2);
              M2LexBuf_CloseSource ();
            }
          else
            {
              /* It is quite legitimate to implement a module in C (and pretend it was a M2
               implementation) providing that it is not the main program module and the
               definition module does not declare a hidden type when -fextended-opaque
               is used.  */
              if ((! M2Options_WholeProgram || (sym == Main)) || (SymbolTable_IsHiddenTypeDeclared (sym)))
                {
                  /* Unrecoverable error.  */
                  M2MetaError_MetaErrorString1 (FormatStrings_Sprintf1 (DynamicStrings_InitString ((const char *) "file {%%1EUAF%s} containing module {%%1a} cannot be found", 57), (const unsigned char *) &FileName, (sizeof (FileName)-1)), sym);
                }
            }
        }
    }
  else if (M2Options_GenModuleList)
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsDefImp (sym)) && (! (SymbolTable_IsDefinitionForC (sym))))
        {
          /* The implementation module is only useful if -fgen-module-list= is
            used (to gather all dependencies).  Note that we do not insist
            upon finding the implementation module.  */
          LibName = static_cast<DynamicStrings_String> (NULL);
          if (M2Search_FindSourceModFile (SymName, &FileName, &LibName))
            {
              SymbolTable_PutLibName (sym, NameKey_makekey (DynamicStrings_string (LibName)));
              M2Quiet_qprintf2 ((const char *) "   Module %-20s : %s", 20, (const unsigned char *) &SymName, (sizeof (SymName)-1), (const unsigned char *) &FileName, (sizeof (FileName)-1));
              qprintLibName (LibName);
              M2Quiet_qprintf0 ((const char *) " (linking)\\n", 12);
              ChildDep = M2Preprocess_MakeSaveTempsFileNameExt (CreateFileStem (SymName, LibName), DynamicStrings_InitString ((const char *) ".mod.d", 6));
              if (M2LexBuf_OpenSource (M2Batch_AssociateModule (M2Preprocess_PreprocessModule (FileName, false, true, ChildDep), sym)))
                {
                  SymbolTable_PutModLink (sym, true);  /* This source is only used to determine link time info.  */
                  if (! (P0SyntaxCheck_CompilationUnit ()))  /* This source is only used to determine link time info.  */
                    {
                      M2Error_WriteFormat0 ((const char *) "compilation failed", 18);
                      M2LexBuf_CloseSource ();
                      SymName = DynamicStrings_KillString (SymName);
                      FileName = DynamicStrings_KillString (FileName);
                      LibName = DynamicStrings_KillString (LibName);
                      return false;
                    }
                  M2LexBuf_CloseSource ();
                  MergeDeps (DepContent, ChildDep, LibName);
                }
            }
        }
    }
  SymName = DynamicStrings_KillString (SymName);
  FileName = DynamicStrings_KillString (FileName);
  LibName = DynamicStrings_KillString (LibName);
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoPass0 -
*/

static void DoPass0 (DynamicStrings_String filename)
{
  unsigned int sym;
  unsigned int i;
  DynamicStrings_String PPSource;

  P0SymBuild_P0Init ();
  M2Pass_SetPassToPass0 ();
  /* Maybe preprocess the main file.  */
  DepOutput = CreateDepFilename (filename);
  PPSource = M2Preprocess_PreprocessModule (filename, true, false, DepOutput);
  DepContent = ReadDepContents (filename, DepOutput);
  PeepInto (PPSource);
  i = 1;
  sym = M2Batch_GetModuleNo (i);
  M2Quiet_qprintf1 ((const char *) "Compiling: %s\\n", 15, (const unsigned char *) &PPSource, (sizeof (PPSource)-1));
  if (Debugging)
    {
      PathName_DumpPathName ((const char *) "DoPass0", 7);
    }
  if (M2Options_Verbose)
    {
      M2Printf_fprintf1 (FIO_StdOut, (const char *) "Compiling: %s\\n", 15, (const unsigned char *) &PPSource, (sizeof (PPSource)-1));
    }
  M2Quiet_qprintf0 ((const char *) "Pass 0: lexical analysis, parsing, modules and associated filenames\\n", 69);
  while (sym != SymbolTable_NulSym)
    {
      if (! (Pass0CheckDef (sym)))
        {
          return;
        }
      if (! (Pass0CheckMod (sym, PPSource)))
        {
          return;
        }
      i += 1;
      sym = M2Batch_GetModuleNo (i);
    }
  M2Pass_SetPassToNoPass ();
}


/*
   DoPass1 - parses the sources of all modules necessary to compile
             the required module, Main.
*/

static void DoPass1 (void)
{
  NameKey_Name name;
  unsigned int Sym;
  unsigned int i;
  DynamicStrings_String FileName;

  P0SymBuild_P1Init ();
  M2Pass_SetPassToPass1 ();
  i = 1;
  Sym = M2Batch_GetModuleNo (i);
  while (Sym != SymbolTable_NulSym)
    {
      FileName = M2Batch_GetDefinitionModuleFile (Sym);
      if (FileName != NULL)
        {
          if (Debugging)
            {
              name = SymbolTable_GetSymName (Sym);
              M2Quiet_qprintf1 ((const char *) "   Module %a\\n", 14, (const unsigned char *) &name, (sizeof (name)-1));
            }
          if (M2LexBuf_OpenSource (FileName))
            {
              ModuleType = M2Comp_Definition;
              if (! (P1Build_CompilationUnit ()))
                {
                  M2MetaError_MetaError0 ((const char *) "compilation failed", 18);
                  M2LexBuf_CloseSource ();
                  return;
                }
              M2LexBuf_CloseSource ();
            }
          else
            {
              M2Printf_fprintf1 (FIO_StdErr, (const char *) "failed to open %s\\n", 19, (const unsigned char *) &FileName, (sizeof (FileName)-1));
              libc_exit (1);
            }
          ModuleType = M2Comp_Implementation;
        }
      else
        {
          ModuleType = M2Comp_Program;
        }
      FileName = M2Batch_GetModuleFile (Sym);
      if (FileName != NULL)
        {
          if (Debugging)
            {
              name = SymbolTable_GetSymName (Sym);
              M2Quiet_qprintf1 ((const char *) "   Module %a\\n", 14, (const unsigned char *) &name, (sizeof (name)-1));
            }
          if (M2LexBuf_OpenSource (FileName))
            {
              if (! (P1Build_CompilationUnit ()))
                {
                  M2MetaError_MetaError0 ((const char *) "compilation failed", 18);
                  M2LexBuf_CloseSource ();
                  return;
                }
              M2LexBuf_CloseSource ();
            }
          else
            {
              M2Printf_fprintf1 (FIO_StdErr, (const char *) "failed to open %s\\n", 19, (const unsigned char *) &FileName, (sizeof (FileName)-1));
              libc_exit (1);
            }
        }
      i += 1;
      Sym = M2Batch_GetModuleNo (i);
    }
  M2Pass_SetPassToNoPass ();
}


/*
   DoPass2 - parses the sources of all modules necessary to compile
             the required module, Main.
*/

static void DoPass2 (void)
{
  NameKey_Name name;
  unsigned int Sym;
  unsigned int i;
  DynamicStrings_String FileName;

  M2Pass_SetPassToPass2 ();
  i = 1;
  Sym = M2Batch_GetModuleNo (i);
  while (Sym != SymbolTable_NulSym)
    {
      FileName = M2Batch_GetDefinitionModuleFile (Sym);
      if (FileName != NULL)
        {
          if (Debugging)
            {
              name = SymbolTable_GetSymName (Sym);
              M2Quiet_qprintf1 ((const char *) "   Module %a\\n", 14, (const unsigned char *) &name, (sizeof (name)-1));
            }
          if (M2LexBuf_OpenSource (FileName))
            {
              ModuleType = M2Comp_Definition;
              if (! (P2Build_CompilationUnit ()))
                {
                  M2MetaError_MetaError0 ((const char *) "compilation failed", 18);
                  M2LexBuf_CloseSource ();
                  return;
                }
              M2LexBuf_CloseSource ();
            }
          else
            {
              M2Printf_fprintf1 (FIO_StdErr, (const char *) "failed to open %s\\n", 19, (const unsigned char *) &FileName, (sizeof (FileName)-1));
              libc_exit (1);
            }
          ModuleType = M2Comp_Implementation;
        }
      else
        {
          ModuleType = M2Comp_Program;
        }
      FileName = M2Batch_GetModuleFile (Sym);
      if (FileName != NULL)
        {
          if (Debugging)
            {
              name = SymbolTable_GetSymName (Sym);
              M2Quiet_qprintf1 ((const char *) "   Module %a\\n", 14, (const unsigned char *) &name, (sizeof (name)-1));
            }
          if (M2LexBuf_OpenSource (FileName))
            {
              if (! (P2Build_CompilationUnit ()))
                {
                  M2MetaError_MetaError0 ((const char *) "compilation failed", 18);
                  M2LexBuf_CloseSource ();
                  return;
                }
              M2LexBuf_CloseSource ();
            }
          else
            {
              M2Printf_fprintf1 (FIO_StdErr, (const char *) "failed to open %s\\n", 19, (const unsigned char *) &FileName, (sizeof (FileName)-1));
              libc_exit (1);
            }
        }
      i += 1;
      Sym = M2Batch_GetModuleNo (i);
    }
  M2Pass_SetPassToNoPass ();
}


/*
   DoPassC - parses the sources of all modules necessary to compile
             the required module, Main.
*/

static void DoPassC (void)
{
  NameKey_Name name;
  unsigned int Sym;
  unsigned int i;
  DynamicStrings_String FileName;

  M2Pass_SetPassToPassC ();
  i = 1;
  Sym = M2Batch_GetModuleNo (i);
  while (Sym != SymbolTable_NulSym)
    {
      FileName = M2Batch_GetDefinitionModuleFile (Sym);
      if (FileName != NULL)
        {
          if (Debugging)
            {
              name = SymbolTable_GetSymName (Sym);
              M2Quiet_qprintf1 ((const char *) "   Module %a\\n", 14, (const unsigned char *) &name, (sizeof (name)-1));
            }
          if (M2LexBuf_OpenSource (FileName))
            {
              ModuleType = M2Comp_Definition;
              if (! (PCBuild_CompilationUnit ()))
                {
                  M2MetaError_MetaError0 ((const char *) "compilation failed", 18);
                  M2LexBuf_CloseSource ();
                  return;
                }
              M2LexBuf_CloseSource ();
            }
          else
            {
              M2Printf_fprintf1 (FIO_StdErr, (const char *) "failed to open %s\\n", 19, (const unsigned char *) &FileName, (sizeof (FileName)-1));
              libc_exit (1);
            }
          ModuleType = M2Comp_Implementation;
        }
      else
        {
          ModuleType = M2Comp_Program;
        }
      FileName = M2Batch_GetModuleFile (Sym);
      if (FileName != NULL)
        {
          if (Debugging)
            {
              name = SymbolTable_GetSymName (Sym);
              M2Quiet_qprintf1 ((const char *) "   Module %a\\n", 14, (const unsigned char *) &name, (sizeof (name)-1));
            }
          if (M2LexBuf_OpenSource (FileName))
            {
              if (! (PCBuild_CompilationUnit ()))
                {
                  M2MetaError_MetaError0 ((const char *) "compilation failed", 18);
                  M2LexBuf_CloseSource ();
                  return;
                }
              M2LexBuf_CloseSource ();
            }
          else
            {
              M2Printf_fprintf1 (FIO_StdErr, (const char *) "failed to open %s\\n", 19, (const unsigned char *) &FileName, (sizeof (FileName)-1));
              libc_exit (1);
            }
        }
      i += 1;
      Sym = M2Batch_GetModuleNo (i);
    }
  PCSymBuild_ResolveConstTypes ();
  SymbolTable_ResolveConstructorTypes ();
  SymbolTable_SanityCheckConstants ();
  M2Pass_SetPassToNoPass ();
}


/*
   DoPass3 - parses the sources of all modules necessary to compile
             the required module, Main.
*/

static void DoPass3 (void)
{
  unsigned int Main;
  unsigned int Sym;
  unsigned int i;
  DynamicStrings_String FileName;

  M2Pass_SetPassToPass3 ();
  Main = SymbolTable_GetMainModule ();
  i = 1;
  Sym = M2Batch_GetModuleNo (i);
  while (Sym != SymbolTable_NulSym)
    {
      FileName = M2Batch_GetDefinitionModuleFile (Sym);
      if (FileName != NULL)
        {
          if (M2LexBuf_OpenSource (FileName))
            {
              ModuleType = M2Comp_Definition;
              if (! (P3Build_CompilationUnit ()))
                {
                  M2MetaError_MetaError0 ((const char *) "compilation failed", 18);
                  M2LexBuf_CloseSource ();
                  return;
                }
              M2LexBuf_CloseSource ();
            }
          else
            {
              M2Printf_fprintf1 (FIO_StdErr, (const char *) "failed to open %s\\n", 19, (const unsigned char *) &FileName, (sizeof (FileName)-1));
              libc_exit (1);
            }
          ModuleType = M2Comp_Implementation;
        }
      else
        {
          ModuleType = M2Comp_Program;
        }
      FileName = M2Batch_GetModuleFile (Sym);
      if (FileName != NULL)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (M2LexBuf_OpenSource (FileName))
            {
              if ((Main == Sym) || M2Options_WholeProgram)
                {
                  /* avoid dangling else.  */
                  if (! (P3Build_CompilationUnit ()))
                    {
                      M2MetaError_MetaError0 ((const char *) "compilation failed", 18);
                      M2LexBuf_CloseSource ();
                      return;
                    }
                }
              else
                {
                  /* 
                  not the main module .mod therefore must be implementing
                  a hidden type - we dont want to generate any
                  StatementSequence quadrupes but we do want to build TYPEs
                  and ConstExpressions.
  */
                  M2Pass_SetPassToNoPass ();
                  M2Pass_SetPassToPassHidden ();
                  if (! (PHBuild_CompilationUnit ()))
                    {
                      M2MetaError_MetaError0 ((const char *) "compilation failed", 18);
                      M2LexBuf_CloseSource ();
                      return;
                    }
                  M2Pass_SetPassToNoPass ();
                  M2Pass_SetPassToPass3 ();
                }
              M2LexBuf_CloseSource ();
            }
          else
            {
              M2Printf_fprintf1 (FIO_StdErr, (const char *) "failed to open %s\\n", 19, (const unsigned char *) &FileName, (sizeof (FileName)-1));
              libc_exit (1);
            }
        }
      i += 1;
      Sym = M2Batch_GetModuleNo (i);
    }
  M2Pass_SetPassToNoPass ();
}


/*
   compile - compile the filename.
*/

extern "C" void M2Comp_compile (void * filename)
{
  DynamicStrings_String f;

  f = DynamicStrings_InitStringCharStar (filename);
  Compile (f);
  f = DynamicStrings_KillString (f);
}


/*
   CompilingDefinitionModule - returns true if the current module being
                               compiled is a definition module.
*/

extern "C" bool M2Comp_CompilingDefinitionModule (void)
{
  return ModuleType == M2Comp_Definition;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CompilingImplementationModule - returns true if the current module being
                                   compiled is an implementation module.
*/

extern "C" bool M2Comp_CompilingImplementationModule (void)
{
  return ModuleType == M2Comp_Implementation;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CompilingProgramModule - returns true if the current module being
                            compiled is a program module.
*/

extern "C" bool M2Comp_CompilingProgramModule (void)
{
  return ModuleType == M2Comp_Program;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Comp_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  ModuleType = M2Comp_None;
  DepContent = static_cast<Indexing_Index> (NULL);
  DepOutput = static_cast<DynamicStrings_String> (NULL);
}

extern "C" void _M2_M2Comp_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
