/* do not edit automatically generated by mc from M2Swig.  */
/* M2Swig.mod generates a swig interface file for the main module.

Copyright (C) 2008-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#define _M2Swig_C

#include "GM2Swig.h"
#   include "GStorage.h"
#   include "GM2Options.h"
#   include "GSFIO.h"
#   include "GFIO.h"
#   include "GNameKey.h"
#   include "GM2Error.h"
#   include "GM2Printf.h"
#   include "GM2AsmUtil.h"
#   include "GSYSTEM.h"
#   include "GDynamicStrings.h"
#   include "GLists.h"
#   include "GM2Quads.h"
#   include "GM2System.h"
#   include "GM2Bitset.h"
#   include "GIndexing.h"
#   include "GM2Scope.h"
#   include "GM2Base.h"
#   include "GSymbolTable.h"
#   include "GM2BasicBlock.h"

typedef struct M2Swig__T1_r M2Swig__T1;

typedef M2Swig__T1 *M2Swig_UnboundedSig;

struct M2Swig__T1_r {
                      unsigned int type;
                      NameKey_Name name;
                    };

static bool includedArray;
static Indexing_Index uKey;
static unsigned int mainModule;
static Lists_List Done;
static Lists_List ToDo;
static FIO_File f;
static DynamicStrings_String name;
static bool FirstBasicBlock;
static bool Input;
static bool Output;
static bool InOut;
static bool CanGuess;
static bool IsKnown;
static unsigned int rs;
static unsigned int ws;

/*
   GenerateSwigFile - if the -fswig option was specified then generate
                      a swig interface file for the main module.
*/

extern "C" void M2Swig_GenerateSwigFile (unsigned int sym);

/*
   DoExported - includes, sym, into the, ToDo, list.
*/

static void DoExported (unsigned int sym);

/*
   MoveToDone - moves a sym to the, Done, list,
                providing that it is not already on it.
                It returns TRUE if the lists were modified.
*/

static bool MoveToDone (unsigned int sym);

/*
   MoveToToDo - moves a sym to the, ToDo, list,
                providing that it is not already on it.
                It returns TRUE if the lists were modified.
*/

static bool MoveToToDo (unsigned int sym);
static bool TryBase (unsigned int sym);

/*
   TrySystem - returns TRUE if sym can be moved to the done list.
*/

static bool TrySystem (unsigned int sym);

/*
   TryMove - tries to move sym to the done queue as long
             as type is known.
*/

static bool TryMove (unsigned int sym, unsigned int type);

/*
   TryType -
*/

static bool TryType (unsigned int sym);

/*
   TryVar -
*/

static bool TryVar (unsigned int sym);

/*
   TryProcedure -
*/

static bool TryProcedure (unsigned int sym);

/*
   TryUnbounded -
*/

static bool TryUnbounded (unsigned int sym);

/*
   TryParameter -
*/

static bool TryParameter (unsigned int sym);

/*
   TryDependents - returns TRUE if any alteration occurred to any
                   of the lists.
*/

static bool TryDependents (unsigned int sym);

/*
   DoResolveOrder - resolves the declaration order for swig (C).
*/

static void DoResolveOrder (void);

/*
   DoName -
*/

static void DoName (unsigned int sym);

/*
   DoParamName -
*/

static void DoParamName (unsigned int sym);

/*
   DoVar -
*/

static void DoVar (unsigned int sym);

/*
   DoType -
*/

static void DoType (unsigned int sym);

/*
   DoUnbounded -
*/

static void DoUnbounded (unsigned int sym);

/*
   DoBasicBlock -
*/

static void DoBasicBlock (M2BasicBlock_BasicBlock bb);

/*
   DetermineParameter -
*/

static void DetermineParameter (unsigned int procedure, unsigned int param);

/*
   PrintDirection -
*/

static void PrintDirection (void);

/*
   CalculateVarDirective -
*/

static void CalculateVarDirective (unsigned int procedure, unsigned int param, bool annotate);

/*
   AnnotateProcedure -
*/

static void AnnotateProcedure (unsigned int sym);

/*
   DoProcedure -
*/

static bool DoProcedure (unsigned int sym);

/*
   DoWriteSymbol -
*/

static void DoWriteSymbol (unsigned int sym);

/*
   DoCheckExported -
*/

static void DoCheckExported (unsigned int sym);

/*
   IsUnique - returns TRUE if the combination of, n, and, t,
              is unique.
*/

static bool IsUnique (NameKey_Name n, unsigned int t);

/*
   IsTypeUnique - returns TRUE if type, t, has not been entered yet.
*/

static bool IsTypeUnique (unsigned int t);

/*
   DoCheckUnbounded -
*/

static void DoCheckUnbounded (unsigned int sym);

/*
   DoWriteFile -
*/

static void DoWriteFile (unsigned int sym);

/*
   DoGenerateSwig -
*/

static void DoGenerateSwig (unsigned int sym);

/*
   Init -
*/

static void Init (void);

/*
   Kill -
*/

static void Kill (void);


/*
   DoExported - includes, sym, into the, ToDo, list.
*/

static void DoExported (unsigned int sym)
{
  Lists_IncludeItemIntoList (ToDo, sym);
}


/*
   MoveToDone - moves a sym to the, Done, list,
                providing that it is not already on it.
                It returns TRUE if the lists were modified.
*/

static bool MoveToDone (unsigned int sym)
{
  if (Lists_IsItemInList (Done, sym))
    {
      return false;
    }
  else if (Lists_IsItemInList (ToDo, sym))
    {
      /* avoid dangling else.  */
      Lists_RemoveItemFromList (ToDo, sym);
      Lists_IncludeItemIntoList (Done, sym);
      return true;
    }
  Lists_IncludeItemIntoList (Done, sym);
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MoveToToDo - moves a sym to the, ToDo, list,
                providing that it is not already on it.
                It returns TRUE if the lists were modified.
*/

static bool MoveToToDo (unsigned int sym)
{
  if (Lists_IsItemInList (Done, sym))
    {
      M2Error_InternalError ((const char *) "not expecting to get here", 25);
    }
  else if (Lists_IsItemInList (ToDo, sym))
    {
      /* avoid dangling else.  */
      return false;
    }
  else
    {
      /* avoid dangling else.  */
      Lists_IncludeItemIntoList (ToDo, sym);
      return true;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2Swig.def", 20, 1);
  __builtin_unreachable ();
}

static bool TryBase (unsigned int sym)
{
  /* 
   Trybase - returns TRUE
  */
  if (((((((((((sym == M2Base_Cardinal) || (sym == M2Base_Integer)) || (sym == M2Base_LongInt)) || (sym == M2Base_LongCard)) || (sym == M2Base_Char)) || (sym == M2Base_ShortCard)) || (sym == M2Base_ShortInt)) || (sym == M2Base_Real)) || (sym == M2Base_LongReal)) || (sym == M2Base_ShortReal)) || (sym == M2Base_Boolean))
    {
      return MoveToDone (sym);
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TrySystem - returns TRUE if sym can be moved to the done list.
*/

static bool TrySystem (unsigned int sym)
{
  if (((((sym == M2Bitset_Bitset) || (sym == M2System_Address)) || (sym == M2System_Byte)) || (sym == M2System_Loc)) || (sym == M2System_Word))
    {
      return MoveToDone (sym);
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TryMove - tries to move sym to the done queue as long
             as type is known.
*/

static bool TryMove (unsigned int sym, unsigned int type)
{
  if (Lists_IsItemInList (Done, type))
    {
      /* avoid dangling else.  */
      if (MoveToDone (sym))
        {
          return true;
        }
    }
  else
    {
      if (MoveToToDo (sym))
        {
          return true;
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TryType -
*/

static bool TryType (unsigned int sym)
{
  unsigned int type;
  bool result;

  type = SymbolTable_GetType (sym);
  result = TryDependents (type);
  if (TryMove (sym, type))
    {
      return true;
    }
  else
    {
      return result;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TryVar -
*/

static bool TryVar (unsigned int sym)
{
  unsigned int type;
  bool result;

  type = SymbolTable_GetType (sym);
  result = TryDependents (type);
  if (TryMove (sym, type))
    {
      return true;
    }
  else
    {
      return result;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TryProcedure -
*/

static bool TryProcedure (unsigned int sym)
{
  unsigned int son;
  unsigned int p;
  unsigned int i;
  unsigned int type;
  bool solved;
  bool result;

  type = SymbolTable_GetType (sym);
  result = false;
  solved = true;
  if (type != SymbolTable_NulSym)
    {
      if (TryDependents (type))
        {
          result = true;
        }
      if (! (Lists_IsItemInList (Done, type)))
        {
          solved = false;
        }
    }
  p = SymbolTable_NoOfParamAny (sym);
  i = 1;
  while (i <= p)
    {
      son = SymbolTable_GetNthParamAny (sym, i);
      if (TryDependents (son))
        {
          result = true;
        }
      if (! (Lists_IsItemInList (Done, son)))
        {
          solved = false;
        }
      i += 1;
    }
  if (solved)
    {
      /* avoid dangling else.  */
      if (MoveToDone (sym))
        {
          return true;
        }
    }
  else
    {
      if (MoveToToDo (sym))
        {
          return true;
        }
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TryUnbounded -
*/

static bool TryUnbounded (unsigned int sym)
{
  unsigned int type;
  bool result;

  type = SymbolTable_GetType (sym);
  result = TryDependents (type);
  if (TryMove (sym, type))
    {
      return true;
    }
  else
    {
      return result;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TryParameter -
*/

static bool TryParameter (unsigned int sym)
{
  unsigned int type;
  bool result;

  type = SymbolTable_GetType (sym);
  result = TryDependents (type);
  if (TryMove (sym, type))
    {
      return true;
    }
  else
    {
      return result;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TryDependents - returns TRUE if any alteration occurred to any
                   of the lists.
*/

static bool TryDependents (unsigned int sym)
{
  if (M2Base_IsBaseType (sym))
    {
      return TryBase (sym);
    }
  else if (M2System_IsSystemType (sym))
    {
      /* avoid dangling else.  */
      return TrySystem (sym);
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      return TryType (sym);
    }
  else if (SymbolTable_IsParameter (sym))
    {
      /* avoid dangling else.  */
      return TryParameter (sym);
    }
  else if (SymbolTable_IsProcedure (sym))
    {
      /* avoid dangling else.  */
      return TryProcedure (sym);
    }
  else if (SymbolTable_IsConstString (sym))
    {
      /* avoid dangling else.  */
      return MoveToDone (sym);
    }
  else if (SymbolTable_IsConstLit (sym))
    {
      /* avoid dangling else.  */
      return MoveToDone (sym);
    }
  else if ((SymbolTable_IsVar (sym)) && ((SymbolTable_GetMode (sym)) == SymbolTable_ImmediateValue))
    {
      /* avoid dangling else.  */
      return MoveToDone (sym);
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      return TryVar (sym);
    }
  else if (SymbolTable_IsUnbounded (sym))
    {
      /* avoid dangling else.  */
      return TryUnbounded (sym);
    }
  else
    {
      /* avoid dangling else.  */
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoResolveOrder - resolves the declaration order for swig (C).
*/

static void DoResolveOrder (void)
{
  unsigned int sym;
  unsigned int i;
  unsigned int n;
  bool movement;

  do {
    n = Lists_NoOfItemsInList (ToDo);
    movement = false;
    i = 1;
    while ((i <= n) && ! movement)
      {
        sym = static_cast<unsigned int> (Lists_GetItemFromList (ToDo, i));
        movement = TryDependents (sym);
        i += 1;
      }
  } while (! (! movement));
}


/*
   DoName -
*/

static void DoName (unsigned int sym)
{
  NameKey_Name n;

  n = M2AsmUtil_GetFullScopeAsmName (sym);
  M2Printf_fprintf1 (f, (const char *) "%a", 2, (const unsigned char *) &n, (sizeof (n)-1));
}


/*
   DoParamName -
*/

static void DoParamName (unsigned int sym)
{
  NameKey_Name n;

  n = SymbolTable_GetSymName (sym);
  M2Printf_fprintf1 (f, (const char *) "%a", 2, (const unsigned char *) &n, (sizeof (n)-1));
}


/*
   DoVar -
*/

static void DoVar (unsigned int sym)
{
  M2Printf_fprintf0 (f, (const char *) "extern \"C\" ", 11);
  DoType (SymbolTable_GetType (sym));
  M2Printf_fprintf0 (f, (const char *) " ", 1);
  DoName (sym);
  M2Printf_fprintf0 (f, (const char *) ";\\n", 3);
}


/*
   DoType -
*/

static void DoType (unsigned int sym)
{
  if (SymbolTable_IsPointer (sym))
    {
      DoType (SymbolTable_GetType (sym));
      M2Printf_fprintf0 (f, (const char *) " *", 2);
    }
  else if (sym == M2Base_Cardinal)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "unsigned int", 12);
    }
  else if (sym == M2Base_Integer)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "int", 3);
    }
  else if (sym == M2Base_Boolean)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "unsigned int", 12);
    }
  else if (sym == M2Base_LongInt)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "long long int", 13);
    }
  else if (sym == M2Base_LongCard)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "long long unsigned int", 22);
    }
  else if (sym == M2Base_Char)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "char", 4);
    }
  else if (sym == M2Base_ShortCard)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "short unsigned int", 18);
    }
  else if (sym == M2Base_ShortInt)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "short int", 9);
    }
  else if (sym == M2Base_Real)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "double", 6);
    }
  else if (sym == M2Base_LongReal)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "long double", 11);
    }
  else if (sym == M2Base_ShortReal)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "float", 5);
    }
  else if (sym == M2Bitset_Bitset)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "unsigned int", 12);
    }
  else if (sym == M2System_Address)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "void *", 6);
    }
  else if (sym == M2System_Byte)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "unsigned char", 13);
    }
  else if (sym == M2System_Loc)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "unsigned char", 13);
    }
  else if (sym == M2System_Word)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "unsigned int", 12);
    }
}


/*
   DoUnbounded -
*/

static void DoUnbounded (unsigned int sym)
{
  NameKey_Name n;
  unsigned int type;

  type = SymbolTable_GetType (sym);
  DoType (SymbolTable_GetType (type));
  n = SymbolTable_GetSymName (sym);
  M2Printf_fprintf2 (f, (const char *) " *_m2_address_%a, int _m2_high_%a", 33, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &n, (sizeof (n)-1));
}


/*
   DoBasicBlock -
*/

static void DoBasicBlock (M2BasicBlock_BasicBlock bb)
{
  unsigned int start;
  unsigned int end;

  start = M2BasicBlock_GetBasicBlockStart (bb);
  end = M2BasicBlock_GetBasicBlockEnd (bb);
  if (M2Quads_IsProcedureScope (start))
    {
      /* skip this basic block, as this will not modify the parameter  */
      return;
    }
  else if (IsKnown || CanGuess)
    {
      /* avoid dangling else.  */
      /* already resolved  */
      return;
    }
  else
    {
      /* avoid dangling else.  */
      if ((ws == 0) && (rs == 0))
        {
          FirstBasicBlock = false;
        }
      else if (rs == 0)
        {
          /* avoid dangling else.  */
          /* only written  */
          if (ws <= end)
            {
              Output = true;
              if (FirstBasicBlock)
                {
                  IsKnown = true;
                }
              else
                {
                  CanGuess = true;
                }
              FirstBasicBlock = false;
            }
        }
      else if (ws == 0)
        {
          /* avoid dangling else.  */
          /* only read  */
          Input = true;
          if ((rs <= end) && FirstBasicBlock)
            {
              IsKnown = true;
            }
          else
            {
              CanGuess = true;
            }
          FirstBasicBlock = false;
        }
      else if (rs <= ws)
        {
          /* avoid dangling else.  */
          /* read before write  */
          InOut = true;
          if (((rs <= end) && (ws <= end)) && FirstBasicBlock)
            {
              IsKnown = true;
            }
          else
            {
              CanGuess = true;
            }
          FirstBasicBlock = false;
        }
      else
        {
          /* avoid dangling else.  */
          /* must be written before read  */
          Output = true;
          if (((rs <= end) && (ws <= end)) && FirstBasicBlock)
            {
              IsKnown = true;
            }
          else
            {
              CanGuess = true;
            }
          FirstBasicBlock = false;
        }
    }
}


/*
   DetermineParameter -
*/

static void DetermineParameter (unsigned int procedure, unsigned int param)
{
  M2Scope_ScopeBlock sb;
  M2BasicBlock_BasicBlock bb;
  unsigned int we;
  unsigned int re;

  sb = M2Scope_InitScopeBlock (procedure);
  bb = M2BasicBlock_InitBasicBlocks (sb);
  Input = false;
  Output = false;
  InOut = false;
  CanGuess = false;
  IsKnown = false;
  FirstBasicBlock = true;
  SymbolTable_GetReadQuads (param, SymbolTable_RightValue, &rs, &re);
  SymbolTable_GetWriteQuads (param, SymbolTable_RightValue, &ws, &we);
  M2BasicBlock_ForeachBasicBlockDo (bb, (M2BasicBlock_BasicBlockProc) {(M2BasicBlock_BasicBlockProc_t) DoBasicBlock});
  M2BasicBlock_KillBasicBlocks (&bb);
  M2Scope_KillScopeBlock (&sb);
}


/*
   PrintDirection -
*/

static void PrintDirection (void)
{
  if (Input)
    {
      M2Printf_fprintf0 (f, (const char *) "INPUT", 5);
    }
  else if (Output)
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "OUTPUT", 6);
    }
  else
    {
      /* avoid dangling else.  */
      M2Printf_fprintf0 (f, (const char *) "INOUT", 5);
    }
}


/*
   CalculateVarDirective -
*/

static void CalculateVarDirective (unsigned int procedure, unsigned int param, bool annotate)
{
  unsigned int sym;

  sym = SymbolTable_GetParameterShadowVar (param);
  if (sym == SymbolTable_NulSym)
    {
      M2Error_InternalError ((const char *) "why did we get here", 19);
    }
  else
    {
      DetermineParameter (procedure, sym);
      if (annotate)
        {
          DoParamName (sym);
          if (IsKnown)
            {
              M2Printf_fprintf0 (f, (const char *) " is known to be an ", 19);
              PrintDirection ();
            }
          else if (CanGuess)
            {
              /* avoid dangling else.  */
              M2Printf_fprintf0 (f, (const char *) " is guessed to be an ", 21);
              PrintDirection ();
            }
          else
            {
              /* avoid dangling else.  */
              M2Printf_fprintf0 (f, (const char *) " is unknown", 11);
            }
        }
      else
        {
          M2Printf_fprintf0 (f, (const char *) "*", 1);
          if (IsKnown || CanGuess)
            {
              PrintDirection ();
            }
          else
            {
              DoParamName (sym);
            }
        }
    }
}


/*
   AnnotateProcedure -
*/

static void AnnotateProcedure (unsigned int sym)
{
  unsigned int son;
  unsigned int p;
  unsigned int i;
  bool needComma;

  M2Printf_fprintf0 (f, (const char *) "/* Parameter: ", 14);
  p = SymbolTable_NoOfParamAny (sym);
  i = 1;
  needComma = false;
  while (i <= p)
    {
      son = SymbolTable_GetNthParamAny (sym, i);
      if (SymbolTable_IsParameterVar (son))
        {
          if (needComma)
            {
              M2Printf_fprintf0 (f, (const char *) ",\\n   ", 6);
            }
          CalculateVarDirective (sym, son, true);
          needComma = true;
        }
      i += 1;
    }
  M2Printf_fprintf0 (f, (const char *) ".  */\\n\\n", 9);
}


/*
   DoProcedure -
*/

static bool DoProcedure (unsigned int sym)
{
  unsigned int son;
  unsigned int p;
  unsigned int i;
  bool found;

  found = false;
  M2Printf_fprintf0 (f, (const char *) "extern \"C\" ", 11);
  if ((SymbolTable_GetType (sym)) == SymbolTable_NulSym)
    {
      M2Printf_fprintf0 (f, (const char *) "void", 4);
    }
  else
    {
      DoType (SymbolTable_GetType (sym));
    }
  M2Printf_fprintf0 (f, (const char *) " ", 1);
  DoName (sym);
  M2Printf_fprintf0 (f, (const char *) " (", 2);
  p = SymbolTable_NoOfParamAny (sym);
  if (p == 0)
    {
      M2Printf_fprintf0 (f, (const char *) "void", 4);
    }
  else
    {
      i = 1;
      while (i <= p)
        {
          son = SymbolTable_GetNthParamAny (sym, i);
          if (SymbolTable_IsUnboundedParamAny (sym, i))
            {
              DoUnbounded (son);
            }
          else
            {
              DoType (SymbolTable_GetType (son));
              M2Printf_fprintf0 (f, (const char *) " ", 1);
              if (SymbolTable_IsParameterVar (son))
                {
                  found = true;
                  CalculateVarDirective (sym, son, false);
                }
              else
                {
                  DoParamName (son);
                }
            }
          if (i < p)
            {
              M2Printf_fprintf0 (f, (const char *) ", ", 2);
            }
          i += 1;
        }
    }
  M2Printf_fprintf0 (f, (const char *) ");\\n", 4);
  return found;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoWriteSymbol -
*/

static void DoWriteSymbol (unsigned int sym)
{
  if (M2Base_IsBaseType (sym))
    {}  /* empty.  */
  else if (M2System_IsSystemType (sym))
    {
      /* avoid dangling else.  */
    }
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
    }
  else if (SymbolTable_IsProcedure (sym))
    {
      /* avoid dangling else.  */
      if (DoProcedure (sym))
        {
          AnnotateProcedure (sym);
        }
    }
  else if (SymbolTable_IsConstString (sym))
    {
      /* avoid dangling else.  */
    }
  else if (SymbolTable_IsConstLit (sym))
    {
      /* avoid dangling else.  */
    }
  else if ((SymbolTable_IsVar (sym)) && ((SymbolTable_GetMode (sym)) == SymbolTable_ImmediateValue))
    {
      /* avoid dangling else.  */
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      DoVar (sym);
    }
}


/*
   DoCheckExported -
*/

static void DoCheckExported (unsigned int sym)
{
  if (SymbolTable_IsExported (mainModule, sym))
    {
      DoWriteSymbol (sym);
    }
}


/*
   IsUnique - returns TRUE if the combination of, n, and, t,
              is unique.
*/

static bool IsUnique (NameKey_Name n, unsigned int t)
{
  M2Swig_UnboundedSig p;
  unsigned int h;
  unsigned int i;

  i = 1;
  h = Indexing_HighIndice (uKey);
  while (i <= h)
    {
      p = static_cast<M2Swig_UnboundedSig> (Indexing_GetIndice (uKey, i));
      if ((p->type == t) && (p->name == n))
        {
          return false;
        }
      i += 1;
    }
  h += 1;
  Storage_ALLOCATE ((void **) &p, sizeof (M2Swig__T1));
  p->type = t;
  p->name = n;
  Indexing_PutIndice (uKey, h, reinterpret_cast <void *> (p));
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsTypeUnique - returns TRUE if type, t, has not been entered yet.
*/

static bool IsTypeUnique (unsigned int t)
{
  M2Swig_UnboundedSig p;
  unsigned int h;
  unsigned int i;

  i = 1;
  h = Indexing_HighIndice (uKey);
  while (i <= h)
    {
      p = static_cast<M2Swig_UnboundedSig> (Indexing_GetIndice (uKey, i));
      if (p->type == t)
        {
          return false;
        }
      i += 1;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoCheckUnbounded -
*/

static void DoCheckUnbounded (unsigned int sym)
{
  NameKey_Name name;
  unsigned int type;
  bool typeUnique;

  if ((SymbolTable_IsParameter (sym)) && (SymbolTable_IsParameterUnbounded (sym)))
    {
      name = SymbolTable_GetSymName (sym);
      type = SymbolTable_GetType (SymbolTable_GetType (sym));
      typeUnique = IsTypeUnique (type);
      if (IsUnique (name, type))
        {
          if (! includedArray)
            {
              includedArray = true;
              M2Printf_fprintf0 (f, (const char *) "%%include \"carrays.i\"\\n", 23);
            }
          M2Printf_fprintf0 (f, (const char *) "%%", 2);
          M2Printf_fprintf0 (f, (const char *) "apply (char *STRING, int LENGTH) { (", 36);
          DoUnbounded (sym);
          M2Printf_fprintf0 (f, (const char *) ") };\\n", 6);
          if (typeUnique)
            {
              M2Printf_fprintf0 (f, (const char *) "%%array_functions(", 18);
              DoType (type);
              M2Printf_fprintf0 (f, (const char *) ", ", 2);
              DoType (type);
              M2Printf_fprintf0 (f, (const char *) "Array);\\n", 9);
            }
        }
    }
}


/*
   DoWriteFile -
*/

static void DoWriteFile (unsigned int sym)
{
  NameKey_Name n;

  mainModule = sym;
  n = SymbolTable_GetSymName (sym);
  M2Printf_fprintf0 (f, (const char *) "/* Automatically generated by gm2 -fswig.  */\\n", 47);
  M2Printf_fprintf0 (f, (const char *) "%%", 2);
  M2Printf_fprintf1 (f, (const char *) "module %a\\n\\n", 13, (const unsigned char *) &n, (sizeof (n)-1));
  M2Printf_fprintf0 (f, (const char *) "%%", 2);
  M2Printf_fprintf1 (f, (const char *) "include exception.i\\n\\n", 23, (const unsigned char *) &n, (sizeof (n)-1));
  M2Printf_fprintf0 (f, (const char *) "%%", 2);
  M2Printf_fprintf0 (f, (const char *) "exception {\\n", 13);
  M2Printf_fprintf0 (f, (const char *) "  try {\\n", 9);
  M2Printf_fprintf0 (f, (const char *) "     $action\\n", 14);
  M2Printf_fprintf0 (f, (const char *) "  } catch (int i) {\\n", 21);
  M2Printf_fprintf0 (f, (const char *) "     return NULL;\\n", 19);
  M2Printf_fprintf0 (f, (const char *) "  }\\n", 5);
  M2Printf_fprintf0 (f, (const char *) "}\\n\\n", 5);
  Lists_ForeachItemInListDo (Done, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DoCheckUnbounded});
  M2Printf_fprintf0 (f, (const char *) "\\n%%{\\n", 7);
  Lists_ForeachItemInListDo (Done, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DoCheckExported});
  M2Printf_fprintf0 (f, (const char *) "%%}\\n\\n", 7);
  Lists_ForeachItemInListDo (Done, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DoCheckExported});
}


/*
   DoGenerateSwig -
*/

static void DoGenerateSwig (unsigned int sym)
{
  Init ();
  name = DynamicStrings_ConCat (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym))), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".i", 2)));
  f = SFIO_OpenToWrite (name);
  SymbolTable_ForeachExportedDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DoExported});
  DoResolveOrder ();
  DoWriteFile (sym);
  FIO_Close (f);
  name = DynamicStrings_KillString (name);
  Kill ();
}


/*
   Init -
*/

static void Init (void)
{
  Lists_InitList (&Done);
  Lists_InitList (&ToDo);
  uKey = Indexing_InitIndex (1);
  includedArray = false;
}


/*
   Kill -
*/

static void Kill (void)
{
  Lists_KillList (&Done);
  Lists_KillList (&ToDo);
  uKey = Indexing_KillIndex (uKey);
}


/*
   GenerateSwigFile - if the -fswig option was specified then generate
                      a swig interface file for the main module.
*/

extern "C" void M2Swig_GenerateSwigFile (unsigned int sym)
{
  if (M2Options_GenerateSwig)
    {
      DoGenerateSwig (sym);
    }
}

extern "C" void _M2_M2Swig_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2Swig_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
