/* do not edit automatically generated by mc from m2expr.  */
/* m2expr.def definition module for m2expr.cc.

Copyright (C) 2011-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_m2expr_H)
#   define _m2expr_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "Ggcctypes.h"
#   include "GCDataTypes.h"

#   if defined (_m2expr_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

typedef struct m2expr_BuildBinCheckProcedure_p m2expr_BuildBinCheckProcedure;

typedef struct m2expr_BuildBinProcedure_p m2expr_BuildBinProcedure;

typedef struct m2expr_BuildUnaryProcedure_p m2expr_BuildUnaryProcedure;

typedef struct m2expr_BuildUnaryCheckProcedure_p m2expr_BuildUnaryCheckProcedure;

typedef struct m2expr_BuildExprProcedure_p m2expr_BuildExprProcedure;

typedef struct m2expr_BuildSetProcedure_p m2expr_BuildSetProcedure;

typedef struct m2expr_BuildUnarySetProcedure_p m2expr_BuildUnarySetProcedure;

typedef struct m2expr_BuildUnarySetFunction_p m2expr_BuildUnarySetFunction;

typedef tree (*m2expr_BuildBinCheckProcedure_t) (location_t, tree, tree, tree, tree, tree);
typedef m2expr_BuildBinCheckProcedure_t m2expr_BuildBinCheckProcedure_C;

struct m2expr_BuildBinCheckProcedure_p { m2expr_BuildBinCheckProcedure_t proc; };

typedef tree (*m2expr_BuildBinProcedure_t) (location_t, tree, tree, bool);
typedef m2expr_BuildBinProcedure_t m2expr_BuildBinProcedure_C;

struct m2expr_BuildBinProcedure_p { m2expr_BuildBinProcedure_t proc; };

typedef tree (*m2expr_BuildUnaryProcedure_t) (location_t, tree, bool);
typedef m2expr_BuildUnaryProcedure_t m2expr_BuildUnaryProcedure_C;

struct m2expr_BuildUnaryProcedure_p { m2expr_BuildUnaryProcedure_t proc; };

typedef tree (*m2expr_BuildUnaryCheckProcedure_t) (location_t, tree, tree, tree, tree);
typedef m2expr_BuildUnaryCheckProcedure_t m2expr_BuildUnaryCheckProcedure_C;

struct m2expr_BuildUnaryCheckProcedure_p { m2expr_BuildUnaryCheckProcedure_t proc; };

typedef tree (*m2expr_BuildExprProcedure_t) (location_t, tree, tree);
typedef m2expr_BuildExprProcedure_t m2expr_BuildExprProcedure_C;

struct m2expr_BuildExprProcedure_p { m2expr_BuildExprProcedure_t proc; };

typedef void (*m2expr_BuildSetProcedure_t) (location_t, tree, tree, tree, tree, bool);
typedef m2expr_BuildSetProcedure_t m2expr_BuildSetProcedure_C;

struct m2expr_BuildSetProcedure_p { m2expr_BuildSetProcedure_t proc; };

typedef void (*m2expr_BuildUnarySetProcedure_t) (location_t, tree, bool);
typedef m2expr_BuildUnarySetProcedure_t m2expr_BuildUnarySetProcedure_C;

struct m2expr_BuildUnarySetProcedure_p { m2expr_BuildUnarySetProcedure_t proc; };

typedef tree (*m2expr_BuildUnarySetFunction_t) (location_t, tree, bool);
typedef m2expr_BuildUnarySetFunction_t m2expr_BuildUnarySetFunction_C;

struct m2expr_BuildUnarySetFunction_p { m2expr_BuildUnarySetFunction_t proc; };


/*
   init - initialize this module.
*/

EXTERN void m2expr_init (location_t location);

/*
   CSTIntToString - return an integer string using base 10 and no padding.
                    The string returned will have been mallocd.
*/

EXTERN char * m2expr_CSTIntToString (tree t);

/*
   CSTIntToChar - return the CHAR representation of tree t.
*/

EXTERN char m2expr_CSTIntToChar (tree t);

/*
   CSTIntToChar - return the CHAR representation of tree t.
*/

EXTERN bool m2expr_CheckConstStrZtypeRange (location_t location, char * str, unsigned int base);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN int m2expr_CompareTrees (tree e1, tree e2);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetPointerOne (location_t location);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetPointerZero (location_t location);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetWordOne (location_t location);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetWordZero (location_t location);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetIntegerOne (location_t location);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetIntegerZero (location_t location);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetCardinalOne (location_t location);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetCardinalZero (location_t location);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetSizeOfInBits (tree type);

/*
   CompareTrees - returns -1 if e1 < e2, 0 if e1 == e2, and 1 if e1 > e2.
*/

EXTERN tree m2expr_GetSizeOf (location_t location, tree type);

/*
    BuildLogicalRotate - builds the ISO Modula-2 ROTATE operator
                         for a fundamental data type.
*/

EXTERN void m2expr_BuildLogicalRotate (location_t location, tree op1, tree op2, tree op3, tree nBits, bool needconvert);

/*
    BuildLRRn - builds and returns tree (op1 rotate right by op2 bits)
                it rotates a set of size, nBits.
*/

EXTERN tree m2expr_BuildLRRn (location_t location, tree op1, tree op2, tree nBits, bool needconvert);

/*
    BuildLRLn - builds and returns tree (op1 rotate left by op2 bits)
                it rotates a set of size, nBits.
*/

EXTERN tree m2expr_BuildLRLn (location_t location, tree op1, tree op2, tree nBits, bool needconvert);

/*
    BuildLRLn - builds and returns tree (op1 rotate left by op2 bits)
                it rotates a set of size, nBits.
*/

EXTERN tree m2expr_BuildMask (location_t location, tree nBits, bool needconvert);

/*
    BuildMult - builds a multiplication tree.
*/

EXTERN tree m2expr_BuildMult (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildMultCheck - builds a multiplication tree after checking for overflow.
*/

EXTERN tree m2expr_BuildMultCheck (location_t location, tree op1, tree op2, tree lowest, tree min, tree max);

/*
    BuildLRR - builds and returns tree (op1 rotate right by op2 bits)
*/

EXTERN tree m2expr_BuildLRR (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildLRL - builds and returns tree (op1 rotate left by op2 bits)
*/

EXTERN tree m2expr_BuildLRL (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildLogicalShift - builds the ISO Modula-2 SHIFT operator
                        for a fundamental data type.
*/

EXTERN void m2expr_BuildLogicalShift (location_t location, tree op1, tree op2, tree op3, tree nBits, bool needconvert);

/*
    BuildLSR - builds and returns tree (op1 >> op2)
*/

EXTERN tree m2expr_BuildLSR (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildLSL - builds and returns tree (op1 << op2)
*/

EXTERN tree m2expr_BuildLSL (location_t location, tree op1, tree op2, bool needconvert);

/*
   BuildDivM2 - build and return ((op2 < 0) : (op1 divtrunc op2) ? (op1 divfloor op2))
                when -fiso, -fpim4 or -fpositive-mod-floor-div is present else
                return op1 div trunc op2
*/

EXTERN tree m2expr_BuildDivM2 (location_t location, tree op1, tree op2, bool needsconvert);

/*
   BuildDivM2Check - build and return ((op2 < 0) : (op1 divtrunc op2) ? (op1 divfloor op2))
                     when -fiso, -fpim4 or -fpositive-mod-floor-div is present else
                     return op1 div trunc op2.  Use the checking div equivalents.
*/

EXTERN tree m2expr_BuildDivM2Check (location_t location, tree op1, tree op2, tree lowest, tree min, tree max);

/*
   BuildModM2 - build and return ((op2 < 0) : (op1 divtrunc op2) ? (op1 divfloor op2))
                when -fiso, -fpim4 or -fpositive-mod-floor-div is present else
                return op1 div trunc op2
*/

EXTERN tree m2expr_BuildModM2 (location_t location, tree op1, tree op2, bool needsconvert);

/*
   BuildModM2Check - if iso or pim4 then build and return ((op2 < 0) : (op1
                     modceil op2) ?  (op1 modfloor op2)) otherwise use modtrunc.
                     Use the checking mod equivalents.
                     build and return ((op2 < 0) : (op1 divtrunc op2) ? (op1 divfloor op2))
                     when -fiso, -fpim4 or -fpositive-mod-floor-div is present else
                     return op1 div trunc op2.  Use the checking div equivalents.
*/

EXTERN tree m2expr_BuildModM2Check (location_t location, tree op1, tree op2, tree lowest, tree min, tree max);

/*
    BuildModFloor - builds a modulus tree.
*/

EXTERN tree m2expr_BuildModFloor (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildDivCeil - builds a division tree.
*/

EXTERN tree m2expr_BuildDivCeil (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildModCeil - builds a modulus tree.
*/

EXTERN tree m2expr_BuildModCeil (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildDivFloor - builds a division tree.
*/

EXTERN tree m2expr_BuildDivFloor (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildModTrunc - builds a modulus tree.
*/

EXTERN tree m2expr_BuildModTrunc (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildDivTrunc - builds a division tree.
*/

EXTERN tree m2expr_BuildDivTrunc (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildDivTruncCheck - builds a division tree after checking for overflow.
*/

EXTERN tree m2expr_BuildDivTruncCheck (location_t location, tree op1, tree op2, tree lowest, tree min, tree max);

/*
   BuildRDiv - builds a division tree (this should only be used for REAL and COMPLEX
               types and NEVER for integer based types).
*/

EXTERN tree m2expr_BuildRDiv (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildSubCheck - builds a subtraction tree after checking for overflow.
*/

EXTERN tree m2expr_BuildSubCheck (location_t location, tree op1, tree op2, tree lowest, tree min, tree max);

/*
    BuildAddCheck - builds an addition tree after checking for overflow.
*/

EXTERN tree m2expr_BuildAddCheck (location_t location, tree op1, tree op2, tree lowest, tree min, tree max);

/*
    BuildSub - builds a subtraction tree.
*/

EXTERN tree m2expr_BuildSub (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildAdd - builds an addition tree.
*/

EXTERN tree m2expr_BuildAdd (location_t location, tree op1, tree op2, bool needconvert);

/*
    FoldAndStrip - return expression, t, after it has been folded (if possible).
*/

EXTERN tree m2expr_FoldAndStrip (tree t);

/*
    StringLength - returns an unsigned int which is the length
                   of, string.
*/

EXTERN unsigned int m2expr_StringLength (tree string);

/*
   TreeOverflow - returns TRUE if the contant expression, t, has
                  caused an overflow. No error message or warning
                  is emitted and no modification is made to, t.
*/

EXTERN bool m2expr_TreeOverflow (tree t);

/*
    RemoveOverflow - if tree, t, is a constant expression it removes
                     any overflow flag and returns, t.
*/

EXTERN tree m2expr_RemoveOverflow (tree t);

/*
    BuildCoerce - returns a tree containing the expression, expr, after
                  it has been coersed to, type.
*/

EXTERN tree m2expr_BuildCoerce (location_t location, tree des, tree type, tree expr);

/*
    BuildTrunc - returns an integer expression from a REAL or LONGREAL op1.
*/

EXTERN tree m2expr_BuildTrunc (tree op1);

/*
    BuildNegate - builds a negate expression and returns the tree.
*/

EXTERN tree m2expr_BuildNegate (location_t location, tree op1, bool needconvert);

/*
    BuildNegateCheck - builds a negate expression and returns the tree.
*/

EXTERN tree m2expr_BuildNegateCheck (location_t location, tree arg, tree lowest, tree min, tree max);

/*
    BuildSetNegate - builds a set negate expression and returns the tree.
*/

EXTERN tree m2expr_BuildSetNegate (location_t location, tree op1, bool needconvert);

/*
    BuildTBitSize - returns the minimum number of bits to represent, type.
*/

EXTERN tree m2expr_BuildTBitSize (location_t location, tree type);

/*
    BuildSize - builds a SIZE function expression and returns the tree.
*/

EXTERN tree m2expr_BuildSize (location_t location, tree op1, bool needconvert);

/*
    BuildAddr - builds an expression which calculates the address of
                op1 and returns the tree.
*/

EXTERN tree m2expr_BuildAddr (location_t location, tree op1, bool needconvert);

/*
    BuildOffset1 - builds an expression containing the number of bytes the field
                   is offset from the start of the record structure.
                   This function is the same as the above, except that it
                   derives the record from the field and then calls BuildOffset.
                   The expression is returned.
*/

EXTERN tree m2expr_BuildOffset1 (location_t location, tree field, bool needconvert);

/*
    BuildOffset - builds an expression containing the number of bytes the field
                  is offset from the start of the record structure.
                  The expression is returned.
*/

EXTERN tree m2expr_BuildOffset (location_t location, tree record, tree field, bool needconvert);

/*
    BuildLogicalOrAddress - build a logical or expressions and return the tree.
*/

EXTERN tree m2expr_BuildLogicalOrAddress (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildLogicalOr - build a logical or expressions and return the tree.
*/

EXTERN tree m2expr_BuildLogicalOr (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildLogicalAnd - build a logical and expression and return the tree.
*/

EXTERN tree m2expr_BuildLogicalAnd (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildLogicalAnd - build a logical and expression and return the tree.
*/

EXTERN tree m2expr_BuildSymmetricDifference (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildLogicalDifference - build a logical difference expression and
                             return the tree.
                             (op1 and (not op2))
*/

EXTERN tree m2expr_BuildLogicalDifference (location_t location, tree op1, tree op2, bool needconvert);

/*
    BuildLessThan - return a tree which computes <
*/

EXTERN tree m2expr_BuildLessThan (location_t location, tree op1, tree op2);

/*
    BuildGreaterThan - return a tree which computes >
*/

EXTERN tree m2expr_BuildGreaterThan (location_t location, tree op1, tree op2);

/*
    BuildLessThanOrEqual - return a tree which computes <
*/

EXTERN tree m2expr_BuildLessThanOrEqual (location_t location, tree op1, tree op2);

/*
    BuildGreaterThanOrEqual - return a tree which computes >=
*/

EXTERN tree m2expr_BuildGreaterThanOrEqual (location_t location, tree op1, tree op2);

/*
    BuildEqualTo - return a tree which computes =
*/

EXTERN tree m2expr_BuildEqualTo (location_t location, tree op1, tree op2);

/*
    BuildEqualTo - return a tree which computes =
*/

EXTERN tree m2expr_BuildNotEqualTo (location_t location, tree op1, tree op2);

/*
    BuildIsSuperset - return a tree which computes:  op1 & op2 == op2
*/

EXTERN tree m2expr_BuildIsSuperset (location_t location, tree op1, tree op2);

/*
    BuildIsNotSuperset - return a tree which computes: op1 & op2 != op2
*/

EXTERN tree m2expr_BuildIsNotSuperset (location_t location, tree op1, tree op2);

/*
    BuildIsSubset - return a tree which computes:  op1 & op2 == op1
*/

EXTERN tree m2expr_BuildIsSubset (location_t location, tree op1, tree op2);

/*
    BuildIsNotSubset - return a tree which computes: op1 & op2 != op1
*/

EXTERN tree m2expr_BuildIsNotSubset (location_t location, tree op1, tree op2);

/*
    BuildIfConstInVar - generates: if constel in varset then goto label.
*/

EXTERN void m2expr_BuildIfConstInVar (location_t location, tree type, tree varset, tree constel, bool is_lvalue, int fieldno, char * label);

/*
    BuildIfConstInVar - generates: if constel in varset then goto label.
*/

EXTERN void m2expr_BuildIfNotConstInVar (location_t location, tree type, tree varset, tree constel, bool is_lvalue, int fieldno, char * label);

/*
    BuildIfVarInVar - generates: if varel in varset then goto label
*/

EXTERN void m2expr_BuildIfVarInVar (location_t location, tree type, tree varset, tree varel, bool is_lvalue, tree low, tree high, char * label);

/*
    BuildIfNotVarInVar - generates: if not (varel in varset) then goto label
*/

EXTERN void m2expr_BuildIfNotVarInVar (location_t location, tree type, tree varset, tree varel, bool is_lvalue, tree low, tree high, char * label);

/*
    BuildForeachWordInSetDoIfExpr - foreach word in set, type, compute the expression, expr, and if true
                                    goto label.
*/

EXTERN void m2expr_BuildForeachWordInSetDoIfExpr (location_t location, tree type, tree op1, tree op2, bool is_op1lvalue, bool is_op2lvalue, bool is_op1const, bool isop2const, m2expr_BuildExprProcedure_C expr, char * label);

/*
    BuildIfInRangeGoto - if var is in the range low..high then goto label
*/

EXTERN void m2expr_BuildIfInRangeGoto (location_t location, tree var, tree low, tree high, char * label);

/*
    BuildIfNotInRangeGoto - if var is not in the range low..high then goto label
*/

EXTERN void m2expr_BuildIfNotInRangeGoto (location_t location, tree var, tree low, tree high, char * label);

/*
    BuildArray - returns a tree which accesses array[index]
                 given, lowIndice.
*/

EXTERN tree m2expr_BuildArray (location_t location, tree type, tree array, tree index, tree lowIndice);

/*
   BuildComponentRef - build a component reference tree which accesses record.field.
                       If field does not belong to record it calls
                       BuildComponentRef on the penultimate field.
*/

EXTERN tree m2expr_BuildComponentRef (location_t location, tree record, tree field);

/*
    BuildIndirect - build: ( *target) given that the object to be copied is of, type.
*/

EXTERN tree m2expr_BuildIndirect (location_t location, tree target, tree type);

/*
    IsTrue - returns TRUE if, t, is known to be TRUE.
*/

EXTERN bool m2expr_IsTrue (tree t);

/*
    IsFalse - returns FALSE if, t, is known to be FALSE.
*/

EXTERN bool m2expr_IsFalse (tree t);

/*
    GetCstInteger - return the integer value of the cst tree.
*/

EXTERN int m2expr_GetCstInteger (tree cst);

/*
    AreConstantsEqual - maps onto tree.c (tree_int_cst_equal). It returns
                        TRUE if the value of e1 is the same as e2.
*/

EXTERN bool m2expr_AreConstantsEqual (tree e1, tree e2);

/*
    AreRealOrComplexConstantsEqual - returns TRUE if constants,
                                     e1 and e2 are equal according
                                     to IEEE rules.  This does not
                                     perform bit equivalence for
                                     example IEEE states that
                                     -0 == 0 and NaN != NaN.
*/

EXTERN bool m2expr_AreRealOrComplexConstantsEqual (tree e1, tree e2);

/*
    DetermineSign - returns -1 if e<0
                             0 if e==0
                             1 if e>0

                    an unsigned constant will never return -1
*/

EXTERN int m2expr_DetermineSign (tree e);

/*
    BuildCap - builds the Modula-2 function CAP(t) and returns
               the result in a gcc tree.
*/

EXTERN tree m2expr_BuildCap (location_t location, tree t);

/*
    BuildAbs - builds the Modula-2 function ABS(t) and returns
               the result in a gcc tree.
*/

EXTERN tree m2expr_BuildAbs (location_t location, tree t);

/*
    BuildRe - builds an expression for the function RE.
*/

EXTERN tree m2expr_BuildRe (tree op1);

/*
    BuildIm - builds an expression for the function IM.
*/

EXTERN tree m2expr_BuildIm (tree op1);

/*
    BuildCmplx - builds an expression for the function CMPLX.
*/

EXTERN tree m2expr_BuildCmplx (location_t location, tree type, tree real, tree imag);

/*
    BuildBinaryForeachWordDo - provides the large set operators. Each word
                               (or less) of the set can be calculated by binop.
                               This procedure runs along each word of the
                               large set invoking the binop.
*/

EXTERN void m2expr_BuildBinaryForeachWordDo (location_t location, tree type, tree op1, tree op2, tree op3, m2expr_BuildBinProcedure_C binop, bool is_op1lvalue, bool is_op2lvalue, bool is_op3lvalue, bool is_op1_const, bool is_op2_const, bool is_op3_const);

/*
   BuildBinarySetDo - if the size of the set is <= TSIZE(WORD) then
                         op1 := binop(op2, op3)
                      else
                         call m2rtsprocedure(op1, op2, op3)
*/

EXTERN void m2expr_BuildBinarySetDo (location_t location, tree settype, tree op1, tree op2, tree op3, m2expr_BuildSetProcedure_C binop, bool is_op1lvalue, bool is_op2lvalue, bool is_op3lvalue, tree nBits, tree unbounded, tree varproc, tree leftproc, tree rightproc);

/*
   ConstantExpressionWarning - issue a warning if the constant has overflowed.
*/

EXTERN void m2expr_ConstantExpressionWarning (tree value);

/*
   BuildAddAddress - returns an expression op1+op2 where op1 is a pointer type
                     and op2 is not a pointer type.
*/

EXTERN tree m2expr_BuildAddAddress (location_t location, tree op1, tree op2);

/*
   calcNbits - return the smallest number of bits required to
               represent: min..max.
*/

EXTERN tree m2expr_calcNbits (location_t location, tree min, tree max);

/*
   OverflowZType - return TRUE if str exceeds the ZTYPE range.
*/

EXTERN bool m2expr_OverflowZType (location_t location, const char * str, unsigned int base, bool issueError);

/*
   BuildCondIfExpression - returns a tree containing
                           (condition) ? (left) : right.
*/

EXTERN tree m2expr_BuildCondIfExpression (tree condition, tree type, tree left, tree right);

/*
   BuildSystemTBitSize - return the minimum number of bits to represent type.
                         This function is called when evaluating
                         SYSTEM.TBITSIZE.
*/

EXTERN tree m2expr_BuildSystemTBitSize (location_t location, tree type);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
