/* do not edit automatically generated by mc from M2GenGCC.  */
/* M2GenGCC.mod convert the quadruples into GCC trees.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2GenGCC_C

#include "GM2GenGCC.h"
#   include "GSYSTEM.h"
#   include "GSymbolTable.h"
#   include "GM2Batch.h"
#   include "GM2LexBuf.h"
#   include "GM2Code.h"
#   include "GM2Debug.h"
#   include "GM2Error.h"
#   include "GM2MetaError.h"
#   include "GM2Options.h"
#   include "GM2Printf.h"
#   include "GM2Quiet.h"
#   include "GM2Base.h"
#   include "GM2Bitset.h"
#   include "GNameKey.h"
#   include "GDynamicStrings.h"
#   include "GFormatStrings.h"
#   include "GM2System.h"
#   include "GM2FileName.h"
#   include "GSymbolConversion.h"
#   include "GM2StackWord.h"
#   include "GLists.h"
#   include "GM2ALU.h"
#   include "GM2GCCDeclare.h"
#   include "GM2Range.h"
#   include "Gm2builtins.h"
#   include "Gm2expr.h"
#   include "Gm2tree.h"
#   include "Ggcctypes.h"
#   include "Gm2decl.h"
#   include "Gm2statement.h"
#   include "Gm2type.h"
#   include "Gm2block.h"
#   include "Gm2misc.h"
#   include "Gm2convert.h"
#   include "Gm2except.h"
#   include "GM2Quads.h"
#   include "GM2Check.h"
#   include "GM2SSA.h"
#   include "GM2Optimize.h"
#   include "GM2BasicBlock.h"

#   define Debugging false
#   define PriorityDebugging false
#   define CascadedDebugging false
typedef struct M2GenGCC_DoProcedure_p M2GenGCC_DoProcedure;

typedef struct M2GenGCC_DoUnaryProcedure_p M2GenGCC_DoUnaryProcedure;

#   define Verbose false
#   define DebugTokPos false
#   define DebugTokPos false
typedef void (*M2GenGCC_DoProcedure_t) (unsigned int);
struct M2GenGCC_DoProcedure_p { M2GenGCC_DoProcedure_t proc; };

typedef void (*M2GenGCC_DoUnaryProcedure_t) (unsigned int);
struct M2GenGCC_DoUnaryProcedure_p { M2GenGCC_DoUnaryProcedure_t proc; };

static unsigned int Memset;
static unsigned int Memcpy;
static unsigned int CurrentQuadToken;
static unsigned int UnboundedLabelNo;
static unsigned int LastLine;
static M2Quads_QuadOperator LastOperator;
static M2StackWord_StackOfWord ScopeStack;
static bool NoChange;
static tree tryBlock;
static tree handlerBlock;

/*
   ConvertQuadsToTree - runs through the quadruple list and converts it into
                        the GCC tree structure.
*/

extern "C" void M2GenGCC_ConvertQuadsToTree (unsigned int Start, unsigned int End);

/*
   ResolveConstantExpressions - resolves constant expressions from the quadruple list.
                                It returns TRUE if one or more constants were folded.
                                When a constant symbol value is solved, the call back
                                p(sym) is invoked.
*/

extern "C" bool M2GenGCC_ResolveConstantExpressions (M2GCCDeclare_WalkAction p, M2BasicBlock_BasicBlock bb);

/*
   GetHighFromUnbounded - returns a Tree containing the value of
                          param.HIGH.
*/

extern "C" tree M2GenGCC_GetHighFromUnbounded (location_t location, unsigned int dim, unsigned int param);

/*
   StringToChar - if type=Char and str is a string (of size <= 1)
                  then convert the string into a character constant.
*/

extern "C" tree M2GenGCC_StringToChar (tree t, unsigned int type, unsigned int str);

/*
   LValueToGenericPtr - returns a Tree representing symbol, sym.
                        It coerces a lvalue into an internal pointer type
*/

extern "C" tree M2GenGCC_LValueToGenericPtr (location_t location, unsigned int sym);

/*
   ZConstToTypedConst - checks whether op1 and op2 are constants and
                        coerces, t, appropriately.
*/

extern "C" tree M2GenGCC_ZConstToTypedConst (tree t, unsigned int op1, unsigned int op2);

/*
   PrepareCopyString - returns two trees:
                       length    number of bytes to be copied (including the nul if room)
                       srcTreeType the new string type (with the extra nul character).

                       Pre condition:  destStrType the dest type string.
                                       src is the original string (without a nul)
                                       to be copied.
                       Post condition: TRUE or FALSE is returned.
                                       if true length and srcTreeType will be assigned
                                       else length is set to the maximum length to be
                                            copied and srcTree is set to the max length
                                            which fits in dest.
*/

extern "C" bool M2GenGCC_PrepareCopyString (unsigned int tokenno, tree *length, tree *srcTree, unsigned int src, unsigned int destStrType);

/*
   ErrorMessageDecl - emit an error message together with declaration fragments of left
                      and right if they are parameters or variables.
*/

static void ErrorMessageDecl (unsigned int tok, const char *message_, unsigned int _message_high, unsigned int left, unsigned int right, bool iserror);

/*
   IsExportedGcc - returns TRUE if this symbol should be (as far as the middle/backend of GCC)
                   is concerned, exported.
*/

static bool IsExportedGcc (unsigned int sym);

/*
   IsCompilingMainModule -
*/

static bool IsCompilingMainModule (unsigned int sym);

/*
   CodeLastForIterator - call PerformLastForIterator allowing for
                         a non constant last iterator value.
*/

static void CodeLastForIterator (unsigned int quad);

/*
   FoldLastForIterator - call PerformLastForIterator providing
                         all operands are constant and are known by GCC.
*/

static void FoldLastForIterator (unsigned int quad, M2GCCDeclare_WalkAction p);
static void PerformLastForIterator (unsigned int quad, M2GCCDeclare_WalkAction p, bool constant);

/*
   CodeStatement - A multi-way decision call depending on the current
                   quadruple.
*/

static void CodeStatement (unsigned int q);

/*
   FindSize - given a Modula-2 symbol sym return a gcc tree
              constant representing the storage size in bytes.
*/

static tree FindSize (unsigned int tokenno, unsigned int sym);

/*
   FindType - returns the type of, Sym, if Sym is a TYPE then return Sym otherwise return GetType(Sym)
*/

static unsigned int FindType (unsigned int Sym);

/*
   BuildTreeFromInterface - generates a GCC tree from an interface definition.
*/

static tree BuildTreeFromInterface (unsigned int sym);

/*
   BuildTrashTreeFromInterface - generates a GCC string tree from an interface definition.
*/

static tree BuildTrashTreeFromInterface (unsigned int sym);

/*
   CodeInline - InlineOp is a quadruple which has the following format:

                InlineOp   NulSym  NulSym  Sym
*/

static void CodeInline (unsigned int quad);

/*
   FoldStatementNote - set CurrentQuadToken to tokennno.
*/

static void FoldStatementNote (unsigned int tokenno);

/*
   CodeStatementNote - set CurrentQuadToken to tokennno and
                       add a statement note.
*/

static void CodeStatementNote (unsigned int tokenno);

/*
   FoldRange - attempts to fold the range test.
               --fixme-- complete this.
*/

static void FoldRange (unsigned int tokenno, unsigned int quad, unsigned int rangeno);

/*
   CodeSaveException - op1 := op3(TRUE)
*/

static void CodeSaveException (unsigned int des, unsigned int exceptionProcedure);

/*
   CodeRestoreException - op1 := op3(op1).
*/

static void CodeRestoreException (unsigned int des, unsigned int exceptionProcedure);

/*
   PushScope -
*/

static void PushScope (unsigned int sym);

/*
   PopScope -
*/

static void PopScope (void);

/*
   GetCurrentScopeDescription - returns a description of the current scope.
*/

static DynamicStrings_String GetCurrentScopeDescription (void);

/*
   CodeRange - encode the range test associated with op3.
*/

static void CodeRange (unsigned int rangeId);

/*
   CodeError - encode the error test associated with op3.
*/

static void CodeError (unsigned int errorId);

/*
   CodeModuleScope - ModuleScopeOp is a quadruple which has the following
                     format:

                     ModuleScopeOp  _  _  moduleSym

                     Its purpose is to reset the source file to another
                     file, hence all line numbers emitted with the
                     generated code will be relative to this source file.
*/

static void CodeModuleScope (unsigned int moduleSym);

/*
   CodeStartModFile - StartModFileOp is a quadruple which has the following
                      format:

                      StartModFileOp  _  _  moduleSym

                      A new source file has been encountered therefore
                      set LastLine to 1.
                      Call pushGlobalScope.
*/

static void CodeStartModFile (unsigned int moduleSym);

/*
   CodeStartDefFile - StartDefFileOp is a quadruple with the following
                      format:

                      StartDefFileOp  _  _  moduleSym

                      A new source file has been encountered therefore
                      set LastLine to 1.
                      Call pushGlobalScope.
*/

static void CodeStartDefFile (unsigned int moduleSym);

/*
   CodeEndFile - pops the GlobalScope.
*/

static void CodeEndFile (void);

/*
   CallInnerInit - produce a call to inner module initialization routine.
*/

static void CallInnerInit (unsigned int moduleSym);

/*
   CallInnerFinally - produce a call to inner module finalization routine.
*/

static void CallInnerFinally (unsigned int moduleSym);

/*
   CodeInitStart - emits starting code before the main BEGIN END of the
                   current module.
*/

static void CodeInitStart (unsigned int moduleSym, bool CompilingMainModule);

/*
   CodeInitEnd - emits terminating code after the main BEGIN END of the
                 current module.
*/

static void CodeInitEnd (unsigned int moduleSym, bool CompilingMainModule);

/*
   CodeFinallyStart - emits starting code before the main BEGIN END of the
                      current module.
*/

static void CodeFinallyStart (unsigned int moduleSym, bool CompilingMainModule);

/*
   CodeFinallyEnd - emits terminating code after the main BEGIN END of the
                    current module.  It also creates the scaffold if the
                    cflag was not present.
*/

static void CodeFinallyEnd (unsigned int moduleSym, bool CompilingMainModule);

/*
   GetAddressOfUnbounded - returns the address of the unbounded array contents.
*/

static tree GetAddressOfUnbounded (location_t location, unsigned int param);

/*
   GetSizeOfHighFromUnbounded - returns a Tree containing the value of
                                param.HIGH * sizeof(unboundedType).
                                The number of legal bytes this array
                                occupies.
*/

static tree GetSizeOfHighFromUnbounded (unsigned int tokenno, unsigned int param);

/*
   MaybeDebugBuiltinAlloca - if DebugBuiltins is set
                             then call Builtins.alloca_trace
                             else call Builtins.alloca.
*/

static tree MaybeDebugBuiltinAlloca (location_t location, unsigned int tok, tree high);

/*
   MaybeDebugBuiltinMemcpy - if DebugBuiltins is set
                             then call memcpy
                             else call Builtins.memcpy.
*/

static tree MaybeDebugBuiltinMemcpy (location_t location, tree src, tree dest, tree nbytes);

/*
   MakeCopyUse - make a copy of the unbounded array and alter all references
                 from the old unbounded array to the new unbounded array.
                 The parameter, param, contains a RECORD
                                                     ArrayAddress: ADDRESS ;
                                                     ArrayHigh   : CARDINAL ;
                                                  END
                 we simply declare a new array of size, ArrayHigh
                 and set ArrayAddress to the address of the copy.

                 Remember ArrayHigh == sizeof(Array)-sizeof(typeof(array))
                          so we add 1 for the size and add 1 for a possible <nul>
*/

static void MakeCopyUse (unsigned int tokenno, unsigned int param);

/*
   GetParamAddress - returns the address of parameter, param.
*/

static tree GetParamAddress (location_t location, unsigned int proc, unsigned int param);

/*
   IsUnboundedWrittenTo - returns TRUE if the unbounded parameter
                          might be written to, or if -funbounded-by-reference
                          was _not_ specified.
*/

static bool IsUnboundedWrittenTo (unsigned int proc, unsigned int param);

/*
   GetParamSize - returns the size in bytes of, param.
*/

static tree GetParamSize (unsigned int tokenno, unsigned int param);

/*
   DoIsIntersection - jumps to, tLabel, if the ranges i1..i2  j1..j2 overlap
                      else jump to, fLabel.
*/

static void DoIsIntersection (unsigned int tokenno, tree ta, tree tb, tree tc, tree td, DynamicStrings_String tLabel, DynamicStrings_String fLabel);

/*
   BuildCascadedIfThenElsif - mustCheck contains a list of variables which
                              must be checked against the address of (proc, param, i).
                              If the address matches we make a copy of the unbounded
                              parameter (proc, param) and quit further checking.
*/

static void BuildCascadedIfThenElsif (unsigned int tokenno, Lists_List mustCheck, unsigned int proc, unsigned int param);

/*
   CheckUnboundedNonVarParameter - if non var unbounded parameter is written to
                                   then
                                      make a copy of the contents of this parameter
                                      and use the copy
                                   else if param
                                      is type compatible with any parameter, symv
                                      and at runtime its address matches symv
                                   then
                                      make a copy of the contents of this parameter
                                      and use the copy
                                   fi
*/

static void CheckUnboundedNonVarParameter (unsigned int tokenno, Lists_List trashed, unsigned int proc, unsigned int param);

/*
   IsParameterWritten - returns TRUE if a parameter, sym, is written to.
*/

static bool IsParameterWritten (unsigned int proc, unsigned int sym);

/*
   SaveNonVarUnboundedParameters - for each var parameter, symv, do
                                       not just unbounded var parameters, but _all_
                                         parameters 
                                      if symv is written to
                                      then
                                         add symv to a compile list
                                      fi
                                   done

                                   for each parameter of procedure, symu, do
                                      if non var unbounded parameter is written to
                                      then
                                         make a copy of the contents of this parameter
                                         and use the copy
                                      else if
                                         symu is type compatible with any parameter, symv
                                         and at runtime its address matches symv
                                      then
                                         make a copy of the contents of this parameter
                                         and use the copy
                                      fi
                                   done
*/

static void SaveNonVarUnboundedParameters (unsigned int tokenno, unsigned int proc);

/*
   AutoInitVariable -
*/

static void AutoInitVariable (location_t location, unsigned int sym);

/*
   AutoInitialize - scope will be a procedure, module or defimp.  All pointer
                    variables are assigned to NIL.
*/

static void AutoInitialize (location_t location, unsigned int scope);

/*
   CodeNewLocalVar - Builds a new frame on the stack to contain the procedure
                     local variables.
*/

static void CodeNewLocalVar (unsigned int tokenno, unsigned int CurrentProcedure);

/*
   CodeKillLocalVar - removes local variables and returns to previous scope.
*/

static void CodeKillLocalVar (unsigned int CurrentProcedure);

/*
   CodeProcedureScope - start a procedure scope for CurrentProcedure.
*/

static void CodeProcedureScope (unsigned int CurrentProcedure);

/*
   CodeReturnValue - places the operand into the return value space
                     allocated by the function call.
*/

static void CodeReturnValue (unsigned int quad);

/*
   CodeCall - determines whether the procedure call is a direct call
              or an indirect procedure call.
*/

static void CodeCall (unsigned int tokenno, unsigned int procedure);

/*
   UseBuiltin - returns a Tree containing the builtin function
                and parameters. It should only be called if
                CanUseBuiltin or IsProcedureBuiltinAvailable returns TRUE.
*/

static tree UseBuiltin (unsigned int tokenno, unsigned int Sym);

/*
   CodeDirectCall - calls a function/procedure.
*/

static tree CodeDirectCall (unsigned int tokenno, unsigned int procedure);

/*
   CodeIndirectCall - calls a function/procedure indirectly.
*/

static tree CodeIndirectCall (unsigned int tokenno, unsigned int ProcVar);

/*
   ConvertTo - convert gcc tree, t, (which currently represents Modula-2 op3) into
               a symbol of, type.
*/

static tree ConvertTo (tree t, unsigned int type, unsigned int op3);

/*
   ConvertRHS - convert (t, rhs) into, type.  (t, rhs) refer to the
                same entity t is a GCC Tree and, rhs, is a Modula-2
                symbol.  It checks for char and strings
                first and then the remaining types.
*/

static tree ConvertRHS (tree t, unsigned int type, unsigned int rhs);

/*
   IsCoerceableParameter - returns TRUE if symbol, sym, is a
                           coerceable parameter.
*/

static bool IsCoerceableParameter (unsigned int sym);

/*
   IsConstProcedure - returns TRUE if, p, is a const procedure.
*/

static bool IsConstProcedure (unsigned int p);

/*
   IsConstant - returns TRUE if symbol, p, is either a const or procedure.
*/

static bool IsConstant (unsigned int p);

/*
   CheckConvertCoerceParameter - ensure that actual parameter is the same as the nth of callee.
*/

static tree CheckConvertCoerceParameter (unsigned int tokenno, unsigned int nth, unsigned int callee, unsigned int actual);

/*
   CheckConstant - checks to see whether we should declare the constant.
*/

static tree CheckConstant (unsigned int tokenno, unsigned int des, unsigned int expr);

/*
   CodeMakeAdr - code the function MAKEADR.
*/

static void CodeMakeAdr (unsigned int q, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeBuiltinFunction - attempts to inline a function. Currently it only
                         inlines the SYSTEM function MAKEADR.
*/

static void CodeBuiltinFunction (unsigned int q, unsigned int nth, unsigned int func, unsigned int parameter);

/*
   FoldMakeAdr - attempts to fold the function MAKEADR.
*/

static void FoldMakeAdr (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int q, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   doParam - builds the parameter, op3, which is to be passed to
             procedure, op2.  The number of the parameter is op1.
*/

static void doParam (unsigned int quad, unsigned int paramtok, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   FoldBuiltin - attempts to fold the gcc builtin function.
*/

static void FoldBuiltin (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int q);

/*
   FoldBuiltinFunction - attempts to inline a function. Currently it only
                         inlines the SYSTEM function MAKEADR.
*/

static void FoldBuiltinFunction (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int q, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeParam - builds a parameter list.
               Note that we can ignore ModeOfAddr as any lvalue will
               have been created in a preceeding quadruple.
*/

static void CodeParam (unsigned int quad);

/*
   Replace - replace the entry for sym in the double entry bookkeeping with sym/tree.
*/

static void Replace (unsigned int sym, tree gcc);

/*
   CodeFunctValue - retrieves the function return value and assigns it
                    into a variable.
*/

static void CodeFunctValue (location_t location, unsigned int op1);

/*
   FoldStringLength -
*/

static void FoldStringLength (unsigned int quad, M2GCCDeclare_WalkAction p);

/*
   FoldStringConvertM2nul - attempt to assign the des with the string contents from expr.
                            It also marks the des as a m2 string which must be nul terminated.
                            The front end uses double book keeping and it is easier to have
                            different m2 string symbols each of which map onto a slightly different
                            gcc string tree.
*/

static void FoldStringConvertM2nul (unsigned int quad, M2GCCDeclare_WalkAction p);

/*
   FoldStringConvertCnul -attempt to assign the des with the string contents from expr.
                          It also marks the des as a C string which must be nul terminated.
*/

static void FoldStringConvertCnul (unsigned int quad, M2GCCDeclare_WalkAction p);
static void CodeAddr (unsigned int tokenno, unsigned int quad, unsigned int op1, unsigned int op3);
static void stop (void);
static void CheckStop (unsigned int q);
static void FoldBecomes (M2GCCDeclare_WalkAction p, M2BasicBlock_BasicBlock bb, unsigned int quad);

/*
   TryDeclareConst -
*/

static void TryDeclareConst (unsigned int tokenno, unsigned int sym);

/*
   RemoveQuad - remove quad and ensure p (des) is called.
*/

static void RemoveQuad (M2GCCDeclare_WalkAction p, unsigned int des, unsigned int quad);

/*
   DeclaredOperandsBecomes -
*/

static bool DeclaredOperandsBecomes (M2GCCDeclare_WalkAction p, unsigned int quad);

/*
   TypeCheckBecomes - returns TRUE if the type check succeeds.
*/

static bool TypeCheckBecomes (M2GCCDeclare_WalkAction p, unsigned int quad);

/*
   PerformFoldBecomes - attempts to fold quad.  It propagates constant strings
                        and attempts to declare des providing it is a constant
                        and expr is resolved.
*/

static void PerformFoldBecomes (M2GCCDeclare_WalkAction p, unsigned int quad);

/*
   CodeTry - starts building a GCC 'try' node.
*/

static void CodeTry (void);

/*
   CodeThrow - builds a GCC 'throw' node.
*/

static void CodeThrow (unsigned int value);
static void CodeRetry (unsigned int destQuad);
static void CodeCatchBegin (void);
static void CodeCatchEnd (void);

/*
   DescribeTypeError -
*/

static void DescribeTypeError (unsigned int token, unsigned int op1, unsigned int op2);

/*
   DefaultConvertGM2 - provides a simple mapping between
                       front end data types and GCC equivalents.
                       This is only used to aid assignment of
                       typed constants.
*/

static tree DefaultConvertGM2 (unsigned int sym);

/*
   FoldConstBecomes - returns a Tree containing op3.
                      The tree will have been folded and
                      type converted if necessary.
*/

static tree FoldConstBecomes (unsigned int tokenno, unsigned int op1, unsigned int op3);

/*
   checkArrayElements - return TRUE if des or expr are not arrays.
                        If they are arrays and have different number of
                        elements return FALSE, otherwise TRUE.
*/

static bool checkArrayElements (unsigned int des, unsigned int expr, unsigned int virtpos, unsigned int despos, unsigned int exprpos);

/*
   CodeInitAddress -
*/

static void CodeInitAddress (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   checkRecordTypes - returns TRUE if des is not a record or if the record
                      is the same type as expr.
*/

static bool checkRecordTypes (unsigned int des, unsigned int expr, unsigned int virtpos);

/*
   checkIncorrectMeta - checks to see if des and expr are assignment compatible is allows
                        generic system types to be assigned.
*/

static bool checkIncorrectMeta (unsigned int des, unsigned int expr, unsigned int virtpos);

/*
   checkBecomes - returns TRUE if the checks pass.
*/

static bool checkBecomes (unsigned int des, unsigned int expr, unsigned int virtpos, unsigned int despos, unsigned int exprpos);

/*
   checkDeclare - checks to see if sym is declared and if it is not then declare it.
*/

static void checkDeclare (unsigned int sym);

/*
   PerformCodeBecomes -
*/

static void PerformCodeBecomes (location_t location, unsigned int virtpos, unsigned int des, unsigned int expr);
static void CodeBecomes (unsigned int quad);

/*
   LValueToGenericPtrOrConvert - if sym is an lvalue then convert to pointer type
                                 else convert to type, type. Return the converted tree.
*/

static tree LValueToGenericPtrOrConvert (unsigned int sym, tree type);

/*
   FoldBinary - check whether we can fold the binop operation.
*/

static void FoldBinary (unsigned int tokenno, M2GCCDeclare_WalkAction p, m2expr_BuildBinProcedure binop, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   ConvertBinaryOperands -
*/

static void ConvertBinaryOperands (location_t location, tree *tl, tree *tr, unsigned int type, unsigned int op2, unsigned int op3);

/*
   CodeBinaryCheck - encode a binary arithmetic operation.
*/

static void CodeBinaryCheck (m2expr_BuildBinCheckProcedure binop, unsigned int quad);

/*
   MixTypesBinary - depending upon overflowCheck do not check pointer arithmetic.
*/

static unsigned int MixTypesBinary (unsigned int left, unsigned int right, unsigned int tokpos, bool overflowCheck);

/*
   CodeBinary - encode a binary arithmetic operation.
*/

static void CodeBinary (m2expr_BuildBinProcedure binop, unsigned int quad);

/*
   NoWalkProcedure -
*/

static void NoWalkProcedure (unsigned int param __attribute__((unused)));

/*
   CheckBinaryExpressionTypes - returns TRUE if all expression checks pass.
                                If the expression check fails quad is removed,
                                the walk procedure (des) is called and NoChange is
                                set to FALSE.
*/

static bool CheckBinaryExpressionTypes (unsigned int quad, M2GCCDeclare_WalkAction p);

/*
   CheckElementSetTypes - returns TRUE if all expression checks pass.
                          If the expression check fails quad is removed,
                          the walk procedure (des) is called and NoChange is
                          set to FALSE.
*/

static bool CheckElementSetTypes (unsigned int quad);

/*
   CodeBinarySet - encode a binary set arithmetic operation.
                   Set operands may be longer than a word.
*/

static void CodeBinarySet (m2expr_BuildBinProcedure binop, M2GenGCC_DoProcedure doOp, unsigned int quad);

/*
   CheckUnaryOperand - checks to see whether operand is using a generic type.
*/

static bool CheckUnaryOperand (unsigned int quad, unsigned int operand);

/*
   UnaryOperand - returns TRUE if operand is acceptable for
                  unary operator: + -.  If FALSE
                  is returned, an error message will be generated
                  and the quad is deleted.
*/

static bool UnaryOperand (unsigned int quad, unsigned int operand);

/*
   CheckBinaryOperand - checks to see whether operand is using a generic type.
*/

static bool CheckBinaryOperand (unsigned int quad, bool isleft, unsigned int operand, bool result);

/*
   BinaryOperands - returns TRUE if, l, and, r, are acceptable for
                    binary operator: + - / * and friends.  If FALSE
                    is returned, an error message will be generated
                    and the, quad, is deleted.
*/

static bool BinaryOperands (unsigned int quad, unsigned int l, unsigned int r);

/*
   IsConstStr - returns TRUE if sym is a constant string or a char constant.
*/

static bool IsConstStr (unsigned int sym);

/*
   IsConstStrKnown - returns TRUE if sym is a constant string or a char constant
                     which is known.
*/

static bool IsConstStrKnown (unsigned int sym);

/*
   GetStr - return a string containing a constant string value associated with sym.
            A nul char constant will return an empty string.
*/

static DynamicStrings_String GetStr (unsigned int tokenno, unsigned int sym);

/*
   FoldAdd - check addition for constant folding.  It checks for conststrings
             overloading the +.
*/

static void FoldAdd (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   FoldArithAdd - check arithmetic addition for constant folding.
*/

static void FoldArithAdd (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeAddChecked - code an addition instruction, determine whether checking
                    is required.
*/

static void CodeAddChecked (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeAddCheck - encode addition but check for overflow.
*/

static void CodeAddCheck (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeAdd - encode addition.
*/

static void CodeAdd (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldSub - check subtraction for constant folding.
*/

static void FoldSub (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeSubChecked - code a subtract instruction, determine whether checking
                    is required.
*/

static void CodeSubChecked (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeSubCheck - encode subtraction but check for overflow.
*/

static void CodeSubCheck (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeSub - encode subtraction.
*/

static void CodeSub (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldMult - check multiplication for constant folding.
*/

static void FoldMult (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeMultChecked - code a multiplication instruction, determine whether checking
                     is required.
*/

static void CodeMultChecked (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeMultCheck - encode multiplication but check for overflow.
*/

static void CodeMultCheck (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeMult - encode multiplication.
*/

static void CodeMult (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeDivM2Checked - code a divide instruction, determine whether checking
                      is required.
*/

static void CodeDivM2Checked (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeDivM2Check - encode addition but check for overflow.
*/

static void CodeDivM2Check (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeModM2Checked - code a modulus instruction, determine whether checking
                      is required.
*/

static void CodeModM2Checked (unsigned int quad, unsigned int left, unsigned int right);

/*
   CodeModM2Check - encode addition but check for overflow.
*/

static void CodeModM2Check (unsigned int quad, unsigned int left, unsigned int right);

/*
   BinaryOperandRealFamily -
*/

static bool BinaryOperandRealFamily (unsigned int op);

/*
   FoldDivM2 - check division for constant folding.
*/

static void FoldDivM2 (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeDivM2 - encode division.
*/

static void CodeDivM2 (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldModM2 - check modulus for constant folding.
*/

static void FoldModM2 (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeModM2 - encode modulus.
*/

static void CodeModM2 (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldDivTrunc - check division for constant folding.
*/

static void FoldDivTrunc (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeDivTrunc - encode multiplication.
*/

static void CodeDivTrunc (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldModTrunc - check modulus for constant folding.
*/

static void FoldModTrunc (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeModTrunc - encode modulus.
*/

static void CodeModTrunc (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldDivCeil - check division for constant folding.
*/

static void FoldDivCeil (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeDivCeil - encode multiplication.
*/

static void CodeDivCeil (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldModCeil - check modulus for constant folding.
*/

static void FoldModCeil (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeModCeil - encode multiplication.
*/

static void CodeModCeil (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldDivFloor - check division for constant folding.
*/

static void FoldDivFloor (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeDivFloor - encode multiplication.
*/

static void CodeDivFloor (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldModFloor - check modulus for constant folding.
*/

static void FoldModFloor (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeModFloor - encode modulus.
*/

static void CodeModFloor (unsigned int quad, unsigned int left, unsigned int right);

/*
   FoldBuiltinConst -
*/

static void FoldBuiltinConst (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int constDesc);

/*
   FoldBuiltinTypeInfo - attempts to fold a builtin attribute value on type op2.
*/

static void FoldBuiltinTypeInfo (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   FoldTBitsize - attempt to fold the standard function SYSTEM.TBITSIZE
                  quadruple.  If the quadruple is folded it is removed.
*/

static void FoldTBitsize (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int res, unsigned int type);

/*
   FoldStandardFunction - attempts to fold a standard function.
*/

static void FoldStandardFunction (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeStandardFunction -
*/

static void CodeStandardFunction (unsigned int quad, unsigned int result, unsigned int function, unsigned int param);

/*
   CodeSavePriority - checks to see whether op2 is reachable and is directly accessible
                      externally. If so then it saves the current interrupt priority
                      in op1 and sets the current priority to that determined by
                      appropriate module.

                      op1 := op3(GetModuleScope(op2))
*/

static void CodeSavePriority (unsigned int oldValue, unsigned int scopeSym, unsigned int procedureSym);

/*
   CodeRestorePriority - checks to see whether op2 is reachable and is directly accessible
                         externally. If so then it restores the previous interrupt priority
                         held in op1.

                         op1 := op3(op1)
*/

static void CodeRestorePriority (unsigned int oldValue, unsigned int scopeSym, unsigned int procedureSym);

/*
   FoldBinarySet - attempts to fold set arithmetic it removes the quad if successful.
*/

static void FoldBinarySet (unsigned int tokenno, M2GCCDeclare_WalkAction p, M2GenGCC_DoProcedure op, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   FoldSetOr - check whether we can fold a set arithmetic or.
*/

static void FoldSetOr (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeSetOr - encode set arithmetic or.
*/

static void CodeSetOr (unsigned int quad);

/*
   FoldSetAnd - check whether we can fold a logical and.
*/

static void FoldSetAnd (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeSetAnd - encode set arithmetic and.
*/

static void CodeSetAnd (unsigned int quad);

/*
   CodeBinarySetShift - encode a binary set arithmetic operation.
                        The set maybe larger than a machine word
                        and the value of one word may effect the
                        values of another - ie shift and rotate.
                        Set sizes of a word or less are evaluated
                        with binop, whereas multiword sets are
                        evaluated by M2RTS.
*/

static void CodeBinarySetShift (m2expr_BuildSetProcedure binop, M2GenGCC_DoProcedure doOp, NameKey_Name var, NameKey_Name left, NameKey_Name right, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   FoldSetShift - check whether we can fold a logical shift.
*/

static void FoldSetShift (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeSetShift - encode set arithmetic shift.
*/

static void CodeSetShift (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   FoldSetRotate - check whether we can fold a logical rotate.
*/

static void FoldSetRotate (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeSetRotate - encode set arithmetic rotate.
*/

static void CodeSetRotate (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeSetLogicalDifference - encode set arithmetic logical difference.
*/

static void CodeSetLogicalDifference (unsigned int quad);

/*
   FoldSymmetricDifference - check whether we can fold a logical difference.
*/

static void FoldSymmetricDifference (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeSetSymmetricDifference - code set difference.
*/

static void CodeSetSymmetricDifference (unsigned int quad);

/*
   CodeUnarySet - encode a unary set arithmetic operation.
                  Set operands may be longer than a word.
*/

static void CodeUnarySet (m2expr_BuildUnarySetFunction unop, M2GenGCC_DoUnaryProcedure constop, unsigned int quad, unsigned int result, unsigned int expr);

/*
   FoldIncl - check whether we can fold the InclOp.
              result := result + (1 << expr)
*/

static void FoldIncl (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int expr);

/*
   FoldIfLess - check to see if it is possible to evaluate
                if op1 < op2 then goto op3.
*/

static void FoldIfLess (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad);

/*
   FoldIfGre - check to see if it is possible to evaluate
               if op1 > op2 then goto op3.
*/

static void FoldIfGre (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad);

/*
   FoldIfLessEqu - check to see if it is possible to evaluate
                   if op1 <= op2 then goto op3.
*/

static void FoldIfLessEqu (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad);

/*
   FoldIfGreEqu - check to see if it is possible to evaluate
                  if op1 >= op2 then goto op3.
*/

static void FoldIfGreEqu (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad);

/*
   FoldIfIn - check whether we can fold the IfInOp
              if op1 in op2 then goto op3
*/

static void FoldIfIn (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad);

/*
   FoldIfNotIn - check whether we can fold the IfNotInOp
                 if not (op1 in op2) then goto op3
*/

static void FoldIfNotIn (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad);

/*
   FoldIfEqu - check to see if it is possible to evaluate
               if op1 = op2 then goto op3.
*/

static void FoldIfEqu (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad);

/*
   FoldIfNotEqu - check to see if it is possible to evaluate
                  if op1 # op2 then goto op3.
*/

static void FoldIfNotEqu (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad);

/*
   GetSetLimits - assigns low and high to the limits of the declared, set.
*/

static void GetSetLimits (unsigned int set, unsigned int *low, unsigned int *high);

/*
   GetFieldNo - returns the field number in the, set, which contains, element.
*/

static int GetFieldNo (unsigned int tokenno, unsigned int element, unsigned int set, tree *offset);

/*
   CodeIncl - encode an InclOp:
              result := result + (1 << expr)
*/

static void CodeIncl (unsigned int result, unsigned int expr);

/*
   FoldExcl - check whether we can fold the InclOp.
              op1 := op1 - (1 << op3)
*/

static void FoldExcl (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int expr);

/*
   CodeExcl - encode an ExclOp:
              result := result - (1 << expr)
*/

static void CodeExcl (unsigned int result, unsigned int expr);

/*
   FoldUnary - check whether we can fold the unop operation.
*/

static void FoldUnary (unsigned int tokenno, M2GCCDeclare_WalkAction p, m2expr_BuildUnaryProcedure unop, tree ZConstToTypedConst, unsigned int quad, unsigned int result, unsigned int expr);

/*
   FoldUnarySet - check whether we can fold the doOp operation.
*/

static void FoldUnarySet (unsigned int tokenno, M2GCCDeclare_WalkAction p, M2GenGCC_DoUnaryProcedure doOp, unsigned int quad, unsigned int result, unsigned int expr);

/*
   CodeUnaryCheck - encode a unary arithmetic operation.
*/

static void CodeUnaryCheck (m2expr_BuildUnaryCheckProcedure unop, tree ZConstToTypedConst, unsigned int quad, unsigned int result, unsigned int expr);

/*
   CodeUnary - encode a unary arithmetic operation.
*/

static void CodeUnary (m2expr_BuildUnaryProcedure unop, tree ZConstToTypedConst, unsigned int quad, unsigned int result, unsigned int expr);

/*
   FoldNegate - check unary negate for constant folding.
*/

static void FoldNegate (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int expr);

/*
   CodeNegateChecked - code a negate instruction, determine whether checking
                       is required.
*/

static void CodeNegateChecked (unsigned int quad, unsigned int op1, unsigned int op3);

/*
   FoldSize - check unary SIZE for constant folding.
*/

static void FoldSize (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeSize - encode the inbuilt SIZE function.
*/

static void CodeSize (unsigned int result, unsigned int sym);

/*
   FoldRecordField - check whether we can fold an RecordFieldOp quadruple.
                     Very similar to FoldBinary, except that we need to
                     hard code a few parameters to the gcc backend.
*/

static void FoldRecordField (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int record, unsigned int field);

/*
   CodeRecordField - encode a reference to a field within a record.
*/

static void CodeRecordField (unsigned int result, unsigned int record, unsigned int field);

/*
   BuildHighFromChar -
*/

static tree BuildHighFromChar (unsigned int operand);

/*
   SkipToArray -
*/

static unsigned int SkipToArray (unsigned int operand, unsigned int dim);

/*
   BuildHighFromArray -
*/

static tree BuildHighFromArray (unsigned int tokenno, unsigned int dim, unsigned int operand);

/*
   BuildHighFromStaticArray -
*/

static tree BuildHighFromStaticArray (location_t location, unsigned int Type);

/*
   BuildHighFromString -
*/

static tree BuildHighFromString (unsigned int operand);

/*
   ResolveHigh - given an Modula-2 operand, it resolves the HIGH(operand)
                 and returns a GCC constant symbol containing the value of
                 HIGH(operand).
*/

static tree ResolveHigh (unsigned int tokenno, unsigned int dim, unsigned int operand);

/*
   FoldHigh - if the array is not dynamic then we should be able to
              remove the HighOp quadruple and assign op1 with
              the known compile time HIGH(op3).
*/

static void FoldHigh (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int dim, unsigned int op3);

/*
   CodeHigh - encode a unary arithmetic operation.
*/

static void CodeHigh (unsigned int result, unsigned int dim, unsigned int array);

/*
   CodeUnbounded - codes the creation of an unbounded parameter variable.
                   places the address of op3 into *op1
*/

static void CodeUnbounded (unsigned int result, unsigned int array);

/*
   AreSubrangesKnown - returns TRUE if the subranges values used within, array, are known.
*/

static bool AreSubrangesKnown (unsigned int array);

/*
   CodeArray - res is an lvalue which will point to the array element.
*/

static void CodeArray (unsigned int res, unsigned int index, unsigned int array);

/*
   FoldElementSizeForArray - attempts to calculate the Subscript
                             multiplier for the index op3.
*/

static void FoldElementSizeForArray (unsigned int tokenno, unsigned int quad, M2GCCDeclare_WalkAction p, unsigned int result, unsigned int type);

/*
   FoldElementSizeForUnbounded - Unbounded arrays only have one index,
                                 therefore element size will be the
                                 TSIZE(Type) where Type is defined as:
                                 ARRAY OF Type.
*/

static void FoldElementSizeForUnbounded (unsigned int tokenno, unsigned int quad, M2GCCDeclare_WalkAction p, unsigned int result, unsigned int ArrayType);

/*
   FoldElementSize - folds the element size for an ArraySym or UnboundedSym.
                     ElementSize returns a constant which defines the
                     multiplier to be multiplied by this element index.
*/

static void FoldElementSize (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int type);

/*
   PopKindTree - returns a Tree from M2ALU of the type implied by, op.
*/

static tree PopKindTree (unsigned int op, unsigned int tokenno);

/*
   FoldConvert - attempts to fold expr to type into result
                 providing that result and expr are constants.
                 If required convert will alter the machine representation
                 of expr to comply with type.
*/

static void FoldConvert (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int type, unsigned int expr);

/*
   CodeConvert - Converts, rhs, to, type, placing the result into lhs.
                 Convert will, if need be, alter the machine representation
                 of op3 to comply with TYPE op2.
*/

static void CodeConvert (unsigned int quad, unsigned int lhs, unsigned int type, unsigned int rhs);

/*
   CodeCoerce - Coerce op3 to type op2 placing the result into
                op1.
                Coerce will NOT alter the machine representation
                of op3 to comply with TYPE op2.
                Therefore it _insists_ that under all circumstances that the
                type sizes of op1 and op3 are the same.
                CONVERT will perform machine manipulation to change variable
                types, coerce does no such thing.
*/

static void CodeCoerce (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   FoldCoerce -
*/

static void FoldCoerce (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CanConvert - returns TRUE if we can convert variable, var, to a, type.
*/

static bool CanConvert (unsigned int type, unsigned int var);

/*
   CodeCast - Cast op3 to type op2 placing the result into op1.
              Cast will NOT alter the machine representation
              of op3 to comply with TYPE op2 as long as SIZE(op3)=SIZE(op2).
              If the sizes differ then Convert is called.
*/

static void CodeCast (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);
static void FoldCast (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CreateLabelProcedureN - creates a label using procedure name and
                           an integer.
*/

static DynamicStrings_String CreateLabelProcedureN (unsigned int proc, const char *leader_, unsigned int _leader_high, unsigned int unboundedCount, unsigned int n);

/*
   CreateLabelName - creates a namekey from quadruple, q.
*/

static DynamicStrings_String CreateLabelName (unsigned int q);

/*
   CodeGoto - creates a jump to a labeled quadruple.
*/

static void CodeGoto (unsigned int destquad);

/*
   CheckReferenced - checks to see whether this quadruple requires a label.
*/

static void CheckReferenced (unsigned int quad, M2Quads_QuadOperator op);

/*
   CodeIfSetLess -
*/

static void CodeIfSetLess (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   PerformCodeIfLess - codes the quadruple if op1 < op2 then goto op3
*/

static void PerformCodeIfLess (unsigned int quad);

/*
   CodeIfLess - codes the quadruple if op1 < op2 then goto op3
*/

static void CodeIfLess (unsigned int quad);

/*
   CodeIfSetGre -
*/

static void CodeIfSetGre (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   PerformCodeIfGre - codes the quadruple if op1 > op2 then goto op3
*/

static void PerformCodeIfGre (unsigned int quad);

/*
   CodeIfGre - codes the quadruple if op1 > op2 then goto op3
*/

static void CodeIfGre (unsigned int quad);

/*
   CodeIfSetLessEqu -
*/

static void CodeIfSetLessEqu (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   PerformCodeIfLessEqu - codes the quadruple if op1 <= op2 then goto op3
*/

static void PerformCodeIfLessEqu (unsigned int quad);

/*
   CodeIfLessEqu - codes the quadruple if op1 <= op2 then goto op3
*/

static void CodeIfLessEqu (unsigned int quad);

/*
   CodeIfSetGreEqu -
*/

static void CodeIfSetGreEqu (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   PerformCodeIfGreEqu - codes the quadruple if op1 >= op2 then goto op3
*/

static void PerformCodeIfGreEqu (unsigned int quad);

/*
   CodeIfGreEqu - codes the quadruple if op1 >= op2 then goto op3
*/

static void CodeIfGreEqu (unsigned int quad);

/*
   CodeIfSetEqu - codes if op1 = op2 then goto op3
                  Note that if op1 and op2 are not both constants
                  since this will have been evaluated in CodeIfEqu.
*/

static void CodeIfSetEqu (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   CodeIfSetNotEqu - codes if op1 # op2 then goto op3
                     Note that if op1 and op2 are not both constants
                     since this will have been evaluated in CodeIfNotEqu.
*/

static void CodeIfSetNotEqu (unsigned int left, unsigned int right, unsigned int destQuad);

/*
   ComparisonMixTypes -
*/

static unsigned int ComparisonMixTypes (unsigned int varleft, unsigned int varright, unsigned int left, unsigned int right, unsigned int tokpos);

/*
   PerformCodeIfEqu -
*/

static void PerformCodeIfEqu (unsigned int quad);

/*
   PerformCodeIfNotEqu -
*/

static void PerformCodeIfNotEqu (unsigned int quad);

/*
   IsValidExpressionRelOp - declare left and right constants (if they are not already declared).
                            Check whether left and right are expression compatible.
*/

static bool IsValidExpressionRelOp (unsigned int quad, bool isin);

/*
   CodeIfEqu - codes the quadruple if op1 = op2 then goto op3
*/

static void CodeIfEqu (unsigned int quad);

/*
   CodeIfNotEqu - codes the quadruple if op1 # op2 then goto op3
*/

static void CodeIfNotEqu (unsigned int quad);

/*
   MixTypes3 - returns a type compatible from, low, high, var.
*/

static unsigned int MixTypes3 (unsigned int low, unsigned int high, unsigned int var, unsigned int tokenno);

/*
   BuildIfVarInConstValue - if var in constsetvalue then goto trueexit
*/

static void BuildIfVarInConstValue (location_t location, unsigned int tokenno, M2ALU_PtrToValue constsetvalue, unsigned int var, unsigned int trueexit);

/*
   BuildIfNotVarInConstValue - if not (var in constsetvalue) then goto trueexit
*/

static void BuildIfNotVarInConstValue (unsigned int quad, M2ALU_PtrToValue constsetvalue, unsigned int var, unsigned int trueexit);

/*
   PerformCodeIfIn - code the quadruple: if op1 in op2 then goto op3
*/

static void PerformCodeIfIn (unsigned int quad);

/*
   PerformCodeIfNotIn - code the quadruple: if not (op1 in op2) then goto op3
*/

static void PerformCodeIfNotIn (unsigned int quad);

/*
   CodeIfIn - code the quadruple: if op1 in op2 then goto op3
*/

static void CodeIfIn (unsigned int quad);

/*
   CodeIfNotIn - code the quadruple: if not (op1 in op2) then goto op3
*/

static void CodeIfNotIn (unsigned int quad);
static void CodeIndrX (unsigned int quad);

/*
   CodeXIndr - operands for XIndrOp are: left type right.
                *left = right.  The second operand is the type of the data being
                indirectly copied.
*/

static void CodeXIndr (unsigned int quad);

/*
   InitBuiltinSyms -
*/

static void InitBuiltinSyms (unsigned int tok);


/*
   ErrorMessageDecl - emit an error message together with declaration fragments of left
                      and right if they are parameters or variables.
*/

static void ErrorMessageDecl (unsigned int tok, const char *message_, unsigned int _message_high, unsigned int left, unsigned int right, bool iserror)
{
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  M2MetaError_MetaErrorT2 (tok, (const char *) message, _message_high, left, right);
  M2MetaError_MetaErrorDecl (left, iserror);
  M2MetaError_MetaErrorDecl (right, iserror);
}


/*
   IsExportedGcc - returns TRUE if this symbol should be (as far as the middle/backend of GCC)
                   is concerned, exported.
*/

static bool IsExportedGcc (unsigned int sym)
{
  unsigned int scope;

  /* Has a procedure been overridden as public?  */
  if ((SymbolTable_IsProcedure (sym)) && (SymbolTable_IsPublic (sym)))
    {
      return true;
    }
  /* Check for whole program.  */
  if (M2Options_WholeProgram)
    {
      scope = SymbolTable_GetScope (sym);
      while (scope != SymbolTable_NulSym)
        {
          if (SymbolTable_IsDefImp (scope))
            {
              return SymbolTable_IsExported (scope, sym);
            }
          else if (SymbolTable_IsModule (scope))
            {
              /* avoid dangling else.  */
              return false;
            }
          scope = SymbolTable_GetScope (scope);
        }
      M2Error_InternalError ((const char *) "expecting scope to eventually reach a module or defimp symbol", 61);
    }
  else
    {
      /* Otherwise it is public if it were exported.  */
      return SymbolTable_IsExported (SymbolTable_GetMainModule (), sym);
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2GenGCC.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsCompilingMainModule -
*/

static bool IsCompilingMainModule (unsigned int sym)
{
  while ((sym != SymbolTable_NulSym) && ((SymbolTable_GetMainModule ()) != sym))
    {
      sym = SymbolTable_GetModuleScope (sym);
    }
  return sym != SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeLastForIterator - call PerformLastForIterator allowing for
                         a non constant last iterator value.
*/

static void CodeLastForIterator (unsigned int quad)
{
  PerformLastForIterator (quad, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) NoWalkProcedure}, false);
}


/*
   FoldLastForIterator - call PerformLastForIterator providing
                         all operands are constant and are known by GCC.
*/

static void FoldLastForIterator (unsigned int quad, M2GCCDeclare_WalkAction p)
{
  M2Quads_QuadOperator op;
  unsigned int e1;
  unsigned int e2;
  unsigned int op1;
  unsigned int tuple;
  unsigned int incr;

  M2Quads_GetQuad (quad, &op, &op1, &tuple, &incr);
  M2Debug_Assert (SymbolTable_IsTuple (tuple));
  e1 = SymbolTable_GetNth (tuple, 1);
  e2 = SymbolTable_GetNth (tuple, 2);
  if (((((((SymbolTable_IsConst (op1)) && (SymbolTable_IsConst (e1))) && (SymbolTable_IsConst (e2))) && (SymbolTable_IsConst (incr))) && (SymbolConversion_GccKnowsAbout (e1))) && (SymbolConversion_GccKnowsAbout (e2))) && (SymbolConversion_GccKnowsAbout (incr)))
    {
      PerformLastForIterator (quad, p, true);
    }
}

static void PerformLastForIterator (unsigned int quad, M2GCCDeclare_WalkAction p, bool constant)
{
  bool success;
  bool constExpr;
  bool overflowChecking;
  M2Quads_QuadOperator op;
  unsigned int lastpos;
  unsigned int op1pos;
  unsigned int op2pos;
  unsigned int incrpos;
  unsigned int last;
  unsigned int tuple;
  unsigned int incr;
  unsigned int e1;
  unsigned int e2;
  tree lasttree;
  tree e1tree;
  tree e2tree;
  tree expr;
  tree incrtree;
  location_t location;

  /* 
   FoldLastForIterator - generates code to calculate the last iterator value
                         in a for loop.  It examines the increment constant
                         and generates different code depending whether it is
                         negative or positive.
  */
  M2Quads_GetQuadOtok (quad, &lastpos, &op, &last, &tuple, &incr, &overflowChecking, &constExpr, &op1pos, &op2pos, &incrpos);
  M2GCCDeclare_DeclareConstant (incrpos, incr);
  lasttree = SymbolConversion_Mod2Gcc (last);
  success = true;
  if (SymbolTable_IsConst (incr))
    {
      /* avoid dangling else.  */
      incrtree = SymbolConversion_Mod2Gcc (incr);
      location = M2LexBuf_TokenToLocation (lastpos);
      e1 = SymbolTable_GetNth (tuple, 1);
      e2 = SymbolTable_GetNth (tuple, 2);
      e1tree = SymbolConversion_Mod2Gcc (e1);
      e2tree = SymbolConversion_Mod2Gcc (e2);
      if ((m2expr_CompareTrees (incrtree, m2expr_GetIntegerZero (location))) == 0)
        {
          M2MetaError_MetaErrorT0 (lastpos, (const char *) "the {%kFOR} loop step value must not be zero", 44);
          M2MetaError_MetaErrorDecl (incr, true);
          NoChange = false;
          M2Quads_SubQuad (quad);
          success = false;
        }
      else if ((m2expr_CompareTrees (incrtree, m2expr_GetIntegerZero (location))) > 0)
        {
          /* avoid dangling else.  */
          /* If incr > 0 then LastIterator := ((e2-e1) DIV incr) * incr + e1.  */
          expr = m2expr_BuildSub (location, e2tree, e1tree, false);
          incrtree = m2convert_BuildConvert (location, m2type_GetTreeType (expr), incrtree, false);
          if (m2expr_TreeOverflow (incrtree))
            {
              M2MetaError_MetaErrorT0 (lastpos, (const char *) "the intemediate calculation for the last iterator value in the {%kFOR} loop has caused an overflow", 98);
              NoChange = false;
              M2Quads_SubQuad (quad);
              success = false;
            }
          else
            {
              expr = m2expr_BuildDivFloor (location, expr, incrtree, false);
              expr = m2expr_BuildMult (location, expr, incrtree, false);
              expr = m2expr_BuildAdd (location, expr, e1tree, false);
            }
        }
      else
        {
          /* avoid dangling else.  */
          /* Else use LastIterator := e1 - ((e1-e2) DIV PositiveBy) * PositiveBy
            to avoid unsigned div signed arithmetic.  */
          expr = m2expr_BuildSub (location, e1tree, e2tree, false);
          incrtree = m2convert_BuildConvert (location, m2type_GetM2ZType (), incrtree, false);
          incrtree = m2expr_BuildNegate (location, incrtree, false);
          incrtree = m2convert_BuildConvert (location, m2type_GetTreeType (expr), incrtree, false);
          if (m2expr_TreeOverflow (incrtree))
            {
              M2MetaError_MetaErrorT0 (lastpos, (const char *) "the intemediate calculation for the last iterator value in the {%kFOR} loop has caused an overflow", 98);
              NoChange = false;
              M2Quads_SubQuad (quad);
              success = false;
            }
          else
            {
              expr = m2expr_BuildSub (location, e1tree, e2tree, false);
              expr = m2expr_BuildDivFloor (location, expr, incrtree, false);
              expr = m2expr_BuildMult (location, expr, incrtree, false);
              expr = m2expr_BuildSub (location, e1tree, expr, false);
            }
        }
      if (success)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (SymbolTable_IsConst (last))
            {
              SymbolConversion_AddModGcc (last, expr);
              (*p.proc) (last);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
          else
            {
              M2Debug_Assert (! constant);
              m2statement_BuildAssignmentStatement (location, lasttree, expr);
            }
        }
    }
  else
    {
      M2MetaError_MetaErrorT1 (lastpos, (const char *) "the value {%1Ead} in the {%kBY} clause of the {%kFOR} loop must be constant", 75, incr);
      M2MetaError_MetaErrorDecl (incr, true);
      NoChange = false;
      M2Quads_SubQuad (quad);
    }
}


/*
   CodeStatement - A multi-way decision call depending on the current
                   quadruple.
*/

static void CodeStatement (unsigned int q)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  location_t location;

  InitBuiltinSyms (M2LexBuf_BuiltinTokenNo);
  M2Quads_GetQuad (q, &op, &op1, &op2, &op3);
  if (op == M2Quads_StatementNoteOp)
    {
      FoldStatementNote (op3);  /* Will change CurrentQuadToken using op3.  */
    }
  else
    {
      CurrentQuadToken = M2Quads_QuadToTokenNo (q);
    }
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  CheckReferenced (q, op);
  if (M2Options_GetDebugTraceQuad ())
    {
      M2Printf_printf0 ((const char *) "building: ", 10);
      M2Quads_DisplayQuad (q);
    }
  switch (op)
    {
      case M2Quads_StartDefFileOp:
        CodeStartDefFile (op3);
        break;

      case M2Quads_StartModFileOp:
        CodeStartModFile (op3);
        break;

      case M2Quads_ModuleScopeOp:
        CodeModuleScope (op3);
        break;

      case M2Quads_EndFileOp:
        CodeEndFile ();
        break;

      case M2Quads_InitStartOp:
        CodeInitStart (op3, IsCompilingMainModule (op3));
        break;

      case M2Quads_InitEndOp:
        CodeInitEnd (op3, IsCompilingMainModule (op3));
        break;

      case M2Quads_FinallyStartOp:
        CodeFinallyStart (op3, IsCompilingMainModule (op3));
        break;

      case M2Quads_FinallyEndOp:
        CodeFinallyEnd (op3, IsCompilingMainModule (op3));
        break;

      case M2Quads_NewLocalVarOp:
        CodeNewLocalVar (op1, op3);
        break;

      case M2Quads_KillLocalVarOp:
        CodeKillLocalVar (op3);
        break;

      case M2Quads_ProcedureScopeOp:
        CodeProcedureScope (op3);
        break;

      case M2Quads_ReturnOp:
        break;

      case M2Quads_ReturnValueOp:
        CodeReturnValue (q);  /* Not used as return is achieved by KillLocalVar.  */
        break;

      case M2Quads_TryOp:
        CodeTry ();
        break;

      case M2Quads_ThrowOp:
        CodeThrow (op3);
        break;

      case M2Quads_CatchBeginOp:
        CodeCatchBegin ();
        break;

      case M2Quads_CatchEndOp:
        CodeCatchEnd ();
        break;

      case M2Quads_RetryOp:
        CodeRetry (op3);
        break;

      case M2Quads_DummyOp:
        break;

      case M2Quads_InitAddressOp:
        CodeInitAddress (q, op1, op2, op3);
        break;

      case M2Quads_BecomesOp:
        CodeBecomes (q);
        break;

      case M2Quads_ArithAddOp:
      case M2Quads_AddOp:
        CodeAddChecked (q, op2, op3);
        break;

      case M2Quads_SubOp:
        CodeSubChecked (q, op2, op3);
        break;

      case M2Quads_MultOp:
        CodeMultChecked (q, op2, op3);
        break;

      case M2Quads_DivM2Op:
        CodeDivM2Checked (q, op2, op3);
        break;

      case M2Quads_ModM2Op:
        CodeModM2Checked (q, op2, op3);
        break;

      case M2Quads_DivTruncOp:
        CodeDivTrunc (q, op2, op3);
        break;

      case M2Quads_ModTruncOp:
        CodeModTrunc (q, op2, op3);
        break;

      case M2Quads_DivCeilOp:
        CodeDivCeil (q, op2, op3);
        break;

      case M2Quads_ModCeilOp:
        CodeModCeil (q, op2, op3);
        break;

      case M2Quads_DivFloorOp:
        CodeDivFloor (q, op2, op3);
        break;

      case M2Quads_ModFloorOp:
        CodeModFloor (q, op2, op3);
        break;

      case M2Quads_GotoOp:
        CodeGoto (op3);
        break;

      case M2Quads_InclOp:
        CodeIncl (op1, op3);
        break;

      case M2Quads_ExclOp:
        CodeExcl (op1, op3);
        break;

      case M2Quads_NegateOp:
        CodeNegateChecked (q, op1, op3);
        break;

      case M2Quads_LastForIteratorOp:
        CodeLastForIterator (q);
        break;

      case M2Quads_LogicalShiftOp:
        CodeSetShift (q, op1, op2, op3);
        break;

      case M2Quads_LogicalRotateOp:
        CodeSetRotate (q, op1, op2, op3);
        break;

      case M2Quads_LogicalOrOp:
        CodeSetOr (q);
        break;

      case M2Quads_LogicalAndOp:
        CodeSetAnd (q);
        break;

      case M2Quads_LogicalXorOp:
        CodeSetSymmetricDifference (q);
        break;

      case M2Quads_LogicalDiffOp:
        CodeSetLogicalDifference (q);
        break;

      case M2Quads_IfLessOp:
        CodeIfLess (q);
        break;

      case M2Quads_IfEquOp:
        CodeIfEqu (q);
        break;

      case M2Quads_IfNotEquOp:
        CodeIfNotEqu (q);
        break;

      case M2Quads_IfGreEquOp:
        CodeIfGreEqu (q);
        break;

      case M2Quads_IfLessEquOp:
        CodeIfLessEqu (q);
        break;

      case M2Quads_IfGreOp:
        CodeIfGre (q);
        break;

      case M2Quads_IfInOp:
        CodeIfIn (q);
        break;

      case M2Quads_IfNotInOp:
        CodeIfNotIn (q);
        break;

      case M2Quads_IndrXOp:
        CodeIndrX (q);
        break;

      case M2Quads_XIndrOp:
        CodeXIndr (q);
        break;

      case M2Quads_CallOp:
        CodeCall (CurrentQuadToken, op3);
        break;

      case M2Quads_ParamOp:
        CodeParam (q);
        break;

      case M2Quads_FunctValueOp:
        CodeFunctValue (location, op1);
        break;

      case M2Quads_AddrOp:
        CodeAddr (CurrentQuadToken, q, op1, op3);
        break;

      case M2Quads_SizeOp:
        CodeSize (op1, op3);
        break;

      case M2Quads_UnboundedOp:
        CodeUnbounded (op1, op3);
        break;

      case M2Quads_RecordFieldOp:
        CodeRecordField (op1, op2, op3);
        break;

      case M2Quads_HighOp:
        CodeHigh (op1, op2, op3);
        break;

      case M2Quads_ArrayOp:
        CodeArray (op1, op2, op3);
        break;

      case M2Quads_ElementSizeOp:
        M2Error_InternalError ((const char *) "ElementSizeOp is expected to have been folded via constant evaluation", 69);
        break;

      case M2Quads_ConvertOp:
        CodeConvert (q, op1, op2, op3);
        break;

      case M2Quads_CoerceOp:
        CodeCoerce (q, op1, op2, op3);
        break;

      case M2Quads_CastOp:
        CodeCast (q, op1, op2, op3);
        break;

      case M2Quads_StandardFunctionOp:
        CodeStandardFunction (q, op1, op2, op3);
        break;

      case M2Quads_SavePriorityOp:
        CodeSavePriority (op1, op2, op3);
        break;

      case M2Quads_RestorePriorityOp:
        CodeRestorePriority (op1, op2, op3);
        break;

      case M2Quads_InlineOp:
        CodeInline (q);
        break;

      case M2Quads_StatementNoteOp:
        CodeStatementNote (op3);
        break;

      case M2Quads_CodeOnOp:
        break;

      case M2Quads_CodeOffOp:
        break;

      case M2Quads_ProfileOnOp:
        break;

      case M2Quads_ProfileOffOp:
        break;

      case M2Quads_OptimizeOnOp:
        break;

      case M2Quads_OptimizeOffOp:
        break;

      case M2Quads_RangeCheckOp:
        CodeRange (op3);  /* The following make no sense with gcc.  */
        break;

      case M2Quads_ErrorOp:
        CodeError (op3);
        break;

      case M2Quads_SaveExceptionOp:
        CodeSaveException (op1, op3);
        break;

      case M2Quads_RestoreExceptionOp:
        CodeRestoreException (op1, op3);
        break;


      default:
        M2Error_WriteFormat1 ((const char *) "quadruple %d not yet implemented", 32, (const unsigned char *) &q, (sizeof (q)-1));
        M2Error_InternalError ((const char *) "quadruple not implemented yet", 29);
        break;
    }
  LastOperator = op;
}


/*
   FindSize - given a Modula-2 symbol sym return a gcc tree
              constant representing the storage size in bytes.
*/

static tree FindSize (unsigned int tokenno, unsigned int sym)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  if (SymbolTable_IsConstString (sym))
    {
      M2Debug_Assert (SymbolTable_IsConstStringKnown (sym));
      M2ALU_PushCard (SymbolTable_GetStringLength (tokenno, sym));
      return M2ALU_PopIntegerTree ();
    }
  else if (SymbolTable_IsSizeSolved (sym))
    {
      /* avoid dangling else.  */
      SymbolTable_PushSize (sym);
      return M2ALU_PopIntegerTree ();
    }
  else
    {
      /* avoid dangling else.  */
      if (SymbolConversion_GccKnowsAbout (sym))
        {
          if ((SymbolTable_IsVar (sym)) && (SymbolTable_IsVariableSSA (sym)))
            {
              sym = SymbolTable_GetType (sym);
            }
          M2ALU_PushIntegerTree (m2expr_BuildSize (location, SymbolConversion_Mod2Gcc (sym), false));
          SymbolTable_PopSize (sym);
          SymbolTable_PushSize (sym);
          return M2ALU_PopIntegerTree ();
        }
      else if ((SymbolTable_IsVar (sym)) && (SymbolConversion_GccKnowsAbout (SymbolTable_GetType (sym))))
        {
          /* avoid dangling else.  */
          M2ALU_PushIntegerTree (m2expr_BuildSize (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (sym)), false));
          return M2ALU_PopIntegerTree ();
        }
      else
        {
          /* avoid dangling else.  */
          M2Error_InternalError ((const char *) "expecting gcc to already know about this symbol", 47);
        }
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2GenGCC.def", 20, 1);
  __builtin_unreachable ();
}


/*
   FindType - returns the type of, Sym, if Sym is a TYPE then return Sym otherwise return GetType(Sym)
*/

static unsigned int FindType (unsigned int Sym)
{
  if (SymbolTable_IsType (Sym))
    {
      return Sym;
    }
  else
    {
      return SymbolTable_GetType (Sym);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildTreeFromInterface - generates a GCC tree from an interface definition.
*/

static tree BuildTreeFromInterface (unsigned int sym)
{
  unsigned int tok;
  unsigned int i;
  NameKey_Name name;
  unsigned int str;
  unsigned int obj;
  tree gccName;
  tree asmTree;

  asmTree = (tree) (NULL);
  if (sym != SymbolTable_NulSym)
    {
      i = 1;
      do {
        SymbolTable_GetRegInterface (sym, i, &tok, &name, &str, &obj);
        if (str != SymbolTable_NulSym)
          {
            /* avoid gcc warning by using compound statement even if not strictly necessary.  */
            if (SymbolTable_IsConstString (str))
              {
                /* avoid dangling else.  */
                M2GCCDeclare_DeclareConstant (tok, obj);
                if (name == NameKey_NulName)
                  {
                    gccName = NULL;
                  }
                else
                  {
                    gccName = m2decl_BuildCStringConstant (const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (name))), static_cast<int> (NameKey_LengthKey (name)));
                  }
                asmTree = m2type_ChainOnParamValue (asmTree, gccName, M2GCCDeclare_PromoteToCString (tok, str), m2tree_skip_const_decl (SymbolConversion_Mod2Gcc (obj)));
                if (DebugTokPos)
                  {
                    M2Error_WarnStringAt (DynamicStrings_InitString ((const char *) "input expression", 16), tok);
                  }
              }
            else
              {
                M2MetaError_MetaErrorT1 (tok, (const char *) "a constraint to the GNU ASM statement must be a constant string and not a {%1Ed}", 80, str);
              }
          }
        i += 1;
      } while (! ((str == SymbolTable_NulSym) && (obj == SymbolTable_NulSym)));
    }
  return asmTree;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildTrashTreeFromInterface - generates a GCC string tree from an interface definition.
*/

static tree BuildTrashTreeFromInterface (unsigned int sym)
{
  unsigned int tok;
  unsigned int i;
  unsigned int str;
  unsigned int obj;
  NameKey_Name name;
  tree asmTree;

  asmTree = (tree) (NULL);
  if (sym != SymbolTable_NulSym)
    {
      i = 1;
      do {
        SymbolTable_GetRegInterface (sym, i, &tok, &name, &str, &obj);
        if (str != SymbolTable_NulSym)
          {
            /* avoid gcc warning by using compound statement even if not strictly necessary.  */
            if (SymbolTable_IsConstString (str))
              {
                /* avoid dangling else.  */
                asmTree = m2type_AddStringToTreeList (asmTree, M2GCCDeclare_PromoteToCString (tok, str));
                if (DebugTokPos)
                  {
                    M2Error_WarnStringAt (DynamicStrings_InitString ((const char *) "trash expression", 16), tok);
                  }
              }
            else
              {
                M2MetaError_MetaErrorT1 (tok, (const char *) "a constraint to the GNU ASM statement must be a constant string and not a {%1Ed}", 80, str);
              }
          }
        i += 1;
      } while (! ((str == SymbolTable_NulSym) && (obj == SymbolTable_NulSym)));
    }
  return asmTree;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeInline - InlineOp is a quadruple which has the following format:

                InlineOp   NulSym  NulSym  Sym
*/

static void CodeInline (unsigned int quad)
{
  bool constExpr;
  bool overflowChecking;
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int GnuAsm;
  unsigned int op1pos;
  unsigned int op2pos;
  unsigned int op3pos;
  unsigned int asmpos;
  unsigned int string;
  tree inputs;
  tree outputs;
  tree trash;
  tree labels;
  location_t location;

  M2Quads_GetQuadOtok (quad, &asmpos, &op, &op1, &op2, &GnuAsm, &overflowChecking, &constExpr, &op1pos, &op2pos, &op3pos);
  location = M2LexBuf_TokenToLocation (asmpos);
  inputs = BuildTreeFromInterface (SymbolTable_GetGnuAsmInput (GnuAsm));
  outputs = BuildTreeFromInterface (SymbolTable_GetGnuAsmOutput (GnuAsm));
  trash = BuildTrashTreeFromInterface (SymbolTable_GetGnuAsmTrash (GnuAsm));
  labels = NULL;  /* At present it makes no sence for Modula-2 to jump to a label,
                        given that labels are not allowed in Modula-2.  */
  string = SymbolTable_GetGnuAsm (GnuAsm);  /* At present it makes no sence for Modula-2 to jump to a label,
                        given that labels are not allowed in Modula-2.  */
  m2statement_BuildAsm (location, M2GCCDeclare_PromoteToCString (SymbolTable_GetDeclaredMod (string), string), SymbolTable_IsGnuAsmVolatile (GnuAsm), SymbolTable_IsGnuAsmSimple (GnuAsm), inputs, outputs, trash, labels);
}


/*
   FoldStatementNote - set CurrentQuadToken to tokennno.
*/

static void FoldStatementNote (unsigned int tokenno)
{
  CurrentQuadToken = tokenno;
}


/*
   CodeStatementNote - set CurrentQuadToken to tokennno and
                       add a statement note.
*/

static void CodeStatementNote (unsigned int tokenno)
{
  if (Debugging)
    {
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "{%W} statement note", 19);
    }
  CurrentQuadToken = tokenno;
  m2block_addStmtNote (M2LexBuf_TokenToLocation (tokenno));
}


/*
   FoldRange - attempts to fold the range test.
               --fixme-- complete this.
*/

static void FoldRange (unsigned int tokenno, unsigned int quad, unsigned int rangeno)
{
  M2Range_FoldRangeCheck (tokenno, quad, rangeno);  /* p: WalkAction;  */
}


/*
   CodeSaveException - op1 := op3(TRUE)
*/

static void CodeSaveException (unsigned int des, unsigned int exceptionProcedure)
{
  tree functValue;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  m2statement_BuildParam (location, SymbolConversion_Mod2Gcc (M2Base_True));
  m2statement_BuildFunctionCallTree (location, SymbolConversion_Mod2Gcc (exceptionProcedure), SymbolConversion_Mod2Gcc (SymbolTable_GetType (exceptionProcedure)));
  functValue = m2statement_BuildFunctValue (location, SymbolConversion_Mod2Gcc (des));
  m2type_AddStatement (location, functValue);
}


/*
   CodeRestoreException - op1 := op3(op1).
*/

static void CodeRestoreException (unsigned int des, unsigned int exceptionProcedure)
{
  tree functValue;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  m2statement_BuildParam (location, SymbolConversion_Mod2Gcc (des));
  m2statement_BuildFunctionCallTree (location, SymbolConversion_Mod2Gcc (exceptionProcedure), SymbolConversion_Mod2Gcc (SymbolTable_GetType (exceptionProcedure)));
  functValue = m2statement_BuildFunctValue (location, SymbolConversion_Mod2Gcc (des));
  m2type_AddStatement (location, functValue);
}


/*
   PushScope -
*/

static void PushScope (unsigned int sym)
{
  M2StackWord_PushWord (ScopeStack, sym);
}


/*
   PopScope -
*/

static void PopScope (void)
{
  unsigned int sym;

  sym = static_cast<unsigned int> (M2StackWord_PopWord (ScopeStack));
  M2Debug_Assert (sym != SymbolTable_NulSym);
}


/*
   GetCurrentScopeDescription - returns a description of the current scope.
*/

static DynamicStrings_String GetCurrentScopeDescription (void)
{
  unsigned int sym;
  DynamicStrings_String n;

  if (M2StackWord_IsEmptyWord (ScopeStack))
    {
      M2Error_InternalError ((const char *) "not expecting scope stack to be empty", 37);
    }
  else
    {
      sym = static_cast<unsigned int> (M2StackWord_PeepWord (ScopeStack, 1));
      n = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym))));
      if (SymbolTable_IsDefImp (sym))
        {
          return FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "implementation module %s", 24)), (const unsigned char *) &n, (sizeof (n)-1));
        }
      else if (SymbolTable_IsModule (sym))
        {
          /* avoid dangling else.  */
          if (SymbolTable_IsInnerModule (sym))
            {
              return FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "inner module %s", 15)), (const unsigned char *) &n, (sizeof (n)-1));
            }
          else
            {
              return FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "program module %s", 17)), (const unsigned char *) &n, (sizeof (n)-1));
            }
        }
      else if (SymbolTable_IsProcedure (sym))
        {
          /* avoid dangling else.  */
          if (SymbolTable_IsProcedureNested (sym))
            {
              return FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "nested procedure %s", 19)), (const unsigned char *) &n, (sizeof (n)-1));
            }
          else
            {
              return FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "procedure %s", 12)), (const unsigned char *) &n, (sizeof (n)-1));
            }
        }
      else
        {
          /* avoid dangling else.  */
          M2Error_InternalError ((const char *) "unexpected scope symbol", 23);
        }
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2GenGCC.def", 20, 1);
  __builtin_unreachable ();
}


/*
   CodeRange - encode the range test associated with op3.
*/

static void CodeRange (unsigned int rangeId)
{
  M2Range_CodeRangeCheck (rangeId, GetCurrentScopeDescription ());
}


/*
   CodeError - encode the error test associated with op3.
*/

static void CodeError (unsigned int errorId)
{
  /* We would like to test whether this position is in the same basicblock
      as any known entry point.  If so we could emit an error message.
  */
  m2type_AddStatement (M2LexBuf_TokenToLocation (CurrentQuadToken), M2Range_CodeErrorCheck (errorId, GetCurrentScopeDescription (), static_cast<DynamicStrings_String> (NULL)));
}


/*
   CodeModuleScope - ModuleScopeOp is a quadruple which has the following
                     format:

                     ModuleScopeOp  _  _  moduleSym

                     Its purpose is to reset the source file to another
                     file, hence all line numbers emitted with the
                     generated code will be relative to this source file.
*/

static void CodeModuleScope (unsigned int moduleSym)
{
  PushScope (moduleSym);
}


/*
   CodeStartModFile - StartModFileOp is a quadruple which has the following
                      format:

                      StartModFileOp  _  _  moduleSym

                      A new source file has been encountered therefore
                      set LastLine to 1.
                      Call pushGlobalScope.
*/

static void CodeStartModFile (unsigned int moduleSym)
{
  m2block_pushGlobalScope ();
  LastLine = 1;
  PushScope (moduleSym);
}


/*
   CodeStartDefFile - StartDefFileOp is a quadruple with the following
                      format:

                      StartDefFileOp  _  _  moduleSym

                      A new source file has been encountered therefore
                      set LastLine to 1.
                      Call pushGlobalScope.
*/

static void CodeStartDefFile (unsigned int moduleSym)
{
  m2block_pushGlobalScope ();
  PushScope (moduleSym);
  LastLine = 1;
}


/*
   CodeEndFile - pops the GlobalScope.
*/

static void CodeEndFile (void)
{
  m2block_popGlobalScope ();
}


/*
   CallInnerInit - produce a call to inner module initialization routine.
*/

static void CallInnerInit (unsigned int moduleSym)
{
  location_t location;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  SymbolTable_GetModuleCtors (moduleSym, &ctor, &init, &fini, &dep);
  m2statement_BuildCallInner (location, SymbolConversion_Mod2Gcc (init));
}


/*
   CallInnerFinally - produce a call to inner module finalization routine.
*/

static void CallInnerFinally (unsigned int moduleSym)
{
  location_t location;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  SymbolTable_GetModuleCtors (moduleSym, &ctor, &init, &fini, &dep);
  m2statement_BuildCallInner (location, SymbolConversion_Mod2Gcc (fini));
}


/*
   CodeInitStart - emits starting code before the main BEGIN END of the
                   current module.
*/

static void CodeInitStart (unsigned int moduleSym, bool CompilingMainModule)
{
  location_t location;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  if (CompilingMainModule || M2Options_WholeProgram)
    {
      location = M2LexBuf_TokenToLocation (CurrentQuadToken);
      SymbolTable_GetModuleCtors (moduleSym, &ctor, &init, &fini, &dep);
      m2statement_BuildStartFunctionCode (location, SymbolConversion_Mod2Gcc (init), IsExportedGcc (init), false);
      SymbolTable_ForeachInnerModuleDo (moduleSym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) CallInnerInit});
    }
}


/*
   CodeInitEnd - emits terminating code after the main BEGIN END of the
                 current module.
*/

static void CodeInitEnd (unsigned int moduleSym, bool CompilingMainModule)
{
  location_t location;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  if (CompilingMainModule || M2Options_WholeProgram)
    {
      location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (moduleSym));
      SymbolTable_GetModuleCtors (moduleSym, &ctor, &init, &fini, &dep);
      m2block_finishFunctionDecl (location, SymbolConversion_Mod2Gcc (init));
      m2statement_BuildEndFunctionCode (location, SymbolConversion_Mod2Gcc (init), SymbolTable_IsModuleWithinProcedure (moduleSym));
    }
}


/*
   CodeFinallyStart - emits starting code before the main BEGIN END of the
                      current module.
*/

static void CodeFinallyStart (unsigned int moduleSym, bool CompilingMainModule)
{
  location_t location;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  if (CompilingMainModule || M2Options_WholeProgram)
    {
      location = M2LexBuf_TokenToLocation (CurrentQuadToken);
      SymbolTable_GetModuleCtors (moduleSym, &ctor, &init, &fini, &dep);
      m2statement_BuildStartFunctionCode (location, SymbolConversion_Mod2Gcc (fini), IsExportedGcc (fini), false);
      SymbolTable_ForeachInnerModuleDo (moduleSym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) CallInnerFinally});
    }
}


/*
   CodeFinallyEnd - emits terminating code after the main BEGIN END of the
                    current module.  It also creates the scaffold if the
                    cflag was not present.
*/

static void CodeFinallyEnd (unsigned int moduleSym, bool CompilingMainModule)
{
  location_t location;
  unsigned int tokenpos;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  if (CompilingMainModule || M2Options_WholeProgram)
    {
      tokenpos = SymbolTable_GetDeclaredMod (moduleSym);
      location = M2LexBuf_TokenToLocation (tokenpos);
      SymbolTable_GetModuleCtors (moduleSym, &ctor, &init, &fini, &dep);
      m2block_finishFunctionDecl (location, SymbolConversion_Mod2Gcc (fini));
      m2statement_BuildEndFunctionCode (location, SymbolConversion_Mod2Gcc (fini), SymbolTable_IsModuleWithinProcedure (moduleSym));
    }
}


/*
   GetAddressOfUnbounded - returns the address of the unbounded array contents.
*/

static tree GetAddressOfUnbounded (location_t location, unsigned int param)
{
  unsigned int UnboundedType;

  UnboundedType = SymbolTable_GetType (param);
  M2Debug_Assert (SymbolTable_IsUnbounded (UnboundedType));
  return m2convert_BuildConvert (M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (param)), m2type_GetPointerType (), m2expr_BuildComponentRef (location, SymbolConversion_Mod2Gcc (param), SymbolConversion_Mod2Gcc (SymbolTable_GetUnboundedAddressOffset (UnboundedType))), false);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetSizeOfHighFromUnbounded - returns a Tree containing the value of
                                param.HIGH * sizeof(unboundedType).
                                The number of legal bytes this array
                                occupies.
*/

static tree GetSizeOfHighFromUnbounded (unsigned int tokenno, unsigned int param)
{
  tree t;
  unsigned int UnboundedType;
  unsigned int ArrayType;
  unsigned int i;
  unsigned int n;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  UnboundedType = SymbolTable_GetType (param);
  M2Debug_Assert (SymbolTable_IsUnbounded (UnboundedType));
  ArrayType = SymbolTable_GetType (UnboundedType);
  i = 1;
  n = SymbolTable_GetDimension (UnboundedType);
  t = m2expr_GetCardinalOne (location);
  while (i <= n)
    {
      t = m2expr_BuildMult (location, m2expr_BuildAdd (location, M2GenGCC_GetHighFromUnbounded (location, i, param), m2expr_GetCardinalOne (location), false), t, false);
      /* Remember we must add one as a[HIGH(a)] is the last accessible element of the array.  */
      i += 1;
    }
  return m2convert_BuildConvert (location, m2type_GetCardinalType (), m2expr_BuildMult (location, t, m2convert_BuildConvert (location, m2type_GetCardinalType (), FindSize (tokenno, ArrayType), false), false), false);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MaybeDebugBuiltinAlloca - if DebugBuiltins is set
                             then call Builtins.alloca_trace
                             else call Builtins.alloca.
*/

static tree MaybeDebugBuiltinAlloca (location_t location, unsigned int tok, tree high)
{
  tree call;
  tree memptr;
  tree func;

  if (M2Options_DebugBuiltins)
    {
      func = SymbolConversion_Mod2Gcc (SymbolTable_FromModuleGetSym (tok, NameKey_MakeKey ((const char *) "alloca_trace", 12), M2Batch_MakeDefinitionSource (tok, NameKey_MakeKey ((const char *) "Builtins", 8))));
      call = m2builtins_BuiltInAlloca (location, high);
      m2statement_SetLastFunction (call);
      memptr = m2statement_BuildFunctValue (location, call);
      call = m2statement_BuildCall2 (location, func, m2type_GetPointerType (), memptr, high);
    }
  else
    {
      call = m2builtins_BuiltInAlloca (location, high);
    }
  m2statement_SetLastFunction (call);
  return m2statement_BuildFunctValue (location, call);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MaybeDebugBuiltinMemcpy - if DebugBuiltins is set
                             then call memcpy
                             else call Builtins.memcpy.
*/

static tree MaybeDebugBuiltinMemcpy (location_t location, tree src, tree dest, tree nbytes)
{
  tree call;
  tree func;

  if (M2Options_DebugBuiltins)
    {
      func = SymbolConversion_Mod2Gcc (Memcpy);
      call = m2statement_BuildCall3 (location, func, m2type_GetPointerType (), src, dest, nbytes);
    }
  else
    {
      call = m2builtins_BuiltinMemCopy (location, src, dest, nbytes);
    }
  m2statement_SetLastFunction (call);
  return m2statement_BuildFunctValue (location, call);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeCopyUse - make a copy of the unbounded array and alter all references
                 from the old unbounded array to the new unbounded array.
                 The parameter, param, contains a RECORD
                                                     ArrayAddress: ADDRESS ;
                                                     ArrayHigh   : CARDINAL ;
                                                  END
                 we simply declare a new array of size, ArrayHigh
                 and set ArrayAddress to the address of the copy.

                 Remember ArrayHigh == sizeof(Array)-sizeof(typeof(array))
                          so we add 1 for the size and add 1 for a possible <nul>
*/

static void MakeCopyUse (unsigned int tokenno, unsigned int param)
{
  location_t location;
  unsigned int UnboundedType;
  tree Addr;
  tree High;
  tree NewArray;

  location = M2LexBuf_TokenToLocation (tokenno);
  UnboundedType = SymbolTable_GetType (param);
  M2Debug_Assert (SymbolTable_IsUnbounded (UnboundedType));
  High = GetSizeOfHighFromUnbounded (tokenno, param);
  Addr = GetAddressOfUnbounded (location, param);
  NewArray = MaybeDebugBuiltinAlloca (location, tokenno, High);
  NewArray = MaybeDebugBuiltinMemcpy (location, NewArray, Addr, High);
  /* Now assign  param.Addr := ADR(NewArray).  */
  m2statement_BuildAssignmentStatement (location, m2expr_BuildComponentRef (location, SymbolConversion_Mod2Gcc (param), SymbolConversion_Mod2Gcc (SymbolTable_GetUnboundedAddressOffset (UnboundedType))), NewArray);
}


/*
   GetParamAddress - returns the address of parameter, param.
*/

static tree GetParamAddress (location_t location, unsigned int proc, unsigned int param)
{
  unsigned int sym;
  unsigned int type;

  if (SymbolTable_IsParameter (param))
    {
      type = SymbolTable_GetType (param);
      sym = SymbolTable_GetLocalSym (proc, SymbolTable_GetSymName (param));
      if (SymbolTable_IsUnbounded (type))
        {
          return GetAddressOfUnbounded (location, sym);
        }
      else
        {
          M2Debug_Assert ((SymbolTable_GetMode (sym)) == SymbolTable_LeftValue);
          return SymbolConversion_Mod2Gcc (sym);
        }
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsVar (param));
      M2Debug_Assert ((SymbolTable_GetMode (param)) == SymbolTable_LeftValue);
      return SymbolConversion_Mod2Gcc (param);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsUnboundedWrittenTo - returns TRUE if the unbounded parameter
                          might be written to, or if -funbounded-by-reference
                          was _not_ specified.
*/

static bool IsUnboundedWrittenTo (unsigned int proc, unsigned int param)
{
  DynamicStrings_String f;
  unsigned int l;
  unsigned int sym;
  NameKey_Name n1;
  NameKey_Name n2;

  sym = SymbolTable_GetLocalSym (proc, SymbolTable_GetSymName (param));
  if (sym == SymbolTable_NulSym)
    {
      M2Error_InternalError ((const char *) "should find symbol in table", 27);
    }
  else
    {
      if (M2Options_UnboundedByReference)
        {
          if ((! (SymbolTable_GetVarWritten (sym))) && M2Options_VerboseUnbounded)
            {
              n1 = SymbolTable_GetSymName (sym);
              n2 = SymbolTable_GetSymName (proc);
              f = M2LexBuf_FindFileNameFromToken (SymbolTable_GetDeclaredMod (sym), 0);
              l = M2LexBuf_TokenToLineNo (SymbolTable_GetDeclaredMod (sym), 0);
              M2Printf_printf4 ((const char *) "%s:%d:non VAR unbounded parameter %a in procedure %a does not need to be copied\\n", 81, (const unsigned char *) &f, (sizeof (f)-1), (const unsigned char *) &l, (sizeof (l)-1), (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
            }
          return SymbolTable_GetVarWritten (sym);
        }
      else
        {
          return true;
        }
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2GenGCC.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetParamSize - returns the size in bytes of, param.
*/

static tree GetParamSize (unsigned int tokenno, unsigned int param)
{
  M2Debug_Assert ((SymbolTable_IsVar (param)) || (SymbolTable_IsParameter (param)));
  if (SymbolTable_IsUnbounded (param))
    {
      return GetSizeOfHighFromUnbounded (tokenno, param);
    }
  else
    {
      return m2expr_BuildSize (M2LexBuf_TokenToLocation (tokenno), SymbolConversion_Mod2Gcc (SymbolTable_GetType (param)), false);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoIsIntersection - jumps to, tLabel, if the ranges i1..i2  j1..j2 overlap
                      else jump to, fLabel.
*/

static void DoIsIntersection (unsigned int tokenno, tree ta, tree tb, tree tc, tree td, DynamicStrings_String tLabel, DynamicStrings_String fLabel)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  /* 
     if (ta>td) OR (tb<tc)
     then
        goto fLabel
     else
        goto tLabel
     fi
  */
  m2statement_DoJump (location, m2expr_BuildGreaterThan (location, ta, td), NULL, reinterpret_cast <char * > (DynamicStrings_string (fLabel)));
  m2statement_DoJump (location, m2expr_BuildLessThan (location, tb, tc), NULL, reinterpret_cast <char * > (DynamicStrings_string (fLabel)));
  m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (tLabel)));
  if (CascadedDebugging)
    {
      M2Printf_printf1 ((const char *) "label used %s\\n", 15, (const unsigned char *) &tLabel, (sizeof (tLabel)-1));
      M2Printf_printf1 ((const char *) "label used %s\\n", 15, (const unsigned char *) &fLabel, (sizeof (fLabel)-1));
    }
}


/*
   BuildCascadedIfThenElsif - mustCheck contains a list of variables which
                              must be checked against the address of (proc, param, i).
                              If the address matches we make a copy of the unbounded
                              parameter (proc, param) and quit further checking.
*/

static void BuildCascadedIfThenElsif (unsigned int tokenno, Lists_List mustCheck, unsigned int proc, unsigned int param)
{
  tree ta;
  tree tb;
  tree tc;
  tree td;
  unsigned int n;
  unsigned int j;
  DynamicStrings_String tLabel;
  DynamicStrings_String fLabel;
  DynamicStrings_String nLabel;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  n = Lists_NoOfItemsInList (mustCheck);
  /* We want a sequence of if then elsif statements.  */
  if (n > 0)
    {
      UnboundedLabelNo += 1;
      j = 1;
      ta = GetAddressOfUnbounded (location, param);
      tb = m2convert_BuildConvert (M2LexBuf_TokenToLocation (tokenno), m2type_GetPointerType (), m2expr_BuildAddAddress (location, ta, GetSizeOfHighFromUnbounded (tokenno, param)), false);
      while (j <= n)
        {
          if (j > 1)
            {
              nLabel = CreateLabelProcedureN (proc, (const char *) "n", 1, UnboundedLabelNo, j);
              if (CascadedDebugging)
                {
                  M2Printf_printf1 ((const char *) "label declared %s\\n", 19, (const unsigned char *) &nLabel, (sizeof (nLabel)-1));
                }
              m2statement_DeclareLabel (location, reinterpret_cast <char * > (DynamicStrings_string (nLabel)));
            }
          tc = GetParamAddress (location, proc, Lists_GetItemFromList (mustCheck, j));
          td = m2convert_BuildConvert (M2LexBuf_TokenToLocation (tokenno), m2type_GetPointerType (), m2expr_BuildAddAddress (location, tc, GetParamSize (tokenno, param)), false);
          tLabel = CreateLabelProcedureN (proc, (const char *) "t", 1, UnboundedLabelNo, j+1);
          fLabel = CreateLabelProcedureN (proc, (const char *) "f", 1, UnboundedLabelNo, j+1);
          DoIsIntersection (tokenno, ta, tb, tc, td, tLabel, fLabel);
          if (CascadedDebugging)
            {
              M2Printf_printf1 ((const char *) "label declared %s\\n", 19, (const unsigned char *) &tLabel, (sizeof (tLabel)-1));
            }
          m2statement_DeclareLabel (location, reinterpret_cast <char * > (DynamicStrings_string (tLabel)));
          MakeCopyUse (tokenno, param);
          if (j < n)
            {
              nLabel = CreateLabelProcedureN (proc, (const char *) "n", 1, UnboundedLabelNo, n+1);
              m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (nLabel)));
              if (CascadedDebugging)
                {
                  M2Printf_printf1 ((const char *) "goto %s\\n", 9, (const unsigned char *) &nLabel, (sizeof (nLabel)-1));
                }
            }
          if (CascadedDebugging)
            {
              M2Printf_printf1 ((const char *) "label declared %s\\n", 19, (const unsigned char *) &fLabel, (sizeof (fLabel)-1));
            }
          m2statement_DeclareLabel (location, reinterpret_cast <char * > (DynamicStrings_string (fLabel)));
          j += 1;
        }
    }
  /* 
      nLabel := CreateLabelProcedureN(proc, "fin", UnboundedLabelNo, n+1) ;
      IF CascadedDebugging
      THEN
         printf1('label declared %s
  ', nLabel)
      END ;
      DeclareLabel(location, string(nLabel))
  */
}


/*
   CheckUnboundedNonVarParameter - if non var unbounded parameter is written to
                                   then
                                      make a copy of the contents of this parameter
                                      and use the copy
                                   else if param
                                      is type compatible with any parameter, symv
                                      and at runtime its address matches symv
                                   then
                                      make a copy of the contents of this parameter
                                      and use the copy
                                   fi
*/

static void CheckUnboundedNonVarParameter (unsigned int tokenno, Lists_List trashed, unsigned int proc, unsigned int param)
{
  Lists_List mustCheck;
  unsigned int paramTrashed;
  unsigned int n;
  unsigned int j;
  DynamicStrings_String f;
  unsigned int l;
  NameKey_Name n1;
  NameKey_Name n2;

  if (IsUnboundedWrittenTo (proc, param))
    {
      MakeCopyUse (tokenno, param);
    }
  else
    {
      Lists_InitList (&mustCheck);
      n = Lists_NoOfItemsInList (trashed);
      j = 1;
      while (j <= n)
        {
          paramTrashed = static_cast<unsigned int> (Lists_GetItemFromList (trashed, j));
          if (M2Base_IsAssignmentCompatible (SymbolTable_GetLowestType (param), SymbolTable_GetLowestType (paramTrashed)))
            {
              /* We must check whether this unbounded parameter has the same
               address as the trashed parameter.  */
              if (M2Options_VerboseUnbounded)
                {
                  n1 = SymbolTable_GetSymName (paramTrashed);
                  n2 = SymbolTable_GetSymName (proc);
                  f = M2LexBuf_FindFileNameFromToken (SymbolTable_GetDeclaredMod (paramTrashed), 0);
                  l = M2LexBuf_TokenToLineNo (SymbolTable_GetDeclaredMod (paramTrashed), 0);
                  M2Printf_printf4 ((const char *) "%s:%d:must check at runtime the address of parameter, %a, in procedure, %a, whose contents will be trashed\\n", 108, (const unsigned char *) &f, (sizeof (f)-1), (const unsigned char *) &l, (sizeof (l)-1), (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
                  n1 = SymbolTable_GetSymName (param);
                  n2 = SymbolTable_GetSymName (paramTrashed);
                  M2Printf_printf4 ((const char *) "%s:%d:against address of parameter, %a, possibly resulting in a copy of parameter, %a\\n", 87, (const unsigned char *) &f, (sizeof (f)-1), (const unsigned char *) &l, (sizeof (l)-1), (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
                }
              Lists_PutItemIntoList (mustCheck, paramTrashed);
            }
          j += 1;
        }
      /* Now we build a sequence of if then { elsif then } end to check addresses.  */
      BuildCascadedIfThenElsif (tokenno, mustCheck, proc, param);
      Lists_KillList (&mustCheck);
    }
}


/*
   IsParameterWritten - returns TRUE if a parameter, sym, is written to.
*/

static bool IsParameterWritten (unsigned int proc, unsigned int sym)
{
  if (SymbolTable_IsParameter (sym))
    {
      sym = SymbolTable_GetLocalSym (proc, SymbolTable_GetSymName (sym));
    }
  if (SymbolTable_IsVar (sym))
    {
      /* Unbounded arrays will appear as vars.  */
      return SymbolTable_GetVarWritten (sym);
    }
  M2Error_InternalError ((const char *) "expecting IsVar to return TRUE", 30);
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2GenGCC.def", 20, 1);
  __builtin_unreachable ();
}


/*
   SaveNonVarUnboundedParameters - for each var parameter, symv, do
                                       not just unbounded var parameters, but _all_
                                         parameters 
                                      if symv is written to
                                      then
                                         add symv to a compile list
                                      fi
                                   done

                                   for each parameter of procedure, symu, do
                                      if non var unbounded parameter is written to
                                      then
                                         make a copy of the contents of this parameter
                                         and use the copy
                                      else if
                                         symu is type compatible with any parameter, symv
                                         and at runtime its address matches symv
                                      then
                                         make a copy of the contents of this parameter
                                         and use the copy
                                      fi
                                   done
*/

static void SaveNonVarUnboundedParameters (unsigned int tokenno, unsigned int proc)
{
  unsigned int i;
  unsigned int p;
  Lists_List trashed;
  DynamicStrings_String f;
  unsigned int sym;
  unsigned int l;
  NameKey_Name n1;
  NameKey_Name n2;

  Lists_InitList (&trashed);
  i = 1;
  p = SymbolTable_NoOfParamAny (proc);
  while (i <= p)
    {
      sym = SymbolTable_GetNthParamAny (proc, i);
      if (IsParameterWritten (proc, sym))
        {
          if (M2Options_VerboseUnbounded)
            {
              n1 = SymbolTable_GetSymName (sym);
              n2 = SymbolTable_GetSymName (proc);
              f = M2LexBuf_FindFileNameFromToken (SymbolTable_GetDeclaredMod (sym), 0);
              l = M2LexBuf_TokenToLineNo (SymbolTable_GetDeclaredMod (sym), 0);
              M2Printf_printf4 ((const char *) "%s:%d:parameter, %a, in procedure, %a, is trashed\\n", 51, (const unsigned char *) &f, (sizeof (f)-1), (const unsigned char *) &l, (sizeof (l)-1), (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
            }
          Lists_PutItemIntoList (trashed, sym);
        }
      i += 1;
    }
  /* Now see whether we need to copy any unbounded array parameters.  */
  i = 1;
  p = SymbolTable_NoOfParamAny (proc);
  while (i <= p)
    {
      if ((SymbolTable_IsUnboundedParamAny (proc, i)) && (! (SymbolTable_IsVarParamAny (proc, i))))
        {
          CheckUnboundedNonVarParameter (tokenno, trashed, proc, SymbolTable_GetNth (proc, i));
        }
      i += 1;
    }
  Lists_KillList (&trashed);
}


/*
   AutoInitVariable -
*/

static void AutoInitVariable (location_t location, unsigned int sym)
{
  unsigned int type;

  if (((! (SymbolTable_IsParameter (sym))) && (SymbolTable_IsVar (sym))) && (! (SymbolTable_IsTemporary (sym))))
    {
      /* PrintSym (sym) ;  */
      type = SymbolTable_SkipType (SymbolTable_GetType (sym));
      /* The type SYSTEM.ADDRESS is a pointer type.  */
      if (SymbolTable_IsPointer (type))
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (sym), m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (sym)), m2expr_GetPointerZero (location), true));
        }
    }
}


/*
   AutoInitialize - scope will be a procedure, module or defimp.  All pointer
                    variables are assigned to NIL.
*/

static void AutoInitialize (location_t location, unsigned int scope)
{
  unsigned int i;
  unsigned int n;

  if (M2Options_AutoInit)
    {
      n = SymbolTable_NoOfVariables (scope);
      i = 1;
      if (SymbolTable_IsProcedure (scope))
        {
          /* The parameters are stored as local variables.  */
          i += SymbolTable_NoOfParamAny (scope);
        }
      while (i <= n)
        {
          AutoInitVariable (location, SymbolTable_GetNth (scope, i));
          i += 1;
        }
    }
}


/*
   CodeNewLocalVar - Builds a new frame on the stack to contain the procedure
                     local variables.
*/

static void CodeNewLocalVar (unsigned int tokenno, unsigned int CurrentProcedure)
{
  unsigned int begin;
  unsigned int end;

  /* Callee saves non var unbounded parameter contents.  */
  SaveNonVarUnboundedParameters (tokenno, CurrentProcedure);
  m2statement_BuildPushFunctionContext ();
  SymbolTable_GetProcedureBeginEnd (CurrentProcedure, &begin, &end);
  CurrentQuadToken = begin;
  m2statement_SetBeginLocation (M2LexBuf_TokenToLocation (begin));
  AutoInitialize (M2LexBuf_TokenToLocation (begin), CurrentProcedure);
  SymbolTable_ForeachProcedureDo (CurrentProcedure, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2Code_CodeBlock});
  SymbolTable_ForeachInnerModuleDo (CurrentProcedure, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2Code_CodeBlock});
  m2statement_BuildPopFunctionContext ();
  SymbolTable_ForeachInnerModuleDo (CurrentProcedure, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) CallInnerInit});
}


/*
   CodeKillLocalVar - removes local variables and returns to previous scope.
*/

static void CodeKillLocalVar (unsigned int CurrentProcedure)
{
  unsigned int begin;
  unsigned int end;
  tree proc;

  SymbolTable_GetProcedureBeginEnd (CurrentProcedure, &begin, &end);
  CurrentQuadToken = end;
  proc = NULL;
  if (SymbolTable_IsCtor (CurrentProcedure))
    {
      proc = m2decl_DeclareModuleCtor (SymbolConversion_Mod2Gcc (CurrentProcedure));
    }
  m2statement_BuildEndFunctionCode (M2LexBuf_TokenToLocation (end), SymbolConversion_Mod2Gcc (CurrentProcedure), M2GCCDeclare_IsProcedureGccNested (CurrentProcedure));
  if ((SymbolTable_IsCtor (CurrentProcedure)) && (proc != NULL))
    {
      m2decl_BuildModuleCtor (proc);
    }
  M2GCCDeclare_PoisonSymbols (CurrentProcedure);
  m2block_removeStmtNote ();
  PopScope ();
}


/*
   CodeProcedureScope - start a procedure scope for CurrentProcedure.
*/

static void CodeProcedureScope (unsigned int CurrentProcedure)
{
  unsigned int begin;
  unsigned int end;

  m2block_removeStmtNote ();
  SymbolTable_GetProcedureBeginEnd (CurrentProcedure, &begin, &end);
  m2statement_BuildStartFunctionCode (M2LexBuf_TokenToLocation (begin), SymbolConversion_Mod2Gcc (CurrentProcedure), IsExportedGcc (CurrentProcedure), SymbolTable_IsProcedureInline (CurrentProcedure));
  M2GCCDeclare_StartDeclareScope (CurrentProcedure);
  PushScope (CurrentProcedure);
}


/*
   CodeReturnValue - places the operand into the return value space
                     allocated by the function call.
*/

static void CodeReturnValue (unsigned int quad)
{
  M2Quads_QuadOperator op;
  bool constExpr;
  bool overflowChecking;
  unsigned int expr;
  unsigned int none;
  unsigned int procedure;
  unsigned int combinedpos;
  unsigned int returnpos;
  unsigned int exprpos;
  unsigned int nonepos;
  unsigned int procpos;
  tree value;
  tree length;
  location_t location;

  M2Quads_GetQuadOtok (quad, &returnpos, &op, &expr, &none, &procedure, &overflowChecking, &constExpr, &exprpos, &nonepos, &procpos);
  combinedpos = M2LexBuf_MakeVirtualTok (returnpos, returnpos, exprpos);
  location = M2LexBuf_TokenToLocation (combinedpos);
  M2GCCDeclare_TryDeclareConstant (exprpos, expr);  /* Checks to see whether it is a constant and declares it.  */
  M2GCCDeclare_TryDeclareConstructor (exprpos, expr);  /* Checks to see whether it is a constant and declares it.  */
  if ((SymbolTable_IsConstString (expr)) && ((SymbolTable_SkipTypeAndSubrange (SymbolTable_GetType (procedure))) != M2Base_Char))
    {
      if (! (M2GenGCC_PrepareCopyString (returnpos, &length, &value, expr, SymbolTable_GetType (procedure))))
        {
          M2MetaError_MetaErrorT3 (M2LexBuf_MakeVirtualTok (returnpos, returnpos, exprpos), (const char *) "string constant {%1Ea} is too large to be returned from procedure {%2a} via the {%3d} {%3a}", 91, expr, procedure, SymbolTable_GetType (procedure));
        }
      value = m2type_BuildArrayStringConstructor (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (procedure)), value, length);
    }
  else
    {
      value = SymbolConversion_Mod2Gcc (expr);
    }
  m2statement_BuildReturnValueCode (location, SymbolConversion_Mod2Gcc (procedure), value);
}


/*
   CodeCall - determines whether the procedure call is a direct call
              or an indirect procedure call.
*/

static void CodeCall (unsigned int tokenno, unsigned int procedure)
{
  tree callTree;
  location_t location;

  if (SymbolTable_IsProcedure (procedure))
    {
      M2GCCDeclare_DeclareParameters (procedure);
      callTree = CodeDirectCall (tokenno, procedure);
    }
  else if (SymbolTable_IsProcType (SymbolTable_SkipType (SymbolTable_GetType (procedure))))
    {
      /* avoid dangling else.  */
      M2GCCDeclare_DeclareParameters (SymbolTable_SkipType (SymbolTable_GetType (procedure)));
      callTree = CodeIndirectCall (tokenno, procedure);
      procedure = SymbolTable_SkipType (SymbolTable_GetType (procedure));
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "expecting Procedure or ProcType", 31);
    }
  if ((SymbolTable_GetType (procedure)) == SymbolTable_NulSym)
    {
      location = M2LexBuf_TokenToLocation (tokenno);
      m2type_AddStatement (location, callTree);
    }
  /* Leave tree alone - as it will be picked up when processing FunctValue.  */
}


/*
   UseBuiltin - returns a Tree containing the builtin function
                and parameters. It should only be called if
                CanUseBuiltin or IsProcedureBuiltinAvailable returns TRUE.
*/

static tree UseBuiltin (unsigned int tokenno, unsigned int Sym)
{
  if (m2builtins_BuiltinExists (reinterpret_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetProcedureBuiltin (Sym)))))
    {
      return m2builtins_BuildBuiltinTree (M2LexBuf_TokenToLocation (tokenno), reinterpret_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetProcedureBuiltin (Sym))));
    }
  else
    {
      return m2builtins_BuildBuiltinTree (M2LexBuf_TokenToLocation (tokenno), reinterpret_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetSymName (Sym))));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeDirectCall - calls a function/procedure.
*/

static tree CodeDirectCall (unsigned int tokenno, unsigned int procedure)
{
  location_t location;
  tree call;

  location = M2LexBuf_TokenToLocation (tokenno);
  if (SymbolTable_IsProcedureBuiltinAvailable (procedure))
    {
      /* avoid dangling else.  */
      call = UseBuiltin (tokenno, procedure);
      if (call != NULL)
        {
          call = m2statement_BuildBuiltinCallTree (call);
        }
    }
  else
    {
      call = NULL;
    }
  if (call == NULL)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((SymbolTable_GetType (procedure)) == SymbolTable_NulSym)
        {
          call = m2statement_BuildProcedureCallTree (location, SymbolConversion_Mod2Gcc (procedure), NULL);
        }
      else
        {
          call = m2statement_BuildProcedureCallTree (location, SymbolConversion_Mod2Gcc (procedure), SymbolConversion_Mod2Gcc (SymbolTable_GetType (procedure)));
        }
    }
  if ((SymbolTable_GetType (procedure)) == SymbolTable_NulSym)
    {
      m2statement_SetLastFunction (NULL);
    }
  else
    {
      m2statement_SetLastFunction (call);
    }
  return call;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeIndirectCall - calls a function/procedure indirectly.
*/

static tree CodeIndirectCall (unsigned int tokenno, unsigned int ProcVar)
{
  tree ReturnType;
  unsigned int proc;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  proc = SymbolTable_SkipType (SymbolTable_GetType (ProcVar));
  if ((SymbolTable_GetType (proc)) == SymbolTable_NulSym)
    {
      ReturnType = (tree) (NULL);
    }
  else
    {
      ReturnType = (tree) (SymbolConversion_Mod2Gcc (SymbolTable_GetType (proc)));
    }
  /* Now we dereference the lvalue if necessary.  */
  if ((SymbolTable_GetMode (ProcVar)) == SymbolTable_LeftValue)
    {
      return m2statement_BuildIndirectProcedureCallTree (location, m2expr_BuildIndirect (location, SymbolConversion_Mod2Gcc (ProcVar), SymbolConversion_Mod2Gcc (proc)), ReturnType);
    }
  else
    {
      return m2statement_BuildIndirectProcedureCallTree (location, SymbolConversion_Mod2Gcc (ProcVar), ReturnType);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConvertTo - convert gcc tree, t, (which currently represents Modula-2 op3) into
               a symbol of, type.
*/

static tree ConvertTo (tree t, unsigned int type, unsigned int op3)
{
  if ((SymbolTable_SkipType (type)) != (SymbolTable_SkipType (SymbolTable_GetType (op3))))
    {
      if ((SymbolTable_IsConst (op3)) && (! (SymbolTable_IsConstString (op3))))
        {
          SymbolTable_PushValue (op3);
          return m2convert_BuildConvert (M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (op3)), SymbolConversion_Mod2Gcc (type), t, false);
        }
    }
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConvertRHS - convert (t, rhs) into, type.  (t, rhs) refer to the
                same entity t is a GCC Tree and, rhs, is a Modula-2
                symbol.  It checks for char and strings
                first and then the remaining types.
*/

static tree ConvertRHS (tree t, unsigned int type, unsigned int rhs)
{
  t = M2GenGCC_StringToChar (SymbolConversion_Mod2Gcc (rhs), type, rhs);
  return ConvertTo (t, type, rhs);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsCoerceableParameter - returns TRUE if symbol, sym, is a
                           coerceable parameter.
*/

static bool IsCoerceableParameter (unsigned int sym)
{
  return ((((((SymbolTable_IsSet (sym)) || (((M2Base_IsOrdinalType (sym)) && (sym != M2Base_Boolean)) && (! (SymbolTable_IsEnumeration (sym))))) || (M2Base_IsComplexType (sym))) || (M2Base_IsRealType (sym))) || (M2System_IsComplexN (sym))) || (M2System_IsRealN (sym))) || (M2System_IsSetN (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstProcedure - returns TRUE if, p, is a const procedure.
*/

static bool IsConstProcedure (unsigned int p)
{
  return ((SymbolTable_IsConst (p)) && ((SymbolTable_GetType (p)) != SymbolTable_NulSym)) && (SymbolTable_IsProcType (SymbolTable_GetType (p)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstant - returns TRUE if symbol, p, is either a const or procedure.
*/

static bool IsConstant (unsigned int p)
{
  return (SymbolTable_IsConst (p)) || (SymbolTable_IsProcedure (p));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckConvertCoerceParameter - ensure that actual parameter is the same as the nth of callee.
*/

static tree CheckConvertCoerceParameter (unsigned int tokenno, unsigned int nth, unsigned int callee, unsigned int actual)
{
  unsigned int OperandType;
  unsigned int ParamType;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  if ((SymbolTable_GetNthParamAny (callee, nth)) == SymbolTable_NulSym)
    {
      /* We reach here if the argument is being passed to a C vararg function.  */
      return SymbolConversion_Mod2Gcc (actual);
    }
  else
    {
      OperandType = SymbolTable_SkipType (SymbolTable_GetType (actual));
      ParamType = SymbolTable_SkipType (SymbolTable_GetType (SymbolTable_GetNthParamAny (callee, nth)));
    }
  if (SymbolTable_IsProcType (ParamType))
    {
      if (((SymbolTable_IsProcedure (actual)) || (IsConstProcedure (actual))) || (OperandType == ParamType))
        {
          return SymbolConversion_Mod2Gcc (actual);
        }
      else
        {
          return m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (ParamType), SymbolConversion_Mod2Gcc (actual), false);
        }
    }
  else if (((M2Base_IsRealType (OperandType)) && (M2Base_IsRealType (ParamType))) && (ParamType != OperandType))
    {
      /* avoid dangling else.  */
      /* SHORTREAL, LONGREAL and REAL conversion during parameter passing.  */
      return m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (ParamType), SymbolConversion_Mod2Gcc (actual), false);
    }
  else if (((OperandType != SymbolTable_NulSym) && (SymbolTable_IsSet (OperandType))) && (SymbolTable_IsConst (actual)))
    {
      /* avoid dangling else.  */
      return m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (ParamType), SymbolConversion_Mod2Gcc (actual));
    }
  else if ((SymbolTable_IsConst (actual)) && ((M2Base_IsOrdinalType (ParamType)) || (M2System_IsSystemType (ParamType))))
    {
      /* avoid dangling else.  */
      return m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (ParamType), M2GenGCC_StringToChar (SymbolConversion_Mod2Gcc (actual), ParamType, actual), false);
    }
  else if ((SymbolTable_IsConstString (actual)) || (((OperandType != SymbolTable_NulSym) && (IsCoerceableParameter (OperandType))) && (OperandType != ParamType)))
    {
      /* avoid dangling else.  */
      return m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (ParamType), SymbolConversion_Mod2Gcc (actual), false);
    }
  else
    {
      /* avoid dangling else.  */
      return SymbolConversion_Mod2Gcc (actual);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckConstant - checks to see whether we should declare the constant.
*/

static tree CheckConstant (unsigned int tokenno, unsigned int des, unsigned int expr)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  if (SymbolTable_IsProcedure (expr))
    {
      return SymbolConversion_Mod2Gcc (expr);
    }
  else
    {
      return m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (des)), SymbolConversion_Mod2Gcc (expr));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeMakeAdr - code the function MAKEADR.
*/

static void CodeMakeAdr (unsigned int q, unsigned int op1, unsigned int op2, unsigned int op3)
{
  unsigned int r;
  unsigned int n;
  unsigned int type;
  M2Quads_QuadOperator op;
  tree bits;
  tree max;
  tree tmp;
  tree res;
  tree val;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  n = q;
  do {
    if (op1 > 0)
      {
        M2GCCDeclare_DeclareConstant (CurrentQuadToken, op3);
      }
    n = M2Quads_GetNextQuad (n);
    M2Quads_GetQuad (n, &op, &r, &op2, &op3);
  } while (! (op == M2Quads_FunctValueOp));
  n = q;
  M2Quads_GetQuad (n, &op, &op1, &op2, &op3);
  res = SymbolConversion_Mod2Gcc (r);
  max = m2expr_GetSizeOfInBits (SymbolConversion_Mod2Gcc (M2System_Address));
  bits = m2expr_GetIntegerZero (location);
  val = m2expr_GetPointerZero (location);
  do {
    location = M2LexBuf_TokenToLocation (CurrentQuadToken);
    if ((op == M2Quads_ParamOp) && (op1 > 0))
      {
        /* avoid gcc warning by using compound statement even if not strictly necessary.  */
        if ((SymbolTable_GetType (op3)) == SymbolTable_NulSym)
          {
            M2Error_WriteFormat0 ((const char *) "must supply typed constants to MAKEADR", 38);
          }
        else
          {
            type = SymbolTable_GetType (op3);
            tmp = m2convert_BuildConvert (location, m2type_GetPointerType (), SymbolConversion_Mod2Gcc (op3), false);
            if ((m2expr_CompareTrees (bits, m2expr_GetIntegerZero (location))) > 0)
              {
                tmp = m2expr_BuildLSL (location, tmp, bits, false);
              }
            bits = m2expr_BuildAdd (location, bits, m2expr_GetSizeOfInBits (SymbolConversion_Mod2Gcc (type)), false);
            val = m2expr_BuildLogicalOrAddress (location, val, tmp, false);
          }
      }
    M2Quads_SubQuad (n);
    n = M2Quads_GetNextQuad (n);
    M2Quads_GetQuad (n, &op, &op1, &op2, &op3);
  } while (! (op == M2Quads_FunctValueOp));
  if ((m2expr_CompareTrees (bits, max)) > 0)
    {
      M2MetaError_MetaErrorT0 (CurrentQuadToken, (const char *) "total number of bits specified as parameters to {%kMAKEADR} exceeds address width", 81);
    }
  M2Quads_SubQuad (n);
  m2statement_BuildAssignmentStatement (location, res, val);
}


/*
   CodeBuiltinFunction - attempts to inline a function. Currently it only
                         inlines the SYSTEM function MAKEADR.
*/

static void CodeBuiltinFunction (unsigned int q, unsigned int nth, unsigned int func, unsigned int parameter)
{
  if (nth == 0)
    {
      InitBuiltinSyms (M2LexBuf_BuiltinTokenNo);
      if (func == M2System_MakeAdr)
        {
          CodeMakeAdr (q, nth, func, parameter);
        }
    }
}


/*
   FoldMakeAdr - attempts to fold the function MAKEADR.
*/

static void FoldMakeAdr (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int q, unsigned int op1, unsigned int op2, unsigned int op3)
{
  bool resolved;
  unsigned int r;
  unsigned int n;
  M2Quads_QuadOperator op;
  unsigned int type;
  tree bits;
  tree max;
  tree tmp;
  tree val;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  resolved = true;
  n = q;
  r = op1;
  do {
    if (r > 0)
      {
        M2GCCDeclare_TryDeclareConstant (tokenno, op3);
        if (! (SymbolConversion_GccKnowsAbout (op3)))
          {
            resolved = false;
          }
      }
    n = M2Quads_GetNextQuad (n);
    M2Quads_GetQuad (n, &op, &r, &op2, &op3);
  } while (! (op == M2Quads_FunctValueOp));
  if (resolved && (SymbolTable_IsConst (r)))
    {
      n = q;
      M2Quads_GetQuad (n, &op, &op1, &op2, &op3);
      max = m2expr_GetSizeOfInBits (SymbolConversion_Mod2Gcc (M2System_Address));
      bits = m2expr_GetIntegerZero (location);
      val = m2expr_GetPointerZero (location);
      do {
        location = M2LexBuf_TokenToLocation (tokenno);
        if ((op == M2Quads_ParamOp) && (op1 > 0))
          {
            /* avoid gcc warning by using compound statement even if not strictly necessary.  */
            if ((SymbolTable_GetType (op3)) == SymbolTable_NulSym)
              {
                M2MetaError_MetaErrorT0 (tokenno, (const char *) "constants passed to {%kMAKEADR} must be typed", 45);
              }
            else
              {
                type = SymbolTable_GetType (op3);
                tmp = m2convert_BuildConvert (location, m2type_GetPointerType (), SymbolConversion_Mod2Gcc (op3), false);
                if ((m2expr_CompareTrees (bits, m2expr_GetIntegerZero (location))) > 0)
                  {
                    tmp = m2expr_BuildLSL (location, tmp, bits, false);
                  }
                bits = m2expr_BuildAdd (location, bits, m2expr_GetSizeOfInBits (SymbolConversion_Mod2Gcc (type)), false);
                val = m2expr_BuildLogicalOrAddress (location, val, tmp, false);
              }
          }
        M2Quads_SubQuad (n);
        n = M2Quads_GetNextQuad (n);
        M2Quads_GetQuad (n, &op, &op1, &op2, &op3);
      } while (! (op == M2Quads_FunctValueOp));
      if ((m2expr_CompareTrees (bits, max)) > 0)
        {
          M2MetaError_MetaErrorT0 (tokenno, (const char *) "total number of bits specified as parameters to {%kMAKEADR} exceeds address width", 81);
        }
      SymbolTable_PutConst (r, M2System_Address);
      SymbolConversion_AddModGcc (r, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (M2System_Address), val));
      (*p.proc) (r);
      NoChange = false;
      M2Quads_SubQuad (n);
    }
}


/*
   doParam - builds the parameter, op3, which is to be passed to
             procedure, op2.  The number of the parameter is op1.
*/

static void doParam (unsigned int quad, unsigned int paramtok, unsigned int op1, unsigned int op2, unsigned int op3)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (paramtok);
  M2GCCDeclare_DeclareConstant (paramtok, op3);
  M2GCCDeclare_DeclareConstructor (paramtok, quad, op3);
  m2statement_BuildParam (location, CheckConvertCoerceParameter (paramtok, op1, op2, op3));
}


/*
   FoldBuiltin - attempts to fold the gcc builtin function.
*/

static void FoldBuiltin (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int q)
{
  bool resolved;
  unsigned int procedure;
  unsigned int r;
  unsigned int n;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  M2Quads_QuadOperator op;
  tree val;
  tree call;
  location_t location;

  M2Quads_GetQuad (q, &op, &op1, &op2, &op3);
  resolved = true;
  procedure = SymbolTable_NulSym;
  n = q;
  r = op1;
  do {
    if (r > 0)
      {
        M2GCCDeclare_TryDeclareConstant (tokenno, op3);
        if (! (SymbolConversion_GccKnowsAbout (op3)))
          {
            resolved = false;
          }
      }
    if ((op == M2Quads_CallOp) && (! (SymbolTable_IsProcedure (op3))))
      {
        /* Cannot fold an indirect procedure function call.  */
        resolved = false;
      }
    n = M2Quads_GetNextQuad (n);
    M2Quads_GetQuad (n, &op, &r, &op2, &op3);
  } while (! (op == M2Quads_FunctValueOp));
  if (resolved && (SymbolTable_IsConst (r)))
    {
      n = q;
      M2Quads_GetQuad (n, &op, &op1, &op2, &op3);
      do {
        if ((op == M2Quads_ParamOp) && (op1 > 0))
          {
            doParam (tokenno, n, op1, op2, op3);
          }
        else if (op == M2Quads_CallOp)
          {
            /* avoid dangling else.  */
            procedure = op3;
          }
        M2Quads_SubQuad (n);
        n = M2Quads_GetNextQuad (n);
        M2Quads_GetQuad (n, &op, &op1, &op2, &op3);
      } while (! (op == M2Quads_FunctValueOp));
      if (SymbolTable_IsProcedureBuiltinAvailable (procedure))
        {
          location = M2LexBuf_TokenToLocation (tokenno);
          call = UseBuiltin (tokenno, procedure);
          val = m2statement_BuildFunctValue (location, call);
          val = m2expr_FoldAndStrip (val);
          SymbolTable_PutConst (r, SymbolTable_GetType (procedure));
          SymbolConversion_AddModGcc (r, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (procedure)), val));
          (*p.proc) (r);
          m2statement_SetLastFunction (NULL);
        }
      else
        {
          M2MetaError_MetaErrorT1 (tokenno, (const char *) "gcc builtin procedure {%1Ead} cannot be used in a constant expression", 69, procedure);
        }
      NoChange = false;
      M2Quads_SubQuad (n);
    }
}


/*
   FoldBuiltinFunction - attempts to inline a function. Currently it only
                         inlines the SYSTEM function MAKEADR.
*/

static void FoldBuiltinFunction (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int q, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (op1 == 0)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      /* Must be a function as op1 is the return parameter.  */
      if (op3 == M2System_MakeAdr)
        {
          FoldMakeAdr (tokenno, p, q, op1, op2, op3);
        }
      else if ((SymbolTable_IsProcedure (op3)) && (SymbolTable_IsProcedureBuiltinAvailable (op3)))
        {
          /* avoid dangling else.  */
          FoldBuiltin (tokenno, p, q);
        }
    }
}


/*
   CodeParam - builds a parameter list.
               Note that we can ignore ModeOfAddr as any lvalue will
               have been created in a preceeding quadruple.
*/

static void CodeParam (unsigned int quad)
{
  unsigned int nopos;
  unsigned int procedure;
  unsigned int parameter;
  unsigned int parampos;
  unsigned int nth;
  bool compatible;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &parampos, &op, &nth, &procedure, &parameter, &overflow, &constExpr, &nopos, &nopos, &nopos);
  compatible = true;
  if (nth == 0)
    {
      CodeBuiltinFunction (quad, nth, procedure, parameter);
    }
  else
    {
      if (M2Options_StrictTypeChecking)
        {
          if (nth <= (SymbolTable_NoOfParamAny (procedure)))
            {
              compatible = M2Check_ParameterTypeCompatible (parampos, (const char *) "parameter incompatibility when attempting to pass actual parameter {%2ad} to a {%kVAR} formal parameter {%3Ead} during call to procedure {%1ad}", 143, procedure, SymbolTable_GetNthParamAny (procedure, nth), parameter, nth, SymbolTable_IsVarParamAny (procedure, nth));
            }
        }
      if (((nth <= (SymbolTable_NoOfParamAny (procedure))) && (SymbolTable_IsVarParamAny (procedure, nth))) && (SymbolTable_IsConst (parameter)))
        {
          M2MetaError_MetaErrorT1 (parampos, (const char *) "cannot pass a constant {%1Ead} as a VAR parameter", 49, parameter);
        }
      else if (SymbolTable_IsAModula2Type (parameter))
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT2 (parampos, (const char *) "cannot pass a type {%1Ead} as a parameter to procedure {%2ad}", 61, parameter, procedure);
        }
      else if (compatible)
        {
          /* avoid dangling else.  */
          doParam (quad, parampos, nth, procedure, parameter);
        }
    }
}


/*
   Replace - replace the entry for sym in the double entry bookkeeping with sym/tree.
*/

static void Replace (unsigned int sym, tree gcc)
{
  if (SymbolConversion_GccKnowsAbout (sym))
    {
      SymbolConversion_RemoveMod2Gcc (sym);
    }
  SymbolConversion_AddModGcc (sym, gcc);
}


/*
   CodeFunctValue - retrieves the function return value and assigns it
                    into a variable.
*/

static void CodeFunctValue (location_t location, unsigned int op1)
{
  tree call;
  tree value;

  /* 
      operator : FunctValueOp
      op1 : The Returned Variable
      op3 : The Function Returning this Variable
  */
  if (M2SSA_EnableSSA && (SymbolTable_IsVariableSSA (op1)))
    {
      call = m2statement_GetLastFunction ();
      m2statement_SetLastFunction (NULL);
      Replace (op1, call);
    }
  else
    {
      value = m2statement_BuildFunctValue (location, SymbolConversion_Mod2Gcc (op1));
      /* AddStatement (location, CheckCleanup (location, op3, value, call))  */
      m2type_AddStatement (location, value);
    }
}


/*
   FoldStringLength -
*/

static void FoldStringLength (unsigned int quad, M2GCCDeclare_WalkAction p)
{
  M2Quads_QuadOperator op;
  unsigned int des;
  unsigned int none;
  unsigned int expr;
  unsigned int stroppos;
  unsigned int despos;
  unsigned int nonepos;
  unsigned int exprpos;
  bool constExpr;
  bool overflowChecking;
  location_t location;

  M2Quads_GetQuadOtok (quad, &stroppos, &op, &des, &none, &expr, &overflowChecking, &constExpr, &despos, &nonepos, &exprpos);
  if ((IsConstStr (expr)) && (IsConstStrKnown (expr)))
    {
      location = M2LexBuf_TokenToLocation (stroppos);
      M2ALU_PushCard (SymbolTable_GetStringLength (exprpos, expr));
      SymbolConversion_AddModGcc (des, m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (des)), M2ALU_PopIntegerTree (), false));
      RemoveQuad (p, des, quad);
    }
}


/*
   FoldStringConvertM2nul - attempt to assign the des with the string contents from expr.
                            It also marks the des as a m2 string which must be nul terminated.
                            The front end uses double book keeping and it is easier to have
                            different m2 string symbols each of which map onto a slightly different
                            gcc string tree.
*/

static void FoldStringConvertM2nul (unsigned int quad, M2GCCDeclare_WalkAction p)
{
  M2Quads_QuadOperator op;
  unsigned int des;
  unsigned int none;
  unsigned int expr;
  unsigned int stroppos;
  unsigned int despos;
  unsigned int nonepos;
  unsigned int exprpos;
  DynamicStrings_String s;
  bool constExpr;
  bool overflowChecking;

  M2Quads_GetQuadOtok (quad, &stroppos, &op, &des, &none, &expr, &overflowChecking, &constExpr, &despos, &nonepos, &exprpos);
  if ((IsConstStr (expr)) && (IsConstStrKnown (expr)))
    {
      s = GetStr (exprpos, expr);
      SymbolTable_PutConstStringKnown (stroppos, des, NameKey_makekey (DynamicStrings_string (s)), false, true);
      M2GCCDeclare_TryDeclareConstant (despos, des);
      (*p.proc) (des);
      NoChange = false;
      M2Quads_SubQuad (quad);
      s = DynamicStrings_KillString (s);
    }
}


/*
   FoldStringConvertCnul -attempt to assign the des with the string contents from expr.
                          It also marks the des as a C string which must be nul terminated.
*/

static void FoldStringConvertCnul (unsigned int quad, M2GCCDeclare_WalkAction p)
{
  M2Quads_QuadOperator op;
  unsigned int des;
  unsigned int none;
  unsigned int expr;
  unsigned int stroppos;
  unsigned int despos;
  unsigned int nonepos;
  unsigned int exprpos;
  DynamicStrings_String s;
  bool constExpr;
  bool overflowChecking;

  M2Quads_GetQuadOtok (quad, &stroppos, &op, &des, &none, &expr, &overflowChecking, &constExpr, &despos, &nonepos, &exprpos);
  if ((IsConstStr (expr)) && (IsConstStrKnown (expr)))
    {
      s = GetStr (exprpos, expr);
      SymbolTable_PutConstStringKnown (stroppos, des, NameKey_makekey (DynamicStrings_string (s)), true, true);
      M2GCCDeclare_TryDeclareConstant (despos, des);
      (*p.proc) (des);
      NoChange = false;
      M2Quads_SubQuad (quad);
      s = DynamicStrings_KillString (s);
    }
}

static void CodeAddr (unsigned int tokenno, unsigned int quad, unsigned int op1, unsigned int op3)
{
  tree value;
  unsigned int type;
  location_t location;

  /* 
   Addr Operator - generates the address of a variable (op1 = &op3).
  */
  if ((SymbolTable_IsConst (op3)) && (! (SymbolTable_IsConstString (op3))))
    {
      M2MetaError_MetaErrorT1 (tokenno, (const char *) "error in expression, trying to find the address of a constant {%1Ead}", 69, op3);
    }
  else
    {
      if ((SymbolTable_IsConstString (op3)) && (! (SymbolTable_IsConstStringKnown (op3))))
        {
          M2Printf_printf1 ((const char *) "failure in quad: %d\\n", 21, (const unsigned char *) &quad, (sizeof (quad)-1));
        }
      location = M2LexBuf_TokenToLocation (tokenno);
      type = SymbolTable_SkipType (SymbolTable_GetType (op3));
      M2GCCDeclare_DeclareConstant (tokenno, op3);  /* We might be asked to find the address of a constant string.  */
      M2GCCDeclare_DeclareConstructor (tokenno, quad, op3);  /* We might be asked to find the address of a constant string.  */
      if (((SymbolTable_IsConst (op3)) && (type == M2Base_Char)) || (SymbolTable_IsConstString (op3)))
        {
          value = m2decl_BuildStringConstant (const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetString (op3)))), static_cast<int> (SymbolTable_GetStringLength (tokenno, op3)));
        }
      else
        {
          value = SymbolConversion_Mod2Gcc (op3);
        }
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (op1), m2expr_BuildAddr (location, value, false));
    }
}

static void stop (void)
{
}

static void CheckStop (unsigned int q)
{
  if (q == 3827)
    {
      stop ();
    }
}

static void FoldBecomes (M2GCCDeclare_WalkAction p, M2BasicBlock_BasicBlock bb, unsigned int quad)
{
  M2Quads_QuadOperator op;
  unsigned int des;
  unsigned int op2;
  unsigned int expr;

  /* 
------------------------------------------------------------------------------
   := Operator
------------------------------------------------------------------------------
   Sym1<I> := Sym3<I>           := produces a constant
  */
  if (DeclaredOperandsBecomes (p, quad))
    {
      if ((! (M2Quads_IsConditionalBooleanQuad (quad))) || (M2BasicBlock_IsBasicBlockFirst (bb)))
        {
          if (TypeCheckBecomes (p, quad))
            {
              PerformFoldBecomes (p, quad);
            }
        }
    }
}


/*
   TryDeclareConst -
*/

static void TryDeclareConst (unsigned int tokenno, unsigned int sym)
{
  /* Check whether expr is a constant literal and if so declare it.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, sym);
  /* Check whether expr is a const constructor and if so declare it.  */
  M2GCCDeclare_TryDeclareConstructor (tokenno, sym);
}


/*
   RemoveQuad - remove quad and ensure p (des) is called.
*/

static void RemoveQuad (M2GCCDeclare_WalkAction p, unsigned int des, unsigned int quad)
{
  (*p.proc) (des);
  NoChange = false;
  M2Quads_SubQuad (quad);
}


/*
   DeclaredOperandsBecomes -
*/

static bool DeclaredOperandsBecomes (M2GCCDeclare_WalkAction p, unsigned int quad)
{
  unsigned int des;
  unsigned int op2;
  unsigned int expr;
  bool constExpr;
  bool overflowChecking;
  unsigned int despos;
  unsigned int op2pos;
  unsigned int exprpos;
  unsigned int becomespos;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &becomespos, &op, &des, &op2, &expr, &overflowChecking, &constExpr, &despos, &op2pos, &exprpos);
  M2Debug_Assert (op2pos == M2LexBuf_UnknownTokenNo);
  TryDeclareConst (exprpos, expr);
  if ((SymbolTable_IsConst (des)) && (IsConstant (expr)))
    {
      /* Constant folding taking place, but have we resolved op3 yet?  */
      if (SymbolConversion_GccKnowsAbout (expr))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          /* RemoveSSAPlaceholder (quad, des) ;  */
          if (SymbolConversion_GccKnowsAbout (des))
            {
              M2MetaError_MetaErrorT1 (despos, (const char *) "constant {%1Ead} should not be reassigned", 41, des);
              RemoveQuad (p, des, quad);
              return false;
            }
          else
            {
              return true;
            }
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TypeCheckBecomes - returns TRUE if the type check succeeds.
*/

static bool TypeCheckBecomes (M2GCCDeclare_WalkAction p, unsigned int quad)
{
  unsigned int des;
  unsigned int op2;
  unsigned int expr;
  bool constExpr;
  bool overflowChecking;
  unsigned int despos;
  unsigned int op2pos;
  unsigned int exprpos;
  unsigned int becomespos;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &becomespos, &op, &des, &op2, &expr, &overflowChecking, &constExpr, &despos, &op2pos, &exprpos);
  M2Debug_Assert (op2pos == M2LexBuf_UnknownTokenNo);
  if (M2Options_StrictTypeChecking && (! (M2Check_AssignmentTypeCompatible (despos, (const char *) "", 0, des, expr, true))))
    {
      M2MetaError_MetaErrorT2 (M2LexBuf_MakeVirtualTok (becomespos, despos, exprpos), (const char *) "assignment check caught mismatch between {%1Ead} and {%2ad}", 59, des, expr);
      RemoveQuad (p, des, quad);
      return false;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PerformFoldBecomes - attempts to fold quad.  It propagates constant strings
                        and attempts to declare des providing it is a constant
                        and expr is resolved.
*/

static void PerformFoldBecomes (M2GCCDeclare_WalkAction p, unsigned int quad)
{
  unsigned int des;
  unsigned int op2;
  unsigned int expr;
  bool constExpr;
  bool overflowChecking;
  unsigned int despos;
  unsigned int op2pos;
  unsigned int exprpos;
  unsigned int becomespos;
  unsigned int virtpos;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &becomespos, &op, &des, &op2, &expr, &overflowChecking, &constExpr, &despos, &op2pos, &exprpos);
  M2Debug_Assert (op2pos == M2LexBuf_UnknownTokenNo);
  if ((SymbolTable_IsConst (des)) && (SymbolTable_IsConstString (expr)))
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsConstStringKnown (expr)) && (! (SymbolTable_IsConstStringKnown (des))))
        {
          SymbolTable_CopyConstString (exprpos, des, expr);
        }
    }
  else if ((SymbolTable_GetType (des)) == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      M2Debug_Assert ((SymbolTable_GetType (expr)) != SymbolTable_NulSym);
      SymbolTable_PutConst (des, SymbolTable_GetType (expr));
    }
  if ((SymbolTable_GetType (expr)) == SymbolTable_NulSym)
    {
      M2ALU_CheckOrResetOverflow (exprpos, SymbolConversion_Mod2Gcc (expr), M2Quads_MustCheckOverflow (quad));
      SymbolConversion_AddModGcc (des, SymbolConversion_Mod2Gcc (expr));
    }
  else
    {
      if (! (SymbolConversion_GccKnowsAbout (SymbolTable_GetType (des))))
        {
          return;
        }
      if (SymbolTable_IsProcedure (expr))
        {
          SymbolConversion_AddModGcc (des, m2convert_BuildConvert (M2LexBuf_TokenToLocation (exprpos), SymbolConversion_Mod2Gcc (SymbolTable_GetType (des)), m2expr_BuildAddr (M2LexBuf_TokenToLocation (exprpos), SymbolConversion_Mod2Gcc (expr), false), true));
        }
      else if (SymbolTable_IsValueSolved (expr))
        {
          /* avoid dangling else.  */
          SymbolTable_PushValue (expr);
          if (M2ALU_IsValueTypeReal ())
            {
              M2ALU_CheckOrResetOverflow (exprpos, M2ALU_PopRealTree (), M2Quads_MustCheckOverflow (quad));
              SymbolTable_PushValue (expr);
              SymbolConversion_AddModGcc (des, M2ALU_PopRealTree ());
            }
          else if (M2ALU_IsValueTypeSet ())
            {
              /* avoid dangling else.  */
              SymbolTable_PopValue (des);
              SymbolTable_PutConstSet (des);
            }
          else if (((M2ALU_IsValueTypeConstructor ()) || (M2ALU_IsValueTypeArray ())) || (M2ALU_IsValueTypeRecord ()))
            {
              /* avoid dangling else.  */
              SymbolTable_PopValue (des);
              SymbolTable_PutConstructor (des);
            }
          else if (M2ALU_IsValueTypeComplex ())
            {
              /* avoid dangling else.  */
              M2ALU_CheckOrResetOverflow (exprpos, M2ALU_PopComplexTree (), M2Quads_MustCheckOverflow (quad));
              SymbolTable_PushValue (expr);
              SymbolTable_PopValue (des);
            }
          else
            {
              /* avoid dangling else.  */
              M2ALU_CheckOrResetOverflow (exprpos, M2ALU_PopIntegerTree (), M2Quads_MustCheckOverflow (quad));
              if ((SymbolTable_GetType (des)) == SymbolTable_NulSym)
                {
                  SymbolTable_PushValue (expr);
                  SymbolConversion_AddModGcc (des, M2ALU_PopIntegerTree ());
                }
              else
                {
                  virtpos = M2LexBuf_MakeVirtualTok (becomespos, despos, exprpos);
                  SymbolTable_PushValue (expr);
                  SymbolConversion_AddModGcc (des, m2convert_BuildConvert (M2LexBuf_TokenToLocation (virtpos), SymbolConversion_Mod2Gcc (SymbolTable_GetType (des)), M2ALU_PopIntegerTree (), false));
                }
            }
        }
      else
        {
          /* avoid dangling else.  */
          virtpos = M2LexBuf_MakeVirtualTok (becomespos, despos, exprpos);
          M2ALU_CheckOrResetOverflow (exprpos, SymbolConversion_Mod2Gcc (des), M2Quads_MustCheckOverflow (quad));
          SymbolConversion_AddModGcc (des, m2convert_BuildConvert (M2LexBuf_TokenToLocation (virtpos), SymbolConversion_Mod2Gcc (SymbolTable_GetType (des)), m2decl_DeclareKnownConstant (M2LexBuf_TokenToLocation (virtpos), SymbolConversion_Mod2Gcc (SymbolTable_GetType (expr)), SymbolConversion_Mod2Gcc (expr)), false));
        }
    }
  RemoveQuad (p, des, quad);
  M2Debug_Assert ((m2block_RememberConstant (SymbolConversion_Mod2Gcc (des))) == (SymbolConversion_Mod2Gcc (des)));
}


/*
   CodeTry - starts building a GCC 'try' node.
*/

static void CodeTry (void)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  handlerBlock = NULL;
  tryBlock = m2except_BuildTryBegin (location);
}


/*
   CodeThrow - builds a GCC 'throw' node.
*/

static void CodeThrow (unsigned int value)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if (value == SymbolTable_NulSym)
    {
      m2type_AddStatement (location, m2except_BuildThrow (location, (tree) (NULL)));
    }
  else
    {
      M2GCCDeclare_DeclareConstant (CurrentQuadToken, value);  /* Checks to see whether it is a constant and declares it.  */
      m2type_AddStatement (location, m2except_BuildThrow (location, m2convert_BuildConvert (location, m2type_GetIntegerType (), SymbolConversion_Mod2Gcc (value), false)));  /* Checks to see whether it is a constant and declares it.  */
    }
}

static void CodeRetry (unsigned int destQuad)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (destQuad))));
}

static void CodeCatchBegin (void)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  m2except_BuildTryEnd (tryBlock);
  handlerBlock = m2except_BuildCatchBegin (location);
}

static void CodeCatchEnd (void)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  tryBlock = m2except_BuildCatchEnd (location, handlerBlock, tryBlock);
  m2type_AddStatement (location, tryBlock);
}


/*
   DescribeTypeError -
*/

static void DescribeTypeError (unsigned int token, unsigned int op1, unsigned int op2)
{
  M2MetaError_MetaErrorT2 (token, (const char *) "incompatible set types in assignment, assignment between {%1ERad} and {%2ad}", 76, op1, op2);
  M2MetaError_MetaError2 ((const char *) "set types are {%1CDtsad} and {%2Dtsad}", 38, op1, op2);
}


/*
   DefaultConvertGM2 - provides a simple mapping between
                       front end data types and GCC equivalents.
                       This is only used to aid assignment of
                       typed constants.
*/

static tree DefaultConvertGM2 (unsigned int sym)
{
  sym = SymbolTable_SkipType (sym);
  if (sym == M2Bitset_Bitset)
    {
      return m2type_GetWordType ();
    }
  else
    {
      return SymbolConversion_Mod2Gcc (sym);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldConstBecomes - returns a Tree containing op3.
                      The tree will have been folded and
                      type converted if necessary.
*/

static tree FoldConstBecomes (unsigned int tokenno, unsigned int op1, unsigned int op3)
{
  tree t;
  tree type;
  location_t location;

  if ((SymbolTable_IsConstSet (op3)) || (((SymbolTable_SkipType (SymbolTable_GetType (op3))) != SymbolTable_NulSym) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (op3))))))
    {
      if ((SymbolTable_SkipType (SymbolTable_GetTypeMode (op1))) != (SymbolTable_SkipType (SymbolTable_GetTypeMode (op3))))
        {
          DescribeTypeError (tokenno, op1, op3);
          /* Assigning an errant op3 might ICE, therefore it is safer to return op1.  */
          return SymbolConversion_Mod2Gcc (op1);
        }
    }
  location = M2LexBuf_TokenToLocation (tokenno);
  M2GCCDeclare_TryDeclareConstant (tokenno, op3);
  t = SymbolConversion_Mod2Gcc (op3);
  M2Debug_Assert (t != NULL);
  if (IsConstant (op3))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsProcedure (op3))
        {
          return t;
        }
      else if (((! (SymbolTable_IsConstString (op3))) && (! (SymbolTable_IsConstSet (op3)))) && ((SymbolTable_SkipType (SymbolTable_GetType (op3))) != (SymbolTable_SkipType (SymbolTable_GetType (op1)))))
        {
          /* avoid dangling else.  */
          type = DefaultConvertGM2 (SymbolTable_GetType (op1));  /* do we need this now? --fixme--  */
          t = m2convert_ConvertConstantAndCheck (location, type, t);  /* do we need this now? --fixme--  */
        }
      else if ((SymbolTable_GetType (op1)) != SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          t = M2GenGCC_StringToChar (SymbolConversion_Mod2Gcc (op3), SymbolTable_GetType (op1), op3);
        }
    }
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkArrayElements - return TRUE if des or expr are not arrays.
                        If they are arrays and have different number of
                        elements return FALSE, otherwise TRUE.
*/

static bool checkArrayElements (unsigned int des, unsigned int expr, unsigned int virtpos, unsigned int despos, unsigned int exprpos)
{
  tree e1;
  tree e3;
  unsigned int t1;
  unsigned int t3;

  t1 = SymbolTable_GetType (des);
  t3 = SymbolTable_GetType (expr);
  if ((((t1 != SymbolTable_NulSym) && (t3 != SymbolTable_NulSym)) && (SymbolTable_IsArray (SymbolTable_SkipType (SymbolTable_GetType (expr))))) && (SymbolTable_IsArray (SymbolTable_SkipType (SymbolTable_GetType (des)))))
    {
      /* both arrays continue checking  */
      e1 = m2type_GetArrayNoOfElements (M2LexBuf_TokenToLocation (despos), SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (des))));
      e3 = m2type_GetArrayNoOfElements (M2LexBuf_TokenToLocation (exprpos), SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (expr))));
      if ((m2expr_CompareTrees (e1, e3)) != 0)
        {
          M2MetaError_MetaErrorT2 (virtpos, (const char *) "not allowed to assign array {%2Ead} to {%1ad} as they have a different number of elements", 89, des, expr);
          return false;
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeInitAddress -
*/

static void CodeInitAddress (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  location_t location;

  M2GCCDeclare_DeclareConstant (CurrentQuadToken, op3);  /* checks to see whether it is a constant and declares it  */
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, op3);  /* checks to see whether it is a constant and declares it  */
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  M2Debug_Assert (op2 == SymbolTable_NulSym);
  M2Debug_Assert ((SymbolTable_GetMode (op1)) == SymbolTable_LeftValue);
  m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (op1), m2convert_BuildConvert (location, m2type_GetPointerType (), SymbolConversion_Mod2Gcc (op3), false));
}


/*
   checkRecordTypes - returns TRUE if des is not a record or if the record
                      is the same type as expr.
*/

static bool checkRecordTypes (unsigned int des, unsigned int expr, unsigned int virtpos)
{
  unsigned int t1;
  unsigned int t2;

  if (((SymbolTable_GetType (des)) == SymbolTable_NulSym) || ((SymbolTable_GetMode (des)) == SymbolTable_LeftValue))
    {
      return true;
    }
  else
    {
      t1 = SymbolTable_SkipType (SymbolTable_GetType (des));
      if (SymbolTable_IsRecord (t1))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if ((SymbolTable_GetType (expr)) == SymbolTable_NulSym)
            {
              M2MetaError_MetaErrorT2 (virtpos, (const char *) "cannot assign an operand of type {%1Ets} to a record type {%2tsa}", 65, expr, des);
              return false;
            }
          else
            {
              t2 = SymbolTable_SkipType (SymbolTable_GetType (expr));
              if (t1 == t2)
                {
                  return true;
                }
              else
                {
                  M2MetaError_MetaErrorT2 (virtpos, (const char *) "cannot assign an operand of type {%1ts} to a record type {%2tsa}", 64, expr, des);
                  return false;
                }
            }
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkIncorrectMeta - checks to see if des and expr are assignment compatible is allows
                        generic system types to be assigned.
*/

static bool checkIncorrectMeta (unsigned int des, unsigned int expr, unsigned int virtpos)
{
  unsigned int t1;
  unsigned int t2;

  t1 = SymbolTable_SkipType (SymbolTable_GetType (des));
  t2 = SymbolTable_SkipType (SymbolTable_GetType (expr));
  if ((((t1 == SymbolTable_NulSym) || ((SymbolTable_GetMode (des)) == SymbolTable_LeftValue)) || (t2 == SymbolTable_NulSym)) || ((SymbolTable_GetMode (expr)) == SymbolTable_LeftValue))
    {
      return true;
    }
  else if (((t1 != t2) && (! (M2System_IsGenericSystemType (t1)))) && (! (M2System_IsGenericSystemType (t2))))
    {
      /* avoid dangling else.  */
      if (((SymbolTable_IsArray (t1)) || (SymbolTable_IsSet (t1))) || (SymbolTable_IsRecord (t1)))
        {
          if (! (M2Base_IsAssignmentCompatible (t1, t2)))
            {
              ErrorMessageDecl (virtpos, (const char *) "illegal assignment error between {%1Etad} and {%2tad}", 53, des, expr, true);
              return false;
            }
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkBecomes - returns TRUE if the checks pass.
*/

static bool checkBecomes (unsigned int des, unsigned int expr, unsigned int virtpos, unsigned int despos, unsigned int exprpos)
{
  if (((! (checkArrayElements (des, expr, virtpos, despos, exprpos))) || (! (checkRecordTypes (des, expr, virtpos)))) || (! (checkIncorrectMeta (des, expr, virtpos))))
    {
      return false;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkDeclare - checks to see if sym is declared and if it is not then declare it.
*/

static void checkDeclare (unsigned int sym)
{
  if (((SymbolTable_IsTemporary (sym)) && (SymbolTable_IsVariableSSA (sym))) && (! (SymbolConversion_GccKnowsAbout (sym))))
    {
      M2GCCDeclare_DeclareLocalVariable (sym);
    }
}


/*
   PerformCodeBecomes -
*/

static void PerformCodeBecomes (location_t location, unsigned int virtpos, unsigned int des, unsigned int expr)
{
  tree destree;
  tree exprtree;

  destree = SymbolConversion_Mod2Gcc (des);
  exprtree = FoldConstBecomes (virtpos, des, expr);
  if ((SymbolTable_IsVar (des)) && (SymbolTable_IsVariableSSA (des)))
    {
      Replace (des, exprtree);
    }
  else if (m2type_IsGccStrictTypeEquivalent (destree, exprtree))
    {
      /* avoid dangling else.  */
      m2statement_BuildAssignmentStatement (location, destree, exprtree);
    }
  else
    {
      /* avoid dangling else.  */
      m2statement_CopyByField (location, destree, exprtree);
    }
}

static void CodeBecomes (unsigned int quad)
{
  bool constExpr;
  bool overflowChecking;
  M2Quads_QuadOperator op;
  unsigned int des;
  unsigned int op2;
  unsigned int expr;
  unsigned int virtpos;
  unsigned int becomespos;
  unsigned int despos;
  unsigned int op2pos;
  unsigned int exprpos;
  tree length;
  tree exprt;
  location_t location;

  /* 
------------------------------------------------------------------------------
   := Operator
------------------------------------------------------------------------------
   Sym1<I> := Sym3<I>           := produces a constant
   Sym1<O> := Sym3<O>           := has the effect Mem[Sym1<I>] := Mem[Sym3<I>]
  */
  M2Quads_GetQuadOtok (quad, &becomespos, &op, &des, &op2, &expr, &overflowChecking, &constExpr, &despos, &op2pos, &exprpos);
  M2Debug_Assert (op2pos == M2LexBuf_UnknownTokenNo);
  M2GCCDeclare_DeclareConstant (exprpos, expr);  /* Check to see whether expr is a constant and declare it.  */
  M2GCCDeclare_DeclareConstructor (exprpos, quad, expr);  /* Check to see whether expr is a constant and declare it.  */
  virtpos = M2LexBuf_MakeVirtualTok (becomespos, despos, exprpos);
  location = M2LexBuf_TokenToLocation (virtpos);
  if (M2Options_StrictTypeChecking && (! (M2Check_AssignmentTypeCompatible (virtpos, (const char *) "", 0, des, expr, true))))
    {
      ErrorMessageDecl (virtpos, (const char *) "assignment check caught mismatch between {%1Ead} and {%2ad}", 59, des, expr, true);
    }
  if ((SymbolTable_IsConstString (expr)) && (! (SymbolTable_IsConstStringKnown (expr))))
    {
      M2MetaError_MetaErrorT2 (virtpos, (const char *) "internal error: CodeBecomes {%1Aad} in quad {%2n}", 49, des, quad);
    }
  if ((SymbolTable_IsConst (des)) && (! (SymbolConversion_GccKnowsAbout (des))))
    {
      M2GCCDeclare_ConstantKnownAndUsed (des, CheckConstant (virtpos, des, expr));
    }
  else if ((SymbolTable_IsConstString (expr)) && ((SymbolTable_SkipTypeAndSubrange (SymbolTable_GetType (des))) != M2Base_Char))
    {
      /* avoid dangling else.  */
      checkDeclare (des);
      if (! (M2GenGCC_PrepareCopyString (becomespos, &length, &exprt, expr, SymbolTable_SkipType (SymbolTable_GetType (des)))))
        {
          ErrorMessageDecl (virtpos, (const char *) "string constant {%1Ea} is too large to be assigned to the array {%2ad}", 70, expr, des, true);
        }
      m2type_AddStatement (location, MaybeDebugBuiltinMemcpy (location, m2expr_BuildAddr (location, SymbolConversion_Mod2Gcc (des), false), m2expr_BuildAddr (location, exprt, false), length));
    }
  else
    {
      /* avoid dangling else.  */
      if ((((M2System_IsGenericSystemType (SymbolTable_SkipType (SymbolTable_GetType (des)))) != (M2System_IsGenericSystemType (SymbolTable_SkipType (SymbolTable_GetType (expr))))) || (((SymbolTable_IsUnbounded (SymbolTable_SkipType (SymbolTable_GetType (des)))) && (SymbolTable_IsUnbounded (SymbolTable_SkipType (SymbolTable_GetType (expr))))) && ((M2System_IsGenericSystemType (SymbolTable_SkipType (SymbolTable_GetType (SymbolTable_GetType (des))))) != (M2System_IsGenericSystemType (SymbolTable_SkipType (SymbolTable_GetType (SymbolTable_GetType (expr)))))))) && (! (IsConstant (expr))))
        {
          checkDeclare (des);
          m2type_AddStatement (location, MaybeDebugBuiltinMemcpy (location, m2expr_BuildAddr (location, SymbolConversion_Mod2Gcc (des), false), m2expr_BuildAddr (location, SymbolConversion_Mod2Gcc (expr), false), m2expr_BuildSize (location, SymbolConversion_Mod2Gcc (des), false)));
        }
      else
        {
          if (checkBecomes (des, expr, virtpos, despos, exprpos))
            {
              PerformCodeBecomes (location, virtpos, des, expr);
            }
          else
            {
              M2Quads_SubQuad (quad);  /* We don't want multiple errors for the quad.  */
            }
        }
    }
}


/*
   LValueToGenericPtrOrConvert - if sym is an lvalue then convert to pointer type
                                 else convert to type, type. Return the converted tree.
*/

static tree LValueToGenericPtrOrConvert (unsigned int sym, tree type)
{
  tree n;
  location_t location;

  n = SymbolConversion_Mod2Gcc (sym);
  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (sym));
  if (n == NULL)
    {
      M2Error_InternalError ((const char *) "expecting symbol to be resolved", 31);
    }
  if ((SymbolTable_GetMode (sym)) == SymbolTable_LeftValue)
    {
      n = m2convert_BuildConvert (location, m2type_GetPointerType (), n, false);
    }
  else
    {
      n = m2convert_BuildConvert (location, type, n, false);
    }
  return n;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldBinary - check whether we can fold the binop operation.
*/

static void FoldBinary (unsigned int tokenno, M2GCCDeclare_WalkAction p, m2expr_BuildBinProcedure binop, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  tree tl;
  tree tr;
  tree tv;
  tree resType;
  location_t location;

  /* firstly ensure that constant literals are declared  */
  M2GCCDeclare_TryDeclareConstant (tokenno, op3);
  M2GCCDeclare_TryDeclareConstant (tokenno, op2);
  location = M2LexBuf_TokenToLocation (tokenno);
  if ((SymbolTable_IsConst (op2)) && (SymbolTable_IsConst (op3)))
    {
      if ((SymbolConversion_GccKnowsAbout (op2)) && (SymbolConversion_GccKnowsAbout (op3)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          /* fine, we can take advantage of this and fold constants  */
          if (SymbolTable_IsConst (op1))
            {
              M2Debug_Assert ((M2Base_MixTypes (FindType (op3), FindType (op2), tokenno)) != SymbolTable_NulSym);
              SymbolTable_PutConst (op1, M2Base_MixTypes (FindType (op3), FindType (op2), tokenno));
              tl = M2GenGCC_LValueToGenericPtr (location, op2);
              tr = M2GenGCC_LValueToGenericPtr (location, op3);
              if ((SymbolTable_GetType (op1)) == SymbolTable_NulSym)
                {
                  resType = m2type_GetM2ZType ();
                }
              else
                {
                  resType = SymbolConversion_Mod2Gcc (SymbolTable_GetType (op1));
                }
              tl = m2convert_BuildConvert (location, resType, tl, false);
              tr = m2convert_BuildConvert (location, resType, tr, false);
              tv = (*binop.proc) (location, tl, tr, true);
              M2ALU_CheckOrResetOverflow (tokenno, tv, M2Quads_MustCheckOverflow (quad));
              SymbolConversion_AddModGcc (op1, m2decl_DeclareKnownConstant (location, resType, tv));
              (*p.proc) (op1);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
          /* we can still fold the expression, but not the assignment,
               however, we will not do this here but in CodeBinary
  */
        }
    }
}


/*
   ConvertBinaryOperands -
*/

static void ConvertBinaryOperands (location_t location, tree *tl, tree *tr, unsigned int type, unsigned int op2, unsigned int op3)
{
  (*tl) = NULL;
  (*tr) = NULL;
  if ((SymbolTable_GetMode (op2)) == SymbolTable_LeftValue)
    {
      (*tl) = M2GenGCC_LValueToGenericPtr (location, op2);
      type = M2System_Address;
    }
  if ((SymbolTable_GetMode (op3)) == SymbolTable_LeftValue)
    {
      (*tr) = M2GenGCC_LValueToGenericPtr (location, op3);
      type = M2System_Address;
    }
  if (((*tl) == NULL) && ((*tr) == NULL))
    {
      (*tl) = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (type), SymbolConversion_Mod2Gcc (op2), false);
      (*tr) = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (type), SymbolConversion_Mod2Gcc (op3), false);
    }
  else if ((*tl) == NULL)
    {
      /* avoid dangling else.  */
      (*tl) = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (type), SymbolConversion_Mod2Gcc (op2), false);
    }
  else if ((*tr) == NULL)
    {
      /* avoid dangling else.  */
      (*tr) = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (type), SymbolConversion_Mod2Gcc (op3), false);
    }
}


/*
   CodeBinaryCheck - encode a binary arithmetic operation.
*/

static void CodeBinaryCheck (m2expr_BuildBinCheckProcedure binop, unsigned int quad)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  unsigned int op1pos;
  unsigned int op2pos;
  unsigned int op3pos;
  unsigned int lowestType;
  unsigned int type;
  tree min;
  tree max;
  tree lowest;
  tree tv;
  tree tl;
  tree tr;
  location_t location;

  /* firstly ensure that constant literals are declared.  */
  M2Quads_GetQuadtok (quad, &op, &op1, &op2, &op3, &op1pos, &op2pos, &op3pos);
  M2GCCDeclare_DeclareConstant (op3pos, op3);
  M2GCCDeclare_DeclareConstant (op2pos, op2);
  location = M2LexBuf_TokenToLocation (op1pos);
  type = MixTypesBinary (op2, op3, op1pos, M2Quads_MustCheckOverflow (quad));
  ConvertBinaryOperands (location, &tl, &tr, type, op2, op3);
  lowestType = SymbolTable_GetLType (op1);
  lowest = SymbolConversion_Mod2Gcc (lowestType);
  if (M2Range_GetMinMax (CurrentQuadToken, lowestType, &min, &max))
    {
      tv = (*binop.proc) (location, tl, tr, lowest, min, max);
    }
  else
    {
      tv = (*binop.proc) (location, tl, tr, NULL, NULL, NULL);
    }
  M2ALU_CheckOrResetOverflow (op1pos, tv, M2Quads_MustCheckOverflow (quad));
  if (SymbolTable_IsConst (op1))
    {
      /* still have a constant which was not resolved, pass it to gcc.  */
      M2Debug_Assert ((M2Base_MixTypes (FindType (op3), FindType (op2), op3pos)) != SymbolTable_NulSym);
      SymbolTable_PutConst (op1, M2Base_MixTypes (FindType (op3), FindType (op2), op3pos));
      M2GCCDeclare_ConstantKnownAndUsed (op1, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (op3)), tv));
    }
  else
    {
      if (M2SSA_EnableSSA && (SymbolTable_IsVariableSSA (op1)))
        {
          Replace (op1, tv);
        }
      else
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (op1), tv);
        }
    }
}


/*
   MixTypesBinary - depending upon overflowCheck do not check pointer arithmetic.
*/

static unsigned int MixTypesBinary (unsigned int left, unsigned int right, unsigned int tokpos, bool overflowCheck)
{
  if (! overflowCheck && ((SymbolTable_IsPointer (SymbolTable_GetTypeMode (left))) || (SymbolTable_IsPointer (SymbolTable_GetTypeMode (right)))))
    {
      return M2System_Address;
    }
  else
    {
      return M2Base_MixTypesDecl (left, right, FindType (left), FindType (right), tokpos);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeBinary - encode a binary arithmetic operation.
*/

static void CodeBinary (m2expr_BuildBinProcedure binop, unsigned int quad)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  unsigned int op1pos;
  unsigned int op2pos;
  unsigned int op3pos;
  unsigned int type;
  tree tv;
  tree tl;
  tree tr;
  location_t location;

  /* firstly ensure that constant literals are declared  */
  M2Quads_GetQuadtok (quad, &op, &op1, &op2, &op3, &op1pos, &op2pos, &op3pos);
  M2GCCDeclare_DeclareConstant (op3pos, op3);
  M2GCCDeclare_DeclareConstant (op2pos, op2);
  location = M2LexBuf_TokenToLocation (op1pos);
  type = MixTypesBinary (op2, op3, op1pos, M2Quads_MustCheckOverflow (quad));
  ConvertBinaryOperands (location, &tl, &tr, type, op2, op3);
  tv = (*binop.proc) (location, tl, tr, false);
  M2ALU_CheckOrResetOverflow (op1pos, tv, M2Quads_MustCheckOverflow (quad));
  if (SymbolTable_IsConst (op1))
    {
      /* still have a constant which was not resolved, pass it to gcc  */
      M2Debug_Assert ((M2Base_MixTypes (FindType (op3), FindType (op2), op1pos)) != SymbolTable_NulSym);
      SymbolTable_PutConst (op1, M2Base_MixTypes (FindType (op3), FindType (op2), op1pos));
      M2GCCDeclare_ConstantKnownAndUsed (op1, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (op3)), tv));
    }
  else
    {
      if (M2SSA_EnableSSA && (SymbolTable_IsVariableSSA (op1)))
        {
          Replace (op1, tv);
        }
      else
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (op1), tv);
        }
    }
}


/*
   NoWalkProcedure -
*/

static void NoWalkProcedure (unsigned int param __attribute__((unused)))
{
}


/*
   CheckBinaryExpressionTypes - returns TRUE if all expression checks pass.
                                If the expression check fails quad is removed,
                                the walk procedure (des) is called and NoChange is
                                set to FALSE.
*/

static bool CheckBinaryExpressionTypes (unsigned int quad, M2GCCDeclare_WalkAction p)
{
  unsigned int des;
  unsigned int left;
  unsigned int right;
  bool typeChecking;
  bool constExpr;
  bool overflowChecking;
  unsigned int despos;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int operatorpos;
  unsigned int subexprpos;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOTypetok (quad, &operatorpos, &op, &des, &left, &right, &overflowChecking, &typeChecking, &constExpr, &despos, &leftpos, &rightpos);
  if ((typeChecking && (op != M2Quads_LogicalRotateOp)) && (op != M2Quads_LogicalShiftOp))
    {
      subexprpos = M2LexBuf_MakeVirtualTok (operatorpos, leftpos, rightpos);
      if (M2Options_StrictTypeChecking && (! (M2Check_ExpressionTypeCompatible (subexprpos, (const char *) "", 0, left, right, M2Options_StrictTypeChecking, false))))
        {
          M2MetaError_MetaErrorT2 (subexprpos, (const char *) "expression mismatch between {%1Etad} and {%2tad}", 48, left, right);
          NoChange = false;
          M2Quads_SubQuad (quad);
          (*p.proc) (des);
          return false;
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckElementSetTypes - returns TRUE if all expression checks pass.
                          If the expression check fails quad is removed,
                          the walk procedure (des) is called and NoChange is
                          set to FALSE.
*/

static bool CheckElementSetTypes (unsigned int quad)
{
  unsigned int righttype;
  unsigned int ignore;
  unsigned int left;
  unsigned int right;
  bool constExpr;
  bool overflowChecking;
  unsigned int ignorepos;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int operatorpos;
  unsigned int subexprpos;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &operatorpos, &op, &left, &right, &ignore, &overflowChecking, &constExpr, &leftpos, &rightpos, &ignorepos);
  subexprpos = M2LexBuf_MakeVirtualTok (operatorpos, leftpos, rightpos);
  righttype = SymbolTable_GetType (right);
  if (M2Options_StrictTypeChecking && (! (M2Check_ExpressionTypeCompatible (subexprpos, (const char *) "", 0, left, right, M2Options_StrictTypeChecking, true))))
    {
      M2MetaError_MetaErrorT2 (subexprpos, (const char *) "the types used in expression {%1Etad} {%kIN} {%2tad} are incompatible", 69, left, right);
      NoChange = false;
      M2Quads_SubQuad (quad);
      return false;
    }
  if ((righttype == SymbolTable_NulSym) || (! (SymbolTable_IsSet (SymbolTable_SkipType (righttype)))))
    {
      M2MetaError_MetaErrorT1 (rightpos, (const char *) "an {%kIN} expression is expecting {%1Etad} to be a {%kSET} type", 63, right);
      NoChange = false;
      M2Quads_SubQuad (quad);
      return false;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeBinarySet - encode a binary set arithmetic operation.
                   Set operands may be longer than a word.
*/

static void CodeBinarySet (m2expr_BuildBinProcedure binop, M2GenGCC_DoProcedure doOp, unsigned int quad)
{
  location_t location;
  bool constExpr;
  bool overflowChecking;
  M2Quads_QuadOperator op;
  unsigned int virttoken;
  unsigned int virtexpr;
  unsigned int des;
  unsigned int left;
  unsigned int right;
  unsigned int despos;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int operatorpos;

  M2Quads_GetQuadOtok (quad, &operatorpos, &op, &des, &left, &right, &overflowChecking, &constExpr, &despos, &leftpos, &rightpos);
  /* Firstly ensure that constant literals are declared.  */
  M2GCCDeclare_DeclareConstant (rightpos, right);
  M2GCCDeclare_DeclareConstant (leftpos, left);
  M2GCCDeclare_DeclareConstructor (rightpos, quad, right);
  M2GCCDeclare_DeclareConstructor (leftpos, quad, left);
  virttoken = M2LexBuf_MakeVirtualTok (operatorpos, despos, rightpos);
  location = M2LexBuf_TokenToLocation (virttoken);
  if (CheckBinaryExpressionTypes (quad, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) NoWalkProcedure}))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsConst (des))
        {
          virtexpr = M2LexBuf_MakeVirtualTok (operatorpos, leftpos, rightpos);
          if ((SymbolTable_IsValueSolved (left)) && (SymbolTable_IsValueSolved (right)))
            {
              M2Debug_Assert ((M2Base_MixTypes (FindType (right), FindType (left), virtexpr)) != SymbolTable_NulSym);
              SymbolTable_PutConst (des, FindType (right));
              SymbolTable_PushValue (left);
              SymbolTable_PushValue (right);
              (*doOp.proc) (virttoken);
              SymbolTable_PopValue (des);
              SymbolTable_PutConstSet (des);
            }
          else
            {
              M2MetaError_MetaErrorT0 (virtexpr, (const char *) "{%E}constant expression cannot be evaluated", 43);
            }
        }
      else
        {
          checkDeclare (des);
          m2expr_BuildBinaryForeachWordDo (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (des))), SymbolConversion_Mod2Gcc (des), SymbolConversion_Mod2Gcc (left), SymbolConversion_Mod2Gcc (right), (m2expr_BuildBinProcedure_C) binop.proc, (SymbolTable_GetMode (des)) == SymbolTable_LeftValue, (SymbolTable_GetMode (left)) == SymbolTable_LeftValue, (SymbolTable_GetMode (right)) == SymbolTable_LeftValue, SymbolTable_IsConst (des), SymbolTable_IsConst (left), SymbolTable_IsConst (right));
        }
    }
}


/*
   CheckUnaryOperand - checks to see whether operand is using a generic type.
*/

static bool CheckUnaryOperand (unsigned int quad, unsigned int operand)
{
  unsigned int type;
  DynamicStrings_String s;
  DynamicStrings_String op;

  type = SymbolTable_SkipType (SymbolTable_GetType (operand));
  if ((((M2System_Word == type) || (M2System_IsWordN (type))) || (M2System_Byte == type)) || (M2System_Loc == type))
    {
      op = M2Quads_GetM2OperatorDesc (M2Quads_GetQuadOp (quad));
      s = DynamicStrings_InitString ((const char *) "operand of type {%1Ets} is not allowed in an unary expression", 61);
      if (op != NULL)
        {
          s = DynamicStrings_ConCatChar (s, ' ');
          s = DynamicStrings_ConCat (s, DynamicStrings_Mark (op));
        }
      M2MetaError_MetaErrorStringT1 (CurrentQuadToken, s, operand);
      return false;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   UnaryOperand - returns TRUE if operand is acceptable for
                  unary operator: + -.  If FALSE
                  is returned, an error message will be generated
                  and the quad is deleted.
*/

static bool UnaryOperand (unsigned int quad, unsigned int operand)
{
  if (! (CheckUnaryOperand (quad, operand)))
    {
      M2Quads_SubQuad (quad);  /* We do not want multiple copies of the same error.  */
      return false;  /* We do not want multiple copies of the same error.  */
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckBinaryOperand - checks to see whether operand is using a generic type.
*/

static bool CheckBinaryOperand (unsigned int quad, bool isleft, unsigned int operand, bool result)
{
  unsigned int type;
  M2Quads_QuadOperator qop;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  unsigned int op1pos;
  unsigned int op2pos;
  unsigned int op3pos;
  DynamicStrings_String s;
  DynamicStrings_String op;

  type = SymbolTable_SkipType (SymbolTable_GetType (operand));
  if ((((M2System_Word == type) || (M2System_IsWordN (type))) || (M2System_Byte == type)) || (M2System_Loc == type))
    {
      M2Quads_GetQuadtok (quad, &qop, &op1, &op2, &op3, &op1pos, &op2pos, &op3pos);
      op = M2Quads_GetM2OperatorDesc (M2Quads_GetQuadOp (quad));
      if (isleft)
        {
          s = DynamicStrings_InitString ((const char *) "left operand {%1Ea} of type {%1Ets} is not allowed in binary expression", 71);
        }
      else
        {
          s = DynamicStrings_InitString ((const char *) "right operand {%1Ea} of type {%1Ets} is not allowed in binary expression", 72);
        }
      if (op != NULL)
        {
          s = DynamicStrings_ConCatChar (s, ' ');
          s = DynamicStrings_ConCat (s, DynamicStrings_Mark (op));
        }
      M2MetaError_MetaErrorStringT1 (op1pos, s, operand);
      return false;
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BinaryOperands - returns TRUE if, l, and, r, are acceptable for
                    binary operator: + - / * and friends.  If FALSE
                    is returned, an error message will be generated
                    and the, quad, is deleted.
*/

static bool BinaryOperands (unsigned int quad, unsigned int l, unsigned int r)
{
  bool result;

  result = CheckBinaryOperand (quad, true, l, true);
  result = CheckBinaryOperand (quad, false, r, result);
  if (! result)
    {
      M2Quads_SubQuad (quad);  /* We do not want multiple copies of the same error.  */
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstStr - returns TRUE if sym is a constant string or a char constant.
*/

static bool IsConstStr (unsigned int sym)
{
  return (SymbolTable_IsConstString (sym)) || ((SymbolTable_IsConst (sym)) && ((SymbolTable_GetSType (sym)) == M2Base_Char));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstStrKnown - returns TRUE if sym is a constant string or a char constant
                     which is known.
*/

static bool IsConstStrKnown (unsigned int sym)
{
  return ((SymbolTable_IsConstString (sym)) && (SymbolTable_IsConstStringKnown (sym))) || ((SymbolTable_IsConst (sym)) && ((SymbolTable_GetSType (sym)) == M2Base_Char));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetStr - return a string containing a constant string value associated with sym.
            A nul char constant will return an empty string.
*/

static DynamicStrings_String GetStr (unsigned int tokenno, unsigned int sym)
{
  char ch;

  M2Debug_Assert (SymbolTable_IsConst (sym));
  if (SymbolTable_IsConstString (sym))
    {
      return DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetString (sym)));
    }
  else
    {
      M2Debug_Assert ((SymbolTable_GetSType (sym)) == M2Base_Char);
      SymbolTable_PushValue (sym);
      ch = M2ALU_PopChar (tokenno);
      return DynamicStrings_InitStringChar (ch);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldAdd - check addition for constant folding.  It checks for conststrings
             overloading the +.
*/

static void FoldAdd (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  DynamicStrings_String s;

  if ((IsConstStr (op2)) && (IsConstStr (op3)))
    {
      /* avoid dangling else.  */
      if ((IsConstStrKnown (op2)) && (IsConstStrKnown (op3)))
        {
          /* Handle special addition for constant strings.  */
          s = DynamicStrings_Dup (GetStr (tokenno, op2));
          s = DynamicStrings_ConCat (s, GetStr (tokenno, op3));
          SymbolTable_PutConstStringKnown (tokenno, op1, NameKey_makekey (DynamicStrings_string (s)), false, true);
          M2GCCDeclare_TryDeclareConstant (tokenno, op1);
          (*p.proc) (op1);
          NoChange = false;
          M2Quads_SubQuad (quad);
          s = DynamicStrings_KillString (s);
        }
    }
  else
    {
      FoldArithAdd (tokenno, p, quad, op1, op2, op3);
    }
}


/*
   FoldArithAdd - check arithmetic addition for constant folding.
*/

static void FoldArithAdd (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildAdd}, quad, op1, op2, op3);
    }
}


/*
   CodeAddChecked - code an addition instruction, determine whether checking
                    is required.
*/

static void CodeAddChecked (unsigned int quad, unsigned int left, unsigned int right)
{
  if (M2Quads_MustCheckOverflow (quad))
    {
      CodeAddCheck (quad, left, right);
    }
  else
    {
      CodeAdd (quad, left, right);
    }
}


/*
   CodeAddCheck - encode addition but check for overflow.
*/

static void CodeAddCheck (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinaryCheck ((m2expr_BuildBinCheckProcedure) {(m2expr_BuildBinCheckProcedure_t) m2expr_BuildAddCheck}, quad);
    }
}


/*
   CodeAdd - encode addition.
*/

static void CodeAdd (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildAdd}, quad);
    }
}


/*
   FoldSub - check subtraction for constant folding.
*/

static void FoldSub (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildSub}, quad, op1, op2, op3);
    }
}


/*
   CodeSubChecked - code a subtract instruction, determine whether checking
                    is required.
*/

static void CodeSubChecked (unsigned int quad, unsigned int left, unsigned int right)
{
  if (M2Quads_MustCheckOverflow (quad))
    {
      CodeSubCheck (quad, left, right);
    }
  else
    {
      CodeSub (quad, left, right);
    }
}


/*
   CodeSubCheck - encode subtraction but check for overflow.
*/

static void CodeSubCheck (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinaryCheck ((m2expr_BuildBinCheckProcedure) {(m2expr_BuildBinCheckProcedure_t) m2expr_BuildSubCheck}, quad);
    }
}


/*
   CodeSub - encode subtraction.
*/

static void CodeSub (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildSub}, quad);
    }
}


/*
   FoldMult - check multiplication for constant folding.
*/

static void FoldMult (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildMult}, quad, op1, op2, op3);
    }
}


/*
   CodeMultChecked - code a multiplication instruction, determine whether checking
                     is required.
*/

static void CodeMultChecked (unsigned int quad, unsigned int left, unsigned int right)
{
  if (M2Quads_MustCheckOverflow (quad))
    {
      CodeMultCheck (quad, left, right);
    }
  else
    {
      CodeMult (quad, left, right);
    }
}


/*
   CodeMultCheck - encode multiplication but check for overflow.
*/

static void CodeMultCheck (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinaryCheck ((m2expr_BuildBinCheckProcedure) {(m2expr_BuildBinCheckProcedure_t) m2expr_BuildMultCheck}, quad);
    }
}


/*
   CodeMult - encode multiplication.
*/

static void CodeMult (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildMult}, quad);
    }
}


/*
   CodeDivM2Checked - code a divide instruction, determine whether checking
                      is required.
*/

static void CodeDivM2Checked (unsigned int quad, unsigned int left, unsigned int right)
{
  if (M2Quads_MustCheckOverflow (quad))
    {
      CodeDivM2Check (quad, left, right);
    }
  else
    {
      CodeDivM2 (quad, left, right);
    }
}


/*
   CodeDivM2Check - encode addition but check for overflow.
*/

static void CodeDivM2Check (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinaryCheck ((m2expr_BuildBinCheckProcedure) {(m2expr_BuildBinCheckProcedure_t) m2expr_BuildDivM2Check}, quad);
    }
}


/*
   CodeModM2Checked - code a modulus instruction, determine whether checking
                      is required.
*/

static void CodeModM2Checked (unsigned int quad, unsigned int left, unsigned int right)
{
  if (M2Quads_MustCheckOverflow (quad))
    {
      CodeModM2Check (quad, left, right);
    }
  else
    {
      CodeModM2 (quad, left, right);
    }
}


/*
   CodeModM2Check - encode addition but check for overflow.
*/

static void CodeModM2Check (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinaryCheck ((m2expr_BuildBinCheckProcedure) {(m2expr_BuildBinCheckProcedure_t) m2expr_BuildModM2Check}, quad);
    }
}


/*
   BinaryOperandRealFamily -
*/

static bool BinaryOperandRealFamily (unsigned int op)
{
  unsigned int t;

  t = SymbolTable_SkipType (SymbolTable_GetType (op));
  return (((M2Base_IsComplexType (t)) || (M2System_IsComplexN (t))) || (M2Base_IsRealType (t))) || (M2System_IsRealN (t));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldDivM2 - check division for constant folding.
*/

static void FoldDivM2 (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((BinaryOperandRealFamily (op2)) || (BinaryOperandRealFamily (op3)))
        {
          FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildRDiv}, quad, op1, op2, op3);
        }
      else
        {
          FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildDivM2}, quad, op1, op2, op3);
        }
    }
}


/*
   CodeDivM2 - encode division.
*/

static void CodeDivM2 (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((BinaryOperandRealFamily (left)) || (BinaryOperandRealFamily (right)))
        {
          CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildRDiv}, quad);
        }
      else
        {
          CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildDivM2}, quad);
        }
    }
}


/*
   FoldModM2 - check modulus for constant folding.
*/

static void FoldModM2 (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildModM2}, quad, op1, op2, op3);
    }
}


/*
   CodeModM2 - encode modulus.
*/

static void CodeModM2 (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildModM2}, quad);
    }
}


/*
   FoldDivTrunc - check division for constant folding.
*/

static void FoldDivTrunc (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((BinaryOperandRealFamily (op2)) || (BinaryOperandRealFamily (op3)))
        {
          FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildRDiv}, quad, op1, op2, op3);
        }
      else
        {
          FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildDivTrunc}, quad, op1, op2, op3);
        }
    }
}


/*
   CodeDivTrunc - encode multiplication.
*/

static void CodeDivTrunc (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((BinaryOperandRealFamily (left)) || (BinaryOperandRealFamily (right)))
        {
          CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildRDiv}, quad);
        }
      else
        {
          CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildDivTrunc}, quad);
        }
    }
}


/*
   FoldModTrunc - check modulus for constant folding.
*/

static void FoldModTrunc (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildModTrunc}, quad, op1, op2, op3);
    }
}


/*
   CodeModTrunc - encode modulus.
*/

static void CodeModTrunc (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildModTrunc}, quad);
    }
}


/*
   FoldDivCeil - check division for constant folding.
*/

static void FoldDivCeil (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((BinaryOperandRealFamily (op2)) || (BinaryOperandRealFamily (op3)))
        {
          FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildRDiv}, quad, op1, op2, op3);
        }
      else
        {
          FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildDivCeil}, quad, op1, op2, op3);
        }
    }
}


/*
   CodeDivCeil - encode multiplication.
*/

static void CodeDivCeil (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((BinaryOperandRealFamily (left)) || (BinaryOperandRealFamily (right)))
        {
          CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildRDiv}, quad);
        }
      else
        {
          CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildDivCeil}, quad);
        }
    }
}


/*
   FoldModCeil - check modulus for constant folding.
*/

static void FoldModCeil (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildModCeil}, quad, op1, op2, op3);
    }
}


/*
   CodeModCeil - encode multiplication.
*/

static void CodeModCeil (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildModCeil}, quad);
    }
}


/*
   FoldDivFloor - check division for constant folding.
*/

static void FoldDivFloor (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((BinaryOperandRealFamily (op2)) || (BinaryOperandRealFamily (op3)))
        {
          FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildRDiv}, quad, op1, op2, op3);
        }
      else
        {
          FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildDivFloor}, quad, op1, op2, op3);
        }
    }
}


/*
   CodeDivFloor - encode multiplication.
*/

static void CodeDivFloor (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((BinaryOperandRealFamily (left)) || (BinaryOperandRealFamily (right)))
        {
          CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildRDiv}, quad);
        }
      else
        {
          CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildDivFloor}, quad);
        }
    }
}


/*
   FoldModFloor - check modulus for constant folding.
*/

static void FoldModFloor (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  if (BinaryOperands (quad, op2, op3))
    {
      FoldBinary (tokenno, p, (m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildModFloor}, quad, op1, op2, op3);
    }
}


/*
   CodeModFloor - encode modulus.
*/

static void CodeModFloor (unsigned int quad, unsigned int left, unsigned int right)
{
  if (BinaryOperands (quad, left, right))
    {
      CodeBinary ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildModFloor}, quad);
    }
}


/*
   FoldBuiltinConst -
*/

static void FoldBuiltinConst (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int constDesc)
{
  tree value;

  value = m2builtins_GetBuiltinConst (reinterpret_cast <char * > (NameKey_KeyToCharStar ((NameKey_Name) (constDesc))));
  if (value == NULL)
    {
      M2MetaError_MetaErrorT1 (tokenno, (const char *) "unknown built in constant {%1Ead}", 33, constDesc);
    }
  else
    {
      SymbolConversion_AddModGcc (result, value);
      (*p.proc) (result);
      NoChange = false;
      M2Quads_SubQuad (quad);
    }
}


/*
   FoldBuiltinTypeInfo - attempts to fold a builtin attribute value on type op2.
*/

static void FoldBuiltinTypeInfo (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  tree t;
  location_t location;

  if ((SymbolConversion_GccKnowsAbout (op2)) && (M2GCCDeclare_CompletelyResolved (op2)))
    {
      location = M2LexBuf_TokenToLocation (tokenno);
      t = m2builtins_GetBuiltinTypeInfo (location, SymbolConversion_Mod2Gcc (op2), const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar ((NameKey_Name) (op3)))));
      if (t == NULL)
        {
          M2MetaError_MetaErrorT2 (tokenno, (const char *) "unknown built in constant {%1Ead} attribute for type {%2ad}", 59, op3, op2);
        }
      else
        {
          SymbolConversion_AddModGcc (op1, t);
          (*p.proc) (op1);
          NoChange = false;
          M2Quads_SubQuad (quad);
        }
    }
}


/*
   FoldTBitsize - attempt to fold the standard function SYSTEM.TBITSIZE
                  quadruple.  If the quadruple is folded it is removed.
*/

static void FoldTBitsize (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int res, unsigned int type)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  M2GCCDeclare_TryDeclareType (type);
  type = SymbolTable_GetDType (type);
  if (M2GCCDeclare_CompletelyResolved (type))
    {
      SymbolConversion_AddModGcc (res, m2expr_BuildSystemTBitSize (location, SymbolConversion_Mod2Gcc (type)));
      (*p.proc) (res);
      NoChange = false;
      M2Quads_SubQuad (quad);
    }
}


/*
   FoldStandardFunction - attempts to fold a standard function.
*/

static void FoldStandardFunction (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  DynamicStrings_String s;
  unsigned int type;
  unsigned int d;
  unsigned int result;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  if ((SymbolTable_GetSymName (op2)) == (NameKey_MakeKey ((const char *) "Length", 6)))
    {
      /* avoid dangling else.  */
      M2GCCDeclare_TryDeclareConstant (tokenno, op3);
      if ((SymbolTable_IsConst (op3)) && (SymbolConversion_GccKnowsAbout (op3)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          /* fine, we can take advantage of this and fold constants  */
          if (SymbolTable_IsConst (op1))
            {
              if (SymbolTable_IsConstString (op3))
                {
                  SymbolConversion_AddModGcc (op1, FindSize (tokenno, op3));
                  (*p.proc) (op1);
                  NoChange = false;
                  M2Quads_SubQuad (quad);
                }
              else
                {
                  M2MetaError_MetaErrorT1 (tokenno, (const char *) "parameter to LENGTH must be a string {%1Ead}", 44, op3);
                }
            }
          else
            {
              /* rewrite the quad to use becomes.  */
              d = SymbolTable_GetStringLength (tokenno, op3);
              s = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "%d", 2)), (const unsigned char *) &d, (sizeof (d)-1));
              result = SymbolTable_MakeConstLit (tokenno, NameKey_makekey (DynamicStrings_string (s)), M2Base_Cardinal);
              s = DynamicStrings_KillString (s);
              M2GCCDeclare_TryDeclareConstant (tokenno, result);
              M2Quads_PutQuad (quad, M2Quads_BecomesOp, op1, SymbolTable_NulSym, result);
            }
        }
    }
  else if ((SymbolTable_GetSymName (op2)) == (NameKey_MakeKey ((const char *) "CAP", 3)))
    {
      /* avoid dangling else.  */
      M2GCCDeclare_TryDeclareConstant (tokenno, op3);
      if ((SymbolTable_IsConst (op3)) && (SymbolConversion_GccKnowsAbout (op3)))
        {
          /* fine, we can take advantage of this and fold constants  */
          if (SymbolTable_IsConst (op1))
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if (((SymbolTable_IsConstString (op3)) && ((SymbolTable_GetStringLength (tokenno, op3)) == 1)) || ((SymbolTable_GetType (op3)) == M2Base_Char))
                {
                  SymbolConversion_AddModGcc (op1, m2expr_BuildCap (location, SymbolConversion_Mod2Gcc (op3)));
                  (*p.proc) (op1);
                  NoChange = false;
                  M2Quads_SubQuad (quad);
                }
              else
                {
                  M2MetaError_MetaErrorT1 (tokenno, (const char *) "parameter to CAP must be a single character {%1Ead}", 51, op3);
                }
            }
        }
    }
  else if ((SymbolTable_GetSymName (op2)) == (NameKey_MakeKey ((const char *) "ABS", 3)))
    {
      /* avoid dangling else.  */
      M2GCCDeclare_TryDeclareConstant (tokenno, op3);
      if ((SymbolTable_IsConst (op3)) && (SymbolConversion_GccKnowsAbout (op3)))
        {
          /* fine, we can take advantage of this and fold constants  */
          if (SymbolTable_IsConst (op1))
            {
              SymbolConversion_AddModGcc (op1, m2expr_BuildAbs (location, SymbolConversion_Mod2Gcc (op3)));
              (*p.proc) (op1);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
        }
    }
  else if (op2 == M2Base_Im)
    {
      /* avoid dangling else.  */
      M2GCCDeclare_TryDeclareConstant (tokenno, op3);
      if ((SymbolTable_IsConst (op3)) && (SymbolConversion_GccKnowsAbout (op3)))
        {
          /* fine, we can take advantage of this and fold constants  */
          if (SymbolTable_IsConst (op1))
            {
              SymbolConversion_AddModGcc (op1, m2expr_BuildIm (SymbolConversion_Mod2Gcc (op3)));
              (*p.proc) (op1);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
        }
    }
  else if (op2 == M2Base_Re)
    {
      /* avoid dangling else.  */
      M2GCCDeclare_TryDeclareConstant (tokenno, op3);
      if ((SymbolTable_IsConst (op3)) && (SymbolConversion_GccKnowsAbout (op3)))
        {
          /* fine, we can take advantage of this and fold constants  */
          if (SymbolTable_IsConst (op1))
            {
              SymbolConversion_AddModGcc (op1, m2expr_BuildRe (SymbolConversion_Mod2Gcc (op3)));
              (*p.proc) (op1);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
        }
    }
  else if (op2 == M2Base_Cmplx)
    {
      /* avoid dangling else.  */
      M2GCCDeclare_TryDeclareConstant (tokenno, SymbolTable_GetNth (op3, 1));
      M2GCCDeclare_TryDeclareConstant (tokenno, SymbolTable_GetNth (op3, 2));
      if ((((SymbolTable_IsConst (SymbolTable_GetNth (op3, 1))) && (SymbolConversion_GccKnowsAbout (SymbolTable_GetNth (op3, 1)))) && (SymbolTable_IsConst (SymbolTable_GetNth (op3, 2)))) && (SymbolConversion_GccKnowsAbout (SymbolTable_GetNth (op3, 2))))
        {
          /* fine, we can take advantage of this and fold constants  */
          if (SymbolTable_IsConst (op1))
            {
              type = M2Base_GetCmplxReturnType (SymbolTable_GetType (SymbolTable_GetNth (op3, 1)), SymbolTable_GetType (SymbolTable_GetNth (op3, 2)));
              if (type == SymbolTable_NulSym)
                {
                  M2MetaError_MetaErrorT2 (tokenno, (const char *) "real {%1Eatd} and imaginary {%2atd} types are incompatible", 58, SymbolTable_GetNth (op3, 1), SymbolTable_GetNth (op3, 2));
                }
              else
                {
                  SymbolConversion_AddModGcc (op1, m2expr_BuildCmplx (location, SymbolConversion_Mod2Gcc (type), SymbolConversion_Mod2Gcc (SymbolTable_GetNth (op3, 1)), SymbolConversion_Mod2Gcc (SymbolTable_GetNth (op3, 2))));
                  (*p.proc) (op1);
                  NoChange = false;
                  M2Quads_SubQuad (quad);
                }
            }
        }
    }
  else if (op2 == M2System_TBitSize)
    {
      /* avoid dangling else.  */
      FoldTBitsize (tokenno, p, quad, op1, op3);
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "only expecting LENGTH, CAP, ABS, IM, RE", 39);
    }
}


/*
   CodeStandardFunction -
*/

static void CodeStandardFunction (unsigned int quad, unsigned int result, unsigned int function, unsigned int param)
{
  unsigned int type;
  location_t location;

  M2GCCDeclare_DeclareConstant (CurrentQuadToken, param);
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, param);
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if ((function != SymbolTable_NulSym) && ((SymbolTable_GetSymName (function)) == (NameKey_MakeKey ((const char *) "Length", 6))))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (result))
        {
          M2Error_InternalError ((const char *) "LENGTH function should already have been folded", 47);
        }
    }
  else if ((function != SymbolTable_NulSym) && ((SymbolTable_GetSymName (function)) == (NameKey_MakeKey ((const char *) "CAP", 3))))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (result))
        {
          M2Error_InternalError ((const char *) "CAP function should already have been folded", 44);
        }
      else
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2expr_BuildCap (location, SymbolConversion_Mod2Gcc (param)));
        }
    }
  else if ((function != SymbolTable_NulSym) && ((SymbolTable_GetSymName (function)) == (NameKey_MakeKey ((const char *) "ABS", 3))))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (result))
        {
          M2Error_InternalError ((const char *) "ABS function should already have been folded", 44);
        }
      else
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2expr_BuildAbs (location, SymbolConversion_Mod2Gcc (param)));
        }
    }
  else if (function == M2Base_Im)
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (result))
        {
          M2Error_InternalError ((const char *) "IM function should already have been folded", 43);
        }
      else
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2expr_BuildIm (SymbolConversion_Mod2Gcc (param)));
        }
    }
  else if (function == M2Base_Re)
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (result))
        {
          M2Error_InternalError ((const char *) "RE function should already have been folded", 43);
        }
      else
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2expr_BuildRe (SymbolConversion_Mod2Gcc (param)));
        }
    }
  else if (function == M2Base_Cmplx)
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (result))
        {
          M2Error_InternalError ((const char *) "CMPLX function should already have been folded", 46);
        }
      else
        {
          type = M2Base_GetCmplxReturnType (SymbolTable_GetType (SymbolTable_GetNth (param, 1)), SymbolTable_GetType (SymbolTable_GetNth (param, 2)));
          if (type == SymbolTable_NulSym)
            {
              M2MetaError_MetaErrorT2 (CurrentQuadToken, (const char *) "real {%1Eatd} and imaginary {%2atd} types are incompatible", 58, SymbolTable_GetNth (param, 1), SymbolTable_GetNth (param, 2));
            }
          else
            {
              m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2expr_BuildCmplx (location, SymbolConversion_Mod2Gcc (type), SymbolConversion_Mod2Gcc (SymbolTable_GetNth (param, 1)), SymbolConversion_Mod2Gcc (SymbolTable_GetNth (param, 2))));
            }
        }
    }
  else if (function == M2System_TBitSize)
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (result))
        {
          M2Error_InternalError ((const char *) "TBITSIZE function should already have been folded", 49);
        }
      else
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2expr_BuildTBitSize (location, SymbolConversion_Mod2Gcc (param)));
        }
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "expecting LENGTH, CAP, ABS, IM", 30);
    }
}


/*
   CodeSavePriority - checks to see whether op2 is reachable and is directly accessible
                      externally. If so then it saves the current interrupt priority
                      in op1 and sets the current priority to that determined by
                      appropriate module.

                      op1 := op3(GetModuleScope(op2))
*/

static void CodeSavePriority (unsigned int oldValue, unsigned int scopeSym, unsigned int procedureSym)
{
  tree funcTree;
  unsigned int mod;
  NameKey_Name n;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if (((SymbolTable_IsModule (scopeSym)) || (SymbolTable_IsDefImp (scopeSym))) || ((SymbolTable_IsProcedure (scopeSym)) && (SymbolTable_GetNeedSavePriority (scopeSym))))
    {
      if (SymbolTable_IsProcedure (scopeSym))
        {
          mod = SymbolTable_GetModuleScope (scopeSym);
        }
      else
        {
          M2Debug_Assert ((SymbolTable_IsModule (scopeSym)) || (SymbolTable_IsDefImp (scopeSym)));
          mod = scopeSym;
        }
      if ((SymbolTable_GetPriority (mod)) != SymbolTable_NulSym)
        {
          if (PriorityDebugging)
            {
              n = SymbolTable_GetSymName (scopeSym);
              M2Printf_printf1 ((const char *) "procedure <%a> needs to save interrupts\\n", 41, (const unsigned char *) &n, (sizeof (n)-1));
            }
          M2GCCDeclare_DeclareConstant (CurrentQuadToken, SymbolTable_GetPriority (mod));
          m2statement_BuildParam (location, SymbolConversion_Mod2Gcc (SymbolTable_GetPriority (mod)));
          funcTree = m2statement_BuildProcedureCallTree (location, SymbolConversion_Mod2Gcc (procedureSym), SymbolConversion_Mod2Gcc (SymbolTable_GetType (procedureSym)));
          funcTree = m2statement_BuildFunctValue (location, SymbolConversion_Mod2Gcc (oldValue));
          m2type_AddStatement (location, funcTree);
        }
    }
}


/*
   CodeRestorePriority - checks to see whether op2 is reachable and is directly accessible
                         externally. If so then it restores the previous interrupt priority
                         held in op1.

                         op1 := op3(op1)
*/

static void CodeRestorePriority (unsigned int oldValue, unsigned int scopeSym, unsigned int procedureSym)
{
  tree funcTree;
  unsigned int mod;
  NameKey_Name n;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if (((SymbolTable_IsModule (scopeSym)) || (SymbolTable_IsDefImp (scopeSym))) || ((SymbolTable_IsProcedure (scopeSym)) && (SymbolTable_GetNeedSavePriority (scopeSym))))
    {
      if (SymbolTable_IsProcedure (scopeSym))
        {
          mod = SymbolTable_GetModuleScope (scopeSym);
        }
      else
        {
          M2Debug_Assert ((SymbolTable_IsModule (scopeSym)) || (SymbolTable_IsDefImp (scopeSym)));
          mod = scopeSym;
        }
      if ((SymbolTable_GetPriority (mod)) != SymbolTable_NulSym)
        {
          if (PriorityDebugging)
            {
              n = SymbolTable_GetSymName (scopeSym);
              M2Printf_printf1 ((const char *) "procedure <%a> needs to restore interrupts\\n", 44, (const unsigned char *) &n, (sizeof (n)-1));
            }
          m2statement_BuildParam (location, SymbolConversion_Mod2Gcc (oldValue));
          funcTree = m2statement_BuildProcedureCallTree (location, SymbolConversion_Mod2Gcc (procedureSym), SymbolConversion_Mod2Gcc (SymbolTable_GetType (procedureSym)));
          funcTree = m2statement_BuildFunctValue (location, SymbolConversion_Mod2Gcc (oldValue));
          m2type_AddStatement (location, funcTree);
        }
    }
}


/*
   FoldBinarySet - attempts to fold set arithmetic it removes the quad if successful.
*/

static void FoldBinarySet (unsigned int tokenno, M2GCCDeclare_WalkAction p, M2GenGCC_DoProcedure op, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  location_t location;

  /* firstly try and ensure that constants are declared  */
  M2GCCDeclare_TryDeclareConstant (tokenno, op2);
  M2GCCDeclare_TryDeclareConstant (tokenno, op3);
  location = M2LexBuf_TokenToLocation (tokenno);
  if ((SymbolConversion_GccKnowsAbout (op2)) && (SymbolConversion_GccKnowsAbout (op3)))
    {
      if (CheckBinaryExpressionTypes (quad, p))
        {
          if (((((SymbolTable_IsConst (op2)) && (SymbolTable_IsConstSet (op2))) && (SymbolTable_IsConst (op3))) && (SymbolTable_IsConstSet (op3))) && (SymbolTable_IsConst (op1)))
            {
              if ((SymbolTable_IsValueSolved (op2)) && (SymbolTable_IsValueSolved (op3)))
                {
                  M2Debug_Assert ((M2Base_MixTypes (FindType (op3), FindType (op2), tokenno)) != SymbolTable_NulSym);
                  SymbolTable_PutConst (op1, M2Base_MixTypes (FindType (op3), FindType (op2), tokenno));
                  SymbolTable_PushValue (op2);
                  SymbolTable_PushValue (op3);
                  (*op.proc) (tokenno);
                  SymbolTable_PopValue (op1);
                  SymbolTable_PushValue (op1);
                  SymbolTable_PutConstSet (op1);
                  SymbolConversion_AddModGcc (op1, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (op3)), M2ALU_PopSetTree (tokenno)));
                  (*p.proc) (op1);
                  NoChange = false;
                  M2Quads_SubQuad (quad);
                }
            }
        }
    }
}


/*
   FoldSetOr - check whether we can fold a set arithmetic or.
*/

static void FoldSetOr (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  FoldBinarySet (tokenno, p, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetOr}, quad, op1, op2, op3);
}


/*
   CodeSetOr - encode set arithmetic or.
*/

static void CodeSetOr (unsigned int quad)
{
  CodeBinarySet ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildLogicalOr}, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetOr}, quad);
}


/*
   FoldSetAnd - check whether we can fold a logical and.
*/

static void FoldSetAnd (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  FoldBinarySet (tokenno, p, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetAnd}, quad, op1, op2, op3);
}


/*
   CodeSetAnd - encode set arithmetic and.
*/

static void CodeSetAnd (unsigned int quad)
{
  CodeBinarySet ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildLogicalAnd}, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetAnd}, quad);
}


/*
   CodeBinarySetShift - encode a binary set arithmetic operation.
                        The set maybe larger than a machine word
                        and the value of one word may effect the
                        values of another - ie shift and rotate.
                        Set sizes of a word or less are evaluated
                        with binop, whereas multiword sets are
                        evaluated by M2RTS.
*/

static void CodeBinarySetShift (m2expr_BuildSetProcedure binop, M2GenGCC_DoProcedure doOp, NameKey_Name var, NameKey_Name left, NameKey_Name right, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  tree nBits;
  tree unbounded;
  tree leftproc;
  tree rightproc;
  tree varproc;
  location_t location;

  /* firstly ensure that constant literals are declared  */
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, op3);
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, op2);
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, op3);
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, op2);
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if (SymbolTable_IsConst (op1))
    {
      if ((SymbolTable_IsValueSolved (op2)) && (SymbolTable_IsValueSolved (op3)))
        {
          M2Debug_Assert ((M2Base_MixTypes (FindType (op3), FindType (op2), CurrentQuadToken)) != SymbolTable_NulSym);
          SymbolTable_PutConst (op1, FindType (op3));
          SymbolTable_PushValue (op2);
          SymbolTable_PushValue (op3);
          (*doOp.proc) (CurrentQuadToken);
          SymbolTable_PopValue (op1);
          SymbolTable_PutConstSet (op1);
        }
      else
        {
          M2MetaError_MetaErrorT0 (CurrentQuadToken, (const char *) "{%E}constant expression cannot be evaluated", 43);
        }
    }
  else
    {
      varproc = SymbolConversion_Mod2Gcc (SymbolTable_FromModuleGetSym (CurrentQuadToken, var, M2System_System));
      leftproc = SymbolConversion_Mod2Gcc (SymbolTable_FromModuleGetSym (CurrentQuadToken, left, M2System_System));
      rightproc = SymbolConversion_Mod2Gcc (SymbolTable_FromModuleGetSym (CurrentQuadToken, right, M2System_System));
      unbounded = SymbolConversion_Mod2Gcc (SymbolTable_GetType (SymbolTable_GetNthParamAny (SymbolTable_FromModuleGetSym (CurrentQuadToken, var, M2System_System), 1)));
      SymbolTable_PushValue (M2GCCDeclare_GetTypeMax (SymbolTable_SkipType (SymbolTable_GetType (op1))));
      M2ALU_PushIntegerTree (m2convert_BuildConvert (location, m2type_GetM2ZType (), M2ALU_PopIntegerTree (), false));
      SymbolTable_PushValue (M2GCCDeclare_GetTypeMin (SymbolTable_SkipType (SymbolTable_GetType (op1))));
      M2ALU_PushIntegerTree (m2convert_BuildConvert (location, m2type_GetM2ZType (), M2ALU_PopIntegerTree (), false));
      M2ALU_Sub ();
      M2ALU_PushCard (1);
      M2ALU_PushIntegerTree (m2convert_BuildConvert (location, m2type_GetM2ZType (), M2ALU_PopIntegerTree (), false));
      M2ALU_Addn ();
      nBits = M2ALU_PopIntegerTree ();
      m2expr_BuildBinarySetDo (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (op1))), SymbolConversion_Mod2Gcc (op1), SymbolConversion_Mod2Gcc (op2), SymbolConversion_Mod2Gcc (op3), (m2expr_BuildSetProcedure_C) binop.proc, (SymbolTable_GetMode (op1)) == SymbolTable_LeftValue, (SymbolTable_GetMode (op2)) == SymbolTable_LeftValue, (SymbolTable_GetMode (op3)) == SymbolTable_LeftValue, nBits, unbounded, varproc, leftproc, rightproc);
    }
}


/*
   FoldSetShift - check whether we can fold a logical shift.
*/

static void FoldSetShift (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  FoldBinarySet (tokenno, p, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetShift}, quad, op1, op2, op3);
}


/*
   CodeSetShift - encode set arithmetic shift.
*/

static void CodeSetShift (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  CodeBinarySetShift ((m2expr_BuildSetProcedure) {(m2expr_BuildSetProcedure_t) m2expr_BuildLogicalShift}, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetShift}, NameKey_MakeKey ((const char *) "ShiftVal", 8), NameKey_MakeKey ((const char *) "ShiftLeft", 9), NameKey_MakeKey ((const char *) "ShiftRight", 10), quad, op1, op2, op3);
}


/*
   FoldSetRotate - check whether we can fold a logical rotate.
*/

static void FoldSetRotate (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  FoldBinarySet (tokenno, p, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetRotate}, quad, op1, op2, op3);
}


/*
   CodeSetRotate - encode set arithmetic rotate.
*/

static void CodeSetRotate (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  CodeBinarySetShift ((m2expr_BuildSetProcedure) {(m2expr_BuildSetProcedure_t) m2expr_BuildLogicalRotate}, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetRotate}, NameKey_MakeKey ((const char *) "RotateVal", 9), NameKey_MakeKey ((const char *) "RotateLeft", 10), NameKey_MakeKey ((const char *) "RotateRight", 11), quad, op1, op2, op3);
}


/*
   CodeSetLogicalDifference - encode set arithmetic logical difference.
*/

static void CodeSetLogicalDifference (unsigned int quad)
{
  CodeBinarySet ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildLogicalDifference}, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetDifference}, quad);
}


/*
   FoldSymmetricDifference - check whether we can fold a logical difference.
*/

static void FoldSymmetricDifference (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  FoldBinarySet (tokenno, p, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetSymmetricDifference}, quad, op1, op2, op3);
}


/*
   CodeSetSymmetricDifference - code set difference.
*/

static void CodeSetSymmetricDifference (unsigned int quad)
{
  CodeBinarySet ((m2expr_BuildBinProcedure) {(m2expr_BuildBinProcedure_t) m2expr_BuildSymmetricDifference}, (M2GenGCC_DoProcedure) {(M2GenGCC_DoProcedure_t) M2ALU_SetSymmetricDifference}, quad);
}


/*
   CodeUnarySet - encode a unary set arithmetic operation.
                  Set operands may be longer than a word.
*/

static void CodeUnarySet (m2expr_BuildUnarySetFunction unop, M2GenGCC_DoUnaryProcedure constop, unsigned int quad, unsigned int result, unsigned int expr)
{
  location_t location;

  /* firstly ensure that constant literals are declared  */
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, expr);
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, expr);
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if (SymbolTable_IsConst (result))
    {
      if (SymbolTable_IsValueSolved (expr))
        {
          M2Debug_Assert ((FindType (expr)) != SymbolTable_NulSym);
          SymbolTable_PutConst (result, FindType (expr));
          SymbolTable_PushValue (expr);
          (*constop.proc) (CurrentQuadToken);
          SymbolTable_PopValue (result);
          SymbolTable_PushValue (result);
          SymbolTable_PutConstSet (result);
          M2GCCDeclare_ConstantKnownAndUsed (result, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (expr)), M2ALU_PopSetTree (CurrentQuadToken)));
        }
      else
        {
          M2MetaError_MetaErrorT0 (CurrentQuadToken, (const char *) "{%E}constant expression cannot be evaluated", 43);
        }
    }
  else
    {
      checkDeclare (result);
      m2statement_BuildUnaryForeachWordDo (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (result)), SymbolConversion_Mod2Gcc (result), SymbolConversion_Mod2Gcc (expr), (m2expr_BuildUnarySetFunction_C) unop.proc, (SymbolTable_GetMode (result)) == SymbolTable_LeftValue, (SymbolTable_GetMode (expr)) == SymbolTable_LeftValue, SymbolTable_IsConst (result), SymbolTable_IsConst (expr));
    }
}


/*
   FoldIncl - check whether we can fold the InclOp.
              result := result + (1 << expr)
*/

static void FoldIncl (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int expr)
{
  /* firstly ensure that constant literals are declared  */
  M2GCCDeclare_TryDeclareConstant (tokenno, expr);
  if ((SymbolTable_IsConst (result)) && (SymbolTable_IsConst (expr)))
    {
      if ((SymbolConversion_GccKnowsAbout (expr)) && (SymbolTable_IsValueSolved (result)))
        {
          /* fine, we can take advantage of this and fold constants  */
          SymbolTable_PushValue (result);
          M2ALU_AddBit (tokenno, expr);
          SymbolConversion_AddModGcc (result, M2ALU_PopSetTree (tokenno));
          (*p.proc) (result);
          NoChange = false;
          M2Quads_SubQuad (quad);
        }
    }
}


/*
   FoldIfLess - check to see if it is possible to evaluate
                if op1 < op2 then goto op3.
*/

static void FoldIfLess (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad)
{
  /* Firstly ensure that constant literals are declared.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, left);
  M2GCCDeclare_TryDeclareConstant (tokenno, right);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      if ((SymbolTable_IsValueSolved (left)) && (SymbolTable_IsValueSolved (right)))
        {
          /* We can take advantage of the known values and evaluate the condition.  */
          SymbolTable_PushValue (left);
          SymbolTable_PushValue (right);
          if (M2ALU_Less (tokenno))
            {
              M2Quads_PutQuad (quad, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, destQuad);
            }
          else
            {
              M2Quads_SubQuad (quad);
            }
          NoChange = false;
        }
    }
}


/*
   FoldIfGre - check to see if it is possible to evaluate
               if op1 > op2 then goto op3.
*/

static void FoldIfGre (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad)
{
  /* Firstly ensure that constant literals are declared.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, left);
  M2GCCDeclare_TryDeclareConstant (tokenno, right);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      if ((SymbolTable_IsValueSolved (left)) && (SymbolTable_IsValueSolved (right)))
        {
          /* We can take advantage of the known values and evaluate the condition.  */
          SymbolTable_PushValue (left);
          SymbolTable_PushValue (right);
          if (M2ALU_Gre (tokenno))
            {
              M2Quads_PutQuad (quad, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, destQuad);
            }
          else
            {
              M2Quads_SubQuad (quad);
            }
          NoChange = false;
        }
    }
}


/*
   FoldIfLessEqu - check to see if it is possible to evaluate
                   if op1 <= op2 then goto op3.
*/

static void FoldIfLessEqu (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad)
{
  /* Firstly ensure that constant literals are declared.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, left);
  M2GCCDeclare_TryDeclareConstant (tokenno, right);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      if ((SymbolTable_IsValueSolved (left)) && (SymbolTable_IsValueSolved (right)))
        {
          /* We can take advantage of the known values and evaluate the condition.  */
          SymbolTable_PushValue (left);
          SymbolTable_PushValue (right);
          if (M2ALU_LessEqu (tokenno))
            {
              M2Quads_PutQuad (quad, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, destQuad);
            }
          else
            {
              M2Quads_SubQuad (quad);
            }
          NoChange = false;
        }
    }
}


/*
   FoldIfGreEqu - check to see if it is possible to evaluate
                  if op1 >= op2 then goto op3.
*/

static void FoldIfGreEqu (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad)
{
  /* Firstly ensure that constant literals are declared.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, left);
  M2GCCDeclare_TryDeclareConstant (tokenno, right);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      if ((SymbolTable_IsValueSolved (left)) && (SymbolTable_IsValueSolved (right)))
        {
          /* We can take advantage of the known values and evaluate the condition.  */
          SymbolTable_PushValue (left);
          SymbolTable_PushValue (right);
          if (M2ALU_GreEqu (tokenno))
            {
              M2Quads_PutQuad (quad, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, destQuad);
            }
          else
            {
              M2Quads_SubQuad (quad);
            }
          NoChange = false;
        }
    }
}


/*
   FoldIfIn - check whether we can fold the IfInOp
              if op1 in op2 then goto op3
*/

static void FoldIfIn (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad)
{
  /* Firstly ensure that constant literals are declared.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, left);
  M2GCCDeclare_TryDeclareConstant (tokenno, right);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      if ((SymbolTable_IsValueSolved (left)) && (SymbolTable_IsValueSolved (right)))
        {
          if (CheckBinaryExpressionTypes (quad, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) NoWalkProcedure}))
            {
              /* We can take advantage of the known values and evaluate the condition.  */
              SymbolTable_PushValue (right);
              if (M2ALU_SetIn (tokenno, left))
                {
                  M2Quads_PutQuad (quad, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, destQuad);
                }
              else
                {
                  M2Quads_SubQuad (quad);
                }
            }
          else
            {
              M2Quads_SubQuad (quad);
            }
          NoChange = false;
        }
    }
}


/*
   FoldIfNotIn - check whether we can fold the IfNotInOp
                 if not (op1 in op2) then goto op3
*/

static void FoldIfNotIn (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad)
{
  /* Firstly ensure that constant literals are declared.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, left);
  M2GCCDeclare_TryDeclareConstant (tokenno, right);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      if ((SymbolTable_IsValueSolved (left)) && (SymbolTable_IsValueSolved (right)))
        {
          if (CheckBinaryExpressionTypes (quad, (M2GCCDeclare_WalkAction) {(M2GCCDeclare_WalkAction_t) NoWalkProcedure}))
            {
              /* We can take advantage of the known values and evaluate the
               condition.  */
              SymbolTable_PushValue (right);
              if (! (M2ALU_SetIn (tokenno, left)))
                {
                  M2Quads_PutQuad (quad, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, destQuad);
                }
              else
                {
                  M2Quads_SubQuad (quad);
                }
            }
          else
            {
              M2Quads_SubQuad (quad);
            }
          NoChange = false;
        }
    }
}


/*
   FoldIfEqu - check to see if it is possible to evaluate
               if op1 = op2 then goto op3.
*/

static void FoldIfEqu (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad)
{
  /* Firstly ensure that constant literals are declared.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, left);
  M2GCCDeclare_TryDeclareConstant (tokenno, right);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      if ((SymbolTable_IsValueSolved (left)) && (SymbolTable_IsValueSolved (right)))
        {
          /* We can take advantage of the known values and evaluate the
            condition.  */
          SymbolTable_PushValue (left);
          SymbolTable_PushValue (right);
          if (M2ALU_Equ (tokenno))
            {
              M2Quads_PutQuad (quad, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, destQuad);
            }
          else
            {
              M2Quads_SubQuad (quad);
            }
          NoChange = false;
        }
    }
}


/*
   FoldIfNotEqu - check to see if it is possible to evaluate
                  if op1 # op2 then goto op3.
*/

static void FoldIfNotEqu (unsigned int tokenno, unsigned int quad, unsigned int left, unsigned int right, unsigned int destQuad)
{
  /* Firstly ensure that constant literals are declared.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, left);
  M2GCCDeclare_TryDeclareConstant (tokenno, right);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      if ((SymbolTable_IsValueSolved (left)) && (SymbolTable_IsValueSolved (right)))
        {
          /* We can take advantage of the known values and evaluate the
            condition.  */
          SymbolTable_PushValue (left);
          SymbolTable_PushValue (right);
          if (M2ALU_NotEqu (tokenno))
            {
              M2Quads_PutQuad (quad, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, destQuad);
            }
          else
            {
              M2Quads_SubQuad (quad);
            }
          NoChange = false;
        }
    }
}


/*
   GetSetLimits - assigns low and high to the limits of the declared, set.
*/

static void GetSetLimits (unsigned int set, unsigned int *low, unsigned int *high)
{
  unsigned int type;

  type = SymbolTable_GetType (set);
  if (SymbolTable_IsSubrange (type))
    {
      SymbolTable_GetSubrange (type, high, low);
    }
  else
    {
      (*low) = M2GCCDeclare_GetTypeMin (type);
      (*high) = M2GCCDeclare_GetTypeMax (type);
    }
}


/*
   GetFieldNo - returns the field number in the, set, which contains, element.
*/

static int GetFieldNo (unsigned int tokenno, unsigned int element, unsigned int set, tree *offset)
{
  unsigned int low;
  unsigned int high;
  unsigned int bpw;
  unsigned int c;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  bpw = m2decl_GetBitsPerBitset ();
  GetSetLimits (set, &low, &high);
  /* check element is legal  */
  SymbolTable_PushValue (element);
  SymbolTable_PushValue (low);
  if (M2ALU_Less (tokenno))
    {
      /* out of range  */
      return -1;
    }
  else
    {
      SymbolTable_PushValue (element);
      SymbolTable_PushValue (high);
      if (M2ALU_Gre (tokenno))
        {
          return -1;
        }
    }
  /* all legal  */
  SymbolTable_PushValue (low);
  (*offset) = M2ALU_PopIntegerTree ();
  c = 0;
  SymbolTable_PushValue (element);
  SymbolTable_PushValue (low);
  M2ALU_PushIntegerTree (m2convert_ToCardinal (location, M2ALU_PopIntegerTree ()));
  M2ALU_PushCard (bpw);
  M2ALU_PushIntegerTree (m2convert_ToCardinal (location, M2ALU_PopIntegerTree ()));
  M2ALU_Addn ();
  while (M2ALU_GreEqu (tokenno))
    {
      c += 1;  /* move onto next field  */
      SymbolTable_PushValue (element);  /* move onto next field  */
      M2ALU_PushIntegerTree (m2convert_ToCardinal (location, M2ALU_PopIntegerTree ()));
      M2ALU_PushCard ((c+1)*bpw);
      SymbolTable_PushValue (low);
      M2ALU_PushIntegerTree (m2convert_ToCardinal (location, M2ALU_PopIntegerTree ()));
      M2ALU_Addn ();
      M2ALU_PushIntegerTree ((*offset));
      M2ALU_PushIntegerTree (m2convert_ToCardinal (location, M2ALU_PopIntegerTree ()));
      M2ALU_PushCard (bpw);
      M2ALU_PushIntegerTree (m2convert_ToCardinal (location, M2ALU_PopIntegerTree ()));
      M2ALU_Addn ();
      (*offset) = M2ALU_PopIntegerTree ();
    }
  return (int ) (c);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeIncl - encode an InclOp:
              result := result + (1 << expr)
*/

static void CodeIncl (unsigned int result, unsigned int expr)
{
  unsigned int low;
  unsigned int high;
  tree offset;
  int fieldno;
  location_t location;

  /* firstly ensure that constant literals are declared  */
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, expr);
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if (SymbolTable_IsConst (result))
    {
      if (SymbolTable_IsConst (expr))
        {
          M2Error_InternalError ((const char *) "this quadruple should have been removed by FoldIncl", 51);
        }
      else
        {
          M2Error_InternalError ((const char *) "should not get to here (why are we generating <incl const, var> ?)", 66);
        }
    }
  else
    {
      if (SymbolTable_IsConst (expr))
        {
          fieldno = GetFieldNo (CurrentQuadToken, expr, SymbolTable_GetType (result), &offset);
          if (fieldno >= 0)
            {
              SymbolTable_PushValue (expr);
              M2ALU_PushIntegerTree (offset);
              M2ALU_Sub ();
              m2statement_BuildIncludeVarConst (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (result)), SymbolConversion_Mod2Gcc (result), M2ALU_PopIntegerTree (), (SymbolTable_GetMode (result)) == SymbolTable_LeftValue, fieldno);
            }
          else
            {
              M2MetaError_MetaErrorT1 (CurrentQuadToken, (const char *) "bit exceeded the range of set {%1Eatd}", 38, result);
            }
        }
      else
        {
          GetSetLimits (SymbolTable_GetType (result), &low, &high);
          m2statement_BuildIncludeVarVar (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (result)), SymbolConversion_Mod2Gcc (result), SymbolConversion_Mod2Gcc (expr), (SymbolTable_GetMode (result)) == SymbolTable_LeftValue, SymbolConversion_Mod2Gcc (low));
        }
    }
}


/*
   FoldExcl - check whether we can fold the InclOp.
              op1 := op1 - (1 << op3)
*/

static void FoldExcl (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int expr)
{
  /* firstly ensure that constant literals are declared  */
  M2GCCDeclare_TryDeclareConstant (tokenno, expr);
  if ((SymbolTable_IsConst (result)) && (SymbolTable_IsConst (expr)))
    {
      if ((SymbolConversion_GccKnowsAbout (expr)) && (SymbolTable_IsValueSolved (result)))
        {
          SymbolTable_PushValue (result);
          M2ALU_SubBit (tokenno, expr);
          SymbolConversion_AddModGcc (result, M2ALU_PopSetTree (tokenno));
          (*p.proc) (result);
          NoChange = false;
          M2Quads_SubQuad (quad);
        }
    }
}


/*
   CodeExcl - encode an ExclOp:
              result := result - (1 << expr)
*/

static void CodeExcl (unsigned int result, unsigned int expr)
{
  unsigned int low;
  unsigned int high;
  tree offset;
  int fieldno;
  location_t location;

  /* firstly ensure that constant literals are declared  */
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, expr);
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if (SymbolTable_IsConst (result))
    {
      M2Error_InternalError ((const char *) "should not get to here (if we do we should consider calling FoldInclOp)", 71);
    }
  else
    {
      if (SymbolTable_IsConst (expr))
        {
          fieldno = GetFieldNo (CurrentQuadToken, expr, SymbolTable_GetType (result), &offset);
          if (fieldno >= 0)
            {
              SymbolTable_PushValue (expr);
              M2ALU_PushIntegerTree (offset);
              M2ALU_Sub ();
              m2statement_BuildExcludeVarConst (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (result)), SymbolConversion_Mod2Gcc (result), M2ALU_PopIntegerTree (), (SymbolTable_GetMode (result)) == SymbolTable_LeftValue, fieldno);
            }
          else
            {
              M2MetaError_MetaErrorT1 (CurrentQuadToken, (const char *) "bit exceeded the range of set {%1Eatd}", 38, result);
            }
        }
      else
        {
          GetSetLimits (SymbolTable_GetType (result), &low, &high);
          m2statement_BuildExcludeVarVar (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (result)), SymbolConversion_Mod2Gcc (result), SymbolConversion_Mod2Gcc (expr), (SymbolTable_GetMode (result)) == SymbolTable_LeftValue, SymbolConversion_Mod2Gcc (low));
        }
    }
}


/*
   FoldUnary - check whether we can fold the unop operation.
*/

static void FoldUnary (unsigned int tokenno, M2GCCDeclare_WalkAction p, m2expr_BuildUnaryProcedure unop, tree ZConstToTypedConst, unsigned int quad, unsigned int result, unsigned int expr)
{
  tree tv;
  location_t location;

  /* firstly ensure that any constant literal is declared  */
  M2GCCDeclare_TryDeclareConstant (tokenno, expr);
  location = M2LexBuf_TokenToLocation (tokenno);
  if (SymbolTable_IsConst (expr))
    {
      if (SymbolConversion_GccKnowsAbout (expr))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          /* fine, we can take advantage of this and fold constants  */
          if (SymbolTable_IsConst (result))
            {
              if (ZConstToTypedConst == ((tree) (NULL)))
                {
                  /* avoid gcc warning by using compound statement even if not strictly necessary.  */
                  if (((SymbolTable_GetType (expr)) == SymbolTable_NulSym) || (M2Base_IsOrdinalType (SymbolTable_SkipType (SymbolTable_GetType (expr)))))
                    {
                      ZConstToTypedConst = m2type_GetM2ZType ();
                    }
                  else if ((M2Base_IsRealType (SymbolTable_SkipType (SymbolTable_GetType (expr)))) || (M2System_IsRealN (SymbolTable_SkipType (SymbolTable_GetType (expr)))))
                    {
                      /* avoid dangling else.  */
                      ZConstToTypedConst = m2type_GetM2RType ();
                    }
                  else if ((M2Base_IsComplexType (SymbolTable_SkipType (SymbolTable_GetType (expr)))) || (M2System_IsComplexN (SymbolTable_SkipType (SymbolTable_GetType (expr)))))
                    {
                      /* avoid dangling else.  */
                      ZConstToTypedConst = m2type_GetM2CType ();
                    }
                }
              if ((SymbolTable_GetType (result)) == SymbolTable_NulSym)
                {
                  SymbolTable_PutConst (result, M2Base_NegateType (SymbolTable_GetType (expr)));  /* , tokenno  */
                }
              tv = (*unop.proc) (location, LValueToGenericPtrOrConvert (expr, ZConstToTypedConst), false);
              M2ALU_CheckOrResetOverflow (tokenno, tv, M2Quads_MustCheckOverflow (quad));
              SymbolConversion_AddModGcc (result, m2decl_DeclareKnownConstant (location, ZConstToTypedConst, tv));
              (*p.proc) (result);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
          /* we can still fold the expression, but not the assignment, however, we will
               not do this here but in CodeUnary
  */
        }
    }
}


/*
   FoldUnarySet - check whether we can fold the doOp operation.
*/

static void FoldUnarySet (unsigned int tokenno, M2GCCDeclare_WalkAction p, M2GenGCC_DoUnaryProcedure doOp, unsigned int quad, unsigned int result, unsigned int expr)
{
  location_t location;

  /* firstly try and ensure that constants are declared  */
  M2GCCDeclare_TryDeclareConstant (tokenno, expr);
  location = M2LexBuf_TokenToLocation (tokenno);
  if (((SymbolTable_IsConst (expr)) && (SymbolTable_IsConstSet (expr))) && (SymbolTable_IsConst (result)))
    {
      if ((SymbolTable_IsValueSolved (expr)) && ((SymbolTable_GetType (expr)) != SymbolTable_NulSym))
        {
          SymbolTable_PutConst (result, FindType (expr));
          SymbolTable_PushValue (expr);
          (*doOp.proc) (tokenno);
          SymbolTable_PopValue (result);
          SymbolTable_PushValue (result);
          SymbolTable_PutConstSet (result);
          SymbolConversion_AddModGcc (result, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (expr)), M2ALU_PopSetTree (tokenno)));
          (*p.proc) (result);
          NoChange = false;
          M2Quads_SubQuad (quad);
        }
    }
}


/*
   CodeUnaryCheck - encode a unary arithmetic operation.
*/

static void CodeUnaryCheck (m2expr_BuildUnaryCheckProcedure unop, tree ZConstToTypedConst, unsigned int quad, unsigned int result, unsigned int expr)
{
  unsigned int lowestType;
  tree min;
  tree max;
  tree lowest;
  tree tv;
  location_t location;

  /* firstly ensure that any constant literal is declared  */
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, expr);
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, expr);
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  lowestType = SymbolTable_GetLType (result);
  if (lowestType == SymbolTable_NulSym)
    {
      lowest = NULL;
    }
  else
    {
      lowest = SymbolConversion_Mod2Gcc (lowestType);
    }
  if (M2Range_GetMinMax (CurrentQuadToken, lowestType, &min, &max))
    {
      tv = (*unop.proc) (location, M2GenGCC_LValueToGenericPtr (location, expr), lowest, min, max);
    }
  else
    {
      tv = (*unop.proc) (location, M2GenGCC_LValueToGenericPtr (location, expr), NULL, NULL, NULL);
    }
  M2ALU_CheckOrResetOverflow (CurrentQuadToken, tv, M2Quads_MustCheckOverflow (quad));
  if (SymbolTable_IsConst (result))
    {
      if (ZConstToTypedConst == ((tree) (NULL)))
        {
          ZConstToTypedConst = (tree) (SymbolConversion_Mod2Gcc (SymbolTable_GetType (expr)));
        }
      /* still have a constant which was not resolved, pass it to gcc  */
      SymbolTable_PutConst (result, FindType (expr));
      M2GCCDeclare_ConstantKnownAndUsed (result, m2decl_DeclareKnownConstant (location, ZConstToTypedConst, tv));
    }
  else
    {
      if (M2SSA_EnableSSA && (SymbolTable_IsVariableSSA (result)))
        {
          Replace (result, tv);
        }
      else
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), tv);
        }
    }
}


/*
   CodeUnary - encode a unary arithmetic operation.
*/

static void CodeUnary (m2expr_BuildUnaryProcedure unop, tree ZConstToTypedConst, unsigned int quad, unsigned int result, unsigned int expr)
{
  tree tv;
  location_t location;

  /* firstly ensure that any constant literal is declared  */
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, expr);
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, expr);
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  tv = (*unop.proc) (location, M2GenGCC_LValueToGenericPtr (location, expr), false);
  M2ALU_CheckOrResetOverflow (CurrentQuadToken, tv, M2Quads_MustCheckOverflow (quad));
  if (SymbolTable_IsConst (result))
    {
      if (ZConstToTypedConst == ((tree) (NULL)))
        {
          ZConstToTypedConst = (tree) (SymbolConversion_Mod2Gcc (SymbolTable_GetType (expr)));
        }
      /* still have a constant which was not resolved, pass it to gcc  */
      SymbolTable_PutConst (result, FindType (expr));
      M2GCCDeclare_ConstantKnownAndUsed (result, m2decl_DeclareKnownConstant (location, ZConstToTypedConst, tv));
    }
  else
    {
      if (M2SSA_EnableSSA && (SymbolTable_IsVariableSSA (result)))
        {
          Replace (result, tv);
        }
      else
        {
          m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), tv);
        }
    }
}


/*
   FoldNegate - check unary negate for constant folding.
*/

static void FoldNegate (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int expr)
{
  if (SymbolTable_IsConstSet (expr))
    {
      FoldUnarySet (tokenno, p, (M2GenGCC_DoUnaryProcedure) {(M2GenGCC_DoUnaryProcedure_t) M2ALU_SetNegate}, quad, result, expr);
    }
  else
    {
      FoldUnary (tokenno, p, (m2expr_BuildUnaryProcedure) {(m2expr_BuildUnaryProcedure_t) m2expr_BuildNegate}, NULL, quad, result, expr);
    }
}


/*
   CodeNegateChecked - code a negate instruction, determine whether checking
                       is required.
*/

static void CodeNegateChecked (unsigned int quad, unsigned int op1, unsigned int op3)
{
  if ((SymbolTable_IsConstSet (op3)) || (SymbolTable_IsSet (SymbolTable_GetType (op3))))
    {
      CodeUnarySet ((m2expr_BuildUnarySetFunction) {(m2expr_BuildUnarySetFunction_t) m2expr_BuildSetNegate}, (M2GenGCC_DoUnaryProcedure) {(M2GenGCC_DoUnaryProcedure_t) M2ALU_SetNegate}, quad, op1, op3);
    }
  else if (UnaryOperand (quad, op3))
    {
      /* avoid dangling else.  */
      if (M2Quads_MustCheckOverflow (quad))
        {
          CodeUnaryCheck ((m2expr_BuildUnaryCheckProcedure) {(m2expr_BuildUnaryCheckProcedure_t) m2expr_BuildNegateCheck}, NULL, quad, op1, op3);
        }
      else
        {
          CodeUnary ((m2expr_BuildUnaryProcedure) {(m2expr_BuildUnaryProcedure_t) m2expr_BuildNegate}, NULL, quad, op1, op3);
        }
    }
}


/*
   FoldSize - check unary SIZE for constant folding.
*/

static void FoldSize (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  tree t;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  if ((SymbolTable_IsConst (op1)) && (M2GCCDeclare_CompletelyResolved (op3)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (op2 == SymbolTable_NulSym)
        {
          t = m2expr_BuildSize (location, SymbolConversion_Mod2Gcc (op3), false);
          M2ALU_PushIntegerTree (t);
          SymbolTable_PopValue (op1);
          SymbolTable_PutConst (op1, M2Base_Cardinal);
          (*p.proc) (op1);
          NoChange = false;
          M2Quads_SubQuad (quad);
          t = m2block_RememberConstant (t);
        }
      else if (SymbolConversion_GccKnowsAbout (op2))
        {
          /* avoid dangling else.  */
          /* ignore the chosen varients as we implement it as a C union  */
          t = m2expr_BuildSize (location, SymbolConversion_Mod2Gcc (op3), false);
          M2ALU_PushIntegerTree (t);
          SymbolTable_PopValue (op1);
          SymbolTable_PutConst (op1, M2Base_Cardinal);
          (*p.proc) (op1);
          NoChange = false;
          M2Quads_SubQuad (quad);
          t = m2block_RememberConstant (t);
        }
    }
}


/*
   CodeSize - encode the inbuilt SIZE function.
*/

static void CodeSize (unsigned int result, unsigned int sym)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  M2ALU_PushIntegerTree (m2expr_BuildSize (location, SymbolConversion_Mod2Gcc (sym), false));
  if (SymbolTable_IsConst (result))
    {
      SymbolTable_PopValue (result);
      SymbolTable_PutConst (result, M2Base_Cardinal);
      SymbolTable_PushValue (result);
      M2GCCDeclare_ConstantKnownAndUsed (result, m2decl_DeclareKnownConstant (location, m2type_GetIntegerType (), M2ALU_PopIntegerTree ()));
    }
  else
    {
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), M2ALU_PopIntegerTree ());
    }
}


/*
   FoldRecordField - check whether we can fold an RecordFieldOp quadruple.
                     Very similar to FoldBinary, except that we need to
                     hard code a few parameters to the gcc backend.
*/

static void FoldRecordField (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int record, unsigned int field)
{
  unsigned int recordType;
  unsigned int fieldType;
  tree ptr;
  location_t location;

  return;  /* this procedure should no longer be called  */
  location = M2LexBuf_TokenToLocation (tokenno);
  /* firstly ensure that any constant literal is declared  */
  M2GCCDeclare_TryDeclareConstant (tokenno, record);
  if ((SymbolTable_IsRecordField (record)) || (SymbolTable_IsFieldVarient (record)))
    {
      recordType = SymbolTable_GetType (record);
      fieldType = SymbolTable_GetType (field);
      if ((((((SymbolConversion_GccKnowsAbout (record)) && (SymbolConversion_GccKnowsAbout (field))) && (SymbolConversion_GccKnowsAbout (recordType))) && (SymbolConversion_GccKnowsAbout (fieldType))) && (M2GCCDeclare_CompletelyResolved (recordType))) && (M2GCCDeclare_CompletelyResolved (fieldType)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          /* fine, we can take advantage of this and fold constants  */
          if (SymbolTable_IsConst (result))
            {
              ptr = m2expr_BuildComponentRef (location, SymbolConversion_Mod2Gcc (record), SymbolConversion_Mod2Gcc (field));
              if (! (SymbolTable_IsValueSolved (result)))
                {
                  M2ALU_PushIntegerTree (ptr);
                  SymbolTable_PopValue (result);
                }
              SymbolTable_PutConst (result, fieldType);
              SymbolConversion_AddModGcc (result, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (fieldType), ptr));
              (*p.proc) (result);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
          /* we can still fold the expression, but not the assignment, however, we will
               not do this here but in CodeOffset
  */
        }
    }
}


/*
   CodeRecordField - encode a reference to a field within a record.
*/

static void CodeRecordField (unsigned int result, unsigned int record, unsigned int field)
{
  unsigned int recordType;
  unsigned int fieldType;
  tree ptr;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  /* firstly ensure that any constant literal is declared  */
  if ((SymbolTable_IsRecordField (field)) || (SymbolTable_IsFieldVarient (field)))
    {
      recordType = SymbolTable_GetType (record);
      fieldType = SymbolTable_GetType (field);
      if ((((((SymbolConversion_GccKnowsAbout (record)) && (SymbolConversion_GccKnowsAbout (field))) && (SymbolConversion_GccKnowsAbout (recordType))) && (SymbolConversion_GccKnowsAbout (fieldType))) && (M2GCCDeclare_CompletelyResolved (recordType))) && (M2GCCDeclare_CompletelyResolved (fieldType)))
        {
          if ((SymbolTable_GetMode (record)) == SymbolTable_LeftValue)
            {
              ptr = m2expr_BuildComponentRef (location, m2expr_BuildIndirect (location, SymbolConversion_Mod2Gcc (record), SymbolConversion_Mod2Gcc (recordType)), SymbolConversion_Mod2Gcc (field));
            }
          else
            {
              ptr = m2expr_BuildComponentRef (location, SymbolConversion_Mod2Gcc (record), SymbolConversion_Mod2Gcc (field));
            }
          SymbolConversion_AddModGcc (result, ptr);
        }
      else
        {
          M2Error_InternalError ((const char *) "symbol type should have been declared by now", 44);
        }
    }
  else
    {
      M2Error_InternalError ((const char *) "not expecting this type of symbol", 33);
    }
}


/*
   BuildHighFromChar -
*/

static tree BuildHighFromChar (unsigned int operand)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (operand));
  if ((SymbolTable_IsConstString (operand)) && ((SymbolTable_IsConstStringM2nul (operand)) || (SymbolTable_IsConstStringCnul (operand))))
    {
      return m2expr_GetCardinalOne (location);
    }
  return m2expr_GetCardinalZero (location);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SkipToArray -
*/

static unsigned int SkipToArray (unsigned int operand, unsigned int dim)
{
  unsigned int type;

  while (dim > 1)
    {
      type = SymbolTable_SkipType (SymbolTable_GetType (operand));
      if (SymbolTable_IsArray (type))
        {
          operand = type;
        }
      dim -= 1;
    }
  return operand;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildHighFromArray -
*/

static tree BuildHighFromArray (unsigned int tokenno, unsigned int dim, unsigned int operand)
{
  unsigned int Type;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  Type = SymbolTable_SkipType (SymbolTable_GetType (SkipToArray (operand, dim)));
  return BuildHighFromStaticArray (location, Type);  /* dim,  */
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildHighFromStaticArray -
*/

static tree BuildHighFromStaticArray (location_t location, unsigned int Type)
{
  unsigned int High;
  unsigned int Low;
  unsigned int Subscript;
  unsigned int Subrange;

  M2Debug_Assert (SymbolTable_IsArray (Type));  /* dim,  */
  Subscript = SymbolTable_GetArraySubscript (Type);
  Subrange = SymbolTable_SkipType (SymbolTable_GetType (Subscript));
  if (SymbolTable_IsEnumeration (Subrange))
    {
      /* avoid dangling else.  */
      M2Base_GetBaseTypeMinMax (Subrange, &Low, &High);
      if (SymbolConversion_GccKnowsAbout (High))
        {
          return (tree) (SymbolConversion_Mod2Gcc (High));
        }
    }
  else if (SymbolTable_IsSubrange (Subrange))
    {
      /* avoid dangling else.  */
      SymbolTable_GetSubrange (Subrange, &High, &Low);
      if ((SymbolConversion_GccKnowsAbout (Low)) && (SymbolConversion_GccKnowsAbout (High)))
        {
          return m2expr_BuildSub (location, SymbolConversion_Mod2Gcc (High), SymbolConversion_Mod2Gcc (Low), true);
        }
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "array subscript {%1EDad:for} must be a subrange or enumeration type", 67, Type);
      return (tree) (NULL);
    }
  if (SymbolConversion_GccKnowsAbout (High))
    {
      return (tree) (SymbolConversion_Mod2Gcc (High));
    }
  else
    {
      return (tree) (NULL);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildHighFromString -
*/

static tree BuildHighFromString (unsigned int operand)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (operand));
  if ((SymbolConversion_GccKnowsAbout (operand)) && ((m2expr_StringLength (SymbolConversion_Mod2Gcc (operand))) > 0))
    {
      return m2decl_BuildIntegerConstant (static_cast<int> ((m2expr_StringLength (SymbolConversion_Mod2Gcc (operand)))-1));
    }
  else
    {
      return m2expr_GetIntegerZero (location);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ResolveHigh - given an Modula-2 operand, it resolves the HIGH(operand)
                 and returns a GCC constant symbol containing the value of
                 HIGH(operand).
*/

static tree ResolveHigh (unsigned int tokenno, unsigned int dim, unsigned int operand)
{
  unsigned int Type;
  location_t location;

  Type = SymbolTable_SkipType (SymbolTable_GetType (operand));
  location = M2LexBuf_TokenToLocation (tokenno);
  if ((Type == M2Base_Char) && (dim == 1))
    {
      return BuildHighFromChar (operand);
    }
  else if ((SymbolTable_IsConstString (operand)) && (dim == 1))
    {
      /* avoid dangling else.  */
      return BuildHighFromString (operand);
    }
  else if (SymbolTable_IsArray (Type))
    {
      /* avoid dangling else.  */
      return BuildHighFromArray (tokenno, dim, operand);
    }
  else if (SymbolTable_IsUnbounded (Type))
    {
      /* avoid dangling else.  */
      return M2GenGCC_GetHighFromUnbounded (location, dim, operand);
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT1 (tokenno, (const char *) "base procedure HIGH expects a variable of type array or a constant string or CHAR as its parameter, rather than {%1Etad}", 120, operand);
      return m2expr_GetIntegerZero (location);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldHigh - if the array is not dynamic then we should be able to
              remove the HighOp quadruple and assign op1 with
              the known compile time HIGH(op3).
*/

static void FoldHigh (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int dim, unsigned int op3)
{
  tree t;
  location_t location;

  /* firstly ensure that any constant literal is declared  */
  M2GCCDeclare_TryDeclareConstant (tokenno, op3);
  location = M2LexBuf_TokenToLocation (tokenno);
  if ((SymbolConversion_GccKnowsAbout (op3)) && (M2GCCDeclare_CompletelyResolved (op3)))
    {
      t = ResolveHigh (tokenno, dim, op3);
      /* fine, we can take advantage of this and fold constants  */
      if ((SymbolTable_IsConst (op1)) && (t != ((tree) (NULL))))
        {
          SymbolTable_PutConst (op1, M2Base_Cardinal);
          SymbolConversion_AddModGcc (op1, m2decl_DeclareKnownConstant (location, m2type_GetCardinalType (), m2convert_ToCardinal (location, t)));
          (*p.proc) (op1);
          NoChange = false;
          M2Quads_SubQuad (quad);
        }
      /* we can still fold the expression, but not the assignment, however, we will
            not do this here but in CodeHigh
  */
    }
}


/*
   CodeHigh - encode a unary arithmetic operation.
*/

static void CodeHigh (unsigned int result, unsigned int dim, unsigned int array)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  /* firstly ensure that any constant literal is declared  */
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, array);
  if (SymbolTable_IsConst (result))
    {
      /* still have a constant which was not resolved, pass it to gcc  */
      M2GCCDeclare_ConstantKnownAndUsed (result, m2decl_DeclareKnownConstant (location, m2type_GetM2ZType (), ResolveHigh (CurrentQuadToken, dim, array)));
    }
  else
    {
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (result)), ResolveHigh (CurrentQuadToken, dim, array), false));
    }
}


/*
   CodeUnbounded - codes the creation of an unbounded parameter variable.
                   places the address of op3 into *op1
*/

static void CodeUnbounded (unsigned int result, unsigned int array)
{
  tree Addr;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, array);
  if ((SymbolTable_IsConstString (array)) || ((SymbolTable_IsConst (array)) && ((SymbolTable_GetSType (array)) == M2Base_Char)))
    {
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2expr_BuildAddr (location, M2GCCDeclare_PromoteToString (CurrentQuadToken, array), false));
    }
  else if (SymbolTable_IsConstructor (array))
    {
      /* avoid dangling else.  */
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2expr_BuildAddr (location, SymbolConversion_Mod2Gcc (array), true));
    }
  else if (SymbolTable_IsUnbounded (SymbolTable_GetType (array)))
    {
      /* avoid dangling else.  */
      if ((SymbolTable_GetMode (array)) == SymbolTable_LeftValue)
        {
          Addr = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (result)), SymbolConversion_Mod2Gcc (array), false);
        }
      else
        {
          Addr = m2expr_BuildComponentRef (location, SymbolConversion_Mod2Gcc (array), SymbolConversion_Mod2Gcc (SymbolTable_GetUnboundedAddressOffset (SymbolTable_GetType (array))));
        }
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), Addr);
    }
  else if ((SymbolTable_GetMode (array)) == SymbolTable_RightValue)
    {
      /* avoid dangling else.  */
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), m2expr_BuildAddr (location, SymbolConversion_Mod2Gcc (array), false));
    }
  else
    {
      /* avoid dangling else.  */
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (result), SymbolConversion_Mod2Gcc (array));
    }
}


/*
   AreSubrangesKnown - returns TRUE if the subranges values used within, array, are known.
*/

static bool AreSubrangesKnown (unsigned int array)
{
  unsigned int type;
  unsigned int subscript;
  unsigned int low;
  unsigned int high;

  if (SymbolConversion_GccKnowsAbout (array))
    {
      subscript = SymbolTable_GetArraySubscript (array);
      if (subscript == SymbolTable_NulSym)
        {
          M2Error_InternalError ((const char *) "not expecting a NulSym as a subscript", 37);
        }
      else
        {
          type = SymbolTable_SkipType (SymbolTable_GetType (subscript));
          low = M2GCCDeclare_GetTypeMin (type);
          high = M2GCCDeclare_GetTypeMax (type);
          return (SymbolConversion_GccKnowsAbout (low)) && (SymbolConversion_GccKnowsAbout (high));
        }
    }
  else
    {
      return false;
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2GenGCC.def", 20, 1);
  __builtin_unreachable ();
}


/*
   CodeArray - res is an lvalue which will point to the array element.
*/

static void CodeArray (unsigned int res, unsigned int index, unsigned int array)
{
  unsigned int resType;
  unsigned int arrayDecl;
  unsigned int type;
  unsigned int low;
  unsigned int subscript;
  tree a;
  tree ta;
  tree ti;
  tree tl;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  arrayDecl = SymbolTable_SkipType (SymbolTable_GetType (array));
  if (AreSubrangesKnown (arrayDecl))
    {
      subscript = SymbolTable_GetArraySubscript (arrayDecl);
      type = SymbolTable_SkipType (SymbolTable_GetType (subscript));
      low = M2GCCDeclare_GetTypeMin (type);
      resType = SymbolTable_GetVarBackEndType (res);
      if (resType == SymbolTable_NulSym)
        {
          resType = SymbolTable_SkipType (SymbolTable_GetType (res));
        }
      ta = SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (arrayDecl)));
      if ((SymbolTable_GetMode (array)) == SymbolTable_LeftValue)
        {
          a = m2expr_BuildIndirect (location, SymbolConversion_Mod2Gcc (array), SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (array))));
        }
      else
        {
          a = SymbolConversion_Mod2Gcc (array);
        }
      if (SymbolTable_IsArrayLarge (arrayDecl))
        {
          tl = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (type), SymbolConversion_Mod2Gcc (low), false);
          ti = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (type), SymbolConversion_Mod2Gcc (index), false);
          ti = m2convert_BuildConvert (location, m2type_GetIntegerType (), m2expr_BuildSub (location, ti, tl, false), false);
          tl = m2expr_GetIntegerZero (location);
        }
      else
        {
          tl = m2convert_BuildConvert (location, m2type_GetIntegerType (), SymbolConversion_Mod2Gcc (low), false);
          ti = m2convert_BuildConvert (location, m2type_GetIntegerType (), SymbolConversion_Mod2Gcc (index), false);
        }
      /* ti := BuildConvert(location, GetIntegerType(), Mod2Gcc(high), FALSE) ;  */
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (res), m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (resType), m2expr_BuildAddr (location, m2expr_BuildArray (location, ta, a, ti, tl), false), false));
    }
  else
    {
      M2Error_InternalError ((const char *) "subranges not yet resolved", 26);
    }
}


/*
   FoldElementSizeForArray - attempts to calculate the Subscript
                             multiplier for the index op3.
*/

static void FoldElementSizeForArray (unsigned int tokenno, unsigned int quad, M2GCCDeclare_WalkAction p, unsigned int result, unsigned int type)
{
  unsigned int Subscript;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  if ((SymbolTable_IsConst (result)) && (! (SymbolConversion_GccKnowsAbout (result))))
    {
      Subscript = SymbolTable_GetArraySubscript (type);
      if (SymbolTable_IsSizeSolved (Subscript))
        {
          SymbolTable_PutConst (result, M2Base_Integer);
          SymbolTable_PushSize (Subscript);
          SymbolConversion_AddModGcc (result, m2decl_DeclareKnownConstant (location, m2type_GetCardinalType (), m2convert_BuildConvert (location, m2type_GetCardinalType (), M2ALU_PopIntegerTree (), true)));
          (*p.proc) (result);
          NoChange = false;
          M2Quads_SubQuad (quad);
        }
    }
}


/*
   FoldElementSizeForUnbounded - Unbounded arrays only have one index,
                                 therefore element size will be the
                                 TSIZE(Type) where Type is defined as:
                                 ARRAY OF Type.
*/

static void FoldElementSizeForUnbounded (unsigned int tokenno, unsigned int quad, M2GCCDeclare_WalkAction p, unsigned int result, unsigned int ArrayType)
{
  unsigned int Type;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  if (SymbolTable_IsConst (result))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolConversion_GccKnowsAbout (result))
        {
          M2Error_InternalError ((const char *) "cannot assign a value twice to a constant", 41);
        }
      else
        {
          M2Debug_Assert (SymbolTable_IsUnbounded (ArrayType));
          Type = SymbolTable_GetType (ArrayType);
          if (SymbolConversion_GccKnowsAbout (Type))
            {
              SymbolTable_PutConst (result, M2Base_Cardinal);
              SymbolConversion_AddModGcc (result, m2decl_DeclareKnownConstant (location, m2type_GetCardinalType (), m2convert_BuildConvert (location, m2type_GetCardinalType (), FindSize (tokenno, Type), true)));
              (*p.proc) (result);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
        }
    }
}


/*
   FoldElementSize - folds the element size for an ArraySym or UnboundedSym.
                     ElementSize returns a constant which defines the
                     multiplier to be multiplied by this element index.
*/

static void FoldElementSize (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int type)
{
  if (SymbolTable_IsUnbounded (type))
    {
      FoldElementSizeForUnbounded (tokenno, quad, p, result, type);
    }
  else if (SymbolTable_IsArray (type))
    {
      /* avoid dangling else.  */
      FoldElementSizeForArray (tokenno, quad, p, result, type);
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "expecting UnboundedSym or ArraySym", 34);
    }
}


/*
   PopKindTree - returns a Tree from M2ALU of the type implied by, op.
*/

static tree PopKindTree (unsigned int op, unsigned int tokenno)
{
  unsigned int type;

  if ((SymbolTable_IsConst (op)) && (SymbolTable_IsConstString (op)))
    {
      /* Converting a nul char or char for example.  */
      return M2ALU_PopIntegerTree ();
    }
  else
    {
      type = SymbolTable_SkipType (SymbolTable_GetType (op));
      if (SymbolTable_IsSet (type))
        {
          return M2ALU_PopSetTree (tokenno);
        }
      else if (M2Base_IsRealType (type))
        {
          /* avoid dangling else.  */
          return M2ALU_PopRealTree ();
        }
      else
        {
          /* avoid dangling else.  */
          return M2ALU_PopIntegerTree ();
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldConvert - attempts to fold expr to type into result
                 providing that result and expr are constants.
                 If required convert will alter the machine representation
                 of expr to comply with type.
*/

static void FoldConvert (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int result, unsigned int type, unsigned int expr)
{
  tree tl;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  /* First ensure that constant literals are declared.  */
  M2GCCDeclare_TryDeclareConstant (tokenno, expr);
  if (IsConstant (expr))
    {
      if (((SymbolConversion_GccKnowsAbout (type)) && ((SymbolTable_IsProcedure (expr)) || (SymbolTable_IsValueSolved (expr)))) && (SymbolConversion_GccKnowsAbout (SymbolTable_SkipType (type))))
        {
          /* The type is known and expr is resolved so fold the convert.  */
          if (SymbolTable_IsConst (result))
            {
              SymbolTable_PutConst (result, type);  /* Change result type just in case.  */
              tl = SymbolConversion_Mod2Gcc (SymbolTable_SkipType (type));  /* Change result type just in case.  */
              if (SymbolTable_IsProcedure (expr))
                {
                  SymbolConversion_AddModGcc (result, m2convert_BuildConvert (location, tl, SymbolConversion_Mod2Gcc (expr), true));
                }
              else
                {
                  SymbolTable_PushValue (expr);
                  if (SymbolTable_IsConstSet (expr))
                    {
                      if (SymbolTable_IsSet (SymbolTable_SkipType (type)))
                        {
                          M2Error_WriteFormat0 ((const char *) "cannot convert values between sets", 34);
                        }
                      else
                        {
                          M2ALU_PushIntegerTree (m2expr_FoldAndStrip (m2convert_BuildConvert (location, tl, M2ALU_PopSetTree (tokenno), true)));
                          SymbolTable_PopValue (result);
                          SymbolTable_PushValue (result);
                          SymbolConversion_AddModGcc (result, M2ALU_PopIntegerTree ());
                        }
                    }
                  else
                    {
                      if (SymbolTable_IsSet (SymbolTable_SkipType (type)))
                        {
                          M2ALU_PushSetTree (tokenno, m2expr_FoldAndStrip (m2convert_BuildConvert (location, tl, PopKindTree (expr, tokenno), true)), SymbolTable_SkipType (type));
                          SymbolTable_PopValue (result);
                          SymbolTable_PutConstSet (result);
                          SymbolTable_PushValue (result);
                          SymbolConversion_AddModGcc (result, M2ALU_PopSetTree (tokenno));
                        }
                      else if (M2Base_IsRealType (SymbolTable_SkipType (type)))
                        {
                          /* avoid dangling else.  */
                          M2ALU_PushRealTree (m2expr_FoldAndStrip (m2convert_BuildConvert (location, tl, PopKindTree (expr, tokenno), true)));
                          SymbolTable_PopValue (result);
                          SymbolTable_PushValue (result);
                          SymbolConversion_AddModGcc (result, PopKindTree (result, tokenno));
                        }
                      else
                        {
                          /* avoid dangling else.  */
                          /* Let CheckOverflow catch a potential overflow rather than BuildConvert.  */
                          M2ALU_PushIntegerTree (m2expr_FoldAndStrip (m2convert_BuildConvert (location, tl, PopKindTree (expr, tokenno), false)));
                          SymbolTable_PopValue (result);
                          SymbolTable_PushValue (result);
                          M2ALU_CheckOrResetOverflow (tokenno, PopKindTree (result, tokenno), M2Quads_MustCheckOverflow (quad));
                          SymbolTable_PushValue (result);
                          SymbolConversion_AddModGcc (result, PopKindTree (result, tokenno));
                        }
                    }
                }
              (*p.proc) (result);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
        }
    }
}


/*
   CodeConvert - Converts, rhs, to, type, placing the result into lhs.
                 Convert will, if need be, alter the machine representation
                 of op3 to comply with TYPE op2.
*/

static void CodeConvert (unsigned int quad, unsigned int lhs, unsigned int type, unsigned int rhs)
{
  tree tl;
  tree tr;
  location_t location;

  CheckStop (quad);
  /* firstly ensure that constant literals are declared  */
  M2GCCDeclare_DeclareConstant (CurrentQuadToken, rhs);
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, rhs);
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  tl = M2GenGCC_LValueToGenericPtr (location, type);
  if (SymbolTable_IsProcedure (rhs))
    {
      tr = m2expr_BuildAddr (location, SymbolConversion_Mod2Gcc (rhs), false);
    }
  else
    {
      tr = M2GenGCC_LValueToGenericPtr (location, rhs);
      tr = ConvertRHS (tr, type, rhs);
    }
  if (SymbolTable_IsConst (lhs))
    {
      /* fine, we can take advantage of this and fold constant  */
      SymbolTable_PutConst (lhs, type);
      tl = SymbolConversion_Mod2Gcc (SymbolTable_SkipType (type));
      M2GCCDeclare_ConstantKnownAndUsed (lhs, m2convert_BuildConvert (location, tl, SymbolConversion_Mod2Gcc (rhs), true));
    }
  else
    {
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (lhs), m2convert_BuildConvert (location, tl, tr, true));
    }
}


/*
   CodeCoerce - Coerce op3 to type op2 placing the result into
                op1.
                Coerce will NOT alter the machine representation
                of op3 to comply with TYPE op2.
                Therefore it _insists_ that under all circumstances that the
                type sizes of op1 and op3 are the same.
                CONVERT will perform machine manipulation to change variable
                types, coerce does no such thing.
*/

static void CodeCoerce (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  location_t location;

  M2GCCDeclare_DeclareConstant (CurrentQuadToken, op3);  /* checks to see whether it is a constant literal and declares it  */
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, op3);  /* checks to see whether it is a constant literal and declares it  */
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if (SymbolTable_IsProcedure (op3))
    {
      if (m2expr_AreConstantsEqual (FindSize (CurrentQuadToken, op1), FindSize (CurrentQuadToken, M2System_Address)))
        {
          if (SymbolTable_IsConst (op1))
            {
              M2GCCDeclare_ConstantKnownAndUsed (op1, CheckConstant (CurrentQuadToken, op1, op3));
            }
          else
            {
              m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (op1), SymbolConversion_Mod2Gcc (op3));
            }
        }
      else
        {
          M2MetaError_MetaErrorT0 (CurrentQuadToken, (const char *) "{%E}procedure address can only be stored in an address sized operand", 68);
        }
    }
  else if ((SymbolTable_IsConst (op3)) || (m2expr_AreConstantsEqual (FindSize (CurrentQuadToken, op1), FindSize (CurrentQuadToken, op3))))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (op1))
        {
          M2GCCDeclare_ConstantKnownAndUsed (op1, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (op1)), SymbolConversion_Mod2Gcc (op3)));
        }
      else
        {
          M2Debug_Assert (SymbolConversion_GccKnowsAbout (op2));
          if (SymbolTable_IsConst (op3))
            {
              m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (op1), SymbolConversion_Mod2Gcc (op3));
            }
          else
            {
              /* does not work t := BuildCoerce(Mod2Gcc(op1), Mod2Gcc(op2), Mod2Gcc(op3))  */
              checkDeclare (op1);
              m2type_AddStatement (location, MaybeDebugBuiltinMemcpy (location, m2expr_BuildAddr (location, SymbolConversion_Mod2Gcc (op1), false), m2expr_BuildAddr (location, SymbolConversion_Mod2Gcc (op3), false), FindSize (CurrentQuadToken, op2)));
            }
        }
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT0 (CurrentQuadToken, (const char *) "can only {%kCAST} objects of the same size", 42);
    }
}


/*
   FoldCoerce -
*/

static void FoldCoerce (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  location_t location;

  M2GCCDeclare_TryDeclareConstant (tokenno, op3);  /* checks to see whether it is a constant literal and declares it  */
  location = M2LexBuf_TokenToLocation (tokenno);  /* checks to see whether it is a constant literal and declares it  */
  if ((SymbolConversion_GccKnowsAbout (op2)) && (SymbolConversion_GccKnowsAbout (op3)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsProcedure (op3))
        {
          if (m2expr_AreConstantsEqual (FindSize (tokenno, op1), FindSize (tokenno, M2System_Address)))
            {
              /* avoid dangling else.  */
              if (SymbolTable_IsConst (op1))
                {
                  SymbolConversion_AddModGcc (op1, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (op1)), SymbolConversion_Mod2Gcc (op3)));
                  (*p.proc) (op1);
                  NoChange = false;
                  M2Quads_SubQuad (quad);
                }
            }
          else
            {
              M2MetaError_MetaErrorT0 (CurrentQuadToken, (const char *) "{%E}procedure address can only be stored in a address sized operand", 67);
            }
        }
      else if (SymbolTable_IsConst (op3))
        {
          /* avoid dangling else.  */
          if (SymbolTable_IsConst (op1))
            {
              SymbolConversion_AddModGcc (op1, m2decl_DeclareKnownConstant (location, SymbolConversion_Mod2Gcc (SymbolTable_GetType (op1)), SymbolConversion_Mod2Gcc (op3)));
              (*p.proc) (op1);
              NoChange = false;
              M2Quads_SubQuad (quad);
            }
        }
    }
}


/*
   CanConvert - returns TRUE if we can convert variable, var, to a, type.
*/

static bool CanConvert (unsigned int type, unsigned int var)
{
  unsigned int svar;
  unsigned int stype;

  stype = SymbolTable_SkipType (type);
  svar = SymbolTable_SkipType (SymbolTable_GetType (var));
  return (((M2Base_IsBaseType (stype)) || (M2Base_IsOrdinalType (stype))) || (M2System_IsSystemType (stype))) && (((M2Base_IsBaseType (svar)) || (M2Base_IsOrdinalType (svar))) || (M2System_IsSystemType (stype)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeCast - Cast op3 to type op2 placing the result into op1.
              Cast will NOT alter the machine representation
              of op3 to comply with TYPE op2 as long as SIZE(op3)=SIZE(op2).
              If the sizes differ then Convert is called.
*/

static void CodeCast (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  location_t location;

  M2GCCDeclare_DeclareConstant (CurrentQuadToken, op3);  /* checks to see whether it is a constant literal and declares it  */
  M2GCCDeclare_DeclareConstructor (CurrentQuadToken, quad, op3);  /* checks to see whether it is a constant literal and declares it  */
  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if (SymbolTable_IsProcedure (op3))
    {
      if (m2expr_AreConstantsEqual (FindSize (CurrentQuadToken, op1), FindSize (CurrentQuadToken, M2System_Address)))
        {
          if (SymbolTable_IsConst (op1))
            {
              M2GCCDeclare_ConstantKnownAndUsed (op1, CheckConstant (CurrentQuadToken, op1, op3));
            }
          else
            {
              m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (op1), SymbolConversion_Mod2Gcc (op3));
            }
        }
      else
        {
          M2MetaError_MetaErrorT0 (CurrentQuadToken, (const char *) "{%E}procedure address can only be stored in an address sized operand", 68);
        }
    }
  else if ((SymbolTable_IsConst (op3)) || (m2expr_AreConstantsEqual (FindSize (CurrentQuadToken, op1), FindSize (CurrentQuadToken, op3))))
    {
      /* avoid dangling else.  */
      CodeCoerce (quad, op1, op2, op3);
    }
  else
    {
      /* avoid dangling else.  */
      if (M2Options_PedanticCast && (! (CanConvert (op2, op3))))
        {
          M2MetaError_MetaError2 ((const char *) "{%WkCAST} cannot copy a variable src {%2Dad} to a destination {%1Dad} as they are of different sizes and are not ordinal or real types", 134, op1, op3);
        }
      CodeConvert (quad, op1, op2, op3);
    }
}

static void FoldCast (unsigned int tokenno, M2GCCDeclare_WalkAction p, unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  /* 
   FoldCoerce -
  */
  M2GCCDeclare_TryDeclareConstant (tokenno, op3);  /* checks to see whether it is a constant literal and declares it  */
  if ((SymbolConversion_GccKnowsAbout (op2)) && (SymbolConversion_GccKnowsAbout (op3)))  /* checks to see whether it is a constant literal and declares it  */
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsProcedure (op3))
        {
          if (m2expr_AreConstantsEqual (FindSize (tokenno, op1), FindSize (tokenno, M2System_Address)))
            {
              FoldCoerce (tokenno, p, quad, op1, op2, op3);
            }
          else
            {
              M2MetaError_MetaErrorT0 (tokenno, (const char *) "{%E}procedure address can only be stored in an address sized operand", 68);
            }
        }
      else if (SymbolTable_IsConst (op3))
        {
          /* avoid dangling else.  */
          FoldCoerce (tokenno, p, quad, op1, op2, op3);
        }
    }
}


/*
   CreateLabelProcedureN - creates a label using procedure name and
                           an integer.
*/

static DynamicStrings_String CreateLabelProcedureN (unsigned int proc, const char *leader_, unsigned int _leader_high, unsigned int unboundedCount, unsigned int n)
{
  DynamicStrings_String n1;
  DynamicStrings_String n2;
  char leader[_leader_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (leader, leader_, _leader_high+1);

  n1 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (proc))));
  n2 = DynamicStrings_Mark (DynamicStrings_InitString ((const char *) leader, _leader_high));
  /* prefixed by .L unboundedCount and n to ensure that no Modula-2 identifiers clash  */
  return FormatStrings_Sprintf4 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".L%d.%d.unbounded.%s.%s", 23)), (const unsigned char *) &unboundedCount, (sizeof (unboundedCount)-1), (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CreateLabelName - creates a namekey from quadruple, q.
*/

static DynamicStrings_String CreateLabelName (unsigned int q)
{
  /* prefixed by . to ensure that no Modula-2 identifiers clash  */
  return FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".L%d", 4)), (const unsigned char *) &q, (sizeof (q)-1));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeGoto - creates a jump to a labeled quadruple.
*/

static void CodeGoto (unsigned int destquad)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (destquad))));
}


/*
   CheckReferenced - checks to see whether this quadruple requires a label.
*/

static void CheckReferenced (unsigned int quad, M2Quads_QuadOperator op)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  /* we do not create labels for procedure entries  */
  if (((op != M2Quads_ProcedureScopeOp) && (op != M2Quads_NewLocalVarOp)) && (M2Quads_IsReferenced (quad)))
    {
      m2statement_DeclareLabel (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (quad))));
    }
}


/*
   CodeIfSetLess -
*/

static void CodeIfSetLess (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  unsigned int settype;
  void * falselabel;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if ((SymbolTable_IsConst (op1)) && (SymbolTable_IsConst (op2)))
    {
      M2Error_InternalError ((const char *) "this should have been folded in the calling procedure", 53);
    }
  else if (SymbolTable_IsConst (op1))
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op2));
    }
  else
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op1));
    }
  if ((m2expr_CompareTrees (FindSize (CurrentQuadToken, settype), FindSize (CurrentQuadToken, M2System_Word))) <= 0)
    {
      /* word size sets  */
      m2statement_DoJump (location, m2expr_BuildIsNotSuperset (location, m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op1), false), m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op2), false)), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
    }
  else
    {
      falselabel = DynamicStrings_string (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".Lset%dcomp", 11)), (const unsigned char *) &quad, (sizeof (quad)-1)));
      m2expr_BuildForeachWordInSetDoIfExpr (location, SymbolConversion_Mod2Gcc (settype), SymbolConversion_Mod2Gcc (op1), SymbolConversion_Mod2Gcc (op2), (SymbolTable_GetMode (op1)) == SymbolTable_LeftValue, (SymbolTable_GetMode (op2)) == SymbolTable_LeftValue, SymbolTable_IsConst (op1), SymbolTable_IsConst (op2), (m2expr_BuildExprProcedure_C) m2expr_BuildIsSuperset, reinterpret_cast <char * > (falselabel));
      m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
      m2statement_DeclareLabel (location, reinterpret_cast <char * > (falselabel));
    }
}


/*
   PerformCodeIfLess - codes the quadruple if op1 < op2 then goto op3
*/

static void PerformCodeIfLess (unsigned int quad)
{
  tree tl;
  tree tr;
  location_t location;
  unsigned int left;
  unsigned int right;
  unsigned int dest;
  unsigned int combined;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int destpos;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &combined, &op, &left, &right, &dest, &overflow, &constExpr, &leftpos, &rightpos, &destpos);
  location = M2LexBuf_TokenToLocation (combined);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      SymbolTable_PushValue (left);
      SymbolTable_PushValue (right);
      if (M2ALU_Less (CurrentQuadToken))
        {
          m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
      /* Fall through.  */
    }
  else if ((((SymbolTable_IsConstSet (left)) || ((SymbolTable_IsVar (left)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (left)))))) || (SymbolTable_IsConstSet (right))) || ((SymbolTable_IsVar (right)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (right))))))
    {
      /* avoid dangling else.  */
      CodeIfSetLess (quad, left, right, dest);
    }
  else
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsComposite (SymbolTable_GetType (left))) || (SymbolTable_IsComposite (SymbolTable_GetType (right))))
        {
          M2MetaError_MetaErrorT2 (combined, (const char *) "comparison tests between composite types not allowed {%1Eatd} and {%2atd}", 73, left, right);
        }
      else
        {
          ConvertBinaryOperands (location, &tl, &tr, ComparisonMixTypes (left, right, SymbolTable_SkipType (SymbolTable_GetType (left)), SymbolTable_SkipType (SymbolTable_GetType (right)), combined), left, right);
          m2statement_DoJump (location, m2expr_BuildLessThan (location, tl, tr), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
    }
}


/*
   CodeIfLess - codes the quadruple if op1 < op2 then goto op3
*/

static void CodeIfLess (unsigned int quad)
{
  if (IsValidExpressionRelOp (quad, false))
    {
      PerformCodeIfLess (quad);
    }
}


/*
   CodeIfSetGre -
*/

static void CodeIfSetGre (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  unsigned int settype;
  void * falselabel;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if ((SymbolTable_IsConst (op1)) && (SymbolTable_IsConst (op2)))
    {
      M2Error_InternalError ((const char *) "this should have been folded in the calling procedure", 53);
    }
  else if (SymbolTable_IsConst (op1))
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op2));
    }
  else
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op1));
    }
  if ((m2expr_CompareTrees (FindSize (CurrentQuadToken, settype), FindSize (CurrentQuadToken, M2System_Word))) <= 0)
    {
      /* word size sets  */
      m2statement_DoJump (location, m2expr_BuildIsNotSubset (location, m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op1), false), m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op2), false)), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
    }
  else
    {
      falselabel = DynamicStrings_string (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".Lset%dcomp", 11)), (const unsigned char *) &quad, (sizeof (quad)-1)));
      m2expr_BuildForeachWordInSetDoIfExpr (location, SymbolConversion_Mod2Gcc (settype), SymbolConversion_Mod2Gcc (op1), SymbolConversion_Mod2Gcc (op2), (SymbolTable_GetMode (op1)) == SymbolTable_LeftValue, (SymbolTable_GetMode (op2)) == SymbolTable_LeftValue, SymbolTable_IsConst (op1), SymbolTable_IsConst (op2), (m2expr_BuildExprProcedure_C) m2expr_BuildIsSubset, reinterpret_cast <char * > (falselabel));
      m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
      m2statement_DeclareLabel (location, reinterpret_cast <char * > (falselabel));
    }
}


/*
   PerformCodeIfGre - codes the quadruple if op1 > op2 then goto op3
*/

static void PerformCodeIfGre (unsigned int quad)
{
  tree tl;
  tree tr;
  location_t location;
  unsigned int left;
  unsigned int right;
  unsigned int dest;
  unsigned int combined;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int destpos;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &combined, &op, &left, &right, &dest, &overflow, &constExpr, &leftpos, &rightpos, &destpos);
  location = M2LexBuf_TokenToLocation (combined);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      SymbolTable_PushValue (left);
      SymbolTable_PushValue (right);
      if (M2ALU_Gre (combined))
        {
          m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
      /* fall through  */
    }
  else if ((((SymbolTable_IsConstSet (left)) || ((SymbolTable_IsVar (left)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (left)))))) || (SymbolTable_IsConstSet (right))) || ((SymbolTable_IsVar (right)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (right))))))
    {
      /* avoid dangling else.  */
      CodeIfSetGre (quad, left, right, dest);
    }
  else
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsComposite (SymbolTable_GetType (left))) || (SymbolTable_IsComposite (SymbolTable_GetType (right))))
        {
          M2MetaError_MetaErrorT2 (combined, (const char *) "comparison tests between composite types not allowed {%1Eatd} and {%2atd}", 73, left, right);
        }
      else
        {
          ConvertBinaryOperands (location, &tl, &tr, ComparisonMixTypes (left, right, SymbolTable_SkipType (SymbolTable_GetType (left)), SymbolTable_SkipType (SymbolTable_GetType (right)), combined), left, right);
          m2statement_DoJump (location, m2expr_BuildGreaterThan (location, tl, tr), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
    }
}


/*
   CodeIfGre - codes the quadruple if op1 > op2 then goto op3
*/

static void CodeIfGre (unsigned int quad)
{
  if (IsValidExpressionRelOp (quad, false))
    {
      PerformCodeIfGre (quad);
    }
}


/*
   CodeIfSetLessEqu -
*/

static void CodeIfSetLessEqu (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  unsigned int settype;
  void * falselabel;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if ((SymbolTable_IsConst (op1)) && (SymbolTable_IsConst (op2)))
    {
      M2Error_InternalError ((const char *) "this should have been folded in the calling procedure", 53);
    }
  else if (SymbolTable_IsConst (op1))
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op2));
    }
  else
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op1));
    }
  if ((m2expr_CompareTrees (FindSize (CurrentQuadToken, settype), FindSize (CurrentQuadToken, M2System_Word))) <= 0)
    {
      /* word size sets  */
      m2statement_DoJump (location, m2expr_BuildIsSubset (location, m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op1), false), m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op2), false)), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
    }
  else
    {
      falselabel = DynamicStrings_string (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".Lset%dcomp", 11)), (const unsigned char *) &quad, (sizeof (quad)-1)));
      m2expr_BuildForeachWordInSetDoIfExpr (location, SymbolConversion_Mod2Gcc (settype), SymbolConversion_Mod2Gcc (op1), SymbolConversion_Mod2Gcc (op2), (SymbolTable_GetMode (op1)) == SymbolTable_LeftValue, (SymbolTable_GetMode (op2)) == SymbolTable_LeftValue, SymbolTable_IsConst (op1), SymbolTable_IsConst (op2), (m2expr_BuildExprProcedure_C) m2expr_BuildIsNotSubset, reinterpret_cast <char * > (falselabel));
      m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
      m2statement_DeclareLabel (location, reinterpret_cast <char * > (falselabel));
    }
}


/*
   PerformCodeIfLessEqu - codes the quadruple if op1 <= op2 then goto op3
*/

static void PerformCodeIfLessEqu (unsigned int quad)
{
  tree tl;
  tree tr;
  location_t location;
  unsigned int left;
  unsigned int right;
  unsigned int dest;
  unsigned int combined;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int destpos;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &combined, &op, &left, &right, &dest, &overflow, &constExpr, &leftpos, &rightpos, &destpos);
  location = M2LexBuf_TokenToLocation (combined);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      SymbolTable_PushValue (left);
      SymbolTable_PushValue (right);
      if (M2ALU_LessEqu (combined))
        {
          m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
      /* fall through  */
    }
  else if ((((SymbolTable_IsConstSet (left)) || ((SymbolTable_IsVar (left)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (left)))))) || (SymbolTable_IsConstSet (right))) || ((SymbolTable_IsVar (right)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (right))))))
    {
      /* avoid dangling else.  */
      CodeIfSetLessEqu (quad, left, right, dest);
    }
  else
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsComposite (SymbolTable_GetType (left))) || (SymbolTable_IsComposite (SymbolTable_GetType (right))))
        {
          M2MetaError_MetaErrorT2 (combined, (const char *) "comparison tests between composite types not allowed {%1Eatd} and {%2atd}", 73, left, right);
        }
      else
        {
          ConvertBinaryOperands (location, &tl, &tr, ComparisonMixTypes (left, right, SymbolTable_SkipType (SymbolTable_GetType (left)), SymbolTable_SkipType (SymbolTable_GetType (right)), combined), left, right);
          m2statement_DoJump (location, m2expr_BuildLessThanOrEqual (location, tl, tr), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
    }
}


/*
   CodeIfLessEqu - codes the quadruple if op1 <= op2 then goto op3
*/

static void CodeIfLessEqu (unsigned int quad)
{
  if (IsValidExpressionRelOp (quad, false))
    {
      PerformCodeIfLessEqu (quad);
    }
}


/*
   CodeIfSetGreEqu -
*/

static void CodeIfSetGreEqu (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  unsigned int settype;
  void * falselabel;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if ((SymbolTable_IsConst (op1)) && (SymbolTable_IsConst (op2)))
    {
      M2Error_InternalError ((const char *) "this should have been folded in the calling procedure", 53);
    }
  else if (SymbolTable_IsConst (op1))
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op2));
    }
  else
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op1));
    }
  if ((m2expr_CompareTrees (FindSize (CurrentQuadToken, settype), FindSize (CurrentQuadToken, M2System_Word))) <= 0)
    {
      /* word size sets  */
      m2statement_DoJump (location, m2expr_BuildIsSuperset (location, m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op1), false), m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op2), false)), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
    }
  else
    {
      falselabel = DynamicStrings_string (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".Lset%dcomp", 11)), (const unsigned char *) &quad, (sizeof (quad)-1)));
      m2expr_BuildForeachWordInSetDoIfExpr (location, SymbolConversion_Mod2Gcc (settype), SymbolConversion_Mod2Gcc (op1), SymbolConversion_Mod2Gcc (op2), (SymbolTable_GetMode (op1)) == SymbolTable_LeftValue, (SymbolTable_GetMode (op2)) == SymbolTable_LeftValue, SymbolTable_IsConst (op1), SymbolTable_IsConst (op2), (m2expr_BuildExprProcedure_C) m2expr_BuildIsNotSuperset, reinterpret_cast <char * > (falselabel));
      m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
      m2statement_DeclareLabel (location, reinterpret_cast <char * > (falselabel));
    }
}


/*
   PerformCodeIfGreEqu - codes the quadruple if op1 >= op2 then goto op3
*/

static void PerformCodeIfGreEqu (unsigned int quad)
{
  tree tl;
  tree tr;
  location_t location;
  unsigned int left;
  unsigned int right;
  unsigned int dest;
  unsigned int combined;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int destpos;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &combined, &op, &left, &right, &dest, &overflow, &constExpr, &leftpos, &rightpos, &destpos);
  location = M2LexBuf_TokenToLocation (combined);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      SymbolTable_PushValue (left);
      SymbolTable_PushValue (right);
      if (M2ALU_GreEqu (combined))
        {
          m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
      /* fall through  */
    }
  else if ((((SymbolTable_IsConstSet (left)) || ((SymbolTable_IsVar (left)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (left)))))) || (SymbolTable_IsConstSet (right))) || ((SymbolTable_IsVar (right)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (right))))))
    {
      /* avoid dangling else.  */
      CodeIfSetGreEqu (quad, left, right, dest);
    }
  else
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsComposite (SymbolTable_GetType (left))) || (SymbolTable_IsComposite (SymbolTable_GetType (right))))
        {
          M2MetaError_MetaErrorT2 (combined, (const char *) "comparison tests between composite types not allowed {%1Eatd} and {%2atd}", 73, left, right);
        }
      else
        {
          ConvertBinaryOperands (location, &tl, &tr, ComparisonMixTypes (left, right, SymbolTable_SkipType (SymbolTable_GetType (left)), SymbolTable_SkipType (SymbolTable_GetType (right)), combined), left, right);
          m2statement_DoJump (location, m2expr_BuildGreaterThanOrEqual (location, tl, tr), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
    }
}


/*
   CodeIfGreEqu - codes the quadruple if op1 >= op2 then goto op3
*/

static void CodeIfGreEqu (unsigned int quad)
{
  if (IsValidExpressionRelOp (quad, false))
    {
      PerformCodeIfGreEqu (quad);
    }
}


/*
   CodeIfSetEqu - codes if op1 = op2 then goto op3
                  Note that if op1 and op2 are not both constants
                  since this will have been evaluated in CodeIfEqu.
*/

static void CodeIfSetEqu (unsigned int quad, unsigned int op1, unsigned int op2, unsigned int op3)
{
  unsigned int settype;
  void * falselabel;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if ((SymbolTable_IsConst (op1)) && (SymbolTable_IsConst (op2)))
    {
      M2Error_InternalError ((const char *) "this should have been folded in the calling procedure", 53);
    }
  else if (SymbolTable_IsConst (op1))
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op2));
    }
  else
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (op1));
    }
  if ((m2expr_CompareTrees (FindSize (CurrentQuadToken, settype), FindSize (CurrentQuadToken, M2System_Word))) <= 0)
    {
      /* word size sets  */
      m2statement_DoJump (location, m2expr_BuildEqualTo (location, m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op1), false), m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (op2), false)), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
    }
  else if ((SymbolTable_GetSType (op1)) == (SymbolTable_GetSType (op2)))
    {
      /* avoid dangling else.  */
      falselabel = DynamicStrings_string (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".Lset%dcomp", 11)), (const unsigned char *) &quad, (sizeof (quad)-1)));
      m2expr_BuildForeachWordInSetDoIfExpr (location, SymbolConversion_Mod2Gcc (settype), SymbolConversion_Mod2Gcc (op1), SymbolConversion_Mod2Gcc (op2), (SymbolTable_GetMode (op1)) == SymbolTable_LeftValue, (SymbolTable_GetMode (op2)) == SymbolTable_LeftValue, SymbolTable_IsConst (op1), SymbolTable_IsConst (op2), (m2expr_BuildExprProcedure_C) m2expr_BuildNotEqualTo, reinterpret_cast <char * > (falselabel));
      m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (op3))));
      m2statement_DeclareLabel (location, reinterpret_cast <char * > (falselabel));
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT2 (CurrentQuadToken, (const char *) "set comparison is only allowed between the same set type, the set types used by {%1Eatd} and {%2atd} are different", 114, op1, op2);
    }
}


/*
   CodeIfSetNotEqu - codes if op1 # op2 then goto op3
                     Note that if op1 and op2 are not both constants
                     since this will have been evaluated in CodeIfNotEqu.
*/

static void CodeIfSetNotEqu (unsigned int left, unsigned int right, unsigned int destQuad)
{
  unsigned int settype;
  void * truelabel;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      M2Error_InternalError ((const char *) "this should have been folded in the calling procedure", 53);
    }
  else if (SymbolTable_IsConst (left))
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (right));
    }
  else
    {
      /* avoid dangling else.  */
      settype = SymbolTable_SkipType (SymbolTable_GetType (left));
    }
  if ((m2expr_CompareTrees (FindSize (CurrentQuadToken, settype), FindSize (CurrentQuadToken, M2System_Word))) <= 0)
    {
      /* word size sets  */
      m2statement_DoJump (location, m2expr_BuildNotEqualTo (location, m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (left), false), m2convert_BuildConvert (location, m2type_GetWordType (), SymbolConversion_Mod2Gcc (right), false)), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (destQuad))));
    }
  else if ((SymbolTable_GetSType (left)) == (SymbolTable_GetSType (right)))
    {
      /* avoid dangling else.  */
      truelabel = DynamicStrings_string (CreateLabelName (destQuad));
      m2expr_BuildForeachWordInSetDoIfExpr (location, SymbolConversion_Mod2Gcc (settype), SymbolConversion_Mod2Gcc (left), SymbolConversion_Mod2Gcc (right), (SymbolTable_GetMode (left)) == SymbolTable_LeftValue, (SymbolTable_GetMode (right)) == SymbolTable_LeftValue, SymbolTable_IsConst (left), SymbolTable_IsConst (right), (m2expr_BuildExprProcedure_C) m2expr_BuildNotEqualTo, reinterpret_cast <char * > (truelabel));
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT2 (CurrentQuadToken, (const char *) "set comparison is only allowed between the same set type, the set types used by {%1Eatd} and {%2atd} are different", 114, left, right);
    }
}


/*
   ComparisonMixTypes -
*/

static unsigned int ComparisonMixTypes (unsigned int varleft, unsigned int varright, unsigned int left, unsigned int right, unsigned int tokpos)
{
  if (M2System_IsGenericSystemType (left))
    {
      return left;
    }
  else if (M2System_IsGenericSystemType (right))
    {
      /* avoid dangling else.  */
      return right;
    }
  else
    {
      /* avoid dangling else.  */
      return M2Base_MixTypesDecl (varleft, varright, left, right, tokpos);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PerformCodeIfEqu -
*/

static void PerformCodeIfEqu (unsigned int quad)
{
  tree tl;
  tree tr;
  location_t location;
  unsigned int left;
  unsigned int right;
  unsigned int dest;
  unsigned int combined;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int destpos;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  M2Quads_GetQuadOtok (quad, &combined, &op, &left, &right, &dest, &overflow, &constExpr, &leftpos, &rightpos, &destpos);
  location = M2LexBuf_TokenToLocation (combined);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      SymbolTable_PushValue (left);
      SymbolTable_PushValue (right);
      if (M2ALU_Equ (combined))
        {
          m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
      /* Fall through.  */
    }
  else if ((((SymbolTable_IsConstSet (left)) || ((SymbolTable_IsVar (left)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (left)))))) || (SymbolTable_IsConstSet (right))) || ((SymbolTable_IsVar (right)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (right))))))
    {
      /* avoid dangling else.  */
      CodeIfSetEqu (quad, left, right, dest);
    }
  else
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsComposite (SymbolTable_GetType (left))) || (SymbolTable_IsComposite (SymbolTable_GetType (right))))
        {
          M2MetaError_MetaErrorT2 (combined, (const char *) "equality tests between composite types not allowed {%1Eatd} and {%2atd}", 71, left, right);
        }
      else
        {
          ConvertBinaryOperands (location, &tl, &tr, ComparisonMixTypes (left, right, SymbolTable_SkipType (SymbolTable_GetType (left)), SymbolTable_SkipType (SymbolTable_GetType (right)), combined), left, right);
          m2statement_DoJump (location, m2expr_BuildEqualTo (location, tl, tr), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
    }
}


/*
   PerformCodeIfNotEqu -
*/

static void PerformCodeIfNotEqu (unsigned int quad)
{
  tree tl;
  tree tr;
  location_t location;
  unsigned int left;
  unsigned int right;
  unsigned int dest;
  unsigned int combined;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int destpos;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  /* Ensure that any remaining undeclared constant literal is declared.  */
  M2Quads_GetQuadOtok (quad, &combined, &op, &left, &right, &dest, &constExpr, &overflow, &leftpos, &rightpos, &destpos);
  location = M2LexBuf_TokenToLocation (combined);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      SymbolTable_PushValue (left);
      SymbolTable_PushValue (right);
      if (M2ALU_NotEqu (combined))
        {
          m2statement_BuildGoto (location, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
      /* Fall through.  */
    }
  else if ((((SymbolTable_IsConstSet (left)) || ((SymbolTable_IsVar (left)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (left)))))) || (SymbolTable_IsConstSet (right))) || ((SymbolTable_IsVar (right)) && (SymbolTable_IsSet (SymbolTable_SkipType (SymbolTable_GetType (right))))))
    {
      /* avoid dangling else.  */
      CodeIfSetNotEqu (left, right, dest);
    }
  else
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsComposite (SymbolTable_GetType (left))) || (SymbolTable_IsComposite (SymbolTable_GetType (right))))
        {
          M2MetaError_MetaErrorT2 (combined, (const char *) "inequality tests between composite types not allowed {%1Eatd} and {%2atd}", 73, left, right);
        }
      else
        {
          ConvertBinaryOperands (location, &tl, &tr, ComparisonMixTypes (left, right, SymbolTable_SkipType (SymbolTable_GetType (left)), SymbolTable_SkipType (SymbolTable_GetType (right)), combined), left, right);
          m2statement_DoJump (location, m2expr_BuildNotEqualTo (location, tl, tr), NULL, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
    }
}


/*
   IsValidExpressionRelOp - declare left and right constants (if they are not already declared).
                            Check whether left and right are expression compatible.
*/

static bool IsValidExpressionRelOp (unsigned int quad, bool isin)
{
  unsigned int left;
  unsigned int right;
  unsigned int dest;
  unsigned int combined;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int destpos;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  /* Ensure that any remaining undeclared constant literal is declared.  */
  M2Quads_GetQuadOtok (quad, &combined, &op, &left, &right, &dest, &constExpr, &overflow, &leftpos, &rightpos, &destpos);
  M2GCCDeclare_DeclareConstant (leftpos, left);
  M2GCCDeclare_DeclareConstant (rightpos, right);
  M2GCCDeclare_DeclareConstructor (leftpos, quad, left);
  M2GCCDeclare_DeclareConstructor (rightpos, quad, right);
  if (M2Check_ExpressionTypeCompatible (combined, (const char *) "", 0, left, right, M2Options_StrictTypeChecking, isin))
    {
      return true;
    }
  else
    {
      if (Verbose)
        {
          M2MetaError_MetaErrorT2 (combined, (const char *) "expression mismatch between {%1Etad} and {%2tad} seen during comparison", 71, left, right);
        }
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeIfEqu - codes the quadruple if op1 = op2 then goto op3
*/

static void CodeIfEqu (unsigned int quad)
{
  if (IsValidExpressionRelOp (quad, false))
    {
      PerformCodeIfEqu (quad);
    }
}


/*
   CodeIfNotEqu - codes the quadruple if op1 # op2 then goto op3
*/

static void CodeIfNotEqu (unsigned int quad)
{
  if (IsValidExpressionRelOp (quad, false))
    {
      PerformCodeIfNotEqu (quad);
    }
}


/*
   MixTypes3 - returns a type compatible from, low, high, var.
*/

static unsigned int MixTypes3 (unsigned int low, unsigned int high, unsigned int var, unsigned int tokenno)
{
  unsigned int type;

  type = M2Base_MixTypes (SymbolTable_SkipType (SymbolTable_GetType (low)), SymbolTable_SkipType (SymbolTable_GetType (high)), tokenno);
  type = M2Base_MixTypes (type, SymbolTable_SkipType (SymbolTable_GetType (var)), tokenno);
  return type;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildIfVarInConstValue - if var in constsetvalue then goto trueexit
*/

static void BuildIfVarInConstValue (location_t location, unsigned int tokenno, M2ALU_PtrToValue constsetvalue, unsigned int var, unsigned int trueexit)
{
  tree vt;
  tree lt;
  tree ht;
  unsigned int type;
  unsigned int low;
  unsigned int high;
  unsigned int n;
  DynamicStrings_String truelabel;

  n = 1;
  truelabel = static_cast<DynamicStrings_String> (DynamicStrings_string (CreateLabelName (trueexit)));
  while (M2ALU_GetRange (constsetvalue, n, &low, &high))
    {
      type = MixTypes3 (low, high, var, tokenno);
      ConvertBinaryOperands (location, &vt, &lt, type, var, low);
      ConvertBinaryOperands (location, &ht, &lt, type, high, low);
      m2expr_BuildIfInRangeGoto (location, vt, lt, ht, reinterpret_cast <char * > (truelabel));
      n += 1;
    }
}


/*
   BuildIfNotVarInConstValue - if not (var in constsetvalue) then goto trueexit
*/

static void BuildIfNotVarInConstValue (unsigned int quad, M2ALU_PtrToValue constsetvalue, unsigned int var, unsigned int trueexit)
{
  tree vt;
  tree lt;
  tree ht;
  unsigned int type;
  unsigned int low;
  unsigned int high;
  unsigned int n;
  DynamicStrings_String falselabel;
  DynamicStrings_String truelabel;
  location_t location;

  location = M2LexBuf_TokenToLocation (CurrentQuadToken);
  truelabel = static_cast<DynamicStrings_String> (DynamicStrings_string (CreateLabelName (trueexit)));
  n = 1;
  while (M2ALU_GetRange (constsetvalue, n, &low, &high))
    {
      n += 1;
    }
  if (n == 2)
    {
      /* actually only one set range, so we invert it  */
      type = MixTypes3 (low, high, var, CurrentQuadToken);
      ConvertBinaryOperands (location, &vt, &lt, type, var, low);
      ConvertBinaryOperands (location, &ht, &lt, type, high, low);
      m2expr_BuildIfNotInRangeGoto (location, vt, lt, ht, reinterpret_cast <char * > (truelabel));
    }
  else
    {
      n = 1;
      falselabel = static_cast<DynamicStrings_String> (DynamicStrings_string (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ".Lset%d", 7)), (const unsigned char *) &quad, (sizeof (quad)-1))));
      while (M2ALU_GetRange (constsetvalue, n, &low, &high))
        {
          type = MixTypes3 (low, high, var, CurrentQuadToken);
          ConvertBinaryOperands (location, &vt, &lt, type, var, low);
          ConvertBinaryOperands (location, &ht, &lt, type, high, low);
          m2expr_BuildIfInRangeGoto (location, vt, lt, ht, reinterpret_cast <char * > (falselabel));
          n += 1;
        }
      m2statement_BuildGoto (location, reinterpret_cast <char * > (truelabel));
      m2statement_DeclareLabel (location, reinterpret_cast <char * > (falselabel));
    }
}


/*
   PerformCodeIfIn - code the quadruple: if op1 in op2 then goto op3
*/

static void PerformCodeIfIn (unsigned int quad)
{
  unsigned int low;
  unsigned int high;
  tree lowtree;
  tree hightree;
  tree offset;
  int fieldno;
  location_t location;
  unsigned int left;
  unsigned int right;
  unsigned int dest;
  unsigned int combined;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int destpos;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  /* Ensure that any remaining undeclared constant literal is declared.  */
  M2Quads_GetQuadOtok (quad, &combined, &op, &left, &right, &dest, &constExpr, &overflow, &leftpos, &rightpos, &destpos);
  location = M2LexBuf_TokenToLocation (combined);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      M2Error_InternalError ((const char *) "should not get to here (if we do we should consider calling FoldIfIn)", 69);
    }
  else if (CheckElementSetTypes (quad))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (left))
        {
          fieldno = GetFieldNo (combined, left, SymbolTable_GetType (right), &offset);
          if (fieldno >= 0)
            {
              SymbolTable_PushValue (left);
              M2ALU_PushIntegerTree (offset);
              M2ALU_ConvertToType (SymbolTable_GetType (left));
              M2ALU_Sub ();
              m2expr_BuildIfConstInVar (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (right))), SymbolConversion_Mod2Gcc (right), M2ALU_PopIntegerTree (), (SymbolTable_GetMode (right)) == SymbolTable_LeftValue, fieldno, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
            }
          else
            {
              M2MetaError_MetaErrorT1 (combined, (const char *) "bit exceeded the range of set {%1Eatd}", 38, left);
            }
        }
      else if (SymbolTable_IsConst (right))
        {
          /* avoid dangling else.  */
          /* builds a cascaded list of if statements  */
          SymbolTable_PushValue (right);
          BuildIfVarInConstValue (location, combined, M2ALU_GetValue (combined), left, dest);
        }
      else
        {
          /* avoid dangling else.  */
          GetSetLimits (SymbolTable_SkipType (SymbolTable_GetType (right)), &low, &high);
          SymbolTable_PushValue (low);
          lowtree = M2ALU_PopIntegerTree ();
          SymbolTable_PushValue (high);
          hightree = M2ALU_PopIntegerTree ();
          m2expr_BuildIfVarInVar (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (right))), SymbolConversion_Mod2Gcc (right), SymbolConversion_Mod2Gcc (left), (SymbolTable_GetMode (right)) == SymbolTable_LeftValue, lowtree, hightree, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
    }
}


/*
   PerformCodeIfNotIn - code the quadruple: if not (op1 in op2) then goto op3
*/

static void PerformCodeIfNotIn (unsigned int quad)
{
  unsigned int low;
  unsigned int high;
  tree lowtree;
  tree hightree;
  tree offset;
  int fieldno;
  location_t location;
  unsigned int left;
  unsigned int right;
  unsigned int dest;
  unsigned int combined;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int destpos;
  bool constExpr;
  bool overflow;
  M2Quads_QuadOperator op;

  /* Ensure that any remaining undeclared constant literal is declared.  */
  M2Quads_GetQuadOtok (quad, &combined, &op, &left, &right, &dest, &overflow, &constExpr, &leftpos, &rightpos, &destpos);
  location = M2LexBuf_TokenToLocation (combined);
  if ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right)))
    {
      M2Error_InternalError ((const char *) "should not get to here (if we do we should consider calling FoldIfIn)", 69);
    }
  else if (CheckElementSetTypes (quad))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (left))
        {
          fieldno = GetFieldNo (combined, left, SymbolTable_SkipType (SymbolTable_GetType (right)), &offset);
          if (fieldno >= 0)
            {
              SymbolTable_PushValue (left);
              M2ALU_PushIntegerTree (offset);
              M2ALU_ConvertToType (SymbolTable_GetType (left));
              M2ALU_Sub ();
              m2expr_BuildIfNotConstInVar (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (right))), SymbolConversion_Mod2Gcc (right), M2ALU_PopIntegerTree (), (SymbolTable_GetMode (right)) == SymbolTable_LeftValue, fieldno, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
            }
          else
            {
              M2MetaError_MetaErrorT1 (combined, (const char *) "bit exceeded the range of set {%1Eatd}", 38, right);
            }
        }
      else if (SymbolTable_IsConst (right))
        {
          /* avoid dangling else.  */
          /* builds a cascaded list of if statements  */
          SymbolTable_PushValue (right);
          BuildIfNotVarInConstValue (quad, M2ALU_GetValue (combined), left, dest);
        }
      else
        {
          /* avoid dangling else.  */
          GetSetLimits (SymbolTable_SkipType (SymbolTable_GetType (right)), &low, &high);
          SymbolTable_PushValue (low);
          lowtree = M2ALU_PopIntegerTree ();
          SymbolTable_PushValue (high);
          hightree = M2ALU_PopIntegerTree ();
          m2expr_BuildIfNotVarInVar (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (right))), SymbolConversion_Mod2Gcc (right), SymbolConversion_Mod2Gcc (left), (SymbolTable_GetMode (right)) == SymbolTable_LeftValue, lowtree, hightree, reinterpret_cast <char * > (DynamicStrings_string (CreateLabelName (dest))));
        }
    }
}


/*
   CodeIfIn - code the quadruple: if op1 in op2 then goto op3
*/

static void CodeIfIn (unsigned int quad)
{
  if (IsValidExpressionRelOp (quad, true))
    {
      PerformCodeIfIn (quad);
    }
}


/*
   CodeIfNotIn - code the quadruple: if not (op1 in op2) then goto op3
*/

static void CodeIfNotIn (unsigned int quad)
{
  if (IsValidExpressionRelOp (quad, true))
    {
      PerformCodeIfNotIn (quad);
    }
}

static void CodeIndrX (unsigned int quad)
{
  bool constExpr;
  bool overflowChecking;
  M2Quads_QuadOperator op;
  unsigned int tokenno;
  unsigned int left;
  unsigned int type;
  unsigned int right;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int typepos;
  unsigned int indrxpos;
  tree length;
  tree newstr;
  location_t location;

  /* 
------------------------------------------------------------------------------
   IndrX Operator           a = *b
------------------------------------------------------------------------------
   Sym1<X>   IndrX   Sym2<I>     Meaning     Mem[Sym1<I>] := Mem[constant]
   Sym1<X>   IndrX   Sym2<X>     Meaning     Mem[Sym1<I>] := Mem[Mem[Sym3<I>]]

   (op2 is the type of the data being indirectly copied)
  */
  M2Quads_GetQuadOtok (quad, &indrxpos, &op, &left, &type, &right, &overflowChecking, &constExpr, &leftpos, &typepos, &rightpos);
  tokenno = M2LexBuf_MakeVirtualTok (indrxpos, leftpos, rightpos);
  location = M2LexBuf_TokenToLocation (tokenno);
  /* 
      Follow the Quadruple rules:
  */
  M2GCCDeclare_DeclareConstant (rightpos, right);  /* Checks to see whether it is a constant
                                           and if necessary declare it.  */
  M2GCCDeclare_DeclareConstructor (rightpos, quad, right);  /* Checks to see whether it is a constant
                                           and if necessary declare it.  */
  if (SymbolTable_IsConstString (right))
    {
      M2Error_InternalError ((const char *) "not expecting to index through a constant string", 48);
    }
  else if (M2Options_StrictTypeChecking && (! (M2Check_AssignmentTypeCompatible (indrxpos, (const char *) "", 0, left, SymbolTable_GetType (right), true))))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT2 (tokenno, (const char *) "assignment check caught mismatch between {%1Ead} and {%2ad}", 59, left, right);
      M2Quads_SubQuad (quad);
    }
  else
    {
      /* avoid dangling else.  */
      /* 
         Mem[op1] := Mem[Mem[op3]]
  */
      m2statement_BuildAssignmentStatement (location, SymbolConversion_Mod2Gcc (left), m2expr_BuildIndirect (location, SymbolConversion_Mod2Gcc (right), SymbolConversion_Mod2Gcc (type)));
    }
}


/*
   CodeXIndr - operands for XIndrOp are: left type right.
                *left = right.  The second operand is the type of the data being
                indirectly copied.
*/

static void CodeXIndr (unsigned int quad)
{
  bool constExpr;
  bool overflowChecking;
  M2Quads_QuadOperator op;
  unsigned int tokenno;
  unsigned int left;
  unsigned int type;
  unsigned int right;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int typepos;
  unsigned int xindrpos;
  tree length;
  tree newstr;
  location_t location;

  M2Quads_GetQuadOtok (quad, &xindrpos, &op, &left, &type, &right, &overflowChecking, &constExpr, &leftpos, &typepos, &rightpos);
  tokenno = M2LexBuf_MakeVirtualTok (xindrpos, leftpos, rightpos);
  location = M2LexBuf_TokenToLocation (tokenno);
  type = SymbolTable_SkipType (type);
  M2GCCDeclare_DeclareConstant (rightpos, right);
  M2GCCDeclare_DeclareConstructor (rightpos, quad, right);
  if (M2Options_StrictTypeChecking && (! (M2Check_AssignmentTypeCompatible (xindrpos, (const char *) "", 0, SymbolTable_GetType (left), right, true))))
    {
      M2MetaError_MetaErrorT2 (tokenno, (const char *) "assignment check caught mismatch between {%1Ead} and {%2ad}", 59, left, right);
      M2Quads_SubQuad (quad);
    }
  if (SymbolTable_IsProcType (SymbolTable_SkipType (type)))
    {
      m2statement_BuildAssignmentStatement (location, m2expr_BuildIndirect (location, SymbolConversion_Mod2Gcc (left), m2type_GetPointerType ()), SymbolConversion_Mod2Gcc (right));
    }
  else if (((SymbolTable_IsConstString (right)) && ((SymbolTable_GetStringLength (rightpos, right)) == 0)) && ((SymbolTable_GetMode (left)) == SymbolTable_LeftValue))
    {
      /* avoid dangling else.  */
      /* 
         no need to check for type errors,
         but we handle nul string as a special case as back end
         complains if we pass through a "" and ask it to copy the
         contents.
  */
      m2statement_BuildAssignmentStatement (location, m2expr_BuildIndirect (location, M2GenGCC_LValueToGenericPtr (location, left), SymbolConversion_Mod2Gcc (M2Base_Char)), M2GenGCC_StringToChar (SymbolConversion_Mod2Gcc (right), M2Base_Char, right));
    }
  else if ((SymbolTable_IsConstString (right)) && ((SymbolTable_SkipTypeAndSubrange (SymbolTable_GetType (left))) != M2Base_Char))
    {
      /* avoid dangling else.  */
      if (! (M2GenGCC_PrepareCopyString (tokenno, &length, &newstr, right, type)))
        {
          M2MetaError_MetaErrorT2 (M2LexBuf_MakeVirtualTok (xindrpos, leftpos, rightpos), (const char *) "string constant {%1Ea} is too large to be assigned to the array {%2ad}", 70, right, left);
        }
      m2type_AddStatement (location, MaybeDebugBuiltinMemcpy (location, SymbolConversion_Mod2Gcc (left), m2expr_BuildAddr (location, newstr, false), length));
    }
  else
    {
      /* avoid dangling else.  */
      m2statement_BuildAssignmentStatement (location, m2expr_BuildIndirect (location, SymbolConversion_Mod2Gcc (left), SymbolConversion_Mod2Gcc (type)), ConvertRHS (SymbolConversion_Mod2Gcc (right), type, right));
    }
}


/*
   InitBuiltinSyms -
*/

static void InitBuiltinSyms (unsigned int tok)
{
  if (Memset == SymbolTable_NulSym)
    {
      Memset = SymbolTable_FromModuleGetSym (tok, NameKey_MakeKey ((const char *) "memset", 6), M2Batch_MakeDefinitionSource (tok, NameKey_MakeKey ((const char *) "Builtins", 8)));
    }
  if (Memcpy == SymbolTable_NulSym)
    {
      Memcpy = SymbolTable_FromModuleGetSym (tok, NameKey_MakeKey ((const char *) "memcpy", 6), M2Batch_MakeDefinitionSource (tok, NameKey_MakeKey ((const char *) "Builtins", 8)));
    }
}


/*
   ConvertQuadsToTree - runs through the quadruple list and converts it into
                        the GCC tree structure.
*/

extern "C" void M2GenGCC_ConvertQuadsToTree (unsigned int Start, unsigned int End)
{
  do {
    CodeStatement (Start);
    Start = M2Quads_GetNextQuad (Start);
  } while (! ((Start > End) || (Start == 0)));
}


/*
   ResolveConstantExpressions - resolves constant expressions from the quadruple list.
                                It returns TRUE if one or more constants were folded.
                                When a constant symbol value is solved, the call back
                                p(sym) is invoked.
*/

extern "C" bool M2GenGCC_ResolveConstantExpressions (M2GCCDeclare_WalkAction p, M2BasicBlock_BasicBlock bb)
{
  unsigned int tokenno;
  unsigned int quad;
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  unsigned int op1pos;
  unsigned int op2pos;
  unsigned int op3pos;
  bool Changed;
  unsigned int start;
  unsigned int end;

  InitBuiltinSyms (M2LexBuf_BuiltinTokenNo);
  start = M2BasicBlock_GetBasicBlockStart (bb);
  end = M2BasicBlock_GetBasicBlockEnd (bb);
  Changed = false;
  do {
    NoChange = true;
    quad = start;
    while ((quad <= end) && (quad != 0))
      {
        tokenno = CurrentQuadToken;
        if (tokenno == 0)
          {
            tokenno = M2Quads_QuadToTokenNo (quad);
          }
        if (M2Options_GetDebugTraceQuad ())
          {
            M2Printf_printf0 ((const char *) "examining fold: ", 16);
            M2Quads_DisplayQuad (quad);
          }
        M2Quads_GetQuadtok (quad, &op, &op1, &op2, &op3, &op1pos, &op2pos, &op3pos);
        switch (op)
          {
            case M2Quads_StandardFunctionOp:
              FoldStandardFunction (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_BuiltinConstOp:
              FoldBuiltinConst (tokenno, p, quad, op1, op3);
              break;

            case M2Quads_BuiltinTypeInfoOp:
              FoldBuiltinTypeInfo (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_LogicalOrOp:
              FoldSetOr (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_LogicalAndOp:
              FoldSetAnd (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_LogicalXorOp:
              FoldSymmetricDifference (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_BecomesOp:
              FoldBecomes (p, bb, quad);
              break;

            case M2Quads_ArithAddOp:
              FoldArithAdd (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_AddOp:
              FoldAdd (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_SubOp:
              FoldSub (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_MultOp:
              FoldMult (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_DivM2Op:
              FoldDivM2 (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_ModM2Op:
              FoldModM2 (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_DivTruncOp:
              FoldDivTrunc (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_ModTruncOp:
              FoldModTrunc (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_DivCeilOp:
              FoldDivCeil (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_ModCeilOp:
              FoldModCeil (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_DivFloorOp:
              FoldDivFloor (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_ModFloorOp:
              FoldModFloor (op1pos, p, quad, op1, op2, op3);
              break;

            case M2Quads_NegateOp:
              FoldNegate (op1pos, p, quad, op1, op3);
              break;

            case M2Quads_SizeOp:
              FoldSize (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_RecordFieldOp:
              FoldRecordField (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_HighOp:
              FoldHigh (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_ElementSizeOp:
              FoldElementSize (tokenno, p, quad, op1, op2);
              break;

            case M2Quads_ConvertOp:
              FoldConvert (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_CoerceOp:
              FoldCoerce (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_CastOp:
              FoldCast (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_InclOp:
              FoldIncl (tokenno, p, quad, op1, op3);
              break;

            case M2Quads_ExclOp:
              FoldExcl (tokenno, p, quad, op1, op3);
              break;

            case M2Quads_IfEquOp:
              FoldIfEqu (tokenno, quad, op1, op2, op3);
              break;

            case M2Quads_IfNotEquOp:
              FoldIfNotEqu (tokenno, quad, op1, op2, op3);
              break;

            case M2Quads_IfLessOp:
              FoldIfLess (tokenno, quad, op1, op2, op3);
              break;

            case M2Quads_IfLessEquOp:
              FoldIfLessEqu (tokenno, quad, op1, op2, op3);
              break;

            case M2Quads_IfGreOp:
              FoldIfGre (tokenno, quad, op1, op2, op3);
              break;

            case M2Quads_IfGreEquOp:
              FoldIfGreEqu (tokenno, quad, op1, op2, op3);
              break;

            case M2Quads_IfInOp:
              FoldIfIn (tokenno, quad, op1, op2, op3);
              break;

            case M2Quads_IfNotInOp:
              FoldIfNotIn (tokenno, quad, op1, op2, op3);
              break;

            case M2Quads_LogicalShiftOp:
              FoldSetShift (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_LogicalRotateOp:
              FoldSetRotate (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_ParamOp:
              FoldBuiltinFunction (tokenno, p, quad, op1, op2, op3);
              break;

            case M2Quads_RangeCheckOp:
              FoldRange (tokenno, quad, op3);
              break;

            case M2Quads_StatementNoteOp:
              FoldStatementNote (op3);
              break;

            case M2Quads_StringLengthOp:
              FoldStringLength (quad, p);
              break;

            case M2Quads_StringConvertM2nulOp:
              FoldStringConvertM2nul (quad, p);
              break;

            case M2Quads_StringConvertCnulOp:
              FoldStringConvertCnul (quad, p);
              break;

            case M2Quads_LastForIteratorOp:
              FoldLastForIterator (quad, p);
              break;


            default:
              break;
          }
        /* Ignore quadruple as it is not associated with a constant expression.  */
        quad = M2Quads_GetNextQuad (quad);
      }
    if (! NoChange)
      {
        Changed = true;
      }
  } while (! (NoChange));
  return Changed;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetHighFromUnbounded - returns a Tree containing the value of
                          param.HIGH.
*/

extern "C" tree M2GenGCC_GetHighFromUnbounded (location_t location, unsigned int dim, unsigned int param)
{
  unsigned int UnboundedType;
  unsigned int ArrayType;
  unsigned int HighField;
  tree HighTree;
  unsigned int accessibleDim;

  /* remainingDim : CARDINAL ;  */
  UnboundedType = SymbolTable_GetType (param);
  M2Debug_Assert (SymbolTable_IsUnbounded (UnboundedType));
  ArrayType = SymbolTable_GetType (UnboundedType);
  HighField = SymbolTable_GetUnboundedHighOffset (UnboundedType, dim);
  if (HighField == SymbolTable_NulSym)
    {
      /* It might be a dynamic array of static arrays,
         so lets see if there is an earlier dimension available.  */
      accessibleDim = dim;
      while ((HighField == SymbolTable_NulSym) && (accessibleDim > 1))
        {
          accessibleDim -= 1;
          HighField = SymbolTable_GetUnboundedHighOffset (UnboundedType, accessibleDim);
        }
      if (HighField == SymbolTable_NulSym)
        {
          M2MetaError_MetaError1 ((const char *) "{%EkHIGH} dimension number {%1N} for array does not exist", 57, dim);
          return m2expr_GetCardinalZero (location);
        }
      else
        {
          HighTree = BuildHighFromStaticArray (location, ArrayType);  /* remainingDim,  */
          if (HighTree == NULL)
            {
              M2MetaError_MetaError1 ((const char *) "{%EkHIGH} dimension number {%1N} for array does not exist", 57, dim);
              return m2expr_GetCardinalZero (location);
            }
          return HighTree;
        }
    }
  else
    {
      return m2expr_BuildComponentRef (location, SymbolConversion_Mod2Gcc (param), SymbolConversion_Mod2Gcc (HighField));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   StringToChar - if type=Char and str is a string (of size <= 1)
                  then convert the string into a character constant.
*/

extern "C" tree M2GenGCC_StringToChar (tree t, unsigned int type, unsigned int str)
{
  DynamicStrings_String s;
  NameKey_Name n;
  unsigned int tokenno;
  location_t location;

  tokenno = SymbolTable_GetDeclaredMod (str);
  location = M2LexBuf_TokenToLocation (tokenno);
  type = SymbolTable_SkipType (type);
  if ((type == M2Base_Char) && (SymbolTable_IsConstString (str)))
    {
      M2Debug_Assert (SymbolTable_IsConstStringKnown (str));
      if ((SymbolTable_GetStringLength (tokenno, str)) == 0)
        {
          s = DynamicStrings_InitString ((const char *) "", 0);
          t = m2type_BuildCharConstant (location, reinterpret_cast <const char * > (s));
          s = DynamicStrings_KillString (s);
        }
      else if ((SymbolTable_GetStringLength (tokenno, str)) > 1)
        {
          /* avoid dangling else.  */
          n = SymbolTable_GetSymName (str);
          M2Error_WriteFormat1 ((const char *) "type incompatibility, attempting to use a string ('%a') when a CHAR is expected", 79, (const unsigned char *) &n, (sizeof (n)-1));
          s = DynamicStrings_InitString ((const char *) "", 0);  /* Do something safe.  */
          t = m2type_BuildCharConstant (location, reinterpret_cast <const char * > (s));  /* Do something safe.  */
        }
      s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetString (str)));
      s = DynamicStrings_Slice (s, 0, 1);
      t = m2type_BuildCharConstant (location, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (s))));
      s = DynamicStrings_KillString (s);
    }
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   LValueToGenericPtr - returns a Tree representing symbol, sym.
                        It coerces a lvalue into an internal pointer type
*/

extern "C" tree M2GenGCC_LValueToGenericPtr (location_t location, unsigned int sym)
{
  tree t;

  t = SymbolConversion_Mod2Gcc (sym);
  if (t == NULL)
    {
      M2Error_InternalError ((const char *) "expecting symbol to be resolved", 31);
    }
  if ((SymbolTable_GetMode (sym)) == SymbolTable_LeftValue)
    {
      t = m2convert_BuildConvert (location, m2type_GetPointerType (), t, false);
    }
  return t;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ZConstToTypedConst - checks whether op1 and op2 are constants and
                        coerces, t, appropriately.
*/

extern "C" tree M2GenGCC_ZConstToTypedConst (tree t, unsigned int op1, unsigned int op2)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (op2));
  if ((SymbolTable_IsConst (op1)) && (SymbolTable_IsConst (op2)))
    {
      /* leave, Z type, alone  */
      return t;
    }
  else if (SymbolTable_IsConst (op1))
    {
      /* avoid dangling else.  */
      if ((SymbolTable_GetMode (op2)) == SymbolTable_LeftValue)
        {
          /* convert, Z type const into type of non constant operand  */
          return m2convert_BuildConvert (location, m2type_GetPointerType (), t, false);
        }
      else
        {
          /* convert, Z type const into type of non constant operand  */
          return m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (FindType (op2)), t, false);
        }
    }
  else if (SymbolTable_IsConst (op2))
    {
      /* avoid dangling else.  */
      if ((SymbolTable_GetMode (op1)) == SymbolTable_LeftValue)
        {
          /* convert, Z type const into type of non constant operand  */
          return m2convert_BuildConvert (location, m2type_GetPointerType (), t, false);
        }
      else
        {
          /* convert, Z type const into type of non constant operand  */
          return m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (FindType (op1)), t, false);
        }
    }
  else
    {
      /* avoid dangling else.  */
      /* neither operands are constants, leave alone  */
      return t;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PrepareCopyString - returns two trees:
                       length    number of bytes to be copied (including the nul if room)
                       srcTreeType the new string type (with the extra nul character).

                       Pre condition:  destStrType the dest type string.
                                       src is the original string (without a nul)
                                       to be copied.
                       Post condition: TRUE or FALSE is returned.
                                       if true length and srcTreeType will be assigned
                                       else length is set to the maximum length to be
                                            copied and srcTree is set to the max length
                                            which fits in dest.
*/

extern "C" bool M2GenGCC_PrepareCopyString (unsigned int tokenno, tree *length, tree *srcTree, unsigned int src, unsigned int destStrType)
{
  location_t location;
  int intLength;

  location = M2LexBuf_TokenToLocation (tokenno);
  M2Debug_Assert (SymbolTable_IsArray (SymbolTable_SkipType (destStrType)));
  /* Handle string assignments:
      VAR
         str: ARRAY [0..10] OF CHAR ;
         ch : CHAR ;

         str := 'abcde' but not ch := 'a'
  */
  if ((SymbolTable_GetType (src)) == M2Base_Char)
    {
      /* avoid dangling else.  */
      /* 
       *  Create string from char and add nul to the end, nul is
       *  added by BuildStringConstant.  In modula-2 an array must
       *  have at least one element.
  */
      (*length) = m2expr_GetIntegerOne (location);
      M2ALU_PushIntegerTree (FindSize (tokenno, src));
      M2ALU_PushIntegerTree (FindSize (tokenno, destStrType));
      if (M2ALU_Less (tokenno))
        {
          /* There is room for the extra <nul> character.  */
          (*length) = m2expr_BuildAdd (location, (*length), m2expr_GetIntegerOne (location), false);
        }
    }
  else
    {
      M2ALU_PushIntegerTree (FindSize (tokenno, src));
      M2ALU_PushIntegerTree (FindSize (tokenno, destStrType));
      if (M2ALU_Less (tokenno))
        {
          /* There is room for the extra <nul> character.  */
          (*length) = m2expr_BuildAdd (location, FindSize (tokenno, src), m2expr_GetIntegerOne (location), false);
          (*srcTree) = SymbolConversion_Mod2Gcc (src);
        }
      else
        {
          /* We need to truncate the <nul> at least.  */
          (*length) = FindSize (tokenno, destStrType);
          M2ALU_PushIntegerTree (FindSize (tokenno, src));
          M2ALU_PushIntegerTree ((*length));
          /* Greater or Equal so return max characters in the array.  */
          if (M2ALU_Gre (tokenno))
            {
              /* Create a new string without non nul characters to be gimple safe.
               But return FALSE indicating an overflow.  */
              intLength = m2expr_GetCstInteger ((*length));
              (*srcTree) = m2decl_BuildStringConstant (const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetString (src)))), intLength);
              (*srcTree) = m2convert_ConvertString (SymbolConversion_Mod2Gcc (destStrType), (*srcTree));
              return false;
            }
        }
    }
  intLength = m2expr_GetCstInteger ((*length));
  (*srcTree) = m2decl_BuildStringConstant (const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetString (src)))), intLength);
  (*srcTree) = m2convert_ConvertString (SymbolConversion_Mod2Gcc (destStrType), (*srcTree));
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2GenGCC_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Memset = SymbolTable_NulSym;
  Memcpy = SymbolTable_NulSym;
  UnboundedLabelNo = 0;
  CurrentQuadToken = 0;
  ScopeStack = M2StackWord_InitStackWord ();
}

extern "C" void _M2_M2GenGCC_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
