/* do not edit automatically generated by mc from M2StackAddress.  */
/* M2StackAddress.mod provides a generic stack for ADDRESS sized objects.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2StackAddress_C

#include "GM2StackAddress.h"
#   include "GStorage.h"
#   include "GM2Error.h"
#   include "GM2Debug.h"

#   define MaxBucket 10
typedef struct M2StackAddress__T1_r M2StackAddress__T1;

typedef struct M2StackAddress__T2_r M2StackAddress__T2;

typedef M2StackAddress__T2 *M2StackAddress_StackBucket;

typedef struct M2StackAddress__T3_a M2StackAddress__T3;

typedef M2StackAddress__T1 *M2StackAddress_StackOfAddress__opaque;

struct M2StackAddress__T1_r {
                              M2StackAddress_StackBucket tail;
                            };

struct M2StackAddress__T3_a { void * array[(MaxBucket-1)+1]; };
struct M2StackAddress__T2_r {
                              M2StackAddress__T3 bucket;
                              unsigned int items;
                              M2StackAddress_StackBucket prev;
                            };


/*
   InitStackAddress - creates and returns a new stack.
*/

extern "C" M2StackAddress_StackOfAddress M2StackAddress_InitStackAddress (void);

/*
   KillStackAddress - destroys a stack, returning NIL.
*/

extern "C" M2StackAddress_StackOfAddress M2StackAddress_KillStackAddress (M2StackAddress_StackOfAddress s);

/*
   PushAddress - pushes a word, w, onto, s.
*/

extern "C" void M2StackAddress_PushAddress (M2StackAddress_StackOfAddress s, void * w);

/*
   PopAddress - pops an element from stack, s.
*/

extern "C" void * M2StackAddress_PopAddress (M2StackAddress_StackOfAddress s);

/*
   IsEmptyAddress - returns TRUE if stack, s, is empty.
*/

extern "C" bool M2StackAddress_IsEmptyAddress (M2StackAddress_StackOfAddress s);

/*
   PeepAddress - returns the element at, n, items below in the stack.
                 Top of stack can be seen via Peep(s, 1)
*/

extern "C" void * M2StackAddress_PeepAddress (M2StackAddress_StackOfAddress s, unsigned int n);

/*
   ReduceAddress - reduce the stack by n elements.
*/

extern "C" void M2StackAddress_ReduceAddress (M2StackAddress_StackOfAddress s, unsigned int n);

/*
   NoOfItemsInStackAddress - returns the number of items held in the stack, s.
*/

extern "C" unsigned int M2StackAddress_NoOfItemsInStackAddress (M2StackAddress_StackOfAddress s);

/*
   KillBucket - destroys a StackBucket and returns, NIL.
*/

static M2StackAddress_StackBucket KillBucket (M2StackAddress_StackBucket b);

/*
   InitBucket - returns an empty StackBucket.
*/

static M2StackAddress_StackBucket InitBucket (M2StackAddress_StackBucket l);


/*
   KillBucket - destroys a StackBucket and returns, NIL.
*/

static M2StackAddress_StackBucket KillBucket (M2StackAddress_StackBucket b)
{
  if (b != NULL)
    {
      b = KillBucket (b->prev);
      Storage_DEALLOCATE ((void **) &b, sizeof (M2StackAddress__T2));
    }
  return NULL;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitBucket - returns an empty StackBucket.
*/

static M2StackAddress_StackBucket InitBucket (M2StackAddress_StackBucket l)
{
  M2StackAddress_StackBucket b;

  Storage_ALLOCATE ((void **) &b, sizeof (M2StackAddress__T2));
  b->items = 0;
  b->prev = l;
  return b;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitStackAddress - creates and returns a new stack.
*/

extern "C" M2StackAddress_StackOfAddress M2StackAddress_InitStackAddress (void)
{
  M2StackAddress_StackOfAddress__opaque s;

  Storage_ALLOCATE ((void **) &s, sizeof (M2StackAddress__T1));
  s->tail = NULL;
  return static_cast<M2StackAddress_StackOfAddress> (s);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillStackAddress - destroys a stack, returning NIL.
*/

extern "C" M2StackAddress_StackOfAddress M2StackAddress_KillStackAddress (M2StackAddress_StackOfAddress s)
{
  if (s != NULL)
    {
      static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail = KillBucket (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail);
      Storage_DEALLOCATE ((void **) &s, sizeof (M2StackAddress__T1));
    }
  return static_cast<M2StackAddress_StackOfAddress> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushAddress - pushes a word, w, onto, s.
*/

extern "C" void M2StackAddress_PushAddress (M2StackAddress_StackOfAddress s, void * w)
{
  if (s == NULL)
    {
      M2Error_InternalError ((const char *) "stack has not been initialized", 30);
    }
  else
    {
      if ((static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail == NULL) || (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items == MaxBucket))
        {
          static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail = InitBucket (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail);
        }
      if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items < MaxBucket)
        {
          static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->bucket.array[static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items] = w;
          static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items += 1;
        }
    }
}


/*
   PopAddress - pops an element from stack, s.
*/

extern "C" void * M2StackAddress_PopAddress (M2StackAddress_StackOfAddress s)
{
  M2StackAddress_StackBucket b;

  if (s == NULL)
    {
      M2Error_InternalError ((const char *) "stack has not been initialized", 30);
    }
  else
    {
      if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail == NULL)
        {
          M2Error_InternalError ((const char *) "stack underflow", 15);
        }
      else
        {
          if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items == 0)
            {
              b = static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail;
              if (b == NULL)
                {
                  M2Error_InternalError ((const char *) "stack underflow", 15);
                }
              else
                {
                  static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail = b->prev;
                }
              Storage_DEALLOCATE ((void **) &b, sizeof (M2StackAddress__T2));
            }
          if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail == NULL)
            {
              M2Error_InternalError ((const char *) "stack underflow", 15);
            }
          else
            {
              static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items -= 1;
              return static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->bucket.array[static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items];
            }
        }
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2StackAddress.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsEmptyAddress - returns TRUE if stack, s, is empty.
*/

extern "C" bool M2StackAddress_IsEmptyAddress (M2StackAddress_StackOfAddress s)
{
  return (s == NULL) || (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail == NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PeepAddress - returns the element at, n, items below in the stack.
                 Top of stack can be seen via Peep(s, 1)
*/

extern "C" void * M2StackAddress_PeepAddress (M2StackAddress_StackOfAddress s, unsigned int n)
{
  M2StackAddress_StackBucket b;

  if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail == NULL)
    {
      M2Error_InternalError ((const char *) "stack underflow", 15);
    }
  else
    {
      if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items == 0)
        {
          b = static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail;
          if (b == NULL)
            {
              M2Error_InternalError ((const char *) "stack underflow", 15);
            }
          else
            {
              static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail = b->prev;
            }
          Storage_DEALLOCATE ((void **) &b, sizeof (M2StackAddress__T2));
        }
      b = static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail;
      while (n >= 1)
        {
          if (b == NULL)
            {
              M2Error_InternalError ((const char *) "stack underflow", 15);
            }
          else if (b->items >= n)
            {
              /* avoid dangling else.  */
              return b->bucket.array[b->items-n];
            }
          else
            {
              /* avoid dangling else.  */
              M2Debug_Assert (b->items < n);
              n -= b->items;
              b = b->prev;
            }
        }
      M2Error_InternalError ((const char *) "stack underflow", 15);
    }
  ReturnException ("/tmp/pkg/src/gcc/gcc/m2/gm2-compiler/M2StackAddress.def", 20, 1);
  __builtin_unreachable ();
}


/*
   ReduceAddress - reduce the stack by n elements.
*/

extern "C" void M2StackAddress_ReduceAddress (M2StackAddress_StackOfAddress s, unsigned int n)
{
  M2StackAddress_StackBucket b;

  if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail == NULL)
    {
      M2Error_InternalError ((const char *) "stack underflow", 15);
    }
  else
    {
      if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items == 0)
        {
          b = static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail;
          if (b == NULL)
            {
              M2Error_InternalError ((const char *) "stack underflow", 15);
            }
          else
            {
              static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail = b->prev;
            }
          Storage_DEALLOCATE ((void **) &b, sizeof (M2StackAddress__T2));
        }
      for (;;)
      {
        if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail == NULL)
          {
            M2Error_InternalError ((const char *) "stack underflow", 15);
          }
        else if (static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items >= n)
          {
            /* avoid dangling else.  */
            static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->items -= n;
            return;  /* all done exit  */
          }
        else
          {
            /* avoid dangling else.  */
            b = static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail;
            n -= b->items;
            static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail = static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail->prev;
            Storage_DEALLOCATE ((void **) &b, sizeof (M2StackAddress__T2));
          }
      }
    }
}


/*
   NoOfItemsInStackAddress - returns the number of items held in the stack, s.
*/

extern "C" unsigned int M2StackAddress_NoOfItemsInStackAddress (M2StackAddress_StackOfAddress s)
{
  M2StackAddress_StackBucket b;
  unsigned int n;

  if (M2StackAddress_IsEmptyAddress (s))
    {
      return 0;
    }
  else
    {
      n = 0;
      b = static_cast<M2StackAddress_StackOfAddress__opaque> (s)->tail;
      while (b != NULL)
        {
          n += b->items;
          b = b->prev;
        }
      return n;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2StackAddress_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_M2StackAddress_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
