// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module VkEncoder
//
// (header) generated by ../mesa-25.3.1/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.3.1/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.3.1/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /tmp/pkg/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//
#pragma once
#include <vulkan/vulkan.h>
#include "vulkan_gfxstream.h"
#include "vk_android_native_buffer_gfxstream.h"

#include "goldfish_vk_private_defs.h"
#include <memory>

namespace gfxstream {
namespace guest {
class IOStream;
}  // namespace guest
}  // namespace gfxstream


namespace gfxstream {
namespace vk {



class VkEncoder {
public:
    VkEncoder(gfxstream::guest::IOStream* stream);
    ~VkEncoder();

#include "VkEncoder.h.inl"
#ifdef VK_VERSION_1_0
    VkResult vkCreateInstance(
    const VkInstanceCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkInstance* pInstance,
        uint32_t doLock);
    void vkDestroyInstance(
    VkInstance instance,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkEnumeratePhysicalDevices(
    VkInstance instance,
        uint32_t* pPhysicalDeviceCount,
        VkPhysicalDevice* pPhysicalDevices,
        uint32_t doLock);
    void vkGetPhysicalDeviceFeatures(
    VkPhysicalDevice physicalDevice,
        VkPhysicalDeviceFeatures* pFeatures,
        uint32_t doLock);
    void vkGetPhysicalDeviceFormatProperties(
    VkPhysicalDevice physicalDevice,
        VkFormat format,
        VkFormatProperties* pFormatProperties,
        uint32_t doLock);
    VkResult vkGetPhysicalDeviceImageFormatProperties(
    VkPhysicalDevice physicalDevice,
        VkFormat format,
        VkImageType type,
        VkImageTiling tiling,
        VkImageUsageFlags usage,
        VkImageCreateFlags flags,
        VkImageFormatProperties* pImageFormatProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceProperties(
    VkPhysicalDevice physicalDevice,
        VkPhysicalDeviceProperties* pProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceQueueFamilyProperties(
    VkPhysicalDevice physicalDevice,
        uint32_t* pQueueFamilyPropertyCount,
        VkQueueFamilyProperties* pQueueFamilyProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceMemoryProperties(
    VkPhysicalDevice physicalDevice,
        VkPhysicalDeviceMemoryProperties* pMemoryProperties,
        uint32_t doLock);
    PFN_vkVoidFunction vkGetInstanceProcAddr(
    VkInstance instance,
        const char* pName,
        uint32_t doLock);
    PFN_vkVoidFunction vkGetDeviceProcAddr(
    VkDevice device,
        const char* pName,
        uint32_t doLock);
    VkResult vkCreateDevice(
    VkPhysicalDevice physicalDevice,
        const VkDeviceCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkDevice* pDevice,
        uint32_t doLock);
    void vkDestroyDevice(
    VkDevice device,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkEnumerateInstanceExtensionProperties(
    const char* pLayerName,
        uint32_t* pPropertyCount,
        VkExtensionProperties* pProperties,
        uint32_t doLock);
    VkResult vkEnumerateDeviceExtensionProperties(
    VkPhysicalDevice physicalDevice,
        const char* pLayerName,
        uint32_t* pPropertyCount,
        VkExtensionProperties* pProperties,
        uint32_t doLock);
    VkResult vkEnumerateInstanceLayerProperties(
    uint32_t* pPropertyCount,
        VkLayerProperties* pProperties,
        uint32_t doLock);
    VkResult vkEnumerateDeviceLayerProperties(
    VkPhysicalDevice physicalDevice,
        uint32_t* pPropertyCount,
        VkLayerProperties* pProperties,
        uint32_t doLock);
    void vkGetDeviceQueue(
    VkDevice device,
        uint32_t queueFamilyIndex,
        uint32_t queueIndex,
        VkQueue* pQueue,
        uint32_t doLock);
    VkResult vkQueueSubmit(
    VkQueue queue,
        uint32_t submitCount,
        const VkSubmitInfo* pSubmits,
        VkFence fence,
        uint32_t doLock);
    VkResult vkQueueWaitIdle(
    VkQueue queue,
        uint32_t doLock);
    VkResult vkDeviceWaitIdle(
    VkDevice device,
        uint32_t doLock);
    VkResult vkAllocateMemory(
    VkDevice device,
        const VkMemoryAllocateInfo* pAllocateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkDeviceMemory* pMemory,
        uint32_t doLock);
    void vkFreeMemory(
    VkDevice device,
        VkDeviceMemory memory,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkMapMemory(
    VkDevice device,
        VkDeviceMemory memory,
        VkDeviceSize offset,
        VkDeviceSize size,
        VkMemoryMapFlags flags,
        void** ppData,
        uint32_t doLock);
    void vkUnmapMemory(
    VkDevice device,
        VkDeviceMemory memory,
        uint32_t doLock);
    VkResult vkFlushMappedMemoryRanges(
    VkDevice device,
        uint32_t memoryRangeCount,
        const VkMappedMemoryRange* pMemoryRanges,
        uint32_t doLock);
    VkResult vkInvalidateMappedMemoryRanges(
    VkDevice device,
        uint32_t memoryRangeCount,
        const VkMappedMemoryRange* pMemoryRanges,
        uint32_t doLock);
    void vkGetDeviceMemoryCommitment(
    VkDevice device,
        VkDeviceMemory memory,
        VkDeviceSize* pCommittedMemoryInBytes,
        uint32_t doLock);
    VkResult vkBindBufferMemory(
    VkDevice device,
        VkBuffer buffer,
        VkDeviceMemory memory,
        VkDeviceSize memoryOffset,
        uint32_t doLock);
    VkResult vkBindImageMemory(
    VkDevice device,
        VkImage image,
        VkDeviceMemory memory,
        VkDeviceSize memoryOffset,
        uint32_t doLock);
    void vkGetBufferMemoryRequirements(
    VkDevice device,
        VkBuffer buffer,
        VkMemoryRequirements* pMemoryRequirements,
        uint32_t doLock);
    void vkGetImageMemoryRequirements(
    VkDevice device,
        VkImage image,
        VkMemoryRequirements* pMemoryRequirements,
        uint32_t doLock);
    void vkGetImageSparseMemoryRequirements(
    VkDevice device,
        VkImage image,
        uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements* pSparseMemoryRequirements,
        uint32_t doLock);
    void vkGetPhysicalDeviceSparseImageFormatProperties(
    VkPhysicalDevice physicalDevice,
        VkFormat format,
        VkImageType type,
        VkSampleCountFlagBits samples,
        VkImageUsageFlags usage,
        VkImageTiling tiling,
        uint32_t* pPropertyCount,
        VkSparseImageFormatProperties* pProperties,
        uint32_t doLock);
    VkResult vkQueueBindSparse(
    VkQueue queue,
        uint32_t bindInfoCount,
        const VkBindSparseInfo* pBindInfo,
        VkFence fence,
        uint32_t doLock);
    VkResult vkCreateFence(
    VkDevice device,
        const VkFenceCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkFence* pFence,
        uint32_t doLock);
    void vkDestroyFence(
    VkDevice device,
        VkFence fence,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkResetFences(
    VkDevice device,
        uint32_t fenceCount,
        const VkFence* pFences,
        uint32_t doLock);
    VkResult vkGetFenceStatus(
    VkDevice device,
        VkFence fence,
        uint32_t doLock);
    VkResult vkWaitForFences(
    VkDevice device,
        uint32_t fenceCount,
        const VkFence* pFences,
        VkBool32 waitAll,
        uint64_t timeout,
        uint32_t doLock);
    VkResult vkCreateSemaphore(
    VkDevice device,
        const VkSemaphoreCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkSemaphore* pSemaphore,
        uint32_t doLock);
    void vkDestroySemaphore(
    VkDevice device,
        VkSemaphore semaphore,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreateEvent(
    VkDevice device,
        const VkEventCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkEvent* pEvent,
        uint32_t doLock);
    void vkDestroyEvent(
    VkDevice device,
        VkEvent event,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkGetEventStatus(
    VkDevice device,
        VkEvent event,
        uint32_t doLock);
    VkResult vkSetEvent(
    VkDevice device,
        VkEvent event,
        uint32_t doLock);
    VkResult vkResetEvent(
    VkDevice device,
        VkEvent event,
        uint32_t doLock);
    VkResult vkCreateQueryPool(
    VkDevice device,
        const VkQueryPoolCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkQueryPool* pQueryPool,
        uint32_t doLock);
    void vkDestroyQueryPool(
    VkDevice device,
        VkQueryPool queryPool,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkGetQueryPoolResults(
    VkDevice device,
        VkQueryPool queryPool,
        uint32_t firstQuery,
        uint32_t queryCount,
        size_t dataSize,
        void* pData,
        VkDeviceSize stride,
        VkQueryResultFlags flags,
        uint32_t doLock);
    VkResult vkCreateBuffer(
    VkDevice device,
        const VkBufferCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkBuffer* pBuffer,
        uint32_t doLock);
    void vkDestroyBuffer(
    VkDevice device,
        VkBuffer buffer,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreateBufferView(
    VkDevice device,
        const VkBufferViewCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkBufferView* pView,
        uint32_t doLock);
    void vkDestroyBufferView(
    VkDevice device,
        VkBufferView bufferView,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreateImage(
    VkDevice device,
        const VkImageCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkImage* pImage,
        uint32_t doLock);
    void vkDestroyImage(
    VkDevice device,
        VkImage image,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    void vkGetImageSubresourceLayout(
    VkDevice device,
        VkImage image,
        const VkImageSubresource* pSubresource,
        VkSubresourceLayout* pLayout,
        uint32_t doLock);
    VkResult vkCreateImageView(
    VkDevice device,
        const VkImageViewCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkImageView* pView,
        uint32_t doLock);
    void vkDestroyImageView(
    VkDevice device,
        VkImageView imageView,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreateShaderModule(
    VkDevice device,
        const VkShaderModuleCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkShaderModule* pShaderModule,
        uint32_t doLock);
    void vkDestroyShaderModule(
    VkDevice device,
        VkShaderModule shaderModule,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreatePipelineCache(
    VkDevice device,
        const VkPipelineCacheCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkPipelineCache* pPipelineCache,
        uint32_t doLock);
    void vkDestroyPipelineCache(
    VkDevice device,
        VkPipelineCache pipelineCache,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkGetPipelineCacheData(
    VkDevice device,
        VkPipelineCache pipelineCache,
        size_t* pDataSize,
        void* pData,
        uint32_t doLock);
    VkResult vkMergePipelineCaches(
    VkDevice device,
        VkPipelineCache dstCache,
        uint32_t srcCacheCount,
        const VkPipelineCache* pSrcCaches,
        uint32_t doLock);
    VkResult vkCreateGraphicsPipelines(
    VkDevice device,
        VkPipelineCache pipelineCache,
        uint32_t createInfoCount,
        const VkGraphicsPipelineCreateInfo* pCreateInfos,
        const VkAllocationCallbacks* pAllocator,
        VkPipeline* pPipelines,
        uint32_t doLock);
    VkResult vkCreateComputePipelines(
    VkDevice device,
        VkPipelineCache pipelineCache,
        uint32_t createInfoCount,
        const VkComputePipelineCreateInfo* pCreateInfos,
        const VkAllocationCallbacks* pAllocator,
        VkPipeline* pPipelines,
        uint32_t doLock);
    void vkDestroyPipeline(
    VkDevice device,
        VkPipeline pipeline,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreatePipelineLayout(
    VkDevice device,
        const VkPipelineLayoutCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkPipelineLayout* pPipelineLayout,
        uint32_t doLock);
    void vkDestroyPipelineLayout(
    VkDevice device,
        VkPipelineLayout pipelineLayout,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreateSampler(
    VkDevice device,
        const VkSamplerCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkSampler* pSampler,
        uint32_t doLock);
    void vkDestroySampler(
    VkDevice device,
        VkSampler sampler,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreateDescriptorSetLayout(
    VkDevice device,
        const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkDescriptorSetLayout* pSetLayout,
        uint32_t doLock);
    void vkDestroyDescriptorSetLayout(
    VkDevice device,
        VkDescriptorSetLayout descriptorSetLayout,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreateDescriptorPool(
    VkDevice device,
        const VkDescriptorPoolCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkDescriptorPool* pDescriptorPool,
        uint32_t doLock);
    void vkDestroyDescriptorPool(
    VkDevice device,
        VkDescriptorPool descriptorPool,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkResetDescriptorPool(
    VkDevice device,
        VkDescriptorPool descriptorPool,
        VkDescriptorPoolResetFlags flags,
        uint32_t doLock);
    VkResult vkAllocateDescriptorSets(
    VkDevice device,
        const VkDescriptorSetAllocateInfo* pAllocateInfo,
        VkDescriptorSet* pDescriptorSets,
        uint32_t doLock);
    VkResult vkFreeDescriptorSets(
    VkDevice device,
        VkDescriptorPool descriptorPool,
        uint32_t descriptorSetCount,
        const VkDescriptorSet* pDescriptorSets,
        uint32_t doLock);
    void vkUpdateDescriptorSets(
    VkDevice device,
        uint32_t descriptorWriteCount,
        const VkWriteDescriptorSet* pDescriptorWrites,
        uint32_t descriptorCopyCount,
        const VkCopyDescriptorSet* pDescriptorCopies,
        uint32_t doLock);
    VkResult vkCreateFramebuffer(
    VkDevice device,
        const VkFramebufferCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkFramebuffer* pFramebuffer,
        uint32_t doLock);
    void vkDestroyFramebuffer(
    VkDevice device,
        VkFramebuffer framebuffer,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreateRenderPass(
    VkDevice device,
        const VkRenderPassCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkRenderPass* pRenderPass,
        uint32_t doLock);
    void vkDestroyRenderPass(
    VkDevice device,
        VkRenderPass renderPass,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    void vkGetRenderAreaGranularity(
    VkDevice device,
        VkRenderPass renderPass,
        VkExtent2D* pGranularity,
        uint32_t doLock);
    VkResult vkCreateCommandPool(
    VkDevice device,
        const VkCommandPoolCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkCommandPool* pCommandPool,
        uint32_t doLock);
    void vkDestroyCommandPool(
    VkDevice device,
        VkCommandPool commandPool,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkResetCommandPool(
    VkDevice device,
        VkCommandPool commandPool,
        VkCommandPoolResetFlags flags,
        uint32_t doLock);
    VkResult vkAllocateCommandBuffers(
    VkDevice device,
        const VkCommandBufferAllocateInfo* pAllocateInfo,
        VkCommandBuffer* pCommandBuffers,
        uint32_t doLock);
    void vkFreeCommandBuffers(
    VkDevice device,
        VkCommandPool commandPool,
        uint32_t commandBufferCount,
        const VkCommandBuffer* pCommandBuffers,
        uint32_t doLock);
    VkResult vkBeginCommandBuffer(
    VkCommandBuffer commandBuffer,
        const VkCommandBufferBeginInfo* pBeginInfo,
        uint32_t doLock);
    VkResult vkEndCommandBuffer(
    VkCommandBuffer commandBuffer,
        uint32_t doLock);
    VkResult vkResetCommandBuffer(
    VkCommandBuffer commandBuffer,
        VkCommandBufferResetFlags flags,
        uint32_t doLock);
    void vkCmdBindPipeline(
    VkCommandBuffer commandBuffer,
        VkPipelineBindPoint pipelineBindPoint,
        VkPipeline pipeline,
        uint32_t doLock);
    void vkCmdSetViewport(
    VkCommandBuffer commandBuffer,
        uint32_t firstViewport,
        uint32_t viewportCount,
        const VkViewport* pViewports,
        uint32_t doLock);
    void vkCmdSetScissor(
    VkCommandBuffer commandBuffer,
        uint32_t firstScissor,
        uint32_t scissorCount,
        const VkRect2D* pScissors,
        uint32_t doLock);
    void vkCmdSetLineWidth(
    VkCommandBuffer commandBuffer,
        float lineWidth,
        uint32_t doLock);
    void vkCmdSetDepthBias(
    VkCommandBuffer commandBuffer,
        float depthBiasConstantFactor,
        float depthBiasClamp,
        float depthBiasSlopeFactor,
        uint32_t doLock);
    void vkCmdSetBlendConstants(
    VkCommandBuffer commandBuffer,
        const float blendConstants[4],
        uint32_t doLock);
    void vkCmdSetDepthBounds(
    VkCommandBuffer commandBuffer,
        float minDepthBounds,
        float maxDepthBounds,
        uint32_t doLock);
    void vkCmdSetStencilCompareMask(
    VkCommandBuffer commandBuffer,
        VkStencilFaceFlags faceMask,
        uint32_t compareMask,
        uint32_t doLock);
    void vkCmdSetStencilWriteMask(
    VkCommandBuffer commandBuffer,
        VkStencilFaceFlags faceMask,
        uint32_t writeMask,
        uint32_t doLock);
    void vkCmdSetStencilReference(
    VkCommandBuffer commandBuffer,
        VkStencilFaceFlags faceMask,
        uint32_t reference,
        uint32_t doLock);
    void vkCmdBindDescriptorSets(
    VkCommandBuffer commandBuffer,
        VkPipelineBindPoint pipelineBindPoint,
        VkPipelineLayout layout,
        uint32_t firstSet,
        uint32_t descriptorSetCount,
        const VkDescriptorSet* pDescriptorSets,
        uint32_t dynamicOffsetCount,
        const uint32_t* pDynamicOffsets,
        uint32_t doLock);
    void vkCmdBindIndexBuffer(
    VkCommandBuffer commandBuffer,
        VkBuffer buffer,
        VkDeviceSize offset,
        VkIndexType indexType,
        uint32_t doLock);
    void vkCmdBindVertexBuffers(
    VkCommandBuffer commandBuffer,
        uint32_t firstBinding,
        uint32_t bindingCount,
        const VkBuffer* pBuffers,
        const VkDeviceSize* pOffsets,
        uint32_t doLock);
    void vkCmdDraw(
    VkCommandBuffer commandBuffer,
        uint32_t vertexCount,
        uint32_t instanceCount,
        uint32_t firstVertex,
        uint32_t firstInstance,
        uint32_t doLock);
    void vkCmdDrawIndexed(
    VkCommandBuffer commandBuffer,
        uint32_t indexCount,
        uint32_t instanceCount,
        uint32_t firstIndex,
        int32_t vertexOffset,
        uint32_t firstInstance,
        uint32_t doLock);
    void vkCmdDrawIndirect(
    VkCommandBuffer commandBuffer,
        VkBuffer buffer,
        VkDeviceSize offset,
        uint32_t drawCount,
        uint32_t stride,
        uint32_t doLock);
    void vkCmdDrawIndexedIndirect(
    VkCommandBuffer commandBuffer,
        VkBuffer buffer,
        VkDeviceSize offset,
        uint32_t drawCount,
        uint32_t stride,
        uint32_t doLock);
    void vkCmdDispatch(
    VkCommandBuffer commandBuffer,
        uint32_t groupCountX,
        uint32_t groupCountY,
        uint32_t groupCountZ,
        uint32_t doLock);
    void vkCmdDispatchIndirect(
    VkCommandBuffer commandBuffer,
        VkBuffer buffer,
        VkDeviceSize offset,
        uint32_t doLock);
    void vkCmdCopyBuffer(
    VkCommandBuffer commandBuffer,
        VkBuffer srcBuffer,
        VkBuffer dstBuffer,
        uint32_t regionCount,
        const VkBufferCopy* pRegions,
        uint32_t doLock);
    void vkCmdCopyImage(
    VkCommandBuffer commandBuffer,
        VkImage srcImage,
        VkImageLayout srcImageLayout,
        VkImage dstImage,
        VkImageLayout dstImageLayout,
        uint32_t regionCount,
        const VkImageCopy* pRegions,
        uint32_t doLock);
    void vkCmdBlitImage(
    VkCommandBuffer commandBuffer,
        VkImage srcImage,
        VkImageLayout srcImageLayout,
        VkImage dstImage,
        VkImageLayout dstImageLayout,
        uint32_t regionCount,
        const VkImageBlit* pRegions,
        VkFilter filter,
        uint32_t doLock);
    void vkCmdCopyBufferToImage(
    VkCommandBuffer commandBuffer,
        VkBuffer srcBuffer,
        VkImage dstImage,
        VkImageLayout dstImageLayout,
        uint32_t regionCount,
        const VkBufferImageCopy* pRegions,
        uint32_t doLock);
    void vkCmdCopyImageToBuffer(
    VkCommandBuffer commandBuffer,
        VkImage srcImage,
        VkImageLayout srcImageLayout,
        VkBuffer dstBuffer,
        uint32_t regionCount,
        const VkBufferImageCopy* pRegions,
        uint32_t doLock);
    void vkCmdUpdateBuffer(
    VkCommandBuffer commandBuffer,
        VkBuffer dstBuffer,
        VkDeviceSize dstOffset,
        VkDeviceSize dataSize,
        const void* pData,
        uint32_t doLock);
    void vkCmdFillBuffer(
    VkCommandBuffer commandBuffer,
        VkBuffer dstBuffer,
        VkDeviceSize dstOffset,
        VkDeviceSize size,
        uint32_t data,
        uint32_t doLock);
    void vkCmdClearColorImage(
    VkCommandBuffer commandBuffer,
        VkImage image,
        VkImageLayout imageLayout,
        const VkClearColorValue* pColor,
        uint32_t rangeCount,
        const VkImageSubresourceRange* pRanges,
        uint32_t doLock);
    void vkCmdClearDepthStencilImage(
    VkCommandBuffer commandBuffer,
        VkImage image,
        VkImageLayout imageLayout,
        const VkClearDepthStencilValue* pDepthStencil,
        uint32_t rangeCount,
        const VkImageSubresourceRange* pRanges,
        uint32_t doLock);
    void vkCmdClearAttachments(
    VkCommandBuffer commandBuffer,
        uint32_t attachmentCount,
        const VkClearAttachment* pAttachments,
        uint32_t rectCount,
        const VkClearRect* pRects,
        uint32_t doLock);
    void vkCmdResolveImage(
    VkCommandBuffer commandBuffer,
        VkImage srcImage,
        VkImageLayout srcImageLayout,
        VkImage dstImage,
        VkImageLayout dstImageLayout,
        uint32_t regionCount,
        const VkImageResolve* pRegions,
        uint32_t doLock);
    void vkCmdSetEvent(
    VkCommandBuffer commandBuffer,
        VkEvent event,
        VkPipelineStageFlags stageMask,
        uint32_t doLock);
    void vkCmdResetEvent(
    VkCommandBuffer commandBuffer,
        VkEvent event,
        VkPipelineStageFlags stageMask,
        uint32_t doLock);
    void vkCmdWaitEvents(
    VkCommandBuffer commandBuffer,
        uint32_t eventCount,
        const VkEvent* pEvents,
        VkPipelineStageFlags srcStageMask,
        VkPipelineStageFlags dstStageMask,
        uint32_t memoryBarrierCount,
        const VkMemoryBarrier* pMemoryBarriers,
        uint32_t bufferMemoryBarrierCount,
        const VkBufferMemoryBarrier* pBufferMemoryBarriers,
        uint32_t imageMemoryBarrierCount,
        const VkImageMemoryBarrier* pImageMemoryBarriers,
        uint32_t doLock);
    void vkCmdPipelineBarrier(
    VkCommandBuffer commandBuffer,
        VkPipelineStageFlags srcStageMask,
        VkPipelineStageFlags dstStageMask,
        VkDependencyFlags dependencyFlags,
        uint32_t memoryBarrierCount,
        const VkMemoryBarrier* pMemoryBarriers,
        uint32_t bufferMemoryBarrierCount,
        const VkBufferMemoryBarrier* pBufferMemoryBarriers,
        uint32_t imageMemoryBarrierCount,
        const VkImageMemoryBarrier* pImageMemoryBarriers,
        uint32_t doLock);
    void vkCmdBeginQuery(
    VkCommandBuffer commandBuffer,
        VkQueryPool queryPool,
        uint32_t query,
        VkQueryControlFlags flags,
        uint32_t doLock);
    void vkCmdEndQuery(
    VkCommandBuffer commandBuffer,
        VkQueryPool queryPool,
        uint32_t query,
        uint32_t doLock);
    void vkCmdResetQueryPool(
    VkCommandBuffer commandBuffer,
        VkQueryPool queryPool,
        uint32_t firstQuery,
        uint32_t queryCount,
        uint32_t doLock);
    void vkCmdWriteTimestamp(
    VkCommandBuffer commandBuffer,
        VkPipelineStageFlagBits pipelineStage,
        VkQueryPool queryPool,
        uint32_t query,
        uint32_t doLock);
    void vkCmdCopyQueryPoolResults(
    VkCommandBuffer commandBuffer,
        VkQueryPool queryPool,
        uint32_t firstQuery,
        uint32_t queryCount,
        VkBuffer dstBuffer,
        VkDeviceSize dstOffset,
        VkDeviceSize stride,
        VkQueryResultFlags flags,
        uint32_t doLock);
    void vkCmdPushConstants(
    VkCommandBuffer commandBuffer,
        VkPipelineLayout layout,
        VkShaderStageFlags stageFlags,
        uint32_t offset,
        uint32_t size,
        const void* pValues,
        uint32_t doLock);
    void vkCmdBeginRenderPass(
    VkCommandBuffer commandBuffer,
        const VkRenderPassBeginInfo* pRenderPassBegin,
        VkSubpassContents contents,
        uint32_t doLock);
    void vkCmdNextSubpass(
    VkCommandBuffer commandBuffer,
        VkSubpassContents contents,
        uint32_t doLock);
    void vkCmdEndRenderPass(
    VkCommandBuffer commandBuffer,
        uint32_t doLock);
    void vkCmdExecuteCommands(
    VkCommandBuffer commandBuffer,
        uint32_t commandBufferCount,
        const VkCommandBuffer* pCommandBuffers,
        uint32_t doLock);
#endif
#ifdef VK_VERSION_1_1
    VkResult vkEnumerateInstanceVersion(
    uint32_t* pApiVersion,
        uint32_t doLock);
    VkResult vkBindBufferMemory2(
    VkDevice device,
        uint32_t bindInfoCount,
        const VkBindBufferMemoryInfo* pBindInfos,
        uint32_t doLock);
    VkResult vkBindImageMemory2(
    VkDevice device,
        uint32_t bindInfoCount,
        const VkBindImageMemoryInfo* pBindInfos,
        uint32_t doLock);
    void vkGetDeviceGroupPeerMemoryFeatures(
    VkDevice device,
        uint32_t heapIndex,
        uint32_t localDeviceIndex,
        uint32_t remoteDeviceIndex,
        VkPeerMemoryFeatureFlags* pPeerMemoryFeatures,
        uint32_t doLock);
    void vkCmdSetDeviceMask(
    VkCommandBuffer commandBuffer,
        uint32_t deviceMask,
        uint32_t doLock);
    void vkCmdDispatchBase(
    VkCommandBuffer commandBuffer,
        uint32_t baseGroupX,
        uint32_t baseGroupY,
        uint32_t baseGroupZ,
        uint32_t groupCountX,
        uint32_t groupCountY,
        uint32_t groupCountZ,
        uint32_t doLock);
    VkResult vkEnumeratePhysicalDeviceGroups(
    VkInstance instance,
        uint32_t* pPhysicalDeviceGroupCount,
        VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties,
        uint32_t doLock);
    void vkGetImageMemoryRequirements2(
    VkDevice device,
        const VkImageMemoryRequirementsInfo2* pInfo,
        VkMemoryRequirements2* pMemoryRequirements,
        uint32_t doLock);
    void vkGetBufferMemoryRequirements2(
    VkDevice device,
        const VkBufferMemoryRequirementsInfo2* pInfo,
        VkMemoryRequirements2* pMemoryRequirements,
        uint32_t doLock);
    void vkGetImageSparseMemoryRequirements2(
    VkDevice device,
        const VkImageSparseMemoryRequirementsInfo2* pInfo,
        uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements2* pSparseMemoryRequirements,
        uint32_t doLock);
    void vkGetPhysicalDeviceFeatures2(
    VkPhysicalDevice physicalDevice,
        VkPhysicalDeviceFeatures2* pFeatures,
        uint32_t doLock);
    void vkGetPhysicalDeviceProperties2(
    VkPhysicalDevice physicalDevice,
        VkPhysicalDeviceProperties2* pProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceFormatProperties2(
    VkPhysicalDevice physicalDevice,
        VkFormat format,
        VkFormatProperties2* pFormatProperties,
        uint32_t doLock);
    VkResult vkGetPhysicalDeviceImageFormatProperties2(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
        VkImageFormatProperties2* pImageFormatProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceQueueFamilyProperties2(
    VkPhysicalDevice physicalDevice,
        uint32_t* pQueueFamilyPropertyCount,
        VkQueueFamilyProperties2* pQueueFamilyProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceMemoryProperties2(
    VkPhysicalDevice physicalDevice,
        VkPhysicalDeviceMemoryProperties2* pMemoryProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceSparseImageFormatProperties2(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
        uint32_t* pPropertyCount,
        VkSparseImageFormatProperties2* pProperties,
        uint32_t doLock);
    void vkTrimCommandPool(
    VkDevice device,
        VkCommandPool commandPool,
        VkCommandPoolTrimFlags flags,
        uint32_t doLock);
    void vkGetDeviceQueue2(
    VkDevice device,
        const VkDeviceQueueInfo2* pQueueInfo,
        VkQueue* pQueue,
        uint32_t doLock);
    VkResult vkCreateSamplerYcbcrConversion(
    VkDevice device,
        const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkSamplerYcbcrConversion* pYcbcrConversion,
        uint32_t doLock);
    void vkDestroySamplerYcbcrConversion(
    VkDevice device,
        VkSamplerYcbcrConversion ycbcrConversion,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkCreateDescriptorUpdateTemplate(
    VkDevice device,
        const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate,
        uint32_t doLock);
    void vkDestroyDescriptorUpdateTemplate(
    VkDevice device,
        VkDescriptorUpdateTemplate descriptorUpdateTemplate,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    void vkUpdateDescriptorSetWithTemplate(
    VkDevice device,
        VkDescriptorSet descriptorSet,
        VkDescriptorUpdateTemplate descriptorUpdateTemplate,
        const void* pData,
        uint32_t doLock);
    void vkGetPhysicalDeviceExternalBufferProperties(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
        VkExternalBufferProperties* pExternalBufferProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceExternalFenceProperties(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
        VkExternalFenceProperties* pExternalFenceProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceExternalSemaphoreProperties(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
        VkExternalSemaphoreProperties* pExternalSemaphoreProperties,
        uint32_t doLock);
    void vkGetDescriptorSetLayoutSupport(
    VkDevice device,
        const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
        VkDescriptorSetLayoutSupport* pSupport,
        uint32_t doLock);
#endif
#ifdef VK_VERSION_1_2
    void vkCmdDrawIndirectCount(
    VkCommandBuffer commandBuffer,
        VkBuffer buffer,
        VkDeviceSize offset,
        VkBuffer countBuffer,
        VkDeviceSize countBufferOffset,
        uint32_t maxDrawCount,
        uint32_t stride,
        uint32_t doLock);
    void vkCmdDrawIndexedIndirectCount(
    VkCommandBuffer commandBuffer,
        VkBuffer buffer,
        VkDeviceSize offset,
        VkBuffer countBuffer,
        VkDeviceSize countBufferOffset,
        uint32_t maxDrawCount,
        uint32_t stride,
        uint32_t doLock);
    VkResult vkCreateRenderPass2(
    VkDevice device,
        const VkRenderPassCreateInfo2* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkRenderPass* pRenderPass,
        uint32_t doLock);
    void vkCmdBeginRenderPass2(
    VkCommandBuffer commandBuffer,
        const VkRenderPassBeginInfo* pRenderPassBegin,
        const VkSubpassBeginInfo* pSubpassBeginInfo,
        uint32_t doLock);
    void vkCmdNextSubpass2(
    VkCommandBuffer commandBuffer,
        const VkSubpassBeginInfo* pSubpassBeginInfo,
        const VkSubpassEndInfo* pSubpassEndInfo,
        uint32_t doLock);
    void vkCmdEndRenderPass2(
    VkCommandBuffer commandBuffer,
        const VkSubpassEndInfo* pSubpassEndInfo,
        uint32_t doLock);
    void vkResetQueryPool(
    VkDevice device,
        VkQueryPool queryPool,
        uint32_t firstQuery,
        uint32_t queryCount,
        uint32_t doLock);
    VkResult vkGetSemaphoreCounterValue(
    VkDevice device,
        VkSemaphore semaphore,
        uint64_t* pValue,
        uint32_t doLock);
    VkResult vkWaitSemaphores(
    VkDevice device,
        const VkSemaphoreWaitInfo* pWaitInfo,
        uint64_t timeout,
        uint32_t doLock);
    VkResult vkSignalSemaphore(
    VkDevice device,
        const VkSemaphoreSignalInfo* pSignalInfo,
        uint32_t doLock);
    VkDeviceAddress vkGetBufferDeviceAddress(
    VkDevice device,
        const VkBufferDeviceAddressInfo* pInfo,
        uint32_t doLock);
    uint64_t vkGetBufferOpaqueCaptureAddress(
    VkDevice device,
        const VkBufferDeviceAddressInfo* pInfo,
        uint32_t doLock);
    uint64_t vkGetDeviceMemoryOpaqueCaptureAddress(
    VkDevice device,
        const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo,
        uint32_t doLock);
#endif
#ifdef VK_VERSION_1_3
    VkResult vkGetPhysicalDeviceToolProperties(
    VkPhysicalDevice physicalDevice,
        uint32_t* pToolCount,
        VkPhysicalDeviceToolProperties* pToolProperties,
        uint32_t doLock);
    VkResult vkCreatePrivateDataSlot(
    VkDevice device,
        const VkPrivateDataSlotCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkPrivateDataSlot* pPrivateDataSlot,
        uint32_t doLock);
    void vkDestroyPrivateDataSlot(
    VkDevice device,
        VkPrivateDataSlot privateDataSlot,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkSetPrivateData(
    VkDevice device,
        VkObjectType objectType,
        uint64_t objectHandle,
        VkPrivateDataSlot privateDataSlot,
        uint64_t data,
        uint32_t doLock);
    void vkGetPrivateData(
    VkDevice device,
        VkObjectType objectType,
        uint64_t objectHandle,
        VkPrivateDataSlot privateDataSlot,
        uint64_t* pData,
        uint32_t doLock);
    void vkCmdSetEvent2(
    VkCommandBuffer commandBuffer,
        VkEvent event,
        const VkDependencyInfo* pDependencyInfo,
        uint32_t doLock);
    void vkCmdResetEvent2(
    VkCommandBuffer commandBuffer,
        VkEvent event,
        VkPipelineStageFlags2 stageMask,
        uint32_t doLock);
    void vkCmdWaitEvents2(
    VkCommandBuffer commandBuffer,
        uint32_t eventCount,
        const VkEvent* pEvents,
        const VkDependencyInfo* pDependencyInfos,
        uint32_t doLock);
    void vkCmdPipelineBarrier2(
    VkCommandBuffer commandBuffer,
        const VkDependencyInfo* pDependencyInfo,
        uint32_t doLock);
    void vkCmdWriteTimestamp2(
    VkCommandBuffer commandBuffer,
        VkPipelineStageFlags2 stage,
        VkQueryPool queryPool,
        uint32_t query,
        uint32_t doLock);
    VkResult vkQueueSubmit2(
    VkQueue queue,
        uint32_t submitCount,
        const VkSubmitInfo2* pSubmits,
        VkFence fence,
        uint32_t doLock);
    void vkCmdCopyBuffer2(
    VkCommandBuffer commandBuffer,
        const VkCopyBufferInfo2* pCopyBufferInfo,
        uint32_t doLock);
    void vkCmdCopyImage2(
    VkCommandBuffer commandBuffer,
        const VkCopyImageInfo2* pCopyImageInfo,
        uint32_t doLock);
    void vkCmdCopyBufferToImage2(
    VkCommandBuffer commandBuffer,
        const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo,
        uint32_t doLock);
    void vkCmdCopyImageToBuffer2(
    VkCommandBuffer commandBuffer,
        const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo,
        uint32_t doLock);
    void vkCmdBlitImage2(
    VkCommandBuffer commandBuffer,
        const VkBlitImageInfo2* pBlitImageInfo,
        uint32_t doLock);
    void vkCmdResolveImage2(
    VkCommandBuffer commandBuffer,
        const VkResolveImageInfo2* pResolveImageInfo,
        uint32_t doLock);
    void vkCmdBeginRendering(
    VkCommandBuffer commandBuffer,
        const VkRenderingInfo* pRenderingInfo,
        uint32_t doLock);
    void vkCmdEndRendering(
    VkCommandBuffer commandBuffer,
        uint32_t doLock);
    void vkCmdSetCullMode(
    VkCommandBuffer commandBuffer,
        VkCullModeFlags cullMode,
        uint32_t doLock);
    void vkCmdSetFrontFace(
    VkCommandBuffer commandBuffer,
        VkFrontFace frontFace,
        uint32_t doLock);
    void vkCmdSetPrimitiveTopology(
    VkCommandBuffer commandBuffer,
        VkPrimitiveTopology primitiveTopology,
        uint32_t doLock);
    void vkCmdSetViewportWithCount(
    VkCommandBuffer commandBuffer,
        uint32_t viewportCount,
        const VkViewport* pViewports,
        uint32_t doLock);
    void vkCmdSetScissorWithCount(
    VkCommandBuffer commandBuffer,
        uint32_t scissorCount,
        const VkRect2D* pScissors,
        uint32_t doLock);
    void vkCmdBindVertexBuffers2(
    VkCommandBuffer commandBuffer,
        uint32_t firstBinding,
        uint32_t bindingCount,
        const VkBuffer* pBuffers,
        const VkDeviceSize* pOffsets,
        const VkDeviceSize* pSizes,
        const VkDeviceSize* pStrides,
        uint32_t doLock);
    void vkCmdSetDepthTestEnable(
    VkCommandBuffer commandBuffer,
        VkBool32 depthTestEnable,
        uint32_t doLock);
    void vkCmdSetDepthWriteEnable(
    VkCommandBuffer commandBuffer,
        VkBool32 depthWriteEnable,
        uint32_t doLock);
    void vkCmdSetDepthCompareOp(
    VkCommandBuffer commandBuffer,
        VkCompareOp depthCompareOp,
        uint32_t doLock);
    void vkCmdSetDepthBoundsTestEnable(
    VkCommandBuffer commandBuffer,
        VkBool32 depthBoundsTestEnable,
        uint32_t doLock);
    void vkCmdSetStencilTestEnable(
    VkCommandBuffer commandBuffer,
        VkBool32 stencilTestEnable,
        uint32_t doLock);
    void vkCmdSetStencilOp(
    VkCommandBuffer commandBuffer,
        VkStencilFaceFlags faceMask,
        VkStencilOp failOp,
        VkStencilOp passOp,
        VkStencilOp depthFailOp,
        VkCompareOp compareOp,
        uint32_t doLock);
    void vkCmdSetRasterizerDiscardEnable(
    VkCommandBuffer commandBuffer,
        VkBool32 rasterizerDiscardEnable,
        uint32_t doLock);
    void vkCmdSetDepthBiasEnable(
    VkCommandBuffer commandBuffer,
        VkBool32 depthBiasEnable,
        uint32_t doLock);
    void vkCmdSetPrimitiveRestartEnable(
    VkCommandBuffer commandBuffer,
        VkBool32 primitiveRestartEnable,
        uint32_t doLock);
    void vkGetDeviceBufferMemoryRequirements(
    VkDevice device,
        const VkDeviceBufferMemoryRequirements* pInfo,
        VkMemoryRequirements2* pMemoryRequirements,
        uint32_t doLock);
    void vkGetDeviceImageMemoryRequirements(
    VkDevice device,
        const VkDeviceImageMemoryRequirements* pInfo,
        VkMemoryRequirements2* pMemoryRequirements,
        uint32_t doLock);
    void vkGetDeviceImageSparseMemoryRequirements(
    VkDevice device,
        const VkDeviceImageMemoryRequirements* pInfo,
        uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements2* pSparseMemoryRequirements,
        uint32_t doLock);
#endif
#ifdef VK_VERSION_1_4
    void vkCmdSetLineStipple(
    VkCommandBuffer commandBuffer,
        uint32_t lineStippleFactor,
        uint16_t lineStipplePattern,
        uint32_t doLock);
    VkResult vkMapMemory2(
    VkDevice device,
        const VkMemoryMapInfo* pMemoryMapInfo,
        void** ppData,
        uint32_t doLock);
    VkResult vkUnmapMemory2(
    VkDevice device,
        const VkMemoryUnmapInfo* pMemoryUnmapInfo,
        uint32_t doLock);
    void vkCmdBindIndexBuffer2(
    VkCommandBuffer commandBuffer,
        VkBuffer buffer,
        VkDeviceSize offset,
        VkDeviceSize size,
        VkIndexType indexType,
        uint32_t doLock);
    void vkGetRenderingAreaGranularity(
    VkDevice device,
        const VkRenderingAreaInfo* pRenderingAreaInfo,
        VkExtent2D* pGranularity,
        uint32_t doLock);
    void vkGetDeviceImageSubresourceLayout(
    VkDevice device,
        const VkDeviceImageSubresourceInfo* pInfo,
        VkSubresourceLayout2* pLayout,
        uint32_t doLock);
    void vkGetImageSubresourceLayout2(
    VkDevice device,
        VkImage image,
        const VkImageSubresource2* pSubresource,
        VkSubresourceLayout2* pLayout,
        uint32_t doLock);
    void vkCmdPushDescriptorSet(
    VkCommandBuffer commandBuffer,
        VkPipelineBindPoint pipelineBindPoint,
        VkPipelineLayout layout,
        uint32_t set,
        uint32_t descriptorWriteCount,
        const VkWriteDescriptorSet* pDescriptorWrites,
        uint32_t doLock);
    void vkCmdPushDescriptorSetWithTemplate(
    VkCommandBuffer commandBuffer,
        VkDescriptorUpdateTemplate descriptorUpdateTemplate,
        VkPipelineLayout layout,
        uint32_t set,
        const void* pData,
        uint32_t doLock);
    void vkCmdSetRenderingAttachmentLocations(
    VkCommandBuffer commandBuffer,
        const VkRenderingAttachmentLocationInfo* pLocationInfo,
        uint32_t doLock);
    void vkCmdSetRenderingInputAttachmentIndices(
    VkCommandBuffer commandBuffer,
        const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo,
        uint32_t doLock);
    void vkCmdBindDescriptorSets2(
    VkCommandBuffer commandBuffer,
        const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo,
        uint32_t doLock);
    void vkCmdPushConstants2(
    VkCommandBuffer commandBuffer,
        const VkPushConstantsInfo* pPushConstantsInfo,
        uint32_t doLock);
    void vkCmdPushDescriptorSet2(
    VkCommandBuffer commandBuffer,
        const VkPushDescriptorSetInfo* pPushDescriptorSetInfo,
        uint32_t doLock);
    void vkCmdPushDescriptorSetWithTemplate2(
    VkCommandBuffer commandBuffer,
        const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo,
        uint32_t doLock);
    VkResult vkCopyMemoryToImage(
    VkDevice device,
        const VkCopyMemoryToImageInfo* pCopyMemoryToImageInfo,
        uint32_t doLock);
    VkResult vkCopyImageToMemory(
    VkDevice device,
        const VkCopyImageToMemoryInfo* pCopyImageToMemoryInfo,
        uint32_t doLock);
    VkResult vkCopyImageToImage(
    VkDevice device,
        const VkCopyImageToImageInfo* pCopyImageToImageInfo,
        uint32_t doLock);
    VkResult vkTransitionImageLayout(
    VkDevice device,
        uint32_t transitionCount,
        const VkHostImageLayoutTransitionInfo* pTransitions,
        uint32_t doLock);
#endif
#ifdef VK_KHR_dynamic_rendering
    void vkCmdBeginRenderingKHR(
    VkCommandBuffer commandBuffer,
        const VkRenderingInfo* pRenderingInfo,
        uint32_t doLock);
    void vkCmdEndRenderingKHR(
    VkCommandBuffer commandBuffer,
        uint32_t doLock);
#endif
#ifdef VK_KHR_get_physical_device_properties2
    void vkGetPhysicalDeviceFeatures2KHR(
    VkPhysicalDevice physicalDevice,
        VkPhysicalDeviceFeatures2* pFeatures,
        uint32_t doLock);
    void vkGetPhysicalDeviceProperties2KHR(
    VkPhysicalDevice physicalDevice,
        VkPhysicalDeviceProperties2* pProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceFormatProperties2KHR(
    VkPhysicalDevice physicalDevice,
        VkFormat format,
        VkFormatProperties2* pFormatProperties,
        uint32_t doLock);
    VkResult vkGetPhysicalDeviceImageFormatProperties2KHR(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
        VkImageFormatProperties2* pImageFormatProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceQueueFamilyProperties2KHR(
    VkPhysicalDevice physicalDevice,
        uint32_t* pQueueFamilyPropertyCount,
        VkQueueFamilyProperties2* pQueueFamilyProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceMemoryProperties2KHR(
    VkPhysicalDevice physicalDevice,
        VkPhysicalDeviceMemoryProperties2* pMemoryProperties,
        uint32_t doLock);
    void vkGetPhysicalDeviceSparseImageFormatProperties2KHR(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
        uint32_t* pPropertyCount,
        VkSparseImageFormatProperties2* pProperties,
        uint32_t doLock);
#endif
#ifdef VK_KHR_maintenance1
    void vkTrimCommandPoolKHR(
    VkDevice device,
        VkCommandPool commandPool,
        VkCommandPoolTrimFlags flags,
        uint32_t doLock);
#endif
#ifdef VK_KHR_external_memory_capabilities
    void vkGetPhysicalDeviceExternalBufferPropertiesKHR(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
        VkExternalBufferProperties* pExternalBufferProperties,
        uint32_t doLock);
#endif
#ifdef VK_KHR_external_semaphore_capabilities
    void vkGetPhysicalDeviceExternalSemaphorePropertiesKHR(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
        VkExternalSemaphoreProperties* pExternalSemaphoreProperties,
        uint32_t doLock);
#endif
#ifdef VK_KHR_external_semaphore_fd
    VkResult vkImportSemaphoreFdKHR(
    VkDevice device,
        const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo,
        uint32_t doLock);
    VkResult vkGetSemaphoreFdKHR(
    VkDevice device,
        const VkSemaphoreGetFdInfoKHR* pGetFdInfo,
        int* pFd,
        uint32_t doLock);
#endif
#ifdef VK_KHR_descriptor_update_template
    VkResult vkCreateDescriptorUpdateTemplateKHR(
    VkDevice device,
        const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate,
        uint32_t doLock);
    void vkDestroyDescriptorUpdateTemplateKHR(
    VkDevice device,
        VkDescriptorUpdateTemplate descriptorUpdateTemplate,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    void vkUpdateDescriptorSetWithTemplateKHR(
    VkDevice device,
        VkDescriptorSet descriptorSet,
        VkDescriptorUpdateTemplate descriptorUpdateTemplate,
        const void* pData,
        uint32_t doLock);
#endif
#ifdef VK_KHR_create_renderpass2
    VkResult vkCreateRenderPass2KHR(
    VkDevice device,
        const VkRenderPassCreateInfo2* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkRenderPass* pRenderPass,
        uint32_t doLock);
    void vkCmdBeginRenderPass2KHR(
    VkCommandBuffer commandBuffer,
        const VkRenderPassBeginInfo* pRenderPassBegin,
        const VkSubpassBeginInfo* pSubpassBeginInfo,
        uint32_t doLock);
    void vkCmdNextSubpass2KHR(
    VkCommandBuffer commandBuffer,
        const VkSubpassBeginInfo* pSubpassBeginInfo,
        const VkSubpassEndInfo* pSubpassEndInfo,
        uint32_t doLock);
    void vkCmdEndRenderPass2KHR(
    VkCommandBuffer commandBuffer,
        const VkSubpassEndInfo* pSubpassEndInfo,
        uint32_t doLock);
#endif
#ifdef VK_KHR_external_fence_capabilities
    void vkGetPhysicalDeviceExternalFencePropertiesKHR(
    VkPhysicalDevice physicalDevice,
        const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
        VkExternalFenceProperties* pExternalFenceProperties,
        uint32_t doLock);
#endif
#ifdef VK_KHR_external_fence_fd
    VkResult vkImportFenceFdKHR(
    VkDevice device,
        const VkImportFenceFdInfoKHR* pImportFenceFdInfo,
        uint32_t doLock);
    VkResult vkGetFenceFdKHR(
    VkDevice device,
        const VkFenceGetFdInfoKHR* pGetFdInfo,
        int* pFd,
        uint32_t doLock);
#endif
#ifdef VK_KHR_get_memory_requirements2
    void vkGetImageMemoryRequirements2KHR(
    VkDevice device,
        const VkImageMemoryRequirementsInfo2* pInfo,
        VkMemoryRequirements2* pMemoryRequirements,
        uint32_t doLock);
    void vkGetBufferMemoryRequirements2KHR(
    VkDevice device,
        const VkBufferMemoryRequirementsInfo2* pInfo,
        VkMemoryRequirements2* pMemoryRequirements,
        uint32_t doLock);
    void vkGetImageSparseMemoryRequirements2KHR(
    VkDevice device,
        const VkImageSparseMemoryRequirementsInfo2* pInfo,
        uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements2* pSparseMemoryRequirements,
        uint32_t doLock);
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
    VkResult vkCreateSamplerYcbcrConversionKHR(
    VkDevice device,
        const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkSamplerYcbcrConversion* pYcbcrConversion,
        uint32_t doLock);
    void vkDestroySamplerYcbcrConversionKHR(
    VkDevice device,
        VkSamplerYcbcrConversion ycbcrConversion,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
#endif
#ifdef VK_KHR_bind_memory2
    VkResult vkBindBufferMemory2KHR(
    VkDevice device,
        uint32_t bindInfoCount,
        const VkBindBufferMemoryInfo* pBindInfos,
        uint32_t doLock);
    VkResult vkBindImageMemory2KHR(
    VkDevice device,
        uint32_t bindInfoCount,
        const VkBindImageMemoryInfo* pBindInfos,
        uint32_t doLock);
#endif
#ifdef VK_KHR_maintenance3
    void vkGetDescriptorSetLayoutSupportKHR(
    VkDevice device,
        const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
        VkDescriptorSetLayoutSupport* pSupport,
        uint32_t doLock);
#endif
#ifdef VK_KHR_buffer_device_address
    VkDeviceAddress vkGetBufferDeviceAddressKHR(
    VkDevice device,
        const VkBufferDeviceAddressInfo* pInfo,
        uint32_t doLock);
    uint64_t vkGetBufferOpaqueCaptureAddressKHR(
    VkDevice device,
        const VkBufferDeviceAddressInfo* pInfo,
        uint32_t doLock);
    uint64_t vkGetDeviceMemoryOpaqueCaptureAddressKHR(
    VkDevice device,
        const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo,
        uint32_t doLock);
#endif
#ifdef VK_KHR_pipeline_executable_properties
    VkResult vkGetPipelineExecutablePropertiesKHR(
    VkDevice device,
        const VkPipelineInfoKHR* pPipelineInfo,
        uint32_t* pExecutableCount,
        VkPipelineExecutablePropertiesKHR* pProperties,
        uint32_t doLock);
    VkResult vkGetPipelineExecutableStatisticsKHR(
    VkDevice device,
        const VkPipelineExecutableInfoKHR* pExecutableInfo,
        uint32_t* pStatisticCount,
        VkPipelineExecutableStatisticKHR* pStatistics,
        uint32_t doLock);
    VkResult vkGetPipelineExecutableInternalRepresentationsKHR(
    VkDevice device,
        const VkPipelineExecutableInfoKHR* pExecutableInfo,
        uint32_t* pInternalRepresentationCount,
        VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations,
        uint32_t doLock);
#endif
#ifdef VK_KHR_synchronization2
    void vkCmdSetEvent2KHR(
    VkCommandBuffer commandBuffer,
        VkEvent event,
        const VkDependencyInfo* pDependencyInfo,
        uint32_t doLock);
    void vkCmdResetEvent2KHR(
    VkCommandBuffer commandBuffer,
        VkEvent event,
        VkPipelineStageFlags2 stageMask,
        uint32_t doLock);
    void vkCmdWaitEvents2KHR(
    VkCommandBuffer commandBuffer,
        uint32_t eventCount,
        const VkEvent* pEvents,
        const VkDependencyInfo* pDependencyInfos,
        uint32_t doLock);
    void vkCmdPipelineBarrier2KHR(
    VkCommandBuffer commandBuffer,
        const VkDependencyInfo* pDependencyInfo,
        uint32_t doLock);
    void vkCmdWriteTimestamp2KHR(
    VkCommandBuffer commandBuffer,
        VkPipelineStageFlags2 stage,
        VkQueryPool queryPool,
        uint32_t query,
        uint32_t doLock);
    VkResult vkQueueSubmit2KHR(
    VkQueue queue,
        uint32_t submitCount,
        const VkSubmitInfo2* pSubmits,
        VkFence fence,
        uint32_t doLock);
#endif
#ifdef VK_KHR_copy_commands2
    void vkCmdCopyBuffer2KHR(
    VkCommandBuffer commandBuffer,
        const VkCopyBufferInfo2* pCopyBufferInfo,
        uint32_t doLock);
    void vkCmdCopyImage2KHR(
    VkCommandBuffer commandBuffer,
        const VkCopyImageInfo2* pCopyImageInfo,
        uint32_t doLock);
    void vkCmdCopyBufferToImage2KHR(
    VkCommandBuffer commandBuffer,
        const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo,
        uint32_t doLock);
    void vkCmdCopyImageToBuffer2KHR(
    VkCommandBuffer commandBuffer,
        const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo,
        uint32_t doLock);
    void vkCmdBlitImage2KHR(
    VkCommandBuffer commandBuffer,
        const VkBlitImageInfo2* pBlitImageInfo,
        uint32_t doLock);
    void vkCmdResolveImage2KHR(
    VkCommandBuffer commandBuffer,
        const VkResolveImageInfo2* pResolveImageInfo,
        uint32_t doLock);
#endif
#ifdef VK_KHR_maintenance4
    void vkGetDeviceBufferMemoryRequirementsKHR(
    VkDevice device,
        const VkDeviceBufferMemoryRequirements* pInfo,
        VkMemoryRequirements2* pMemoryRequirements,
        uint32_t doLock);
    void vkGetDeviceImageMemoryRequirementsKHR(
    VkDevice device,
        const VkDeviceImageMemoryRequirements* pInfo,
        VkMemoryRequirements2* pMemoryRequirements,
        uint32_t doLock);
    void vkGetDeviceImageSparseMemoryRequirementsKHR(
    VkDevice device,
        const VkDeviceImageMemoryRequirements* pInfo,
        uint32_t* pSparseMemoryRequirementCount,
        VkSparseImageMemoryRequirements2* pSparseMemoryRequirements,
        uint32_t doLock);
#endif
#ifdef VK_KHR_maintenance5
    void vkCmdBindIndexBuffer2KHR(
    VkCommandBuffer commandBuffer,
        VkBuffer buffer,
        VkDeviceSize offset,
        VkDeviceSize size,
        VkIndexType indexType,
        uint32_t doLock);
    void vkGetRenderingAreaGranularityKHR(
    VkDevice device,
        const VkRenderingAreaInfo* pRenderingAreaInfo,
        VkExtent2D* pGranularity,
        uint32_t doLock);
    void vkGetDeviceImageSubresourceLayoutKHR(
    VkDevice device,
        const VkDeviceImageSubresourceInfo* pInfo,
        VkSubresourceLayout2* pLayout,
        uint32_t doLock);
    void vkGetImageSubresourceLayout2KHR(
    VkDevice device,
        VkImage image,
        const VkImageSubresource2* pSubresource,
        VkSubresourceLayout2* pLayout,
        uint32_t doLock);
#endif
#ifdef VK_KHR_line_rasterization
    void vkCmdSetLineStippleKHR(
    VkCommandBuffer commandBuffer,
        uint32_t lineStippleFactor,
        uint16_t lineStipplePattern,
        uint32_t doLock);
#endif
#ifdef VK_ANDROID_native_buffer
    VkResult vkGetSwapchainGrallocUsageANDROID(
    VkDevice device,
        VkFormat format,
        VkImageUsageFlags imageUsage,
        int* grallocUsage,
        uint32_t doLock);
    VkResult vkAcquireImageANDROID(
    VkDevice device,
        VkImage image,
        int nativeFenceFd,
        VkSemaphore semaphore,
        VkFence fence,
        uint32_t doLock);
    VkResult vkQueueSignalReleaseImageANDROID(
    VkQueue queue,
        uint32_t waitSemaphoreCount,
        const VkSemaphore* pWaitSemaphores,
        VkImage image,
        int* pNativeFenceFd,
        uint32_t doLock);
    VkResult vkGetSwapchainGrallocUsage2ANDROID(
    VkDevice device,
        VkFormat format,
        VkImageUsageFlags imageUsage,
        VkSwapchainImageUsageFlagsANDROID swapchainImageUsage,
        uint64_t* grallocConsumerUsage,
        uint64_t* grallocProducerUsage,
        uint32_t doLock);
#endif
#ifdef VK_EXT_transform_feedback
    void vkCmdBindTransformFeedbackBuffersEXT(
    VkCommandBuffer commandBuffer,
        uint32_t firstBinding,
        uint32_t bindingCount,
        const VkBuffer* pBuffers,
        const VkDeviceSize* pOffsets,
        const VkDeviceSize* pSizes,
        uint32_t doLock);
    void vkCmdBeginTransformFeedbackEXT(
    VkCommandBuffer commandBuffer,
        uint32_t firstCounterBuffer,
        uint32_t counterBufferCount,
        const VkBuffer* pCounterBuffers,
        const VkDeviceSize* pCounterBufferOffsets,
        uint32_t doLock);
    void vkCmdEndTransformFeedbackEXT(
    VkCommandBuffer commandBuffer,
        uint32_t firstCounterBuffer,
        uint32_t counterBufferCount,
        const VkBuffer* pCounterBuffers,
        const VkDeviceSize* pCounterBufferOffsets,
        uint32_t doLock);
    void vkCmdBeginQueryIndexedEXT(
    VkCommandBuffer commandBuffer,
        VkQueryPool queryPool,
        uint32_t query,
        VkQueryControlFlags flags,
        uint32_t index,
        uint32_t doLock);
    void vkCmdEndQueryIndexedEXT(
    VkCommandBuffer commandBuffer,
        VkQueryPool queryPool,
        uint32_t query,
        uint32_t index,
        uint32_t doLock);
    void vkCmdDrawIndirectByteCountEXT(
    VkCommandBuffer commandBuffer,
        uint32_t instanceCount,
        uint32_t firstInstance,
        VkBuffer counterBuffer,
        VkDeviceSize counterBufferOffset,
        uint32_t counterOffset,
        uint32_t vertexStride,
        uint32_t doLock);
#endif
#ifdef VK_EXT_image_drm_format_modifier
    VkResult vkGetImageDrmFormatModifierPropertiesEXT(
    VkDevice device,
        VkImage image,
        VkImageDrmFormatModifierPropertiesEXT* pProperties,
        uint32_t doLock);
#endif
#ifdef VK_EXT_tooling_info
    VkResult vkGetPhysicalDeviceToolPropertiesEXT(
    VkPhysicalDevice physicalDevice,
        uint32_t* pToolCount,
        VkPhysicalDeviceToolProperties* pToolProperties,
        uint32_t doLock);
#endif
#ifdef VK_EXT_line_rasterization
    void vkCmdSetLineStippleEXT(
    VkCommandBuffer commandBuffer,
        uint32_t lineStippleFactor,
        uint16_t lineStipplePattern,
        uint32_t doLock);
#endif
#ifdef VK_EXT_extended_dynamic_state
    void vkCmdSetCullModeEXT(
    VkCommandBuffer commandBuffer,
        VkCullModeFlags cullMode,
        uint32_t doLock);
    void vkCmdSetFrontFaceEXT(
    VkCommandBuffer commandBuffer,
        VkFrontFace frontFace,
        uint32_t doLock);
    void vkCmdSetPrimitiveTopologyEXT(
    VkCommandBuffer commandBuffer,
        VkPrimitiveTopology primitiveTopology,
        uint32_t doLock);
    void vkCmdSetViewportWithCountEXT(
    VkCommandBuffer commandBuffer,
        uint32_t viewportCount,
        const VkViewport* pViewports,
        uint32_t doLock);
    void vkCmdSetScissorWithCountEXT(
    VkCommandBuffer commandBuffer,
        uint32_t scissorCount,
        const VkRect2D* pScissors,
        uint32_t doLock);
    void vkCmdBindVertexBuffers2EXT(
    VkCommandBuffer commandBuffer,
        uint32_t firstBinding,
        uint32_t bindingCount,
        const VkBuffer* pBuffers,
        const VkDeviceSize* pOffsets,
        const VkDeviceSize* pSizes,
        const VkDeviceSize* pStrides,
        uint32_t doLock);
    void vkCmdSetDepthTestEnableEXT(
    VkCommandBuffer commandBuffer,
        VkBool32 depthTestEnable,
        uint32_t doLock);
    void vkCmdSetDepthWriteEnableEXT(
    VkCommandBuffer commandBuffer,
        VkBool32 depthWriteEnable,
        uint32_t doLock);
    void vkCmdSetDepthCompareOpEXT(
    VkCommandBuffer commandBuffer,
        VkCompareOp depthCompareOp,
        uint32_t doLock);
    void vkCmdSetDepthBoundsTestEnableEXT(
    VkCommandBuffer commandBuffer,
        VkBool32 depthBoundsTestEnable,
        uint32_t doLock);
    void vkCmdSetStencilTestEnableEXT(
    VkCommandBuffer commandBuffer,
        VkBool32 stencilTestEnable,
        uint32_t doLock);
    void vkCmdSetStencilOpEXT(
    VkCommandBuffer commandBuffer,
        VkStencilFaceFlags faceMask,
        VkStencilOp failOp,
        VkStencilOp passOp,
        VkStencilOp depthFailOp,
        VkCompareOp compareOp,
        uint32_t doLock);
#endif
#ifdef VK_EXT_host_image_copy
    VkResult vkCopyMemoryToImageEXT(
    VkDevice device,
        const VkCopyMemoryToImageInfo* pCopyMemoryToImageInfo,
        uint32_t doLock);
    VkResult vkCopyImageToMemoryEXT(
    VkDevice device,
        const VkCopyImageToMemoryInfo* pCopyImageToMemoryInfo,
        uint32_t doLock);
    VkResult vkCopyImageToImageEXT(
    VkDevice device,
        const VkCopyImageToImageInfo* pCopyImageToImageInfo,
        uint32_t doLock);
    VkResult vkTransitionImageLayoutEXT(
    VkDevice device,
        uint32_t transitionCount,
        const VkHostImageLayoutTransitionInfo* pTransitions,
        uint32_t doLock);
    void vkGetImageSubresourceLayout2EXT(
    VkDevice device,
        VkImage image,
        const VkImageSubresource2* pSubresource,
        VkSubresourceLayout2* pLayout,
        uint32_t doLock);
#endif
#ifdef VK_EXT_private_data
    VkResult vkCreatePrivateDataSlotEXT(
    VkDevice device,
        const VkPrivateDataSlotCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkPrivateDataSlot* pPrivateDataSlot,
        uint32_t doLock);
    void vkDestroyPrivateDataSlotEXT(
    VkDevice device,
        VkPrivateDataSlot privateDataSlot,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    VkResult vkSetPrivateDataEXT(
    VkDevice device,
        VkObjectType objectType,
        uint64_t objectHandle,
        VkPrivateDataSlot privateDataSlot,
        uint64_t data,
        uint32_t doLock);
    void vkGetPrivateDataEXT(
    VkDevice device,
        VkObjectType objectType,
        uint64_t objectHandle,
        VkPrivateDataSlot privateDataSlot,
        uint64_t* pData,
        uint32_t doLock);
#endif
#ifdef VK_EXT_extended_dynamic_state2
    void vkCmdSetPatchControlPointsEXT(
    VkCommandBuffer commandBuffer,
        uint32_t patchControlPoints,
        uint32_t doLock);
    void vkCmdSetRasterizerDiscardEnableEXT(
    VkCommandBuffer commandBuffer,
        VkBool32 rasterizerDiscardEnable,
        uint32_t doLock);
    void vkCmdSetDepthBiasEnableEXT(
    VkCommandBuffer commandBuffer,
        VkBool32 depthBiasEnable,
        uint32_t doLock);
    void vkCmdSetLogicOpEXT(
    VkCommandBuffer commandBuffer,
        VkLogicOp logicOp,
        uint32_t doLock);
    void vkCmdSetPrimitiveRestartEnableEXT(
    VkCommandBuffer commandBuffer,
        VkBool32 primitiveRestartEnable,
        uint32_t doLock);
#endif
#ifdef VK_EXT_color_write_enable
    void vkCmdSetColorWriteEnableEXT(
    VkCommandBuffer commandBuffer,
        uint32_t attachmentCount,
        const VkBool32* pColorWriteEnables,
        uint32_t doLock);
#endif
#ifdef VK_GOOGLE_gfxstream
    VkResult vkMapMemoryIntoAddressSpaceGOOGLE(
    VkDevice device,
        VkDeviceMemory memory,
        uint64_t* pAddress,
        uint32_t doLock);
    void vkUpdateDescriptorSetWithTemplateSizedGOOGLE(
    VkDevice device,
        VkDescriptorSet descriptorSet,
        VkDescriptorUpdateTemplate descriptorUpdateTemplate,
        uint32_t imageInfoCount,
        uint32_t bufferInfoCount,
        uint32_t bufferViewCount,
        const uint32_t* pImageInfoEntryIndices,
        const uint32_t* pBufferInfoEntryIndices,
        const uint32_t* pBufferViewEntryIndices,
        const VkDescriptorImageInfo* pImageInfos,
        const VkDescriptorBufferInfo* pBufferInfos,
        const VkBufferView* pBufferViews,
        uint32_t doLock);
    void vkBeginCommandBufferAsyncGOOGLE(
    VkCommandBuffer commandBuffer,
        const VkCommandBufferBeginInfo* pBeginInfo,
        uint32_t doLock);
    void vkEndCommandBufferAsyncGOOGLE(
    VkCommandBuffer commandBuffer,
        uint32_t doLock);
    void vkResetCommandBufferAsyncGOOGLE(
    VkCommandBuffer commandBuffer,
        VkCommandBufferResetFlags flags,
        uint32_t doLock);
    void vkCommandBufferHostSyncGOOGLE(
    VkCommandBuffer commandBuffer,
        uint32_t needHostSync,
        uint32_t sequenceNumber,
        uint32_t doLock);
    VkResult vkCreateImageWithRequirementsGOOGLE(
    VkDevice device,
        const VkImageCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkImage* pImage,
        VkMemoryRequirements* pMemoryRequirements,
        uint32_t doLock);
    VkResult vkCreateBufferWithRequirementsGOOGLE(
    VkDevice device,
        const VkBufferCreateInfo* pCreateInfo,
        const VkAllocationCallbacks* pAllocator,
        VkBuffer* pBuffer,
        VkMemoryRequirements* pMemoryRequirements,
        uint32_t doLock);
    VkResult vkGetMemoryHostAddressInfoGOOGLE(
    VkDevice device,
        VkDeviceMemory memory,
        uint64_t* pAddress,
        uint64_t* pSize,
        uint64_t* pHostmemId,
        uint32_t doLock);
    VkResult vkFreeMemorySyncGOOGLE(
    VkDevice device,
        VkDeviceMemory memory,
        const VkAllocationCallbacks* pAllocator,
        uint32_t doLock);
    void vkQueueHostSyncGOOGLE(
    VkQueue queue,
        uint32_t needHostSync,
        uint32_t sequenceNumber,
        uint32_t doLock);
    void vkQueueSubmitAsyncGOOGLE(
    VkQueue queue,
        uint32_t submitCount,
        const VkSubmitInfo* pSubmits,
        VkFence fence,
        uint32_t doLock);
    void vkQueueWaitIdleAsyncGOOGLE(
    VkQueue queue,
        uint32_t doLock);
    void vkQueueBindSparseAsyncGOOGLE(
    VkQueue queue,
        uint32_t bindInfoCount,
        const VkBindSparseInfo* pBindInfo,
        VkFence fence,
        uint32_t doLock);
    void vkGetLinearImageLayoutGOOGLE(
    VkDevice device,
        VkFormat format,
        VkDeviceSize* pOffset,
        VkDeviceSize* pRowPitchAlignment,
        uint32_t doLock);
    void vkGetLinearImageLayout2GOOGLE(
    VkDevice device,
        const VkImageCreateInfo* pCreateInfo,
        VkDeviceSize* pOffset,
        VkDeviceSize* pRowPitchAlignment,
        uint32_t doLock);
    void vkQueueFlushCommandsGOOGLE(
    VkQueue queue,
        VkCommandBuffer commandBuffer,
        VkDeviceSize dataSize,
        const void* pData,
        uint32_t doLock);
    void vkQueueCommitDescriptorSetUpdatesGOOGLE(
    VkQueue queue,
        uint32_t descriptorPoolCount,
        const VkDescriptorPool* pDescriptorPools,
        uint32_t descriptorSetCount,
        const VkDescriptorSetLayout* pSetLayouts,
        const uint64_t* pDescriptorSetPoolIds,
        const uint32_t* pDescriptorSetWhichPool,
        const uint32_t* pDescriptorSetPendingAllocation,
        const uint32_t* pDescriptorWriteStartingIndices,
        uint32_t pendingDescriptorWriteCount,
        const VkWriteDescriptorSet* pPendingDescriptorWrites,
        uint32_t doLock);
    void vkCollectDescriptorPoolIdsGOOGLE(
    VkDevice device,
        VkDescriptorPool descriptorPool,
        uint32_t* pPoolIdCount,
        uint64_t* pPoolIds,
        uint32_t doLock);
    void vkQueueSignalReleaseImageANDROIDAsyncGOOGLE(
    VkQueue queue,
        uint32_t waitSemaphoreCount,
        const VkSemaphore* pWaitSemaphores,
        VkImage image,
        uint32_t doLock);
    void vkQueueFlushCommandsFromAuxMemoryGOOGLE(
    VkQueue queue,
        VkCommandBuffer commandBuffer,
        VkDeviceMemory deviceMemory,
        VkDeviceSize dataOffset,
        VkDeviceSize dataSize,
        uint32_t doLock);
    VkResult vkGetBlobGOOGLE(
    VkDevice device,
        VkDeviceMemory memory,
        uint32_t doLock);
    void vkUpdateDescriptorSetWithTemplateSized2GOOGLE(
    VkDevice device,
        VkDescriptorSet descriptorSet,
        VkDescriptorUpdateTemplate descriptorUpdateTemplate,
        uint32_t imageInfoCount,
        uint32_t bufferInfoCount,
        uint32_t bufferViewCount,
        uint32_t inlineUniformBlockCount,
        const uint32_t* pImageInfoEntryIndices,
        const uint32_t* pBufferInfoEntryIndices,
        const uint32_t* pBufferViewEntryIndices,
        const VkDescriptorImageInfo* pImageInfos,
        const VkDescriptorBufferInfo* pBufferInfos,
        const VkBufferView* pBufferViews,
        const uint8_t* pInlineUniformBlockData,
        uint32_t doLock);
    void vkQueueSubmitAsync2GOOGLE(
    VkQueue queue,
        uint32_t submitCount,
        const VkSubmitInfo2* pSubmits,
        VkFence fence,
        uint32_t doLock);
    VkResult vkGetSemaphoreGOOGLE(
    VkDevice device,
        VkSemaphore semaphore,
        uint64_t syncId,
        uint32_t doLock);
    void vkTraceAsyncGOOGLE(
    uint64_t id,
        uint32_t doLock);
#endif
private:
    class Impl;
    std::unique_ptr<Impl> mImpl;
};

}  // namespace vk
}  // namespace gfxstream
