// This file is generated by Forward_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef v8_inspector_protocol_Forward_h
#define v8_inspector_protocol_Forward_h


#include <memory>
#include <vector>

#include "../../deps/v8/third_party/inspector_protocol/crdtp/error_support.h"
#include "../../deps/v8/third_party/inspector_protocol/crdtp/dispatch.h"
#include "../../deps/v8/third_party/inspector_protocol/crdtp/frontend_channel.h"
#include "../../deps/v8/third_party/inspector_protocol/crdtp/protocol_core.h"

#include "src/inspector/string-util.h"

namespace v8_inspector {
namespace protocol {

using DispatchResponse = v8_crdtp::DispatchResponse;
using ErrorSupport = v8_crdtp::ErrorSupport;
using Serializable = v8_crdtp::Serializable;
using FrontendChannel = v8_crdtp::FrontendChannel;
using DomainDispatcher = v8_crdtp::DomainDispatcher;
using UberDispatcher = v8_crdtp::UberDispatcher;
using Response = DispatchResponse;

class DictionaryValue;
class FundamentalValue;
class ListValue;
class Object;
class SerializedValue;
class StringValue;
class Value;

namespace detail {

template <typename T>
struct ArrayTypedef { typedef std::vector<std::unique_ptr<T>> type; };

template <>
struct ArrayTypedef<String> { typedef std::vector<String> type; };

template <>
struct ArrayTypedef<int> { typedef std::vector<int> type; };

template <>
struct ArrayTypedef<double> { typedef std::vector<double> type; };

template <>
struct ArrayTypedef<bool> { typedef std::vector<bool> type; };

template <>
struct ArrayTypedef<Binary> { typedef std::vector<Binary> type; };

}  // namespace detail

template <typename T>
using Array = typename detail::ArrayTypedef<T>::type;

} // namespace v8_inspector
} // namespace protocol

#endif // !defined(v8_inspector_protocol_Forward_h)
