//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// TenantAccessGitServer is a fake server for instances of the armapimanagement.TenantAccessGitClient type.
type TenantAccessGitServer struct {
	// RegeneratePrimaryKey is the fake for method TenantAccessGitClient.RegeneratePrimaryKey
	// HTTP status codes to indicate success: http.StatusNoContent
	RegeneratePrimaryKey func(ctx context.Context, resourceGroupName string, serviceName string, accessName armapimanagement.AccessIDName, options *armapimanagement.TenantAccessGitClientRegeneratePrimaryKeyOptions) (resp azfake.Responder[armapimanagement.TenantAccessGitClientRegeneratePrimaryKeyResponse], errResp azfake.ErrorResponder)

	// RegenerateSecondaryKey is the fake for method TenantAccessGitClient.RegenerateSecondaryKey
	// HTTP status codes to indicate success: http.StatusNoContent
	RegenerateSecondaryKey func(ctx context.Context, resourceGroupName string, serviceName string, accessName armapimanagement.AccessIDName, options *armapimanagement.TenantAccessGitClientRegenerateSecondaryKeyOptions) (resp azfake.Responder[armapimanagement.TenantAccessGitClientRegenerateSecondaryKeyResponse], errResp azfake.ErrorResponder)
}

// NewTenantAccessGitServerTransport creates a new instance of TenantAccessGitServerTransport with the provided implementation.
// The returned TenantAccessGitServerTransport instance is connected to an instance of armapimanagement.TenantAccessGitClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTenantAccessGitServerTransport(srv *TenantAccessGitServer) *TenantAccessGitServerTransport {
	return &TenantAccessGitServerTransport{srv: srv}
}

// TenantAccessGitServerTransport connects instances of armapimanagement.TenantAccessGitClient to instances of TenantAccessGitServer.
// Don't use this type directly, use NewTenantAccessGitServerTransport instead.
type TenantAccessGitServerTransport struct {
	srv *TenantAccessGitServer
}

// Do implements the policy.Transporter interface for TenantAccessGitServerTransport.
func (t *TenantAccessGitServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TenantAccessGitClient.RegeneratePrimaryKey":
		resp, err = t.dispatchRegeneratePrimaryKey(req)
	case "TenantAccessGitClient.RegenerateSecondaryKey":
		resp, err = t.dispatchRegenerateSecondaryKey(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TenantAccessGitServerTransport) dispatchRegeneratePrimaryKey(req *http.Request) (*http.Response, error) {
	if t.srv.RegeneratePrimaryKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegeneratePrimaryKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tenant/(?P<accessName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/git/regeneratePrimaryKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	accessNameParam, err := parseWithCast(matches[regex.SubexpIndex("accessName")], func(v string) (armapimanagement.AccessIDName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armapimanagement.AccessIDName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.RegeneratePrimaryKey(req.Context(), resourceGroupNameParam, serviceNameParam, accessNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TenantAccessGitServerTransport) dispatchRegenerateSecondaryKey(req *http.Request) (*http.Response, error) {
	if t.srv.RegenerateSecondaryKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegenerateSecondaryKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tenant/(?P<accessName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/git/regenerateSecondaryKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	accessNameParam, err := parseWithCast(matches[regex.SubexpIndex("accessName")], func(v string) (armapimanagement.AccessIDName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armapimanagement.AccessIDName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.RegenerateSecondaryKey(req.Context(), resourceGroupNameParam, serviceNameParam, accessNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
