//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid/v2"
	"net/http"
	"net/url"
	"regexp"
)

// TopicTypesServer is a fake server for instances of the armeventgrid.TopicTypesClient type.
type TopicTypesServer struct {
	// Get is the fake for method TopicTypesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, topicTypeName string, options *armeventgrid.TopicTypesClientGetOptions) (resp azfake.Responder[armeventgrid.TopicTypesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method TopicTypesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armeventgrid.TopicTypesClientListOptions) (resp azfake.PagerResponder[armeventgrid.TopicTypesClientListResponse])

	// NewListEventTypesPager is the fake for method TopicTypesClient.NewListEventTypesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListEventTypesPager func(topicTypeName string, options *armeventgrid.TopicTypesClientListEventTypesOptions) (resp azfake.PagerResponder[armeventgrid.TopicTypesClientListEventTypesResponse])
}

// NewTopicTypesServerTransport creates a new instance of TopicTypesServerTransport with the provided implementation.
// The returned TopicTypesServerTransport instance is connected to an instance of armeventgrid.TopicTypesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTopicTypesServerTransport(srv *TopicTypesServer) *TopicTypesServerTransport {
	return &TopicTypesServerTransport{
		srv:                    srv,
		newListPager:           newTracker[azfake.PagerResponder[armeventgrid.TopicTypesClientListResponse]](),
		newListEventTypesPager: newTracker[azfake.PagerResponder[armeventgrid.TopicTypesClientListEventTypesResponse]](),
	}
}

// TopicTypesServerTransport connects instances of armeventgrid.TopicTypesClient to instances of TopicTypesServer.
// Don't use this type directly, use NewTopicTypesServerTransport instead.
type TopicTypesServerTransport struct {
	srv                    *TopicTypesServer
	newListPager           *tracker[azfake.PagerResponder[armeventgrid.TopicTypesClientListResponse]]
	newListEventTypesPager *tracker[azfake.PagerResponder[armeventgrid.TopicTypesClientListEventTypesResponse]]
}

// Do implements the policy.Transporter interface for TopicTypesServerTransport.
func (t *TopicTypesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TopicTypesClient.Get":
		resp, err = t.dispatchGet(req)
	case "TopicTypesClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	case "TopicTypesClient.NewListEventTypesPager":
		resp, err = t.dispatchNewListEventTypesPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TopicTypesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.EventGrid/topicTypes/(?P<topicTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	topicTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("topicTypeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), topicTypeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TopicTypeInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TopicTypesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		resp := t.srv.NewListPager(nil)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}

func (t *TopicTypesServerTransport) dispatchNewListEventTypesPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListEventTypesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListEventTypesPager not implemented")}
	}
	newListEventTypesPager := t.newListEventTypesPager.get(req)
	if newListEventTypesPager == nil {
		const regexStr = `/providers/Microsoft\.EventGrid/topicTypes/(?P<topicTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventTypes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		topicTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("topicTypeName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListEventTypesPager(topicTypeNameParam, nil)
		newListEventTypesPager = &resp
		t.newListEventTypesPager.add(req, newListEventTypesPager)
	}
	resp, err := server.PagerResponderNext(newListEventTypesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListEventTypesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListEventTypesPager) {
		t.newListEventTypesPager.remove(req)
	}
	return resp, nil
}
