//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagementpartner

import "time"

// Error - this is the management partner operations error
type Error struct {
	// this is the error response code
	Code *string

	// this is the ExtendedErrorInfo property
	Error *ExtendedErrorInfo

	// this is the extended error info message
	Message *string
}

// ExtendedErrorInfo - this is the extended error info
type ExtendedErrorInfo struct {
	// this is the error response code
	Code *string

	// this is the extended error info message
	Message *string
}

// OperationDisplay - this is the management partner operation
type OperationDisplay struct {
	// the is management partner operation description
	Description *string

	// the is management partner operation
	Operation *string

	// the is management partner provider
	Provider *string

	// the is management partner resource
	Resource *string
}

// OperationList - this is the management partner operations list
type OperationList struct {
	// Url to get the next page of items.
	NextLink *string

	// this is the operation response list
	Value []*OperationResponse
}

// OperationResponse - this is the management partner operations response
type OperationResponse struct {
	// this is the operation display
	Display *OperationDisplay

	// this is the operation response name
	Name *string

	// the is operation response origin information
	Origin *string
}

// PartnerProperties - this is the management partner properties
type PartnerProperties struct {
	// This is the DateTime when the partner was created.
	CreatedTime *time.Time

	// This is the object id.
	ObjectID *string

	// This is the partner id
	PartnerID *string

	// This is the partner name
	PartnerName *string

	// This is the partner state
	State *ManagementPartnerState

	// This is the tenant id.
	TenantID *string

	// This is the DateTime when the partner was updated.
	UpdatedTime *time.Time

	// This is the version.
	Version *int32
}

// PartnerResponse - this is the management partner operations response
type PartnerResponse struct {
	// Type of the partner
	Etag *int32

	// Properties of the partner
	Properties *PartnerProperties

	// READ-ONLY; Identifier of the partner
	ID *string

	// READ-ONLY; Name of the partner
	Name *string

	// READ-ONLY; Type of resource. "Microsoft.ManagementPartner/partners"
	Type *string
}
