//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
)

// ManagersClient contains the methods for the Managers group.
// Don't use this type directly, use NewManagersClient() instead.
type ManagersClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewManagersClient creates a new instance of ManagersClient with the specified values.
//   - subscriptionID - The subscription id
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewManagersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagersClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ManagersClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateExtendedInfo - Creates the extended info of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - The manager extended information.
//   - options - ManagersClientCreateExtendedInfoOptions contains the optional parameters for the ManagersClient.CreateExtendedInfo
//     method.
func (client *ManagersClient) CreateExtendedInfo(ctx context.Context, resourceGroupName string, managerName string, parameters ManagerExtendedInfo, options *ManagersClientCreateExtendedInfoOptions) (ManagersClientCreateExtendedInfoResponse, error) {
	var err error
	const operationName = "ManagersClient.CreateExtendedInfo"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createExtendedInfoCreateRequest(ctx, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return ManagersClientCreateExtendedInfoResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientCreateExtendedInfoResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientCreateExtendedInfoResponse{}, err
	}
	resp, err := client.createExtendedInfoHandleResponse(httpResp)
	return resp, err
}

// createExtendedInfoCreateRequest creates the CreateExtendedInfo request.
func (client *ManagersClient) createExtendedInfoCreateRequest(ctx context.Context, resourceGroupName string, managerName string, parameters ManagerExtendedInfo, options *ManagersClientCreateExtendedInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createExtendedInfoHandleResponse handles the CreateExtendedInfo response.
func (client *ManagersClient) createExtendedInfoHandleResponse(resp *http.Response) (ManagersClientCreateExtendedInfoResponse, error) {
	result := ManagersClientCreateExtendedInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerExtendedInfo); err != nil {
		return ManagersClientCreateExtendedInfoResponse{}, err
	}
	return result, nil
}

// CreateOrUpdate - Creates or updates the manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - The manager.
//   - options - ManagersClientCreateOrUpdateOptions contains the optional parameters for the ManagersClient.CreateOrUpdate method.
func (client *ManagersClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, managerName string, parameters Manager, options *ManagersClientCreateOrUpdateOptions) (ManagersClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "ManagersClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return ManagersClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ManagersClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, managerName string, parameters Manager, options *ManagersClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ManagersClient) createOrUpdateHandleResponse(resp *http.Response) (ManagersClientCreateOrUpdateResponse, error) {
	result := ManagersClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Manager); err != nil {
		return ManagersClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes the manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientDeleteOptions contains the optional parameters for the ManagersClient.Delete method.
func (client *ManagersClient) Delete(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientDeleteOptions) (ManagersClientDeleteResponse, error) {
	var err error
	const operationName = "ManagersClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientDeleteResponse{}, err
	}
	return ManagersClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ManagersClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// DeleteExtendedInfo - Deletes the extended info of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientDeleteExtendedInfoOptions contains the optional parameters for the ManagersClient.DeleteExtendedInfo
//     method.
func (client *ManagersClient) DeleteExtendedInfo(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientDeleteExtendedInfoOptions) (ManagersClientDeleteExtendedInfoResponse, error) {
	var err error
	const operationName = "ManagersClient.DeleteExtendedInfo"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteExtendedInfoCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientDeleteExtendedInfoResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientDeleteExtendedInfoResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientDeleteExtendedInfoResponse{}, err
	}
	return ManagersClientDeleteExtendedInfoResponse{}, nil
}

// deleteExtendedInfoCreateRequest creates the DeleteExtendedInfo request.
func (client *ManagersClient) deleteExtendedInfoCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientDeleteExtendedInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Returns the properties of the specified manager name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientGetOptions contains the optional parameters for the ManagersClient.Get method.
func (client *ManagersClient) Get(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetOptions) (ManagersClientGetResponse, error) {
	var err error
	const operationName = "ManagersClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ManagersClient) getCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ManagersClient) getHandleResponse(resp *http.Response) (ManagersClientGetResponse, error) {
	result := ManagersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Manager); err != nil {
		return ManagersClientGetResponse{}, err
	}
	return result, nil
}

// GetActivationKey - Returns the activation key of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientGetActivationKeyOptions contains the optional parameters for the ManagersClient.GetActivationKey
//     method.
func (client *ManagersClient) GetActivationKey(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetActivationKeyOptions) (ManagersClientGetActivationKeyResponse, error) {
	var err error
	const operationName = "ManagersClient.GetActivationKey"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getActivationKeyCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetActivationKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientGetActivationKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientGetActivationKeyResponse{}, err
	}
	resp, err := client.getActivationKeyHandleResponse(httpResp)
	return resp, err
}

// getActivationKeyCreateRequest creates the GetActivationKey request.
func (client *ManagersClient) getActivationKeyCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetActivationKeyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/listActivationKey"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getActivationKeyHandleResponse handles the GetActivationKey response.
func (client *ManagersClient) getActivationKeyHandleResponse(resp *http.Response) (ManagersClientGetActivationKeyResponse, error) {
	result := ManagersClientGetActivationKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Key); err != nil {
		return ManagersClientGetActivationKeyResponse{}, err
	}
	return result, nil
}

// GetDevicePublicEncryptionKey - Returns the public encryption key of the device.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - deviceName - The device name
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientGetDevicePublicEncryptionKeyOptions contains the optional parameters for the ManagersClient.GetDevicePublicEncryptionKey
//     method.
func (client *ManagersClient) GetDevicePublicEncryptionKey(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *ManagersClientGetDevicePublicEncryptionKeyOptions) (ManagersClientGetDevicePublicEncryptionKeyResponse, error) {
	var err error
	const operationName = "ManagersClient.GetDevicePublicEncryptionKey"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDevicePublicEncryptionKeyCreateRequest(ctx, deviceName, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetDevicePublicEncryptionKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientGetDevicePublicEncryptionKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientGetDevicePublicEncryptionKeyResponse{}, err
	}
	resp, err := client.getDevicePublicEncryptionKeyHandleResponse(httpResp)
	return resp, err
}

// getDevicePublicEncryptionKeyCreateRequest creates the GetDevicePublicEncryptionKey request.
func (client *ManagersClient) getDevicePublicEncryptionKeyCreateRequest(ctx context.Context, deviceName string, resourceGroupName string, managerName string, options *ManagersClientGetDevicePublicEncryptionKeyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/publicEncryptionKey"
	urlPath = strings.ReplaceAll(urlPath, "{deviceName}", deviceName)
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDevicePublicEncryptionKeyHandleResponse handles the GetDevicePublicEncryptionKey response.
func (client *ManagersClient) getDevicePublicEncryptionKeyHandleResponse(resp *http.Response) (ManagersClientGetDevicePublicEncryptionKeyResponse, error) {
	result := ManagersClientGetDevicePublicEncryptionKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PublicKey); err != nil {
		return ManagersClientGetDevicePublicEncryptionKeyResponse{}, err
	}
	return result, nil
}

// GetEncryptionSettings - Returns the encryption settings of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientGetEncryptionSettingsOptions contains the optional parameters for the ManagersClient.GetEncryptionSettings
//     method.
func (client *ManagersClient) GetEncryptionSettings(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetEncryptionSettingsOptions) (ManagersClientGetEncryptionSettingsResponse, error) {
	var err error
	const operationName = "ManagersClient.GetEncryptionSettings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getEncryptionSettingsCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetEncryptionSettingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientGetEncryptionSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientGetEncryptionSettingsResponse{}, err
	}
	resp, err := client.getEncryptionSettingsHandleResponse(httpResp)
	return resp, err
}

// getEncryptionSettingsCreateRequest creates the GetEncryptionSettings request.
func (client *ManagersClient) getEncryptionSettingsCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetEncryptionSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/encryptionSettings/default"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getEncryptionSettingsHandleResponse handles the GetEncryptionSettings response.
func (client *ManagersClient) getEncryptionSettingsHandleResponse(resp *http.Response) (ManagersClientGetEncryptionSettingsResponse, error) {
	result := ManagersClientGetEncryptionSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EncryptionSettings); err != nil {
		return ManagersClientGetEncryptionSettingsResponse{}, err
	}
	return result, nil
}

// GetExtendedInfo - Returns the extended information of the specified manager name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientGetExtendedInfoOptions contains the optional parameters for the ManagersClient.GetExtendedInfo
//     method.
func (client *ManagersClient) GetExtendedInfo(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetExtendedInfoOptions) (ManagersClientGetExtendedInfoResponse, error) {
	var err error
	const operationName = "ManagersClient.GetExtendedInfo"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getExtendedInfoCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetExtendedInfoResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientGetExtendedInfoResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientGetExtendedInfoResponse{}, err
	}
	resp, err := client.getExtendedInfoHandleResponse(httpResp)
	return resp, err
}

// getExtendedInfoCreateRequest creates the GetExtendedInfo request.
func (client *ManagersClient) getExtendedInfoCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetExtendedInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getExtendedInfoHandleResponse handles the GetExtendedInfo response.
func (client *ManagersClient) getExtendedInfoHandleResponse(resp *http.Response) (ManagersClientGetExtendedInfoResponse, error) {
	result := ManagersClientGetExtendedInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerExtendedInfo); err != nil {
		return ManagersClientGetExtendedInfoResponse{}, err
	}
	return result, nil
}

// GetPublicEncryptionKey - Returns the symmetric encrypted public encryption key of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientGetPublicEncryptionKeyOptions contains the optional parameters for the ManagersClient.GetPublicEncryptionKey
//     method.
func (client *ManagersClient) GetPublicEncryptionKey(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetPublicEncryptionKeyOptions) (ManagersClientGetPublicEncryptionKeyResponse, error) {
	var err error
	const operationName = "ManagersClient.GetPublicEncryptionKey"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getPublicEncryptionKeyCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetPublicEncryptionKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientGetPublicEncryptionKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientGetPublicEncryptionKeyResponse{}, err
	}
	resp, err := client.getPublicEncryptionKeyHandleResponse(httpResp)
	return resp, err
}

// getPublicEncryptionKeyCreateRequest creates the GetPublicEncryptionKey request.
func (client *ManagersClient) getPublicEncryptionKeyCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetPublicEncryptionKeyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/listPublicEncryptionKey"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getPublicEncryptionKeyHandleResponse handles the GetPublicEncryptionKey response.
func (client *ManagersClient) getPublicEncryptionKeyHandleResponse(resp *http.Response) (ManagersClientGetPublicEncryptionKeyResponse, error) {
	result := ManagersClientGetPublicEncryptionKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SymmetricEncryptedSecret); err != nil {
		return ManagersClientGetPublicEncryptionKeyResponse{}, err
	}
	return result, nil
}

// NewListPager - Retrieves all the managers in a subscription.
//
// Generated from API version 2017-06-01
//   - options - ManagersClientListOptions contains the optional parameters for the ManagersClient.NewListPager method.
func (client *ManagersClient) NewListPager(options *ManagersClientListOptions) *runtime.Pager[ManagersClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagersClientListResponse]{
		More: func(page ManagersClientListResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ManagersClientListResponse) (ManagersClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagersClient.NewListPager")
			req, err := client.listCreateRequest(ctx, options)
			if err != nil {
				return ManagersClientListResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ManagersClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagersClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ManagersClient) listCreateRequest(ctx context.Context, options *ManagersClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.StorSimple/managers"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ManagersClient) listHandleResponse(resp *http.Response) (ManagersClientListResponse, error) {
	result := ManagersClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerList); err != nil {
		return ManagersClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Retrieves all the managers in a resource group.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - options - ManagersClientListByResourceGroupOptions contains the optional parameters for the ManagersClient.NewListByResourceGroupPager
//     method.
func (client *ManagersClient) NewListByResourceGroupPager(resourceGroupName string, options *ManagersClientListByResourceGroupOptions) *runtime.Pager[ManagersClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagersClientListByResourceGroupResponse]{
		More: func(page ManagersClientListByResourceGroupResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ManagersClientListByResourceGroupResponse) (ManagersClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagersClient.NewListByResourceGroupPager")
			req, err := client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			if err != nil {
				return ManagersClientListByResourceGroupResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ManagersClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagersClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *ManagersClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *ManagersClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *ManagersClient) listByResourceGroupHandleResponse(resp *http.Response) (ManagersClientListByResourceGroupResponse, error) {
	result := ManagersClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerList); err != nil {
		return ManagersClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListFeatureSupportStatusPager - Lists the features and their support status
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientListFeatureSupportStatusOptions contains the optional parameters for the ManagersClient.NewListFeatureSupportStatusPager
//     method.
func (client *ManagersClient) NewListFeatureSupportStatusPager(resourceGroupName string, managerName string, options *ManagersClientListFeatureSupportStatusOptions) *runtime.Pager[ManagersClientListFeatureSupportStatusResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagersClientListFeatureSupportStatusResponse]{
		More: func(page ManagersClientListFeatureSupportStatusResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ManagersClientListFeatureSupportStatusResponse) (ManagersClientListFeatureSupportStatusResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagersClient.NewListFeatureSupportStatusPager")
			req, err := client.listFeatureSupportStatusCreateRequest(ctx, resourceGroupName, managerName, options)
			if err != nil {
				return ManagersClientListFeatureSupportStatusResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ManagersClientListFeatureSupportStatusResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagersClientListFeatureSupportStatusResponse{}, runtime.NewResponseError(resp)
			}
			return client.listFeatureSupportStatusHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listFeatureSupportStatusCreateRequest creates the ListFeatureSupportStatus request.
func (client *ManagersClient) listFeatureSupportStatusCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientListFeatureSupportStatusOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/features"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listFeatureSupportStatusHandleResponse handles the ListFeatureSupportStatus response.
func (client *ManagersClient) listFeatureSupportStatusHandleResponse(resp *http.Response) (ManagersClientListFeatureSupportStatusResponse, error) {
	result := ManagersClientListFeatureSupportStatusResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FeatureList); err != nil {
		return ManagersClientListFeatureSupportStatusResponse{}, err
	}
	return result, nil
}

// NewListMetricDefinitionPager - Gets the metric definitions for the specified manager.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientListMetricDefinitionOptions contains the optional parameters for the ManagersClient.NewListMetricDefinitionPager
//     method.
func (client *ManagersClient) NewListMetricDefinitionPager(resourceGroupName string, managerName string, options *ManagersClientListMetricDefinitionOptions) *runtime.Pager[ManagersClientListMetricDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagersClientListMetricDefinitionResponse]{
		More: func(page ManagersClientListMetricDefinitionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ManagersClientListMetricDefinitionResponse) (ManagersClientListMetricDefinitionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagersClient.NewListMetricDefinitionPager")
			req, err := client.listMetricDefinitionCreateRequest(ctx, resourceGroupName, managerName, options)
			if err != nil {
				return ManagersClientListMetricDefinitionResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ManagersClientListMetricDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagersClientListMetricDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricDefinitionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMetricDefinitionCreateRequest creates the ListMetricDefinition request.
func (client *ManagersClient) listMetricDefinitionCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientListMetricDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/metricsDefinitions"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricDefinitionHandleResponse handles the ListMetricDefinition response.
func (client *ManagersClient) listMetricDefinitionHandleResponse(resp *http.Response) (ManagersClientListMetricDefinitionResponse, error) {
	result := ManagersClientListMetricDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricDefinitionList); err != nil {
		return ManagersClientListMetricDefinitionResponse{}, err
	}
	return result, nil
}

// NewListMetricsPager - Gets the metrics for the specified manager.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - filter - OData Filter options
//   - options - ManagersClientListMetricsOptions contains the optional parameters for the ManagersClient.NewListMetricsPager
//     method.
func (client *ManagersClient) NewListMetricsPager(resourceGroupName string, managerName string, filter string, options *ManagersClientListMetricsOptions) *runtime.Pager[ManagersClientListMetricsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagersClientListMetricsResponse]{
		More: func(page ManagersClientListMetricsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ManagersClientListMetricsResponse) (ManagersClientListMetricsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagersClient.NewListMetricsPager")
			req, err := client.listMetricsCreateRequest(ctx, resourceGroupName, managerName, filter, options)
			if err != nil {
				return ManagersClientListMetricsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ManagersClientListMetricsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagersClientListMetricsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listMetricsCreateRequest creates the ListMetrics request.
func (client *ManagersClient) listMetricsCreateRequest(ctx context.Context, resourceGroupName string, managerName string, filter string, options *ManagersClientListMetricsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/metrics"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	reqQP.Set("$filter", filter)
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricsHandleResponse handles the ListMetrics response.
func (client *ManagersClient) listMetricsHandleResponse(resp *http.Response) (ManagersClientListMetricsResponse, error) {
	result := ManagersClientListMetricsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricList); err != nil {
		return ManagersClientListMetricsResponse{}, err
	}
	return result, nil
}

// RegenerateActivationKey - Re-generates and returns the activation key of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - options - ManagersClientRegenerateActivationKeyOptions contains the optional parameters for the ManagersClient.RegenerateActivationKey
//     method.
func (client *ManagersClient) RegenerateActivationKey(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientRegenerateActivationKeyOptions) (ManagersClientRegenerateActivationKeyResponse, error) {
	var err error
	const operationName = "ManagersClient.RegenerateActivationKey"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.regenerateActivationKeyCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientRegenerateActivationKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientRegenerateActivationKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientRegenerateActivationKeyResponse{}, err
	}
	resp, err := client.regenerateActivationKeyHandleResponse(httpResp)
	return resp, err
}

// regenerateActivationKeyCreateRequest creates the RegenerateActivationKey request.
func (client *ManagersClient) regenerateActivationKeyCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientRegenerateActivationKeyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/regenerateActivationKey"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// regenerateActivationKeyHandleResponse handles the RegenerateActivationKey response.
func (client *ManagersClient) regenerateActivationKeyHandleResponse(resp *http.Response) (ManagersClientRegenerateActivationKeyResponse, error) {
	result := ManagersClientRegenerateActivationKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Key); err != nil {
		return ManagersClientRegenerateActivationKeyResponse{}, err
	}
	return result, nil
}

// Update - Updates the StorSimple Manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - parameters - The manager update parameters.
//   - options - ManagersClientUpdateOptions contains the optional parameters for the ManagersClient.Update method.
func (client *ManagersClient) Update(ctx context.Context, resourceGroupName string, managerName string, parameters ManagerPatch, options *ManagersClientUpdateOptions) (ManagersClientUpdateResponse, error) {
	var err error
	const operationName = "ManagersClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return ManagersClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *ManagersClient) updateCreateRequest(ctx context.Context, resourceGroupName string, managerName string, parameters ManagerPatch, options *ManagersClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *ManagersClient) updateHandleResponse(resp *http.Response) (ManagersClientUpdateResponse, error) {
	result := ManagersClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Manager); err != nil {
		return ManagersClientUpdateResponse{}, err
	}
	return result, nil
}

// UpdateExtendedInfo - Updates the extended info of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-06-01
//   - resourceGroupName - The resource group name
//   - managerName - The manager name
//   - ifMatch - Pass the ETag of ExtendedInfo fetched from GET call
//   - parameters - The manager extended information.
//   - options - ManagersClientUpdateExtendedInfoOptions contains the optional parameters for the ManagersClient.UpdateExtendedInfo
//     method.
func (client *ManagersClient) UpdateExtendedInfo(ctx context.Context, resourceGroupName string, managerName string, ifMatch string, parameters ManagerExtendedInfo, options *ManagersClientUpdateExtendedInfoOptions) (ManagersClientUpdateExtendedInfoResponse, error) {
	var err error
	const operationName = "ManagersClient.UpdateExtendedInfo"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateExtendedInfoCreateRequest(ctx, resourceGroupName, managerName, ifMatch, parameters, options)
	if err != nil {
		return ManagersClientUpdateExtendedInfoResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagersClientUpdateExtendedInfoResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagersClientUpdateExtendedInfoResponse{}, err
	}
	resp, err := client.updateExtendedInfoHandleResponse(httpResp)
	return resp, err
}

// updateExtendedInfoCreateRequest creates the UpdateExtendedInfo request.
func (client *ManagersClient) updateExtendedInfoCreateRequest(ctx context.Context, resourceGroupName string, managerName string, ifMatch string, parameters ManagerExtendedInfo, options *ManagersClientUpdateExtendedInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo"
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", client.subscriptionID)
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", resourceGroupName)
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", managerName)
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["If-Match"] = []string{ifMatch}
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateExtendedInfoHandleResponse handles the UpdateExtendedInfo response.
func (client *ManagersClient) updateExtendedInfoHandleResponse(resp *http.Response) (ManagersClientUpdateExtendedInfoResponse, error) {
	result := ManagersClientUpdateExtendedInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerExtendedInfo); err != nil {
		return ManagersClientUpdateExtendedInfoResponse{}, err
	}
	return result, nil
}
