//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armtimeseriesinsights.ClientFactory type.
type ServerFactory struct {
	AccessPoliciesServer    AccessPoliciesServer
	EnvironmentsServer      EnvironmentsServer
	EventSourcesServer      EventSourcesServer
	OperationsServer        OperationsServer
	ReferenceDataSetsServer ReferenceDataSetsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armtimeseriesinsights.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armtimeseriesinsights.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                       *ServerFactory
	trMu                      sync.Mutex
	trAccessPoliciesServer    *AccessPoliciesServerTransport
	trEnvironmentsServer      *EnvironmentsServerTransport
	trEventSourcesServer      *EventSourcesServerTransport
	trOperationsServer        *OperationsServerTransport
	trReferenceDataSetsServer *ReferenceDataSetsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AccessPoliciesClient":
		initServer(s, &s.trAccessPoliciesServer, func() *AccessPoliciesServerTransport {
			return NewAccessPoliciesServerTransport(&s.srv.AccessPoliciesServer)
		})
		resp, err = s.trAccessPoliciesServer.Do(req)
	case "EnvironmentsClient":
		initServer(s, &s.trEnvironmentsServer, func() *EnvironmentsServerTransport { return NewEnvironmentsServerTransport(&s.srv.EnvironmentsServer) })
		resp, err = s.trEnvironmentsServer.Do(req)
	case "EventSourcesClient":
		initServer(s, &s.trEventSourcesServer, func() *EventSourcesServerTransport { return NewEventSourcesServerTransport(&s.srv.EventSourcesServer) })
		resp, err = s.trEventSourcesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "ReferenceDataSetsClient":
		initServer(s, &s.trReferenceDataSetsServer, func() *ReferenceDataSetsServerTransport {
			return NewReferenceDataSetsServerTransport(&s.srv.ReferenceDataSetsServer)
		})
		resp, err = s.trReferenceDataSetsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
