//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/windowsesu/armwindowsesu"
	"net/http"
	"net/url"
	"regexp"
)

// MultipleActivationKeysServer is a fake server for instances of the armwindowsesu.MultipleActivationKeysClient type.
type MultipleActivationKeysServer struct {
	// BeginCreate is the fake for method MultipleActivationKeysClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey armwindowsesu.MultipleActivationKey, options *armwindowsesu.MultipleActivationKeysClientBeginCreateOptions) (resp azfake.PollerResponder[armwindowsesu.MultipleActivationKeysClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method MultipleActivationKeysClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, options *armwindowsesu.MultipleActivationKeysClientDeleteOptions) (resp azfake.Responder[armwindowsesu.MultipleActivationKeysClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method MultipleActivationKeysClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, options *armwindowsesu.MultipleActivationKeysClientGetOptions) (resp azfake.Responder[armwindowsesu.MultipleActivationKeysClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method MultipleActivationKeysClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armwindowsesu.MultipleActivationKeysClientListOptions) (resp azfake.PagerResponder[armwindowsesu.MultipleActivationKeysClientListResponse])

	// NewListByResourceGroupPager is the fake for method MultipleActivationKeysClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armwindowsesu.MultipleActivationKeysClientListByResourceGroupOptions) (resp azfake.PagerResponder[armwindowsesu.MultipleActivationKeysClientListByResourceGroupResponse])

	// Update is the fake for method MultipleActivationKeysClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, multipleActivationKeyName string, multipleActivationKey armwindowsesu.MultipleActivationKeyUpdate, options *armwindowsesu.MultipleActivationKeysClientUpdateOptions) (resp azfake.Responder[armwindowsesu.MultipleActivationKeysClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewMultipleActivationKeysServerTransport creates a new instance of MultipleActivationKeysServerTransport with the provided implementation.
// The returned MultipleActivationKeysServerTransport instance is connected to an instance of armwindowsesu.MultipleActivationKeysClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMultipleActivationKeysServerTransport(srv *MultipleActivationKeysServer) *MultipleActivationKeysServerTransport {
	return &MultipleActivationKeysServerTransport{
		srv:                         srv,
		beginCreate:                 newTracker[azfake.PollerResponder[armwindowsesu.MultipleActivationKeysClientCreateResponse]](),
		newListPager:                newTracker[azfake.PagerResponder[armwindowsesu.MultipleActivationKeysClientListResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armwindowsesu.MultipleActivationKeysClientListByResourceGroupResponse]](),
	}
}

// MultipleActivationKeysServerTransport connects instances of armwindowsesu.MultipleActivationKeysClient to instances of MultipleActivationKeysServer.
// Don't use this type directly, use NewMultipleActivationKeysServerTransport instead.
type MultipleActivationKeysServerTransport struct {
	srv                         *MultipleActivationKeysServer
	beginCreate                 *tracker[azfake.PollerResponder[armwindowsesu.MultipleActivationKeysClientCreateResponse]]
	newListPager                *tracker[azfake.PagerResponder[armwindowsesu.MultipleActivationKeysClientListResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armwindowsesu.MultipleActivationKeysClientListByResourceGroupResponse]]
}

// Do implements the policy.Transporter interface for MultipleActivationKeysServerTransport.
func (m *MultipleActivationKeysServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MultipleActivationKeysClient.BeginCreate":
		resp, err = m.dispatchBeginCreate(req)
	case "MultipleActivationKeysClient.Delete":
		resp, err = m.dispatchDelete(req)
	case "MultipleActivationKeysClient.Get":
		resp, err = m.dispatchGet(req)
	case "MultipleActivationKeysClient.NewListPager":
		resp, err = m.dispatchNewListPager(req)
	case "MultipleActivationKeysClient.NewListByResourceGroupPager":
		resp, err = m.dispatchNewListByResourceGroupPager(req)
	case "MultipleActivationKeysClient.Update":
		resp, err = m.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MultipleActivationKeysServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := m.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.WindowsESU/multipleActivationKeys/(?P<multipleActivationKeyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armwindowsesu.MultipleActivationKey](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		multipleActivationKeyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("multipleActivationKeyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreate(req.Context(), resourceGroupNameParam, multipleActivationKeyNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		m.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		m.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		m.beginCreate.remove(req)
	}

	return resp, nil
}

func (m *MultipleActivationKeysServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if m.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.WindowsESU/multipleActivationKeys/(?P<multipleActivationKeyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	multipleActivationKeyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("multipleActivationKeyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Delete(req.Context(), resourceGroupNameParam, multipleActivationKeyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MultipleActivationKeysServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.WindowsESU/multipleActivationKeys/(?P<multipleActivationKeyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	multipleActivationKeyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("multipleActivationKeyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, multipleActivationKeyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MultipleActivationKey, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MultipleActivationKeysServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := m.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.WindowsESU/multipleActivationKeys`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := m.srv.NewListPager(nil)
		newListPager = &resp
		m.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armwindowsesu.MultipleActivationKeysClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		m.newListPager.remove(req)
	}
	return resp, nil
}

func (m *MultipleActivationKeysServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := m.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.WindowsESU/multipleActivationKeys`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		m.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armwindowsesu.MultipleActivationKeysClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		m.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (m *MultipleActivationKeysServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.WindowsESU/multipleActivationKeys/(?P<multipleActivationKeyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armwindowsesu.MultipleActivationKeyUpdate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	multipleActivationKeyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("multipleActivationKeyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Update(req.Context(), resourceGroupNameParam, multipleActivationKeyNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MultipleActivationKey, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
