# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.monitor import MonitorManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-monitor
# USAGE
    python create_or_update_metric_alert_resource_group.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = MonitorManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7",
    )

    response = client.metric_alerts.create_or_update(
        resource_group_name="gigtest1",
        rule_name="MetricAlertAtResourceGroupLevel",
        parameters={
            "location": "global",
            "properties": {
                "actions": [
                    {
                        "actionGroupId": "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2",
                        "webHookProperties": {"key11": "value11", "key12": "value12"},
                    }
                ],
                "autoMitigate": True,
                "criteria": {
                    "allOf": [
                        {
                            "criterionType": "StaticThresholdCriterion",
                            "dimensions": [],
                            "metricName": "Percentage CPU",
                            "metricNamespace": "microsoft.compute/virtualmachines",
                            "name": "High_CPU_80",
                            "operator": "GreaterThan",
                            "threshold": 80.5,
                            "timeAggregation": "Average",
                        }
                    ],
                    "odata.type": "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria",
                },
                "description": "This is the description of the rule1",
                "enabled": True,
                "evaluationFrequency": "PT1M",
                "scopes": [
                    "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest1",
                    "/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest2",
                ],
                "severity": 3,
                "targetResourceRegion": "southcentralus",
                "targetResourceType": "Microsoft.Compute/virtualMachines",
                "windowSize": "PT15M",
            },
            "tags": {},
        },
    )
    print(response)


# x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/createOrUpdateMetricAlertResourceGroup.json
if __name__ == "__main__":
    main()
