# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementScopeAccessReviewScheduleDefinitionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scope_access_review_schedule_definitions_list(self, resource_group):
        response = self.client.scope_access_review_schedule_definitions.list(
            scope="str",
            api_version="2021-12-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scope_access_review_schedule_definitions_get_by_id(self, resource_group):
        response = self.client.scope_access_review_schedule_definitions.get_by_id(
            scope="str",
            schedule_definition_id="str",
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scope_access_review_schedule_definitions_delete_by_id(self, resource_group):
        response = self.client.scope_access_review_schedule_definitions.delete_by_id(
            scope="str",
            schedule_definition_id="str",
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scope_access_review_schedule_definitions_create_or_update_by_id(self, resource_group):
        response = self.client.scope_access_review_schedule_definitions.create_or_update_by_id(
            scope="str",
            schedule_definition_id="str",
            properties={
                "assignmentState": "str",
                "autoApplyDecisionsEnabled": bool,
                "backupReviewers": [{"principalId": "str", "principalType": "str"}],
                "defaultDecision": "str",
                "defaultDecisionEnabled": bool,
                "descriptionForAdmins": "str",
                "descriptionForReviewers": "str",
                "displayName": "str",
                "endDate": "2020-02-20 00:00:00",
                "excludeResourceId": "str",
                "excludeRoleDefinitionId": "str",
                "expandNestedMemberships": bool,
                "inactiveDuration": "1 day, 0:00:00",
                "includeAccessBelowResource": bool,
                "includeInheritedAccess": bool,
                "instanceDurationInDays": 0,
                "instances": [
                    {
                        "backupReviewers": [{"principalId": "str", "principalType": "str"}],
                        "endDateTime": "2020-02-20 00:00:00",
                        "id": "str",
                        "name": "str",
                        "reviewers": [{"principalId": "str", "principalType": "str"}],
                        "reviewersType": "str",
                        "startDateTime": "2020-02-20 00:00:00",
                        "status": "str",
                        "type": "str",
                    }
                ],
                "interval": 0,
                "justificationRequiredOnApproval": bool,
                "mailNotificationsEnabled": bool,
                "numberOfOccurrences": 0,
                "principalId": "str",
                "principalName": "str",
                "principalType": "str",
                "recommendationLookBackDuration": "1 day, 0:00:00",
                "recommendationsEnabled": bool,
                "reminderNotificationsEnabled": bool,
                "resourceId": "str",
                "reviewers": [{"principalId": "str", "principalType": "str"}],
                "reviewersType": "str",
                "roleDefinitionId": "str",
                "startDate": "2020-02-20 00:00:00",
                "status": "str",
                "type": "str",
                "userPrincipalName": "str",
            },
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_scope_access_review_schedule_definitions_stop(self, resource_group):
        response = self.client.scope_access_review_schedule_definitions.stop(
            scope="str",
            schedule_definition_id="str",
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...
