---
title: District
---

## districts2poly.py

Transform
[districts](../Demand/Importing_O/D_Matrices.md#describing_the_taz)
into polygons for visualization in [sumo-gui](../sumo-gui.md).
Using the options **--hue, --saturation, --brightness** the colors can be controlled. Each of these options
supports values from \[0, 1\] as well as the special value *random*.

```
python tools/districts2poly.py <net-file> <route-file>
```

!!! caution
    Only districts using the attribute `edges` are currently supported

## edgesInDistricts.py

Parses a network and a list of polygons and writes a taz file with all the edges which are inside the respective polygonal shape.
The taz-shape-files must be in the format generated by
[polyconvert](../polyconvert.md).

```
python tools/edgesInDistricts.py -n <net-file> -t <taz-files>
```


Call option **--help** for additional details.

!!! caution
    The provided taz shapes must use the same coordinate projection as the network file. The best way to ensure this when importing shapes with [polyconvert](../polyconvert.md) is by setting option **--net-file**

## filterDistricts.py

Filter a taz (district) file using a network file and a vehicle class so
that only edges which allow the given vehicle class are included in the
taz definitions.

```
python tools/district/filterDistricts.py -n <net-file> -t <taz-file> -o <output-file> --vclass passenger
```

Call option **--help** for additional details.

## generateBidiDistricts.py

Finds edges that are opposites of each other and puts them in a common
district (TAZ). This can be used to improve routing in conjunction with
[trip attributes fromTaz and
toTaz](../Definition_of_Vehicles,_Vehicle_Types,_and_Routes.md#traffic_assignment_zones_taz).

```
python tools/generateBidiDistricts.py <net-file>
```

Call option **--help** for additional details.

### Example usage

When applied to a typical OSM network, and edge and the edge with the
negated id describe opposite direction edges of the same road. The
generated bidi-taz would look like this:

```xml
<taz id="-123" edges="-123 123"/>
<taz id="123" edges="-123 123"/>
```

The `<trip>` definitions that would typically use attributes *from* and *to*
instead use the attributes *fromTaz* and *toTaz*:

```xml
<trip id="someTrip" from="123" to="456" depart="0"/>
<trip id="someTripWithBidiTaz" fromTaz="123" toTaz="456"/>
```

The second definition would allow departure from either edge *123*' or
*-123* **due to the way the taz *123* ** is defined. This can prevent
unwanted turn-arounds and the beginning and end of generated trips and
thus simplifies trips created from mapping of geo-coordinates.


## gridDistricts.py

Generates a grid of districts (TAZ) with a given width (in m) for a given network file.

```
python tools/district/gridDistricts.py -n <net-file> -o <output-file> -w 300
```


## stationDistricts.py

Segment a public transport network based on nearby stations.
A station is defined by all stops (`<busStop>` or `<trainStop>`) that have the same `name` attribute. Each edge that belongs to the public transport network for a configurable list of vClasses is assigned to the nearest station. Each station is then written as a `<taz>` with its assigned edges.
By default only edges that permit vehicle classes `rail` or `rail_urban` are considered (can be set via option **--vclasses**)
The following edges are considered part of the public transport network:

- a) edges that have a stop
- b) edges within a configurable radius around a station
- c) edges that are connected to edges of category a) or b)

If there are multiple stops with different names (stations) on the same edge, the following behaviors are possible:

- **default**: the edge belongs to multiple stations (`<taz>`)
- option **--merge**: the stations are merged into a joint station with `name="<NAME1>|<NAME2>"`
- option **--split-output**: a patch file with splits is written that allows further processing of the input network. After splitting the net and running **stationDistricts.py** again, each stop will have its own edge

Example call:

```
python tools/district/stationDistricts.py -n <net-file> -s <stop-file> -o <output-file>
```
