## TFSA-2021-086: Division by zero in TFLite's implementation of `SVDF`

### CVE Number
CVE-2021-29598

### Impact
The implementation of the `SVDF` TFLite operator is [vulnerable to a
division by zero
error](https://github.com/tensorflow/tensorflow/blob/7f283ff806b2031f407db64c4d3edcda8fb9f9f5/tensorflow/lite/kernels/svdf.cc#L99-L102):

```cc
const int rank = params->rank;
...
TF_LITE_ENSURE_EQ(context, num_filters % rank, 0);
```

An attacker can craft a model such that `params->rank` would be 0.

### Patches
We have patched the issue in GitHub commit
[6841e522a3e7d48706a02e8819836e809f738682](https://github.com/tensorflow/tensorflow/commit/6841e522a3e7d48706a02e8819836e809f738682).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
