---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, caractèresn symbole marque déposée, 
              symbole marque commerciale, copie interdite
---

# Comment obtenir un symbole copyright, trademark ou registered ?

LaTeX fournit les commandes :

- `\textcopyright` pour (c), symbole du [copyright](wpfr:Copyright) ;
- `\textregistered` pour (r), symbole de [marque déposée](wpfr:Symbole%20de%20marque%20déposée)
  (*registered trademark*) ;
- `\texttrademark` pour (tm), symbole du [trademark](wpfr:Droit%20des%20marques) ;

Un problème survient lorsque vous voulez mettre en exposant un `\textregistered` 
(pour qu'il ressemble un peu à un (tm)). 
La mise en exposant mathématique provoque des erreurs inutiles. 
Aussi, vous devrez utiliser la mise en exposant textuelle :

```{noedit}
\textsuperscript{\textregistered}
```

Voici un exemple d'utilisation :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\og{}L'État\texttrademark, c'est moi\textsuperscript{\textregistered} !\fg{}
\textcopyright{} Tous droits réservés - 1655.
\end{document}
```


## Avec l'extension [amssymb](ctanpkg:amsfonts)

L'extension [amssymb](ctanpkg:amsfonts) dispose d'une commande `\circledR` pour obtenir le (r).


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amssymb}

\begin{document}
Petite comparaison : \textregistered{} et \circledR.
\end{document}
```


## Avec l'extension <ctanpkg:textcomp>

:::{warning}
L’extension <ctanpkg:textcomp> est classée comme
[obsolète](/1_generalites/histoire/liste_des_packages_obsoletes). Ce qui suit
est informatif.
:::

L'extension <ctanpkg:textcomp> fournissait historiquement des variantes plus élégantes 
et plus stables de `\textregistered`, `\texttrademark` et `\textcopyright` 
pour compenser les premières versions fournies par LaTeX. 
En particulier, la version de `\textregistered` de <ctanpkg:textcomp> corrigeait 
un comportement inadéquat du caractère de base lorsqu'il se trouvait dans un texte en gras : 
le "R" majuscule (en fait une petite majuscule) devenait un "r" minuscule 
(en l'absence de petite majuscule grasse).

:::{sources}
[How to get copyright, trademark, etc.](faquk:FAQ-tradesyms)
:::