// Copyright (C) 2017 Fredrik Öhrström (CC0-1.0) Definitions from
// WMBus_HCI_Spec_V1_6.pdf Found here:
// https://wireless-solutions.de/products/gateways/wirelessadapter.html

#define IM871A_SERIAL_SOF 0xA5

#define DEVMGMT_ID 0x01
#define RADIOLINK_ID 0x02
#define RADIOLINKTEST_ID 0x03
#define HWTEST_ID 0x04

#define DEVMGMT_MSG_PING_REQ 0x01
#define DEVMGMT_MSG_PING_RSP 0x02
#define DEVMGMT_MSG_SET_CONFIG_REQ 0x03
#define DEVMGMT_MSG_SET_CONFIG_RSP 0x04
#define DEVMGMT_MSG_GET_CONFIG_REQ 0x05
#define DEVMGMT_MSG_GET_CONFIG_RSP 0x06
#define DEVMGMT_MSG_RESET_REQ 0x07
#define DEVMGMT_MSG_RESET_RSP 0x08
#define DEVMGMT_MSG_FACTORY_RESET_REQ 0x09
#define DEVMGMT_MSG_FACTORY_RESET_RSP 0x0A
#define DEVMGMT_MSG_GET_OPMODE_REQ 0x0B
#define DEVMGMT_MSG_GET_OPMODE_RSP 0x0C
#define DEVMGMT_MSG_SET_OPMODE_REQ 0x0D
#define DEVMGMT_MSG_SET_OPMODE_RSP 0x0E
#define DEVMGMT_MSG_GET_DEVICEINFO_REQ 0x0F
#define DEVMGMT_MSG_GET_DEVICEINFO_RSP 0x10
#define DEVMGMT_MSG_GET_SYSSTATUS_REQ 0x11
#define DEVMGMT_MSG_GET_SYSSTATUS_RSP 0x12
#define DEVMGMT_MSG_GET_FWINFO_REQ 0x13
#define DEVMGMT_MSG_GET_FWINFO_RSP 0x14
#define DEVMGMT_MSG_GET_RTC_REQ 0x19
#define DEVMGMT_MSG_GET_RTC_RSP 0x1A
#define DEVMGMT_MSG_SET_RTC_REQ 0x1B
#define DEVMGMT_MSG_SET_RTC_RSP 0x1C
#define DEVMGMT_MSG_ENTER_LPM_REQ 0x1D
#define DEVMGMT_MSG_ENTER_LPM_RSP 0x1E
#define DEVMGMT_MSG_SET_AES_ENCKEY_REQ 0x21
#define DEVMGMT_MSG_SET_AES_ENCKEY_RSP 0x22
#define DEVMGMT_MSG_ENABLE_AES_ENCKEY_REQ 0x23
#define DEVMGMT_MSG_ENABLE_AES_ENCKEY_RSP 0x24
#define DEVMGMT_MSG_SET_AES_DECKEY_REQ 0x25
#define DEVMGMT_MSG_SET_AES_DECKEY_RSP 0x26
#define DEVMGMT_MSG_AES_DEC_ERROR_IND 0x27

#define RADIOLINK_MSG_WMBUSMSG_REQ 0x01
#define RADIOLINK_MSG_WMBUSMSG_RSP 0x02
#define RADIOLINK_MSG_WMBUSMSG_IND 0x03
#define RADIOLINK_MSG_DATA_REQ 0x04
#define RADIOLINK_MSG_DATA_RSP 0x05

#define RADIOLINKTEST_MSG_START_REQ 0x01
#define RADIOLINKTEST_MSG_START_RSP 0x02
#define RADIOLINKTEST_MSG_STOP_REQ 0x03
#define RADIOLINKTEST_MSG_STOP_RSP 0x04
#define RADIOLINKTEST_MSG_STATUS_IND 0x07

#define HWTEST_MSG_RADIOTEST_REQ 0x01
#define HWTEST_MSG_RADIOTEST_RSP 0x02

// LinkModeIM871A::S1 is 0, S1m is 1 etc. These numbers are what the dongle requires.
#define LIST_OF_IM871A_LINK_MODES \
    X(S1,s1)\
    X(S1m,s1m)\
    X(S2,s2)\
    X(T1,t1)\
    X(T2,t2)\
    X(R2,r2)\
    X(C1a,c1a)\
    X(C1b,cab)\
    X(C2a,c2a)\
    X(C2b,c2b)\
    X(CT_N1A,ct_n1a)\
    X(N2A,n2a)\
    X(N1B,n1b)\
    X(N2B,n2b)\
    X(N1C,n1c)\
    X(N2C,n2c)\
    X(N1D,n1d)\
    X(N2D,n2d)\
    X(N1E,n1e)\
    X(N2E,n2e)\
    X(N1F,n1f)\
    X(N2F,n2f)\
    X(UNKNOWN,unknown)

enum class LinkModeIM871A {
#define X(name,text) name,
LIST_OF_IM871A_LINK_MODES
#undef X
};

string toString(LinkModeIM871A lm);
