package ONVIF::Media::Types::MaximumNumberOfOSDs;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::Media::Types::MaximumNumberOfOSDs::_MaximumNumberOfOSDs::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}



# There's no variety - empty complexType
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

__PACKAGE__->_factory();


package ONVIF::Media::Types::MaximumNumberOfOSDs::_MaximumNumberOfOSDs::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %Total_of :ATTR(:get<Total>);
my %Image_of :ATTR(:get<Image>);
my %PlainText_of :ATTR(:get<PlainText>);
my %Date_of :ATTR(:get<Date>);
my %Time_of :ATTR(:get<Time>);
my %DateAndTime_of :ATTR(:get<DateAndTime>);

__PACKAGE__->_factory(
    [ qw(
        Total
        Image
        PlainText
        Date
        Time
        DateAndTime
    ) ],
    {

        Total => \%Total_of,

        Image => \%Image_of,

        PlainText => \%PlainText_of,

        Date => \%Date_of,

        Time => \%Time_of,

        DateAndTime => \%DateAndTime_of,
    },
    {
        Total => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        Image => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        PlainText => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        Date => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        Time => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        DateAndTime => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::Media::Types::MaximumNumberOfOSDs

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MaximumNumberOfOSDs from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

,



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::Media::Types::MaximumNumberOfOSDs::_MaximumNumberOfOSDs::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * Total



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::int|SOAP::WSDL::XSD::Typelib::Builtin::int>.

=item * Image



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::int|SOAP::WSDL::XSD::Typelib::Builtin::int>.

=item * PlainText



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::int|SOAP::WSDL::XSD::Typelib::Builtin::int>.

=item * Date



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::int|SOAP::WSDL::XSD::Typelib::Builtin::int>.

=item * Time



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::int|SOAP::WSDL::XSD::Typelib::Builtin::int>.

=item * DateAndTime



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::int|SOAP::WSDL::XSD::Typelib::Builtin::int>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

