/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.bitext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.bitext.StringPair;
import org.languagetool.bitext.TabBitextReader;

public class TabBitextReaderTest {
    @Test
    public void testReader() throws Exception {
        File input = File.createTempFile("input", "txt");
        input.deleteOnExit();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(input), StandardCharsets.UTF_8));
        writer.println("This is not actual.\tTo nie jest aktualne.");
        writer.println("Test\tTest");
        writer.println("ab\tVery strange data indeed, much longer than input");
        writer.close();
        TabBitextReader reader = new TabBitextReader(input.getAbsolutePath(), "UTF-8");
        int i = 1;
        for (StringPair srcAndTrg : reader) {
            Assert.assertTrue((srcAndTrg.getSource() != null ? 1 : 0) != 0);
            Assert.assertTrue((srcAndTrg.getTarget() != null ? 1 : 0) != 0);
            if (i == 1) {
                Assert.assertEquals((Object)"This is not actual.", (Object)srcAndTrg.getSource());
            } else if (i == 2) {
                Assert.assertEquals((Object)"Test", (Object)srcAndTrg.getSource());
            } else if (i == 3) {
                Assert.assertEquals((Object)"Very strange data indeed, much longer than input", (Object)srcAndTrg.getTarget());
            }
            ++i;
        }
    }
}

