# (c) Copyright 2020-2021. CodeWeavers, Inc.

import cxlog
import cxobjc
import cxproduct
import cxurlget
import cxutils
import distversion
import fileupdate
import proxyinfo

import hashlib
import json
import os

from urllib.parse import urlencode


class WebUtils(cxobjc.Proxy):
    pass


def get_version():
    '''Put the version number in the right format for the REST API'''
    return '.'.join(distversion.CX_VERSION.split('.')[0:3])


def get_token():
    token = cxproduct.get_config_string('CrossOver', 'Token', None)

    if not token:
        # Make sure the transition between CrossOver 25 and 26 goes smoothly on macOS.
        config = cxproduct.get_config()
        token = config['CrossOver'].get('Token', None)
        if token:
            cxproduct.set_config_string('CrossOver', 'Token', token)

    return token


@cxobjc.method(WebUtils, 'createToken_password_')
def create_token(login, password):
    url = 'https://www.codeweavers.com/bin/rest/create_token'

    # Get an md5 of the password.
    md5_hasher = hashlib.md5()
    md5_hasher.update(cxutils.string_to_utf8(password))
    md5_password = md5_hasher.hexdigest()

    token = None

    try:
        proxyinfo.install_default_opener()

        data = cxurlget.fetch_content(url, timeout=5,
            data={'username': login, 'password': md5_password})
        token = json.loads(cxutils.string_to_unicode(data))
    except cxurlget.UrlError as e:
        # Errors in communication with the server
        cxlog.log(e.reason)
        return False

    if token is not None:
        cxproduct.set_config_string('CrossOver', 'Token', token)
        return True

    return False


@cxobjc.method(WebUtils, 'updateCompatDB')
def update_compatdb():
    major_version = get_version().split('.', maxsplit=1)[0]
    compatdb_dat = os.path.join(cxproduct.get_user_dir(), f"compatdb-{major_version}.dat")
    url = "https://www.codeweavers.com/bin/rest/compatdb"
    data = urlencode({'version': get_version()})
    return fileupdate.update(compatdb_dat, url + "?" + data, True)
