/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.validation;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;

public interface EndpointValidator {
    public Endpoint endpoint();

    public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator();

    private String resourceName() {
        if (Objects.isNull((Object)this.endpoint())) {
            return "";
        }
        switch (this.endpoint()) {
            case ACCOUNT: {
                return "account";
            }
            case ACTIONGROUPS: {
                return "actiongroup";
            }
            case ALLOWLIST: 
            case AUDIT: 
            case CONFIG: {
                return "config";
            }
            case INTERNALUSERS: {
                return "user";
            }
            case NODESDN: {
                return "nodesdn";
            }
            case ROLES: {
                return "role";
            }
            case ROLESMAPPING: {
                return "rolesmapping";
            }
            case TENANTS: {
                return "tenant";
            }
        }
        return "";
    }

    default public boolean isCurrentUserAdmin() {
        return this.restApiAdminPrivilegesEvaluator().isCurrentUserAdminFor(this.endpoint());
    }

    default public ValidationResult<String> withRequiredEntityName(String entityName) {
        if (entityName == null) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("No " + this.resourceName() + " specified."));
        }
        return ValidationResult.success(entityName);
    }

    default public ValidationResult<SecurityConfiguration> entityExists(SecurityConfiguration securityConfiguration) {
        return this.entityExists(this.resourceName(), securityConfiguration);
    }

    default public ValidationResult<SecurityConfiguration> entityExists(String resourceName, SecurityConfiguration securityConfiguration) {
        return securityConfiguration.maybeEntityName().map(entityName -> {
            if (!securityConfiguration.entityExists()) {
                return ValidationResult.error(RestStatus.NOT_FOUND, Responses.notFoundMessage(resourceName + " '" + securityConfiguration.entityName() + "' not found."));
            }
            return ValidationResult.success(securityConfiguration);
        }).orElseGet(() -> ValidationResult.success(securityConfiguration));
    }

    default public ValidationResult<SecurityConfiguration> isAllowedToChangeImmutableEntity(SecurityConfiguration securityConfiguration) throws IOException {
        ValidationResult<SecurityConfiguration> immutableCheck = this.entityImmutable(securityConfiguration);
        if (!immutableCheck.isValid() && !this.isCurrentUserAdmin()) {
            return immutableCheck;
        }
        return ValidationResult.success(securityConfiguration);
    }

    default public ValidationResult<SecurityConfiguration> isAllowedToLoadOrChangeHiddenEntity(SecurityConfiguration securityConfiguration) {
        ValidationResult<SecurityConfiguration> hiddenCheck = this.entityHidden(securityConfiguration);
        if (!hiddenCheck.isValid() && !this.isCurrentUserAdmin()) {
            return hiddenCheck;
        }
        return ValidationResult.success(securityConfiguration);
    }

    default public ValidationResult<SecurityConfiguration> entityImmutable(SecurityConfiguration securityConfiguration) throws IOException {
        return this.entityHidden(securityConfiguration).map(this::entityStatic).map(this::entityReserved);
    }

    default public ValidationResult<SecurityConfiguration> entityStatic(SecurityConfiguration securityConfiguration) {
        String entityName;
        SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
        if (configuration.isStatic(entityName = securityConfiguration.entityName())) {
            return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Resource '" + entityName + "' is static."));
        }
        return ValidationResult.success(securityConfiguration);
    }

    default public ValidationResult<SecurityConfiguration> entityReserved(SecurityConfiguration securityConfiguration) {
        String entityName;
        SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
        if (configuration.isReserved(entityName = securityConfiguration.entityName())) {
            return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Resource '" + entityName + "' is reserved."));
        }
        return ValidationResult.success(securityConfiguration);
    }

    default public ValidationResult<SecurityConfiguration> entityHidden(SecurityConfiguration securityConfiguration) {
        String entityName;
        SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
        if (configuration.isHidden(entityName = securityConfiguration.entityName())) {
            return ValidationResult.error(RestStatus.NOT_FOUND, Responses.notFoundMessage("Resource '" + entityName + "' is not available."));
        }
        return ValidationResult.success(securityConfiguration);
    }

    default public ValidationResult<SecurityDynamicConfiguration<?>> validateRoles(List<String> roles, SecurityDynamicConfiguration<?> rolesConfiguration) throws IOException {
        for (String role : roles) {
            ValidationResult validRole = this.entityExists("role", SecurityConfiguration.of(role, rolesConfiguration)).map(this::isAllowedToLoadOrChangeHiddenEntity);
            if (validRole.isValid()) continue;
            return ValidationResult.error(validRole.status(), validRole.errorMessage());
        }
        return ValidationResult.success(rolesConfiguration);
    }

    default public ValidationResult<SecurityConfiguration> isAllowedToChangeEntityWithRestAdminPermissions(SecurityConfiguration securityConfiguration) throws IOException {
        SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
        if (securityConfiguration.entityExists()) {
            Object existingEntity = configuration.getCEntry(securityConfiguration.entityName());
            if (this.restApiAdminPrivilegesEvaluator().containsRestApiAdminPermissions(existingEntity)) {
                return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Access denied"));
            }
        }
        if (securityConfiguration.requestContent() != null) {
            Object newConfigEntityContent = Utils.toConfigObject(securityConfiguration.requestContent(), configuration.getImplementingClass());
            if (this.restApiAdminPrivilegesEvaluator().containsRestApiAdminPermissions(newConfigEntityContent)) {
                return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Access denied"));
            }
        }
        return ValidationResult.success(securityConfiguration);
    }

    default public ValidationResult<SecurityConfiguration> onConfigDelete(SecurityConfiguration securityConfiguration) throws IOException {
        return this.isAllowedToChangeImmutableEntity(securityConfiguration).map(this::entityExists);
    }

    default public ValidationResult<SecurityConfiguration> onConfigLoad(SecurityConfiguration securityConfiguration) throws IOException {
        return this.isAllowedToLoadOrChangeHiddenEntity(securityConfiguration).map(this::entityExists);
    }

    default public ValidationResult<SecurityConfiguration> onConfigChange(SecurityConfiguration securityConfiguration) throws IOException {
        return this.isAllowedToChangeImmutableEntity(securityConfiguration);
    }

    public RequestContentValidator createRequestContentValidator(Object ... var1);
}

