/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class ConsumerGroupDescribeResponse
extends AbstractResponse {
    private final ConsumerGroupDescribeResponseData data;

    public ConsumerGroupDescribeResponse(ConsumerGroupDescribeResponseData data) {
        super(ApiKeys.CONSUMER_GROUP_DESCRIBE);
        this.data = data;
    }

    @Override
    public ConsumerGroupDescribeResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.groups().forEach(group -> this.updateErrorCounts(counts, Errors.forCode(group.errorCode())));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static ConsumerGroupDescribeResponse parse(ByteBuffer buffer, short version) {
        return new ConsumerGroupDescribeResponse(new ConsumerGroupDescribeResponseData(new ByteBufferAccessor(buffer), version));
    }
}

