if (CMAKE_VERSION VERSION_LESS 3.14.0)
    message(FATAL_ERROR "Drumstick requires at least CMake version 3.14.0")
endif()

if ( NOT (QT_VERSION_MAJOR EQUAL 6) )
    message(FATAL_ERROR "Drumstick was built with Qt6, please do not mix Qt${QT_VERSION_MAJOR} when building your program.")
endif()

foreach(component ${${CMAKE_FIND_PACKAGE_NAME}_FIND_COMPONENTS})
    string(TOLOWER ${component} locomp)
    include(${CMAKE_CURRENT_LIST_DIR}/drumstick-${locomp}-config.cmake)
endforeach()
