/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11.awt;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ToolkitLock;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import jogamp.nativewindow.jawt.x11.X11SunJDKReflection;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public class X11AWTGraphicsConfigurationFactory
extends GraphicsConfigurationFactory {
    public static void registerFactory() {
        GraphicsConfigurationFactory.registerFactory(AWTGraphicsDevice.class, CapabilitiesImmutable.class, new X11AWTGraphicsConfigurationFactory());
    }

    private X11AWTGraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        if (abstractGraphicsScreen != null && !(abstractGraphicsScreen instanceof AWTGraphicsScreen)) {
            throw new IllegalArgumentException("This GraphicsConfigurationFactory accepts only AWTGraphicsScreen objects");
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = AWTGraphicsScreen.createDefault();
        }
        return X11AWTGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, (AWTGraphicsScreen)abstractGraphicsScreen, n);
    }

    public static AWTGraphicsConfiguration chooseGraphicsConfigurationStatic(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AWTGraphicsScreen aWTGraphicsScreen, int n) {
        GraphicsConfiguration graphicsConfiguration;
        GraphicsConfigurationFactory graphicsConfigurationFactory;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration;
        Object object;
        boolean bl;
        long l;
        GraphicsDevice graphicsDevice;
        long l2;
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: got " + aWTGraphicsScreen);
        }
        if (0L == (l2 = X11SunJDKReflection.graphicsDeviceGetDisplay(graphicsDevice = ((AWTGraphicsDevice)aWTGraphicsScreen.getDevice()).getGraphicsDevice()))) {
            l = X11Util.openDisplay(null);
            bl = true;
            if (DEBUG) {
                System.err.println(X11AWTGraphicsConfigurationFactory.getThreadName() + " - X11AWTGraphicsConfigurationFactory: Null AWT dpy, create local X11 display: " + X11AWTGraphicsConfigurationFactory.toHexString(l));
            }
        } else {
            object = X11Lib.XDisplayString(l2);
            l = X11Util.openDisplay((String)object);
            bl = true;
            if (DEBUG) {
                System.err.println(X11AWTGraphicsConfigurationFactory.getThreadName() + " - X11AWTGraphicsConfigurationFactory: AWT dpy " + (String)object + " / " + X11AWTGraphicsConfigurationFactory.toHexString(l2) + ", create X11 display " + X11AWTGraphicsConfigurationFactory.toHexString(l));
            }
        }
        object = NativeWindowFactory.getDefaultToolkitLock(".awt");
        X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(l, 0, (ToolkitLock)object, bl);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(x11GraphicsDevice, aWTGraphicsScreen.getIndex());
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: made " + x11GraphicsScreen);
        }
        if ((abstractGraphicsConfiguration = (graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(x11GraphicsDevice, capabilitiesImmutable)).chooseGraphicsConfiguration(capabilitiesImmutable, capabilitiesImmutable2, capabilitiesChooser, x11GraphicsScreen, n)) == null) {
            throw new NativeWindowException("Unable to choose a GraphicsConfiguration (1): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        if (DEBUG) {
            System.err.println("X11AWTGraphicsConfigurationFactory: chosen config: " + abstractGraphicsConfiguration);
        }
        GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
        int n2 = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 != n2) {
            for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                GraphicsConfiguration graphicsConfiguration2 = graphicsConfigurationArray[i];
                if (graphicsConfiguration2 == null || X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration2) != n2) continue;
                if (DEBUG) {
                    System.err.println("Found matching AWT visual: 0x" + Integer.toHexString(n2) + " -> " + abstractGraphicsConfiguration);
                }
                return new AWTGraphicsConfiguration(aWTGraphicsScreen, abstractGraphicsConfiguration.getChosenCapabilities(), abstractGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration2, abstractGraphicsConfiguration);
            }
        }
        if ((abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilitiesImmutable = AWTGraphicsConfiguration.setupCapabilitiesRGBABits(capabilitiesImmutable, graphicsConfiguration = graphicsDevice.getDefaultConfiguration()), capabilitiesImmutable2, capabilitiesChooser, x11GraphicsScreen, n)) == null) {
            throw new NativeWindowException("Unable to choose a GraphicsConfiguration (2): " + capabilitiesImmutable + ",\n\t" + capabilitiesChooser + "\n\t" + x11GraphicsScreen);
        }
        n2 = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 != n2) {
            for (int i = 0; i < graphicsConfigurationArray.length; ++i) {
                graphicsConfiguration = graphicsConfigurationArray[i];
                if (X11SunJDKReflection.graphicsConfigurationGetVisualID(graphicsConfiguration) != n2) continue;
                if (DEBUG) {
                    System.err.println("Found matching default AWT visual: 0x" + Integer.toHexString(n2) + " -> " + abstractGraphicsConfiguration);
                }
                return new AWTGraphicsConfiguration(aWTGraphicsScreen, abstractGraphicsConfiguration.getChosenCapabilities(), abstractGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, abstractGraphicsConfiguration);
            }
        }
        if (DEBUG) {
            System.err.println("Using default configuration");
        }
        graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, abstractGraphicsConfiguration.getChosenCapabilities(), abstractGraphicsConfiguration.getRequestedCapabilities(), graphicsConfiguration, abstractGraphicsConfiguration);
    }
}

