/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ProfiledRGBColor;
import io.sf.carte.doc.style.css.property.XYZColorImpl;

class ColorSpaceHelper {
    ColorSpaceHelper() {
    }

    static BaseColor.Space rgbSpaceEnum(String internedLcColorSpace) {
        BaseColor.Space space = internedLcColorSpace == "srgb" ? BaseColor.Space.sRGB : (internedLcColorSpace == "a98-rgb" ? BaseColor.Space.A98_RGB : (internedLcColorSpace == "display-p3" ? BaseColor.Space.p3 : (internedLcColorSpace == "prophoto-rgb" ? BaseColor.Space.ProPhoto_RGB : (internedLcColorSpace == "rec2020" ? BaseColor.Space.Rec2020 : (internedLcColorSpace == "srgb-linear" ? BaseColor.Space.Linear_sRGB : BaseColor.Space.OTHER)))));
        return space;
    }

    static BaseColor createProfiledColor(String colorSpace) {
        BaseColor color;
        if ("srgb".equalsIgnoreCase(colorSpace)) {
            colorSpace = "srgb";
            color = new ProfiledRGBColor(colorSpace);
        } else if ("display-p3".equalsIgnoreCase(colorSpace)) {
            colorSpace = "display-p3";
            color = new ProfiledRGBColor(colorSpace);
        } else if ("a98-rgb".equalsIgnoreCase(colorSpace)) {
            colorSpace = "a98-rgb";
            color = new ProfiledRGBColor(colorSpace);
        } else if ("prophoto-rgb".equalsIgnoreCase(colorSpace)) {
            colorSpace = "prophoto-rgb";
            color = new ProfiledRGBColor(colorSpace);
        } else if ("rec2020".equalsIgnoreCase(colorSpace)) {
            colorSpace = "rec2020";
            color = new ProfiledRGBColor(colorSpace);
        } else if ("srgb-linear".equalsIgnoreCase(colorSpace)) {
            colorSpace = "srgb-linear";
            color = new ProfiledRGBColor(colorSpace);
        } else {
            color = "xyz".equalsIgnoreCase(colorSpace) || "xyz-d65".equalsIgnoreCase(colorSpace) ? new XYZColorImpl(Illuminant.D65) : ("xyz-d50".equalsIgnoreCase(colorSpace) ? new XYZColorImpl(Illuminant.D50) : null);
        }
        return color;
    }

    static HueInterpolationMethod parseInterpolationMethod(String s) {
        HueInterpolationMethod method = "shorter".equalsIgnoreCase(s) ? HueInterpolationMethod.SHORTER : ("longer".equalsIgnoreCase(s) ? HueInterpolationMethod.LONGER : ("increasing".equalsIgnoreCase(s) ? HueInterpolationMethod.INCREASING : ("decreasing".equalsIgnoreCase(s) ? HueInterpolationMethod.DECREASING : HueInterpolationMethod.UNKNOWN)));
        return method;
    }

    static enum HueInterpolationMethod {
        SHORTER,
        LONGER,
        INCREASING,
        DECREASING,
        UNKNOWN;

    }
}

