/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.util.Msg;
import java.util.HashMap;
import java.util.Map;

public enum C13ChecksumType {
    UnknownChecksumType(-1),
    NoneChecksumType(0),
    Md5ChecksumType(1),
    Sha1ChecksumType(2),
    Sha256ChecksumType(3);

    private static final Map<Integer, C13ChecksumType> BY_VALUE;
    private final int value;

    public static C13ChecksumType fromValue(int val) {
        C13ChecksumType t = BY_VALUE.getOrDefault(val, UnknownChecksumType);
        if (t == UnknownChecksumType && val != C13ChecksumType.UnknownChecksumType.value) {
            Msg.warn(null, (Object)String.format("PDB: C13FileChecksum - Unknown checksum type %08x", val));
        }
        return t;
    }

    private C13ChecksumType(int value) {
        this.value = value;
    }

    static {
        BY_VALUE = new HashMap<Integer, C13ChecksumType>();
        for (C13ChecksumType val : C13ChecksumType.values()) {
            BY_VALUE.put(val.value, val);
        }
    }
}

