/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.parallel;

import generic.cache.BasicFactory;
import generic.cache.CachingPool;
import generic.cache.CountingBasicFactory;
import generic.concurrent.QCallback;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.parallel.DecompileConfigurer;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public abstract class DecompilerCallback<R>
implements QCallback<Function, R> {
    private CachingPool<DecompInterface> pool;
    private int timeout = 60;

    public DecompilerCallback(Program program, DecompileConfigurer configurer) {
        this.pool = new CachingPool((BasicFactory)new DecompilerFactory(program, configurer));
    }

    public abstract R process(DecompileResults var1, TaskMonitor var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R process(Function f, TaskMonitor monitor) throws Exception {
        DecompileResults decompileResults;
        if (monitor.isCancelled()) {
            return null;
        }
        DecompInterface decompiler = null;
        try {
            decompiler = (DecompInterface)this.pool.get();
            monitor.setMessage("Decompiling " + f.getName());
            decompileResults = decompiler.decompileFunction(f, this.timeout, monitor);
        }
        finally {
            if (decompiler != null) {
                this.pool.release((Object)decompiler);
            }
        }
        R r = this.process(decompileResults, monitor);
        return r;
    }

    public void setTimeout(int timeoutSecs) {
        this.timeout = timeoutSecs;
    }

    public void dispose() {
        this.pool.dispose();
    }

    private static class DecompilerFactory
    extends CountingBasicFactory<DecompInterface> {
        private Program program;
        private DecompileConfigurer configurer;

        DecompilerFactory(Program program, DecompileConfigurer configurer) {
            this.program = program;
            this.configurer = configurer;
        }

        public DecompInterface doCreate(int itemNumber) throws IOException {
            DecompInterface decompiler = new DecompInterface();
            this.configurer.configure(decompiler);
            decompiler.openProgram(this.program);
            return decompiler;
        }

        public void doDispose(DecompInterface decompiler) {
            decompiler.dispose();
        }
    }
}

